/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.utils.collections;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImmutableMap<K, V>
extends AbstractMap<K, V> {
    final Map.Entry<K, V>[] entries;

    public static <K, V> ImmutableMap<K, V> newInstance(Map.Entry<K, V> ... entries) {
        return new ImmutableMap<K, V>(entries);
    }

    public static <K, V> ImmutableMap<K, V> newInstance(Map<K, V> entries) {
        if (entries instanceof ImmutableMap) {
            return (ImmutableMap)entries;
        }
        return new ImmutableMap<K, V>(entries);
    }

    protected ImmutableMap(Map.Entry<K, V>[] entries) {
        this.entries = (Map.Entry[])entries.clone();
    }

    protected ImmutableMap(Map<K, V> map) {
        this.entries = map.entrySet().toArray(new Map.Entry[map.size()]);
    }

    @Override
    public V get(Object key) {
        if (key == null) {
            for (int i = 0; i < this.entries.length; ++i) {
                if (this.entries[i].getKey() != null) continue;
                return this.entries[i].getValue();
            }
        } else {
            for (int i = 0; i < this.entries.length; ++i) {
                if (!key.equals(this.entries[i].getKey())) continue;
                return this.entries[i].getValue();
            }
        }
        return null;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new EntrySet();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntryItr
    implements Iterator<Map.Entry<K, V>> {
        int cursor;

        private EntryItr(int cursor) {
            this.cursor = cursor;
        }

        @Override
        public boolean hasNext() {
            return this.cursor != ImmutableMap.this.size();
        }

        @Override
        public Map.Entry<K, V> next() {
            return ImmutableMap.this.entries[this.cursor++];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryItr(0);
        }

        @Override
        public int size() {
            return ImmutableMap.this.entries.length;
        }
    }
}

