/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.rest.utils;

import io.fabric8.cxf.endpoint.ManagedApi;
import io.fabric8.rest.utils.RestCorsFilter;
import io.fabric8.utils.Function;
import io.fabric8.utils.Strings;
import io.fabric8.utils.Systems;
import java.util.EnumSet;
import java.util.EventListener;
import javax.servlet.DispatcherType;
import javax.servlet.Servlet;
import org.apache.cxf.cdi.CXFCdiServlet;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.jboss.weld.environment.servlet.BeanManagerResourceBindingListener;
import org.jboss.weld.environment.servlet.Listener;

public class Servers {
    protected static final String DEFAULT_PORT = "8588";

    public static Server startServer(String appName) throws Exception {
        return Servers.startServer(appName, null, DEFAULT_PORT);
    }

    public static Server startServer(String appName, Function<ServletContextHandler, Void> contextCallback) throws Exception {
        return Servers.startServer(appName, contextCallback, DEFAULT_PORT);
    }

    public static Server startServer(String appName, String defaultPort) throws Exception {
        return Servers.startServer(appName, null, defaultPort);
    }

    public static Server startServer(String appName, Function<ServletContextHandler, Void> contextCallback, String defaultPort) throws Exception {
        String port = Systems.getEnvVarOrSystemProperty((String)"HTTP_PORT", (String)"HTTP_PORT", (String)defaultPort);
        Integer num = Integer.parseInt(port);
        String service = Systems.getEnvVarOrSystemProperty((String)"WEB_CONTEXT_PATH", (String)"WEB_CONTEXT_PATH", (String)"");
        String servicesPath = "cxf/servicesList";
        String servletContextPath = "/" + service;
        ManagedApi.setSingletonCxfServletContext((String)servletContextPath);
        String url = "http://localhost:" + port + servletContextPath;
        if (!url.endsWith("/")) {
            url = url + "/";
        }
        System.out.println();
        System.out.println("-------------------------------------------------------------");
        System.out.println(appName + " is now running at: " + url);
        System.out.println("-------------------------------------------------------------");
        System.out.println();
        Server server = new Server(num.intValue());
        ServletHolder servletHolder = new ServletHolder((Servlet)new CXFCdiServlet());
        servletHolder.setInitParameter("service-list-path", "/" + servicesPath);
        ServletContextHandler context = new ServletContextHandler();
        context.setContextPath("/");
        context.addEventListener((EventListener)new Listener());
        context.addEventListener((EventListener)new BeanManagerResourceBindingListener());
        String servletPath = "/*";
        if (Strings.isNotBlank((String)service)) {
            servletPath = servletContextPath + "/*";
        }
        context.addServlet(servletHolder, servletPath);
        server.setHandler((Handler)context);
        EnumSet<DispatcherType> dispatches = EnumSet.allOf(DispatcherType.class);
        context.addFilter(RestCorsFilter.class, "/*", dispatches);
        if (contextCallback != null) {
            contextCallback.apply((Object)context);
        }
        server.start();
        return server;
    }
}

