/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.process.test;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.fabric8.process.test.MockRestServiceDirectory;
import io.fabric8.process.test.SystemPropertiesMockRestServiceDirectory;
import java.util.HashMap;
import java.util.Map;
import org.mockserver.client.server.MockServerClient;
import org.mockserver.integration.ClientAndServer;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.mockserver.socket.PortFactory;

public class MockedRestServices {
    private Map<String, ClientAndServer> mockServers = new HashMap<String, ClientAndServer>();
    private final MockRestServiceDirectory[] mockRestServiceDirectories;
    private final ObjectMapper jackson = new ObjectMapper();

    public MockedRestServices(MockRestServiceDirectory ... mockRestServiceDirectories) {
        this.mockRestServiceDirectories = mockRestServiceDirectories;
    }

    public MockedRestServices() {
        this(new SystemPropertiesMockRestServiceDirectory());
    }

    public void stop() {
        for (ClientAndServer server : this.mockServers.values()) {
            server.stop();
        }
    }

    public Configure symbol(String serviceSymbol) {
        ClientAndServer server = this.mockServers.get(serviceSymbol);
        if (server == null) {
            int port = PortFactory.findFreePort();
            server = new ClientAndServer(Integer.valueOf(port));
            this.mockServers.put(serviceSymbol, server);
            for (MockRestServiceDirectory directory : this.mockRestServiceDirectories) {
                directory.publish(serviceSymbol, "http://localhost:" + port);
            }
        }
        return new Configure((MockServerClient)server);
    }

    class Configure {
        private final MockServerClient server;

        Configure(MockServerClient server) {
            this.server = server;
        }

        public MockServerClient configure() {
            return this.server;
        }

        public Configure json(Object pojo) {
            try {
                this.server.when(HttpRequest.request()).respond(HttpResponse.response().withBody(MockedRestServices.this.jackson.writeValueAsString(pojo)));
                return this;
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        }

        public Configure json(String pathFragment, Object pojo) {
            try {
                this.server.when(HttpRequest.request().withPath(".*?" + pathFragment + ".*")).respond(HttpResponse.response().withBody(MockedRestServices.this.jackson.writeValueAsString(pojo)));
                return this;
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

