/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.process.test;

import com.jayway.awaitility.Awaitility;
import io.fabric8.process.manager.ProcessController;
import io.fabric8.process.manager.service.ProcessManagerService;
import java.io.File;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.client.RestTemplate;

public abstract class AbstractProcessTest
extends Assert {
    protected static ProcessManagerService processManagerService;
    protected static final RestTemplate restTemplate;

    @BeforeClass
    public static void baseSetup() throws Exception {
        System.setProperty("java.protocol.handler.pkgs", "org.ops4j.pax.url");
        processManagerService = new ProcessManagerService(new File("target", UUID.randomUUID().toString()));
        processManagerService.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static int startProcess(ProcessController processController) throws Exception {
        try {
            int n = processController.start();
            Runtime.getRuntime().addShutdownHook(new Thread(processController){
                final /* synthetic */ ProcessController val$processController;
                {
                    this.val$processController = processController;
                }

                @Override
                public void run() {
                    AbstractProcessTest.stopProcess(this.val$processController);
                }
            });
            return n;
        }
        catch (Throwable throwable) {
            Runtime.getRuntime().addShutdownHook(new /* invalid duplicate definition of identical inner class */);
            throw throwable;
        }
    }

    protected static int stopProcess(ProcessController processController) {
        try {
            if (processController != null) {
                return processController.stop();
            }
            System.out.println("Process controller has not been initialized - skipping stop command.");
            return -1;
        }
        catch (Exception e) {
            System.out.println("Problem occurred while stopping the process " + processController);
            e.printStackTrace();
            return -1;
        }
    }

    protected static void waitForRestResource(final String uri) {
        Awaitility.waitAtMost((long)1L, (TimeUnit)TimeUnit.MINUTES).until((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                try {
                    restTemplate.getForObject(uri, String.class, new Object[0]);
                }
                catch (ResourceAccessException e) {
                    System.out.println(e.getMessage());
                    return false;
                }
                return true;
            }
        });
    }

    static {
        restTemplate = new RestTemplate();
    }
}

