/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.process.spring.boot.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Resources
implements Serializable {
    private final Link[] links;
    private final String[] content;
    private final Page page;

    @JsonCreator
    public Resources(@JsonProperty(value="links") Link[] links, @JsonProperty(value="content") String[] content, @JsonProperty(value="page") Page page) {
        this.links = links;
        this.content = content;
        this.page = page;
    }

    public List<Link> links() {
        return ImmutableList.copyOf((Iterable)Iterables.filter(Arrays.asList(this.links), (Predicate)new Predicate<Link>(){

            public boolean apply(Link input) {
                return !input.rel().equals("self");
            }
        }));
    }

    public String[] getContent() {
        return this.content;
    }

    public Page getPage() {
        return this.page;
    }

    public static class Page {
        private long size;
        private long totalElements;
        private long totalPages;
        private long number;

        public long getSize() {
            return this.size;
        }

        public void setSize(long size) {
            this.size = size;
        }

        public long getTotalElements() {
            return this.totalElements;
        }

        public void setTotalElements(long totalElements) {
            this.totalElements = totalElements;
        }

        public long getTotalPages() {
            return this.totalPages;
        }

        public void setTotalPages(long totalPages) {
            this.totalPages = totalPages;
        }

        public long getNumber() {
            return this.number;
        }

        public void setNumber(long number) {
            this.number = number;
        }
    }

    public static class Link {
        private final String rel;
        private final String href;

        @JsonCreator
        public Link(@JsonProperty(value="rel") String rel, @JsonProperty(value="href") String href) {
            this.rel = rel;
            this.href = href;
        }

        public String rel() {
            return this.rel;
        }

        public String href() {
            return this.href;
        }
    }
}

