/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.process.spring.boot.data;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.io.Serializable;
import java.util.Arrays;
import lombok.NonNull;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Sort;

@JsonIgnoreProperties(ignoreUnknown=true)
public abstract class AbstractQuery
implements Serializable {
    @NonNull
    private int page = 0;
    @NonNull
    private int size = 25;
    @NonNull
    private Sort.Direction sortDirection = Sort.Direction.ASC;
    @NonNull
    private String[] orderBy = new String[]{"id"};

    public PageRequest pageRequest() {
        return new PageRequest(this.page, this.size, this.sortDirection, this.orderBy);
    }

    @NonNull
    public int getPage() {
        return this.page;
    }

    @NonNull
    public int getSize() {
        return this.size;
    }

    @NonNull
    public Sort.Direction getSortDirection() {
        return this.sortDirection;
    }

    @NonNull
    public String[] getOrderBy() {
        return this.orderBy;
    }

    public void setPage(@NonNull int page) {
        this.page = page;
    }

    public void setSize(@NonNull int size) {
        this.size = size;
    }

    public void setSortDirection(@NonNull Sort.Direction sortDirection) {
        if (sortDirection == null) {
            throw new NullPointerException("sortDirection");
        }
        this.sortDirection = sortDirection;
    }

    public void setOrderBy(@NonNull String[] orderBy) {
        if (orderBy == null) {
            throw new NullPointerException("orderBy");
        }
        this.orderBy = orderBy;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractQuery)) {
            return false;
        }
        AbstractQuery other = (AbstractQuery)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPage() != other.getPage()) {
            return false;
        }
        if (this.getSize() != other.getSize()) {
            return false;
        }
        Sort.Direction this$sortDirection = this.getSortDirection();
        Sort.Direction other$sortDirection = other.getSortDirection();
        if (this$sortDirection == null ? other$sortDirection != null : !this$sortDirection.equals(other$sortDirection)) {
            return false;
        }
        return Arrays.deepEquals(this.getOrderBy(), other.getOrderBy());
    }

    protected boolean canEqual(Object other) {
        return other instanceof AbstractQuery;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPage();
        result = result * 59 + this.getSize();
        Sort.Direction $sortDirection = this.getSortDirection();
        result = result * 59 + ($sortDirection == null ? 0 : $sortDirection.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getOrderBy());
        return result;
    }

    public String toString() {
        return "AbstractQuery(page=" + this.getPage() + ", size=" + this.getSize() + ", sortDirection=" + this.getSortDirection() + ", orderBy=" + Arrays.deepToString(this.getOrderBy()) + ")";
    }
}

