/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.process.manager.support;

import com.google.common.base.Predicate;
import com.google.common.collect.Maps;
import io.fabric8.api.Profile;
import io.fabric8.common.util.Closeables;
import io.fabric8.process.manager.support.ByteToStringValues;
import io.fabric8.process.manager.support.LayOutPredicate;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessUtils {
    private static final transient Logger LOGGER = LoggerFactory.getLogger(ProcessUtils.class);

    public static File findInstallDir(File rootDir) {
        if (ProcessUtils.installExists(rootDir)) {
            return rootDir;
        }
        File[] files = rootDir.listFiles();
        if (files != null) {
            for (File file : files) {
                if (!ProcessUtils.installExists(file)) continue;
                return file;
            }
        }
        return rootDir;
    }

    public static boolean installExists(File file) {
        if (file.isDirectory()) {
            File binDir = new File(file, "bin");
            return binDir.exists() && binDir.isDirectory();
        }
        return false;
    }

    public static boolean isProcessAlive(long pid) {
        List<Long> processIds = ProcessUtils.getProcessIds();
        if (processIds.isEmpty()) {
            return true;
        }
        return processIds.contains(pid);
    }

    public static List<Long> getProcessIds() {
        String commands = "ps -e";
        Process process = null;
        Runtime runtime = Runtime.getRuntime();
        String message = commands;
        LOGGER.debug("Executing commands: " + message);
        ArrayList<Long> answer = new ArrayList<Long>();
        try {
            process = runtime.exec(commands);
            ProcessUtils.parseProcesses(process.getInputStream(), answer, message);
            ProcessUtils.processErrors(process.getErrorStream(), message);
        }
        catch (Exception e) {
            LOGGER.error("Failed to execute process stdin for " + message + ": " + e, (Throwable)e);
        }
        return answer;
    }

    public static int killProcess(Long pid, String params) {
        if (pid == null || !ProcessUtils.isProcessAlive(pid)) {
            return 0;
        }
        String commands = "kill " + (params != null ? params + " " : "") + pid;
        Process process = null;
        Runtime runtime = Runtime.getRuntime();
        LOGGER.debug("Executing commands: " + commands);
        try {
            process = runtime.exec(commands);
            ProcessUtils.processInput(process.getInputStream(), commands);
            ProcessUtils.processErrors(process.getErrorStream(), commands);
        }
        catch (Exception e) {
            LOGGER.error("Failed to execute process stdin for " + commands + ": " + e, (Throwable)e);
        }
        try {
            return process != null ? process.waitFor() : 1;
        }
        catch (InterruptedException e) {
            String message = String.format("Interrupted while waiting for 'kill %d ' command to finish", pid);
            throw new RuntimeException(message, e);
        }
    }

    protected static void parseProcesses(InputStream inputStream, List<Long> answer, String message) throws Exception {
        block10: {
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
            block7: while (true) {
                try {
                    while (true) {
                        String line;
                        if ((line = reader.readLine()) == null) {
                            break block10;
                        }
                        StringTokenizer tokenizer = new StringTokenizer(line);
                        if (!tokenizer.hasMoreTokens()) continue;
                        String pidText = tokenizer.nextToken();
                        try {
                            long pid = Long.parseLong(pidText);
                            answer.add(pid);
                            continue block7;
                        }
                        catch (NumberFormatException e) {
                            LOGGER.debug("Could not parse pid " + pidText + " from command: " + message);
                            continue;
                        }
                        break;
                    }
                }
                catch (Exception e) {
                    LOGGER.debug("Failed to process stdin for " + message + ": " + e, (Throwable)e);
                    throw e;
                }
            }
            finally {
                Closeables.closeQuitely((Closeable)reader);
            }
        }
    }

    protected static void processInput(InputStream inputStream, String message) throws Exception {
        ProcessUtils.readProcessOutput(inputStream, "stdout for ", message);
    }

    protected static void processErrors(InputStream inputStream, String message) throws Exception {
        ProcessUtils.readProcessOutput(inputStream, "stderr for ", message);
    }

    protected static void readProcessOutput(InputStream inputStream, String prefix, String message) throws Exception {
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                LOGGER.debug("Error " + prefix + message + ": " + line);
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to process " + prefix + message + ": " + e, (Throwable)e);
            throw e;
        }
        finally {
            Closeables.closeQuitely((Closeable)reader);
        }
    }

    public static Map<String, String> getProcessLayout(List<Profile> profiles, String layoutPath) {
        HashMap<String, String> answer = new HashMap<String, String>();
        for (Profile profile : profiles) {
            Map<String, String> map = ProcessUtils.getProcessLayout(profile, layoutPath);
            answer.putAll(map);
        }
        return answer;
    }

    public static Map<String, String> getProcessLayout(Profile profile, String layoutPath) {
        return ByteToStringValues.INSTANCE.apply(Maps.filterKeys((Map)profile.getOverlay().getFileConfigurations(), (Predicate)new LayOutPredicate(layoutPath)));
    }
}

