/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.process.manager.support;

import com.google.common.base.Preconditions;
import io.fabric8.process.manager.support.command.Command;
import io.fabric8.process.manager.support.command.CommandFailedException;
import io.fabric8.process.manager.support.command.Duration;
import java.io.File;
import java.util.Arrays;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtils {
    private static final transient Logger LOG = LoggerFactory.getLogger(FileUtils.class);

    public static void extractArchive(File archiveFile, File targetDirectory, String extractCommand, Duration timeLimit, Executor executor) throws CommandFailedException {
        Preconditions.checkNotNull((Object)archiveFile, (Object)"archiveFile is null");
        Preconditions.checkNotNull((Object)targetDirectory, (Object)"targetDirectory is null");
        Preconditions.checkArgument((boolean)targetDirectory.isDirectory(), (Object)("targetDirectory is not a directory: " + targetDirectory.getAbsolutePath()));
        String[] commands = FileUtils.splitCommands(extractCommand);
        String[] args = Arrays.copyOf(commands, commands.length + 1);
        args[args.length - 1] = archiveFile.getAbsolutePath();
        LOG.info("Extracting archive with commands: " + Arrays.asList(args));
        new Command(args).setDirectory(targetDirectory).setTimeLimit(timeLimit).execute(executor);
    }

    public static String[] splitCommands(String extractCommand) {
        return extractCommand.split(" ");
    }
}

