/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.process.manager.commands;

import io.fabric8.api.scr.ValidatingReference;
import io.fabric8.boot.commands.support.AbstractCommandComponent;
import io.fabric8.process.manager.ProcessManager;
import io.fabric8.process.manager.commands.UninstallAction;
import io.fabric8.process.manager.commands.support.ProcessNumberCompleter;
import org.apache.felix.gogo.commands.Action;
import org.apache.felix.gogo.commands.basic.AbstractCommand;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.felix.service.command.Function;
import org.osgi.framework.BundleContext;

@Component(immediate=true)
@Service(value={Function.class, AbstractCommand.class})
@Properties(value={@Property(name="osgi.command.scope", value={"process"}), @Property(name="osgi.command.function", value={"uninstall"})})
public class Uninstall
extends AbstractCommandComponent {
    public static final String SCOPE_VALUE = "process";
    public static final String FUNCTION_VALUE = "uninstall";
    public static final String DESCRIPTION = "Uninstalls a managed process from this container.";
    @Reference(referenceInterface=ProcessManager.class)
    private final ValidatingReference<ProcessManager> processManager = new ValidatingReference();
    @Reference(referenceInterface=ProcessNumberCompleter.class, bind="bindProcessNumberCompleter", unbind="unbindProcessNumberCompleter")
    private ProcessNumberCompleter processNumberCompleter;
    private BundleContext bundleContext;

    @Activate
    void activate(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.activateComponent();
    }

    @Deactivate
    void deactivate() {
        this.deactivateComponent();
    }

    public Action createNewAction() {
        this.assertValid();
        return new UninstallAction((ProcessManager)this.processManager.get());
    }

    void bindProcessManager(ProcessManager processManager) {
        this.processManager.bind((Object)processManager);
    }

    void unbindProcessManager(ProcessManager processManager) {
        this.processManager.unbind((Object)processManager);
    }

    void bindProcessNumberCompleter(ProcessNumberCompleter completer) {
        this.bindCompleter(completer);
    }

    void unbindProcessNumberCompleter(ProcessNumberCompleter completer) {
        this.unbindCompleter(completer);
    }
}

