/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.process.manager.support;

import io.fabric8.common.util.Files;
import io.fabric8.process.manager.InstallTask;
import io.fabric8.process.manager.config.ProcessConfig;
import io.fabric8.process.manager.support.ProcessUtils;
import java.io.File;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstallDeploymentsTask
implements InstallTask {
    private static final transient Logger LOG = LoggerFactory.getLogger(InstallDeploymentsTask.class);
    private final Map<String, File> javaArtifacts;

    public InstallDeploymentsTask(Map<String, File> javaArtifacts) {
        this.javaArtifacts = javaArtifacts;
    }

    @Override
    public void install(ProcessConfig config, String id, File installDir) throws Exception {
        File baseDir = ProcessUtils.findInstallDir(installDir);
        String sharedLibraryPath = config.getSharedLibraryPath();
        String deployPath = config.getDeployPath();
        File sharedLibDir = new File(baseDir, sharedLibraryPath);
        File deployDir = new File(baseDir, deployPath);
        sharedLibDir.mkdirs();
        deployDir.mkdirs();
        TreeSet<String> sharedLibraries = new TreeSet<String>();
        TreeSet<String> deployments = new TreeSet<String>();
        Set<Map.Entry<String, File>> entries = this.javaArtifacts.entrySet();
        for (Map.Entry<String, File> entry : entries) {
            File destDir;
            String uri = entry.getKey();
            File file = entry.getValue();
            String fileName = file.getName();
            if (fileName.endsWith(".jar")) {
                destDir = sharedLibDir;
                sharedLibraries.add(fileName);
            } else {
                destDir = deployDir;
                deployments.add(fileName);
            }
            File destFile = new File(destDir, fileName);
            Files.copy((File)file, (File)destFile);
        }
        LOG.info("Deployed " + deployments.size() + " deployment(s)");
        for (String deployment : deployments) {
            LOG.info("   deployed: " + deployment);
        }
        LOG.info("Installed " + sharedLibraries.size() + " shared jar(s)");
        for (String sharedLib : sharedLibraries) {
            LOG.info("   jar: " + sharedLib);
        }
    }
}

