/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.process.manager.service;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import com.google.common.io.InputSupplier;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.fabric8.common.util.Strings;
import io.fabric8.process.manager.InstallOptions;
import io.fabric8.process.manager.InstallTask;
import io.fabric8.process.manager.Installation;
import io.fabric8.process.manager.ProcessController;
import io.fabric8.process.manager.config.JsonHelper;
import io.fabric8.process.manager.config.ProcessConfig;
import io.fabric8.process.manager.service.ProcessManagerServiceMBean;
import io.fabric8.process.manager.support.DefaultProcessController;
import io.fabric8.process.manager.support.FileUtils;
import io.fabric8.process.manager.support.JarInstaller;
import io.fabric8.process.manager.support.ProcessUtils;
import io.fabric8.process.manager.support.command.CommandFailedException;
import io.fabric8.process.manager.support.command.Duration;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessManagerService
implements ProcessManagerServiceMBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessManagerService.class);
    private static final String INSTALLED_BINARY = "install.bin";
    private Executor executor = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("fabric-process-manager-%s").build());
    private File storageLocation;
    private int lastId = 0;
    private final Duration untarTimeout = Duration.valueOf("1h");
    private SortedMap<String, Installation> installations = Maps.newTreeMap();
    private final ObjectName objectName;
    private MBeanServer mbeanServer;

    public ProcessManagerService() throws MalformedObjectNameException {
        this(new File(System.getProperty("karaf.processes", System.getProperty("karaf.base") + File.separatorChar + "processes")));
    }

    public ProcessManagerService(File storageLocation) throws MalformedObjectNameException {
        this.storageLocation = storageLocation;
        this.objectName = new ObjectName("io.fabric8:type=LocalProcesses");
    }

    public void bindMBeanServer(MBeanServer mbeanServer) {
        this.unbindMBeanServer(this.mbeanServer);
        this.mbeanServer = mbeanServer;
        if (mbeanServer != null) {
            this.registerMBeanServer(mbeanServer);
        }
    }

    public void unbindMBeanServer(MBeanServer mbeanServer) {
        if (mbeanServer != null) {
            this.unregisterMBeanServer(mbeanServer);
            this.mbeanServer = null;
        }
    }

    public void registerMBeanServer(MBeanServer mbeanServer) {
        try {
            if (!mbeanServer.isRegistered(this.objectName)) {
                mbeanServer.registerMBean(this, this.objectName);
            }
        }
        catch (Exception e) {
            LOGGER.warn("An error occurred during mbean server registration: " + e, (Throwable)e);
        }
    }

    public void unregisterMBeanServer(MBeanServer mbeanServer) {
        if (mbeanServer != null) {
            try {
                ObjectName name = this.objectName;
                if (mbeanServer.isRegistered(name)) {
                    mbeanServer.unregisterMBean(name);
                }
            }
            catch (Exception e) {
                LOGGER.warn("An error occurred during mbean server registration: " + e, (Throwable)e);
            }
        }
    }

    public void init() throws Exception {
        this.lastId = 0;
        File[] files = this.storageLocation.listFiles();
        if (files != null) {
            for (File file : files) {
                if (!file.isDirectory()) continue;
                String name = file.getName();
                if (name.matches("\\d+")) {
                    try {
                        int id;
                        Integer value = Integer.parseInt(name);
                        if (value != null && (id = value.intValue()) > this.lastId) {
                            this.lastId = id;
                        }
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                }
                ProcessConfig config = JsonHelper.loadProcessConfig(file);
                this.createInstallation(name, ProcessUtils.findInstallDir(file), config);
            }
        }
    }

    public String toString() {
        return "ProcessManager(" + this.storageLocation + ")";
    }

    public ImmutableList<Installation> listInstallations() {
        return ImmutableList.copyOf(this.installations.values());
    }

    @Override
    public ImmutableMap<String, Installation> listInstallationMap() {
        return ImmutableMap.copyOf(this.installations);
    }

    @Override
    public Installation getInstallation(String id) {
        return (Installation)this.installations.get(id);
    }

    @Override
    public Installation install(final InstallOptions options, final InstallTask postInstall) throws Exception {
        InstallTask installTask = new InstallTask(){

            @Override
            public void install(ProcessConfig config, String id, File installDir) throws Exception {
                config.setName(options.getName());
                ProcessManagerService.this.downloadContent(options.getUrl(), installDir);
                if (options.getExtractCmd() != null) {
                    File archive = new File(installDir, ProcessManagerService.INSTALLED_BINARY);
                    FileUtils.extractArchive(archive, installDir, options.getExtractCmd(), ProcessManagerService.this.untarTimeout, ProcessManagerService.this.executor);
                }
                if (postInstall != null) {
                    postInstall.install(config, id, installDir);
                }
            }
        };
        return this.installViaScript(options, installTask);
    }

    @Override
    public Installation installJar(final InstallOptions parameters) throws Exception {
        InstallTask installTask = new InstallTask(){

            @Override
            public void install(ProcessConfig config, String id, File installDir) throws Exception {
                config.setName(parameters.getName());
                String resourceName = "process-launcher.tar.gz";
                final InputStream in = this.getClass().getClassLoader().getResourceAsStream(resourceName);
                Preconditions.checkNotNull((Object)in, (Object)("Could not find " + resourceName + " on the file system"));
                File tmpFile = File.createTempFile("process-launcher", ".tar.gz");
                Files.copy((InputSupplier)new InputSupplier<InputStream>(){

                    public InputStream getInput() throws IOException {
                        return in;
                    }
                }, (File)tmpFile);
                FileUtils.extractArchive(tmpFile, installDir, "tar zxf", ProcessManagerService.this.untarTimeout, ProcessManagerService.this.executor);
                File etc = new File(installDir, "etc");
                if (etc.mkdirs()) {
                    LOGGER.debug("Creating etc directory {} of process {}.", (Object)etc, (Object)id);
                } else {
                    LOGGER.debug("Directory etc {} of process {} exists. Skipping.", (Object)etc, (Object)id);
                }
                Files.write((CharSequence)"", (File)new File(etc, "config.properties"), (Charset)Charsets.UTF_8);
                Files.write((CharSequence)ProcessManagerService.this.generateJvmConfig(parameters.getJvmOptions()), (File)new File(etc, "jvm.config"), (Charset)Charsets.UTF_8);
                JarInstaller installer = new JarInstaller(ProcessManagerService.this.executor);
                installer.unpackJarProcess(config, id, installDir, parameters);
            }
        };
        return this.installViaScript(parameters, installTask);
    }

    private String generateJvmConfig(String[] jvmOptions) {
        StringBuilder jvmConfig = new StringBuilder();
        if (jvmOptions != null) {
            for (String jvmOption : jvmOptions) {
                jvmConfig.append(jvmOption).append(" ");
            }
        }
        return jvmConfig.toString();
    }

    public File getStorageLocation() {
        return this.storageLocation;
    }

    public void setStorageLocation(File storageLocation) {
        this.storageLocation = storageLocation;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    protected Installation installViaScript(InstallOptions options, InstallTask installTask) throws Exception {
        String id = this.createNextId(options);
        File installDir = this.createInstallDir(id);
        installDir.mkdirs();
        ProcessConfig config = this.loadControllerJson(options);
        Map<String, String> configEnv = config.getEnvironment();
        Map<String, String> optionsEnv = options.getEnvironment();
        if (optionsEnv != null) {
            configEnv.putAll(optionsEnv);
        }
        installTask.install(config, id, installDir);
        JsonHelper.saveProcessConfig(config, installDir);
        Installation installation = this.createInstallation(id, installDir, config);
        installation.getController().install();
        return installation;
    }

    protected void downloadContent(final URL url, File installDir) throws IOException, CommandFailedException {
        File archive = new File(installDir, INSTALLED_BINARY);
        Files.copy((InputSupplier)new InputSupplier<InputStream>(){

            public InputStream getInput() throws IOException {
                return url.openStream();
            }
        }, (File)archive);
    }

    protected ProcessConfig loadControllerJson(InstallOptions options) throws IOException {
        String controllerJson = options.getControllerJson();
        URL controllerUrl = options.getControllerUrl();
        if (Strings.isNotBlank((String)controllerJson)) {
            return JsonHelper.loadProcessConfig(controllerJson);
        }
        if (controllerUrl != null) {
            return JsonHelper.loadProcessConfig(controllerUrl);
        }
        return new ProcessConfig();
    }

    protected synchronized String createNextId(InstallOptions options) {
        File dir;
        String id = options.getId();
        if (Strings.isNotBlank((String)id)) {
            return id;
        }
        String answer = null;
        do {
            ++this.lastId;
        } while ((dir = this.createInstallDir(answer = "" + this.lastId)).exists());
        return answer;
    }

    protected File createInstallDir(String id) {
        return new File(this.storageLocation, id);
    }

    protected Installation createInstallation(String id, File rootDir, ProcessConfig config) {
        File installDir = ProcessUtils.findInstallDir(rootDir);
        ProcessController controller = this.createController(id, config, rootDir, installDir);
        Installation installation = new Installation(id, installDir, controller, config);
        this.installations.put(id, installation);
        return installation;
    }

    protected ProcessController createController(String id, ProcessConfig config, File rootDir, File installDir) {
        return new DefaultProcessController(id, config, installDir);
    }
}

