/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.process.manager.config;

import io.fabric8.process.manager.config.ProcessConfig;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonHelper {
    private static final transient Logger LOG = LoggerFactory.getLogger(JsonHelper.class);
    private static ObjectMapper mapper = new ObjectMapper();

    public static ProcessConfig loadProcessConfig(URL url) throws IOException {
        return (ProcessConfig)mapper.readValue(url, ProcessConfig.class);
    }

    public static ProcessConfig loadProcessConfig(File installDir) throws IOException {
        File file = JsonHelper.createControllerConfigFile(installDir);
        if (!file.exists()) {
            LOG.warn("Process configuration file " + file.getPath() + " does not exist");
            return new ProcessConfig();
        }
        return (ProcessConfig)mapper.readValue(file, ProcessConfig.class);
    }

    public static void saveProcessConfig(ProcessConfig config, File installDir) throws IOException {
        mapper.writeValue(JsonHelper.createControllerConfigFile(installDir), (Object)config);
    }

    public static File createControllerConfigFile(File installDir) {
        return new File(installDir, "process-config.json");
    }

    static {
        mapper.getSerializationConfig().withSerializationInclusion(JsonSerialize.Inclusion.NON_EMPTY);
    }
}

