/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.process.manager.service;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.net.MalformedURLException;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.fusesource.process.manager.InstallOptions;
import org.fusesource.process.manager.InstallTask;
import org.fusesource.process.manager.Installation;
import org.fusesource.process.manager.ProcessController;
import org.fusesource.process.manager.ProcessManager;
import org.osgi.framework.BundleContext;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedServiceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessServiceFactory
implements ManagedServiceFactory {
    protected final Logger LOG = LoggerFactory.getLogger(this.getClass());
    private ProcessManager processManager;
    private Map<String, Installation> installationMap = new Hashtable<String, Installation>();
    private static final String PROCESS_SERVICE_FACTORY_PID = "org.fusesource.process";
    private BundleContext bundleContext;

    public String getName() {
        return "Fabric Process Server";
    }

    public final void deleted(String pid) {
        Installation installation = this.installationMap.remove(pid);
        if (installation != null) {
            try {
                if (installation.getController().status() == 0) {
                    installation.getController().stop();
                }
                this.LOG.info("Destroyed Process " + pid);
            }
            catch (Exception e) {
                this.LOG.error("Error destroying Process " + pid + " : " + e.getMessage(), (Throwable)e);
            }
        } else {
            this.LOG.error("Process " + pid + " not found");
        }
        this.LOG.info("Deleted " + pid);
    }

    public void updated(String pid, Dictionary incoming) throws ConfigurationException {
        try {
            HashMap<String, String> env = new HashMap<String, String>();
            InstallOptions options = this.getInstallOptions(incoming, env);
            Installation installation = this.installationMap.get(pid);
            if (null != installation) {
                this.LOG.info("Refreshing Process " + pid);
                this.updateConfig(pid, installation, env);
            } else {
                this.installationMap.put(pid, this.installProcess(pid, options, env));
                this.LOG.info("Started Process " + pid);
            }
        }
        catch (Exception ex) {
            Throwables.propagate((Throwable)ex);
        }
    }

    private InstallOptions getInstallOptions(Dictionary incoming, Map<String, String> env) throws ConfigurationException, MalformedURLException {
        InstallOptions.InstallOptionsBuilder builder = InstallOptions.builder();
        Enumeration keys = incoming.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String value = (String)incoming.get(key);
            try {
                if ("url".equals(key)) {
                    Preconditions.checkNotNull((Object)value, (Object)"Null url property");
                    Preconditions.checkArgument((!value.trim().isEmpty() ? 1 : 0) != 0, (Object)"Empty url property");
                    builder.url(value.trim());
                    continue;
                }
                if ("controllerUrl".equals(key)) {
                    Preconditions.checkNotNull((Object)value, (Object)"Null controllerUrl property");
                    Preconditions.checkArgument((!value.trim().isEmpty() ? 1 : 0) != 0, (Object)"Empty controllerUrl property");
                    builder.controllerUrl(value.trim());
                    continue;
                }
                if ("kind".equals(key)) {
                    Preconditions.checkNotNull((Object)value, (Object)"Null kind property");
                    Preconditions.checkArgument((!value.trim().isEmpty() ? 1 : 0) != 0, (Object)"Empty kind property");
                    String name = value.trim() + ".json";
                    builder.controllerUrl(this.bundleContext.getBundle().getResource(name));
                    continue;
                }
                env.put(key, (String)incoming.get(key));
            }
            catch (Exception e) {
                String msg = "Error getting install parameters: " + e.getMessage();
                this.LOG.error(msg, (Throwable)e);
                throw new ConfigurationException(key, msg);
            }
        }
        return builder.build();
    }

    private void updateConfig(String pid, Installation installation, Map<String, String> env) throws ConfigurationException {
        try {
            boolean running;
            ProcessController controller = installation.getController();
            boolean bl = running = controller.status() == 0;
            if (running) {
                controller.stop();
            }
            installation.getEnvironment().putAll(env);
            controller.configure();
            if (running) {
                controller.start();
            }
        }
        catch (Exception e) {
            String msg = "Error updating process " + pid + ": " + e.getMessage();
            this.LOG.error(msg, (Throwable)e);
            throw new ConfigurationException("Update", msg, (Throwable)e);
        }
    }

    private Installation installProcess(String pid, InstallOptions options, Map<String, String> env) throws ConfigurationException {
        try {
            InstallTask postInstall = null;
            Installation installation = this.processManager.install(options, postInstall);
            installation.getEnvironment().putAll(env);
            installation.getController().configure();
            installation.getController().start();
            return installation;
        }
        catch (Exception e) {
            String msg = "Error installing process " + pid + " : " + e.getMessage();
            this.LOG.error(msg);
            throw new ConfigurationException("Start", msg, (Throwable)e);
        }
    }

    public final void init() throws Exception {
        Preconditions.checkNotNull((Object)this.processManager, (Object)"processManager property");
        Preconditions.checkNotNull((Object)this.bundleContext, (Object)"bundleContext property");
        List<Installation> installations = this.processManager.listInstallations();
        for (Installation installation : installations) {
            Map<String, String> env = installation.getEnvironment();
            if (env == null) continue;
            String factoryPid = env.get("service.factoryPid");
            String servicePid = env.get("service.pid");
            if (servicePid == null || factoryPid == null || !PROCESS_SERVICE_FACTORY_PID.equals(factoryPid)) continue;
            this.installationMap.put(servicePid, installation);
        }
        this.LOG.info("Started");
    }

    public final void destroy() throws Exception {
        this.installationMap.clear();
        this.LOG.info("Destroyed");
    }

    public ProcessManager getProcessManager() {
        return this.processManager;
    }

    public void setProcessManager(ProcessManager processManager) {
        this.processManager = processManager;
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }
}

