/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.process.fabric.commands;

import com.google.common.base.Preconditions;
import io.fabric8.api.Container;
import io.fabric8.api.FabricAuthenticationException;
import io.fabric8.process.fabric.ContainerProcessManager;
import io.fabric8.utils.shell.ShellUtils;
import java.io.IOException;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Option;
import org.apache.karaf.shell.console.OsgiCommandSupport;

public abstract class ContainerProcessCommandSupport
extends OsgiCommandSupport {
    @Option(name="-c", aliases={"--controllerUrl"}, required=false, description="The optional JSON document URL containing the controller configuration")
    protected String controllerJson;
    @Option(name="-k", aliases={"--kind"}, required=false, description="The kind of controller to create")
    protected String controllerKind;
    @Option(name="-u", aliases={"--user"}, required=false, description="The jmx user of the target container")
    protected String user;
    @Option(name="-p", aliases={"--password"}, required=false, description="The jmx password of the target container")
    protected String password;
    @Argument(index=0, required=true, name="container", description="The container to manage the process")
    protected String container;
    private ContainerProcessManager containerProcessManager;

    abstract void doWithAuthentication(String var1, String var2) throws Exception;

    protected void checkRequirements() {
        Preconditions.checkNotNull((Object)this.containerProcessManager, (Object)"containerProcessManager");
    }

    protected Object doExecute() throws Exception {
        this.checkRequirements();
        try {
            String jmxUser = this.user != null ? this.user : ShellUtils.retrieveFabricUser(this.session);
            String jmxPassword = this.password != null ? this.password : ShellUtils.retrieveFabricUserPassword(this.session);
            this.doWithAuthentication(jmxUser, jmxPassword);
        }
        catch (FabricAuthenticationException ex) {
            this.user = null;
            this.password = null;
            this.promptForJmxCredentialsIfNeeded();
            this.doWithAuthentication(this.user, this.password);
            ShellUtils.storeFabricCredentials(this.session, this.user, this.password);
        }
        return null;
    }

    protected void promptForJmxCredentialsIfNeeded() throws IOException {
        if (this.user == null) {
            this.log.debug("Prompting user for jmx login");
            this.user = ShellUtils.readLine(this.session, "Jmx Login for " + this.container + ": ", false);
        }
        if (this.password == null) {
            this.password = ShellUtils.readLine(this.session, "Jmx Password for " + this.container + ": ", true);
        }
    }

    public ContainerProcessManager getContainerProcessManager() {
        return this.containerProcessManager;
    }

    public void setContainerProcessManager(ContainerProcessManager containerProcessManager) {
        this.containerProcessManager = containerProcessManager;
    }

    protected Container getContainerObject() {
        return this.getContainerProcessManager().getFabricService().getContainer(this.container);
    }
}

