/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.commands.support;

import io.fabric8.api.scr.AbstractComponent;
import io.fabric8.zookeeper.utils.ZooKeeperUtils;
import java.util.List;
import org.apache.curator.framework.CuratorFramework;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.karaf.shell.console.Completer;

@Component(immediate=true)
@Service(value={ZNodeCompleter.class, Completer.class})
public class ZNodeCompleter
extends AbstractComponent
implements Completer {
    @Reference
    private CuratorFramework curator;

    public CuratorFramework getCurator() {
        return this.curator;
    }

    public void setCurator(CuratorFramework curator) {
        this.curator = curator;
    }

    @Activate
    void activate() {
        this.activateComponent();
    }

    @Deactivate
    void deactivate() {
        this.deactivateComponent();
    }

    public int complete(String buffer, int cursor, List candidates) {
        try {
            if (this.curator.getZookeeperClient().isConnected()) {
                if (buffer == null) {
                    candidates.add("/");
                    return 1;
                }
                if (!buffer.startsWith("/")) {
                    return 0;
                }
                String path = buffer = buffer.substring(0, cursor);
                int idx = path.lastIndexOf("/") + 1;
                String prefix = path.substring(idx);
                String dir = idx == 1 ? "/" : path.substring(0, idx - 1);
                List children = ZooKeeperUtils.getChildren((CuratorFramework)this.curator, (String)dir);
                for (String child : children) {
                    if (!child.startsWith(prefix)) continue;
                    candidates.add(child);
                }
                return candidates.size() == 0 ? buffer.length() : buffer.lastIndexOf("/") + 1;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return 0;
    }

    protected void bindCurator(CuratorFramework curatorFramework) {
        this.curator = curatorFramework;
    }

    protected void unbindCurator(CuratorFramework curatorFramework) {
        if (this.curator == curatorFramework) {
            this.curator = null;
        }
    }
}

