/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.agent.download;

import io.fabric8.agent.download.AbstractDownloadTask;
import io.fabric8.agent.mvn.DownloadableArtifact;
import io.fabric8.agent.mvn.MavenConfiguration;
import io.fabric8.agent.mvn.MavenRepositoryURL;
import io.fabric8.agent.mvn.Parser;
import io.fabric8.agent.mvn.Version;
import io.fabric8.agent.mvn.VersionRange;
import io.fabric8.common.util.URLUtils;
import io.fabric8.common.util.XmlUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ExecutorService;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class MavenDownloadTask
extends AbstractDownloadTask
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractDownloadTask.class);
    private static final String Ix2 = "  ";
    private static final String Ix4 = "    ";
    private final MavenRepositoryURL cache;
    private final MavenRepositoryURL system;
    private final MavenConfiguration configuration;

    public MavenDownloadTask(String url, MavenRepositoryURL cache, MavenRepositoryURL system, MavenConfiguration configuration, ExecutorService executor) {
        super(url, executor);
        this.cache = cache;
        this.system = system;
        this.configuration = configuration;
    }

    @Override
    protected File download() throws Exception {
        Set<DownloadableArtifact> downloadables;
        Parser parser = Parser.parsePathWithSchemePrefix(this.url);
        if (!parser.getVersion().contains("SNAPSHOT")) {
            downloadables = this.doCollectPossibleDownloads(parser, Arrays.asList(this.cache, this.system, this.configuration.getLocalRepository()));
            for (DownloadableArtifact artifact : downloadables) {
                URL url = artifact.getArtifactURL();
                File file = new File(url.getFile());
                if (!file.exists()) continue;
                return file;
            }
        }
        downloadables = this.collectPossibleDownloads(parser);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Possible download locations for [" + this.url + "]");
            for (DownloadableArtifact artifact : downloadables) {
                LOG.trace(Ix2 + artifact);
            }
        }
        for (DownloadableArtifact artifact : downloadables) {
            LOG.trace("Downloading [" + artifact + "]");
            try {
                this.configuration.enableProxy(artifact.getArtifactURL());
                String repository = this.cache.getFile().getAbsolutePath();
                if (!repository.endsWith(File.separator)) {
                    repository = repository + File.separator;
                }
                InputStream is = artifact.getInputStream();
                File file = new File(repository + parser.getArtifactPath());
                file.getParentFile().mkdirs();
                if (!file.getParentFile().isDirectory()) {
                    throw new IOException("Unable to create directory " + file.getParentFile().toString());
                }
                File tmp = File.createTempFile("fabric-agent-", null, file.getParentFile());
                FileOutputStream os = new FileOutputStream(tmp);
                MavenDownloadTask.copy(is, os);
                is.close();
                ((OutputStream)os).close();
                if (file.exists() && !file.delete()) {
                    throw new IOException("Unable to delete file: " + file.toString());
                }
                if (!tmp.renameTo(file)) {
                    throw new IOException("Unable to rename file " + tmp.toString() + " to " + file.toString());
                }
                return file;
            }
            catch (IOException ignore) {
                LOG.debug("  Could not download [" + artifact + "]");
                LOG.trace("  Reason [" + ignore.getClass().getName() + ": " + ignore.getMessage() + "]");
            }
        }
        throw new IOException("URL [" + this.url + "] could not be resolved.");
    }

    private Set<DownloadableArtifact> collectPossibleDownloads(Parser parser) throws MalformedURLException {
        ArrayList<MavenRepositoryURL> repositories = new ArrayList<MavenRepositoryURL>();
        repositories.addAll(this.configuration.getRepositories());
        repositories.add(this.configuration.getLocalRepository());
        repositories.add(this.system);
        repositories.add(this.cache);
        if (parser.getRepositoryURL() != null) {
            repositories.add(repositories.size() == 0 ? 0 : 1, parser.getRepositoryURL());
        }
        return this.doCollectPossibleDownloads(parser, repositories);
    }

    private Set<DownloadableArtifact> collectDefaultPossibleDownloads(Parser parser) throws MalformedURLException {
        return this.doCollectPossibleDownloads(parser, this.configuration.getDefaultRepositories());
    }

    private Set<DownloadableArtifact> doCollectPossibleDownloads(Parser parser, List<MavenRepositoryURL> repositories) throws MalformedURLException {
        TreeSet<DownloadableArtifact> downloadables = new TreeSet<DownloadableArtifact>(new DownloadComparator());
        boolean isLatest = parser.getVersion().contains("LATEST");
        boolean isSnapshot = parser.getVersion().endsWith("SNAPSHOT");
        VersionRange versionRange = null;
        if (!isLatest && !isSnapshot) {
            try {
                versionRange = new VersionRange(parser.getVersion());
            }
            catch (Exception ignore) {
                // empty catch block
            }
        }
        boolean isVersionRange = versionRange != null;
        boolean isExactVersion = !isLatest && !isSnapshot && !isVersionRange;
        int priority = 0;
        for (MavenRepositoryURL repositoryURL : repositories) {
            LOG.debug("Collecting versions from repository [" + repositoryURL + "]");
            ++priority;
            try {
                if (isExactVersion) {
                    downloadables.add(this.resolveExactVersion(parser, repositoryURL, priority));
                    continue;
                }
                if (isSnapshot) {
                    DownloadableArtifact snapshot = this.resolveSnapshotVersion(parser, repositoryURL, priority, parser.getVersion());
                    downloadables.add(snapshot);
                    if (!snapshot.isLocalSnapshotBuild()) continue;
                    break;
                }
                Document metadata = this.getMetadata(repositoryURL.getURL(), new String[]{parser.getArtifactLocalMetdataPath(), parser.getArtifactMetdataPath()});
                if (isLatest) {
                    downloadables.add(this.resolveLatestVersion(parser, metadata, repositoryURL, priority));
                    continue;
                }
                downloadables.addAll(this.resolveRangeVersions(parser, metadata, repositoryURL, priority, versionRange));
            }
            catch (IOException ignore) {
                LOG.debug("  Skipping repository [" + repositoryURL + "], reason: " + ignore.getMessage());
            }
        }
        return downloadables;
    }

    private Document getMetadata(URL repositoryURL, String[] metadataLocations) throws IOException {
        LOG.debug("  Resolving metadata");
        InputStream inputStream = null;
        String foundLocation = null;
        for (String location : metadataLocations) {
            try {
                inputStream = this.prepareInputStream(repositoryURL, location);
                foundLocation = location;
                LOG.trace("    Metadata found: [" + location + "]");
                break;
            }
            catch (IOException ignore) {
                LOG.trace("    Metadata not found: [" + location + "]");
            }
        }
        if (inputStream == null) {
            throw new IOException("Metadata not found in repository [" + repositoryURL + "]");
        }
        try {
            return XmlUtils.parseDoc(inputStream);
        }
        catch (ParserConfigurationException e) {
            throw MavenDownloadTask.initIOException("Metadata [" + foundLocation + "] could not be parsed.", e);
        }
        catch (SAXException e) {
            throw MavenDownloadTask.initIOException("Metadata [" + foundLocation + "] could not be parsed.", e);
        }
    }

    private DownloadableArtifact resolveExactVersion(Parser parser, MavenRepositoryURL repositoryURL, int priority) throws IOException {
        if (!repositoryURL.isReleasesEnabled()) {
            throw new IOException("Releases not enabled");
        }
        LOG.debug("  Resolving exact version");
        return new DownloadableArtifact(parser.getVersion(), priority, repositoryURL.getURL(), parser.getArtifactPath(), false, this.configuration.getCertificateCheck());
    }

    private DownloadableArtifact resolveLatestVersion(Parser parser, Document metadata, MavenRepositoryURL repositoryURL, int priority) throws IOException {
        LOG.debug("  Resolving latest version");
        String version = XmlUtils.getTextContentOfElement((Document)metadata, (String)"versioning/versions/version[last]");
        if (version != null) {
            if (version.endsWith("SNAPSHOT")) {
                return this.resolveSnapshotVersion(parser, repositoryURL, priority, version);
            }
            return new DownloadableArtifact(version, priority, repositoryURL.getURL(), parser.getArtifactPath(version), false, this.configuration.getCertificateCheck());
        }
        throw new IOException("LATEST version could not be resolved.");
    }

    private DownloadableArtifact resolveSnapshotVersion(Parser parser, MavenRepositoryURL repositoryURL, int priority, String version) throws IOException {
        if (!repositoryURL.isSnapshotsEnabled()) {
            throw new IOException("Snapshots not enabled");
        }
        LOG.debug("  Resolving snapshot version [" + version + "]");
        try {
            Document snapshotMetadata = this.getMetadata(repositoryURL.getURL(), new String[]{parser.getVersionLocalMetadataPath(version), parser.getVersionMetadataPath(version)});
            String timestamp = XmlUtils.getTextContentOfElement((Document)snapshotMetadata, (String)"versioning/snapshot/timestamp");
            String buildNumber = XmlUtils.getTextContentOfElement((Document)snapshotMetadata, (String)"versioning/snapshot/buildNumber");
            String localSnapshot = XmlUtils.getTextContentOfElement((Document)snapshotMetadata, (String)"versioning/snapshot/localCopy");
            if (timestamp != null && buildNumber != null) {
                return new DownloadableArtifact(parser.getSnapshotVersion(version, timestamp, buildNumber), priority, repositoryURL.getURL(), parser.getSnapshotPath(version, timestamp, buildNumber), localSnapshot != null, this.configuration.getCertificateCheck());
            }
            String lastUpdated = XmlUtils.getTextContentOfElement((Document)snapshotMetadata, (String)"versioning/lastUpdated");
            if (lastUpdated != null && lastUpdated.length() > 8) {
                lastUpdated = lastUpdated.substring(0, 8) + "." + lastUpdated.substring(8);
                return new DownloadableArtifact(parser.getSnapshotVersion(version, lastUpdated, "0"), priority, repositoryURL.getURL(), parser.getArtifactPath(version), localSnapshot != null, this.configuration.getCertificateCheck());
            }
        }
        catch (IOException ignore) {
            // empty catch block
        }
        return new DownloadableArtifact(parser.getVersion(), priority, repositoryURL.getURL(), parser.getArtifactPath(), false, this.configuration.getCertificateCheck());
    }

    private List<DownloadableArtifact> resolveRangeVersions(Parser parser, Document metadata, MavenRepositoryURL repositoryURL, int priority, VersionRange versionRange) throws IOException {
        LOG.debug("  Resolving versions in range [" + versionRange + "]");
        ArrayList<DownloadableArtifact> downladables = new ArrayList<DownloadableArtifact>();
        List elements = XmlUtils.getElements((Document)metadata, (String)"versioning/versions/version");
        if (elements != null && elements.size() > 0) {
            for (Element element : elements) {
                Version version;
                String versionString = XmlUtils.getTextContent((Node)element);
                if (versionString == null || !versionRange.includes(version = new Version(versionString))) continue;
                if (versionString.endsWith("SNAPSHOT")) {
                    downladables.add(this.resolveSnapshotVersion(parser, repositoryURL, priority, versionString));
                    continue;
                }
                downladables.add(new DownloadableArtifact(versionString, priority, repositoryURL.getURL(), parser.getArtifactPath(versionString), false, this.configuration.getCertificateCheck()));
            }
        }
        return downladables;
    }

    private InputStream prepareInputStream(URL repositoryURL, String path) throws IOException {
        String repository = repositoryURL.toExternalForm();
        if (!repository.endsWith("/")) {
            repository = repository + "/";
        }
        this.configuration.enableProxy(repositoryURL);
        URL url = new URL(repository + path);
        LOG.trace("Reading " + url.toExternalForm());
        return URLUtils.prepareInputStream((URL)url, (this.configuration.getCertificateCheck() == false ? 1 : 0) != 0);
    }

    private static class DownloadComparator
    implements Comparator<DownloadableArtifact> {
        private DownloadComparator() {
        }

        @Override
        public int compare(DownloadableArtifact first, DownloadableArtifact second) {
            int result = -1 * first.getVersion().compareTo(second.getVersion());
            if (result == 0) {
                if (first.getPriority() < second.getPriority()) {
                    result = -1;
                } else if (first.getPriority() > second.getPriority()) {
                    result = 1;
                }
            }
            return result;
        }
    }
}

