/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.common.util;

import io.fabric8.common.util.XmlNamespaceFinder;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlHelper {
    private static final transient Logger LOG = LoggerFactory.getLogger(XmlHelper.class);
    private static SAXParserFactory factory;

    public static boolean hasNamespace(File file, String ... namespaceURis) {
        try {
            return XmlHelper.hasNamespace(XmlHelper.getNamespaces(file), namespaceURis);
        }
        catch (Exception e) {
            LOG.warn("Failed to parse XML " + file + ". " + e, (Throwable)e);
            return false;
        }
    }

    public static boolean hasNamespace(InputStream file, String ... namespaceURis) {
        try {
            return XmlHelper.hasNamespace(XmlHelper.getNamespaces(file), namespaceURis);
        }
        catch (Exception e) {
            LOG.warn("Failed to parse XML " + file + ". " + e, (Throwable)e);
            return false;
        }
    }

    public static boolean hasNamespace(InputSource file, String ... namespaceURis) {
        try {
            return XmlHelper.hasNamespace(XmlHelper.getNamespaces(file), namespaceURis);
        }
        catch (Exception e) {
            LOG.warn("Failed to parse XML " + file + ". " + e, (Throwable)e);
            return false;
        }
    }

    public static boolean hasNamespace(Set<String> namespaces, String ... namespaceURis) {
        if (namespaces != null) {
            for (String namespaceURi : namespaceURis) {
                if (!namespaces.contains(namespaceURi)) continue;
                return true;
            }
        }
        return false;
    }

    public static Set<String> getNamespaces(File file) throws ParserConfigurationException, SAXException, IOException {
        return XmlHelper.getNamespaces(new InputSource(new FileReader(file)));
    }

    public static Set<String> getNamespaces(InputStream is) throws IOException, SAXException, ParserConfigurationException {
        return XmlHelper.getNamespaces(new InputSource(is));
    }

    public static Set<String> getNamespaces(InputSource source) throws ParserConfigurationException, SAXException, IOException {
        XmlNamespaceFinder finder = XmlHelper.createNamespaceFinder();
        Set<String> answer = finder.parseContents(source);
        if (factory == null) {
            factory = finder.getFactory();
        }
        return answer;
    }

    public static SAXParserFactory getFactory() {
        return factory;
    }

    public static void setFactory(SAXParserFactory factory) {
        XmlHelper.factory = factory;
    }

    protected static XmlNamespaceFinder createNamespaceFinder() {
        XmlNamespaceFinder finder = new XmlNamespaceFinder();
        if (factory != null) {
            finder.setFactory(factory);
        }
        return finder;
    }
}

