/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.config.v1.InfrastructureStatus;
import io.fabric8.openshift.api.model.config.v1.PlatformStatus;
import io.fabric8.openshift.api.model.config.v1.PlatformStatusBuilder;
import io.fabric8.openshift.api.model.config.v1.PlatformStatusFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class InfrastructureStatusFluent<A extends InfrastructureStatusFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private String apiServerInternalURI;
    private String apiServerURL;
    private String controlPlaneTopology;
    private String cpuPartitioning;
    private String etcdDiscoveryDomain;
    private String infrastructureName;
    private String infrastructureTopology;
    private String platform;
    private PlatformStatusBuilder platformStatus;

    public InfrastructureStatusFluent() {
    }

    public InfrastructureStatusFluent(InfrastructureStatus instance) {
        this.copyInstance(instance);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public PlatformStatus buildPlatformStatus() {
        return this.platformStatus != null ? this.platformStatus.build() : null;
    }

    protected void copyInstance(InfrastructureStatus instance) {
        InfrastructureStatus infrastructureStatus = instance = instance != null ? instance : new InfrastructureStatus();
        if (instance != null) {
            this.withApiServerInternalURI(instance.getApiServerInternalURI());
            this.withApiServerURL(instance.getApiServerURL());
            this.withControlPlaneTopology(instance.getControlPlaneTopology());
            this.withCpuPartitioning(instance.getCpuPartitioning());
            this.withEtcdDiscoveryDomain(instance.getEtcdDiscoveryDomain());
            this.withInfrastructureName(instance.getInfrastructureName());
            this.withInfrastructureTopology(instance.getInfrastructureTopology());
            this.withPlatform(instance.getPlatform());
            this.withPlatformStatus(instance.getPlatformStatus());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public PlatformStatusNested<A> editOrNewPlatformStatus() {
        return this.withNewPlatformStatusLike(Optional.ofNullable(this.buildPlatformStatus()).orElse(new PlatformStatusBuilder().build()));
    }

    public PlatformStatusNested<A> editOrNewPlatformStatusLike(PlatformStatus item) {
        return this.withNewPlatformStatusLike(Optional.ofNullable(this.buildPlatformStatus()).orElse(item));
    }

    public PlatformStatusNested<A> editPlatformStatus() {
        return this.withNewPlatformStatusLike(Optional.ofNullable(this.buildPlatformStatus()).orElse(null));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        InfrastructureStatusFluent that = (InfrastructureStatusFluent)((Object)o);
        if (!Objects.equals(this.apiServerInternalURI, that.apiServerInternalURI)) {
            return false;
        }
        if (!Objects.equals(this.apiServerURL, that.apiServerURL)) {
            return false;
        }
        if (!Objects.equals(this.controlPlaneTopology, that.controlPlaneTopology)) {
            return false;
        }
        if (!Objects.equals(this.cpuPartitioning, that.cpuPartitioning)) {
            return false;
        }
        if (!Objects.equals(this.etcdDiscoveryDomain, that.etcdDiscoveryDomain)) {
            return false;
        }
        if (!Objects.equals(this.infrastructureName, that.infrastructureName)) {
            return false;
        }
        if (!Objects.equals(this.infrastructureTopology, that.infrastructureTopology)) {
            return false;
        }
        if (!Objects.equals(this.platform, that.platform)) {
            return false;
        }
        if (!Objects.equals((Object)this.platformStatus, (Object)that.platformStatus)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getApiServerInternalURI() {
        return this.apiServerInternalURI;
    }

    public String getApiServerURL() {
        return this.apiServerURL;
    }

    public String getControlPlaneTopology() {
        return this.controlPlaneTopology;
    }

    public String getCpuPartitioning() {
        return this.cpuPartitioning;
    }

    public String getEtcdDiscoveryDomain() {
        return this.etcdDiscoveryDomain;
    }

    public String getInfrastructureName() {
        return this.infrastructureName;
    }

    public String getInfrastructureTopology() {
        return this.infrastructureTopology;
    }

    public String getPlatform() {
        return this.platform;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasApiServerInternalURI() {
        return this.apiServerInternalURI != null;
    }

    public boolean hasApiServerURL() {
        return this.apiServerURL != null;
    }

    public boolean hasControlPlaneTopology() {
        return this.controlPlaneTopology != null;
    }

    public boolean hasCpuPartitioning() {
        return this.cpuPartitioning != null;
    }

    public boolean hasEtcdDiscoveryDomain() {
        return this.etcdDiscoveryDomain != null;
    }

    public boolean hasInfrastructureName() {
        return this.infrastructureName != null;
    }

    public boolean hasInfrastructureTopology() {
        return this.infrastructureTopology != null;
    }

    public boolean hasPlatform() {
        return this.platform != null;
    }

    public boolean hasPlatformStatus() {
        return this.platformStatus != null;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.apiServerInternalURI, this.apiServerURL, this.controlPlaneTopology, this.cpuPartitioning, this.etcdDiscoveryDomain, this.infrastructureName, this.infrastructureTopology, this.platform, this.platformStatus, this.additionalProperties});
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiServerInternalURI != null) {
            sb.append("apiServerInternalURI:");
            sb.append(this.apiServerInternalURI);
            sb.append(",");
        }
        if (this.apiServerURL != null) {
            sb.append("apiServerURL:");
            sb.append(this.apiServerURL);
            sb.append(",");
        }
        if (this.controlPlaneTopology != null) {
            sb.append("controlPlaneTopology:");
            sb.append(this.controlPlaneTopology);
            sb.append(",");
        }
        if (this.cpuPartitioning != null) {
            sb.append("cpuPartitioning:");
            sb.append(this.cpuPartitioning);
            sb.append(",");
        }
        if (this.etcdDiscoveryDomain != null) {
            sb.append("etcdDiscoveryDomain:");
            sb.append(this.etcdDiscoveryDomain);
            sb.append(",");
        }
        if (this.infrastructureName != null) {
            sb.append("infrastructureName:");
            sb.append(this.infrastructureName);
            sb.append(",");
        }
        if (this.infrastructureTopology != null) {
            sb.append("infrastructureTopology:");
            sb.append(this.infrastructureTopology);
            sb.append(",");
        }
        if (this.platform != null) {
            sb.append("platform:");
            sb.append(this.platform);
            sb.append(",");
        }
        if (this.platformStatus != null) {
            sb.append("platformStatus:");
            sb.append((Object)this.platformStatus);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withApiServerInternalURI(String apiServerInternalURI) {
        this.apiServerInternalURI = apiServerInternalURI;
        return (A)((Object)this);
    }

    public A withApiServerURL(String apiServerURL) {
        this.apiServerURL = apiServerURL;
        return (A)((Object)this);
    }

    public A withControlPlaneTopology(String controlPlaneTopology) {
        this.controlPlaneTopology = controlPlaneTopology;
        return (A)((Object)this);
    }

    public A withCpuPartitioning(String cpuPartitioning) {
        this.cpuPartitioning = cpuPartitioning;
        return (A)((Object)this);
    }

    public A withEtcdDiscoveryDomain(String etcdDiscoveryDomain) {
        this.etcdDiscoveryDomain = etcdDiscoveryDomain;
        return (A)((Object)this);
    }

    public A withInfrastructureName(String infrastructureName) {
        this.infrastructureName = infrastructureName;
        return (A)((Object)this);
    }

    public A withInfrastructureTopology(String infrastructureTopology) {
        this.infrastructureTopology = infrastructureTopology;
        return (A)((Object)this);
    }

    public PlatformStatusNested<A> withNewPlatformStatus() {
        return new PlatformStatusNested(null);
    }

    public PlatformStatusNested<A> withNewPlatformStatusLike(PlatformStatus item) {
        return new PlatformStatusNested(item);
    }

    public A withPlatform(String platform) {
        this.platform = platform;
        return (A)((Object)this);
    }

    public A withPlatformStatus(PlatformStatus platformStatus) {
        this._visitables.remove((Object)"platformStatus");
        if (platformStatus != null) {
            this.platformStatus = new PlatformStatusBuilder(platformStatus);
            this._visitables.get((Object)"platformStatus").add(this.platformStatus);
        } else {
            this.platformStatus = null;
            this._visitables.get((Object)"platformStatus").remove((Object)this.platformStatus);
        }
        return (A)((Object)this);
    }

    public class PlatformStatusNested<N>
    extends PlatformStatusFluent<PlatformStatusNested<N>>
    implements Nested<N> {
        PlatformStatusBuilder builder;

        PlatformStatusNested(PlatformStatus item) {
            this.builder = new PlatformStatusBuilder(this, item);
        }

        public N and() {
            return (N)InfrastructureStatusFluent.this.withPlatformStatus(this.builder.build());
        }

        public N endPlatformStatus() {
            return this.and();
        }
    }
}

