/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.config.v1.BasicAuthIdentityProvider;
import io.fabric8.openshift.api.model.config.v1.ConfigMapNameReference;
import io.fabric8.openshift.api.model.config.v1.ConfigMapNameReferenceBuilder;
import io.fabric8.openshift.api.model.config.v1.ConfigMapNameReferenceFluent;
import io.fabric8.openshift.api.model.config.v1.SecretNameReference;
import io.fabric8.openshift.api.model.config.v1.SecretNameReferenceBuilder;
import io.fabric8.openshift.api.model.config.v1.SecretNameReferenceFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class BasicAuthIdentityProviderFluent<A extends BasicAuthIdentityProviderFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private ConfigMapNameReferenceBuilder ca;
    private SecretNameReferenceBuilder tlsClientCert;
    private SecretNameReferenceBuilder tlsClientKey;
    private String url;

    public BasicAuthIdentityProviderFluent() {
    }

    public BasicAuthIdentityProviderFluent(BasicAuthIdentityProvider instance) {
        this.copyInstance(instance);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public ConfigMapNameReference buildCa() {
        return this.ca != null ? this.ca.build() : null;
    }

    public SecretNameReference buildTlsClientCert() {
        return this.tlsClientCert != null ? this.tlsClientCert.build() : null;
    }

    public SecretNameReference buildTlsClientKey() {
        return this.tlsClientKey != null ? this.tlsClientKey.build() : null;
    }

    protected void copyInstance(BasicAuthIdentityProvider instance) {
        BasicAuthIdentityProvider basicAuthIdentityProvider = instance = instance != null ? instance : new BasicAuthIdentityProvider();
        if (instance != null) {
            this.withCa(instance.getCa());
            this.withTlsClientCert(instance.getTlsClientCert());
            this.withTlsClientKey(instance.getTlsClientKey());
            this.withUrl(instance.getUrl());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public CaNested<A> editCa() {
        return this.withNewCaLike(Optional.ofNullable(this.buildCa()).orElse(null));
    }

    public CaNested<A> editOrNewCa() {
        return this.withNewCaLike(Optional.ofNullable(this.buildCa()).orElse(new ConfigMapNameReferenceBuilder().build()));
    }

    public CaNested<A> editOrNewCaLike(ConfigMapNameReference item) {
        return this.withNewCaLike(Optional.ofNullable(this.buildCa()).orElse(item));
    }

    public TlsClientCertNested<A> editOrNewTlsClientCert() {
        return this.withNewTlsClientCertLike(Optional.ofNullable(this.buildTlsClientCert()).orElse(new SecretNameReferenceBuilder().build()));
    }

    public TlsClientCertNested<A> editOrNewTlsClientCertLike(SecretNameReference item) {
        return this.withNewTlsClientCertLike(Optional.ofNullable(this.buildTlsClientCert()).orElse(item));
    }

    public TlsClientKeyNested<A> editOrNewTlsClientKey() {
        return this.withNewTlsClientKeyLike(Optional.ofNullable(this.buildTlsClientKey()).orElse(new SecretNameReferenceBuilder().build()));
    }

    public TlsClientKeyNested<A> editOrNewTlsClientKeyLike(SecretNameReference item) {
        return this.withNewTlsClientKeyLike(Optional.ofNullable(this.buildTlsClientKey()).orElse(item));
    }

    public TlsClientCertNested<A> editTlsClientCert() {
        return this.withNewTlsClientCertLike(Optional.ofNullable(this.buildTlsClientCert()).orElse(null));
    }

    public TlsClientKeyNested<A> editTlsClientKey() {
        return this.withNewTlsClientKeyLike(Optional.ofNullable(this.buildTlsClientKey()).orElse(null));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BasicAuthIdentityProviderFluent that = (BasicAuthIdentityProviderFluent)((Object)o);
        if (!Objects.equals((Object)this.ca, (Object)that.ca)) {
            return false;
        }
        if (!Objects.equals((Object)this.tlsClientCert, (Object)that.tlsClientCert)) {
            return false;
        }
        if (!Objects.equals((Object)this.tlsClientKey, (Object)that.tlsClientKey)) {
            return false;
        }
        if (!Objects.equals(this.url, that.url)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getUrl() {
        return this.url;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasCa() {
        return this.ca != null;
    }

    public boolean hasTlsClientCert() {
        return this.tlsClientCert != null;
    }

    public boolean hasTlsClientKey() {
        return this.tlsClientKey != null;
    }

    public boolean hasUrl() {
        return this.url != null;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.ca, this.tlsClientCert, this.tlsClientKey, this.url, this.additionalProperties});
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.ca != null) {
            sb.append("ca:");
            sb.append((Object)this.ca);
            sb.append(",");
        }
        if (this.tlsClientCert != null) {
            sb.append("tlsClientCert:");
            sb.append((Object)this.tlsClientCert);
            sb.append(",");
        }
        if (this.tlsClientKey != null) {
            sb.append("tlsClientKey:");
            sb.append((Object)this.tlsClientKey);
            sb.append(",");
        }
        if (this.url != null) {
            sb.append("url:");
            sb.append(this.url);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withCa(ConfigMapNameReference ca) {
        this._visitables.remove((Object)"ca");
        if (ca != null) {
            this.ca = new ConfigMapNameReferenceBuilder(ca);
            this._visitables.get((Object)"ca").add(this.ca);
        } else {
            this.ca = null;
            this._visitables.get((Object)"ca").remove((Object)this.ca);
        }
        return (A)((Object)this);
    }

    public CaNested<A> withNewCa() {
        return new CaNested(null);
    }

    public A withNewCa(String name) {
        return this.withCa(new ConfigMapNameReference(name));
    }

    public CaNested<A> withNewCaLike(ConfigMapNameReference item) {
        return new CaNested(item);
    }

    public TlsClientCertNested<A> withNewTlsClientCert() {
        return new TlsClientCertNested(null);
    }

    public A withNewTlsClientCert(String name) {
        return this.withTlsClientCert(new SecretNameReference(name));
    }

    public TlsClientCertNested<A> withNewTlsClientCertLike(SecretNameReference item) {
        return new TlsClientCertNested(item);
    }

    public TlsClientKeyNested<A> withNewTlsClientKey() {
        return new TlsClientKeyNested(null);
    }

    public A withNewTlsClientKey(String name) {
        return this.withTlsClientKey(new SecretNameReference(name));
    }

    public TlsClientKeyNested<A> withNewTlsClientKeyLike(SecretNameReference item) {
        return new TlsClientKeyNested(item);
    }

    public A withTlsClientCert(SecretNameReference tlsClientCert) {
        this._visitables.remove((Object)"tlsClientCert");
        if (tlsClientCert != null) {
            this.tlsClientCert = new SecretNameReferenceBuilder(tlsClientCert);
            this._visitables.get((Object)"tlsClientCert").add(this.tlsClientCert);
        } else {
            this.tlsClientCert = null;
            this._visitables.get((Object)"tlsClientCert").remove((Object)this.tlsClientCert);
        }
        return (A)((Object)this);
    }

    public A withTlsClientKey(SecretNameReference tlsClientKey) {
        this._visitables.remove((Object)"tlsClientKey");
        if (tlsClientKey != null) {
            this.tlsClientKey = new SecretNameReferenceBuilder(tlsClientKey);
            this._visitables.get((Object)"tlsClientKey").add(this.tlsClientKey);
        } else {
            this.tlsClientKey = null;
            this._visitables.get((Object)"tlsClientKey").remove((Object)this.tlsClientKey);
        }
        return (A)((Object)this);
    }

    public A withUrl(String url) {
        this.url = url;
        return (A)((Object)this);
    }

    public class TlsClientKeyNested<N>
    extends SecretNameReferenceFluent<TlsClientKeyNested<N>>
    implements Nested<N> {
        SecretNameReferenceBuilder builder;

        TlsClientKeyNested(SecretNameReference item) {
            this.builder = new SecretNameReferenceBuilder(this, item);
        }

        public N and() {
            return (N)BasicAuthIdentityProviderFluent.this.withTlsClientKey(this.builder.build());
        }

        public N endTlsClientKey() {
            return this.and();
        }
    }

    public class TlsClientCertNested<N>
    extends SecretNameReferenceFluent<TlsClientCertNested<N>>
    implements Nested<N> {
        SecretNameReferenceBuilder builder;

        TlsClientCertNested(SecretNameReference item) {
            this.builder = new SecretNameReferenceBuilder(this, item);
        }

        public N and() {
            return (N)BasicAuthIdentityProviderFluent.this.withTlsClientCert(this.builder.build());
        }

        public N endTlsClientCert() {
            return this.and();
        }
    }

    public class CaNested<N>
    extends ConfigMapNameReferenceFluent<CaNested<N>>
    implements Nested<N> {
        ConfigMapNameReferenceBuilder builder;

        CaNested(ConfigMapNameReference item) {
            this.builder = new ConfigMapNameReferenceBuilder(this, item);
        }

        public N and() {
            return (N)BasicAuthIdentityProviderFluent.this.withCa(this.builder.build());
        }

        public N endCa() {
            return this.and();
        }
    }
}

