/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluent;
import io.fabric8.openshift.api.model.SecretBuildSource;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class SecretBuildSourceFluent<A extends SecretBuildSourceFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private String destinationDir;
    private LocalObjectReferenceBuilder secret;

    public SecretBuildSourceFluent() {
    }

    public SecretBuildSourceFluent(SecretBuildSource instance) {
        this.copyInstance(instance);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public LocalObjectReference buildSecret() {
        return this.secret != null ? this.secret.build() : null;
    }

    protected void copyInstance(SecretBuildSource instance) {
        SecretBuildSource secretBuildSource = instance = instance != null ? instance : new SecretBuildSource();
        if (instance != null) {
            this.withDestinationDir(instance.getDestinationDir());
            this.withSecret(instance.getSecret());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public SecretNested<A> editOrNewSecret() {
        return this.withNewSecretLike(Optional.ofNullable(this.buildSecret()).orElse(new LocalObjectReferenceBuilder().build()));
    }

    public SecretNested<A> editOrNewSecretLike(LocalObjectReference item) {
        return this.withNewSecretLike(Optional.ofNullable(this.buildSecret()).orElse(item));
    }

    public SecretNested<A> editSecret() {
        return this.withNewSecretLike(Optional.ofNullable(this.buildSecret()).orElse(null));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SecretBuildSourceFluent that = (SecretBuildSourceFluent)((Object)o);
        if (!Objects.equals(this.destinationDir, that.destinationDir)) {
            return false;
        }
        if (!Objects.equals(this.secret, that.secret)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getDestinationDir() {
        return this.destinationDir;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasDestinationDir() {
        return this.destinationDir != null;
    }

    public boolean hasSecret() {
        return this.secret != null;
    }

    public int hashCode() {
        return Objects.hash(this.destinationDir, this.secret, this.additionalProperties);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.destinationDir != null) {
            sb.append("destinationDir:");
            sb.append(this.destinationDir);
            sb.append(",");
        }
        if (this.secret != null) {
            sb.append("secret:");
            sb.append(this.secret);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withDestinationDir(String destinationDir) {
        this.destinationDir = destinationDir;
        return (A)((Object)this);
    }

    public SecretNested<A> withNewSecret() {
        return new SecretNested(null);
    }

    public A withNewSecret(String name) {
        return this.withSecret(new LocalObjectReference(name));
    }

    public SecretNested<A> withNewSecretLike(LocalObjectReference item) {
        return new SecretNested(item);
    }

    public A withSecret(LocalObjectReference secret) {
        this._visitables.remove((Object)"secret");
        if (secret != null) {
            this.secret = new LocalObjectReferenceBuilder(secret);
            this._visitables.get((Object)"secret").add(this.secret);
        } else {
            this.secret = null;
            this._visitables.get((Object)"secret").remove(this.secret);
        }
        return (A)((Object)this);
    }

    public class SecretNested<N>
    extends LocalObjectReferenceFluent<SecretNested<N>>
    implements Nested<N> {
        LocalObjectReferenceBuilder builder;

        SecretNested(LocalObjectReference item) {
            this.builder = new LocalObjectReferenceBuilder((LocalObjectReferenceFluent)this, item);
        }

        public N and() {
            return (N)SecretBuildSourceFluent.this.withSecret(this.builder.build());
        }

        public N endSecret() {
            return this.and();
        }
    }
}

