/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.RouteIngress;
import io.fabric8.openshift.api.model.RouteIngressCondition;
import io.fabric8.openshift.api.model.RouteIngressConditionBuilder;
import io.fabric8.openshift.api.model.RouteIngressConditionFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class RouteIngressFluent<A extends RouteIngressFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private ArrayList<RouteIngressConditionBuilder> conditions = new ArrayList();
    private String host;
    private String routerCanonicalHostname;
    private String routerName;
    private String wildcardPolicy;

    public RouteIngressFluent() {
    }

    public RouteIngressFluent(RouteIngress instance) {
        this.copyInstance(instance);
    }

    public A addAllToConditions(Collection<RouteIngressCondition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (RouteIngressCondition item : items) {
            RouteIngressConditionBuilder builder = new RouteIngressConditionBuilder(item);
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)((Object)this);
    }

    public ConditionsNested<A> addNewCondition() {
        return new ConditionsNested(-1, null);
    }

    public A addNewCondition(String lastTransitionTime, String message, String reason, String status, String type) {
        return this.addToConditions(new RouteIngressCondition(lastTransitionTime, message, reason, status, type));
    }

    public ConditionsNested<A> addNewConditionLike(RouteIngressCondition item) {
        return new ConditionsNested(-1, item);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToConditions(RouteIngressCondition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (RouteIngressCondition item : items) {
            RouteIngressConditionBuilder builder = new RouteIngressConditionBuilder(item);
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)((Object)this);
    }

    public A addToConditions(int index, RouteIngressCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        RouteIngressConditionBuilder builder = new RouteIngressConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(index, builder);
        }
        return (A)((Object)this);
    }

    public RouteIngressCondition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    public List<RouteIngressCondition> buildConditions() {
        return this.conditions != null ? RouteIngressFluent.build(this.conditions) : null;
    }

    public RouteIngressCondition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    public RouteIngressCondition buildLastCondition() {
        return this.conditions.get(this.conditions.size() - 1).build();
    }

    public RouteIngressCondition buildMatchingCondition(Predicate<RouteIngressConditionBuilder> predicate) {
        for (RouteIngressConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    protected void copyInstance(RouteIngress instance) {
        RouteIngress routeIngress = instance = instance != null ? instance : new RouteIngress();
        if (instance != null) {
            this.withConditions(instance.getConditions());
            this.withHost(instance.getHost());
            this.withRouterCanonicalHostname(instance.getRouterCanonicalHostname());
            this.withRouterName(instance.getRouterName());
            this.withWildcardPolicy(instance.getWildcardPolicy());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public ConditionsNested<A> editCondition(int index) {
        if (this.conditions.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "conditions"));
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ConditionsNested<A> editFirstCondition() {
        if (this.conditions.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "conditions"));
        }
        return this.setNewConditionLike(0, this.buildCondition(0));
    }

    public ConditionsNested<A> editLastCondition() {
        int index = this.conditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "conditions"));
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ConditionsNested<A> editMatchingCondition(Predicate<RouteIngressConditionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.conditions.size(); ++i) {
            if (!predicate.test(this.conditions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "conditions"));
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RouteIngressFluent that = (RouteIngressFluent)((Object)o);
        if (!Objects.equals(this.conditions, that.conditions)) {
            return false;
        }
        if (!Objects.equals(this.host, that.host)) {
            return false;
        }
        if (!Objects.equals(this.routerCanonicalHostname, that.routerCanonicalHostname)) {
            return false;
        }
        if (!Objects.equals(this.routerName, that.routerName)) {
            return false;
        }
        if (!Objects.equals(this.wildcardPolicy, that.wildcardPolicy)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getHost() {
        return this.host;
    }

    public String getRouterCanonicalHostname() {
        return this.routerCanonicalHostname;
    }

    public String getRouterName() {
        return this.routerName;
    }

    public String getWildcardPolicy() {
        return this.wildcardPolicy;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    public boolean hasHost() {
        return this.host != null;
    }

    public boolean hasMatchingCondition(Predicate<RouteIngressConditionBuilder> predicate) {
        for (RouteIngressConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasRouterCanonicalHostname() {
        return this.routerCanonicalHostname != null;
    }

    public boolean hasRouterName() {
        return this.routerName != null;
    }

    public boolean hasWildcardPolicy() {
        return this.wildcardPolicy != null;
    }

    public int hashCode() {
        return Objects.hash(this.conditions, this.host, this.routerCanonicalHostname, this.routerName, this.wildcardPolicy, this.additionalProperties);
    }

    public A removeAllFromConditions(Collection<RouteIngressCondition> items) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        for (RouteIngressCondition item : items) {
            RouteIngressConditionBuilder builder = new RouteIngressConditionBuilder(item);
            this._visitables.get((Object)"conditions").remove((Object)builder);
            this.conditions.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeFromConditions(RouteIngressCondition ... items) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        for (RouteIngressCondition item : items) {
            RouteIngressConditionBuilder builder = new RouteIngressConditionBuilder(item);
            this._visitables.get((Object)"conditions").remove((Object)builder);
            this.conditions.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromConditions(Predicate<RouteIngressConditionBuilder> predicate) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        Iterator<RouteIngressConditionBuilder> each = this.conditions.iterator();
        List visitables = this._visitables.get((Object)"conditions");
        while (each.hasNext()) {
            RouteIngressConditionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public ConditionsNested<A> setNewConditionLike(int index, RouteIngressCondition item) {
        return new ConditionsNested(index, item);
    }

    public A setToConditions(int index, RouteIngressCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        RouteIngressConditionBuilder builder = new RouteIngressConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.set(index, builder);
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.conditions != null && !this.conditions.isEmpty()) {
            sb.append("conditions:");
            sb.append(this.conditions);
            sb.append(",");
        }
        if (this.host != null) {
            sb.append("host:");
            sb.append(this.host);
            sb.append(",");
        }
        if (this.routerCanonicalHostname != null) {
            sb.append("routerCanonicalHostname:");
            sb.append(this.routerCanonicalHostname);
            sb.append(",");
        }
        if (this.routerName != null) {
            sb.append("routerName:");
            sb.append(this.routerName);
            sb.append(",");
        }
        if (this.wildcardPolicy != null) {
            sb.append("wildcardPolicy:");
            sb.append(this.wildcardPolicy);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withConditions(List<RouteIngressCondition> conditions) {
        if (this.conditions != null) {
            this._visitables.get((Object)"conditions").clear();
        }
        if (conditions != null) {
            this.conditions = new ArrayList();
            for (RouteIngressCondition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)((Object)this);
    }

    public A withConditions(RouteIngressCondition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
            this._visitables.remove((Object)"conditions");
        }
        if (conditions != null) {
            for (RouteIngressCondition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)((Object)this);
    }

    public A withHost(String host) {
        this.host = host;
        return (A)((Object)this);
    }

    public A withRouterCanonicalHostname(String routerCanonicalHostname) {
        this.routerCanonicalHostname = routerCanonicalHostname;
        return (A)((Object)this);
    }

    public A withRouterName(String routerName) {
        this.routerName = routerName;
        return (A)((Object)this);
    }

    public A withWildcardPolicy(String wildcardPolicy) {
        this.wildcardPolicy = wildcardPolicy;
        return (A)((Object)this);
    }

    public class ConditionsNested<N>
    extends RouteIngressConditionFluent<ConditionsNested<N>>
    implements Nested<N> {
        RouteIngressConditionBuilder builder;
        int index;

        ConditionsNested(int index, RouteIngressCondition item) {
            this.index = index;
            this.builder = new RouteIngressConditionBuilder(this, item);
        }

        public N and() {
            return (N)RouteIngressFluent.this.setToConditions(this.index, this.builder.build());
        }

        public N endCondition() {
            return this.and();
        }
    }
}

