/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.openshift.api.model.OAuthAuthorizeToken;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class OAuthAuthorizeTokenFluent<A extends OAuthAuthorizeTokenFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private String apiVersion;
    private String clientName;
    private String codeChallenge;
    private String codeChallengeMethod;
    private Long expiresIn;
    private String kind;
    private ObjectMetaBuilder metadata;
    private String redirectURI;
    private List<String> scopes = new ArrayList<String>();
    private String state;
    private String userName;
    private String userUID;

    public OAuthAuthorizeTokenFluent() {
    }

    public OAuthAuthorizeTokenFluent(OAuthAuthorizeToken instance) {
        this.copyInstance(instance);
    }

    public A addAllToScopes(Collection<String> items) {
        if (this.scopes == null) {
            this.scopes = new ArrayList<String>();
        }
        for (String item : items) {
            this.scopes.add(item);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToScopes(String ... items) {
        if (this.scopes == null) {
            this.scopes = new ArrayList<String>();
        }
        for (String item : items) {
            this.scopes.add(item);
        }
        return (A)((Object)this);
    }

    public A addToScopes(int index, String item) {
        if (this.scopes == null) {
            this.scopes = new ArrayList<String>();
        }
        this.scopes.add(index, item);
        return (A)((Object)this);
    }

    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    protected void copyInstance(OAuthAuthorizeToken instance) {
        OAuthAuthorizeToken oAuthAuthorizeToken = instance = instance != null ? instance : new OAuthAuthorizeToken();
        if (instance != null) {
            this.withApiVersion(instance.getApiVersion());
            this.withClientName(instance.getClientName());
            this.withCodeChallenge(instance.getCodeChallenge());
            this.withCodeChallengeMethod(instance.getCodeChallengeMethod());
            this.withExpiresIn(instance.getExpiresIn());
            this.withKind(instance.getKind());
            this.withMetadata(instance.getMetadata());
            this.withRedirectURI(instance.getRedirectURI());
            this.withScopes(instance.getScopes());
            this.withState(instance.getState());
            this.withUserName(instance.getUserName());
            this.withUserUID(instance.getUserUID());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(null));
    }

    public MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(new ObjectMetaBuilder().build()));
    }

    public MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(item));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OAuthAuthorizeTokenFluent that = (OAuthAuthorizeTokenFluent)((Object)o);
        if (!Objects.equals(this.apiVersion, that.apiVersion)) {
            return false;
        }
        if (!Objects.equals(this.clientName, that.clientName)) {
            return false;
        }
        if (!Objects.equals(this.codeChallenge, that.codeChallenge)) {
            return false;
        }
        if (!Objects.equals(this.codeChallengeMethod, that.codeChallengeMethod)) {
            return false;
        }
        if (!Objects.equals(this.expiresIn, that.expiresIn)) {
            return false;
        }
        if (!Objects.equals(this.kind, that.kind)) {
            return false;
        }
        if (!Objects.equals(this.metadata, that.metadata)) {
            return false;
        }
        if (!Objects.equals(this.redirectURI, that.redirectURI)) {
            return false;
        }
        if (!Objects.equals(this.scopes, that.scopes)) {
            return false;
        }
        if (!Objects.equals(this.state, that.state)) {
            return false;
        }
        if (!Objects.equals(this.userName, that.userName)) {
            return false;
        }
        if (!Objects.equals(this.userUID, that.userUID)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public String getClientName() {
        return this.clientName;
    }

    public String getCodeChallenge() {
        return this.codeChallenge;
    }

    public String getCodeChallengeMethod() {
        return this.codeChallengeMethod;
    }

    public Long getExpiresIn() {
        return this.expiresIn;
    }

    public String getFirstScope() {
        return this.scopes.get(0);
    }

    public String getKind() {
        return this.kind;
    }

    public String getLastScope() {
        return this.scopes.get(this.scopes.size() - 1);
    }

    public String getMatchingScope(Predicate<String> predicate) {
        for (String item : this.scopes) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public String getRedirectURI() {
        return this.redirectURI;
    }

    public String getScope(int index) {
        return this.scopes.get(index);
    }

    public List<String> getScopes() {
        return this.scopes;
    }

    public String getState() {
        return this.state;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getUserUID() {
        return this.userUID;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public boolean hasClientName() {
        return this.clientName != null;
    }

    public boolean hasCodeChallenge() {
        return this.codeChallenge != null;
    }

    public boolean hasCodeChallengeMethod() {
        return this.codeChallengeMethod != null;
    }

    public boolean hasExpiresIn() {
        return this.expiresIn != null;
    }

    public boolean hasKind() {
        return this.kind != null;
    }

    public boolean hasMatchingScope(Predicate<String> predicate) {
        for (String item : this.scopes) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMetadata() {
        return this.metadata != null;
    }

    public boolean hasRedirectURI() {
        return this.redirectURI != null;
    }

    public boolean hasScopes() {
        return this.scopes != null && !this.scopes.isEmpty();
    }

    public boolean hasState() {
        return this.state != null;
    }

    public boolean hasUserName() {
        return this.userName != null;
    }

    public boolean hasUserUID() {
        return this.userUID != null;
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.clientName, this.codeChallenge, this.codeChallengeMethod, this.expiresIn, this.kind, this.metadata, this.redirectURI, this.scopes, this.state, this.userName, this.userUID, this.additionalProperties);
    }

    public A removeAllFromScopes(Collection<String> items) {
        if (this.scopes == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.scopes.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeFromScopes(String ... items) {
        if (this.scopes == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.scopes.remove(item);
        }
        return (A)((Object)this);
    }

    public A setToScopes(int index, String item) {
        if (this.scopes == null) {
            this.scopes = new ArrayList<String>();
        }
        this.scopes.set(index, item);
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion);
            sb.append(",");
        }
        if (this.clientName != null) {
            sb.append("clientName:");
            sb.append(this.clientName);
            sb.append(",");
        }
        if (this.codeChallenge != null) {
            sb.append("codeChallenge:");
            sb.append(this.codeChallenge);
            sb.append(",");
        }
        if (this.codeChallengeMethod != null) {
            sb.append("codeChallengeMethod:");
            sb.append(this.codeChallengeMethod);
            sb.append(",");
        }
        if (this.expiresIn != null) {
            sb.append("expiresIn:");
            sb.append(this.expiresIn);
            sb.append(",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind);
            sb.append(",");
        }
        if (this.metadata != null) {
            sb.append("metadata:");
            sb.append(this.metadata);
            sb.append(",");
        }
        if (this.redirectURI != null) {
            sb.append("redirectURI:");
            sb.append(this.redirectURI);
            sb.append(",");
        }
        if (this.scopes != null && !this.scopes.isEmpty()) {
            sb.append("scopes:");
            sb.append(this.scopes);
            sb.append(",");
        }
        if (this.state != null) {
            sb.append("state:");
            sb.append(this.state);
            sb.append(",");
        }
        if (this.userName != null) {
            sb.append("userName:");
            sb.append(this.userName);
            sb.append(",");
        }
        if (this.userUID != null) {
            sb.append("userUID:");
            sb.append(this.userUID);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)((Object)this);
    }

    public A withClientName(String clientName) {
        this.clientName = clientName;
        return (A)((Object)this);
    }

    public A withCodeChallenge(String codeChallenge) {
        this.codeChallenge = codeChallenge;
        return (A)((Object)this);
    }

    public A withCodeChallengeMethod(String codeChallengeMethod) {
        this.codeChallengeMethod = codeChallengeMethod;
        return (A)((Object)this);
    }

    public A withExpiresIn(Long expiresIn) {
        this.expiresIn = expiresIn;
        return (A)((Object)this);
    }

    public A withKind(String kind) {
        this.kind = kind;
        return (A)((Object)this);
    }

    public A withMetadata(ObjectMeta metadata) {
        this._visitables.remove((Object)"metadata");
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.get((Object)"metadata").add(this.metadata);
        } else {
            this.metadata = null;
            this._visitables.get((Object)"metadata").remove(this.metadata);
        }
        return (A)((Object)this);
    }

    public MetadataNested<A> withNewMetadata() {
        return new MetadataNested(null);
    }

    public MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNested(item);
    }

    public A withRedirectURI(String redirectURI) {
        this.redirectURI = redirectURI;
        return (A)((Object)this);
    }

    public A withScopes(List<String> scopes) {
        if (scopes != null) {
            this.scopes = new ArrayList<String>();
            for (String item : scopes) {
                this.addToScopes(item);
            }
        } else {
            this.scopes = null;
        }
        return (A)((Object)this);
    }

    public A withScopes(String ... scopes) {
        if (this.scopes != null) {
            this.scopes.clear();
            this._visitables.remove((Object)"scopes");
        }
        if (scopes != null) {
            for (String item : scopes) {
                this.addToScopes(item);
            }
        }
        return (A)((Object)this);
    }

    public A withState(String state) {
        this.state = state;
        return (A)((Object)this);
    }

    public A withUserName(String userName) {
        this.userName = userName;
        return (A)((Object)this);
    }

    public A withUserUID(String userUID) {
        this.userUID = userUID;
        return (A)((Object)this);
    }

    public class MetadataNested<N>
    extends ObjectMetaFluent<MetadataNested<N>>
    implements Nested<N> {
        ObjectMetaBuilder builder;

        MetadataNested(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder((ObjectMetaFluent)this, item);
        }

        public N and() {
            return (N)OAuthAuthorizeTokenFluent.this.withMetadata(this.builder.build());
        }

        public N endMetadata() {
            return this.and();
        }
    }
}

