/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.EnvVarBuilder;
import io.fabric8.kubernetes.api.model.EnvVarFluent;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.openshift.api.model.CustomBuildStrategy;
import io.fabric8.openshift.api.model.SecretSpec;
import io.fabric8.openshift.api.model.SecretSpecBuilder;
import io.fabric8.openshift.api.model.SecretSpecFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class CustomBuildStrategyFluent<A extends CustomBuildStrategyFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private String buildAPIVersion;
    private ArrayList<EnvVarBuilder> env = new ArrayList();
    private Boolean exposeDockerSocket;
    private Boolean forcePull;
    private ObjectReferenceBuilder from;
    private LocalObjectReferenceBuilder pullSecret;
    private ArrayList<SecretSpecBuilder> secrets = new ArrayList();

    public CustomBuildStrategyFluent() {
    }

    public CustomBuildStrategyFluent(CustomBuildStrategy instance) {
        this.copyInstance(instance);
    }

    public A addAllToEnv(Collection<EnvVar> items) {
        if (this.env == null) {
            this.env = new ArrayList();
        }
        for (EnvVar item : items) {
            EnvVarBuilder builder = new EnvVarBuilder(item);
            this._visitables.get((Object)"env").add(builder);
            this.env.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToSecrets(Collection<SecretSpec> items) {
        if (this.secrets == null) {
            this.secrets = new ArrayList();
        }
        for (SecretSpec item : items) {
            SecretSpecBuilder builder = new SecretSpecBuilder(item);
            this._visitables.get((Object)"secrets").add(builder);
            this.secrets.add(builder);
        }
        return (A)((Object)this);
    }

    public EnvNested<A> addNewEnv() {
        return new EnvNested(-1, null);
    }

    public EnvNested<A> addNewEnvLike(EnvVar item) {
        return new EnvNested(-1, item);
    }

    public SecretsNested<A> addNewSecret() {
        return new SecretsNested(-1, null);
    }

    public SecretsNested<A> addNewSecretLike(SecretSpec item) {
        return new SecretsNested(-1, item);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToEnv(EnvVar ... items) {
        if (this.env == null) {
            this.env = new ArrayList();
        }
        for (EnvVar item : items) {
            EnvVarBuilder builder = new EnvVarBuilder(item);
            this._visitables.get((Object)"env").add(builder);
            this.env.add(builder);
        }
        return (A)((Object)this);
    }

    public A addToEnv(int index, EnvVar item) {
        if (this.env == null) {
            this.env = new ArrayList();
        }
        EnvVarBuilder builder = new EnvVarBuilder(item);
        if (index < 0 || index >= this.env.size()) {
            this._visitables.get((Object)"env").add(builder);
            this.env.add(builder);
        } else {
            this._visitables.get((Object)"env").add(builder);
            this.env.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToSecrets(SecretSpec ... items) {
        if (this.secrets == null) {
            this.secrets = new ArrayList();
        }
        for (SecretSpec item : items) {
            SecretSpecBuilder builder = new SecretSpecBuilder(item);
            this._visitables.get((Object)"secrets").add(builder);
            this.secrets.add(builder);
        }
        return (A)((Object)this);
    }

    public A addToSecrets(int index, SecretSpec item) {
        if (this.secrets == null) {
            this.secrets = new ArrayList();
        }
        SecretSpecBuilder builder = new SecretSpecBuilder(item);
        if (index < 0 || index >= this.secrets.size()) {
            this._visitables.get((Object)"secrets").add(builder);
            this.secrets.add(builder);
        } else {
            this._visitables.get((Object)"secrets").add(builder);
            this.secrets.add(index, builder);
        }
        return (A)((Object)this);
    }

    public List<EnvVar> buildEnv() {
        return this.env != null ? CustomBuildStrategyFluent.build(this.env) : null;
    }

    public EnvVar buildEnv(int index) {
        return this.env.get(index).build();
    }

    public EnvVar buildFirstEnv() {
        return this.env.get(0).build();
    }

    public SecretSpec buildFirstSecret() {
        return this.secrets.get(0).build();
    }

    public ObjectReference buildFrom() {
        return this.from != null ? this.from.build() : null;
    }

    public EnvVar buildLastEnv() {
        return this.env.get(this.env.size() - 1).build();
    }

    public SecretSpec buildLastSecret() {
        return this.secrets.get(this.secrets.size() - 1).build();
    }

    public EnvVar buildMatchingEnv(Predicate<EnvVarBuilder> predicate) {
        for (EnvVarBuilder item : this.env) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public SecretSpec buildMatchingSecret(Predicate<SecretSpecBuilder> predicate) {
        for (SecretSpecBuilder item : this.secrets) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public LocalObjectReference buildPullSecret() {
        return this.pullSecret != null ? this.pullSecret.build() : null;
    }

    public SecretSpec buildSecret(int index) {
        return this.secrets.get(index).build();
    }

    public List<SecretSpec> buildSecrets() {
        return this.secrets != null ? CustomBuildStrategyFluent.build(this.secrets) : null;
    }

    protected void copyInstance(CustomBuildStrategy instance) {
        CustomBuildStrategy customBuildStrategy = instance = instance != null ? instance : new CustomBuildStrategy();
        if (instance != null) {
            this.withBuildAPIVersion(instance.getBuildAPIVersion());
            this.withEnv(instance.getEnv());
            this.withExposeDockerSocket(instance.getExposeDockerSocket());
            this.withForcePull(instance.getForcePull());
            this.withFrom(instance.getFrom());
            this.withPullSecret(instance.getPullSecret());
            this.withSecrets(instance.getSecrets());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public EnvNested<A> editEnv(int index) {
        if (this.env.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "env"));
        }
        return this.setNewEnvLike(index, this.buildEnv(index));
    }

    public EnvNested<A> editFirstEnv() {
        if (this.env.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "env"));
        }
        return this.setNewEnvLike(0, this.buildEnv(0));
    }

    public SecretsNested<A> editFirstSecret() {
        if (this.secrets.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "secrets"));
        }
        return this.setNewSecretLike(0, this.buildSecret(0));
    }

    public FromNested<A> editFrom() {
        return this.withNewFromLike(Optional.ofNullable(this.buildFrom()).orElse(null));
    }

    public EnvNested<A> editLastEnv() {
        int index = this.env.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "env"));
        }
        return this.setNewEnvLike(index, this.buildEnv(index));
    }

    public SecretsNested<A> editLastSecret() {
        int index = this.secrets.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "secrets"));
        }
        return this.setNewSecretLike(index, this.buildSecret(index));
    }

    public EnvNested<A> editMatchingEnv(Predicate<EnvVarBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.env.size(); ++i) {
            if (!predicate.test(this.env.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "env"));
        }
        return this.setNewEnvLike(index, this.buildEnv(index));
    }

    public SecretsNested<A> editMatchingSecret(Predicate<SecretSpecBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.secrets.size(); ++i) {
            if (!predicate.test(this.secrets.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "secrets"));
        }
        return this.setNewSecretLike(index, this.buildSecret(index));
    }

    public FromNested<A> editOrNewFrom() {
        return this.withNewFromLike(Optional.ofNullable(this.buildFrom()).orElse(new ObjectReferenceBuilder().build()));
    }

    public FromNested<A> editOrNewFromLike(ObjectReference item) {
        return this.withNewFromLike(Optional.ofNullable(this.buildFrom()).orElse(item));
    }

    public PullSecretNested<A> editOrNewPullSecret() {
        return this.withNewPullSecretLike(Optional.ofNullable(this.buildPullSecret()).orElse(new LocalObjectReferenceBuilder().build()));
    }

    public PullSecretNested<A> editOrNewPullSecretLike(LocalObjectReference item) {
        return this.withNewPullSecretLike(Optional.ofNullable(this.buildPullSecret()).orElse(item));
    }

    public PullSecretNested<A> editPullSecret() {
        return this.withNewPullSecretLike(Optional.ofNullable(this.buildPullSecret()).orElse(null));
    }

    public SecretsNested<A> editSecret(int index) {
        if (this.secrets.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "secrets"));
        }
        return this.setNewSecretLike(index, this.buildSecret(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CustomBuildStrategyFluent that = (CustomBuildStrategyFluent)((Object)o);
        if (!Objects.equals(this.buildAPIVersion, that.buildAPIVersion)) {
            return false;
        }
        if (!Objects.equals(this.env, that.env)) {
            return false;
        }
        if (!Objects.equals(this.exposeDockerSocket, that.exposeDockerSocket)) {
            return false;
        }
        if (!Objects.equals(this.forcePull, that.forcePull)) {
            return false;
        }
        if (!Objects.equals(this.from, that.from)) {
            return false;
        }
        if (!Objects.equals(this.pullSecret, that.pullSecret)) {
            return false;
        }
        if (!Objects.equals(this.secrets, that.secrets)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getBuildAPIVersion() {
        return this.buildAPIVersion;
    }

    public Boolean getExposeDockerSocket() {
        return this.exposeDockerSocket;
    }

    public Boolean getForcePull() {
        return this.forcePull;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasBuildAPIVersion() {
        return this.buildAPIVersion != null;
    }

    public boolean hasEnv() {
        return this.env != null && !this.env.isEmpty();
    }

    public boolean hasExposeDockerSocket() {
        return this.exposeDockerSocket != null;
    }

    public boolean hasForcePull() {
        return this.forcePull != null;
    }

    public boolean hasFrom() {
        return this.from != null;
    }

    public boolean hasMatchingEnv(Predicate<EnvVarBuilder> predicate) {
        for (EnvVarBuilder item : this.env) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMatchingSecret(Predicate<SecretSpecBuilder> predicate) {
        for (SecretSpecBuilder item : this.secrets) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasPullSecret() {
        return this.pullSecret != null;
    }

    public boolean hasSecrets() {
        return this.secrets != null && !this.secrets.isEmpty();
    }

    public int hashCode() {
        return Objects.hash(this.buildAPIVersion, this.env, this.exposeDockerSocket, this.forcePull, this.from, this.pullSecret, this.secrets, this.additionalProperties);
    }

    public A removeAllFromEnv(Collection<EnvVar> items) {
        if (this.env == null) {
            return (A)((Object)this);
        }
        for (EnvVar item : items) {
            EnvVarBuilder builder = new EnvVarBuilder(item);
            this._visitables.get((Object)"env").remove(builder);
            this.env.remove(builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromSecrets(Collection<SecretSpec> items) {
        if (this.secrets == null) {
            return (A)((Object)this);
        }
        for (SecretSpec item : items) {
            SecretSpecBuilder builder = new SecretSpecBuilder(item);
            this._visitables.get((Object)"secrets").remove((Object)builder);
            this.secrets.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeFromEnv(EnvVar ... items) {
        if (this.env == null) {
            return (A)((Object)this);
        }
        for (EnvVar item : items) {
            EnvVarBuilder builder = new EnvVarBuilder(item);
            this._visitables.get((Object)"env").remove(builder);
            this.env.remove(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromSecrets(SecretSpec ... items) {
        if (this.secrets == null) {
            return (A)((Object)this);
        }
        for (SecretSpec item : items) {
            SecretSpecBuilder builder = new SecretSpecBuilder(item);
            this._visitables.get((Object)"secrets").remove((Object)builder);
            this.secrets.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromEnv(Predicate<EnvVarBuilder> predicate) {
        if (this.env == null) {
            return (A)((Object)this);
        }
        Iterator<EnvVarBuilder> each = this.env.iterator();
        List visitables = this._visitables.get((Object)"env");
        while (each.hasNext()) {
            EnvVarBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromSecrets(Predicate<SecretSpecBuilder> predicate) {
        if (this.secrets == null) {
            return (A)((Object)this);
        }
        Iterator<SecretSpecBuilder> each = this.secrets.iterator();
        List visitables = this._visitables.get((Object)"secrets");
        while (each.hasNext()) {
            SecretSpecBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public EnvNested<A> setNewEnvLike(int index, EnvVar item) {
        return new EnvNested(index, item);
    }

    public SecretsNested<A> setNewSecretLike(int index, SecretSpec item) {
        return new SecretsNested(index, item);
    }

    public A setToEnv(int index, EnvVar item) {
        if (this.env == null) {
            this.env = new ArrayList();
        }
        EnvVarBuilder builder = new EnvVarBuilder(item);
        if (index < 0 || index >= this.env.size()) {
            this._visitables.get((Object)"env").add(builder);
            this.env.add(builder);
        } else {
            this._visitables.get((Object)"env").add(builder);
            this.env.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToSecrets(int index, SecretSpec item) {
        if (this.secrets == null) {
            this.secrets = new ArrayList();
        }
        SecretSpecBuilder builder = new SecretSpecBuilder(item);
        if (index < 0 || index >= this.secrets.size()) {
            this._visitables.get((Object)"secrets").add(builder);
            this.secrets.add(builder);
        } else {
            this._visitables.get((Object)"secrets").add(builder);
            this.secrets.set(index, builder);
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.buildAPIVersion != null) {
            sb.append("buildAPIVersion:");
            sb.append(this.buildAPIVersion);
            sb.append(",");
        }
        if (this.env != null && !this.env.isEmpty()) {
            sb.append("env:");
            sb.append(this.env);
            sb.append(",");
        }
        if (this.exposeDockerSocket != null) {
            sb.append("exposeDockerSocket:");
            sb.append(this.exposeDockerSocket);
            sb.append(",");
        }
        if (this.forcePull != null) {
            sb.append("forcePull:");
            sb.append(this.forcePull);
            sb.append(",");
        }
        if (this.from != null) {
            sb.append("from:");
            sb.append(this.from);
            sb.append(",");
        }
        if (this.pullSecret != null) {
            sb.append("pullSecret:");
            sb.append(this.pullSecret);
            sb.append(",");
        }
        if (this.secrets != null && !this.secrets.isEmpty()) {
            sb.append("secrets:");
            sb.append(this.secrets);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withBuildAPIVersion(String buildAPIVersion) {
        this.buildAPIVersion = buildAPIVersion;
        return (A)((Object)this);
    }

    public A withEnv(List<EnvVar> env) {
        if (this.env != null) {
            this._visitables.get((Object)"env").clear();
        }
        if (env != null) {
            this.env = new ArrayList();
            for (EnvVar item : env) {
                this.addToEnv(item);
            }
        } else {
            this.env = null;
        }
        return (A)((Object)this);
    }

    public A withEnv(EnvVar ... env) {
        if (this.env != null) {
            this.env.clear();
            this._visitables.remove((Object)"env");
        }
        if (env != null) {
            for (EnvVar item : env) {
                this.addToEnv(item);
            }
        }
        return (A)((Object)this);
    }

    public A withExposeDockerSocket() {
        return this.withExposeDockerSocket(true);
    }

    public A withExposeDockerSocket(Boolean exposeDockerSocket) {
        this.exposeDockerSocket = exposeDockerSocket;
        return (A)((Object)this);
    }

    public A withForcePull() {
        return this.withForcePull(true);
    }

    public A withForcePull(Boolean forcePull) {
        this.forcePull = forcePull;
        return (A)((Object)this);
    }

    public A withFrom(ObjectReference from) {
        this._visitables.remove((Object)"from");
        if (from != null) {
            this.from = new ObjectReferenceBuilder(from);
            this._visitables.get((Object)"from").add(this.from);
        } else {
            this.from = null;
            this._visitables.get((Object)"from").remove(this.from);
        }
        return (A)((Object)this);
    }

    public FromNested<A> withNewFrom() {
        return new FromNested(null);
    }

    public FromNested<A> withNewFromLike(ObjectReference item) {
        return new FromNested(item);
    }

    public PullSecretNested<A> withNewPullSecret() {
        return new PullSecretNested(null);
    }

    public A withNewPullSecret(String name) {
        return this.withPullSecret(new LocalObjectReference(name));
    }

    public PullSecretNested<A> withNewPullSecretLike(LocalObjectReference item) {
        return new PullSecretNested(item);
    }

    public A withPullSecret(LocalObjectReference pullSecret) {
        this._visitables.remove((Object)"pullSecret");
        if (pullSecret != null) {
            this.pullSecret = new LocalObjectReferenceBuilder(pullSecret);
            this._visitables.get((Object)"pullSecret").add(this.pullSecret);
        } else {
            this.pullSecret = null;
            this._visitables.get((Object)"pullSecret").remove(this.pullSecret);
        }
        return (A)((Object)this);
    }

    public A withSecrets(List<SecretSpec> secrets) {
        if (this.secrets != null) {
            this._visitables.get((Object)"secrets").clear();
        }
        if (secrets != null) {
            this.secrets = new ArrayList();
            for (SecretSpec item : secrets) {
                this.addToSecrets(item);
            }
        } else {
            this.secrets = null;
        }
        return (A)((Object)this);
    }

    public A withSecrets(SecretSpec ... secrets) {
        if (this.secrets != null) {
            this.secrets.clear();
            this._visitables.remove((Object)"secrets");
        }
        if (secrets != null) {
            for (SecretSpec item : secrets) {
                this.addToSecrets(item);
            }
        }
        return (A)((Object)this);
    }

    public class SecretsNested<N>
    extends SecretSpecFluent<SecretsNested<N>>
    implements Nested<N> {
        SecretSpecBuilder builder;
        int index;

        SecretsNested(int index, SecretSpec item) {
            this.index = index;
            this.builder = new SecretSpecBuilder(this, item);
        }

        public N and() {
            return (N)CustomBuildStrategyFluent.this.setToSecrets(this.index, this.builder.build());
        }

        public N endSecret() {
            return this.and();
        }
    }

    public class PullSecretNested<N>
    extends LocalObjectReferenceFluent<PullSecretNested<N>>
    implements Nested<N> {
        LocalObjectReferenceBuilder builder;

        PullSecretNested(LocalObjectReference item) {
            this.builder = new LocalObjectReferenceBuilder((LocalObjectReferenceFluent)this, item);
        }

        public N and() {
            return (N)CustomBuildStrategyFluent.this.withPullSecret(this.builder.build());
        }

        public N endPullSecret() {
            return this.and();
        }
    }

    public class FromNested<N>
    extends ObjectReferenceFluent<FromNested<N>>
    implements Nested<N> {
        ObjectReferenceBuilder builder;

        FromNested(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder((ObjectReferenceFluent)this, item);
        }

        public N and() {
            return (N)CustomBuildStrategyFluent.this.withFrom(this.builder.build());
        }

        public N endFrom() {
            return this.and();
        }
    }

    public class EnvNested<N>
    extends EnvVarFluent<EnvNested<N>>
    implements Nested<N> {
        EnvVarBuilder builder;
        int index;

        EnvNested(int index, EnvVar item) {
            this.index = index;
            this.builder = new EnvVarBuilder((EnvVarFluent)this, item);
        }

        public N and() {
            return (N)CustomBuildStrategyFluent.this.setToEnv(this.index, this.builder.build());
        }

        public N endEnv() {
            return this.and();
        }
    }
}

