/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.config.v1.ExtraMapping;
import io.fabric8.openshift.api.model.config.v1.ExtraMappingBuilder;
import io.fabric8.openshift.api.model.config.v1.ExtraMappingFluent;
import io.fabric8.openshift.api.model.config.v1.PrefixedClaimMapping;
import io.fabric8.openshift.api.model.config.v1.PrefixedClaimMappingBuilder;
import io.fabric8.openshift.api.model.config.v1.PrefixedClaimMappingFluent;
import io.fabric8.openshift.api.model.config.v1.TokenClaimMappings;
import io.fabric8.openshift.api.model.config.v1.TokenClaimOrExpressionMapping;
import io.fabric8.openshift.api.model.config.v1.TokenClaimOrExpressionMappingBuilder;
import io.fabric8.openshift.api.model.config.v1.TokenClaimOrExpressionMappingFluent;
import io.fabric8.openshift.api.model.config.v1.UsernameClaimMapping;
import io.fabric8.openshift.api.model.config.v1.UsernameClaimMappingBuilder;
import io.fabric8.openshift.api.model.config.v1.UsernameClaimMappingFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class TokenClaimMappingsFluent<A extends TokenClaimMappingsFluent<A>>
extends BaseFluent<A> {
    private ArrayList<ExtraMappingBuilder> extra = new ArrayList();
    private PrefixedClaimMappingBuilder groups;
    private TokenClaimOrExpressionMappingBuilder uid;
    private UsernameClaimMappingBuilder username;
    private Map<String, Object> additionalProperties;

    public TokenClaimMappingsFluent() {
    }

    public TokenClaimMappingsFluent(TokenClaimMappings instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(TokenClaimMappings instance) {
        TokenClaimMappings tokenClaimMappings = instance = instance != null ? instance : new TokenClaimMappings();
        if (instance != null) {
            this.withExtra(instance.getExtra());
            this.withGroups(instance.getGroups());
            this.withUid(instance.getUid());
            this.withUsername(instance.getUsername());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToExtra(int index, ExtraMapping item) {
        if (this.extra == null) {
            this.extra = new ArrayList();
        }
        ExtraMappingBuilder builder = new ExtraMappingBuilder(item);
        if (index < 0 || index >= this.extra.size()) {
            this._visitables.get((Object)"extra").add(builder);
            this.extra.add(builder);
        } else {
            this._visitables.get((Object)"extra").add(builder);
            this.extra.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToExtra(int index, ExtraMapping item) {
        if (this.extra == null) {
            this.extra = new ArrayList();
        }
        ExtraMappingBuilder builder = new ExtraMappingBuilder(item);
        if (index < 0 || index >= this.extra.size()) {
            this._visitables.get((Object)"extra").add(builder);
            this.extra.add(builder);
        } else {
            this._visitables.get((Object)"extra").add(builder);
            this.extra.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToExtra(ExtraMapping ... items) {
        if (this.extra == null) {
            this.extra = new ArrayList();
        }
        for (ExtraMapping item : items) {
            ExtraMappingBuilder builder = new ExtraMappingBuilder(item);
            this._visitables.get((Object)"extra").add(builder);
            this.extra.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToExtra(Collection<ExtraMapping> items) {
        if (this.extra == null) {
            this.extra = new ArrayList();
        }
        for (ExtraMapping item : items) {
            ExtraMappingBuilder builder = new ExtraMappingBuilder(item);
            this._visitables.get((Object)"extra").add(builder);
            this.extra.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromExtra(ExtraMapping ... items) {
        if (this.extra == null) {
            return (A)((Object)this);
        }
        for (ExtraMapping item : items) {
            ExtraMappingBuilder builder = new ExtraMappingBuilder(item);
            this._visitables.get((Object)"extra").remove((Object)builder);
            this.extra.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromExtra(Collection<ExtraMapping> items) {
        if (this.extra == null) {
            return (A)((Object)this);
        }
        for (ExtraMapping item : items) {
            ExtraMappingBuilder builder = new ExtraMappingBuilder(item);
            this._visitables.get((Object)"extra").remove((Object)builder);
            this.extra.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromExtra(Predicate<ExtraMappingBuilder> predicate) {
        if (this.extra == null) {
            return (A)((Object)this);
        }
        Iterator<ExtraMappingBuilder> each = this.extra.iterator();
        List visitables = this._visitables.get((Object)"extra");
        while (each.hasNext()) {
            ExtraMappingBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<ExtraMapping> buildExtra() {
        return this.extra != null ? TokenClaimMappingsFluent.build(this.extra) : null;
    }

    public ExtraMapping buildExtra(int index) {
        return this.extra.get(index).build();
    }

    public ExtraMapping buildFirstExtra() {
        return this.extra.get(0).build();
    }

    public ExtraMapping buildLastExtra() {
        return this.extra.get(this.extra.size() - 1).build();
    }

    public ExtraMapping buildMatchingExtra(Predicate<ExtraMappingBuilder> predicate) {
        for (ExtraMappingBuilder item : this.extra) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingExtra(Predicate<ExtraMappingBuilder> predicate) {
        for (ExtraMappingBuilder item : this.extra) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withExtra(List<ExtraMapping> extra) {
        if (this.extra != null) {
            this._visitables.get((Object)"extra").clear();
        }
        if (extra != null) {
            this.extra = new ArrayList();
            for (ExtraMapping item : extra) {
                this.addToExtra(item);
            }
        } else {
            this.extra = null;
        }
        return (A)((Object)this);
    }

    public A withExtra(ExtraMapping ... extra) {
        if (this.extra != null) {
            this.extra.clear();
            this._visitables.remove((Object)"extra");
        }
        if (extra != null) {
            for (ExtraMapping item : extra) {
                this.addToExtra(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasExtra() {
        return this.extra != null && !this.extra.isEmpty();
    }

    public A addNewExtra(String key, String valueExpression) {
        return this.addToExtra(new ExtraMapping(key, valueExpression));
    }

    public ExtraNested<A> addNewExtra() {
        return new ExtraNested(-1, null);
    }

    public ExtraNested<A> addNewExtraLike(ExtraMapping item) {
        return new ExtraNested(-1, item);
    }

    public ExtraNested<A> setNewExtraLike(int index, ExtraMapping item) {
        return new ExtraNested(index, item);
    }

    public ExtraNested<A> editExtra(int index) {
        if (this.extra.size() <= index) {
            throw new RuntimeException("Can't edit extra. Index exceeds size.");
        }
        return this.setNewExtraLike(index, this.buildExtra(index));
    }

    public ExtraNested<A> editFirstExtra() {
        if (this.extra.size() == 0) {
            throw new RuntimeException("Can't edit first extra. The list is empty.");
        }
        return this.setNewExtraLike(0, this.buildExtra(0));
    }

    public ExtraNested<A> editLastExtra() {
        int index = this.extra.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last extra. The list is empty.");
        }
        return this.setNewExtraLike(index, this.buildExtra(index));
    }

    public ExtraNested<A> editMatchingExtra(Predicate<ExtraMappingBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.extra.size(); ++i) {
            if (!predicate.test(this.extra.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching extra. No match found.");
        }
        return this.setNewExtraLike(index, this.buildExtra(index));
    }

    public PrefixedClaimMapping buildGroups() {
        return this.groups != null ? this.groups.build() : null;
    }

    public A withGroups(PrefixedClaimMapping groups) {
        this._visitables.remove((Object)"groups");
        if (groups != null) {
            this.groups = new PrefixedClaimMappingBuilder(groups);
            this._visitables.get((Object)"groups").add(this.groups);
        } else {
            this.groups = null;
            this._visitables.get((Object)"groups").remove((Object)this.groups);
        }
        return (A)((Object)this);
    }

    public boolean hasGroups() {
        return this.groups != null;
    }

    public A withNewGroups(String claim, String prefix) {
        return this.withGroups(new PrefixedClaimMapping(claim, prefix));
    }

    public GroupsNested<A> withNewGroups() {
        return new GroupsNested(null);
    }

    public GroupsNested<A> withNewGroupsLike(PrefixedClaimMapping item) {
        return new GroupsNested(item);
    }

    public GroupsNested<A> editGroups() {
        return this.withNewGroupsLike(Optional.ofNullable(this.buildGroups()).orElse(null));
    }

    public GroupsNested<A> editOrNewGroups() {
        return this.withNewGroupsLike(Optional.ofNullable(this.buildGroups()).orElse(new PrefixedClaimMappingBuilder().build()));
    }

    public GroupsNested<A> editOrNewGroupsLike(PrefixedClaimMapping item) {
        return this.withNewGroupsLike(Optional.ofNullable(this.buildGroups()).orElse(item));
    }

    public TokenClaimOrExpressionMapping buildUid() {
        return this.uid != null ? this.uid.build() : null;
    }

    public A withUid(TokenClaimOrExpressionMapping uid) {
        this._visitables.remove((Object)"uid");
        if (uid != null) {
            this.uid = new TokenClaimOrExpressionMappingBuilder(uid);
            this._visitables.get((Object)"uid").add(this.uid);
        } else {
            this.uid = null;
            this._visitables.get((Object)"uid").remove((Object)this.uid);
        }
        return (A)((Object)this);
    }

    public boolean hasUid() {
        return this.uid != null;
    }

    public A withNewUid(String claim, String expression) {
        return this.withUid(new TokenClaimOrExpressionMapping(claim, expression));
    }

    public UidNested<A> withNewUid() {
        return new UidNested(null);
    }

    public UidNested<A> withNewUidLike(TokenClaimOrExpressionMapping item) {
        return new UidNested(item);
    }

    public UidNested<A> editUid() {
        return this.withNewUidLike(Optional.ofNullable(this.buildUid()).orElse(null));
    }

    public UidNested<A> editOrNewUid() {
        return this.withNewUidLike(Optional.ofNullable(this.buildUid()).orElse(new TokenClaimOrExpressionMappingBuilder().build()));
    }

    public UidNested<A> editOrNewUidLike(TokenClaimOrExpressionMapping item) {
        return this.withNewUidLike(Optional.ofNullable(this.buildUid()).orElse(item));
    }

    public UsernameClaimMapping buildUsername() {
        return this.username != null ? this.username.build() : null;
    }

    public A withUsername(UsernameClaimMapping username) {
        this._visitables.remove((Object)"username");
        if (username != null) {
            this.username = new UsernameClaimMappingBuilder(username);
            this._visitables.get((Object)"username").add(this.username);
        } else {
            this.username = null;
            this._visitables.get((Object)"username").remove((Object)this.username);
        }
        return (A)((Object)this);
    }

    public boolean hasUsername() {
        return this.username != null;
    }

    public UsernameNested<A> withNewUsername() {
        return new UsernameNested(null);
    }

    public UsernameNested<A> withNewUsernameLike(UsernameClaimMapping item) {
        return new UsernameNested(item);
    }

    public UsernameNested<A> editUsername() {
        return this.withNewUsernameLike(Optional.ofNullable(this.buildUsername()).orElse(null));
    }

    public UsernameNested<A> editOrNewUsername() {
        return this.withNewUsernameLike(Optional.ofNullable(this.buildUsername()).orElse(new UsernameClaimMappingBuilder().build()));
    }

    public UsernameNested<A> editOrNewUsernameLike(UsernameClaimMapping item) {
        return this.withNewUsernameLike(Optional.ofNullable(this.buildUsername()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TokenClaimMappingsFluent that = (TokenClaimMappingsFluent)((Object)o);
        if (!Objects.equals(this.extra, that.extra)) {
            return false;
        }
        if (!Objects.equals((Object)this.groups, (Object)that.groups)) {
            return false;
        }
        if (!Objects.equals((Object)this.uid, (Object)that.uid)) {
            return false;
        }
        if (!Objects.equals((Object)this.username, (Object)that.username)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.extra, this.groups, this.uid, this.username, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.extra != null && !this.extra.isEmpty()) {
            sb.append("extra:");
            sb.append(String.valueOf(this.extra) + ",");
        }
        if (this.groups != null) {
            sb.append("groups:");
            sb.append(String.valueOf((Object)this.groups) + ",");
        }
        if (this.uid != null) {
            sb.append("uid:");
            sb.append(String.valueOf((Object)this.uid) + ",");
        }
        if (this.username != null) {
            sb.append("username:");
            sb.append(String.valueOf((Object)this.username) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class UsernameNested<N>
    extends UsernameClaimMappingFluent<UsernameNested<N>>
    implements Nested<N> {
        UsernameClaimMappingBuilder builder;

        UsernameNested(UsernameClaimMapping item) {
            this.builder = new UsernameClaimMappingBuilder(this, item);
        }

        public N and() {
            return (N)TokenClaimMappingsFluent.this.withUsername(this.builder.build());
        }

        public N endUsername() {
            return this.and();
        }
    }

    public class UidNested<N>
    extends TokenClaimOrExpressionMappingFluent<UidNested<N>>
    implements Nested<N> {
        TokenClaimOrExpressionMappingBuilder builder;

        UidNested(TokenClaimOrExpressionMapping item) {
            this.builder = new TokenClaimOrExpressionMappingBuilder(this, item);
        }

        public N and() {
            return (N)TokenClaimMappingsFluent.this.withUid(this.builder.build());
        }

        public N endUid() {
            return this.and();
        }
    }

    public class GroupsNested<N>
    extends PrefixedClaimMappingFluent<GroupsNested<N>>
    implements Nested<N> {
        PrefixedClaimMappingBuilder builder;

        GroupsNested(PrefixedClaimMapping item) {
            this.builder = new PrefixedClaimMappingBuilder(this, item);
        }

        public N and() {
            return (N)TokenClaimMappingsFluent.this.withGroups(this.builder.build());
        }

        public N endGroups() {
            return this.and();
        }
    }

    public class ExtraNested<N>
    extends ExtraMappingFluent<ExtraNested<N>>
    implements Nested<N> {
        ExtraMappingBuilder builder;
        int index;

        ExtraNested(int index, ExtraMapping item) {
            this.index = index;
            this.builder = new ExtraMappingBuilder(this, item);
        }

        public N and() {
            return (N)TokenClaimMappingsFluent.this.setToExtra(this.index, this.builder.build());
        }

        public N endExtra() {
            return this.and();
        }
    }
}

