package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ImageImportSpecBuilder extends ImageImportSpecFluent<ImageImportSpecBuilder> implements VisitableBuilder<ImageImportSpec,ImageImportSpecBuilder>{
  public ImageImportSpecBuilder() {
    this(new ImageImportSpec());
  }
  
  public ImageImportSpecBuilder(ImageImportSpecFluent<?> fluent) {
    this(fluent, new ImageImportSpec());
  }
  
  public ImageImportSpecBuilder(ImageImportSpecFluent<?> fluent,ImageImportSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ImageImportSpecBuilder(ImageImportSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ImageImportSpecFluent<?> fluent;
  
  public ImageImportSpec build() {
    ImageImportSpec buildable = new ImageImportSpec(fluent.buildFrom(),fluent.buildImportPolicy(),fluent.getIncludeManifest(),fluent.buildReferencePolicy(),fluent.buildTo());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}