package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ConfigMapBuildSourceBuilder extends ConfigMapBuildSourceFluent<ConfigMapBuildSourceBuilder> implements VisitableBuilder<ConfigMapBuildSource,ConfigMapBuildSourceBuilder>{
  public ConfigMapBuildSourceBuilder() {
    this(new ConfigMapBuildSource());
  }
  
  public ConfigMapBuildSourceBuilder(ConfigMapBuildSourceFluent<?> fluent) {
    this(fluent, new ConfigMapBuildSource());
  }
  
  public ConfigMapBuildSourceBuilder(ConfigMapBuildSourceFluent<?> fluent,ConfigMapBuildSource instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ConfigMapBuildSourceBuilder(ConfigMapBuildSource instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ConfigMapBuildSourceFluent<?> fluent;
  
  public ConfigMapBuildSource build() {
    ConfigMapBuildSource buildable = new ConfigMapBuildSource(fluent.buildConfigMap(),fluent.getDestinationDir());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}