/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.openshift.api.model.RepositoryImportSpec;
import io.fabric8.openshift.api.model.TagImportPolicy;
import io.fabric8.openshift.api.model.TagImportPolicyBuilder;
import io.fabric8.openshift.api.model.TagImportPolicyFluent;
import io.fabric8.openshift.api.model.TagReferencePolicy;
import io.fabric8.openshift.api.model.TagReferencePolicyBuilder;
import io.fabric8.openshift.api.model.TagReferencePolicyFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class RepositoryImportSpecFluent<A extends RepositoryImportSpecFluent<A>>
extends BaseFluent<A> {
    private ObjectReferenceBuilder from;
    private TagImportPolicyBuilder importPolicy;
    private Boolean includeManifest;
    private TagReferencePolicyBuilder referencePolicy;
    private Map<String, Object> additionalProperties;

    public RepositoryImportSpecFluent() {
    }

    public RepositoryImportSpecFluent(RepositoryImportSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(RepositoryImportSpec instance) {
        RepositoryImportSpec repositoryImportSpec = instance = instance != null ? instance : new RepositoryImportSpec();
        if (instance != null) {
            this.withFrom(instance.getFrom());
            this.withImportPolicy(instance.getImportPolicy());
            this.withIncludeManifest(instance.getIncludeManifest());
            this.withReferencePolicy(instance.getReferencePolicy());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public ObjectReference buildFrom() {
        return this.from != null ? this.from.build() : null;
    }

    public A withFrom(ObjectReference from) {
        this._visitables.remove((Object)"from");
        if (from != null) {
            this.from = new ObjectReferenceBuilder(from);
            this._visitables.get((Object)"from").add(this.from);
        } else {
            this.from = null;
            this._visitables.get((Object)"from").remove(this.from);
        }
        return (A)((Object)this);
    }

    public boolean hasFrom() {
        return this.from != null;
    }

    public FromNested<A> withNewFrom() {
        return new FromNested(null);
    }

    public FromNested<A> withNewFromLike(ObjectReference item) {
        return new FromNested(item);
    }

    public FromNested<A> editFrom() {
        return this.withNewFromLike(Optional.ofNullable(this.buildFrom()).orElse(null));
    }

    public FromNested<A> editOrNewFrom() {
        return this.withNewFromLike(Optional.ofNullable(this.buildFrom()).orElse(new ObjectReferenceBuilder().build()));
    }

    public FromNested<A> editOrNewFromLike(ObjectReference item) {
        return this.withNewFromLike(Optional.ofNullable(this.buildFrom()).orElse(item));
    }

    public TagImportPolicy buildImportPolicy() {
        return this.importPolicy != null ? this.importPolicy.build() : null;
    }

    public A withImportPolicy(TagImportPolicy importPolicy) {
        this._visitables.remove((Object)"importPolicy");
        if (importPolicy != null) {
            this.importPolicy = new TagImportPolicyBuilder(importPolicy);
            this._visitables.get((Object)"importPolicy").add(this.importPolicy);
        } else {
            this.importPolicy = null;
            this._visitables.get((Object)"importPolicy").remove((Object)this.importPolicy);
        }
        return (A)((Object)this);
    }

    public boolean hasImportPolicy() {
        return this.importPolicy != null;
    }

    public A withNewImportPolicy(String importMode, Boolean insecure, Boolean scheduled) {
        return this.withImportPolicy(new TagImportPolicy(importMode, insecure, scheduled));
    }

    public ImportPolicyNested<A> withNewImportPolicy() {
        return new ImportPolicyNested(null);
    }

    public ImportPolicyNested<A> withNewImportPolicyLike(TagImportPolicy item) {
        return new ImportPolicyNested(item);
    }

    public ImportPolicyNested<A> editImportPolicy() {
        return this.withNewImportPolicyLike(Optional.ofNullable(this.buildImportPolicy()).orElse(null));
    }

    public ImportPolicyNested<A> editOrNewImportPolicy() {
        return this.withNewImportPolicyLike(Optional.ofNullable(this.buildImportPolicy()).orElse(new TagImportPolicyBuilder().build()));
    }

    public ImportPolicyNested<A> editOrNewImportPolicyLike(TagImportPolicy item) {
        return this.withNewImportPolicyLike(Optional.ofNullable(this.buildImportPolicy()).orElse(item));
    }

    public Boolean getIncludeManifest() {
        return this.includeManifest;
    }

    public A withIncludeManifest(Boolean includeManifest) {
        this.includeManifest = includeManifest;
        return (A)((Object)this);
    }

    public boolean hasIncludeManifest() {
        return this.includeManifest != null;
    }

    public TagReferencePolicy buildReferencePolicy() {
        return this.referencePolicy != null ? this.referencePolicy.build() : null;
    }

    public A withReferencePolicy(TagReferencePolicy referencePolicy) {
        this._visitables.remove((Object)"referencePolicy");
        if (referencePolicy != null) {
            this.referencePolicy = new TagReferencePolicyBuilder(referencePolicy);
            this._visitables.get((Object)"referencePolicy").add(this.referencePolicy);
        } else {
            this.referencePolicy = null;
            this._visitables.get((Object)"referencePolicy").remove((Object)this.referencePolicy);
        }
        return (A)((Object)this);
    }

    public boolean hasReferencePolicy() {
        return this.referencePolicy != null;
    }

    public A withNewReferencePolicy(String type) {
        return this.withReferencePolicy(new TagReferencePolicy(type));
    }

    public ReferencePolicyNested<A> withNewReferencePolicy() {
        return new ReferencePolicyNested(null);
    }

    public ReferencePolicyNested<A> withNewReferencePolicyLike(TagReferencePolicy item) {
        return new ReferencePolicyNested(item);
    }

    public ReferencePolicyNested<A> editReferencePolicy() {
        return this.withNewReferencePolicyLike(Optional.ofNullable(this.buildReferencePolicy()).orElse(null));
    }

    public ReferencePolicyNested<A> editOrNewReferencePolicy() {
        return this.withNewReferencePolicyLike(Optional.ofNullable(this.buildReferencePolicy()).orElse(new TagReferencePolicyBuilder().build()));
    }

    public ReferencePolicyNested<A> editOrNewReferencePolicyLike(TagReferencePolicy item) {
        return this.withNewReferencePolicyLike(Optional.ofNullable(this.buildReferencePolicy()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RepositoryImportSpecFluent that = (RepositoryImportSpecFluent)((Object)o);
        if (!Objects.equals(this.from, that.from)) {
            return false;
        }
        if (!Objects.equals((Object)this.importPolicy, (Object)that.importPolicy)) {
            return false;
        }
        if (!Objects.equals(this.includeManifest, that.includeManifest)) {
            return false;
        }
        if (!Objects.equals((Object)this.referencePolicy, (Object)that.referencePolicy)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.from, this.importPolicy, this.includeManifest, this.referencePolicy, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.from != null) {
            sb.append("from:");
            sb.append(String.valueOf(this.from) + ",");
        }
        if (this.importPolicy != null) {
            sb.append("importPolicy:");
            sb.append(String.valueOf((Object)this.importPolicy) + ",");
        }
        if (this.includeManifest != null) {
            sb.append("includeManifest:");
            sb.append(this.includeManifest + ",");
        }
        if (this.referencePolicy != null) {
            sb.append("referencePolicy:");
            sb.append(String.valueOf((Object)this.referencePolicy) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withIncludeManifest() {
        return this.withIncludeManifest(true);
    }

    public class ReferencePolicyNested<N>
    extends TagReferencePolicyFluent<ReferencePolicyNested<N>>
    implements Nested<N> {
        TagReferencePolicyBuilder builder;

        ReferencePolicyNested(TagReferencePolicy item) {
            this.builder = new TagReferencePolicyBuilder(this, item);
        }

        public N and() {
            return (N)RepositoryImportSpecFluent.this.withReferencePolicy(this.builder.build());
        }

        public N endReferencePolicy() {
            return this.and();
        }
    }

    public class ImportPolicyNested<N>
    extends TagImportPolicyFluent<ImportPolicyNested<N>>
    implements Nested<N> {
        TagImportPolicyBuilder builder;

        ImportPolicyNested(TagImportPolicy item) {
            this.builder = new TagImportPolicyBuilder(this, item);
        }

        public N and() {
            return (N)RepositoryImportSpecFluent.this.withImportPolicy(this.builder.build());
        }

        public N endImportPolicy() {
            return this.and();
        }
    }

    public class FromNested<N>
    extends ObjectReferenceFluent<FromNested<N>>
    implements Nested<N> {
        ObjectReferenceBuilder builder;

        FromNested(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder((ObjectReferenceFluent)this, item);
        }

        public N and() {
            return (N)RepositoryImportSpecFluent.this.withFrom(this.builder.build());
        }

        public N endFrom() {
            return this.and();
        }
    }
}

