/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.NamedTagEventList;
import io.fabric8.openshift.api.model.TagEvent;
import io.fabric8.openshift.api.model.TagEventBuilder;
import io.fabric8.openshift.api.model.TagEventCondition;
import io.fabric8.openshift.api.model.TagEventConditionBuilder;
import io.fabric8.openshift.api.model.TagEventConditionFluent;
import io.fabric8.openshift.api.model.TagEventFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class NamedTagEventListFluent<A extends NamedTagEventListFluent<A>>
extends BaseFluent<A> {
    private ArrayList<TagEventConditionBuilder> conditions = new ArrayList();
    private ArrayList<TagEventBuilder> items = new ArrayList();
    private String tag;
    private Map<String, Object> additionalProperties;

    public NamedTagEventListFluent() {
    }

    public NamedTagEventListFluent(NamedTagEventList instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(NamedTagEventList instance) {
        NamedTagEventList namedTagEventList = instance = instance != null ? instance : new NamedTagEventList();
        if (instance != null) {
            this.withConditions(instance.getConditions());
            this.withItems(instance.getItems());
            this.withTag(instance.getTag());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToConditions(int index, TagEventCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        TagEventConditionBuilder builder = new TagEventConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToConditions(int index, TagEventCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        TagEventConditionBuilder builder = new TagEventConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToConditions(TagEventCondition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (TagEventCondition item : items) {
            TagEventConditionBuilder builder = new TagEventConditionBuilder(item);
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToConditions(Collection<TagEventCondition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (TagEventCondition item : items) {
            TagEventConditionBuilder builder = new TagEventConditionBuilder(item);
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromConditions(TagEventCondition ... items) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        for (TagEventCondition item : items) {
            TagEventConditionBuilder builder = new TagEventConditionBuilder(item);
            this._visitables.get((Object)"conditions").remove((Object)builder);
            this.conditions.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromConditions(Collection<TagEventCondition> items) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        for (TagEventCondition item : items) {
            TagEventConditionBuilder builder = new TagEventConditionBuilder(item);
            this._visitables.get((Object)"conditions").remove((Object)builder);
            this.conditions.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromConditions(Predicate<TagEventConditionBuilder> predicate) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        Iterator<TagEventConditionBuilder> each = this.conditions.iterator();
        List visitables = this._visitables.get((Object)"conditions");
        while (each.hasNext()) {
            TagEventConditionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<TagEventCondition> buildConditions() {
        return this.conditions != null ? NamedTagEventListFluent.build(this.conditions) : null;
    }

    public TagEventCondition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    public TagEventCondition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    public TagEventCondition buildLastCondition() {
        return this.conditions.get(this.conditions.size() - 1).build();
    }

    public TagEventCondition buildMatchingCondition(Predicate<TagEventConditionBuilder> predicate) {
        for (TagEventConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingCondition(Predicate<TagEventConditionBuilder> predicate) {
        for (TagEventConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withConditions(List<TagEventCondition> conditions) {
        if (this.conditions != null) {
            this._visitables.get((Object)"conditions").clear();
        }
        if (conditions != null) {
            this.conditions = new ArrayList();
            for (TagEventCondition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)((Object)this);
    }

    public A withConditions(TagEventCondition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
            this._visitables.remove((Object)"conditions");
        }
        if (conditions != null) {
            for (TagEventCondition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    public ConditionsNested<A> addNewCondition() {
        return new ConditionsNested(-1, null);
    }

    public ConditionsNested<A> addNewConditionLike(TagEventCondition item) {
        return new ConditionsNested(-1, item);
    }

    public ConditionsNested<A> setNewConditionLike(int index, TagEventCondition item) {
        return new ConditionsNested(index, item);
    }

    public ConditionsNested<A> editCondition(int index) {
        if (this.conditions.size() <= index) {
            throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ConditionsNested<A> editFirstCondition() {
        if (this.conditions.size() == 0) {
            throw new RuntimeException("Can't edit first conditions. The list is empty.");
        }
        return this.setNewConditionLike(0, this.buildCondition(0));
    }

    public ConditionsNested<A> editLastCondition() {
        int index = this.conditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last conditions. The list is empty.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ConditionsNested<A> editMatchingCondition(Predicate<TagEventConditionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.conditions.size(); ++i) {
            if (!predicate.test(this.conditions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching conditions. No match found.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public A addToItems(int index, TagEvent item) {
        if (this.items == null) {
            this.items = new ArrayList();
        }
        TagEventBuilder builder = new TagEventBuilder(item);
        if (index < 0 || index >= this.items.size()) {
            this._visitables.get((Object)"items").add(builder);
            this.items.add(builder);
        } else {
            this._visitables.get((Object)"items").add(builder);
            this.items.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToItems(int index, TagEvent item) {
        if (this.items == null) {
            this.items = new ArrayList();
        }
        TagEventBuilder builder = new TagEventBuilder(item);
        if (index < 0 || index >= this.items.size()) {
            this._visitables.get((Object)"items").add(builder);
            this.items.add(builder);
        } else {
            this._visitables.get((Object)"items").add(builder);
            this.items.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToItems(TagEvent ... items) {
        if (this.items == null) {
            this.items = new ArrayList();
        }
        for (TagEvent item : items) {
            TagEventBuilder builder = new TagEventBuilder(item);
            this._visitables.get((Object)"items").add(builder);
            this.items.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToItems(Collection<TagEvent> items) {
        if (this.items == null) {
            this.items = new ArrayList();
        }
        for (TagEvent item : items) {
            TagEventBuilder builder = new TagEventBuilder(item);
            this._visitables.get((Object)"items").add(builder);
            this.items.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromItems(TagEvent ... items) {
        if (this.items == null) {
            return (A)((Object)this);
        }
        for (TagEvent item : items) {
            TagEventBuilder builder = new TagEventBuilder(item);
            this._visitables.get((Object)"items").remove((Object)builder);
            this.items.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromItems(Collection<TagEvent> items) {
        if (this.items == null) {
            return (A)((Object)this);
        }
        for (TagEvent item : items) {
            TagEventBuilder builder = new TagEventBuilder(item);
            this._visitables.get((Object)"items").remove((Object)builder);
            this.items.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromItems(Predicate<TagEventBuilder> predicate) {
        if (this.items == null) {
            return (A)((Object)this);
        }
        Iterator<TagEventBuilder> each = this.items.iterator();
        List visitables = this._visitables.get((Object)"items");
        while (each.hasNext()) {
            TagEventBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<TagEvent> buildItems() {
        return this.items != null ? NamedTagEventListFluent.build(this.items) : null;
    }

    public TagEvent buildItem(int index) {
        return this.items.get(index).build();
    }

    public TagEvent buildFirstItem() {
        return this.items.get(0).build();
    }

    public TagEvent buildLastItem() {
        return this.items.get(this.items.size() - 1).build();
    }

    public TagEvent buildMatchingItem(Predicate<TagEventBuilder> predicate) {
        for (TagEventBuilder item : this.items) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingItem(Predicate<TagEventBuilder> predicate) {
        for (TagEventBuilder item : this.items) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withItems(List<TagEvent> items) {
        if (this.items != null) {
            this._visitables.get((Object)"items").clear();
        }
        if (items != null) {
            this.items = new ArrayList();
            for (TagEvent item : items) {
                this.addToItems(item);
            }
        } else {
            this.items = null;
        }
        return (A)((Object)this);
    }

    public A withItems(TagEvent ... items) {
        if (this.items != null) {
            this.items.clear();
            this._visitables.remove((Object)"items");
        }
        if (items != null) {
            for (TagEvent item : items) {
                this.addToItems(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasItems() {
        return this.items != null && !this.items.isEmpty();
    }

    public A addNewItem(String created, String dockerImageReference, Long generation, String image) {
        return this.addToItems(new TagEvent(created, dockerImageReference, generation, image));
    }

    public ItemsNested<A> addNewItem() {
        return new ItemsNested(-1, null);
    }

    public ItemsNested<A> addNewItemLike(TagEvent item) {
        return new ItemsNested(-1, item);
    }

    public ItemsNested<A> setNewItemLike(int index, TagEvent item) {
        return new ItemsNested(index, item);
    }

    public ItemsNested<A> editItem(int index) {
        if (this.items.size() <= index) {
            throw new RuntimeException("Can't edit items. Index exceeds size.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    public ItemsNested<A> editFirstItem() {
        if (this.items.size() == 0) {
            throw new RuntimeException("Can't edit first items. The list is empty.");
        }
        return this.setNewItemLike(0, this.buildItem(0));
    }

    public ItemsNested<A> editLastItem() {
        int index = this.items.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last items. The list is empty.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    public ItemsNested<A> editMatchingItem(Predicate<TagEventBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.items.size(); ++i) {
            if (!predicate.test(this.items.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching items. No match found.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    public String getTag() {
        return this.tag;
    }

    public A withTag(String tag) {
        this.tag = tag;
        return (A)((Object)this);
    }

    public boolean hasTag() {
        return this.tag != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NamedTagEventListFluent that = (NamedTagEventListFluent)((Object)o);
        if (!Objects.equals(this.conditions, that.conditions)) {
            return false;
        }
        if (!Objects.equals(this.items, that.items)) {
            return false;
        }
        if (!Objects.equals(this.tag, that.tag)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.conditions, this.items, this.tag, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.conditions != null && !this.conditions.isEmpty()) {
            sb.append("conditions:");
            sb.append(String.valueOf(this.conditions) + ",");
        }
        if (this.items != null && !this.items.isEmpty()) {
            sb.append("items:");
            sb.append(String.valueOf(this.items) + ",");
        }
        if (this.tag != null) {
            sb.append("tag:");
            sb.append(this.tag + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ItemsNested<N>
    extends TagEventFluent<ItemsNested<N>>
    implements Nested<N> {
        TagEventBuilder builder;
        int index;

        ItemsNested(int index, TagEvent item) {
            this.index = index;
            this.builder = new TagEventBuilder(this, item);
        }

        public N and() {
            return (N)NamedTagEventListFluent.this.setToItems(this.index, this.builder.build());
        }

        public N endItem() {
            return this.and();
        }
    }

    public class ConditionsNested<N>
    extends TagEventConditionFluent<ConditionsNested<N>>
    implements Nested<N> {
        TagEventConditionBuilder builder;
        int index;

        ConditionsNested(int index, TagEventCondition item) {
            this.index = index;
            this.builder = new TagEventConditionBuilder(this, item);
        }

        public N and() {
            return (N)NamedTagEventListFluent.this.setToConditions(this.index, this.builder.build());
        }

        public N endCondition() {
            return this.and();
        }
    }
}

