/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.openshift.api.model.ImageSource;
import io.fabric8.openshift.api.model.ImageSourcePath;
import io.fabric8.openshift.api.model.ImageSourcePathBuilder;
import io.fabric8.openshift.api.model.ImageSourcePathFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class ImageSourceFluent<A extends ImageSourceFluent<A>>
extends BaseFluent<A> {
    private List<String> as = new ArrayList<String>();
    private ObjectReferenceBuilder from;
    private ArrayList<ImageSourcePathBuilder> paths = new ArrayList();
    private LocalObjectReferenceBuilder pullSecret;
    private Map<String, Object> additionalProperties;

    public ImageSourceFluent() {
    }

    public ImageSourceFluent(ImageSource instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ImageSource instance) {
        ImageSource imageSource = instance = instance != null ? instance : new ImageSource();
        if (instance != null) {
            this.withAs(instance.getAs());
            this.withFrom(instance.getFrom());
            this.withPaths(instance.getPaths());
            this.withPullSecret(instance.getPullSecret());
            this.withAs(instance.getAs());
            this.withFrom(instance.getFrom());
            this.withPaths(instance.getPaths());
            this.withPullSecret(instance.getPullSecret());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToAs(int index, String item) {
        if (this.as == null) {
            this.as = new ArrayList<String>();
        }
        this.as.add(index, item);
        return (A)((Object)this);
    }

    public A setToAs(int index, String item) {
        if (this.as == null) {
            this.as = new ArrayList<String>();
        }
        this.as.set(index, item);
        return (A)((Object)this);
    }

    public A addToAs(String ... items) {
        if (this.as == null) {
            this.as = new ArrayList<String>();
        }
        for (String item : items) {
            this.as.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToAs(Collection<String> items) {
        if (this.as == null) {
            this.as = new ArrayList<String>();
        }
        for (String item : items) {
            this.as.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromAs(String ... items) {
        if (this.as == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.as.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromAs(Collection<String> items) {
        if (this.as == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.as.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getAs() {
        return this.as;
    }

    public String getA(int index) {
        return this.as.get(index);
    }

    public String getFirstA() {
        return this.as.get(0);
    }

    public String getLastA() {
        return this.as.get(this.as.size() - 1);
    }

    public String getMatchingA(Predicate<String> predicate) {
        for (String item : this.as) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingA(Predicate<String> predicate) {
        for (String item : this.as) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withAs(List<String> as) {
        if (as != null) {
            this.as = new ArrayList<String>();
            for (String item : as) {
                this.addToAs(item);
            }
        } else {
            this.as = null;
        }
        return (A)((Object)this);
    }

    public A withAs(String ... as) {
        if (this.as != null) {
            this.as.clear();
            this._visitables.remove((Object)"as");
        }
        if (as != null) {
            for (String item : as) {
                this.addToAs(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasAs() {
        return this.as != null && !this.as.isEmpty();
    }

    public ObjectReference buildFrom() {
        return this.from != null ? this.from.build() : null;
    }

    public A withFrom(ObjectReference from) {
        this._visitables.remove((Object)this.from);
        if (from != null) {
            this.from = new ObjectReferenceBuilder(from);
            this._visitables.get((Object)"from").add(this.from);
        } else {
            this.from = null;
            this._visitables.get((Object)"from").remove(this.from);
        }
        return (A)((Object)this);
    }

    public boolean hasFrom() {
        return this.from != null;
    }

    public FromNested<A> withNewFrom() {
        return new FromNested(null);
    }

    public FromNested<A> withNewFromLike(ObjectReference item) {
        return new FromNested(item);
    }

    public FromNested<A> editFrom() {
        return this.withNewFromLike(Optional.ofNullable(this.buildFrom()).orElse(null));
    }

    public FromNested<A> editOrNewFrom() {
        return this.withNewFromLike(Optional.ofNullable(this.buildFrom()).orElse(new ObjectReferenceBuilder().build()));
    }

    public FromNested<A> editOrNewFromLike(ObjectReference item) {
        return this.withNewFromLike(Optional.ofNullable(this.buildFrom()).orElse(item));
    }

    public A addToPaths(int index, ImageSourcePath item) {
        if (this.paths == null) {
            this.paths = new ArrayList();
        }
        ImageSourcePathBuilder builder = new ImageSourcePathBuilder(item);
        if (index < 0 || index >= this.paths.size()) {
            this._visitables.get((Object)"paths").add(builder);
            this.paths.add(builder);
        } else {
            this._visitables.get((Object)"paths").add(index, builder);
            this.paths.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToPaths(int index, ImageSourcePath item) {
        if (this.paths == null) {
            this.paths = new ArrayList();
        }
        ImageSourcePathBuilder builder = new ImageSourcePathBuilder(item);
        if (index < 0 || index >= this.paths.size()) {
            this._visitables.get((Object)"paths").add(builder);
            this.paths.add(builder);
        } else {
            this._visitables.get((Object)"paths").set(index, builder);
            this.paths.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToPaths(ImageSourcePath ... items) {
        if (this.paths == null) {
            this.paths = new ArrayList();
        }
        for (ImageSourcePath item : items) {
            ImageSourcePathBuilder builder = new ImageSourcePathBuilder(item);
            this._visitables.get((Object)"paths").add(builder);
            this.paths.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToPaths(Collection<ImageSourcePath> items) {
        if (this.paths == null) {
            this.paths = new ArrayList();
        }
        for (ImageSourcePath item : items) {
            ImageSourcePathBuilder builder = new ImageSourcePathBuilder(item);
            this._visitables.get((Object)"paths").add(builder);
            this.paths.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromPaths(ImageSourcePath ... items) {
        if (this.paths == null) {
            return (A)((Object)this);
        }
        for (ImageSourcePath item : items) {
            ImageSourcePathBuilder builder = new ImageSourcePathBuilder(item);
            this._visitables.get((Object)"paths").remove((Object)builder);
            this.paths.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromPaths(Collection<ImageSourcePath> items) {
        if (this.paths == null) {
            return (A)((Object)this);
        }
        for (ImageSourcePath item : items) {
            ImageSourcePathBuilder builder = new ImageSourcePathBuilder(item);
            this._visitables.get((Object)"paths").remove((Object)builder);
            this.paths.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromPaths(Predicate<ImageSourcePathBuilder> predicate) {
        if (this.paths == null) {
            return (A)((Object)this);
        }
        Iterator<ImageSourcePathBuilder> each = this.paths.iterator();
        List visitables = this._visitables.get((Object)"paths");
        while (each.hasNext()) {
            ImageSourcePathBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<ImageSourcePath> buildPaths() {
        return this.paths != null ? ImageSourceFluent.build(this.paths) : null;
    }

    public ImageSourcePath buildPath(int index) {
        return this.paths.get(index).build();
    }

    public ImageSourcePath buildFirstPath() {
        return this.paths.get(0).build();
    }

    public ImageSourcePath buildLastPath() {
        return this.paths.get(this.paths.size() - 1).build();
    }

    public ImageSourcePath buildMatchingPath(Predicate<ImageSourcePathBuilder> predicate) {
        for (ImageSourcePathBuilder item : this.paths) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingPath(Predicate<ImageSourcePathBuilder> predicate) {
        for (ImageSourcePathBuilder item : this.paths) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withPaths(List<ImageSourcePath> paths) {
        if (this.paths != null) {
            this._visitables.get((Object)"paths").clear();
        }
        if (paths != null) {
            this.paths = new ArrayList();
            for (ImageSourcePath item : paths) {
                this.addToPaths(item);
            }
        } else {
            this.paths = null;
        }
        return (A)((Object)this);
    }

    public A withPaths(ImageSourcePath ... paths) {
        if (this.paths != null) {
            this.paths.clear();
            this._visitables.remove((Object)"paths");
        }
        if (paths != null) {
            for (ImageSourcePath item : paths) {
                this.addToPaths(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasPaths() {
        return this.paths != null && !this.paths.isEmpty();
    }

    public A addNewPath(String destinationDir, String sourcePath) {
        return this.addToPaths(new ImageSourcePath(destinationDir, sourcePath));
    }

    public PathsNested<A> addNewPath() {
        return new PathsNested(-1, null);
    }

    public PathsNested<A> addNewPathLike(ImageSourcePath item) {
        return new PathsNested(-1, item);
    }

    public PathsNested<A> setNewPathLike(int index, ImageSourcePath item) {
        return new PathsNested(index, item);
    }

    public PathsNested<A> editPath(int index) {
        if (this.paths.size() <= index) {
            throw new RuntimeException("Can't edit paths. Index exceeds size.");
        }
        return this.setNewPathLike(index, this.buildPath(index));
    }

    public PathsNested<A> editFirstPath() {
        if (this.paths.size() == 0) {
            throw new RuntimeException("Can't edit first paths. The list is empty.");
        }
        return this.setNewPathLike(0, this.buildPath(0));
    }

    public PathsNested<A> editLastPath() {
        int index = this.paths.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last paths. The list is empty.");
        }
        return this.setNewPathLike(index, this.buildPath(index));
    }

    public PathsNested<A> editMatchingPath(Predicate<ImageSourcePathBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.paths.size(); ++i) {
            if (!predicate.test(this.paths.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching paths. No match found.");
        }
        return this.setNewPathLike(index, this.buildPath(index));
    }

    public LocalObjectReference buildPullSecret() {
        return this.pullSecret != null ? this.pullSecret.build() : null;
    }

    public A withPullSecret(LocalObjectReference pullSecret) {
        this._visitables.remove((Object)this.pullSecret);
        if (pullSecret != null) {
            this.pullSecret = new LocalObjectReferenceBuilder(pullSecret);
            this._visitables.get((Object)"pullSecret").add(this.pullSecret);
        } else {
            this.pullSecret = null;
            this._visitables.get((Object)"pullSecret").remove(this.pullSecret);
        }
        return (A)((Object)this);
    }

    public boolean hasPullSecret() {
        return this.pullSecret != null;
    }

    public A withNewPullSecret(String name) {
        return this.withPullSecret(new LocalObjectReference(name));
    }

    public PullSecretNested<A> withNewPullSecret() {
        return new PullSecretNested(null);
    }

    public PullSecretNested<A> withNewPullSecretLike(LocalObjectReference item) {
        return new PullSecretNested(item);
    }

    public PullSecretNested<A> editPullSecret() {
        return this.withNewPullSecretLike(Optional.ofNullable(this.buildPullSecret()).orElse(null));
    }

    public PullSecretNested<A> editOrNewPullSecret() {
        return this.withNewPullSecretLike(Optional.ofNullable(this.buildPullSecret()).orElse(new LocalObjectReferenceBuilder().build()));
    }

    public PullSecretNested<A> editOrNewPullSecretLike(LocalObjectReference item) {
        return this.withNewPullSecretLike(Optional.ofNullable(this.buildPullSecret()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ImageSourceFluent that = (ImageSourceFluent)((Object)o);
        if (!Objects.equals(this.as, that.as)) {
            return false;
        }
        if (!Objects.equals(this.from, that.from)) {
            return false;
        }
        if (!Objects.equals(this.paths, that.paths)) {
            return false;
        }
        if (!Objects.equals(this.pullSecret, that.pullSecret)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.as, this.from, this.paths, this.pullSecret, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.as != null && !this.as.isEmpty()) {
            sb.append("as:");
            sb.append(this.as + ",");
        }
        if (this.from != null) {
            sb.append("from:");
            sb.append(this.from + ",");
        }
        if (this.paths != null && !this.paths.isEmpty()) {
            sb.append("paths:");
            sb.append(this.paths + ",");
        }
        if (this.pullSecret != null) {
            sb.append("pullSecret:");
            sb.append(this.pullSecret + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class PullSecretNested<N>
    extends LocalObjectReferenceFluent<PullSecretNested<N>>
    implements Nested<N> {
        LocalObjectReferenceBuilder builder;

        PullSecretNested(LocalObjectReference item) {
            this.builder = new LocalObjectReferenceBuilder((LocalObjectReferenceFluent)this, item);
        }

        public N and() {
            return (N)ImageSourceFluent.this.withPullSecret(this.builder.build());
        }

        public N endPullSecret() {
            return this.and();
        }
    }

    public class PathsNested<N>
    extends ImageSourcePathFluent<PathsNested<N>>
    implements Nested<N> {
        ImageSourcePathBuilder builder;
        int index;

        PathsNested(int index, ImageSourcePath item) {
            this.index = index;
            this.builder = new ImageSourcePathBuilder(this, item);
        }

        public N and() {
            return (N)ImageSourceFluent.this.setToPaths(this.index, this.builder.build());
        }

        public N endPath() {
            return this.and();
        }
    }

    public class FromNested<N>
    extends ObjectReferenceFluent<FromNested<N>>
    implements Nested<N> {
        ObjectReferenceBuilder builder;

        FromNested(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder((ObjectReferenceFluent)this, item);
        }

        public N and() {
            return (N)ImageSourceFluent.this.withFrom(this.builder.build());
        }

        public N endFrom() {
            return this.and();
        }
    }
}

