/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.openshift.api.model.BrokerTemplateInstanceSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class BrokerTemplateInstanceSpecFluent<A extends BrokerTemplateInstanceSpecFluent<A>>
extends BaseFluent<A> {
    private List<String> bindingIDs = new ArrayList<String>();
    private ObjectReferenceBuilder secret;
    private ObjectReferenceBuilder templateInstance;
    private Map<String, Object> additionalProperties;

    public BrokerTemplateInstanceSpecFluent() {
    }

    public BrokerTemplateInstanceSpecFluent(BrokerTemplateInstanceSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(BrokerTemplateInstanceSpec instance) {
        BrokerTemplateInstanceSpec brokerTemplateInstanceSpec = instance = instance != null ? instance : new BrokerTemplateInstanceSpec();
        if (instance != null) {
            this.withBindingIDs(instance.getBindingIDs());
            this.withSecret(instance.getSecret());
            this.withTemplateInstance(instance.getTemplateInstance());
            this.withBindingIDs(instance.getBindingIDs());
            this.withSecret(instance.getSecret());
            this.withTemplateInstance(instance.getTemplateInstance());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToBindingIDs(int index, String item) {
        if (this.bindingIDs == null) {
            this.bindingIDs = new ArrayList<String>();
        }
        this.bindingIDs.add(index, item);
        return (A)((Object)this);
    }

    public A setToBindingIDs(int index, String item) {
        if (this.bindingIDs == null) {
            this.bindingIDs = new ArrayList<String>();
        }
        this.bindingIDs.set(index, item);
        return (A)((Object)this);
    }

    public A addToBindingIDs(String ... items) {
        if (this.bindingIDs == null) {
            this.bindingIDs = new ArrayList<String>();
        }
        for (String item : items) {
            this.bindingIDs.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToBindingIDs(Collection<String> items) {
        if (this.bindingIDs == null) {
            this.bindingIDs = new ArrayList<String>();
        }
        for (String item : items) {
            this.bindingIDs.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromBindingIDs(String ... items) {
        if (this.bindingIDs == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.bindingIDs.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromBindingIDs(Collection<String> items) {
        if (this.bindingIDs == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.bindingIDs.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getBindingIDs() {
        return this.bindingIDs;
    }

    public String getBindingID(int index) {
        return this.bindingIDs.get(index);
    }

    public String getFirstBindingID() {
        return this.bindingIDs.get(0);
    }

    public String getLastBindingID() {
        return this.bindingIDs.get(this.bindingIDs.size() - 1);
    }

    public String getMatchingBindingID(Predicate<String> predicate) {
        for (String item : this.bindingIDs) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingBindingID(Predicate<String> predicate) {
        for (String item : this.bindingIDs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withBindingIDs(List<String> bindingIDs) {
        if (bindingIDs != null) {
            this.bindingIDs = new ArrayList<String>();
            for (String item : bindingIDs) {
                this.addToBindingIDs(item);
            }
        } else {
            this.bindingIDs = null;
        }
        return (A)((Object)this);
    }

    public A withBindingIDs(String ... bindingIDs) {
        if (this.bindingIDs != null) {
            this.bindingIDs.clear();
            this._visitables.remove((Object)"bindingIDs");
        }
        if (bindingIDs != null) {
            for (String item : bindingIDs) {
                this.addToBindingIDs(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasBindingIDs() {
        return this.bindingIDs != null && !this.bindingIDs.isEmpty();
    }

    public ObjectReference buildSecret() {
        return this.secret != null ? this.secret.build() : null;
    }

    public A withSecret(ObjectReference secret) {
        this._visitables.remove((Object)this.secret);
        if (secret != null) {
            this.secret = new ObjectReferenceBuilder(secret);
            this._visitables.get((Object)"secret").add(this.secret);
        } else {
            this.secret = null;
            this._visitables.get((Object)"secret").remove(this.secret);
        }
        return (A)((Object)this);
    }

    public boolean hasSecret() {
        return this.secret != null;
    }

    public SecretNested<A> withNewSecret() {
        return new SecretNested(null);
    }

    public SecretNested<A> withNewSecretLike(ObjectReference item) {
        return new SecretNested(item);
    }

    public SecretNested<A> editSecret() {
        return this.withNewSecretLike(Optional.ofNullable(this.buildSecret()).orElse(null));
    }

    public SecretNested<A> editOrNewSecret() {
        return this.withNewSecretLike(Optional.ofNullable(this.buildSecret()).orElse(new ObjectReferenceBuilder().build()));
    }

    public SecretNested<A> editOrNewSecretLike(ObjectReference item) {
        return this.withNewSecretLike(Optional.ofNullable(this.buildSecret()).orElse(item));
    }

    public ObjectReference buildTemplateInstance() {
        return this.templateInstance != null ? this.templateInstance.build() : null;
    }

    public A withTemplateInstance(ObjectReference templateInstance) {
        this._visitables.remove((Object)this.templateInstance);
        if (templateInstance != null) {
            this.templateInstance = new ObjectReferenceBuilder(templateInstance);
            this._visitables.get((Object)"templateInstance").add(this.templateInstance);
        } else {
            this.templateInstance = null;
            this._visitables.get((Object)"templateInstance").remove(this.templateInstance);
        }
        return (A)((Object)this);
    }

    public boolean hasTemplateInstance() {
        return this.templateInstance != null;
    }

    public TemplateInstanceNested<A> withNewTemplateInstance() {
        return new TemplateInstanceNested(null);
    }

    public TemplateInstanceNested<A> withNewTemplateInstanceLike(ObjectReference item) {
        return new TemplateInstanceNested(item);
    }

    public TemplateInstanceNested<A> editTemplateInstance() {
        return this.withNewTemplateInstanceLike(Optional.ofNullable(this.buildTemplateInstance()).orElse(null));
    }

    public TemplateInstanceNested<A> editOrNewTemplateInstance() {
        return this.withNewTemplateInstanceLike(Optional.ofNullable(this.buildTemplateInstance()).orElse(new ObjectReferenceBuilder().build()));
    }

    public TemplateInstanceNested<A> editOrNewTemplateInstanceLike(ObjectReference item) {
        return this.withNewTemplateInstanceLike(Optional.ofNullable(this.buildTemplateInstance()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BrokerTemplateInstanceSpecFluent that = (BrokerTemplateInstanceSpecFluent)((Object)o);
        if (!Objects.equals(this.bindingIDs, that.bindingIDs)) {
            return false;
        }
        if (!Objects.equals(this.secret, that.secret)) {
            return false;
        }
        if (!Objects.equals(this.templateInstance, that.templateInstance)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.bindingIDs, this.secret, this.templateInstance, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.bindingIDs != null && !this.bindingIDs.isEmpty()) {
            sb.append("bindingIDs:");
            sb.append(this.bindingIDs + ",");
        }
        if (this.secret != null) {
            sb.append("secret:");
            sb.append(this.secret + ",");
        }
        if (this.templateInstance != null) {
            sb.append("templateInstance:");
            sb.append(this.templateInstance + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class TemplateInstanceNested<N>
    extends ObjectReferenceFluent<TemplateInstanceNested<N>>
    implements Nested<N> {
        ObjectReferenceBuilder builder;

        TemplateInstanceNested(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder((ObjectReferenceFluent)this, item);
        }

        public N and() {
            return (N)BrokerTemplateInstanceSpecFluent.this.withTemplateInstance(this.builder.build());
        }

        public N endTemplateInstance() {
            return this.and();
        }
    }

    public class SecretNested<N>
    extends ObjectReferenceFluent<SecretNested<N>>
    implements Nested<N> {
        ObjectReferenceBuilder builder;

        SecretNested(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder((ObjectReferenceFluent)this, item);
        }

        public N and() {
            return (N)BrokerTemplateInstanceSpecFluent.this.withSecret(this.builder.build());
        }

        public N endSecret() {
            return this.and();
        }
    }
}

