/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.RouteIngress;
import io.fabric8.openshift.api.model.RouteIngressBuilder;
import io.fabric8.openshift.api.model.RouteIngressFluentImpl;
import io.fabric8.openshift.api.model.RouteStatus;
import io.fabric8.openshift.api.model.RouteStatusFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class RouteStatusFluentImpl<A extends RouteStatusFluent<A>>
extends BaseFluent<A>
implements RouteStatusFluent<A> {
    private ArrayList<RouteIngressBuilder> ingress = new ArrayList();
    private Map<String, Object> additionalProperties;

    public RouteStatusFluentImpl() {
    }

    public RouteStatusFluentImpl(RouteStatus instance) {
        if (instance != null) {
            this.withIngress(instance.getIngress());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    @Override
    public A addToIngress(int index, RouteIngress item) {
        if (this.ingress == null) {
            this.ingress = new ArrayList();
        }
        RouteIngressBuilder builder = new RouteIngressBuilder(item);
        if (index < 0 || index >= this.ingress.size()) {
            this._visitables.get((Object)"ingress").add(builder);
            this.ingress.add(builder);
        } else {
            this._visitables.get((Object)"ingress").add(index, builder);
            this.ingress.add(index, builder);
        }
        return (A)this;
    }

    @Override
    public A setToIngress(int index, RouteIngress item) {
        if (this.ingress == null) {
            this.ingress = new ArrayList();
        }
        RouteIngressBuilder builder = new RouteIngressBuilder(item);
        if (index < 0 || index >= this.ingress.size()) {
            this._visitables.get((Object)"ingress").add(builder);
            this.ingress.add(builder);
        } else {
            this._visitables.get((Object)"ingress").set(index, builder);
            this.ingress.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToIngress(RouteIngress ... items) {
        if (this.ingress == null) {
            this.ingress = new ArrayList();
        }
        for (RouteIngress item : items) {
            RouteIngressBuilder builder = new RouteIngressBuilder(item);
            this._visitables.get((Object)"ingress").add(builder);
            this.ingress.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToIngress(Collection<RouteIngress> items) {
        if (this.ingress == null) {
            this.ingress = new ArrayList();
        }
        for (RouteIngress item : items) {
            RouteIngressBuilder builder = new RouteIngressBuilder(item);
            this._visitables.get((Object)"ingress").add(builder);
            this.ingress.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromIngress(RouteIngress ... items) {
        for (RouteIngress item : items) {
            RouteIngressBuilder builder = new RouteIngressBuilder(item);
            this._visitables.get((Object)"ingress").remove(builder);
            if (this.ingress == null) continue;
            this.ingress.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromIngress(Collection<RouteIngress> items) {
        for (RouteIngress item : items) {
            RouteIngressBuilder builder = new RouteIngressBuilder(item);
            this._visitables.get((Object)"ingress").remove(builder);
            if (this.ingress == null) continue;
            this.ingress.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromIngress(Predicate<RouteIngressBuilder> predicate) {
        if (this.ingress == null) {
            return (A)this;
        }
        Iterator<RouteIngressBuilder> each = this.ingress.iterator();
        List visitables = this._visitables.get((Object)"ingress");
        while (each.hasNext()) {
            RouteIngressBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<RouteIngress> getIngress() {
        return this.ingress != null ? RouteStatusFluentImpl.build(this.ingress) : null;
    }

    @Override
    public List<RouteIngress> buildIngress() {
        return this.ingress != null ? RouteStatusFluentImpl.build(this.ingress) : null;
    }

    @Override
    public RouteIngress buildIngress(int index) {
        return this.ingress.get(index).build();
    }

    @Override
    public RouteIngress buildFirstIngress() {
        return this.ingress.get(0).build();
    }

    @Override
    public RouteIngress buildLastIngress() {
        return this.ingress.get(this.ingress.size() - 1).build();
    }

    @Override
    public RouteIngress buildMatchingIngress(Predicate<RouteIngressBuilder> predicate) {
        for (RouteIngressBuilder item : this.ingress) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingIngress(Predicate<RouteIngressBuilder> predicate) {
        for (RouteIngressBuilder item : this.ingress) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withIngress(List<RouteIngress> ingress) {
        if (this.ingress != null) {
            this._visitables.get((Object)"ingress").clear();
        }
        if (ingress != null) {
            this.ingress = new ArrayList();
            for (RouteIngress item : ingress) {
                this.addToIngress(item);
            }
        } else {
            this.ingress = null;
        }
        return (A)this;
    }

    @Override
    public A withIngress(RouteIngress ... ingress) {
        if (this.ingress != null) {
            this.ingress.clear();
            this._visitables.remove((Object)"ingress");
        }
        if (ingress != null) {
            for (RouteIngress item : ingress) {
                this.addToIngress(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasIngress() {
        return this.ingress != null && !this.ingress.isEmpty();
    }

    @Override
    public RouteStatusFluent.IngressNested<A> addNewIngress() {
        return new IngressNestedImpl();
    }

    @Override
    public RouteStatusFluent.IngressNested<A> addNewIngressLike(RouteIngress item) {
        return new IngressNestedImpl(-1, item);
    }

    @Override
    public RouteStatusFluent.IngressNested<A> setNewIngressLike(int index, RouteIngress item) {
        return new IngressNestedImpl(index, item);
    }

    @Override
    public RouteStatusFluent.IngressNested<A> editIngress(int index) {
        if (this.ingress.size() <= index) {
            throw new RuntimeException("Can't edit ingress. Index exceeds size.");
        }
        return this.setNewIngressLike(index, this.buildIngress(index));
    }

    @Override
    public RouteStatusFluent.IngressNested<A> editFirstIngress() {
        if (this.ingress.size() == 0) {
            throw new RuntimeException("Can't edit first ingress. The list is empty.");
        }
        return this.setNewIngressLike(0, this.buildIngress(0));
    }

    @Override
    public RouteStatusFluent.IngressNested<A> editLastIngress() {
        int index = this.ingress.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last ingress. The list is empty.");
        }
        return this.setNewIngressLike(index, this.buildIngress(index));
    }

    @Override
    public RouteStatusFluent.IngressNested<A> editMatchingIngress(Predicate<RouteIngressBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.ingress.size(); ++i) {
            if (!predicate.test(this.ingress.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching ingress. No match found.");
        }
        return this.setNewIngressLike(index, this.buildIngress(index));
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RouteStatusFluentImpl that = (RouteStatusFluentImpl)o;
        if (!Objects.equals(this.ingress, that.ingress)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.ingress, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.ingress != null && !this.ingress.isEmpty()) {
            sb.append("ingress:");
            sb.append(this.ingress + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class IngressNestedImpl<N>
    extends RouteIngressFluentImpl<RouteStatusFluent.IngressNested<N>>
    implements RouteStatusFluent.IngressNested<N>,
    Nested<N> {
        RouteIngressBuilder builder;
        int index;

        IngressNestedImpl(int index, RouteIngress item) {
            this.index = index;
            this.builder = new RouteIngressBuilder(this, item);
        }

        IngressNestedImpl() {
            this.index = -1;
            this.builder = new RouteIngressBuilder(this);
        }

        @Override
        public N and() {
            return (N)RouteStatusFluentImpl.this.setToIngress(this.index, this.builder.build());
        }

        @Override
        public N endIngress() {
            return this.and();
        }
    }
}

