package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class TemplateInstanceRequesterBuilder extends TemplateInstanceRequesterFluentImpl<TemplateInstanceRequesterBuilder> implements VisitableBuilder<TemplateInstanceRequester,TemplateInstanceRequesterBuilder>{
  public TemplateInstanceRequesterBuilder() {
    this(false);
  }
  public TemplateInstanceRequesterBuilder(Boolean validationEnabled) {
    this(new TemplateInstanceRequester(), validationEnabled);
  }
  public TemplateInstanceRequesterBuilder(TemplateInstanceRequesterFluent<?> fluent) {
    this(fluent, false);
  }
  public TemplateInstanceRequesterBuilder(TemplateInstanceRequesterFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new TemplateInstanceRequester(), validationEnabled);
  }
  public TemplateInstanceRequesterBuilder(TemplateInstanceRequesterFluent<?> fluent,TemplateInstanceRequester instance) {
    this(fluent, instance, false);
  }
  public TemplateInstanceRequesterBuilder(TemplateInstanceRequesterFluent<?> fluent,TemplateInstanceRequester instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withExtra(instance.getExtra()); 
    fluent.withGroups(instance.getGroups()); 
    fluent.withUid(instance.getUid()); 
    fluent.withUsername(instance.getUsername()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public TemplateInstanceRequesterBuilder(TemplateInstanceRequester instance) {
    this(instance,false);
  }
  public TemplateInstanceRequesterBuilder(TemplateInstanceRequester instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withExtra(instance.getExtra()); 
    this.withGroups(instance.getGroups()); 
    this.withUid(instance.getUid()); 
    this.withUsername(instance.getUsername()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  TemplateInstanceRequesterFluent<?> fluent;
  Boolean validationEnabled;
  public TemplateInstanceRequester build() {
    TemplateInstanceRequester buildable = new TemplateInstanceRequester(fluent.getExtra(),fluent.getGroups(),fluent.getUid(),fluent.getUsername());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}