package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class OAuthClientAuthorizationListBuilder extends OAuthClientAuthorizationListFluentImpl<OAuthClientAuthorizationListBuilder> implements VisitableBuilder<OAuthClientAuthorizationList,OAuthClientAuthorizationListBuilder>{
  public OAuthClientAuthorizationListBuilder() {
    this(false);
  }
  public OAuthClientAuthorizationListBuilder(Boolean validationEnabled) {
    this(new OAuthClientAuthorizationList(), validationEnabled);
  }
  public OAuthClientAuthorizationListBuilder(OAuthClientAuthorizationListFluent<?> fluent) {
    this(fluent, false);
  }
  public OAuthClientAuthorizationListBuilder(OAuthClientAuthorizationListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new OAuthClientAuthorizationList(), validationEnabled);
  }
  public OAuthClientAuthorizationListBuilder(OAuthClientAuthorizationListFluent<?> fluent,OAuthClientAuthorizationList instance) {
    this(fluent, instance, false);
  }
  public OAuthClientAuthorizationListBuilder(OAuthClientAuthorizationListFluent<?> fluent,OAuthClientAuthorizationList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public OAuthClientAuthorizationListBuilder(OAuthClientAuthorizationList instance) {
    this(instance,false);
  }
  public OAuthClientAuthorizationListBuilder(OAuthClientAuthorizationList instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  OAuthClientAuthorizationListFluent<?> fluent;
  Boolean validationEnabled;
  public OAuthClientAuthorizationList build() {
    OAuthClientAuthorizationList buildable = new OAuthClientAuthorizationList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}