package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ImageStreamImportSpecFluentImpl<A extends ImageStreamImportSpecFluent<A>> extends BaseFluent<A> implements ImageStreamImportSpecFluent<A>{
  public ImageStreamImportSpecFluentImpl() {
  }
  public ImageStreamImportSpecFluentImpl(ImageStreamImportSpec instance) {
    this.withImages(instance.getImages()); 
    this.withImport(instance.getImport()); 
    this.withRepository(instance.getRepository()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private ArrayList<ImageImportSpecBuilder> images = new ArrayList<ImageImportSpecBuilder>();
  private Boolean _import;
  private RepositoryImportSpecBuilder repository;
  private Map<String,Object> additionalProperties;
  public A addToImages(Integer index,ImageImportSpec item) {
    if (this.images == null) {this.images = new ArrayList<ImageImportSpecBuilder>();}
    ImageImportSpecBuilder builder = new ImageImportSpecBuilder(item);_visitables.get("images").add(index >= 0 ? index : _visitables.get("images").size(), builder);this.images.add(index >= 0 ? index : images.size(), builder); return (A)this;
  }
  public A setToImages(Integer index,ImageImportSpec item) {
    if (this.images == null) {this.images = new ArrayList<ImageImportSpecBuilder>();}
    ImageImportSpecBuilder builder = new ImageImportSpecBuilder(item);
    if (index < 0 || index >= _visitables.get("images").size()) { _visitables.get("images").add(builder); } else { _visitables.get("images").set(index, builder);}
    if (index < 0 || index >= images.size()) { images.add(builder); } else { images.set(index, builder);}
     return (A)this;
  }
  public A addToImages(io.fabric8.openshift.api.model.ImageImportSpec... items) {
    if (this.images == null) {this.images = new ArrayList<ImageImportSpecBuilder>();}
    for (ImageImportSpec item : items) {ImageImportSpecBuilder builder = new ImageImportSpecBuilder(item);_visitables.get("images").add(builder);this.images.add(builder);} return (A)this;
  }
  public A addAllToImages(Collection<ImageImportSpec> items) {
    if (this.images == null) {this.images = new ArrayList<ImageImportSpecBuilder>();}
    for (ImageImportSpec item : items) {ImageImportSpecBuilder builder = new ImageImportSpecBuilder(item);_visitables.get("images").add(builder);this.images.add(builder);} return (A)this;
  }
  public A removeFromImages(io.fabric8.openshift.api.model.ImageImportSpec... items) {
    for (ImageImportSpec item : items) {ImageImportSpecBuilder builder = new ImageImportSpecBuilder(item);_visitables.get("images").remove(builder);if (this.images != null) {this.images.remove(builder);}} return (A)this;
  }
  public A removeAllFromImages(Collection<ImageImportSpec> items) {
    for (ImageImportSpec item : items) {ImageImportSpecBuilder builder = new ImageImportSpecBuilder(item);_visitables.get("images").remove(builder);if (this.images != null) {this.images.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromImages(Predicate<ImageImportSpecBuilder> predicate) {
    if (images == null) return (A) this;
    final Iterator<ImageImportSpecBuilder> each = images.iterator();
    final List visitables = _visitables.get("images");
    while (each.hasNext()) {
      ImageImportSpecBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildImages instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<ImageImportSpec> getImages() {
    return images != null ? build(images) : null;
  }
  public List<ImageImportSpec> buildImages() {
    return images != null ? build(images) : null;
  }
  public ImageImportSpec buildImage(Integer index) {
    return this.images.get(index).build();
  }
  public ImageImportSpec buildFirstImage() {
    return this.images.get(0).build();
  }
  public ImageImportSpec buildLastImage() {
    return this.images.get(images.size() - 1).build();
  }
  public ImageImportSpec buildMatchingImage(Predicate<ImageImportSpecBuilder> predicate) {
    for (ImageImportSpecBuilder item: images) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingImage(Predicate<ImageImportSpecBuilder> predicate) {
    for (ImageImportSpecBuilder item: images) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withImages(List<ImageImportSpec> images) {
    if (this.images != null) { _visitables.get("images").removeAll(this.images);}
    if (images != null) {this.images = new ArrayList(); for (ImageImportSpec item : images){this.addToImages(item);}} else { this.images = null;} return (A) this;
  }
  public A withImages(io.fabric8.openshift.api.model.ImageImportSpec... images) {
    if (this.images != null) {this.images.clear();}
    if (images != null) {for (ImageImportSpec item :images){ this.addToImages(item);}} return (A) this;
  }
  public Boolean hasImages() {
    return images != null && !images.isEmpty();
  }
  public ImageStreamImportSpecFluent.ImagesNested<A> addNewImage() {
    return new ImageStreamImportSpecFluentImpl.ImagesNestedImpl();
  }
  public ImageStreamImportSpecFluent.ImagesNested<A> addNewImageLike(ImageImportSpec item) {
    return new ImageStreamImportSpecFluentImpl.ImagesNestedImpl(-1, item);
  }
  public ImageStreamImportSpecFluent.ImagesNested<A> setNewImageLike(Integer index,ImageImportSpec item) {
    return new ImageStreamImportSpecFluentImpl.ImagesNestedImpl(index, item);
  }
  public ImageStreamImportSpecFluent.ImagesNested<A> editImage(Integer index) {
    if (images.size() <= index) throw new RuntimeException("Can't edit images. Index exceeds size.");
    return setNewImageLike(index, buildImage(index));
  }
  public ImageStreamImportSpecFluent.ImagesNested<A> editFirstImage() {
    if (images.size() == 0) throw new RuntimeException("Can't edit first images. The list is empty.");
    return setNewImageLike(0, buildImage(0));
  }
  public ImageStreamImportSpecFluent.ImagesNested<A> editLastImage() {
    int index = images.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last images. The list is empty.");
    return setNewImageLike(index, buildImage(index));
  }
  public ImageStreamImportSpecFluent.ImagesNested<A> editMatchingImage(Predicate<ImageImportSpecBuilder> predicate) {
    int index = -1;
    for (int i=0;i<images.size();i++) { 
    if (predicate.test(images.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching images. No match found.");
    return setNewImageLike(index, buildImage(index));
  }
  public Boolean getImport() {
    return this._import;
  }
  public A withImport(Boolean _import) {
    this._import=_import; return (A) this;
  }
  public Boolean hasImport() {
    return this._import != null;
  }
  
  /**
   * This method has been deprecated, please use method buildRepository instead.
   * @return The buildable object.
   */
  @Deprecated
  public RepositoryImportSpec getRepository() {
    return this.repository!=null ?this.repository.build():null;
  }
  public RepositoryImportSpec buildRepository() {
    return this.repository!=null ?this.repository.build():null;
  }
  public A withRepository(RepositoryImportSpec repository) {
    _visitables.get("repository").remove(this.repository);
    if (repository!=null){ this.repository= new RepositoryImportSpecBuilder(repository); _visitables.get("repository").add(this.repository);} else { this.repository = null; _visitables.get("repository").remove(this.repository); } return (A) this;
  }
  public Boolean hasRepository() {
    return this.repository != null;
  }
  public ImageStreamImportSpecFluent.RepositoryNested<A> withNewRepository() {
    return new ImageStreamImportSpecFluentImpl.RepositoryNestedImpl();
  }
  public ImageStreamImportSpecFluent.RepositoryNested<A> withNewRepositoryLike(RepositoryImportSpec item) {
    return new ImageStreamImportSpecFluentImpl.RepositoryNestedImpl(item);
  }
  public ImageStreamImportSpecFluent.RepositoryNested<A> editRepository() {
    return withNewRepositoryLike(getRepository());
  }
  public ImageStreamImportSpecFluent.RepositoryNested<A> editOrNewRepository() {
    return withNewRepositoryLike(getRepository() != null ? getRepository(): new RepositoryImportSpecBuilder().build());
  }
  public ImageStreamImportSpecFluent.RepositoryNested<A> editOrNewRepositoryLike(RepositoryImportSpec item) {
    return withNewRepositoryLike(getRepository() != null ? getRepository(): item);
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ImageStreamImportSpecFluentImpl that = (ImageStreamImportSpecFluentImpl) o;
    if (images != null ? !images.equals(that.images) :that.images != null) return false;
    if (_import != null ? !_import.equals(that._import) :that._import != null) return false;
    if (repository != null ? !repository.equals(that.repository) :that.repository != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(images,  _import,  repository,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (images != null && !images.isEmpty()) { sb.append("images:"); sb.append(images + ","); }
    if (_import != null) { sb.append("_import:"); sb.append(_import + ","); }
    if (repository != null) { sb.append("repository:"); sb.append(repository + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public A withImport() {
    return withImport(true);
  }
  class ImagesNestedImpl<N> extends ImageImportSpecFluentImpl<ImageStreamImportSpecFluent.ImagesNested<N>> implements ImageStreamImportSpecFluent.ImagesNested<N>,Nested<N>{
    ImagesNestedImpl(Integer index,ImageImportSpec item) {
      this.index = index;
      this.builder = new ImageImportSpecBuilder(this, item);
    }
    ImagesNestedImpl() {
      this.index = -1;
      this.builder = new ImageImportSpecBuilder(this);
    }
    ImageImportSpecBuilder builder;
    Integer index;
    public N and() {
      return (N) ImageStreamImportSpecFluentImpl.this.setToImages(index,builder.build());
    }
    public N endImage() {
      return and();
    }
    
  }
  class RepositoryNestedImpl<N> extends RepositoryImportSpecFluentImpl<ImageStreamImportSpecFluent.RepositoryNested<N>> implements ImageStreamImportSpecFluent.RepositoryNested<N>,Nested<N>{
    RepositoryNestedImpl(RepositoryImportSpec item) {
      this.builder = new RepositoryImportSpecBuilder(this, item);
    }
    RepositoryNestedImpl() {
      this.builder = new RepositoryImportSpecBuilder(this);
    }
    RepositoryImportSpecBuilder builder;
    public N and() {
      return (N) ImageStreamImportSpecFluentImpl.this.withRepository(builder.build());
    }
    public N endRepository() {
      return and();
    }
    
  }
  
}