package io.fabric8.openshift.api.model;

import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.openshift.api.model.runtime.RawExtensionFluentImpl;
import io.fabric8.kubernetes.api.model.ContainerFluentImpl;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimFluentImpl;
import io.fabric8.openshift.api.model.runtime.RawExtensionBuilder;
import io.fabric8.kubernetes.api.model.Container;
import java.lang.Long;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluentImpl;
import java.lang.Boolean;
import java.lang.Object;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.ResourceRequirementsFluentImpl;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import java.util.List;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import java.lang.SuppressWarnings;
import java.util.Map;
import io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder;
import io.fabric8.kubernetes.api.model.LabelSelectorFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import java.util.Collection;
import io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import java.util.LinkedHashMap;
import io.fabric8.openshift.api.model.runtime.RawExtension;
import io.fabric8.kubernetes.api.builder.Nested;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class LocalSubjectAccessReviewFluentImpl<A extends LocalSubjectAccessReviewFluent<A>> extends BaseFluent<A> implements LocalSubjectAccessReviewFluent<A>{
  public LocalSubjectAccessReviewFluentImpl() {
  }
  public LocalSubjectAccessReviewFluentImpl(LocalSubjectAccessReview instance) {
    this.withApiVersion(instance.getApiVersion()); 
    this.withContent(instance.getContent()); 
    this.withGroups(instance.getGroups()); 
    this.withIsNonResourceURL(instance.getIsNonResourceURL()); 
    this.withKind(instance.getKind()); 
    this.withNamespace(instance.getNamespace()); 
    this.withPath(instance.getPath()); 
    this.withResource(instance.getResource()); 
    this.withResourceAPIGroup(instance.getResourceAPIGroup()); 
    this.withResourceAPIVersion(instance.getResourceAPIVersion()); 
    this.withResourceName(instance.getResourceName()); 
    this.withScopes(instance.getScopes()); 
    this.withUser(instance.getUser()); 
    this.withVerb(instance.getVerb()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private String apiVersion;
  private VisitableBuilder<? extends KubernetesResource,?> content;
  private List<String> groups = new ArrayList<String>();
  private Boolean isNonResourceURL;
  private String kind;
  private String namespace;
  private String path;
  private String resource;
  private String resourceAPIGroup;
  private String resourceAPIVersion;
  private String resourceName;
  private List<String> scopes = new ArrayList<String>();
  private String user;
  private String verb;
  private Map<String,Object> additionalProperties;
  public String getApiVersion() {
    return this.apiVersion;
  }
  public A withApiVersion(String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  public Boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  
  /**
   * This method has been deprecated, please use method buildContent instead.
   * @return The buildable object.
   */
  @Deprecated
  public KubernetesResource getContent() {
    return this.content!=null?this.content.build():null;
  }
  public KubernetesResource buildContent() {
    return this.content!=null?this.content.build():null;
  }
  public A withContent(KubernetesResource content) {
    if (content instanceof GenericWebHookCause){ this.content= new GenericWebHookCauseBuilder((GenericWebHookCause)content); _visitables.get("content").add(this.content);}
    if (content instanceof ServiceAccountRestriction){ this.content= new ServiceAccountRestrictionBuilder((ServiceAccountRestriction)content); _visitables.get("content").add(this.content);}
    if (content instanceof ScopeRestriction){ this.content= new ScopeRestrictionBuilder((ScopeRestriction)content); _visitables.get("content").add(this.content);}
    if (content instanceof SecretLocalReference){ this.content= new SecretLocalReferenceBuilder((SecretLocalReference)content); _visitables.get("content").add(this.content);}
    if (content instanceof StepInfo){ this.content= new StepInfoBuilder((StepInfo)content); _visitables.get("content").add(this.content);}
    if (content instanceof UserRestriction){ this.content= new UserRestrictionBuilder((UserRestriction)content); _visitables.get("content").add(this.content);}
    if (content instanceof PodTemplateSpec){ this.content= new PodTemplateSpecBuilder((PodTemplateSpec)content); _visitables.get("content").add(this.content);}
    if (content instanceof TemplateInstanceList){ this.content= new TemplateInstanceListBuilder((TemplateInstanceList)content); _visitables.get("content").add(this.content);}
    if (content instanceof ImageStreamImport){ this.content= new ImageStreamImportBuilder((ImageStreamImport)content); _visitables.get("content").add(this.content);}
    if (content instanceof ResourceRequirements){ this.content= new ResourceRequirementsBuilder((ResourceRequirements)content); _visitables.get("content").add(this.content);}
    if (content instanceof GitHubWebHookCause){ this.content= new GitHubWebHookCauseBuilder((GitHubWebHookCause)content); _visitables.get("content").add(this.content);}
    if (content instanceof OAuthClientList){ this.content= new OAuthClientListBuilder((OAuthClientList)content); _visitables.get("content").add(this.content);}
    if (content instanceof PodSecurityPolicyReviewStatus){ this.content= new PodSecurityPolicyReviewStatusBuilder((PodSecurityPolicyReviewStatus)content); _visitables.get("content").add(this.content);}
    if (content instanceof TemplateInstanceStatus){ this.content= new TemplateInstanceStatusBuilder((TemplateInstanceStatus)content); _visitables.get("content").add(this.content);}
    if (content instanceof HelmChartRepositoryList){ this.content= new HelmChartRepositoryListBuilder((HelmChartRepositoryList)content); _visitables.get("content").add(this.content);}
    if (content instanceof PolicyRule){ this.content= new PolicyRuleBuilder((PolicyRule)content); _visitables.get("content").add(this.content);}
    if (content instanceof DeploymentTriggerPolicy){ this.content= new DeploymentTriggerPolicyBuilder((DeploymentTriggerPolicy)content); _visitables.get("content").add(this.content);}
    if (content instanceof BuildStrategy){ this.content= new BuildStrategyBuilder((BuildStrategy)content); _visitables.get("content").add(this.content);}
    if (content instanceof RepositoryImportSpec){ this.content= new RepositoryImportSpecBuilder((RepositoryImportSpec)content); _visitables.get("content").add(this.content);}
    if (content instanceof BrokerTemplateInstanceList){ this.content= new BrokerTemplateInstanceListBuilder((BrokerTemplateInstanceList)content); _visitables.get("content").add(this.content);}
    if (content instanceof ImageStreamImportStatus){ this.content= new ImageStreamImportStatusBuilder((ImageStreamImportStatus)content); _visitables.get("content").add(this.content);}
    if (content instanceof CustomBuildStrategy){ this.content= new CustomBuildStrategyBuilder((CustomBuildStrategy)content); _visitables.get("content").add(this.content);}
    if (content instanceof ClusterResourceQuotaSelector){ this.content= new ClusterResourceQuotaSelectorBuilder((ClusterResourceQuotaSelector)content); _visitables.get("content").add(this.content);}
    if (content instanceof SubjectAccessReviewResponse){ this.content= new SubjectAccessReviewResponseBuilder((SubjectAccessReviewResponse)content); _visitables.get("content").add(this.content);}
    if (content instanceof DeploymentTriggerImageChangeParams){ this.content= new DeploymentTriggerImageChangeParamsBuilder((DeploymentTriggerImageChangeParams)content); _visitables.get("content").add(this.content);}
    if (content instanceof LocalObjectReference){ this.content= new LocalObjectReferenceBuilder((LocalObjectReference)content); _visitables.get("content").add(this.content);}
    if (content instanceof TagImageHook){ this.content= new TagImageHookBuilder((TagImageHook)content); _visitables.get("content").add(this.content);}
    if (content instanceof RouteTargetReference){ this.content= new RouteTargetReferenceBuilder((RouteTargetReference)content); _visitables.get("content").add(this.content);}
    if (content instanceof RawExtension){ this.content= new RawExtensionBuilder((RawExtension)content); _visitables.get("content").add(this.content);}
    if (content instanceof SubjectRulesReviewSpec){ this.content= new SubjectRulesReviewSpecBuilder((SubjectRulesReviewSpec)content); _visitables.get("content").add(this.content);}
    if (content instanceof TagReferencePolicy){ this.content= new TagReferencePolicyBuilder((TagReferencePolicy)content); _visitables.get("content").add(this.content);}
    if (content instanceof RoleList){ this.content= new RoleListBuilder((RoleList)content); _visitables.get("content").add(this.content);}
    if (content instanceof Project){ this.content= new ProjectBuilder((Project)content); _visitables.get("content").add(this.content);}
    if (content instanceof BuildVolumeSource){ this.content= new BuildVolumeSourceBuilder((BuildVolumeSource)content); _visitables.get("content").add(this.content);}
    if (content instanceof AppliedClusterResourceQuotaList){ this.content= new AppliedClusterResourceQuotaListBuilder((AppliedClusterResourceQuotaList)content); _visitables.get("content").add(this.content);}
    if (content instanceof DeploymentConfigList){ this.content= new DeploymentConfigListBuilder((DeploymentConfigList)content); _visitables.get("content").add(this.content);}
    if (content instanceof BuildStatusOutput){ this.content= new BuildStatusOutputBuilder((BuildStatusOutput)content); _visitables.get("content").add(this.content);}
    if (content instanceof BuildConfig){ this.content= new BuildConfigBuilder((BuildConfig)content); _visitables.get("content").add(this.content);}
    if (content instanceof ImageImportStatus){ this.content= new ImageImportStatusBuilder((ImageImportStatus)content); _visitables.get("content").add(this.content);}
    if (content instanceof PodSecurityPolicySubjectReview){ this.content= new PodSecurityPolicySubjectReviewBuilder((PodSecurityPolicySubjectReview)content); _visitables.get("content").add(this.content);}
    if (content instanceof GitLabWebHookCause){ this.content= new GitLabWebHookCauseBuilder((GitLabWebHookCause)content); _visitables.get("content").add(this.content);}
    if (content instanceof DeploymentConfigStatus){ this.content= new DeploymentConfigStatusBuilder((DeploymentConfigStatus)content); _visitables.get("content").add(this.content);}
    if (content instanceof SecretBuildSource){ this.content= new SecretBuildSourceBuilder((SecretBuildSource)content); _visitables.get("content").add(this.content);}
    if (content instanceof EgressNetworkPolicySpec){ this.content= new EgressNetworkPolicySpecBuilder((EgressNetworkPolicySpec)content); _visitables.get("content").add(this.content);}
    if (content instanceof HelmChartRepository){ this.content= new HelmChartRepositoryBuilder((HelmChartRepository)content); _visitables.get("content").add(this.content);}
    if (content instanceof TagEvent){ this.content= new TagEventBuilder((TagEvent)content); _visitables.get("content").add(this.content);}
    if (content instanceof ImageStreamTagList){ this.content= new ImageStreamTagListBuilder((ImageStreamTagList)content); _visitables.get("content").add(this.content);}
    if (content instanceof BitbucketWebHookCause){ this.content= new BitbucketWebHookCauseBuilder((BitbucketWebHookCause)content); _visitables.get("content").add(this.content);}
    if (content instanceof ProjectList){ this.content= new ProjectListBuilder((ProjectList)content); _visitables.get("content").add(this.content);}
    if (content instanceof RangeAllocation){ this.content= new RangeAllocationBuilder((RangeAllocation)content); _visitables.get("content").add(this.content);}
    if (content instanceof ClusterRoleScopeRestriction){ this.content= new ClusterRoleScopeRestrictionBuilder((ClusterRoleScopeRestriction)content); _visitables.get("content").add(this.content);}
    if (content instanceof Route){ this.content= new RouteBuilder((Route)content); _visitables.get("content").add(this.content);}
    if (content instanceof SourceStrategyOptions){ this.content= new SourceStrategyOptionsBuilder((SourceStrategyOptions)content); _visitables.get("content").add(this.content);}
    if (content instanceof ClusterNetwork){ this.content= new ClusterNetworkBuilder((ClusterNetwork)content); _visitables.get("content").add(this.content);}
    if (content instanceof OAuthAuthorizeToken){ this.content= new OAuthAuthorizeTokenBuilder((OAuthAuthorizeToken)content); _visitables.get("content").add(this.content);}
    if (content instanceof DockerBuildStrategy){ this.content= new DockerBuildStrategyBuilder((DockerBuildStrategy)content); _visitables.get("content").add(this.content);}
    if (content instanceof SignatureCondition){ this.content= new SignatureConditionBuilder((SignatureCondition)content); _visitables.get("content").add(this.content);}
    if (content instanceof UserOAuthAccessToken){ this.content= new UserOAuthAccessTokenBuilder((UserOAuthAccessToken)content); _visitables.get("content").add(this.content);}
    if (content instanceof RoleBindingRestrictionList){ this.content= new RoleBindingRestrictionListBuilder((RoleBindingRestrictionList)content); _visitables.get("content").add(this.content);}
    if (content instanceof SecurityContextConstraintsList){ this.content= new SecurityContextConstraintsListBuilder((SecurityContextConstraintsList)content); _visitables.get("content").add(this.content);}
    if (content instanceof IdentityList){ this.content= new IdentityListBuilder((IdentityList)content); _visitables.get("content").add(this.content);}
    if (content instanceof BuildConfigList){ this.content= new BuildConfigListBuilder((BuildConfigList)content); _visitables.get("content").add(this.content);}
    if (content instanceof ClusterNetworkList){ this.content= new ClusterNetworkListBuilder((ClusterNetworkList)content); _visitables.get("content").add(this.content);}
    if (content instanceof TemplateInstanceCondition){ this.content= new TemplateInstanceConditionBuilder((TemplateInstanceCondition)content); _visitables.get("content").add(this.content);}
    if (content instanceof RepositoryImportStatus){ this.content= new RepositoryImportStatusBuilder((RepositoryImportStatus)content); _visitables.get("content").add(this.content);}
    if (content instanceof DeploymentCause){ this.content= new DeploymentCauseBuilder((DeploymentCause)content); _visitables.get("content").add(this.content);}
    if (content instanceof GroupList){ this.content= new GroupListBuilder((GroupList)content); _visitables.get("content").add(this.content);}
    if (content instanceof RunAsUserStrategyOptions){ this.content= new RunAsUserStrategyOptionsBuilder((RunAsUserStrategyOptions)content); _visitables.get("content").add(this.content);}
    if (content instanceof LifecycleHook){ this.content= new LifecycleHookBuilder((LifecycleHook)content); _visitables.get("content").add(this.content);}
    if (content instanceof ImageStreamTagReference){ this.content= new ImageStreamTagReferenceBuilder((ImageStreamTagReference)content); _visitables.get("content").add(this.content);}
    if (content instanceof SourceControlUser){ this.content= new SourceControlUserBuilder((SourceControlUser)content); _visitables.get("content").add(this.content);}
    if (content instanceof Container){ this.content= new ContainerBuilder((Container)content); _visitables.get("content").add(this.content);}
    if (content instanceof ImageStreamList){ this.content= new ImageStreamListBuilder((ImageStreamList)content); _visitables.get("content").add(this.content);}
    if (content instanceof ClusterRoleBinding){ this.content= new ClusterRoleBindingBuilder((ClusterRoleBinding)content); _visitables.get("content").add(this.content);}
    if (content instanceof ResourceAccessReview){ this.content= new ResourceAccessReviewBuilder((ResourceAccessReview)content); _visitables.get("content").add(this.content);}
    if (content instanceof SelfSubjectRulesReview){ this.content= new SelfSubjectRulesReviewBuilder((SelfSubjectRulesReview)content); _visitables.get("content").add(this.content);}
    if (content instanceof UserOAuthAccessTokenList){ this.content= new UserOAuthAccessTokenListBuilder((UserOAuthAccessTokenList)content); _visitables.get("content").add(this.content);}
    if (content instanceof ImageChangeTriggerStatus){ this.content= new ImageChangeTriggerStatusBuilder((ImageChangeTriggerStatus)content); _visitables.get("content").add(this.content);}
    if (content instanceof RouteStatus){ this.content= new RouteStatusBuilder((RouteStatus)content); _visitables.get("content").add(this.content);}
    if (content instanceof ClusterResourceQuota){ this.content= new ClusterResourceQuotaBuilder((ClusterResourceQuota)content); _visitables.get("content").add(this.content);}
    if (content instanceof NamedTagEventList){ this.content= new NamedTagEventListBuilder((NamedTagEventList)content); _visitables.get("content").add(this.content);}
    if (content instanceof ClusterResourceQuotaList){ this.content= new ClusterResourceQuotaListBuilder((ClusterResourceQuotaList)content); _visitables.get("content").add(this.content);}
    if (content instanceof RouteSpec){ this.content= new RouteSpecBuilder((RouteSpec)content); _visitables.get("content").add(this.content);}
    if (content instanceof ProjectRequest){ this.content= new ProjectRequestBuilder((ProjectRequest)content); _visitables.get("content").add(this.content);}
    if (content instanceof Template){ this.content= new TemplateBuilder((Template)content); _visitables.get("content").add(this.content);}
    if (content instanceof ImageLookupPolicy){ this.content= new ImageLookupPolicyBuilder((ImageLookupPolicy)content); _visitables.get("content").add(this.content);}
    if (content instanceof OAuthClientAuthorization){ this.content= new OAuthClientAuthorizationBuilder((OAuthClientAuthorization)content); _visitables.get("content").add(this.content);}
    if (content instanceof ImageChangeCause){ this.content= new ImageChangeCauseBuilder((ImageChangeCause)content); _visitables.get("content").add(this.content);}
    if (content instanceof AllowedFlexVolume){ this.content= new AllowedFlexVolumeBuilder((AllowedFlexVolume)content); _visitables.get("content").add(this.content);}
    if (content instanceof SubjectAccessReview){ this.content= new SubjectAccessReviewBuilder((SubjectAccessReview)content); _visitables.get("content").add(this.content);}
    if (content instanceof LocalResourceAccessReview){ this.content= new LocalResourceAccessReviewBuilder((LocalResourceAccessReview)content); _visitables.get("content").add(this.content);}
    if (content instanceof ClusterRole){ this.content= new ClusterRoleBuilder((ClusterRole)content); _visitables.get("content").add(this.content);}
    if (content instanceof ConnectionConfig){ this.content= new ConnectionConfigBuilder((ConnectionConfig)content); _visitables.get("content").add(this.content);}
    if (content instanceof TagEventCondition){ this.content= new TagEventConditionBuilder((TagEventCondition)content); _visitables.get("content").add(this.content);}
    if (content instanceof LabelSelector){ this.content= new LabelSelectorBuilder((LabelSelector)content); _visitables.get("content").add(this.content);}
    if (content instanceof NetNamespaceList){ this.content= new NetNamespaceListBuilder((NetNamespaceList)content); _visitables.get("content").add(this.content);}
    if (content instanceof BrokerTemplateInstanceSpec){ this.content= new BrokerTemplateInstanceSpecBuilder((BrokerTemplateInstanceSpec)content); _visitables.get("content").add(this.content);}
    if (content instanceof BinaryBuildSource){ this.content= new BinaryBuildSourceBuilder((BinaryBuildSource)content); _visitables.get("content").add(this.content);}
    if (content instanceof OAuthClientAuthorizationList){ this.content= new OAuthClientAuthorizationListBuilder((OAuthClientAuthorizationList)content); _visitables.get("content").add(this.content);}
    if (content instanceof BuildSpec){ this.content= new BuildSpecBuilder((BuildSpec)content); _visitables.get("content").add(this.content);}
    if (content instanceof ProjectStatus){ this.content= new ProjectStatusBuilder((ProjectStatus)content); _visitables.get("content").add(this.content);}
    if (content instanceof LocalSubjectAccessReview){ this.content= new LocalSubjectAccessReviewBuilder((LocalSubjectAccessReview)content); _visitables.get("content").add(this.content);}
    if (content instanceof RollingDeploymentStrategyParams){ this.content= new RollingDeploymentStrategyParamsBuilder((RollingDeploymentStrategyParams)content); _visitables.get("content").add(this.content);}
    if (content instanceof GitSourceRevision){ this.content= new GitSourceRevisionBuilder((GitSourceRevision)content); _visitables.get("content").add(this.content);}
    if (content instanceof ImageLabel){ this.content= new ImageLabelBuilder((ImageLabel)content); _visitables.get("content").add(this.content);}
    if (content instanceof ImageChangeTrigger){ this.content= new ImageChangeTriggerBuilder((ImageChangeTrigger)content); _visitables.get("content").add(this.content);}
    if (content instanceof PodSecurityPolicyReviewSpec){ this.content= new PodSecurityPolicyReviewSpecBuilder((PodSecurityPolicyReviewSpec)content); _visitables.get("content").add(this.content);}
    if (content instanceof ImageTag){ this.content= new ImageTagBuilder((ImageTag)content); _visitables.get("content").add(this.content);}
    if (content instanceof ImageStreamImportSpec){ this.content= new ImageStreamImportSpecBuilder((ImageStreamImportSpec)content); _visitables.get("content").add(this.content);}
    if (content instanceof FSGroupStrategyOptions){ this.content= new FSGroupStrategyOptionsBuilder((FSGroupStrategyOptions)content); _visitables.get("content").add(this.content);}
    if (content instanceof PodSecurityPolicyReview){ this.content= new PodSecurityPolicyReviewBuilder((PodSecurityPolicyReview)content); _visitables.get("content").add(this.content);}
    if (content instanceof RecreateDeploymentStrategyParams){ this.content= new RecreateDeploymentStrategyParamsBuilder((RecreateDeploymentStrategyParams)content); _visitables.get("content").add(this.content);}
    if (content instanceof DockerStrategyOptions){ this.content= new DockerStrategyOptionsBuilder((DockerStrategyOptions)content); _visitables.get("content").add(this.content);}
    if (content instanceof ImageList){ this.content= new ImageListBuilder((ImageList)content); _visitables.get("content").add(this.content);}
    if (content instanceof ConfigMapBuildSource){ this.content= new ConfigMapBuildSourceBuilder((ConfigMapBuildSource)content); _visitables.get("content").add(this.content);}
    if (content instanceof ImageTagList){ this.content= new ImageTagListBuilder((ImageTagList)content); _visitables.get("content").add(this.content);}
    if (content instanceof OAuthAccessToken){ this.content= new OAuthAccessTokenBuilder((OAuthAccessToken)content); _visitables.get("content").add(this.content);}
    if (content instanceof DeploymentConfig){ this.content= new DeploymentConfigBuilder((DeploymentConfig)content); _visitables.get("content").add(this.content);}
    if (content instanceof RoleBinding){ this.content= new RoleBindingBuilder((RoleBinding)content); _visitables.get("content").add(this.content);}
    if (content instanceof Image){ this.content= new ImageBuilder((Image)content); _visitables.get("content").add(this.content);}
    if (content instanceof TLSConfig){ this.content= new TLSConfigBuilder((TLSConfig)content); _visitables.get("content").add(this.content);}
    if (content instanceof BuildVolume){ this.content= new BuildVolumeBuilder((BuildVolume)content); _visitables.get("content").add(this.content);}
    if (content instanceof TemplateInstanceSpec){ this.content= new TemplateInstanceSpecBuilder((TemplateInstanceSpec)content); _visitables.get("content").add(this.content);}
    if (content instanceof BuildStatus){ this.content= new BuildStatusBuilder((BuildStatus)content); _visitables.get("content").add(this.content);}
    if (content instanceof ImageSource){ this.content= new ImageSourceBuilder((ImageSource)content); _visitables.get("content").add(this.content);}
    if (content instanceof ObjectMeta){ this.content= new ObjectMetaBuilder((ObjectMeta)content); _visitables.get("content").add(this.content);}
    if (content instanceof PersistentVolumeClaim){ this.content= new PersistentVolumeClaimBuilder((PersistentVolumeClaim)content); _visitables.get("content").add(this.content);}
    if (content instanceof PodSecurityPolicySelfSubjectReview){ this.content= new PodSecurityPolicySelfSubjectReviewBuilder((PodSecurityPolicySelfSubjectReview)content); _visitables.get("content").add(this.content);}
    if (content instanceof TagReference){ this.content= new TagReferenceBuilder((TagReference)content); _visitables.get("content").add(this.content);}
    if (content instanceof EgressNetworkPolicyRule){ this.content= new EgressNetworkPolicyRuleBuilder((EgressNetworkPolicyRule)content); _visitables.get("content").add(this.content);}
    if (content instanceof SubjectRulesReviewStatus){ this.content= new SubjectRulesReviewStatusBuilder((SubjectRulesReviewStatus)content); _visitables.get("content").add(this.content);}
    if (content instanceof BuildVolumeMount){ this.content= new BuildVolumeMountBuilder((BuildVolumeMount)content); _visitables.get("content").add(this.content);}
    if (content instanceof ClusterNetworkEntry){ this.content= new ClusterNetworkEntryBuilder((ClusterNetworkEntry)content); _visitables.get("content").add(this.content);}
    if (content instanceof TemplateInstanceObject){ this.content= new TemplateInstanceObjectBuilder((TemplateInstanceObject)content); _visitables.get("content").add(this.content);}
    if (content instanceof BuildSource){ this.content= new BuildSourceBuilder((BuildSource)content); _visitables.get("content").add(this.content);}
    if (content instanceof ClusterResourceQuotaStatus){ this.content= new ClusterResourceQuotaStatusBuilder((ClusterResourceQuotaStatus)content); _visitables.get("content").add(this.content);}
    if (content instanceof DeploymentCondition){ this.content= new DeploymentConditionBuilder((DeploymentCondition)content); _visitables.get("content").add(this.content);}
    if (content instanceof HelmChartRepositorySpec){ this.content= new HelmChartRepositorySpecBuilder((HelmChartRepositorySpec)content); _visitables.get("content").add(this.content);}
    if (content instanceof DeploymentCauseImageTrigger){ this.content= new DeploymentCauseImageTriggerBuilder((DeploymentCauseImageTrigger)content); _visitables.get("content").add(this.content);}
    if (content instanceof ImageStreamMapping){ this.content= new ImageStreamMappingBuilder((ImageStreamMapping)content); _visitables.get("content").add(this.content);}
    if (content instanceof SubjectRulesReview){ this.content= new SubjectRulesReviewBuilder((SubjectRulesReview)content); _visitables.get("content").add(this.content);}
    if (content instanceof Role){ this.content= new RoleBuilder((Role)content); _visitables.get("content").add(this.content);}
    if (content instanceof GitBuildSource){ this.content= new GitBuildSourceBuilder((GitBuildSource)content); _visitables.get("content").add(this.content);}
    if (content instanceof EgressNetworkPolicyList){ this.content= new EgressNetworkPolicyListBuilder((EgressNetworkPolicyList)content); _visitables.get("content").add(this.content);}
    if (content instanceof SelfSubjectRulesReviewSpec){ this.content= new SelfSubjectRulesReviewSpecBuilder((SelfSubjectRulesReviewSpec)content); _visitables.get("content").add(this.content);}
    if (content instanceof ImageSourcePath){ this.content= new ImageSourcePathBuilder((ImageSourcePath)content); _visitables.get("content").add(this.content);}
    if (content instanceof BuildConfigStatus){ this.content= new BuildConfigStatusBuilder((BuildConfigStatus)content); _visitables.get("content").add(this.content);}
    if (content instanceof ResourceQuotaStatusByNamespace){ this.content= new ResourceQuotaStatusByNamespaceBuilder((ResourceQuotaStatusByNamespace)content); _visitables.get("content").add(this.content);}
    if (content instanceof SourceBuildStrategy){ this.content= new SourceBuildStrategyBuilder((SourceBuildStrategy)content); _visitables.get("content").add(this.content);}
    if (content instanceof Parameter){ this.content= new ParameterBuilder((Parameter)content); _visitables.get("content").add(this.content);}
    if (content instanceof RoleBindingList){ this.content= new RoleBindingListBuilder((RoleBindingList)content); _visitables.get("content").add(this.content);}
    if (content instanceof PodSecurityPolicySelfSubjectReviewSpec){ this.content= new PodSecurityPolicySelfSubjectReviewSpecBuilder((PodSecurityPolicySelfSubjectReviewSpec)content); _visitables.get("content").add(this.content);}
    if (content instanceof BrokerTemplateInstance){ this.content= new BrokerTemplateInstanceBuilder((BrokerTemplateInstance)content); _visitables.get("content").add(this.content);}
    if (content instanceof BuildPostCommitSpec){ this.content= new BuildPostCommitSpecBuilder((BuildPostCommitSpec)content); _visitables.get("content").add(this.content);}
    if (content instanceof OAuthAuthorizeTokenList){ this.content= new OAuthAuthorizeTokenListBuilder((OAuthAuthorizeTokenList)content); _visitables.get("content").add(this.content);}
    if (content instanceof DeploymentStrategy){ this.content= new DeploymentStrategyBuilder((DeploymentStrategy)content); _visitables.get("content").add(this.content);}
    if (content instanceof SignatureSubject){ this.content= new SignatureSubjectBuilder((SignatureSubject)content); _visitables.get("content").add(this.content);}
    if (content instanceof HostSubnetList){ this.content= new HostSubnetListBuilder((HostSubnetList)content); _visitables.get("content").add(this.content);}
    if (content instanceof RouteIngressCondition){ this.content= new RouteIngressConditionBuilder((RouteIngressCondition)content); _visitables.get("content").add(this.content);}
    if (content instanceof CustomDeploymentStrategyParams){ this.content= new CustomDeploymentStrategyParamsBuilder((CustomDeploymentStrategyParams)content); _visitables.get("content").add(this.content);}
    if (content instanceof ImageImportSpec){ this.content= new ImageImportSpecBuilder((ImageImportSpec)content); _visitables.get("content").add(this.content);}
    if (content instanceof StageInfo){ this.content= new StageInfoBuilder((StageInfo)content); _visitables.get("content").add(this.content);}
    if (content instanceof RoleBindingRestrictionSpec){ this.content= new RoleBindingRestrictionSpecBuilder((RoleBindingRestrictionSpec)content); _visitables.get("content").add(this.content);}
    if (content instanceof IDRange){ this.content= new IDRangeBuilder((IDRange)content); _visitables.get("content").add(this.content);}
    if (content instanceof UserList){ this.content= new UserListBuilder((UserList)content); _visitables.get("content").add(this.content);}
    if (content instanceof BuildConfigSpec){ this.content= new BuildConfigSpecBuilder((BuildConfigSpec)content); _visitables.get("content").add(this.content);}
    if (content instanceof User){ this.content= new UserBuilder((User)content); _visitables.get("content").add(this.content);}
    if (content instanceof ImageStreamImage){ this.content= new ImageStreamImageBuilder((ImageStreamImage)content); _visitables.get("content").add(this.content);}
    if (content instanceof BuildStatusOutputTo){ this.content= new BuildStatusOutputToBuilder((BuildStatusOutputTo)content); _visitables.get("content").add(this.content);}
    if (content instanceof BuildCondition){ this.content= new BuildConditionBuilder((BuildCondition)content); _visitables.get("content").add(this.content);}
    if (content instanceof ResourceAccessReviewResponse){ this.content= new ResourceAccessReviewResponseBuilder((ResourceAccessReviewResponse)content); _visitables.get("content").add(this.content);}
    if (content instanceof ExecNewPodHook){ this.content= new ExecNewPodHookBuilder((ExecNewPodHook)content); _visitables.get("content").add(this.content);}
    if (content instanceof SecretSpec){ this.content= new SecretSpecBuilder((SecretSpec)content); _visitables.get("content").add(this.content);}
    if (content instanceof ClusterRoleBindingList){ this.content= new ClusterRoleBindingListBuilder((ClusterRoleBindingList)content); _visitables.get("content").add(this.content);}
    if (content instanceof EgressNetworkPolicyPeer){ this.content= new EgressNetworkPolicyPeerBuilder((EgressNetworkPolicyPeer)content); _visitables.get("content").add(this.content);}
    if (content instanceof TemplateInstance){ this.content= new TemplateInstanceBuilder((TemplateInstance)content); _visitables.get("content").add(this.content);}
    if (content instanceof WebHookTrigger){ this.content= new WebHookTriggerBuilder((WebHookTrigger)content); _visitables.get("content").add(this.content);}
    if (content instanceof ServiceAccountReference){ this.content= new ServiceAccountReferenceBuilder((ServiceAccountReference)content); _visitables.get("content").add(this.content);}
    if (content instanceof Build){ this.content= new BuildBuilder((Build)content); _visitables.get("content").add(this.content);}
    if (content instanceof RoleBindingRestriction){ this.content= new RoleBindingRestrictionBuilder((RoleBindingRestriction)content); _visitables.get("content").add(this.content);}
    if (content instanceof TagImportPolicy){ this.content= new TagImportPolicyBuilder((TagImportPolicy)content); _visitables.get("content").add(this.content);}
    if (content instanceof ImageStreamTag){ this.content= new ImageStreamTagBuilder((ImageStreamTag)content); _visitables.get("content").add(this.content);}
    if (content instanceof BuildTriggerPolicy){ this.content= new BuildTriggerPolicyBuilder((BuildTriggerPolicy)content); _visitables.get("content").add(this.content);}
    if (content instanceof RoutePort){ this.content= new RoutePortBuilder((RoutePort)content); _visitables.get("content").add(this.content);}
    if (content instanceof TemplateInstanceRequester){ this.content= new TemplateInstanceRequesterBuilder((TemplateInstanceRequester)content); _visitables.get("content").add(this.content);}
    if (content instanceof Group){ this.content= new GroupBuilder((Group)content); _visitables.get("content").add(this.content);}
    if (content instanceof BuildTriggerCause){ this.content= new BuildTriggerCauseBuilder((BuildTriggerCause)content); _visitables.get("content").add(this.content);}
    if (content instanceof ImageSignature){ this.content= new ImageSignatureBuilder((ImageSignature)content); _visitables.get("content").add(this.content);}
    if (content instanceof HelmChartRepositoryStatus){ this.content= new HelmChartRepositoryStatusBuilder((HelmChartRepositoryStatus)content); _visitables.get("content").add(this.content);}
    if (content instanceof DeploymentConfigSpec){ this.content= new DeploymentConfigSpecBuilder((DeploymentConfigSpec)content); _visitables.get("content").add(this.content);}
    if (content instanceof HostSubnet){ this.content= new HostSubnetBuilder((HostSubnet)content); _visitables.get("content").add(this.content);}
    if (content instanceof GroupRestriction){ this.content= new GroupRestrictionBuilder((GroupRestriction)content); _visitables.get("content").add(this.content);}
    if (content instanceof AppliedClusterResourceQuota){ this.content= new AppliedClusterResourceQuotaBuilder((AppliedClusterResourceQuota)content); _visitables.get("content").add(this.content);}
    if (content instanceof OAuthAccessTokenList){ this.content= new OAuthAccessTokenListBuilder((OAuthAccessTokenList)content); _visitables.get("content").add(this.content);}
    if (content instanceof JenkinsPipelineBuildStrategy){ this.content= new JenkinsPipelineBuildStrategyBuilder((JenkinsPipelineBuildStrategy)content); _visitables.get("content").add(this.content);}
    if (content instanceof SecurityContextConstraints){ this.content= new SecurityContextConstraintsBuilder((SecurityContextConstraints)content); _visitables.get("content").add(this.content);}
    if (content instanceof SupplementalGroupsStrategyOptions){ this.content= new SupplementalGroupsStrategyOptionsBuilder((SupplementalGroupsStrategyOptions)content); _visitables.get("content").add(this.content);}
    if (content instanceof ServiceAccountPodSecurityPolicyReviewStatus){ this.content= new ServiceAccountPodSecurityPolicyReviewStatusBuilder((ServiceAccountPodSecurityPolicyReviewStatus)content); _visitables.get("content").add(this.content);}
    if (content instanceof BuildRequest){ this.content= new BuildRequestBuilder((BuildRequest)content); _visitables.get("content").add(this.content);}
    if (content instanceof SELinuxContextStrategyOptions){ this.content= new SELinuxContextStrategyOptionsBuilder((SELinuxContextStrategyOptions)content); _visitables.get("content").add(this.content);}
    if (content instanceof ClusterRoleList){ this.content= new ClusterRoleListBuilder((ClusterRoleList)content); _visitables.get("content").add(this.content);}
    if (content instanceof RouteList){ this.content= new RouteListBuilder((RouteList)content); _visitables.get("content").add(this.content);}
    if (content instanceof ImageStreamStatus){ this.content= new ImageStreamStatusBuilder((ImageStreamStatus)content); _visitables.get("content").add(this.content);}
    if (content instanceof EgressNetworkPolicy){ this.content= new EgressNetworkPolicyBuilder((EgressNetworkPolicy)content); _visitables.get("content").add(this.content);}
    if (content instanceof NetNamespace){ this.content= new NetNamespaceBuilder((NetNamespace)content); _visitables.get("content").add(this.content);}
    if (content instanceof UserIdentityMapping){ this.content= new UserIdentityMappingBuilder((UserIdentityMapping)content); _visitables.get("content").add(this.content);}
    if (content instanceof DeploymentDetails){ this.content= new DeploymentDetailsBuilder((DeploymentDetails)content); _visitables.get("content").add(this.content);}
    if (content instanceof PodSecurityPolicySubjectReviewStatus){ this.content= new PodSecurityPolicySubjectReviewStatusBuilder((PodSecurityPolicySubjectReviewStatus)content); _visitables.get("content").add(this.content);}
    if (content instanceof PodSecurityPolicySubjectReviewSpec){ this.content= new PodSecurityPolicySubjectReviewSpecBuilder((PodSecurityPolicySubjectReviewSpec)content); _visitables.get("content").add(this.content);}
    if (content instanceof ImageStream){ this.content= new ImageStreamBuilder((ImageStream)content); _visitables.get("content").add(this.content);}
    if (content instanceof BuildList){ this.content= new BuildListBuilder((BuildList)content); _visitables.get("content").add(this.content);}
    if (content instanceof TemplateList){ this.content= new TemplateListBuilder((TemplateList)content); _visitables.get("content").add(this.content);}
    if (content instanceof BuildOutput){ this.content= new BuildOutputBuilder((BuildOutput)content); _visitables.get("content").add(this.content);}
    if (content instanceof ProjectSpec){ this.content= new ProjectSpecBuilder((ProjectSpec)content); _visitables.get("content").add(this.content);}
    if (content instanceof SourceRevision){ this.content= new SourceRevisionBuilder((SourceRevision)content); _visitables.get("content").add(this.content);}
    if (content instanceof ObjectReference){ this.content= new ObjectReferenceBuilder((ObjectReference)content); _visitables.get("content").add(this.content);}
    if (content instanceof SignatureIssuer){ this.content= new SignatureIssuerBuilder((SignatureIssuer)content); _visitables.get("content").add(this.content);}
    if (content instanceof ImageLayer){ this.content= new ImageLayerBuilder((ImageLayer)content); _visitables.get("content").add(this.content);}
    if (content instanceof ClusterResourceQuotaSpec){ this.content= new ClusterResourceQuotaSpecBuilder((ClusterResourceQuotaSpec)content); _visitables.get("content").add(this.content);}
    if (content instanceof ImageStreamSpec){ this.content= new ImageStreamSpecBuilder((ImageStreamSpec)content); _visitables.get("content").add(this.content);}
    if (content instanceof RouteIngress){ this.content= new RouteIngressBuilder((RouteIngress)content); _visitables.get("content").add(this.content);}
    if (content instanceof OAuthClient){ this.content= new OAuthClientBuilder((OAuthClient)content); _visitables.get("content").add(this.content);}
    if (content instanceof Identity){ this.content= new IdentityBuilder((Identity)content); _visitables.get("content").add(this.content);}
    if (content instanceof RangeAllocationList){ this.content= new RangeAllocationListBuilder((RangeAllocationList)content); _visitables.get("content").add(this.content);}
    return (A) this;
  }
  public Boolean hasContent() {
    return this.content != null;
  }
  public A withGenericWebHookCauseContent(GenericWebHookCause genericWebHookCauseContent) {
    _visitables.get("content").remove(this.content);
    if (genericWebHookCauseContent!=null){ this.content= new GenericWebHookCauseBuilder(genericWebHookCauseContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.GenericWebHookCauseContentNested<A> withNewGenericWebHookCauseContent() {
    return new LocalSubjectAccessReviewFluentImpl.GenericWebHookCauseContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.GenericWebHookCauseContentNested<A> withNewGenericWebHookCauseContentLike(GenericWebHookCause item) {
    return new LocalSubjectAccessReviewFluentImpl.GenericWebHookCauseContentNestedImpl(item);
  }
  public A withServiceAccountRestrictionContent(ServiceAccountRestriction serviceAccountRestrictionContent) {
    _visitables.get("content").remove(this.content);
    if (serviceAccountRestrictionContent!=null){ this.content= new ServiceAccountRestrictionBuilder(serviceAccountRestrictionContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.ServiceAccountRestrictionContentNested<A> withNewServiceAccountRestrictionContent() {
    return new LocalSubjectAccessReviewFluentImpl.ServiceAccountRestrictionContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.ServiceAccountRestrictionContentNested<A> withNewServiceAccountRestrictionContentLike(ServiceAccountRestriction item) {
    return new LocalSubjectAccessReviewFluentImpl.ServiceAccountRestrictionContentNestedImpl(item);
  }
  public A withScopeRestrictionContent(ScopeRestriction scopeRestrictionContent) {
    _visitables.get("content").remove(this.content);
    if (scopeRestrictionContent!=null){ this.content= new ScopeRestrictionBuilder(scopeRestrictionContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.ScopeRestrictionContentNested<A> withNewScopeRestrictionContent() {
    return new LocalSubjectAccessReviewFluentImpl.ScopeRestrictionContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.ScopeRestrictionContentNested<A> withNewScopeRestrictionContentLike(ScopeRestriction item) {
    return new LocalSubjectAccessReviewFluentImpl.ScopeRestrictionContentNestedImpl(item);
  }
  public A withSecretLocalReferenceContent(SecretLocalReference secretLocalReferenceContent) {
    _visitables.get("content").remove(this.content);
    if (secretLocalReferenceContent!=null){ this.content= new SecretLocalReferenceBuilder(secretLocalReferenceContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.SecretLocalReferenceContentNested<A> withNewSecretLocalReferenceContent() {
    return new LocalSubjectAccessReviewFluentImpl.SecretLocalReferenceContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.SecretLocalReferenceContentNested<A> withNewSecretLocalReferenceContentLike(SecretLocalReference item) {
    return new LocalSubjectAccessReviewFluentImpl.SecretLocalReferenceContentNestedImpl(item);
  }
  public A withNewSecretLocalReferenceContent(String name) {
    return (A)withSecretLocalReferenceContent(new SecretLocalReference(name));
  }
  public A withStepInfoContent(StepInfo stepInfoContent) {
    _visitables.get("content").remove(this.content);
    if (stepInfoContent!=null){ this.content= new StepInfoBuilder(stepInfoContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.StepInfoContentNested<A> withNewStepInfoContent() {
    return new LocalSubjectAccessReviewFluentImpl.StepInfoContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.StepInfoContentNested<A> withNewStepInfoContentLike(StepInfo item) {
    return new LocalSubjectAccessReviewFluentImpl.StepInfoContentNestedImpl(item);
  }
  public A withNewStepInfoContent(Long durationMilliseconds,String name,String startTime) {
    return (A)withStepInfoContent(new StepInfo(durationMilliseconds, name, startTime));
  }
  public A withUserRestrictionContent(UserRestriction userRestrictionContent) {
    _visitables.get("content").remove(this.content);
    if (userRestrictionContent!=null){ this.content= new UserRestrictionBuilder(userRestrictionContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.UserRestrictionContentNested<A> withNewUserRestrictionContent() {
    return new LocalSubjectAccessReviewFluentImpl.UserRestrictionContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.UserRestrictionContentNested<A> withNewUserRestrictionContentLike(UserRestriction item) {
    return new LocalSubjectAccessReviewFluentImpl.UserRestrictionContentNestedImpl(item);
  }
  public A withPodTemplateSpecContent(PodTemplateSpec podTemplateSpecContent) {
    _visitables.get("content").remove(this.content);
    if (podTemplateSpecContent!=null){ this.content= new PodTemplateSpecBuilder(podTemplateSpecContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.PodTemplateSpecContentNested<A> withNewPodTemplateSpecContent() {
    return new LocalSubjectAccessReviewFluentImpl.PodTemplateSpecContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.PodTemplateSpecContentNested<A> withNewPodTemplateSpecContentLike(PodTemplateSpec item) {
    return new LocalSubjectAccessReviewFluentImpl.PodTemplateSpecContentNestedImpl(item);
  }
  public A withTemplateInstanceListContent(TemplateInstanceList templateInstanceListContent) {
    _visitables.get("content").remove(this.content);
    if (templateInstanceListContent!=null){ this.content= new TemplateInstanceListBuilder(templateInstanceListContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.TemplateInstanceListContentNested<A> withNewTemplateInstanceListContent() {
    return new LocalSubjectAccessReviewFluentImpl.TemplateInstanceListContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.TemplateInstanceListContentNested<A> withNewTemplateInstanceListContentLike(TemplateInstanceList item) {
    return new LocalSubjectAccessReviewFluentImpl.TemplateInstanceListContentNestedImpl(item);
  }
  public A withImageStreamImportContent(ImageStreamImport imageStreamImportContent) {
    _visitables.get("content").remove(this.content);
    if (imageStreamImportContent!=null){ this.content= new ImageStreamImportBuilder(imageStreamImportContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.ImageStreamImportContentNested<A> withNewImageStreamImportContent() {
    return new LocalSubjectAccessReviewFluentImpl.ImageStreamImportContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.ImageStreamImportContentNested<A> withNewImageStreamImportContentLike(ImageStreamImport item) {
    return new LocalSubjectAccessReviewFluentImpl.ImageStreamImportContentNestedImpl(item);
  }
  public A withResourceRequirementsContent(ResourceRequirements resourceRequirementsContent) {
    _visitables.get("content").remove(this.content);
    if (resourceRequirementsContent!=null){ this.content= new ResourceRequirementsBuilder(resourceRequirementsContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.ResourceRequirementsContentNested<A> withNewResourceRequirementsContent() {
    return new LocalSubjectAccessReviewFluentImpl.ResourceRequirementsContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.ResourceRequirementsContentNested<A> withNewResourceRequirementsContentLike(ResourceRequirements item) {
    return new LocalSubjectAccessReviewFluentImpl.ResourceRequirementsContentNestedImpl(item);
  }
  public A withGitHubWebHookCauseContent(GitHubWebHookCause gitHubWebHookCauseContent) {
    _visitables.get("content").remove(this.content);
    if (gitHubWebHookCauseContent!=null){ this.content= new GitHubWebHookCauseBuilder(gitHubWebHookCauseContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.GitHubWebHookCauseContentNested<A> withNewGitHubWebHookCauseContent() {
    return new LocalSubjectAccessReviewFluentImpl.GitHubWebHookCauseContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.GitHubWebHookCauseContentNested<A> withNewGitHubWebHookCauseContentLike(GitHubWebHookCause item) {
    return new LocalSubjectAccessReviewFluentImpl.GitHubWebHookCauseContentNestedImpl(item);
  }
  public A withOAuthClientListContent(OAuthClientList oAuthClientListContent) {
    _visitables.get("content").remove(this.content);
    if (oAuthClientListContent!=null){ this.content= new OAuthClientListBuilder(oAuthClientListContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.OAuthClientListContentNested<A> withNewOAuthClientListContent() {
    return new LocalSubjectAccessReviewFluentImpl.OAuthClientListContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.OAuthClientListContentNested<A> withNewOAuthClientListContentLike(OAuthClientList item) {
    return new LocalSubjectAccessReviewFluentImpl.OAuthClientListContentNestedImpl(item);
  }
  public A withPodSecurityPolicyReviewStatusContent(PodSecurityPolicyReviewStatus podSecurityPolicyReviewStatusContent) {
    _visitables.get("content").remove(this.content);
    if (podSecurityPolicyReviewStatusContent!=null){ this.content= new PodSecurityPolicyReviewStatusBuilder(podSecurityPolicyReviewStatusContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.PodSecurityPolicyReviewStatusContentNested<A> withNewPodSecurityPolicyReviewStatusContent() {
    return new LocalSubjectAccessReviewFluentImpl.PodSecurityPolicyReviewStatusContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.PodSecurityPolicyReviewStatusContentNested<A> withNewPodSecurityPolicyReviewStatusContentLike(PodSecurityPolicyReviewStatus item) {
    return new LocalSubjectAccessReviewFluentImpl.PodSecurityPolicyReviewStatusContentNestedImpl(item);
  }
  public A withTemplateInstanceStatusContent(TemplateInstanceStatus templateInstanceStatusContent) {
    _visitables.get("content").remove(this.content);
    if (templateInstanceStatusContent!=null){ this.content= new TemplateInstanceStatusBuilder(templateInstanceStatusContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.TemplateInstanceStatusContentNested<A> withNewTemplateInstanceStatusContent() {
    return new LocalSubjectAccessReviewFluentImpl.TemplateInstanceStatusContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.TemplateInstanceStatusContentNested<A> withNewTemplateInstanceStatusContentLike(TemplateInstanceStatus item) {
    return new LocalSubjectAccessReviewFluentImpl.TemplateInstanceStatusContentNestedImpl(item);
  }
  public A withHelmChartRepositoryListContent(HelmChartRepositoryList helmChartRepositoryListContent) {
    _visitables.get("content").remove(this.content);
    if (helmChartRepositoryListContent!=null){ this.content= new HelmChartRepositoryListBuilder(helmChartRepositoryListContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.HelmChartRepositoryListContentNested<A> withNewHelmChartRepositoryListContent() {
    return new LocalSubjectAccessReviewFluentImpl.HelmChartRepositoryListContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.HelmChartRepositoryListContentNested<A> withNewHelmChartRepositoryListContentLike(HelmChartRepositoryList item) {
    return new LocalSubjectAccessReviewFluentImpl.HelmChartRepositoryListContentNestedImpl(item);
  }
  public A withPolicyRuleContent(PolicyRule policyRuleContent) {
    _visitables.get("content").remove(this.content);
    if (policyRuleContent!=null){ this.content= new PolicyRuleBuilder(policyRuleContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.PolicyRuleContentNested<A> withNewPolicyRuleContent() {
    return new LocalSubjectAccessReviewFluentImpl.PolicyRuleContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.PolicyRuleContentNested<A> withNewPolicyRuleContentLike(PolicyRule item) {
    return new LocalSubjectAccessReviewFluentImpl.PolicyRuleContentNestedImpl(item);
  }
  public A withDeploymentTriggerPolicyContent(DeploymentTriggerPolicy deploymentTriggerPolicyContent) {
    _visitables.get("content").remove(this.content);
    if (deploymentTriggerPolicyContent!=null){ this.content= new DeploymentTriggerPolicyBuilder(deploymentTriggerPolicyContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.DeploymentTriggerPolicyContentNested<A> withNewDeploymentTriggerPolicyContent() {
    return new LocalSubjectAccessReviewFluentImpl.DeploymentTriggerPolicyContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.DeploymentTriggerPolicyContentNested<A> withNewDeploymentTriggerPolicyContentLike(DeploymentTriggerPolicy item) {
    return new LocalSubjectAccessReviewFluentImpl.DeploymentTriggerPolicyContentNestedImpl(item);
  }
  public A withBuildStrategyContent(BuildStrategy buildStrategyContent) {
    _visitables.get("content").remove(this.content);
    if (buildStrategyContent!=null){ this.content= new BuildStrategyBuilder(buildStrategyContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.BuildStrategyContentNested<A> withNewBuildStrategyContent() {
    return new LocalSubjectAccessReviewFluentImpl.BuildStrategyContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.BuildStrategyContentNested<A> withNewBuildStrategyContentLike(BuildStrategy item) {
    return new LocalSubjectAccessReviewFluentImpl.BuildStrategyContentNestedImpl(item);
  }
  public A withRepositoryImportSpecContent(RepositoryImportSpec repositoryImportSpecContent) {
    _visitables.get("content").remove(this.content);
    if (repositoryImportSpecContent!=null){ this.content= new RepositoryImportSpecBuilder(repositoryImportSpecContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.RepositoryImportSpecContentNested<A> withNewRepositoryImportSpecContent() {
    return new LocalSubjectAccessReviewFluentImpl.RepositoryImportSpecContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.RepositoryImportSpecContentNested<A> withNewRepositoryImportSpecContentLike(RepositoryImportSpec item) {
    return new LocalSubjectAccessReviewFluentImpl.RepositoryImportSpecContentNestedImpl(item);
  }
  public A withBrokerTemplateInstanceListContent(BrokerTemplateInstanceList brokerTemplateInstanceListContent) {
    _visitables.get("content").remove(this.content);
    if (brokerTemplateInstanceListContent!=null){ this.content= new BrokerTemplateInstanceListBuilder(brokerTemplateInstanceListContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.BrokerTemplateInstanceListContentNested<A> withNewBrokerTemplateInstanceListContent() {
    return new LocalSubjectAccessReviewFluentImpl.BrokerTemplateInstanceListContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.BrokerTemplateInstanceListContentNested<A> withNewBrokerTemplateInstanceListContentLike(BrokerTemplateInstanceList item) {
    return new LocalSubjectAccessReviewFluentImpl.BrokerTemplateInstanceListContentNestedImpl(item);
  }
  public A withImageStreamImportStatusContent(ImageStreamImportStatus imageStreamImportStatusContent) {
    _visitables.get("content").remove(this.content);
    if (imageStreamImportStatusContent!=null){ this.content= new ImageStreamImportStatusBuilder(imageStreamImportStatusContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.ImageStreamImportStatusContentNested<A> withNewImageStreamImportStatusContent() {
    return new LocalSubjectAccessReviewFluentImpl.ImageStreamImportStatusContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.ImageStreamImportStatusContentNested<A> withNewImageStreamImportStatusContentLike(ImageStreamImportStatus item) {
    return new LocalSubjectAccessReviewFluentImpl.ImageStreamImportStatusContentNestedImpl(item);
  }
  public A withCustomBuildStrategyContent(CustomBuildStrategy customBuildStrategyContent) {
    _visitables.get("content").remove(this.content);
    if (customBuildStrategyContent!=null){ this.content= new CustomBuildStrategyBuilder(customBuildStrategyContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.CustomBuildStrategyContentNested<A> withNewCustomBuildStrategyContent() {
    return new LocalSubjectAccessReviewFluentImpl.CustomBuildStrategyContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.CustomBuildStrategyContentNested<A> withNewCustomBuildStrategyContentLike(CustomBuildStrategy item) {
    return new LocalSubjectAccessReviewFluentImpl.CustomBuildStrategyContentNestedImpl(item);
  }
  public A withClusterResourceQuotaSelectorContent(ClusterResourceQuotaSelector clusterResourceQuotaSelectorContent) {
    _visitables.get("content").remove(this.content);
    if (clusterResourceQuotaSelectorContent!=null){ this.content= new ClusterResourceQuotaSelectorBuilder(clusterResourceQuotaSelectorContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.ClusterResourceQuotaSelectorContentNested<A> withNewClusterResourceQuotaSelectorContent() {
    return new LocalSubjectAccessReviewFluentImpl.ClusterResourceQuotaSelectorContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.ClusterResourceQuotaSelectorContentNested<A> withNewClusterResourceQuotaSelectorContentLike(ClusterResourceQuotaSelector item) {
    return new LocalSubjectAccessReviewFluentImpl.ClusterResourceQuotaSelectorContentNestedImpl(item);
  }
  public A withSubjectAccessReviewResponseContent(SubjectAccessReviewResponse subjectAccessReviewResponseContent) {
    _visitables.get("content").remove(this.content);
    if (subjectAccessReviewResponseContent!=null){ this.content= new SubjectAccessReviewResponseBuilder(subjectAccessReviewResponseContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.SubjectAccessReviewResponseContentNested<A> withNewSubjectAccessReviewResponseContent() {
    return new LocalSubjectAccessReviewFluentImpl.SubjectAccessReviewResponseContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.SubjectAccessReviewResponseContentNested<A> withNewSubjectAccessReviewResponseContentLike(SubjectAccessReviewResponse item) {
    return new LocalSubjectAccessReviewFluentImpl.SubjectAccessReviewResponseContentNestedImpl(item);
  }
  public A withDeploymentTriggerImageChangeParamsContent(DeploymentTriggerImageChangeParams deploymentTriggerImageChangeParamsContent) {
    _visitables.get("content").remove(this.content);
    if (deploymentTriggerImageChangeParamsContent!=null){ this.content= new DeploymentTriggerImageChangeParamsBuilder(deploymentTriggerImageChangeParamsContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.DeploymentTriggerImageChangeParamsContentNested<A> withNewDeploymentTriggerImageChangeParamsContent() {
    return new LocalSubjectAccessReviewFluentImpl.DeploymentTriggerImageChangeParamsContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.DeploymentTriggerImageChangeParamsContentNested<A> withNewDeploymentTriggerImageChangeParamsContentLike(DeploymentTriggerImageChangeParams item) {
    return new LocalSubjectAccessReviewFluentImpl.DeploymentTriggerImageChangeParamsContentNestedImpl(item);
  }
  public A withLocalObjectReferenceContent(LocalObjectReference localObjectReferenceContent) {
    _visitables.get("content").remove(this.content);
    if (localObjectReferenceContent!=null){ this.content= new LocalObjectReferenceBuilder(localObjectReferenceContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.LocalObjectReferenceContentNested<A> withNewLocalObjectReferenceContent() {
    return new LocalSubjectAccessReviewFluentImpl.LocalObjectReferenceContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.LocalObjectReferenceContentNested<A> withNewLocalObjectReferenceContentLike(LocalObjectReference item) {
    return new LocalSubjectAccessReviewFluentImpl.LocalObjectReferenceContentNestedImpl(item);
  }
  public A withNewLocalObjectReferenceContent(String name) {
    return (A)withLocalObjectReferenceContent(new LocalObjectReference(name));
  }
  public A withTagImageHookContent(TagImageHook tagImageHookContent) {
    _visitables.get("content").remove(this.content);
    if (tagImageHookContent!=null){ this.content= new TagImageHookBuilder(tagImageHookContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.TagImageHookContentNested<A> withNewTagImageHookContent() {
    return new LocalSubjectAccessReviewFluentImpl.TagImageHookContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.TagImageHookContentNested<A> withNewTagImageHookContentLike(TagImageHook item) {
    return new LocalSubjectAccessReviewFluentImpl.TagImageHookContentNestedImpl(item);
  }
  public A withRouteTargetReferenceContent(RouteTargetReference routeTargetReferenceContent) {
    _visitables.get("content").remove(this.content);
    if (routeTargetReferenceContent!=null){ this.content= new RouteTargetReferenceBuilder(routeTargetReferenceContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.RouteTargetReferenceContentNested<A> withNewRouteTargetReferenceContent() {
    return new LocalSubjectAccessReviewFluentImpl.RouteTargetReferenceContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.RouteTargetReferenceContentNested<A> withNewRouteTargetReferenceContentLike(RouteTargetReference item) {
    return new LocalSubjectAccessReviewFluentImpl.RouteTargetReferenceContentNestedImpl(item);
  }
  public A withNewRouteTargetReferenceContent(String kind,String name,Integer weight) {
    return (A)withRouteTargetReferenceContent(new RouteTargetReference(kind, name, weight));
  }
  public A withRawExtensionContent(RawExtension rawExtensionContent) {
    _visitables.get("content").remove(this.content);
    if (rawExtensionContent!=null){ this.content= new RawExtensionBuilder(rawExtensionContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.RawExtensionContentNested<A> withNewRawExtensionContent() {
    return new LocalSubjectAccessReviewFluentImpl.RawExtensionContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.RawExtensionContentNested<A> withNewRawExtensionContentLike(RawExtension item) {
    return new LocalSubjectAccessReviewFluentImpl.RawExtensionContentNestedImpl(item);
  }
  public A withNewRawExtensionContent(Object value) {
    return (A)withRawExtensionContent(new RawExtension(value));
  }
  public A withSubjectRulesReviewSpecContent(SubjectRulesReviewSpec subjectRulesReviewSpecContent) {
    _visitables.get("content").remove(this.content);
    if (subjectRulesReviewSpecContent!=null){ this.content= new SubjectRulesReviewSpecBuilder(subjectRulesReviewSpecContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.SubjectRulesReviewSpecContentNested<A> withNewSubjectRulesReviewSpecContent() {
    return new LocalSubjectAccessReviewFluentImpl.SubjectRulesReviewSpecContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.SubjectRulesReviewSpecContentNested<A> withNewSubjectRulesReviewSpecContentLike(SubjectRulesReviewSpec item) {
    return new LocalSubjectAccessReviewFluentImpl.SubjectRulesReviewSpecContentNestedImpl(item);
  }
  public A withTagReferencePolicyContent(TagReferencePolicy tagReferencePolicyContent) {
    _visitables.get("content").remove(this.content);
    if (tagReferencePolicyContent!=null){ this.content= new TagReferencePolicyBuilder(tagReferencePolicyContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.TagReferencePolicyContentNested<A> withNewTagReferencePolicyContent() {
    return new LocalSubjectAccessReviewFluentImpl.TagReferencePolicyContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.TagReferencePolicyContentNested<A> withNewTagReferencePolicyContentLike(TagReferencePolicy item) {
    return new LocalSubjectAccessReviewFluentImpl.TagReferencePolicyContentNestedImpl(item);
  }
  public A withNewTagReferencePolicyContent(String type) {
    return (A)withTagReferencePolicyContent(new TagReferencePolicy(type));
  }
  public A withRoleListContent(RoleList roleListContent) {
    _visitables.get("content").remove(this.content);
    if (roleListContent!=null){ this.content= new RoleListBuilder(roleListContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.RoleListContentNested<A> withNewRoleListContent() {
    return new LocalSubjectAccessReviewFluentImpl.RoleListContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.RoleListContentNested<A> withNewRoleListContentLike(RoleList item) {
    return new LocalSubjectAccessReviewFluentImpl.RoleListContentNestedImpl(item);
  }
  public A withProjectContent(Project projectContent) {
    _visitables.get("content").remove(this.content);
    if (projectContent!=null){ this.content= new ProjectBuilder(projectContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.ProjectContentNested<A> withNewProjectContent() {
    return new LocalSubjectAccessReviewFluentImpl.ProjectContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.ProjectContentNested<A> withNewProjectContentLike(Project item) {
    return new LocalSubjectAccessReviewFluentImpl.ProjectContentNestedImpl(item);
  }
  public A withBuildVolumeSourceContent(BuildVolumeSource buildVolumeSourceContent) {
    _visitables.get("content").remove(this.content);
    if (buildVolumeSourceContent!=null){ this.content= new BuildVolumeSourceBuilder(buildVolumeSourceContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.BuildVolumeSourceContentNested<A> withNewBuildVolumeSourceContent() {
    return new LocalSubjectAccessReviewFluentImpl.BuildVolumeSourceContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.BuildVolumeSourceContentNested<A> withNewBuildVolumeSourceContentLike(BuildVolumeSource item) {
    return new LocalSubjectAccessReviewFluentImpl.BuildVolumeSourceContentNestedImpl(item);
  }
  public A withAppliedClusterResourceQuotaListContent(AppliedClusterResourceQuotaList appliedClusterResourceQuotaListContent) {
    _visitables.get("content").remove(this.content);
    if (appliedClusterResourceQuotaListContent!=null){ this.content= new AppliedClusterResourceQuotaListBuilder(appliedClusterResourceQuotaListContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.AppliedClusterResourceQuotaListContentNested<A> withNewAppliedClusterResourceQuotaListContent() {
    return new LocalSubjectAccessReviewFluentImpl.AppliedClusterResourceQuotaListContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.AppliedClusterResourceQuotaListContentNested<A> withNewAppliedClusterResourceQuotaListContentLike(AppliedClusterResourceQuotaList item) {
    return new LocalSubjectAccessReviewFluentImpl.AppliedClusterResourceQuotaListContentNestedImpl(item);
  }
  public A withDeploymentConfigListContent(DeploymentConfigList deploymentConfigListContent) {
    _visitables.get("content").remove(this.content);
    if (deploymentConfigListContent!=null){ this.content= new DeploymentConfigListBuilder(deploymentConfigListContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.DeploymentConfigListContentNested<A> withNewDeploymentConfigListContent() {
    return new LocalSubjectAccessReviewFluentImpl.DeploymentConfigListContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.DeploymentConfigListContentNested<A> withNewDeploymentConfigListContentLike(DeploymentConfigList item) {
    return new LocalSubjectAccessReviewFluentImpl.DeploymentConfigListContentNestedImpl(item);
  }
  public A withBuildStatusOutputContent(BuildStatusOutput buildStatusOutputContent) {
    _visitables.get("content").remove(this.content);
    if (buildStatusOutputContent!=null){ this.content= new BuildStatusOutputBuilder(buildStatusOutputContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.BuildStatusOutputContentNested<A> withNewBuildStatusOutputContent() {
    return new LocalSubjectAccessReviewFluentImpl.BuildStatusOutputContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.BuildStatusOutputContentNested<A> withNewBuildStatusOutputContentLike(BuildStatusOutput item) {
    return new LocalSubjectAccessReviewFluentImpl.BuildStatusOutputContentNestedImpl(item);
  }
  public A withBuildConfigContent(BuildConfig buildConfigContent) {
    _visitables.get("content").remove(this.content);
    if (buildConfigContent!=null){ this.content= new BuildConfigBuilder(buildConfigContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.BuildConfigContentNested<A> withNewBuildConfigContent() {
    return new LocalSubjectAccessReviewFluentImpl.BuildConfigContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.BuildConfigContentNested<A> withNewBuildConfigContentLike(BuildConfig item) {
    return new LocalSubjectAccessReviewFluentImpl.BuildConfigContentNestedImpl(item);
  }
  public A withImageImportStatusContent(ImageImportStatus imageImportStatusContent) {
    _visitables.get("content").remove(this.content);
    if (imageImportStatusContent!=null){ this.content= new ImageImportStatusBuilder(imageImportStatusContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.ImageImportStatusContentNested<A> withNewImageImportStatusContent() {
    return new LocalSubjectAccessReviewFluentImpl.ImageImportStatusContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.ImageImportStatusContentNested<A> withNewImageImportStatusContentLike(ImageImportStatus item) {
    return new LocalSubjectAccessReviewFluentImpl.ImageImportStatusContentNestedImpl(item);
  }
  public A withPodSecurityPolicySubjectReviewContent(PodSecurityPolicySubjectReview podSecurityPolicySubjectReviewContent) {
    _visitables.get("content").remove(this.content);
    if (podSecurityPolicySubjectReviewContent!=null){ this.content= new PodSecurityPolicySubjectReviewBuilder(podSecurityPolicySubjectReviewContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.PodSecurityPolicySubjectReviewContentNested<A> withNewPodSecurityPolicySubjectReviewContent() {
    return new LocalSubjectAccessReviewFluentImpl.PodSecurityPolicySubjectReviewContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.PodSecurityPolicySubjectReviewContentNested<A> withNewPodSecurityPolicySubjectReviewContentLike(PodSecurityPolicySubjectReview item) {
    return new LocalSubjectAccessReviewFluentImpl.PodSecurityPolicySubjectReviewContentNestedImpl(item);
  }
  public A withGitLabWebHookCauseContent(GitLabWebHookCause gitLabWebHookCauseContent) {
    _visitables.get("content").remove(this.content);
    if (gitLabWebHookCauseContent!=null){ this.content= new GitLabWebHookCauseBuilder(gitLabWebHookCauseContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.GitLabWebHookCauseContentNested<A> withNewGitLabWebHookCauseContent() {
    return new LocalSubjectAccessReviewFluentImpl.GitLabWebHookCauseContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.GitLabWebHookCauseContentNested<A> withNewGitLabWebHookCauseContentLike(GitLabWebHookCause item) {
    return new LocalSubjectAccessReviewFluentImpl.GitLabWebHookCauseContentNestedImpl(item);
  }
  public A withDeploymentConfigStatusContent(DeploymentConfigStatus deploymentConfigStatusContent) {
    _visitables.get("content").remove(this.content);
    if (deploymentConfigStatusContent!=null){ this.content= new DeploymentConfigStatusBuilder(deploymentConfigStatusContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.DeploymentConfigStatusContentNested<A> withNewDeploymentConfigStatusContent() {
    return new LocalSubjectAccessReviewFluentImpl.DeploymentConfigStatusContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.DeploymentConfigStatusContentNested<A> withNewDeploymentConfigStatusContentLike(DeploymentConfigStatus item) {
    return new LocalSubjectAccessReviewFluentImpl.DeploymentConfigStatusContentNestedImpl(item);
  }
  public A withSecretBuildSourceContent(SecretBuildSource secretBuildSourceContent) {
    _visitables.get("content").remove(this.content);
    if (secretBuildSourceContent!=null){ this.content= new SecretBuildSourceBuilder(secretBuildSourceContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.SecretBuildSourceContentNested<A> withNewSecretBuildSourceContent() {
    return new LocalSubjectAccessReviewFluentImpl.SecretBuildSourceContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.SecretBuildSourceContentNested<A> withNewSecretBuildSourceContentLike(SecretBuildSource item) {
    return new LocalSubjectAccessReviewFluentImpl.SecretBuildSourceContentNestedImpl(item);
  }
  public A withEgressNetworkPolicySpecContent(EgressNetworkPolicySpec egressNetworkPolicySpecContent) {
    _visitables.get("content").remove(this.content);
    if (egressNetworkPolicySpecContent!=null){ this.content= new EgressNetworkPolicySpecBuilder(egressNetworkPolicySpecContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.EgressNetworkPolicySpecContentNested<A> withNewEgressNetworkPolicySpecContent() {
    return new LocalSubjectAccessReviewFluentImpl.EgressNetworkPolicySpecContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.EgressNetworkPolicySpecContentNested<A> withNewEgressNetworkPolicySpecContentLike(EgressNetworkPolicySpec item) {
    return new LocalSubjectAccessReviewFluentImpl.EgressNetworkPolicySpecContentNestedImpl(item);
  }
  public A withHelmChartRepositoryContent(HelmChartRepository helmChartRepositoryContent) {
    _visitables.get("content").remove(this.content);
    if (helmChartRepositoryContent!=null){ this.content= new HelmChartRepositoryBuilder(helmChartRepositoryContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.HelmChartRepositoryContentNested<A> withNewHelmChartRepositoryContent() {
    return new LocalSubjectAccessReviewFluentImpl.HelmChartRepositoryContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.HelmChartRepositoryContentNested<A> withNewHelmChartRepositoryContentLike(HelmChartRepository item) {
    return new LocalSubjectAccessReviewFluentImpl.HelmChartRepositoryContentNestedImpl(item);
  }
  public A withTagEventContent(TagEvent tagEventContent) {
    _visitables.get("content").remove(this.content);
    if (tagEventContent!=null){ this.content= new TagEventBuilder(tagEventContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.TagEventContentNested<A> withNewTagEventContent() {
    return new LocalSubjectAccessReviewFluentImpl.TagEventContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.TagEventContentNested<A> withNewTagEventContentLike(TagEvent item) {
    return new LocalSubjectAccessReviewFluentImpl.TagEventContentNestedImpl(item);
  }
  public A withNewTagEventContent(String created,String dockerImageReference,Long generation,String image) {
    return (A)withTagEventContent(new TagEvent(created, dockerImageReference, generation, image));
  }
  public A withImageStreamTagListContent(ImageStreamTagList imageStreamTagListContent) {
    _visitables.get("content").remove(this.content);
    if (imageStreamTagListContent!=null){ this.content= new ImageStreamTagListBuilder(imageStreamTagListContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.ImageStreamTagListContentNested<A> withNewImageStreamTagListContent() {
    return new LocalSubjectAccessReviewFluentImpl.ImageStreamTagListContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.ImageStreamTagListContentNested<A> withNewImageStreamTagListContentLike(ImageStreamTagList item) {
    return new LocalSubjectAccessReviewFluentImpl.ImageStreamTagListContentNestedImpl(item);
  }
  public A withBitbucketWebHookCauseContent(BitbucketWebHookCause bitbucketWebHookCauseContent) {
    _visitables.get("content").remove(this.content);
    if (bitbucketWebHookCauseContent!=null){ this.content= new BitbucketWebHookCauseBuilder(bitbucketWebHookCauseContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.BitbucketWebHookCauseContentNested<A> withNewBitbucketWebHookCauseContent() {
    return new LocalSubjectAccessReviewFluentImpl.BitbucketWebHookCauseContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.BitbucketWebHookCauseContentNested<A> withNewBitbucketWebHookCauseContentLike(BitbucketWebHookCause item) {
    return new LocalSubjectAccessReviewFluentImpl.BitbucketWebHookCauseContentNestedImpl(item);
  }
  public A withProjectListContent(ProjectList projectListContent) {
    _visitables.get("content").remove(this.content);
    if (projectListContent!=null){ this.content= new ProjectListBuilder(projectListContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.ProjectListContentNested<A> withNewProjectListContent() {
    return new LocalSubjectAccessReviewFluentImpl.ProjectListContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.ProjectListContentNested<A> withNewProjectListContentLike(ProjectList item) {
    return new LocalSubjectAccessReviewFluentImpl.ProjectListContentNestedImpl(item);
  }
  public A withRangeAllocationContent(RangeAllocation rangeAllocationContent) {
    _visitables.get("content").remove(this.content);
    if (rangeAllocationContent!=null){ this.content= new RangeAllocationBuilder(rangeAllocationContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.RangeAllocationContentNested<A> withNewRangeAllocationContent() {
    return new LocalSubjectAccessReviewFluentImpl.RangeAllocationContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.RangeAllocationContentNested<A> withNewRangeAllocationContentLike(RangeAllocation item) {
    return new LocalSubjectAccessReviewFluentImpl.RangeAllocationContentNestedImpl(item);
  }
  public A withClusterRoleScopeRestrictionContent(ClusterRoleScopeRestriction clusterRoleScopeRestrictionContent) {
    _visitables.get("content").remove(this.content);
    if (clusterRoleScopeRestrictionContent!=null){ this.content= new ClusterRoleScopeRestrictionBuilder(clusterRoleScopeRestrictionContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.ClusterRoleScopeRestrictionContentNested<A> withNewClusterRoleScopeRestrictionContent() {
    return new LocalSubjectAccessReviewFluentImpl.ClusterRoleScopeRestrictionContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.ClusterRoleScopeRestrictionContentNested<A> withNewClusterRoleScopeRestrictionContentLike(ClusterRoleScopeRestriction item) {
    return new LocalSubjectAccessReviewFluentImpl.ClusterRoleScopeRestrictionContentNestedImpl(item);
  }
  public A withRouteContent(Route routeContent) {
    _visitables.get("content").remove(this.content);
    if (routeContent!=null){ this.content= new RouteBuilder(routeContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.RouteContentNested<A> withNewRouteContent() {
    return new LocalSubjectAccessReviewFluentImpl.RouteContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.RouteContentNested<A> withNewRouteContentLike(Route item) {
    return new LocalSubjectAccessReviewFluentImpl.RouteContentNestedImpl(item);
  }
  public A withSourceStrategyOptionsContent(SourceStrategyOptions sourceStrategyOptionsContent) {
    _visitables.get("content").remove(this.content);
    if (sourceStrategyOptionsContent!=null){ this.content= new SourceStrategyOptionsBuilder(sourceStrategyOptionsContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.SourceStrategyOptionsContentNested<A> withNewSourceStrategyOptionsContent() {
    return new LocalSubjectAccessReviewFluentImpl.SourceStrategyOptionsContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.SourceStrategyOptionsContentNested<A> withNewSourceStrategyOptionsContentLike(SourceStrategyOptions item) {
    return new LocalSubjectAccessReviewFluentImpl.SourceStrategyOptionsContentNestedImpl(item);
  }
  public A withNewSourceStrategyOptionsContent(Boolean incremental) {
    return (A)withSourceStrategyOptionsContent(new SourceStrategyOptions(incremental));
  }
  public A withClusterNetworkContent(ClusterNetwork clusterNetworkContent) {
    _visitables.get("content").remove(this.content);
    if (clusterNetworkContent!=null){ this.content= new ClusterNetworkBuilder(clusterNetworkContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.ClusterNetworkContentNested<A> withNewClusterNetworkContent() {
    return new LocalSubjectAccessReviewFluentImpl.ClusterNetworkContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.ClusterNetworkContentNested<A> withNewClusterNetworkContentLike(ClusterNetwork item) {
    return new LocalSubjectAccessReviewFluentImpl.ClusterNetworkContentNestedImpl(item);
  }
  public A withOAuthAuthorizeTokenContent(OAuthAuthorizeToken oAuthAuthorizeTokenContent) {
    _visitables.get("content").remove(this.content);
    if (oAuthAuthorizeTokenContent!=null){ this.content= new OAuthAuthorizeTokenBuilder(oAuthAuthorizeTokenContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.OAuthAuthorizeTokenContentNested<A> withNewOAuthAuthorizeTokenContent() {
    return new LocalSubjectAccessReviewFluentImpl.OAuthAuthorizeTokenContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.OAuthAuthorizeTokenContentNested<A> withNewOAuthAuthorizeTokenContentLike(OAuthAuthorizeToken item) {
    return new LocalSubjectAccessReviewFluentImpl.OAuthAuthorizeTokenContentNestedImpl(item);
  }
  public A withDockerBuildStrategyContent(DockerBuildStrategy dockerBuildStrategyContent) {
    _visitables.get("content").remove(this.content);
    if (dockerBuildStrategyContent!=null){ this.content= new DockerBuildStrategyBuilder(dockerBuildStrategyContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.DockerBuildStrategyContentNested<A> withNewDockerBuildStrategyContent() {
    return new LocalSubjectAccessReviewFluentImpl.DockerBuildStrategyContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.DockerBuildStrategyContentNested<A> withNewDockerBuildStrategyContentLike(DockerBuildStrategy item) {
    return new LocalSubjectAccessReviewFluentImpl.DockerBuildStrategyContentNestedImpl(item);
  }
  public A withSignatureConditionContent(SignatureCondition signatureConditionContent) {
    _visitables.get("content").remove(this.content);
    if (signatureConditionContent!=null){ this.content= new SignatureConditionBuilder(signatureConditionContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.SignatureConditionContentNested<A> withNewSignatureConditionContent() {
    return new LocalSubjectAccessReviewFluentImpl.SignatureConditionContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.SignatureConditionContentNested<A> withNewSignatureConditionContentLike(SignatureCondition item) {
    return new LocalSubjectAccessReviewFluentImpl.SignatureConditionContentNestedImpl(item);
  }
  public A withUserOAuthAccessTokenContent(UserOAuthAccessToken userOAuthAccessTokenContent) {
    _visitables.get("content").remove(this.content);
    if (userOAuthAccessTokenContent!=null){ this.content= new UserOAuthAccessTokenBuilder(userOAuthAccessTokenContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.UserOAuthAccessTokenContentNested<A> withNewUserOAuthAccessTokenContent() {
    return new LocalSubjectAccessReviewFluentImpl.UserOAuthAccessTokenContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.UserOAuthAccessTokenContentNested<A> withNewUserOAuthAccessTokenContentLike(UserOAuthAccessToken item) {
    return new LocalSubjectAccessReviewFluentImpl.UserOAuthAccessTokenContentNestedImpl(item);
  }
  public A withRoleBindingRestrictionListContent(RoleBindingRestrictionList roleBindingRestrictionListContent) {
    _visitables.get("content").remove(this.content);
    if (roleBindingRestrictionListContent!=null){ this.content= new RoleBindingRestrictionListBuilder(roleBindingRestrictionListContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.RoleBindingRestrictionListContentNested<A> withNewRoleBindingRestrictionListContent() {
    return new LocalSubjectAccessReviewFluentImpl.RoleBindingRestrictionListContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.RoleBindingRestrictionListContentNested<A> withNewRoleBindingRestrictionListContentLike(RoleBindingRestrictionList item) {
    return new LocalSubjectAccessReviewFluentImpl.RoleBindingRestrictionListContentNestedImpl(item);
  }
  public A withSecurityContextConstraintsListContent(SecurityContextConstraintsList securityContextConstraintsListContent) {
    _visitables.get("content").remove(this.content);
    if (securityContextConstraintsListContent!=null){ this.content= new SecurityContextConstraintsListBuilder(securityContextConstraintsListContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.SecurityContextConstraintsListContentNested<A> withNewSecurityContextConstraintsListContent() {
    return new LocalSubjectAccessReviewFluentImpl.SecurityContextConstraintsListContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.SecurityContextConstraintsListContentNested<A> withNewSecurityContextConstraintsListContentLike(SecurityContextConstraintsList item) {
    return new LocalSubjectAccessReviewFluentImpl.SecurityContextConstraintsListContentNestedImpl(item);
  }
  public A withIdentityListContent(IdentityList identityListContent) {
    _visitables.get("content").remove(this.content);
    if (identityListContent!=null){ this.content= new IdentityListBuilder(identityListContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.IdentityListContentNested<A> withNewIdentityListContent() {
    return new LocalSubjectAccessReviewFluentImpl.IdentityListContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.IdentityListContentNested<A> withNewIdentityListContentLike(IdentityList item) {
    return new LocalSubjectAccessReviewFluentImpl.IdentityListContentNestedImpl(item);
  }
  public A withBuildConfigListContent(BuildConfigList buildConfigListContent) {
    _visitables.get("content").remove(this.content);
    if (buildConfigListContent!=null){ this.content= new BuildConfigListBuilder(buildConfigListContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.BuildConfigListContentNested<A> withNewBuildConfigListContent() {
    return new LocalSubjectAccessReviewFluentImpl.BuildConfigListContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.BuildConfigListContentNested<A> withNewBuildConfigListContentLike(BuildConfigList item) {
    return new LocalSubjectAccessReviewFluentImpl.BuildConfigListContentNestedImpl(item);
  }
  public A withClusterNetworkListContent(ClusterNetworkList clusterNetworkListContent) {
    _visitables.get("content").remove(this.content);
    if (clusterNetworkListContent!=null){ this.content= new ClusterNetworkListBuilder(clusterNetworkListContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.ClusterNetworkListContentNested<A> withNewClusterNetworkListContent() {
    return new LocalSubjectAccessReviewFluentImpl.ClusterNetworkListContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.ClusterNetworkListContentNested<A> withNewClusterNetworkListContentLike(ClusterNetworkList item) {
    return new LocalSubjectAccessReviewFluentImpl.ClusterNetworkListContentNestedImpl(item);
  }
  public A withTemplateInstanceConditionContent(TemplateInstanceCondition templateInstanceConditionContent) {
    _visitables.get("content").remove(this.content);
    if (templateInstanceConditionContent!=null){ this.content= new TemplateInstanceConditionBuilder(templateInstanceConditionContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.TemplateInstanceConditionContentNested<A> withNewTemplateInstanceConditionContent() {
    return new LocalSubjectAccessReviewFluentImpl.TemplateInstanceConditionContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.TemplateInstanceConditionContentNested<A> withNewTemplateInstanceConditionContentLike(TemplateInstanceCondition item) {
    return new LocalSubjectAccessReviewFluentImpl.TemplateInstanceConditionContentNestedImpl(item);
  }
  public A withNewTemplateInstanceConditionContent(String lastTransitionTime,String message,String reason,String status,String type) {
    return (A)withTemplateInstanceConditionContent(new TemplateInstanceCondition(lastTransitionTime, message, reason, status, type));
  }
  public A withRepositoryImportStatusContent(RepositoryImportStatus repositoryImportStatusContent) {
    _visitables.get("content").remove(this.content);
    if (repositoryImportStatusContent!=null){ this.content= new RepositoryImportStatusBuilder(repositoryImportStatusContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.RepositoryImportStatusContentNested<A> withNewRepositoryImportStatusContent() {
    return new LocalSubjectAccessReviewFluentImpl.RepositoryImportStatusContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.RepositoryImportStatusContentNested<A> withNewRepositoryImportStatusContentLike(RepositoryImportStatus item) {
    return new LocalSubjectAccessReviewFluentImpl.RepositoryImportStatusContentNestedImpl(item);
  }
  public A withDeploymentCauseContent(DeploymentCause deploymentCauseContent) {
    _visitables.get("content").remove(this.content);
    if (deploymentCauseContent!=null){ this.content= new DeploymentCauseBuilder(deploymentCauseContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.DeploymentCauseContentNested<A> withNewDeploymentCauseContent() {
    return new LocalSubjectAccessReviewFluentImpl.DeploymentCauseContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.DeploymentCauseContentNested<A> withNewDeploymentCauseContentLike(DeploymentCause item) {
    return new LocalSubjectAccessReviewFluentImpl.DeploymentCauseContentNestedImpl(item);
  }
  public A withGroupListContent(GroupList groupListContent) {
    _visitables.get("content").remove(this.content);
    if (groupListContent!=null){ this.content= new GroupListBuilder(groupListContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.GroupListContentNested<A> withNewGroupListContent() {
    return new LocalSubjectAccessReviewFluentImpl.GroupListContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.GroupListContentNested<A> withNewGroupListContentLike(GroupList item) {
    return new LocalSubjectAccessReviewFluentImpl.GroupListContentNestedImpl(item);
  }
  public A withRunAsUserStrategyOptionsContent(RunAsUserStrategyOptions runAsUserStrategyOptionsContent) {
    _visitables.get("content").remove(this.content);
    if (runAsUserStrategyOptionsContent!=null){ this.content= new RunAsUserStrategyOptionsBuilder(runAsUserStrategyOptionsContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.RunAsUserStrategyOptionsContentNested<A> withNewRunAsUserStrategyOptionsContent() {
    return new LocalSubjectAccessReviewFluentImpl.RunAsUserStrategyOptionsContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.RunAsUserStrategyOptionsContentNested<A> withNewRunAsUserStrategyOptionsContentLike(RunAsUserStrategyOptions item) {
    return new LocalSubjectAccessReviewFluentImpl.RunAsUserStrategyOptionsContentNestedImpl(item);
  }
  public A withNewRunAsUserStrategyOptionsContent(String type,Long uid,Long uidRangeMax,Long uidRangeMin) {
    return (A)withRunAsUserStrategyOptionsContent(new RunAsUserStrategyOptions(type, uid, uidRangeMax, uidRangeMin));
  }
  public A withLifecycleHookContent(LifecycleHook lifecycleHookContent) {
    _visitables.get("content").remove(this.content);
    if (lifecycleHookContent!=null){ this.content= new LifecycleHookBuilder(lifecycleHookContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.LifecycleHookContentNested<A> withNewLifecycleHookContent() {
    return new LocalSubjectAccessReviewFluentImpl.LifecycleHookContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.LifecycleHookContentNested<A> withNewLifecycleHookContentLike(LifecycleHook item) {
    return new LocalSubjectAccessReviewFluentImpl.LifecycleHookContentNestedImpl(item);
  }
  public A withImageStreamTagReferenceContent(ImageStreamTagReference imageStreamTagReferenceContent) {
    _visitables.get("content").remove(this.content);
    if (imageStreamTagReferenceContent!=null){ this.content= new ImageStreamTagReferenceBuilder(imageStreamTagReferenceContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.ImageStreamTagReferenceContentNested<A> withNewImageStreamTagReferenceContent() {
    return new LocalSubjectAccessReviewFluentImpl.ImageStreamTagReferenceContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.ImageStreamTagReferenceContentNested<A> withNewImageStreamTagReferenceContentLike(ImageStreamTagReference item) {
    return new LocalSubjectAccessReviewFluentImpl.ImageStreamTagReferenceContentNestedImpl(item);
  }
  public A withNewImageStreamTagReferenceContent(String name,String namespace) {
    return (A)withImageStreamTagReferenceContent(new ImageStreamTagReference(name, namespace));
  }
  public A withSourceControlUserContent(SourceControlUser sourceControlUserContent) {
    _visitables.get("content").remove(this.content);
    if (sourceControlUserContent!=null){ this.content= new SourceControlUserBuilder(sourceControlUserContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.SourceControlUserContentNested<A> withNewSourceControlUserContent() {
    return new LocalSubjectAccessReviewFluentImpl.SourceControlUserContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.SourceControlUserContentNested<A> withNewSourceControlUserContentLike(SourceControlUser item) {
    return new LocalSubjectAccessReviewFluentImpl.SourceControlUserContentNestedImpl(item);
  }
  public A withNewSourceControlUserContent(String email,String name) {
    return (A)withSourceControlUserContent(new SourceControlUser(email, name));
  }
  public A withContainerContent(Container containerContent) {
    _visitables.get("content").remove(this.content);
    if (containerContent!=null){ this.content= new ContainerBuilder(containerContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.ContainerContentNested<A> withNewContainerContent() {
    return new LocalSubjectAccessReviewFluentImpl.ContainerContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.ContainerContentNested<A> withNewContainerContentLike(Container item) {
    return new LocalSubjectAccessReviewFluentImpl.ContainerContentNestedImpl(item);
  }
  public A withImageStreamListContent(ImageStreamList imageStreamListContent) {
    _visitables.get("content").remove(this.content);
    if (imageStreamListContent!=null){ this.content= new ImageStreamListBuilder(imageStreamListContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.ImageStreamListContentNested<A> withNewImageStreamListContent() {
    return new LocalSubjectAccessReviewFluentImpl.ImageStreamListContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.ImageStreamListContentNested<A> withNewImageStreamListContentLike(ImageStreamList item) {
    return new LocalSubjectAccessReviewFluentImpl.ImageStreamListContentNestedImpl(item);
  }
  public A withClusterRoleBindingContent(ClusterRoleBinding clusterRoleBindingContent) {
    _visitables.get("content").remove(this.content);
    if (clusterRoleBindingContent!=null){ this.content= new ClusterRoleBindingBuilder(clusterRoleBindingContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.ClusterRoleBindingContentNested<A> withNewClusterRoleBindingContent() {
    return new LocalSubjectAccessReviewFluentImpl.ClusterRoleBindingContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.ClusterRoleBindingContentNested<A> withNewClusterRoleBindingContentLike(ClusterRoleBinding item) {
    return new LocalSubjectAccessReviewFluentImpl.ClusterRoleBindingContentNestedImpl(item);
  }
  public A withResourceAccessReviewContent(ResourceAccessReview resourceAccessReviewContent) {
    _visitables.get("content").remove(this.content);
    if (resourceAccessReviewContent!=null){ this.content= new ResourceAccessReviewBuilder(resourceAccessReviewContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.ResourceAccessReviewContentNested<A> withNewResourceAccessReviewContent() {
    return new LocalSubjectAccessReviewFluentImpl.ResourceAccessReviewContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.ResourceAccessReviewContentNested<A> withNewResourceAccessReviewContentLike(ResourceAccessReview item) {
    return new LocalSubjectAccessReviewFluentImpl.ResourceAccessReviewContentNestedImpl(item);
  }
  public A withSelfSubjectRulesReviewContent(SelfSubjectRulesReview selfSubjectRulesReviewContent) {
    _visitables.get("content").remove(this.content);
    if (selfSubjectRulesReviewContent!=null){ this.content= new SelfSubjectRulesReviewBuilder(selfSubjectRulesReviewContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.SelfSubjectRulesReviewContentNested<A> withNewSelfSubjectRulesReviewContent() {
    return new LocalSubjectAccessReviewFluentImpl.SelfSubjectRulesReviewContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.SelfSubjectRulesReviewContentNested<A> withNewSelfSubjectRulesReviewContentLike(SelfSubjectRulesReview item) {
    return new LocalSubjectAccessReviewFluentImpl.SelfSubjectRulesReviewContentNestedImpl(item);
  }
  public A withUserOAuthAccessTokenListContent(UserOAuthAccessTokenList userOAuthAccessTokenListContent) {
    _visitables.get("content").remove(this.content);
    if (userOAuthAccessTokenListContent!=null){ this.content= new UserOAuthAccessTokenListBuilder(userOAuthAccessTokenListContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.UserOAuthAccessTokenListContentNested<A> withNewUserOAuthAccessTokenListContent() {
    return new LocalSubjectAccessReviewFluentImpl.UserOAuthAccessTokenListContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.UserOAuthAccessTokenListContentNested<A> withNewUserOAuthAccessTokenListContentLike(UserOAuthAccessTokenList item) {
    return new LocalSubjectAccessReviewFluentImpl.UserOAuthAccessTokenListContentNestedImpl(item);
  }
  public A withImageChangeTriggerStatusContent(ImageChangeTriggerStatus imageChangeTriggerStatusContent) {
    _visitables.get("content").remove(this.content);
    if (imageChangeTriggerStatusContent!=null){ this.content= new ImageChangeTriggerStatusBuilder(imageChangeTriggerStatusContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.ImageChangeTriggerStatusContentNested<A> withNewImageChangeTriggerStatusContent() {
    return new LocalSubjectAccessReviewFluentImpl.ImageChangeTriggerStatusContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.ImageChangeTriggerStatusContentNested<A> withNewImageChangeTriggerStatusContentLike(ImageChangeTriggerStatus item) {
    return new LocalSubjectAccessReviewFluentImpl.ImageChangeTriggerStatusContentNestedImpl(item);
  }
  public A withRouteStatusContent(RouteStatus routeStatusContent) {
    _visitables.get("content").remove(this.content);
    if (routeStatusContent!=null){ this.content= new RouteStatusBuilder(routeStatusContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.RouteStatusContentNested<A> withNewRouteStatusContent() {
    return new LocalSubjectAccessReviewFluentImpl.RouteStatusContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.RouteStatusContentNested<A> withNewRouteStatusContentLike(RouteStatus item) {
    return new LocalSubjectAccessReviewFluentImpl.RouteStatusContentNestedImpl(item);
  }
  public A withClusterResourceQuotaContent(ClusterResourceQuota clusterResourceQuotaContent) {
    _visitables.get("content").remove(this.content);
    if (clusterResourceQuotaContent!=null){ this.content= new ClusterResourceQuotaBuilder(clusterResourceQuotaContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.ClusterResourceQuotaContentNested<A> withNewClusterResourceQuotaContent() {
    return new LocalSubjectAccessReviewFluentImpl.ClusterResourceQuotaContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.ClusterResourceQuotaContentNested<A> withNewClusterResourceQuotaContentLike(ClusterResourceQuota item) {
    return new LocalSubjectAccessReviewFluentImpl.ClusterResourceQuotaContentNestedImpl(item);
  }
  public A withNamedTagEventListContent(NamedTagEventList namedTagEventListContent) {
    _visitables.get("content").remove(this.content);
    if (namedTagEventListContent!=null){ this.content= new NamedTagEventListBuilder(namedTagEventListContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.NamedTagEventListContentNested<A> withNewNamedTagEventListContent() {
    return new LocalSubjectAccessReviewFluentImpl.NamedTagEventListContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.NamedTagEventListContentNested<A> withNewNamedTagEventListContentLike(NamedTagEventList item) {
    return new LocalSubjectAccessReviewFluentImpl.NamedTagEventListContentNestedImpl(item);
  }
  public A withClusterResourceQuotaListContent(ClusterResourceQuotaList clusterResourceQuotaListContent) {
    _visitables.get("content").remove(this.content);
    if (clusterResourceQuotaListContent!=null){ this.content= new ClusterResourceQuotaListBuilder(clusterResourceQuotaListContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.ClusterResourceQuotaListContentNested<A> withNewClusterResourceQuotaListContent() {
    return new LocalSubjectAccessReviewFluentImpl.ClusterResourceQuotaListContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.ClusterResourceQuotaListContentNested<A> withNewClusterResourceQuotaListContentLike(ClusterResourceQuotaList item) {
    return new LocalSubjectAccessReviewFluentImpl.ClusterResourceQuotaListContentNestedImpl(item);
  }
  public A withRouteSpecContent(RouteSpec routeSpecContent) {
    _visitables.get("content").remove(this.content);
    if (routeSpecContent!=null){ this.content= new RouteSpecBuilder(routeSpecContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.RouteSpecContentNested<A> withNewRouteSpecContent() {
    return new LocalSubjectAccessReviewFluentImpl.RouteSpecContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.RouteSpecContentNested<A> withNewRouteSpecContentLike(RouteSpec item) {
    return new LocalSubjectAccessReviewFluentImpl.RouteSpecContentNestedImpl(item);
  }
  public A withProjectRequestContent(ProjectRequest projectRequestContent) {
    _visitables.get("content").remove(this.content);
    if (projectRequestContent!=null){ this.content= new ProjectRequestBuilder(projectRequestContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.ProjectRequestContentNested<A> withNewProjectRequestContent() {
    return new LocalSubjectAccessReviewFluentImpl.ProjectRequestContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.ProjectRequestContentNested<A> withNewProjectRequestContentLike(ProjectRequest item) {
    return new LocalSubjectAccessReviewFluentImpl.ProjectRequestContentNestedImpl(item);
  }
  public A withTemplateContent(Template templateContent) {
    _visitables.get("content").remove(this.content);
    if (templateContent!=null){ this.content= new TemplateBuilder(templateContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.TemplateContentNested<A> withNewTemplateContent() {
    return new LocalSubjectAccessReviewFluentImpl.TemplateContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.TemplateContentNested<A> withNewTemplateContentLike(Template item) {
    return new LocalSubjectAccessReviewFluentImpl.TemplateContentNestedImpl(item);
  }
  public A withImageLookupPolicyContent(ImageLookupPolicy imageLookupPolicyContent) {
    _visitables.get("content").remove(this.content);
    if (imageLookupPolicyContent!=null){ this.content= new ImageLookupPolicyBuilder(imageLookupPolicyContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.ImageLookupPolicyContentNested<A> withNewImageLookupPolicyContent() {
    return new LocalSubjectAccessReviewFluentImpl.ImageLookupPolicyContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.ImageLookupPolicyContentNested<A> withNewImageLookupPolicyContentLike(ImageLookupPolicy item) {
    return new LocalSubjectAccessReviewFluentImpl.ImageLookupPolicyContentNestedImpl(item);
  }
  public A withNewImageLookupPolicyContent(Boolean local) {
    return (A)withImageLookupPolicyContent(new ImageLookupPolicy(local));
  }
  public A withOAuthClientAuthorizationContent(OAuthClientAuthorization oAuthClientAuthorizationContent) {
    _visitables.get("content").remove(this.content);
    if (oAuthClientAuthorizationContent!=null){ this.content= new OAuthClientAuthorizationBuilder(oAuthClientAuthorizationContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.OAuthClientAuthorizationContentNested<A> withNewOAuthClientAuthorizationContent() {
    return new LocalSubjectAccessReviewFluentImpl.OAuthClientAuthorizationContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.OAuthClientAuthorizationContentNested<A> withNewOAuthClientAuthorizationContentLike(OAuthClientAuthorization item) {
    return new LocalSubjectAccessReviewFluentImpl.OAuthClientAuthorizationContentNestedImpl(item);
  }
  public A withImageChangeCauseContent(ImageChangeCause imageChangeCauseContent) {
    _visitables.get("content").remove(this.content);
    if (imageChangeCauseContent!=null){ this.content= new ImageChangeCauseBuilder(imageChangeCauseContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.ImageChangeCauseContentNested<A> withNewImageChangeCauseContent() {
    return new LocalSubjectAccessReviewFluentImpl.ImageChangeCauseContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.ImageChangeCauseContentNested<A> withNewImageChangeCauseContentLike(ImageChangeCause item) {
    return new LocalSubjectAccessReviewFluentImpl.ImageChangeCauseContentNestedImpl(item);
  }
  public A withAllowedFlexVolumeContent(AllowedFlexVolume allowedFlexVolumeContent) {
    _visitables.get("content").remove(this.content);
    if (allowedFlexVolumeContent!=null){ this.content= new AllowedFlexVolumeBuilder(allowedFlexVolumeContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.AllowedFlexVolumeContentNested<A> withNewAllowedFlexVolumeContent() {
    return new LocalSubjectAccessReviewFluentImpl.AllowedFlexVolumeContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.AllowedFlexVolumeContentNested<A> withNewAllowedFlexVolumeContentLike(AllowedFlexVolume item) {
    return new LocalSubjectAccessReviewFluentImpl.AllowedFlexVolumeContentNestedImpl(item);
  }
  public A withNewAllowedFlexVolumeContent(String driver) {
    return (A)withAllowedFlexVolumeContent(new AllowedFlexVolume(driver));
  }
  public A withSubjectAccessReviewContent(SubjectAccessReview subjectAccessReviewContent) {
    _visitables.get("content").remove(this.content);
    if (subjectAccessReviewContent!=null){ this.content= new SubjectAccessReviewBuilder(subjectAccessReviewContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.SubjectAccessReviewContentNested<A> withNewSubjectAccessReviewContent() {
    return new LocalSubjectAccessReviewFluentImpl.SubjectAccessReviewContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.SubjectAccessReviewContentNested<A> withNewSubjectAccessReviewContentLike(SubjectAccessReview item) {
    return new LocalSubjectAccessReviewFluentImpl.SubjectAccessReviewContentNestedImpl(item);
  }
  public A withLocalResourceAccessReviewContent(LocalResourceAccessReview localResourceAccessReviewContent) {
    _visitables.get("content").remove(this.content);
    if (localResourceAccessReviewContent!=null){ this.content= new LocalResourceAccessReviewBuilder(localResourceAccessReviewContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.LocalResourceAccessReviewContentNested<A> withNewLocalResourceAccessReviewContent() {
    return new LocalSubjectAccessReviewFluentImpl.LocalResourceAccessReviewContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.LocalResourceAccessReviewContentNested<A> withNewLocalResourceAccessReviewContentLike(LocalResourceAccessReview item) {
    return new LocalSubjectAccessReviewFluentImpl.LocalResourceAccessReviewContentNestedImpl(item);
  }
  public A withClusterRoleContent(ClusterRole clusterRoleContent) {
    _visitables.get("content").remove(this.content);
    if (clusterRoleContent!=null){ this.content= new ClusterRoleBuilder(clusterRoleContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.ClusterRoleContentNested<A> withNewClusterRoleContent() {
    return new LocalSubjectAccessReviewFluentImpl.ClusterRoleContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.ClusterRoleContentNested<A> withNewClusterRoleContentLike(ClusterRole item) {
    return new LocalSubjectAccessReviewFluentImpl.ClusterRoleContentNestedImpl(item);
  }
  public A withConnectionConfigContent(ConnectionConfig connectionConfigContent) {
    _visitables.get("content").remove(this.content);
    if (connectionConfigContent!=null){ this.content= new ConnectionConfigBuilder(connectionConfigContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.ConnectionConfigContentNested<A> withNewConnectionConfigContent() {
    return new LocalSubjectAccessReviewFluentImpl.ConnectionConfigContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.ConnectionConfigContentNested<A> withNewConnectionConfigContentLike(ConnectionConfig item) {
    return new LocalSubjectAccessReviewFluentImpl.ConnectionConfigContentNestedImpl(item);
  }
  public A withTagEventConditionContent(TagEventCondition tagEventConditionContent) {
    _visitables.get("content").remove(this.content);
    if (tagEventConditionContent!=null){ this.content= new TagEventConditionBuilder(tagEventConditionContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.TagEventConditionContentNested<A> withNewTagEventConditionContent() {
    return new LocalSubjectAccessReviewFluentImpl.TagEventConditionContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.TagEventConditionContentNested<A> withNewTagEventConditionContentLike(TagEventCondition item) {
    return new LocalSubjectAccessReviewFluentImpl.TagEventConditionContentNestedImpl(item);
  }
  public A withLabelSelectorContent(LabelSelector labelSelectorContent) {
    _visitables.get("content").remove(this.content);
    if (labelSelectorContent!=null){ this.content= new LabelSelectorBuilder(labelSelectorContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.LabelSelectorContentNested<A> withNewLabelSelectorContent() {
    return new LocalSubjectAccessReviewFluentImpl.LabelSelectorContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.LabelSelectorContentNested<A> withNewLabelSelectorContentLike(LabelSelector item) {
    return new LocalSubjectAccessReviewFluentImpl.LabelSelectorContentNestedImpl(item);
  }
  public A withNetNamespaceListContent(NetNamespaceList netNamespaceListContent) {
    _visitables.get("content").remove(this.content);
    if (netNamespaceListContent!=null){ this.content= new NetNamespaceListBuilder(netNamespaceListContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.NetNamespaceListContentNested<A> withNewNetNamespaceListContent() {
    return new LocalSubjectAccessReviewFluentImpl.NetNamespaceListContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.NetNamespaceListContentNested<A> withNewNetNamespaceListContentLike(NetNamespaceList item) {
    return new LocalSubjectAccessReviewFluentImpl.NetNamespaceListContentNestedImpl(item);
  }
  public A withBrokerTemplateInstanceSpecContent(BrokerTemplateInstanceSpec brokerTemplateInstanceSpecContent) {
    _visitables.get("content").remove(this.content);
    if (brokerTemplateInstanceSpecContent!=null){ this.content= new BrokerTemplateInstanceSpecBuilder(brokerTemplateInstanceSpecContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.BrokerTemplateInstanceSpecContentNested<A> withNewBrokerTemplateInstanceSpecContent() {
    return new LocalSubjectAccessReviewFluentImpl.BrokerTemplateInstanceSpecContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.BrokerTemplateInstanceSpecContentNested<A> withNewBrokerTemplateInstanceSpecContentLike(BrokerTemplateInstanceSpec item) {
    return new LocalSubjectAccessReviewFluentImpl.BrokerTemplateInstanceSpecContentNestedImpl(item);
  }
  public A withBinaryBuildSourceContent(BinaryBuildSource binaryBuildSourceContent) {
    _visitables.get("content").remove(this.content);
    if (binaryBuildSourceContent!=null){ this.content= new BinaryBuildSourceBuilder(binaryBuildSourceContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.BinaryBuildSourceContentNested<A> withNewBinaryBuildSourceContent() {
    return new LocalSubjectAccessReviewFluentImpl.BinaryBuildSourceContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.BinaryBuildSourceContentNested<A> withNewBinaryBuildSourceContentLike(BinaryBuildSource item) {
    return new LocalSubjectAccessReviewFluentImpl.BinaryBuildSourceContentNestedImpl(item);
  }
  public A withNewBinaryBuildSourceContent(String asFile) {
    return (A)withBinaryBuildSourceContent(new BinaryBuildSource(asFile));
  }
  public A withOAuthClientAuthorizationListContent(OAuthClientAuthorizationList oAuthClientAuthorizationListContent) {
    _visitables.get("content").remove(this.content);
    if (oAuthClientAuthorizationListContent!=null){ this.content= new OAuthClientAuthorizationListBuilder(oAuthClientAuthorizationListContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.OAuthClientAuthorizationListContentNested<A> withNewOAuthClientAuthorizationListContent() {
    return new LocalSubjectAccessReviewFluentImpl.OAuthClientAuthorizationListContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.OAuthClientAuthorizationListContentNested<A> withNewOAuthClientAuthorizationListContentLike(OAuthClientAuthorizationList item) {
    return new LocalSubjectAccessReviewFluentImpl.OAuthClientAuthorizationListContentNestedImpl(item);
  }
  public A withBuildSpecContent(BuildSpec buildSpecContent) {
    _visitables.get("content").remove(this.content);
    if (buildSpecContent!=null){ this.content= new BuildSpecBuilder(buildSpecContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.BuildSpecContentNested<A> withNewBuildSpecContent() {
    return new LocalSubjectAccessReviewFluentImpl.BuildSpecContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.BuildSpecContentNested<A> withNewBuildSpecContentLike(BuildSpec item) {
    return new LocalSubjectAccessReviewFluentImpl.BuildSpecContentNestedImpl(item);
  }
  public A withProjectStatusContent(ProjectStatus projectStatusContent) {
    _visitables.get("content").remove(this.content);
    if (projectStatusContent!=null){ this.content= new ProjectStatusBuilder(projectStatusContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.ProjectStatusContentNested<A> withNewProjectStatusContent() {
    return new LocalSubjectAccessReviewFluentImpl.ProjectStatusContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.ProjectStatusContentNested<A> withNewProjectStatusContentLike(ProjectStatus item) {
    return new LocalSubjectAccessReviewFluentImpl.ProjectStatusContentNestedImpl(item);
  }
  public A withLocalSubjectAccessReviewContent(LocalSubjectAccessReview localSubjectAccessReviewContent) {
    _visitables.get("content").remove(this.content);
    if (localSubjectAccessReviewContent!=null){ this.content= new LocalSubjectAccessReviewBuilder(localSubjectAccessReviewContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.LocalSubjectAccessReviewContentNested<A> withNewLocalSubjectAccessReviewContent() {
    return new LocalSubjectAccessReviewFluentImpl.LocalSubjectAccessReviewContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.LocalSubjectAccessReviewContentNested<A> withNewLocalSubjectAccessReviewContentLike(LocalSubjectAccessReview item) {
    return new LocalSubjectAccessReviewFluentImpl.LocalSubjectAccessReviewContentNestedImpl(item);
  }
  public A withRollingDeploymentStrategyParamsContent(RollingDeploymentStrategyParams rollingDeploymentStrategyParamsContent) {
    _visitables.get("content").remove(this.content);
    if (rollingDeploymentStrategyParamsContent!=null){ this.content= new RollingDeploymentStrategyParamsBuilder(rollingDeploymentStrategyParamsContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.RollingDeploymentStrategyParamsContentNested<A> withNewRollingDeploymentStrategyParamsContent() {
    return new LocalSubjectAccessReviewFluentImpl.RollingDeploymentStrategyParamsContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.RollingDeploymentStrategyParamsContentNested<A> withNewRollingDeploymentStrategyParamsContentLike(RollingDeploymentStrategyParams item) {
    return new LocalSubjectAccessReviewFluentImpl.RollingDeploymentStrategyParamsContentNestedImpl(item);
  }
  public A withGitSourceRevisionContent(GitSourceRevision gitSourceRevisionContent) {
    _visitables.get("content").remove(this.content);
    if (gitSourceRevisionContent!=null){ this.content= new GitSourceRevisionBuilder(gitSourceRevisionContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.GitSourceRevisionContentNested<A> withNewGitSourceRevisionContent() {
    return new LocalSubjectAccessReviewFluentImpl.GitSourceRevisionContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.GitSourceRevisionContentNested<A> withNewGitSourceRevisionContentLike(GitSourceRevision item) {
    return new LocalSubjectAccessReviewFluentImpl.GitSourceRevisionContentNestedImpl(item);
  }
  public A withImageLabelContent(ImageLabel imageLabelContent) {
    _visitables.get("content").remove(this.content);
    if (imageLabelContent!=null){ this.content= new ImageLabelBuilder(imageLabelContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.ImageLabelContentNested<A> withNewImageLabelContent() {
    return new LocalSubjectAccessReviewFluentImpl.ImageLabelContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.ImageLabelContentNested<A> withNewImageLabelContentLike(ImageLabel item) {
    return new LocalSubjectAccessReviewFluentImpl.ImageLabelContentNestedImpl(item);
  }
  public A withNewImageLabelContent(String name,String value) {
    return (A)withImageLabelContent(new ImageLabel(name, value));
  }
  public A withImageChangeTriggerContent(ImageChangeTrigger imageChangeTriggerContent) {
    _visitables.get("content").remove(this.content);
    if (imageChangeTriggerContent!=null){ this.content= new ImageChangeTriggerBuilder(imageChangeTriggerContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.ImageChangeTriggerContentNested<A> withNewImageChangeTriggerContent() {
    return new LocalSubjectAccessReviewFluentImpl.ImageChangeTriggerContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.ImageChangeTriggerContentNested<A> withNewImageChangeTriggerContentLike(ImageChangeTrigger item) {
    return new LocalSubjectAccessReviewFluentImpl.ImageChangeTriggerContentNestedImpl(item);
  }
  public A withPodSecurityPolicyReviewSpecContent(PodSecurityPolicyReviewSpec podSecurityPolicyReviewSpecContent) {
    _visitables.get("content").remove(this.content);
    if (podSecurityPolicyReviewSpecContent!=null){ this.content= new PodSecurityPolicyReviewSpecBuilder(podSecurityPolicyReviewSpecContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.PodSecurityPolicyReviewSpecContentNested<A> withNewPodSecurityPolicyReviewSpecContent() {
    return new LocalSubjectAccessReviewFluentImpl.PodSecurityPolicyReviewSpecContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.PodSecurityPolicyReviewSpecContentNested<A> withNewPodSecurityPolicyReviewSpecContentLike(PodSecurityPolicyReviewSpec item) {
    return new LocalSubjectAccessReviewFluentImpl.PodSecurityPolicyReviewSpecContentNestedImpl(item);
  }
  public A withImageTagContent(ImageTag imageTagContent) {
    _visitables.get("content").remove(this.content);
    if (imageTagContent!=null){ this.content= new ImageTagBuilder(imageTagContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.ImageTagContentNested<A> withNewImageTagContent() {
    return new LocalSubjectAccessReviewFluentImpl.ImageTagContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.ImageTagContentNested<A> withNewImageTagContentLike(ImageTag item) {
    return new LocalSubjectAccessReviewFluentImpl.ImageTagContentNestedImpl(item);
  }
  public A withImageStreamImportSpecContent(ImageStreamImportSpec imageStreamImportSpecContent) {
    _visitables.get("content").remove(this.content);
    if (imageStreamImportSpecContent!=null){ this.content= new ImageStreamImportSpecBuilder(imageStreamImportSpecContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.ImageStreamImportSpecContentNested<A> withNewImageStreamImportSpecContent() {
    return new LocalSubjectAccessReviewFluentImpl.ImageStreamImportSpecContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.ImageStreamImportSpecContentNested<A> withNewImageStreamImportSpecContentLike(ImageStreamImportSpec item) {
    return new LocalSubjectAccessReviewFluentImpl.ImageStreamImportSpecContentNestedImpl(item);
  }
  public A withFSGroupStrategyOptionsContent(FSGroupStrategyOptions fSGroupStrategyOptionsContent) {
    _visitables.get("content").remove(this.content);
    if (fSGroupStrategyOptionsContent!=null){ this.content= new FSGroupStrategyOptionsBuilder(fSGroupStrategyOptionsContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.FSGroupStrategyOptionsContentNested<A> withNewFSGroupStrategyOptionsContent() {
    return new LocalSubjectAccessReviewFluentImpl.FSGroupStrategyOptionsContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.FSGroupStrategyOptionsContentNested<A> withNewFSGroupStrategyOptionsContentLike(FSGroupStrategyOptions item) {
    return new LocalSubjectAccessReviewFluentImpl.FSGroupStrategyOptionsContentNestedImpl(item);
  }
  public A withPodSecurityPolicyReviewContent(PodSecurityPolicyReview podSecurityPolicyReviewContent) {
    _visitables.get("content").remove(this.content);
    if (podSecurityPolicyReviewContent!=null){ this.content= new PodSecurityPolicyReviewBuilder(podSecurityPolicyReviewContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.PodSecurityPolicyReviewContentNested<A> withNewPodSecurityPolicyReviewContent() {
    return new LocalSubjectAccessReviewFluentImpl.PodSecurityPolicyReviewContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.PodSecurityPolicyReviewContentNested<A> withNewPodSecurityPolicyReviewContentLike(PodSecurityPolicyReview item) {
    return new LocalSubjectAccessReviewFluentImpl.PodSecurityPolicyReviewContentNestedImpl(item);
  }
  public A withRecreateDeploymentStrategyParamsContent(RecreateDeploymentStrategyParams recreateDeploymentStrategyParamsContent) {
    _visitables.get("content").remove(this.content);
    if (recreateDeploymentStrategyParamsContent!=null){ this.content= new RecreateDeploymentStrategyParamsBuilder(recreateDeploymentStrategyParamsContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.RecreateDeploymentStrategyParamsContentNested<A> withNewRecreateDeploymentStrategyParamsContent() {
    return new LocalSubjectAccessReviewFluentImpl.RecreateDeploymentStrategyParamsContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.RecreateDeploymentStrategyParamsContentNested<A> withNewRecreateDeploymentStrategyParamsContentLike(RecreateDeploymentStrategyParams item) {
    return new LocalSubjectAccessReviewFluentImpl.RecreateDeploymentStrategyParamsContentNestedImpl(item);
  }
  public A withDockerStrategyOptionsContent(DockerStrategyOptions dockerStrategyOptionsContent) {
    _visitables.get("content").remove(this.content);
    if (dockerStrategyOptionsContent!=null){ this.content= new DockerStrategyOptionsBuilder(dockerStrategyOptionsContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.DockerStrategyOptionsContentNested<A> withNewDockerStrategyOptionsContent() {
    return new LocalSubjectAccessReviewFluentImpl.DockerStrategyOptionsContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.DockerStrategyOptionsContentNested<A> withNewDockerStrategyOptionsContentLike(DockerStrategyOptions item) {
    return new LocalSubjectAccessReviewFluentImpl.DockerStrategyOptionsContentNestedImpl(item);
  }
  public A withImageListContent(ImageList imageListContent) {
    _visitables.get("content").remove(this.content);
    if (imageListContent!=null){ this.content= new ImageListBuilder(imageListContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.ImageListContentNested<A> withNewImageListContent() {
    return new LocalSubjectAccessReviewFluentImpl.ImageListContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.ImageListContentNested<A> withNewImageListContentLike(ImageList item) {
    return new LocalSubjectAccessReviewFluentImpl.ImageListContentNestedImpl(item);
  }
  public A withConfigMapBuildSourceContent(ConfigMapBuildSource configMapBuildSourceContent) {
    _visitables.get("content").remove(this.content);
    if (configMapBuildSourceContent!=null){ this.content= new ConfigMapBuildSourceBuilder(configMapBuildSourceContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.ConfigMapBuildSourceContentNested<A> withNewConfigMapBuildSourceContent() {
    return new LocalSubjectAccessReviewFluentImpl.ConfigMapBuildSourceContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.ConfigMapBuildSourceContentNested<A> withNewConfigMapBuildSourceContentLike(ConfigMapBuildSource item) {
    return new LocalSubjectAccessReviewFluentImpl.ConfigMapBuildSourceContentNestedImpl(item);
  }
  public A withImageTagListContent(ImageTagList imageTagListContent) {
    _visitables.get("content").remove(this.content);
    if (imageTagListContent!=null){ this.content= new ImageTagListBuilder(imageTagListContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.ImageTagListContentNested<A> withNewImageTagListContent() {
    return new LocalSubjectAccessReviewFluentImpl.ImageTagListContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.ImageTagListContentNested<A> withNewImageTagListContentLike(ImageTagList item) {
    return new LocalSubjectAccessReviewFluentImpl.ImageTagListContentNestedImpl(item);
  }
  public A withOAuthAccessTokenContent(OAuthAccessToken oAuthAccessTokenContent) {
    _visitables.get("content").remove(this.content);
    if (oAuthAccessTokenContent!=null){ this.content= new OAuthAccessTokenBuilder(oAuthAccessTokenContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.OAuthAccessTokenContentNested<A> withNewOAuthAccessTokenContent() {
    return new LocalSubjectAccessReviewFluentImpl.OAuthAccessTokenContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.OAuthAccessTokenContentNested<A> withNewOAuthAccessTokenContentLike(OAuthAccessToken item) {
    return new LocalSubjectAccessReviewFluentImpl.OAuthAccessTokenContentNestedImpl(item);
  }
  public A withDeploymentConfigContent(DeploymentConfig deploymentConfigContent) {
    _visitables.get("content").remove(this.content);
    if (deploymentConfigContent!=null){ this.content= new DeploymentConfigBuilder(deploymentConfigContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.DeploymentConfigContentNested<A> withNewDeploymentConfigContent() {
    return new LocalSubjectAccessReviewFluentImpl.DeploymentConfigContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.DeploymentConfigContentNested<A> withNewDeploymentConfigContentLike(DeploymentConfig item) {
    return new LocalSubjectAccessReviewFluentImpl.DeploymentConfigContentNestedImpl(item);
  }
  public A withRoleBindingContent(RoleBinding roleBindingContent) {
    _visitables.get("content").remove(this.content);
    if (roleBindingContent!=null){ this.content= new RoleBindingBuilder(roleBindingContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.RoleBindingContentNested<A> withNewRoleBindingContent() {
    return new LocalSubjectAccessReviewFluentImpl.RoleBindingContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.RoleBindingContentNested<A> withNewRoleBindingContentLike(RoleBinding item) {
    return new LocalSubjectAccessReviewFluentImpl.RoleBindingContentNestedImpl(item);
  }
  public A withImageContent(Image imageContent) {
    _visitables.get("content").remove(this.content);
    if (imageContent!=null){ this.content= new ImageBuilder(imageContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.ImageContentNested<A> withNewImageContent() {
    return new LocalSubjectAccessReviewFluentImpl.ImageContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.ImageContentNested<A> withNewImageContentLike(Image item) {
    return new LocalSubjectAccessReviewFluentImpl.ImageContentNestedImpl(item);
  }
  public A withTLSConfigContent(TLSConfig tLSConfigContent) {
    _visitables.get("content").remove(this.content);
    if (tLSConfigContent!=null){ this.content= new TLSConfigBuilder(tLSConfigContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.TLSConfigContentNested<A> withNewTLSConfigContent() {
    return new LocalSubjectAccessReviewFluentImpl.TLSConfigContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.TLSConfigContentNested<A> withNewTLSConfigContentLike(TLSConfig item) {
    return new LocalSubjectAccessReviewFluentImpl.TLSConfigContentNestedImpl(item);
  }
  public A withBuildVolumeContent(BuildVolume buildVolumeContent) {
    _visitables.get("content").remove(this.content);
    if (buildVolumeContent!=null){ this.content= new BuildVolumeBuilder(buildVolumeContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.BuildVolumeContentNested<A> withNewBuildVolumeContent() {
    return new LocalSubjectAccessReviewFluentImpl.BuildVolumeContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.BuildVolumeContentNested<A> withNewBuildVolumeContentLike(BuildVolume item) {
    return new LocalSubjectAccessReviewFluentImpl.BuildVolumeContentNestedImpl(item);
  }
  public A withTemplateInstanceSpecContent(TemplateInstanceSpec templateInstanceSpecContent) {
    _visitables.get("content").remove(this.content);
    if (templateInstanceSpecContent!=null){ this.content= new TemplateInstanceSpecBuilder(templateInstanceSpecContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.TemplateInstanceSpecContentNested<A> withNewTemplateInstanceSpecContent() {
    return new LocalSubjectAccessReviewFluentImpl.TemplateInstanceSpecContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.TemplateInstanceSpecContentNested<A> withNewTemplateInstanceSpecContentLike(TemplateInstanceSpec item) {
    return new LocalSubjectAccessReviewFluentImpl.TemplateInstanceSpecContentNestedImpl(item);
  }
  public A withBuildStatusContent(BuildStatus buildStatusContent) {
    _visitables.get("content").remove(this.content);
    if (buildStatusContent!=null){ this.content= new BuildStatusBuilder(buildStatusContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.BuildStatusContentNested<A> withNewBuildStatusContent() {
    return new LocalSubjectAccessReviewFluentImpl.BuildStatusContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.BuildStatusContentNested<A> withNewBuildStatusContentLike(BuildStatus item) {
    return new LocalSubjectAccessReviewFluentImpl.BuildStatusContentNestedImpl(item);
  }
  public A withImageSourceContent(ImageSource imageSourceContent) {
    _visitables.get("content").remove(this.content);
    if (imageSourceContent!=null){ this.content= new ImageSourceBuilder(imageSourceContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.ImageSourceContentNested<A> withNewImageSourceContent() {
    return new LocalSubjectAccessReviewFluentImpl.ImageSourceContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.ImageSourceContentNested<A> withNewImageSourceContentLike(ImageSource item) {
    return new LocalSubjectAccessReviewFluentImpl.ImageSourceContentNestedImpl(item);
  }
  public A withObjectMetaContent(ObjectMeta objectMetaContent) {
    _visitables.get("content").remove(this.content);
    if (objectMetaContent!=null){ this.content= new ObjectMetaBuilder(objectMetaContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.ObjectMetaContentNested<A> withNewObjectMetaContent() {
    return new LocalSubjectAccessReviewFluentImpl.ObjectMetaContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.ObjectMetaContentNested<A> withNewObjectMetaContentLike(ObjectMeta item) {
    return new LocalSubjectAccessReviewFluentImpl.ObjectMetaContentNestedImpl(item);
  }
  public A withPersistentVolumeClaimContent(PersistentVolumeClaim persistentVolumeClaimContent) {
    _visitables.get("content").remove(this.content);
    if (persistentVolumeClaimContent!=null){ this.content= new PersistentVolumeClaimBuilder(persistentVolumeClaimContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.PersistentVolumeClaimContentNested<A> withNewPersistentVolumeClaimContent() {
    return new LocalSubjectAccessReviewFluentImpl.PersistentVolumeClaimContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.PersistentVolumeClaimContentNested<A> withNewPersistentVolumeClaimContentLike(PersistentVolumeClaim item) {
    return new LocalSubjectAccessReviewFluentImpl.PersistentVolumeClaimContentNestedImpl(item);
  }
  public A withPodSecurityPolicySelfSubjectReviewContent(PodSecurityPolicySelfSubjectReview podSecurityPolicySelfSubjectReviewContent) {
    _visitables.get("content").remove(this.content);
    if (podSecurityPolicySelfSubjectReviewContent!=null){ this.content= new PodSecurityPolicySelfSubjectReviewBuilder(podSecurityPolicySelfSubjectReviewContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.PodSecurityPolicySelfSubjectReviewContentNested<A> withNewPodSecurityPolicySelfSubjectReviewContent() {
    return new LocalSubjectAccessReviewFluentImpl.PodSecurityPolicySelfSubjectReviewContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.PodSecurityPolicySelfSubjectReviewContentNested<A> withNewPodSecurityPolicySelfSubjectReviewContentLike(PodSecurityPolicySelfSubjectReview item) {
    return new LocalSubjectAccessReviewFluentImpl.PodSecurityPolicySelfSubjectReviewContentNestedImpl(item);
  }
  public A withTagReferenceContent(TagReference tagReferenceContent) {
    _visitables.get("content").remove(this.content);
    if (tagReferenceContent!=null){ this.content= new TagReferenceBuilder(tagReferenceContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.TagReferenceContentNested<A> withNewTagReferenceContent() {
    return new LocalSubjectAccessReviewFluentImpl.TagReferenceContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.TagReferenceContentNested<A> withNewTagReferenceContentLike(TagReference item) {
    return new LocalSubjectAccessReviewFluentImpl.TagReferenceContentNestedImpl(item);
  }
  public A withEgressNetworkPolicyRuleContent(EgressNetworkPolicyRule egressNetworkPolicyRuleContent) {
    _visitables.get("content").remove(this.content);
    if (egressNetworkPolicyRuleContent!=null){ this.content= new EgressNetworkPolicyRuleBuilder(egressNetworkPolicyRuleContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.EgressNetworkPolicyRuleContentNested<A> withNewEgressNetworkPolicyRuleContent() {
    return new LocalSubjectAccessReviewFluentImpl.EgressNetworkPolicyRuleContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.EgressNetworkPolicyRuleContentNested<A> withNewEgressNetworkPolicyRuleContentLike(EgressNetworkPolicyRule item) {
    return new LocalSubjectAccessReviewFluentImpl.EgressNetworkPolicyRuleContentNestedImpl(item);
  }
  public A withSubjectRulesReviewStatusContent(SubjectRulesReviewStatus subjectRulesReviewStatusContent) {
    _visitables.get("content").remove(this.content);
    if (subjectRulesReviewStatusContent!=null){ this.content= new SubjectRulesReviewStatusBuilder(subjectRulesReviewStatusContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.SubjectRulesReviewStatusContentNested<A> withNewSubjectRulesReviewStatusContent() {
    return new LocalSubjectAccessReviewFluentImpl.SubjectRulesReviewStatusContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.SubjectRulesReviewStatusContentNested<A> withNewSubjectRulesReviewStatusContentLike(SubjectRulesReviewStatus item) {
    return new LocalSubjectAccessReviewFluentImpl.SubjectRulesReviewStatusContentNestedImpl(item);
  }
  public A withBuildVolumeMountContent(BuildVolumeMount buildVolumeMountContent) {
    _visitables.get("content").remove(this.content);
    if (buildVolumeMountContent!=null){ this.content= new BuildVolumeMountBuilder(buildVolumeMountContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.BuildVolumeMountContentNested<A> withNewBuildVolumeMountContent() {
    return new LocalSubjectAccessReviewFluentImpl.BuildVolumeMountContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.BuildVolumeMountContentNested<A> withNewBuildVolumeMountContentLike(BuildVolumeMount item) {
    return new LocalSubjectAccessReviewFluentImpl.BuildVolumeMountContentNestedImpl(item);
  }
  public A withNewBuildVolumeMountContent(String destinationPath) {
    return (A)withBuildVolumeMountContent(new BuildVolumeMount(destinationPath));
  }
  public A withClusterNetworkEntryContent(ClusterNetworkEntry clusterNetworkEntryContent) {
    _visitables.get("content").remove(this.content);
    if (clusterNetworkEntryContent!=null){ this.content= new ClusterNetworkEntryBuilder(clusterNetworkEntryContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.ClusterNetworkEntryContentNested<A> withNewClusterNetworkEntryContent() {
    return new LocalSubjectAccessReviewFluentImpl.ClusterNetworkEntryContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.ClusterNetworkEntryContentNested<A> withNewClusterNetworkEntryContentLike(ClusterNetworkEntry item) {
    return new LocalSubjectAccessReviewFluentImpl.ClusterNetworkEntryContentNestedImpl(item);
  }
  public A withNewClusterNetworkEntryContent(String cidr,Integer hostSubnetLength) {
    return (A)withClusterNetworkEntryContent(new ClusterNetworkEntry(cidr, hostSubnetLength));
  }
  public A withTemplateInstanceObjectContent(TemplateInstanceObject templateInstanceObjectContent) {
    _visitables.get("content").remove(this.content);
    if (templateInstanceObjectContent!=null){ this.content= new TemplateInstanceObjectBuilder(templateInstanceObjectContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.TemplateInstanceObjectContentNested<A> withNewTemplateInstanceObjectContent() {
    return new LocalSubjectAccessReviewFluentImpl.TemplateInstanceObjectContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.TemplateInstanceObjectContentNested<A> withNewTemplateInstanceObjectContentLike(TemplateInstanceObject item) {
    return new LocalSubjectAccessReviewFluentImpl.TemplateInstanceObjectContentNestedImpl(item);
  }
  public A withBuildSourceContent(BuildSource buildSourceContent) {
    _visitables.get("content").remove(this.content);
    if (buildSourceContent!=null){ this.content= new BuildSourceBuilder(buildSourceContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.BuildSourceContentNested<A> withNewBuildSourceContent() {
    return new LocalSubjectAccessReviewFluentImpl.BuildSourceContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.BuildSourceContentNested<A> withNewBuildSourceContentLike(BuildSource item) {
    return new LocalSubjectAccessReviewFluentImpl.BuildSourceContentNestedImpl(item);
  }
  public A withClusterResourceQuotaStatusContent(ClusterResourceQuotaStatus clusterResourceQuotaStatusContent) {
    _visitables.get("content").remove(this.content);
    if (clusterResourceQuotaStatusContent!=null){ this.content= new ClusterResourceQuotaStatusBuilder(clusterResourceQuotaStatusContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.ClusterResourceQuotaStatusContentNested<A> withNewClusterResourceQuotaStatusContent() {
    return new LocalSubjectAccessReviewFluentImpl.ClusterResourceQuotaStatusContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.ClusterResourceQuotaStatusContentNested<A> withNewClusterResourceQuotaStatusContentLike(ClusterResourceQuotaStatus item) {
    return new LocalSubjectAccessReviewFluentImpl.ClusterResourceQuotaStatusContentNestedImpl(item);
  }
  public A withDeploymentConditionContent(DeploymentCondition deploymentConditionContent) {
    _visitables.get("content").remove(this.content);
    if (deploymentConditionContent!=null){ this.content= new DeploymentConditionBuilder(deploymentConditionContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.DeploymentConditionContentNested<A> withNewDeploymentConditionContent() {
    return new LocalSubjectAccessReviewFluentImpl.DeploymentConditionContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.DeploymentConditionContentNested<A> withNewDeploymentConditionContentLike(DeploymentCondition item) {
    return new LocalSubjectAccessReviewFluentImpl.DeploymentConditionContentNestedImpl(item);
  }
  public A withHelmChartRepositorySpecContent(HelmChartRepositorySpec helmChartRepositorySpecContent) {
    _visitables.get("content").remove(this.content);
    if (helmChartRepositorySpecContent!=null){ this.content= new HelmChartRepositorySpecBuilder(helmChartRepositorySpecContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.HelmChartRepositorySpecContentNested<A> withNewHelmChartRepositorySpecContent() {
    return new LocalSubjectAccessReviewFluentImpl.HelmChartRepositorySpecContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.HelmChartRepositorySpecContentNested<A> withNewHelmChartRepositorySpecContentLike(HelmChartRepositorySpec item) {
    return new LocalSubjectAccessReviewFluentImpl.HelmChartRepositorySpecContentNestedImpl(item);
  }
  public A withDeploymentCauseImageTriggerContent(DeploymentCauseImageTrigger deploymentCauseImageTriggerContent) {
    _visitables.get("content").remove(this.content);
    if (deploymentCauseImageTriggerContent!=null){ this.content= new DeploymentCauseImageTriggerBuilder(deploymentCauseImageTriggerContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.DeploymentCauseImageTriggerContentNested<A> withNewDeploymentCauseImageTriggerContent() {
    return new LocalSubjectAccessReviewFluentImpl.DeploymentCauseImageTriggerContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.DeploymentCauseImageTriggerContentNested<A> withNewDeploymentCauseImageTriggerContentLike(DeploymentCauseImageTrigger item) {
    return new LocalSubjectAccessReviewFluentImpl.DeploymentCauseImageTriggerContentNestedImpl(item);
  }
  public A withImageStreamMappingContent(ImageStreamMapping imageStreamMappingContent) {
    _visitables.get("content").remove(this.content);
    if (imageStreamMappingContent!=null){ this.content= new ImageStreamMappingBuilder(imageStreamMappingContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.ImageStreamMappingContentNested<A> withNewImageStreamMappingContent() {
    return new LocalSubjectAccessReviewFluentImpl.ImageStreamMappingContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.ImageStreamMappingContentNested<A> withNewImageStreamMappingContentLike(ImageStreamMapping item) {
    return new LocalSubjectAccessReviewFluentImpl.ImageStreamMappingContentNestedImpl(item);
  }
  public A withSubjectRulesReviewContent(SubjectRulesReview subjectRulesReviewContent) {
    _visitables.get("content").remove(this.content);
    if (subjectRulesReviewContent!=null){ this.content= new SubjectRulesReviewBuilder(subjectRulesReviewContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.SubjectRulesReviewContentNested<A> withNewSubjectRulesReviewContent() {
    return new LocalSubjectAccessReviewFluentImpl.SubjectRulesReviewContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.SubjectRulesReviewContentNested<A> withNewSubjectRulesReviewContentLike(SubjectRulesReview item) {
    return new LocalSubjectAccessReviewFluentImpl.SubjectRulesReviewContentNestedImpl(item);
  }
  public A withRoleContent(Role roleContent) {
    _visitables.get("content").remove(this.content);
    if (roleContent!=null){ this.content= new RoleBuilder(roleContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.RoleContentNested<A> withNewRoleContent() {
    return new LocalSubjectAccessReviewFluentImpl.RoleContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.RoleContentNested<A> withNewRoleContentLike(Role item) {
    return new LocalSubjectAccessReviewFluentImpl.RoleContentNestedImpl(item);
  }
  public A withGitBuildSourceContent(GitBuildSource gitBuildSourceContent) {
    _visitables.get("content").remove(this.content);
    if (gitBuildSourceContent!=null){ this.content= new GitBuildSourceBuilder(gitBuildSourceContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.GitBuildSourceContentNested<A> withNewGitBuildSourceContent() {
    return new LocalSubjectAccessReviewFluentImpl.GitBuildSourceContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.GitBuildSourceContentNested<A> withNewGitBuildSourceContentLike(GitBuildSource item) {
    return new LocalSubjectAccessReviewFluentImpl.GitBuildSourceContentNestedImpl(item);
  }
  public A withNewGitBuildSourceContent(String httpProxy,String httpsProxy,String noProxy,String ref,String uri) {
    return (A)withGitBuildSourceContent(new GitBuildSource(httpProxy, httpsProxy, noProxy, ref, uri));
  }
  public A withEgressNetworkPolicyListContent(EgressNetworkPolicyList egressNetworkPolicyListContent) {
    _visitables.get("content").remove(this.content);
    if (egressNetworkPolicyListContent!=null){ this.content= new EgressNetworkPolicyListBuilder(egressNetworkPolicyListContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.EgressNetworkPolicyListContentNested<A> withNewEgressNetworkPolicyListContent() {
    return new LocalSubjectAccessReviewFluentImpl.EgressNetworkPolicyListContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.EgressNetworkPolicyListContentNested<A> withNewEgressNetworkPolicyListContentLike(EgressNetworkPolicyList item) {
    return new LocalSubjectAccessReviewFluentImpl.EgressNetworkPolicyListContentNestedImpl(item);
  }
  public A withSelfSubjectRulesReviewSpecContent(SelfSubjectRulesReviewSpec selfSubjectRulesReviewSpecContent) {
    _visitables.get("content").remove(this.content);
    if (selfSubjectRulesReviewSpecContent!=null){ this.content= new SelfSubjectRulesReviewSpecBuilder(selfSubjectRulesReviewSpecContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.SelfSubjectRulesReviewSpecContentNested<A> withNewSelfSubjectRulesReviewSpecContent() {
    return new LocalSubjectAccessReviewFluentImpl.SelfSubjectRulesReviewSpecContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.SelfSubjectRulesReviewSpecContentNested<A> withNewSelfSubjectRulesReviewSpecContentLike(SelfSubjectRulesReviewSpec item) {
    return new LocalSubjectAccessReviewFluentImpl.SelfSubjectRulesReviewSpecContentNestedImpl(item);
  }
  public A withImageSourcePathContent(ImageSourcePath imageSourcePathContent) {
    _visitables.get("content").remove(this.content);
    if (imageSourcePathContent!=null){ this.content= new ImageSourcePathBuilder(imageSourcePathContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.ImageSourcePathContentNested<A> withNewImageSourcePathContent() {
    return new LocalSubjectAccessReviewFluentImpl.ImageSourcePathContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.ImageSourcePathContentNested<A> withNewImageSourcePathContentLike(ImageSourcePath item) {
    return new LocalSubjectAccessReviewFluentImpl.ImageSourcePathContentNestedImpl(item);
  }
  public A withNewImageSourcePathContent(String destinationDir,String sourcePath) {
    return (A)withImageSourcePathContent(new ImageSourcePath(destinationDir, sourcePath));
  }
  public A withBuildConfigStatusContent(BuildConfigStatus buildConfigStatusContent) {
    _visitables.get("content").remove(this.content);
    if (buildConfigStatusContent!=null){ this.content= new BuildConfigStatusBuilder(buildConfigStatusContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.BuildConfigStatusContentNested<A> withNewBuildConfigStatusContent() {
    return new LocalSubjectAccessReviewFluentImpl.BuildConfigStatusContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.BuildConfigStatusContentNested<A> withNewBuildConfigStatusContentLike(BuildConfigStatus item) {
    return new LocalSubjectAccessReviewFluentImpl.BuildConfigStatusContentNestedImpl(item);
  }
  public A withResourceQuotaStatusByNamespaceContent(ResourceQuotaStatusByNamespace resourceQuotaStatusByNamespaceContent) {
    _visitables.get("content").remove(this.content);
    if (resourceQuotaStatusByNamespaceContent!=null){ this.content= new ResourceQuotaStatusByNamespaceBuilder(resourceQuotaStatusByNamespaceContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.ResourceQuotaStatusByNamespaceContentNested<A> withNewResourceQuotaStatusByNamespaceContent() {
    return new LocalSubjectAccessReviewFluentImpl.ResourceQuotaStatusByNamespaceContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.ResourceQuotaStatusByNamespaceContentNested<A> withNewResourceQuotaStatusByNamespaceContentLike(ResourceQuotaStatusByNamespace item) {
    return new LocalSubjectAccessReviewFluentImpl.ResourceQuotaStatusByNamespaceContentNestedImpl(item);
  }
  public A withSourceBuildStrategyContent(SourceBuildStrategy sourceBuildStrategyContent) {
    _visitables.get("content").remove(this.content);
    if (sourceBuildStrategyContent!=null){ this.content= new SourceBuildStrategyBuilder(sourceBuildStrategyContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.SourceBuildStrategyContentNested<A> withNewSourceBuildStrategyContent() {
    return new LocalSubjectAccessReviewFluentImpl.SourceBuildStrategyContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.SourceBuildStrategyContentNested<A> withNewSourceBuildStrategyContentLike(SourceBuildStrategy item) {
    return new LocalSubjectAccessReviewFluentImpl.SourceBuildStrategyContentNestedImpl(item);
  }
  public A withParameterContent(Parameter parameterContent) {
    _visitables.get("content").remove(this.content);
    if (parameterContent!=null){ this.content= new ParameterBuilder(parameterContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.ParameterContentNested<A> withNewParameterContent() {
    return new LocalSubjectAccessReviewFluentImpl.ParameterContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.ParameterContentNested<A> withNewParameterContentLike(Parameter item) {
    return new LocalSubjectAccessReviewFluentImpl.ParameterContentNestedImpl(item);
  }
  public A withRoleBindingListContent(RoleBindingList roleBindingListContent) {
    _visitables.get("content").remove(this.content);
    if (roleBindingListContent!=null){ this.content= new RoleBindingListBuilder(roleBindingListContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.RoleBindingListContentNested<A> withNewRoleBindingListContent() {
    return new LocalSubjectAccessReviewFluentImpl.RoleBindingListContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.RoleBindingListContentNested<A> withNewRoleBindingListContentLike(RoleBindingList item) {
    return new LocalSubjectAccessReviewFluentImpl.RoleBindingListContentNestedImpl(item);
  }
  public A withPodSecurityPolicySelfSubjectReviewSpecContent(PodSecurityPolicySelfSubjectReviewSpec podSecurityPolicySelfSubjectReviewSpecContent) {
    _visitables.get("content").remove(this.content);
    if (podSecurityPolicySelfSubjectReviewSpecContent!=null){ this.content= new PodSecurityPolicySelfSubjectReviewSpecBuilder(podSecurityPolicySelfSubjectReviewSpecContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.PodSecurityPolicySelfSubjectReviewSpecContentNested<A> withNewPodSecurityPolicySelfSubjectReviewSpecContent() {
    return new LocalSubjectAccessReviewFluentImpl.PodSecurityPolicySelfSubjectReviewSpecContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.PodSecurityPolicySelfSubjectReviewSpecContentNested<A> withNewPodSecurityPolicySelfSubjectReviewSpecContentLike(PodSecurityPolicySelfSubjectReviewSpec item) {
    return new LocalSubjectAccessReviewFluentImpl.PodSecurityPolicySelfSubjectReviewSpecContentNestedImpl(item);
  }
  public A withBrokerTemplateInstanceContent(BrokerTemplateInstance brokerTemplateInstanceContent) {
    _visitables.get("content").remove(this.content);
    if (brokerTemplateInstanceContent!=null){ this.content= new BrokerTemplateInstanceBuilder(brokerTemplateInstanceContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.BrokerTemplateInstanceContentNested<A> withNewBrokerTemplateInstanceContent() {
    return new LocalSubjectAccessReviewFluentImpl.BrokerTemplateInstanceContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.BrokerTemplateInstanceContentNested<A> withNewBrokerTemplateInstanceContentLike(BrokerTemplateInstance item) {
    return new LocalSubjectAccessReviewFluentImpl.BrokerTemplateInstanceContentNestedImpl(item);
  }
  public A withBuildPostCommitSpecContent(BuildPostCommitSpec buildPostCommitSpecContent) {
    _visitables.get("content").remove(this.content);
    if (buildPostCommitSpecContent!=null){ this.content= new BuildPostCommitSpecBuilder(buildPostCommitSpecContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.BuildPostCommitSpecContentNested<A> withNewBuildPostCommitSpecContent() {
    return new LocalSubjectAccessReviewFluentImpl.BuildPostCommitSpecContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.BuildPostCommitSpecContentNested<A> withNewBuildPostCommitSpecContentLike(BuildPostCommitSpec item) {
    return new LocalSubjectAccessReviewFluentImpl.BuildPostCommitSpecContentNestedImpl(item);
  }
  public A withOAuthAuthorizeTokenListContent(OAuthAuthorizeTokenList oAuthAuthorizeTokenListContent) {
    _visitables.get("content").remove(this.content);
    if (oAuthAuthorizeTokenListContent!=null){ this.content= new OAuthAuthorizeTokenListBuilder(oAuthAuthorizeTokenListContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.OAuthAuthorizeTokenListContentNested<A> withNewOAuthAuthorizeTokenListContent() {
    return new LocalSubjectAccessReviewFluentImpl.OAuthAuthorizeTokenListContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.OAuthAuthorizeTokenListContentNested<A> withNewOAuthAuthorizeTokenListContentLike(OAuthAuthorizeTokenList item) {
    return new LocalSubjectAccessReviewFluentImpl.OAuthAuthorizeTokenListContentNestedImpl(item);
  }
  public A withDeploymentStrategyContent(DeploymentStrategy deploymentStrategyContent) {
    _visitables.get("content").remove(this.content);
    if (deploymentStrategyContent!=null){ this.content= new DeploymentStrategyBuilder(deploymentStrategyContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.DeploymentStrategyContentNested<A> withNewDeploymentStrategyContent() {
    return new LocalSubjectAccessReviewFluentImpl.DeploymentStrategyContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.DeploymentStrategyContentNested<A> withNewDeploymentStrategyContentLike(DeploymentStrategy item) {
    return new LocalSubjectAccessReviewFluentImpl.DeploymentStrategyContentNestedImpl(item);
  }
  public A withSignatureSubjectContent(SignatureSubject signatureSubjectContent) {
    _visitables.get("content").remove(this.content);
    if (signatureSubjectContent!=null){ this.content= new SignatureSubjectBuilder(signatureSubjectContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.SignatureSubjectContentNested<A> withNewSignatureSubjectContent() {
    return new LocalSubjectAccessReviewFluentImpl.SignatureSubjectContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.SignatureSubjectContentNested<A> withNewSignatureSubjectContentLike(SignatureSubject item) {
    return new LocalSubjectAccessReviewFluentImpl.SignatureSubjectContentNestedImpl(item);
  }
  public A withNewSignatureSubjectContent(String commonName,String organization,String publicKeyID) {
    return (A)withSignatureSubjectContent(new SignatureSubject(commonName, organization, publicKeyID));
  }
  public A withHostSubnetListContent(HostSubnetList hostSubnetListContent) {
    _visitables.get("content").remove(this.content);
    if (hostSubnetListContent!=null){ this.content= new HostSubnetListBuilder(hostSubnetListContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.HostSubnetListContentNested<A> withNewHostSubnetListContent() {
    return new LocalSubjectAccessReviewFluentImpl.HostSubnetListContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.HostSubnetListContentNested<A> withNewHostSubnetListContentLike(HostSubnetList item) {
    return new LocalSubjectAccessReviewFluentImpl.HostSubnetListContentNestedImpl(item);
  }
  public A withRouteIngressConditionContent(RouteIngressCondition routeIngressConditionContent) {
    _visitables.get("content").remove(this.content);
    if (routeIngressConditionContent!=null){ this.content= new RouteIngressConditionBuilder(routeIngressConditionContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.RouteIngressConditionContentNested<A> withNewRouteIngressConditionContent() {
    return new LocalSubjectAccessReviewFluentImpl.RouteIngressConditionContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.RouteIngressConditionContentNested<A> withNewRouteIngressConditionContentLike(RouteIngressCondition item) {
    return new LocalSubjectAccessReviewFluentImpl.RouteIngressConditionContentNestedImpl(item);
  }
  public A withNewRouteIngressConditionContent(String lastTransitionTime,String message,String reason,String status,String type) {
    return (A)withRouteIngressConditionContent(new RouteIngressCondition(lastTransitionTime, message, reason, status, type));
  }
  public A withCustomDeploymentStrategyParamsContent(CustomDeploymentStrategyParams customDeploymentStrategyParamsContent) {
    _visitables.get("content").remove(this.content);
    if (customDeploymentStrategyParamsContent!=null){ this.content= new CustomDeploymentStrategyParamsBuilder(customDeploymentStrategyParamsContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.CustomDeploymentStrategyParamsContentNested<A> withNewCustomDeploymentStrategyParamsContent() {
    return new LocalSubjectAccessReviewFluentImpl.CustomDeploymentStrategyParamsContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.CustomDeploymentStrategyParamsContentNested<A> withNewCustomDeploymentStrategyParamsContentLike(CustomDeploymentStrategyParams item) {
    return new LocalSubjectAccessReviewFluentImpl.CustomDeploymentStrategyParamsContentNestedImpl(item);
  }
  public A withImageImportSpecContent(ImageImportSpec imageImportSpecContent) {
    _visitables.get("content").remove(this.content);
    if (imageImportSpecContent!=null){ this.content= new ImageImportSpecBuilder(imageImportSpecContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.ImageImportSpecContentNested<A> withNewImageImportSpecContent() {
    return new LocalSubjectAccessReviewFluentImpl.ImageImportSpecContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.ImageImportSpecContentNested<A> withNewImageImportSpecContentLike(ImageImportSpec item) {
    return new LocalSubjectAccessReviewFluentImpl.ImageImportSpecContentNestedImpl(item);
  }
  public A withStageInfoContent(StageInfo stageInfoContent) {
    _visitables.get("content").remove(this.content);
    if (stageInfoContent!=null){ this.content= new StageInfoBuilder(stageInfoContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.StageInfoContentNested<A> withNewStageInfoContent() {
    return new LocalSubjectAccessReviewFluentImpl.StageInfoContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.StageInfoContentNested<A> withNewStageInfoContentLike(StageInfo item) {
    return new LocalSubjectAccessReviewFluentImpl.StageInfoContentNestedImpl(item);
  }
  public A withRoleBindingRestrictionSpecContent(RoleBindingRestrictionSpec roleBindingRestrictionSpecContent) {
    _visitables.get("content").remove(this.content);
    if (roleBindingRestrictionSpecContent!=null){ this.content= new RoleBindingRestrictionSpecBuilder(roleBindingRestrictionSpecContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.RoleBindingRestrictionSpecContentNested<A> withNewRoleBindingRestrictionSpecContent() {
    return new LocalSubjectAccessReviewFluentImpl.RoleBindingRestrictionSpecContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.RoleBindingRestrictionSpecContentNested<A> withNewRoleBindingRestrictionSpecContentLike(RoleBindingRestrictionSpec item) {
    return new LocalSubjectAccessReviewFluentImpl.RoleBindingRestrictionSpecContentNestedImpl(item);
  }
  public A withIDRangeContent(IDRange iDRangeContent) {
    _visitables.get("content").remove(this.content);
    if (iDRangeContent!=null){ this.content= new IDRangeBuilder(iDRangeContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.IDRangeContentNested<A> withNewIDRangeContent() {
    return new LocalSubjectAccessReviewFluentImpl.IDRangeContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.IDRangeContentNested<A> withNewIDRangeContentLike(IDRange item) {
    return new LocalSubjectAccessReviewFluentImpl.IDRangeContentNestedImpl(item);
  }
  public A withNewIDRangeContent(Long max,Long min) {
    return (A)withIDRangeContent(new IDRange(max, min));
  }
  public A withUserListContent(UserList userListContent) {
    _visitables.get("content").remove(this.content);
    if (userListContent!=null){ this.content= new UserListBuilder(userListContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.UserListContentNested<A> withNewUserListContent() {
    return new LocalSubjectAccessReviewFluentImpl.UserListContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.UserListContentNested<A> withNewUserListContentLike(UserList item) {
    return new LocalSubjectAccessReviewFluentImpl.UserListContentNestedImpl(item);
  }
  public A withBuildConfigSpecContent(BuildConfigSpec buildConfigSpecContent) {
    _visitables.get("content").remove(this.content);
    if (buildConfigSpecContent!=null){ this.content= new BuildConfigSpecBuilder(buildConfigSpecContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.BuildConfigSpecContentNested<A> withNewBuildConfigSpecContent() {
    return new LocalSubjectAccessReviewFluentImpl.BuildConfigSpecContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.BuildConfigSpecContentNested<A> withNewBuildConfigSpecContentLike(BuildConfigSpec item) {
    return new LocalSubjectAccessReviewFluentImpl.BuildConfigSpecContentNestedImpl(item);
  }
  public A withUserContent(User userContent) {
    _visitables.get("content").remove(this.content);
    if (userContent!=null){ this.content= new UserBuilder(userContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.UserContentNested<A> withNewUserContent() {
    return new LocalSubjectAccessReviewFluentImpl.UserContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.UserContentNested<A> withNewUserContentLike(User item) {
    return new LocalSubjectAccessReviewFluentImpl.UserContentNestedImpl(item);
  }
  public A withImageStreamImageContent(ImageStreamImage imageStreamImageContent) {
    _visitables.get("content").remove(this.content);
    if (imageStreamImageContent!=null){ this.content= new ImageStreamImageBuilder(imageStreamImageContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.ImageStreamImageContentNested<A> withNewImageStreamImageContent() {
    return new LocalSubjectAccessReviewFluentImpl.ImageStreamImageContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.ImageStreamImageContentNested<A> withNewImageStreamImageContentLike(ImageStreamImage item) {
    return new LocalSubjectAccessReviewFluentImpl.ImageStreamImageContentNestedImpl(item);
  }
  public A withBuildStatusOutputToContent(BuildStatusOutputTo buildStatusOutputToContent) {
    _visitables.get("content").remove(this.content);
    if (buildStatusOutputToContent!=null){ this.content= new BuildStatusOutputToBuilder(buildStatusOutputToContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.BuildStatusOutputToContentNested<A> withNewBuildStatusOutputToContent() {
    return new LocalSubjectAccessReviewFluentImpl.BuildStatusOutputToContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.BuildStatusOutputToContentNested<A> withNewBuildStatusOutputToContentLike(BuildStatusOutputTo item) {
    return new LocalSubjectAccessReviewFluentImpl.BuildStatusOutputToContentNestedImpl(item);
  }
  public A withNewBuildStatusOutputToContent(String imageDigest) {
    return (A)withBuildStatusOutputToContent(new BuildStatusOutputTo(imageDigest));
  }
  public A withBuildConditionContent(BuildCondition buildConditionContent) {
    _visitables.get("content").remove(this.content);
    if (buildConditionContent!=null){ this.content= new BuildConditionBuilder(buildConditionContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.BuildConditionContentNested<A> withNewBuildConditionContent() {
    return new LocalSubjectAccessReviewFluentImpl.BuildConditionContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.BuildConditionContentNested<A> withNewBuildConditionContentLike(BuildCondition item) {
    return new LocalSubjectAccessReviewFluentImpl.BuildConditionContentNestedImpl(item);
  }
  public A withResourceAccessReviewResponseContent(ResourceAccessReviewResponse resourceAccessReviewResponseContent) {
    _visitables.get("content").remove(this.content);
    if (resourceAccessReviewResponseContent!=null){ this.content= new ResourceAccessReviewResponseBuilder(resourceAccessReviewResponseContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.ResourceAccessReviewResponseContentNested<A> withNewResourceAccessReviewResponseContent() {
    return new LocalSubjectAccessReviewFluentImpl.ResourceAccessReviewResponseContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.ResourceAccessReviewResponseContentNested<A> withNewResourceAccessReviewResponseContentLike(ResourceAccessReviewResponse item) {
    return new LocalSubjectAccessReviewFluentImpl.ResourceAccessReviewResponseContentNestedImpl(item);
  }
  public A withExecNewPodHookContent(ExecNewPodHook execNewPodHookContent) {
    _visitables.get("content").remove(this.content);
    if (execNewPodHookContent!=null){ this.content= new ExecNewPodHookBuilder(execNewPodHookContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.ExecNewPodHookContentNested<A> withNewExecNewPodHookContent() {
    return new LocalSubjectAccessReviewFluentImpl.ExecNewPodHookContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.ExecNewPodHookContentNested<A> withNewExecNewPodHookContentLike(ExecNewPodHook item) {
    return new LocalSubjectAccessReviewFluentImpl.ExecNewPodHookContentNestedImpl(item);
  }
  public A withSecretSpecContent(SecretSpec secretSpecContent) {
    _visitables.get("content").remove(this.content);
    if (secretSpecContent!=null){ this.content= new SecretSpecBuilder(secretSpecContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.SecretSpecContentNested<A> withNewSecretSpecContent() {
    return new LocalSubjectAccessReviewFluentImpl.SecretSpecContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.SecretSpecContentNested<A> withNewSecretSpecContentLike(SecretSpec item) {
    return new LocalSubjectAccessReviewFluentImpl.SecretSpecContentNestedImpl(item);
  }
  public A withClusterRoleBindingListContent(ClusterRoleBindingList clusterRoleBindingListContent) {
    _visitables.get("content").remove(this.content);
    if (clusterRoleBindingListContent!=null){ this.content= new ClusterRoleBindingListBuilder(clusterRoleBindingListContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.ClusterRoleBindingListContentNested<A> withNewClusterRoleBindingListContent() {
    return new LocalSubjectAccessReviewFluentImpl.ClusterRoleBindingListContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.ClusterRoleBindingListContentNested<A> withNewClusterRoleBindingListContentLike(ClusterRoleBindingList item) {
    return new LocalSubjectAccessReviewFluentImpl.ClusterRoleBindingListContentNestedImpl(item);
  }
  public A withEgressNetworkPolicyPeerContent(EgressNetworkPolicyPeer egressNetworkPolicyPeerContent) {
    _visitables.get("content").remove(this.content);
    if (egressNetworkPolicyPeerContent!=null){ this.content= new EgressNetworkPolicyPeerBuilder(egressNetworkPolicyPeerContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.EgressNetworkPolicyPeerContentNested<A> withNewEgressNetworkPolicyPeerContent() {
    return new LocalSubjectAccessReviewFluentImpl.EgressNetworkPolicyPeerContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.EgressNetworkPolicyPeerContentNested<A> withNewEgressNetworkPolicyPeerContentLike(EgressNetworkPolicyPeer item) {
    return new LocalSubjectAccessReviewFluentImpl.EgressNetworkPolicyPeerContentNestedImpl(item);
  }
  public A withNewEgressNetworkPolicyPeerContent(String cidrSelector,String dnsName) {
    return (A)withEgressNetworkPolicyPeerContent(new EgressNetworkPolicyPeer(cidrSelector, dnsName));
  }
  public A withTemplateInstanceContent(TemplateInstance templateInstanceContent) {
    _visitables.get("content").remove(this.content);
    if (templateInstanceContent!=null){ this.content= new TemplateInstanceBuilder(templateInstanceContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.TemplateInstanceContentNested<A> withNewTemplateInstanceContent() {
    return new LocalSubjectAccessReviewFluentImpl.TemplateInstanceContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.TemplateInstanceContentNested<A> withNewTemplateInstanceContentLike(TemplateInstance item) {
    return new LocalSubjectAccessReviewFluentImpl.TemplateInstanceContentNestedImpl(item);
  }
  public A withWebHookTriggerContent(WebHookTrigger webHookTriggerContent) {
    _visitables.get("content").remove(this.content);
    if (webHookTriggerContent!=null){ this.content= new WebHookTriggerBuilder(webHookTriggerContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.WebHookTriggerContentNested<A> withNewWebHookTriggerContent() {
    return new LocalSubjectAccessReviewFluentImpl.WebHookTriggerContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.WebHookTriggerContentNested<A> withNewWebHookTriggerContentLike(WebHookTrigger item) {
    return new LocalSubjectAccessReviewFluentImpl.WebHookTriggerContentNestedImpl(item);
  }
  public A withServiceAccountReferenceContent(ServiceAccountReference serviceAccountReferenceContent) {
    _visitables.get("content").remove(this.content);
    if (serviceAccountReferenceContent!=null){ this.content= new ServiceAccountReferenceBuilder(serviceAccountReferenceContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.ServiceAccountReferenceContentNested<A> withNewServiceAccountReferenceContent() {
    return new LocalSubjectAccessReviewFluentImpl.ServiceAccountReferenceContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.ServiceAccountReferenceContentNested<A> withNewServiceAccountReferenceContentLike(ServiceAccountReference item) {
    return new LocalSubjectAccessReviewFluentImpl.ServiceAccountReferenceContentNestedImpl(item);
  }
  public A withNewServiceAccountReferenceContent(String name,String namespace) {
    return (A)withServiceAccountReferenceContent(new ServiceAccountReference(name, namespace));
  }
  public A withBuildContent(Build buildContent) {
    _visitables.get("content").remove(this.content);
    if (buildContent!=null){ this.content= new BuildBuilder(buildContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.BuildContentNested<A> withNewBuildContent() {
    return new LocalSubjectAccessReviewFluentImpl.BuildContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.BuildContentNested<A> withNewBuildContentLike(Build item) {
    return new LocalSubjectAccessReviewFluentImpl.BuildContentNestedImpl(item);
  }
  public A withRoleBindingRestrictionContent(RoleBindingRestriction roleBindingRestrictionContent) {
    _visitables.get("content").remove(this.content);
    if (roleBindingRestrictionContent!=null){ this.content= new RoleBindingRestrictionBuilder(roleBindingRestrictionContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.RoleBindingRestrictionContentNested<A> withNewRoleBindingRestrictionContent() {
    return new LocalSubjectAccessReviewFluentImpl.RoleBindingRestrictionContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.RoleBindingRestrictionContentNested<A> withNewRoleBindingRestrictionContentLike(RoleBindingRestriction item) {
    return new LocalSubjectAccessReviewFluentImpl.RoleBindingRestrictionContentNestedImpl(item);
  }
  public A withTagImportPolicyContent(TagImportPolicy tagImportPolicyContent) {
    _visitables.get("content").remove(this.content);
    if (tagImportPolicyContent!=null){ this.content= new TagImportPolicyBuilder(tagImportPolicyContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.TagImportPolicyContentNested<A> withNewTagImportPolicyContent() {
    return new LocalSubjectAccessReviewFluentImpl.TagImportPolicyContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.TagImportPolicyContentNested<A> withNewTagImportPolicyContentLike(TagImportPolicy item) {
    return new LocalSubjectAccessReviewFluentImpl.TagImportPolicyContentNestedImpl(item);
  }
  public A withNewTagImportPolicyContent(Boolean insecure,Boolean scheduled) {
    return (A)withTagImportPolicyContent(new TagImportPolicy(insecure, scheduled));
  }
  public A withImageStreamTagContent(ImageStreamTag imageStreamTagContent) {
    _visitables.get("content").remove(this.content);
    if (imageStreamTagContent!=null){ this.content= new ImageStreamTagBuilder(imageStreamTagContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.ImageStreamTagContentNested<A> withNewImageStreamTagContent() {
    return new LocalSubjectAccessReviewFluentImpl.ImageStreamTagContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.ImageStreamTagContentNested<A> withNewImageStreamTagContentLike(ImageStreamTag item) {
    return new LocalSubjectAccessReviewFluentImpl.ImageStreamTagContentNestedImpl(item);
  }
  public A withBuildTriggerPolicyContent(BuildTriggerPolicy buildTriggerPolicyContent) {
    _visitables.get("content").remove(this.content);
    if (buildTriggerPolicyContent!=null){ this.content= new BuildTriggerPolicyBuilder(buildTriggerPolicyContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.BuildTriggerPolicyContentNested<A> withNewBuildTriggerPolicyContent() {
    return new LocalSubjectAccessReviewFluentImpl.BuildTriggerPolicyContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.BuildTriggerPolicyContentNested<A> withNewBuildTriggerPolicyContentLike(BuildTriggerPolicy item) {
    return new LocalSubjectAccessReviewFluentImpl.BuildTriggerPolicyContentNestedImpl(item);
  }
  public A withRoutePortContent(RoutePort routePortContent) {
    _visitables.get("content").remove(this.content);
    if (routePortContent!=null){ this.content= new RoutePortBuilder(routePortContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.RoutePortContentNested<A> withNewRoutePortContent() {
    return new LocalSubjectAccessReviewFluentImpl.RoutePortContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.RoutePortContentNested<A> withNewRoutePortContentLike(RoutePort item) {
    return new LocalSubjectAccessReviewFluentImpl.RoutePortContentNestedImpl(item);
  }
  public A withTemplateInstanceRequesterContent(TemplateInstanceRequester templateInstanceRequesterContent) {
    _visitables.get("content").remove(this.content);
    if (templateInstanceRequesterContent!=null){ this.content= new TemplateInstanceRequesterBuilder(templateInstanceRequesterContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.TemplateInstanceRequesterContentNested<A> withNewTemplateInstanceRequesterContent() {
    return new LocalSubjectAccessReviewFluentImpl.TemplateInstanceRequesterContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.TemplateInstanceRequesterContentNested<A> withNewTemplateInstanceRequesterContentLike(TemplateInstanceRequester item) {
    return new LocalSubjectAccessReviewFluentImpl.TemplateInstanceRequesterContentNestedImpl(item);
  }
  public A withGroupContent(Group groupContent) {
    _visitables.get("content").remove(this.content);
    if (groupContent!=null){ this.content= new GroupBuilder(groupContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.GroupContentNested<A> withNewGroupContent() {
    return new LocalSubjectAccessReviewFluentImpl.GroupContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.GroupContentNested<A> withNewGroupContentLike(Group item) {
    return new LocalSubjectAccessReviewFluentImpl.GroupContentNestedImpl(item);
  }
  public A withBuildTriggerCauseContent(BuildTriggerCause buildTriggerCauseContent) {
    _visitables.get("content").remove(this.content);
    if (buildTriggerCauseContent!=null){ this.content= new BuildTriggerCauseBuilder(buildTriggerCauseContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.BuildTriggerCauseContentNested<A> withNewBuildTriggerCauseContent() {
    return new LocalSubjectAccessReviewFluentImpl.BuildTriggerCauseContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.BuildTriggerCauseContentNested<A> withNewBuildTriggerCauseContentLike(BuildTriggerCause item) {
    return new LocalSubjectAccessReviewFluentImpl.BuildTriggerCauseContentNestedImpl(item);
  }
  public A withImageSignatureContent(ImageSignature imageSignatureContent) {
    _visitables.get("content").remove(this.content);
    if (imageSignatureContent!=null){ this.content= new ImageSignatureBuilder(imageSignatureContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.ImageSignatureContentNested<A> withNewImageSignatureContent() {
    return new LocalSubjectAccessReviewFluentImpl.ImageSignatureContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.ImageSignatureContentNested<A> withNewImageSignatureContentLike(ImageSignature item) {
    return new LocalSubjectAccessReviewFluentImpl.ImageSignatureContentNestedImpl(item);
  }
  public A withHelmChartRepositoryStatusContent(HelmChartRepositoryStatus helmChartRepositoryStatusContent) {
    _visitables.get("content").remove(this.content);
    if (helmChartRepositoryStatusContent!=null){ this.content= new HelmChartRepositoryStatusBuilder(helmChartRepositoryStatusContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.HelmChartRepositoryStatusContentNested<A> withNewHelmChartRepositoryStatusContent() {
    return new LocalSubjectAccessReviewFluentImpl.HelmChartRepositoryStatusContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.HelmChartRepositoryStatusContentNested<A> withNewHelmChartRepositoryStatusContentLike(HelmChartRepositoryStatus item) {
    return new LocalSubjectAccessReviewFluentImpl.HelmChartRepositoryStatusContentNestedImpl(item);
  }
  public A withDeploymentConfigSpecContent(DeploymentConfigSpec deploymentConfigSpecContent) {
    _visitables.get("content").remove(this.content);
    if (deploymentConfigSpecContent!=null){ this.content= new DeploymentConfigSpecBuilder(deploymentConfigSpecContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.DeploymentConfigSpecContentNested<A> withNewDeploymentConfigSpecContent() {
    return new LocalSubjectAccessReviewFluentImpl.DeploymentConfigSpecContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.DeploymentConfigSpecContentNested<A> withNewDeploymentConfigSpecContentLike(DeploymentConfigSpec item) {
    return new LocalSubjectAccessReviewFluentImpl.DeploymentConfigSpecContentNestedImpl(item);
  }
  public A withHostSubnetContent(HostSubnet hostSubnetContent) {
    _visitables.get("content").remove(this.content);
    if (hostSubnetContent!=null){ this.content= new HostSubnetBuilder(hostSubnetContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.HostSubnetContentNested<A> withNewHostSubnetContent() {
    return new LocalSubjectAccessReviewFluentImpl.HostSubnetContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.HostSubnetContentNested<A> withNewHostSubnetContentLike(HostSubnet item) {
    return new LocalSubjectAccessReviewFluentImpl.HostSubnetContentNestedImpl(item);
  }
  public A withGroupRestrictionContent(GroupRestriction groupRestrictionContent) {
    _visitables.get("content").remove(this.content);
    if (groupRestrictionContent!=null){ this.content= new GroupRestrictionBuilder(groupRestrictionContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.GroupRestrictionContentNested<A> withNewGroupRestrictionContent() {
    return new LocalSubjectAccessReviewFluentImpl.GroupRestrictionContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.GroupRestrictionContentNested<A> withNewGroupRestrictionContentLike(GroupRestriction item) {
    return new LocalSubjectAccessReviewFluentImpl.GroupRestrictionContentNestedImpl(item);
  }
  public A withAppliedClusterResourceQuotaContent(AppliedClusterResourceQuota appliedClusterResourceQuotaContent) {
    _visitables.get("content").remove(this.content);
    if (appliedClusterResourceQuotaContent!=null){ this.content= new AppliedClusterResourceQuotaBuilder(appliedClusterResourceQuotaContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.AppliedClusterResourceQuotaContentNested<A> withNewAppliedClusterResourceQuotaContent() {
    return new LocalSubjectAccessReviewFluentImpl.AppliedClusterResourceQuotaContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.AppliedClusterResourceQuotaContentNested<A> withNewAppliedClusterResourceQuotaContentLike(AppliedClusterResourceQuota item) {
    return new LocalSubjectAccessReviewFluentImpl.AppliedClusterResourceQuotaContentNestedImpl(item);
  }
  public A withOAuthAccessTokenListContent(OAuthAccessTokenList oAuthAccessTokenListContent) {
    _visitables.get("content").remove(this.content);
    if (oAuthAccessTokenListContent!=null){ this.content= new OAuthAccessTokenListBuilder(oAuthAccessTokenListContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.OAuthAccessTokenListContentNested<A> withNewOAuthAccessTokenListContent() {
    return new LocalSubjectAccessReviewFluentImpl.OAuthAccessTokenListContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.OAuthAccessTokenListContentNested<A> withNewOAuthAccessTokenListContentLike(OAuthAccessTokenList item) {
    return new LocalSubjectAccessReviewFluentImpl.OAuthAccessTokenListContentNestedImpl(item);
  }
  public A withJenkinsPipelineBuildStrategyContent(JenkinsPipelineBuildStrategy jenkinsPipelineBuildStrategyContent) {
    _visitables.get("content").remove(this.content);
    if (jenkinsPipelineBuildStrategyContent!=null){ this.content= new JenkinsPipelineBuildStrategyBuilder(jenkinsPipelineBuildStrategyContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.JenkinsPipelineBuildStrategyContentNested<A> withNewJenkinsPipelineBuildStrategyContent() {
    return new LocalSubjectAccessReviewFluentImpl.JenkinsPipelineBuildStrategyContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.JenkinsPipelineBuildStrategyContentNested<A> withNewJenkinsPipelineBuildStrategyContentLike(JenkinsPipelineBuildStrategy item) {
    return new LocalSubjectAccessReviewFluentImpl.JenkinsPipelineBuildStrategyContentNestedImpl(item);
  }
  public A withSecurityContextConstraintsContent(SecurityContextConstraints securityContextConstraintsContent) {
    _visitables.get("content").remove(this.content);
    if (securityContextConstraintsContent!=null){ this.content= new SecurityContextConstraintsBuilder(securityContextConstraintsContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.SecurityContextConstraintsContentNested<A> withNewSecurityContextConstraintsContent() {
    return new LocalSubjectAccessReviewFluentImpl.SecurityContextConstraintsContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.SecurityContextConstraintsContentNested<A> withNewSecurityContextConstraintsContentLike(SecurityContextConstraints item) {
    return new LocalSubjectAccessReviewFluentImpl.SecurityContextConstraintsContentNestedImpl(item);
  }
  public A withSupplementalGroupsStrategyOptionsContent(SupplementalGroupsStrategyOptions supplementalGroupsStrategyOptionsContent) {
    _visitables.get("content").remove(this.content);
    if (supplementalGroupsStrategyOptionsContent!=null){ this.content= new SupplementalGroupsStrategyOptionsBuilder(supplementalGroupsStrategyOptionsContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.SupplementalGroupsStrategyOptionsContentNested<A> withNewSupplementalGroupsStrategyOptionsContent() {
    return new LocalSubjectAccessReviewFluentImpl.SupplementalGroupsStrategyOptionsContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.SupplementalGroupsStrategyOptionsContentNested<A> withNewSupplementalGroupsStrategyOptionsContentLike(SupplementalGroupsStrategyOptions item) {
    return new LocalSubjectAccessReviewFluentImpl.SupplementalGroupsStrategyOptionsContentNestedImpl(item);
  }
  public A withServiceAccountPodSecurityPolicyReviewStatusContent(ServiceAccountPodSecurityPolicyReviewStatus serviceAccountPodSecurityPolicyReviewStatusContent) {
    _visitables.get("content").remove(this.content);
    if (serviceAccountPodSecurityPolicyReviewStatusContent!=null){ this.content= new ServiceAccountPodSecurityPolicyReviewStatusBuilder(serviceAccountPodSecurityPolicyReviewStatusContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.ServiceAccountPodSecurityPolicyReviewStatusContentNested<A> withNewServiceAccountPodSecurityPolicyReviewStatusContent() {
    return new LocalSubjectAccessReviewFluentImpl.ServiceAccountPodSecurityPolicyReviewStatusContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.ServiceAccountPodSecurityPolicyReviewStatusContentNested<A> withNewServiceAccountPodSecurityPolicyReviewStatusContentLike(ServiceAccountPodSecurityPolicyReviewStatus item) {
    return new LocalSubjectAccessReviewFluentImpl.ServiceAccountPodSecurityPolicyReviewStatusContentNestedImpl(item);
  }
  public A withBuildRequestContent(BuildRequest buildRequestContent) {
    _visitables.get("content").remove(this.content);
    if (buildRequestContent!=null){ this.content= new BuildRequestBuilder(buildRequestContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.BuildRequestContentNested<A> withNewBuildRequestContent() {
    return new LocalSubjectAccessReviewFluentImpl.BuildRequestContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.BuildRequestContentNested<A> withNewBuildRequestContentLike(BuildRequest item) {
    return new LocalSubjectAccessReviewFluentImpl.BuildRequestContentNestedImpl(item);
  }
  public A withSELinuxContextStrategyOptionsContent(SELinuxContextStrategyOptions sELinuxContextStrategyOptionsContent) {
    _visitables.get("content").remove(this.content);
    if (sELinuxContextStrategyOptionsContent!=null){ this.content= new SELinuxContextStrategyOptionsBuilder(sELinuxContextStrategyOptionsContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.SELinuxContextStrategyOptionsContentNested<A> withNewSELinuxContextStrategyOptionsContent() {
    return new LocalSubjectAccessReviewFluentImpl.SELinuxContextStrategyOptionsContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.SELinuxContextStrategyOptionsContentNested<A> withNewSELinuxContextStrategyOptionsContentLike(SELinuxContextStrategyOptions item) {
    return new LocalSubjectAccessReviewFluentImpl.SELinuxContextStrategyOptionsContentNestedImpl(item);
  }
  public A withClusterRoleListContent(ClusterRoleList clusterRoleListContent) {
    _visitables.get("content").remove(this.content);
    if (clusterRoleListContent!=null){ this.content= new ClusterRoleListBuilder(clusterRoleListContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.ClusterRoleListContentNested<A> withNewClusterRoleListContent() {
    return new LocalSubjectAccessReviewFluentImpl.ClusterRoleListContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.ClusterRoleListContentNested<A> withNewClusterRoleListContentLike(ClusterRoleList item) {
    return new LocalSubjectAccessReviewFluentImpl.ClusterRoleListContentNestedImpl(item);
  }
  public A withRouteListContent(RouteList routeListContent) {
    _visitables.get("content").remove(this.content);
    if (routeListContent!=null){ this.content= new RouteListBuilder(routeListContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.RouteListContentNested<A> withNewRouteListContent() {
    return new LocalSubjectAccessReviewFluentImpl.RouteListContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.RouteListContentNested<A> withNewRouteListContentLike(RouteList item) {
    return new LocalSubjectAccessReviewFluentImpl.RouteListContentNestedImpl(item);
  }
  public A withImageStreamStatusContent(ImageStreamStatus imageStreamStatusContent) {
    _visitables.get("content").remove(this.content);
    if (imageStreamStatusContent!=null){ this.content= new ImageStreamStatusBuilder(imageStreamStatusContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.ImageStreamStatusContentNested<A> withNewImageStreamStatusContent() {
    return new LocalSubjectAccessReviewFluentImpl.ImageStreamStatusContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.ImageStreamStatusContentNested<A> withNewImageStreamStatusContentLike(ImageStreamStatus item) {
    return new LocalSubjectAccessReviewFluentImpl.ImageStreamStatusContentNestedImpl(item);
  }
  public A withEgressNetworkPolicyContent(EgressNetworkPolicy egressNetworkPolicyContent) {
    _visitables.get("content").remove(this.content);
    if (egressNetworkPolicyContent!=null){ this.content= new EgressNetworkPolicyBuilder(egressNetworkPolicyContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.EgressNetworkPolicyContentNested<A> withNewEgressNetworkPolicyContent() {
    return new LocalSubjectAccessReviewFluentImpl.EgressNetworkPolicyContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.EgressNetworkPolicyContentNested<A> withNewEgressNetworkPolicyContentLike(EgressNetworkPolicy item) {
    return new LocalSubjectAccessReviewFluentImpl.EgressNetworkPolicyContentNestedImpl(item);
  }
  public A withNetNamespaceContent(NetNamespace netNamespaceContent) {
    _visitables.get("content").remove(this.content);
    if (netNamespaceContent!=null){ this.content= new NetNamespaceBuilder(netNamespaceContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.NetNamespaceContentNested<A> withNewNetNamespaceContent() {
    return new LocalSubjectAccessReviewFluentImpl.NetNamespaceContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.NetNamespaceContentNested<A> withNewNetNamespaceContentLike(NetNamespace item) {
    return new LocalSubjectAccessReviewFluentImpl.NetNamespaceContentNestedImpl(item);
  }
  public A withUserIdentityMappingContent(UserIdentityMapping userIdentityMappingContent) {
    _visitables.get("content").remove(this.content);
    if (userIdentityMappingContent!=null){ this.content= new UserIdentityMappingBuilder(userIdentityMappingContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.UserIdentityMappingContentNested<A> withNewUserIdentityMappingContent() {
    return new LocalSubjectAccessReviewFluentImpl.UserIdentityMappingContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.UserIdentityMappingContentNested<A> withNewUserIdentityMappingContentLike(UserIdentityMapping item) {
    return new LocalSubjectAccessReviewFluentImpl.UserIdentityMappingContentNestedImpl(item);
  }
  public A withDeploymentDetailsContent(DeploymentDetails deploymentDetailsContent) {
    _visitables.get("content").remove(this.content);
    if (deploymentDetailsContent!=null){ this.content= new DeploymentDetailsBuilder(deploymentDetailsContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.DeploymentDetailsContentNested<A> withNewDeploymentDetailsContent() {
    return new LocalSubjectAccessReviewFluentImpl.DeploymentDetailsContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.DeploymentDetailsContentNested<A> withNewDeploymentDetailsContentLike(DeploymentDetails item) {
    return new LocalSubjectAccessReviewFluentImpl.DeploymentDetailsContentNestedImpl(item);
  }
  public A withPodSecurityPolicySubjectReviewStatusContent(PodSecurityPolicySubjectReviewStatus podSecurityPolicySubjectReviewStatusContent) {
    _visitables.get("content").remove(this.content);
    if (podSecurityPolicySubjectReviewStatusContent!=null){ this.content= new PodSecurityPolicySubjectReviewStatusBuilder(podSecurityPolicySubjectReviewStatusContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.PodSecurityPolicySubjectReviewStatusContentNested<A> withNewPodSecurityPolicySubjectReviewStatusContent() {
    return new LocalSubjectAccessReviewFluentImpl.PodSecurityPolicySubjectReviewStatusContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.PodSecurityPolicySubjectReviewStatusContentNested<A> withNewPodSecurityPolicySubjectReviewStatusContentLike(PodSecurityPolicySubjectReviewStatus item) {
    return new LocalSubjectAccessReviewFluentImpl.PodSecurityPolicySubjectReviewStatusContentNestedImpl(item);
  }
  public A withPodSecurityPolicySubjectReviewSpecContent(PodSecurityPolicySubjectReviewSpec podSecurityPolicySubjectReviewSpecContent) {
    _visitables.get("content").remove(this.content);
    if (podSecurityPolicySubjectReviewSpecContent!=null){ this.content= new PodSecurityPolicySubjectReviewSpecBuilder(podSecurityPolicySubjectReviewSpecContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.PodSecurityPolicySubjectReviewSpecContentNested<A> withNewPodSecurityPolicySubjectReviewSpecContent() {
    return new LocalSubjectAccessReviewFluentImpl.PodSecurityPolicySubjectReviewSpecContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.PodSecurityPolicySubjectReviewSpecContentNested<A> withNewPodSecurityPolicySubjectReviewSpecContentLike(PodSecurityPolicySubjectReviewSpec item) {
    return new LocalSubjectAccessReviewFluentImpl.PodSecurityPolicySubjectReviewSpecContentNestedImpl(item);
  }
  public A withImageStreamContent(ImageStream imageStreamContent) {
    _visitables.get("content").remove(this.content);
    if (imageStreamContent!=null){ this.content= new ImageStreamBuilder(imageStreamContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.ImageStreamContentNested<A> withNewImageStreamContent() {
    return new LocalSubjectAccessReviewFluentImpl.ImageStreamContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.ImageStreamContentNested<A> withNewImageStreamContentLike(ImageStream item) {
    return new LocalSubjectAccessReviewFluentImpl.ImageStreamContentNestedImpl(item);
  }
  public A withBuildListContent(BuildList buildListContent) {
    _visitables.get("content").remove(this.content);
    if (buildListContent!=null){ this.content= new BuildListBuilder(buildListContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.BuildListContentNested<A> withNewBuildListContent() {
    return new LocalSubjectAccessReviewFluentImpl.BuildListContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.BuildListContentNested<A> withNewBuildListContentLike(BuildList item) {
    return new LocalSubjectAccessReviewFluentImpl.BuildListContentNestedImpl(item);
  }
  public A withTemplateListContent(TemplateList templateListContent) {
    _visitables.get("content").remove(this.content);
    if (templateListContent!=null){ this.content= new TemplateListBuilder(templateListContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.TemplateListContentNested<A> withNewTemplateListContent() {
    return new LocalSubjectAccessReviewFluentImpl.TemplateListContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.TemplateListContentNested<A> withNewTemplateListContentLike(TemplateList item) {
    return new LocalSubjectAccessReviewFluentImpl.TemplateListContentNestedImpl(item);
  }
  public A withBuildOutputContent(BuildOutput buildOutputContent) {
    _visitables.get("content").remove(this.content);
    if (buildOutputContent!=null){ this.content= new BuildOutputBuilder(buildOutputContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.BuildOutputContentNested<A> withNewBuildOutputContent() {
    return new LocalSubjectAccessReviewFluentImpl.BuildOutputContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.BuildOutputContentNested<A> withNewBuildOutputContentLike(BuildOutput item) {
    return new LocalSubjectAccessReviewFluentImpl.BuildOutputContentNestedImpl(item);
  }
  public A withProjectSpecContent(ProjectSpec projectSpecContent) {
    _visitables.get("content").remove(this.content);
    if (projectSpecContent!=null){ this.content= new ProjectSpecBuilder(projectSpecContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.ProjectSpecContentNested<A> withNewProjectSpecContent() {
    return new LocalSubjectAccessReviewFluentImpl.ProjectSpecContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.ProjectSpecContentNested<A> withNewProjectSpecContentLike(ProjectSpec item) {
    return new LocalSubjectAccessReviewFluentImpl.ProjectSpecContentNestedImpl(item);
  }
  public A withSourceRevisionContent(SourceRevision sourceRevisionContent) {
    _visitables.get("content").remove(this.content);
    if (sourceRevisionContent!=null){ this.content= new SourceRevisionBuilder(sourceRevisionContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.SourceRevisionContentNested<A> withNewSourceRevisionContent() {
    return new LocalSubjectAccessReviewFluentImpl.SourceRevisionContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.SourceRevisionContentNested<A> withNewSourceRevisionContentLike(SourceRevision item) {
    return new LocalSubjectAccessReviewFluentImpl.SourceRevisionContentNestedImpl(item);
  }
  public A withObjectReferenceContent(ObjectReference objectReferenceContent) {
    _visitables.get("content").remove(this.content);
    if (objectReferenceContent!=null){ this.content= new ObjectReferenceBuilder(objectReferenceContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.ObjectReferenceContentNested<A> withNewObjectReferenceContent() {
    return new LocalSubjectAccessReviewFluentImpl.ObjectReferenceContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.ObjectReferenceContentNested<A> withNewObjectReferenceContentLike(ObjectReference item) {
    return new LocalSubjectAccessReviewFluentImpl.ObjectReferenceContentNestedImpl(item);
  }
  public A withSignatureIssuerContent(SignatureIssuer signatureIssuerContent) {
    _visitables.get("content").remove(this.content);
    if (signatureIssuerContent!=null){ this.content= new SignatureIssuerBuilder(signatureIssuerContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.SignatureIssuerContentNested<A> withNewSignatureIssuerContent() {
    return new LocalSubjectAccessReviewFluentImpl.SignatureIssuerContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.SignatureIssuerContentNested<A> withNewSignatureIssuerContentLike(SignatureIssuer item) {
    return new LocalSubjectAccessReviewFluentImpl.SignatureIssuerContentNestedImpl(item);
  }
  public A withNewSignatureIssuerContent(String commonName,String organization) {
    return (A)withSignatureIssuerContent(new SignatureIssuer(commonName, organization));
  }
  public A withImageLayerContent(ImageLayer imageLayerContent) {
    _visitables.get("content").remove(this.content);
    if (imageLayerContent!=null){ this.content= new ImageLayerBuilder(imageLayerContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.ImageLayerContentNested<A> withNewImageLayerContent() {
    return new LocalSubjectAccessReviewFluentImpl.ImageLayerContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.ImageLayerContentNested<A> withNewImageLayerContentLike(ImageLayer item) {
    return new LocalSubjectAccessReviewFluentImpl.ImageLayerContentNestedImpl(item);
  }
  public A withNewImageLayerContent(String mediaType,String name,Long size) {
    return (A)withImageLayerContent(new ImageLayer(mediaType, name, size));
  }
  public A withClusterResourceQuotaSpecContent(ClusterResourceQuotaSpec clusterResourceQuotaSpecContent) {
    _visitables.get("content").remove(this.content);
    if (clusterResourceQuotaSpecContent!=null){ this.content= new ClusterResourceQuotaSpecBuilder(clusterResourceQuotaSpecContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.ClusterResourceQuotaSpecContentNested<A> withNewClusterResourceQuotaSpecContent() {
    return new LocalSubjectAccessReviewFluentImpl.ClusterResourceQuotaSpecContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.ClusterResourceQuotaSpecContentNested<A> withNewClusterResourceQuotaSpecContentLike(ClusterResourceQuotaSpec item) {
    return new LocalSubjectAccessReviewFluentImpl.ClusterResourceQuotaSpecContentNestedImpl(item);
  }
  public A withImageStreamSpecContent(ImageStreamSpec imageStreamSpecContent) {
    _visitables.get("content").remove(this.content);
    if (imageStreamSpecContent!=null){ this.content= new ImageStreamSpecBuilder(imageStreamSpecContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.ImageStreamSpecContentNested<A> withNewImageStreamSpecContent() {
    return new LocalSubjectAccessReviewFluentImpl.ImageStreamSpecContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.ImageStreamSpecContentNested<A> withNewImageStreamSpecContentLike(ImageStreamSpec item) {
    return new LocalSubjectAccessReviewFluentImpl.ImageStreamSpecContentNestedImpl(item);
  }
  public A withRouteIngressContent(RouteIngress routeIngressContent) {
    _visitables.get("content").remove(this.content);
    if (routeIngressContent!=null){ this.content= new RouteIngressBuilder(routeIngressContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.RouteIngressContentNested<A> withNewRouteIngressContent() {
    return new LocalSubjectAccessReviewFluentImpl.RouteIngressContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.RouteIngressContentNested<A> withNewRouteIngressContentLike(RouteIngress item) {
    return new LocalSubjectAccessReviewFluentImpl.RouteIngressContentNestedImpl(item);
  }
  public A withOAuthClientContent(OAuthClient oAuthClientContent) {
    _visitables.get("content").remove(this.content);
    if (oAuthClientContent!=null){ this.content= new OAuthClientBuilder(oAuthClientContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.OAuthClientContentNested<A> withNewOAuthClientContent() {
    return new LocalSubjectAccessReviewFluentImpl.OAuthClientContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.OAuthClientContentNested<A> withNewOAuthClientContentLike(OAuthClient item) {
    return new LocalSubjectAccessReviewFluentImpl.OAuthClientContentNestedImpl(item);
  }
  public A withIdentityContent(Identity identityContent) {
    _visitables.get("content").remove(this.content);
    if (identityContent!=null){ this.content= new IdentityBuilder(identityContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.IdentityContentNested<A> withNewIdentityContent() {
    return new LocalSubjectAccessReviewFluentImpl.IdentityContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.IdentityContentNested<A> withNewIdentityContentLike(Identity item) {
    return new LocalSubjectAccessReviewFluentImpl.IdentityContentNestedImpl(item);
  }
  public A withRangeAllocationListContent(RangeAllocationList rangeAllocationListContent) {
    _visitables.get("content").remove(this.content);
    if (rangeAllocationListContent!=null){ this.content= new RangeAllocationListBuilder(rangeAllocationListContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public LocalSubjectAccessReviewFluent.RangeAllocationListContentNested<A> withNewRangeAllocationListContent() {
    return new LocalSubjectAccessReviewFluentImpl.RangeAllocationListContentNestedImpl();
  }
  public LocalSubjectAccessReviewFluent.RangeAllocationListContentNested<A> withNewRangeAllocationListContentLike(RangeAllocationList item) {
    return new LocalSubjectAccessReviewFluentImpl.RangeAllocationListContentNestedImpl(item);
  }
  public A addToGroups(Integer index,String item) {
    if (this.groups == null) {this.groups = new ArrayList<String>();}
    this.groups.add(index, item);
    return (A)this;
  }
  public A setToGroups(Integer index,String item) {
    if (this.groups == null) {this.groups = new ArrayList<String>();}
    this.groups.set(index, item); return (A)this;
  }
  public A addToGroups(java.lang.String... items) {
    if (this.groups == null) {this.groups = new ArrayList<String>();}
    for (String item : items) {this.groups.add(item);} return (A)this;
  }
  public A addAllToGroups(Collection<String> items) {
    if (this.groups == null) {this.groups = new ArrayList<String>();}
    for (String item : items) {this.groups.add(item);} return (A)this;
  }
  public A removeFromGroups(java.lang.String... items) {
    for (String item : items) {if (this.groups!= null){ this.groups.remove(item);}} return (A)this;
  }
  public A removeAllFromGroups(Collection<String> items) {
    for (String item : items) {if (this.groups!= null){ this.groups.remove(item);}} return (A)this;
  }
  public List<String> getGroups() {
    return this.groups;
  }
  public String getGroup(Integer index) {
    return this.groups.get(index);
  }
  public String getFirstGroup() {
    return this.groups.get(0);
  }
  public String getLastGroup() {
    return this.groups.get(groups.size() - 1);
  }
  public String getMatchingGroup(Predicate<String> predicate) {
    for (String item: groups) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingGroup(Predicate<String> predicate) {
    for (String item: groups) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withGroups(List<String> groups) {
    if (groups != null) {this.groups = new ArrayList(); for (String item : groups){this.addToGroups(item);}} else { this.groups = null;} return (A) this;
  }
  public A withGroups(java.lang.String... groups) {
    if (this.groups != null) {this.groups.clear();}
    if (groups != null) {for (String item :groups){ this.addToGroups(item);}} return (A) this;
  }
  public Boolean hasGroups() {
    return groups != null && !groups.isEmpty();
  }
  public Boolean getIsNonResourceURL() {
    return this.isNonResourceURL;
  }
  public A withIsNonResourceURL(Boolean isNonResourceURL) {
    this.isNonResourceURL=isNonResourceURL; return (A) this;
  }
  public Boolean hasIsNonResourceURL() {
    return this.isNonResourceURL != null;
  }
  public String getKind() {
    return this.kind;
  }
  public A withKind(String kind) {
    this.kind=kind; return (A) this;
  }
  public Boolean hasKind() {
    return this.kind != null;
  }
  public String getNamespace() {
    return this.namespace;
  }
  public A withNamespace(String namespace) {
    this.namespace=namespace; return (A) this;
  }
  public Boolean hasNamespace() {
    return this.namespace != null;
  }
  public String getPath() {
    return this.path;
  }
  public A withPath(String path) {
    this.path=path; return (A) this;
  }
  public Boolean hasPath() {
    return this.path != null;
  }
  public String getResource() {
    return this.resource;
  }
  public A withResource(String resource) {
    this.resource=resource; return (A) this;
  }
  public Boolean hasResource() {
    return this.resource != null;
  }
  public String getResourceAPIGroup() {
    return this.resourceAPIGroup;
  }
  public A withResourceAPIGroup(String resourceAPIGroup) {
    this.resourceAPIGroup=resourceAPIGroup; return (A) this;
  }
  public Boolean hasResourceAPIGroup() {
    return this.resourceAPIGroup != null;
  }
  public String getResourceAPIVersion() {
    return this.resourceAPIVersion;
  }
  public A withResourceAPIVersion(String resourceAPIVersion) {
    this.resourceAPIVersion=resourceAPIVersion; return (A) this;
  }
  public Boolean hasResourceAPIVersion() {
    return this.resourceAPIVersion != null;
  }
  public String getResourceName() {
    return this.resourceName;
  }
  public A withResourceName(String resourceName) {
    this.resourceName=resourceName; return (A) this;
  }
  public Boolean hasResourceName() {
    return this.resourceName != null;
  }
  public A addToScopes(Integer index,String item) {
    if (this.scopes == null) {this.scopes = new ArrayList<String>();}
    this.scopes.add(index, item);
    return (A)this;
  }
  public A setToScopes(Integer index,String item) {
    if (this.scopes == null) {this.scopes = new ArrayList<String>();}
    this.scopes.set(index, item); return (A)this;
  }
  public A addToScopes(java.lang.String... items) {
    if (this.scopes == null) {this.scopes = new ArrayList<String>();}
    for (String item : items) {this.scopes.add(item);} return (A)this;
  }
  public A addAllToScopes(Collection<String> items) {
    if (this.scopes == null) {this.scopes = new ArrayList<String>();}
    for (String item : items) {this.scopes.add(item);} return (A)this;
  }
  public A removeFromScopes(java.lang.String... items) {
    for (String item : items) {if (this.scopes!= null){ this.scopes.remove(item);}} return (A)this;
  }
  public A removeAllFromScopes(Collection<String> items) {
    for (String item : items) {if (this.scopes!= null){ this.scopes.remove(item);}} return (A)this;
  }
  public List<String> getScopes() {
    return this.scopes;
  }
  public String getScope(Integer index) {
    return this.scopes.get(index);
  }
  public String getFirstScope() {
    return this.scopes.get(0);
  }
  public String getLastScope() {
    return this.scopes.get(scopes.size() - 1);
  }
  public String getMatchingScope(Predicate<String> predicate) {
    for (String item: scopes) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingScope(Predicate<String> predicate) {
    for (String item: scopes) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withScopes(List<String> scopes) {
    if (scopes != null) {this.scopes = new ArrayList(); for (String item : scopes){this.addToScopes(item);}} else { this.scopes = null;} return (A) this;
  }
  public A withScopes(java.lang.String... scopes) {
    if (this.scopes != null) {this.scopes.clear();}
    if (scopes != null) {for (String item :scopes){ this.addToScopes(item);}} return (A) this;
  }
  public Boolean hasScopes() {
    return scopes != null && !scopes.isEmpty();
  }
  public String getUser() {
    return this.user;
  }
  public A withUser(String user) {
    this.user=user; return (A) this;
  }
  public Boolean hasUser() {
    return this.user != null;
  }
  public String getVerb() {
    return this.verb;
  }
  public A withVerb(String verb) {
    this.verb=verb; return (A) this;
  }
  public Boolean hasVerb() {
    return this.verb != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    LocalSubjectAccessReviewFluentImpl that = (LocalSubjectAccessReviewFluentImpl) o;
    if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
    if (content != null ? !content.equals(that.content) :that.content != null) return false;
    if (groups != null ? !groups.equals(that.groups) :that.groups != null) return false;
    if (isNonResourceURL != null ? !isNonResourceURL.equals(that.isNonResourceURL) :that.isNonResourceURL != null) return false;
    if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
    if (namespace != null ? !namespace.equals(that.namespace) :that.namespace != null) return false;
    if (path != null ? !path.equals(that.path) :that.path != null) return false;
    if (resource != null ? !resource.equals(that.resource) :that.resource != null) return false;
    if (resourceAPIGroup != null ? !resourceAPIGroup.equals(that.resourceAPIGroup) :that.resourceAPIGroup != null) return false;
    if (resourceAPIVersion != null ? !resourceAPIVersion.equals(that.resourceAPIVersion) :that.resourceAPIVersion != null) return false;
    if (resourceName != null ? !resourceName.equals(that.resourceName) :that.resourceName != null) return false;
    if (scopes != null ? !scopes.equals(that.scopes) :that.scopes != null) return false;
    if (user != null ? !user.equals(that.user) :that.user != null) return false;
    if (verb != null ? !verb.equals(that.verb) :that.verb != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  content,  groups,  isNonResourceURL,  kind,  namespace,  path,  resource,  resourceAPIGroup,  resourceAPIVersion,  resourceName,  scopes,  user,  verb,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (content != null) { sb.append("content:"); sb.append(content + ","); }
    if (groups != null && !groups.isEmpty()) { sb.append("groups:"); sb.append(groups + ","); }
    if (isNonResourceURL != null) { sb.append("isNonResourceURL:"); sb.append(isNonResourceURL + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (namespace != null) { sb.append("namespace:"); sb.append(namespace + ","); }
    if (path != null) { sb.append("path:"); sb.append(path + ","); }
    if (resource != null) { sb.append("resource:"); sb.append(resource + ","); }
    if (resourceAPIGroup != null) { sb.append("resourceAPIGroup:"); sb.append(resourceAPIGroup + ","); }
    if (resourceAPIVersion != null) { sb.append("resourceAPIVersion:"); sb.append(resourceAPIVersion + ","); }
    if (resourceName != null) { sb.append("resourceName:"); sb.append(resourceName + ","); }
    if (scopes != null && !scopes.isEmpty()) { sb.append("scopes:"); sb.append(scopes + ","); }
    if (user != null) { sb.append("user:"); sb.append(user + ","); }
    if (verb != null) { sb.append("verb:"); sb.append(verb + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public A withIsNonResourceURL() {
    return withIsNonResourceURL(true);
  }
  class GenericWebHookCauseContentNestedImpl<N> extends GenericWebHookCauseFluentImpl<LocalSubjectAccessReviewFluent.GenericWebHookCauseContentNested<N>> implements LocalSubjectAccessReviewFluent.GenericWebHookCauseContentNested<N>,Nested<N>{
    GenericWebHookCauseContentNestedImpl(GenericWebHookCause item) {
      this.builder = new GenericWebHookCauseBuilder(this, item);
    }
    GenericWebHookCauseContentNestedImpl() {
      this.builder = new GenericWebHookCauseBuilder(this);
    }
    GenericWebHookCauseBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endGenericWebHookCauseContent() {
      return and();
    }
    
  }
  class ServiceAccountRestrictionContentNestedImpl<N> extends ServiceAccountRestrictionFluentImpl<LocalSubjectAccessReviewFluent.ServiceAccountRestrictionContentNested<N>> implements LocalSubjectAccessReviewFluent.ServiceAccountRestrictionContentNested<N>,Nested<N>{
    ServiceAccountRestrictionContentNestedImpl(ServiceAccountRestriction item) {
      this.builder = new ServiceAccountRestrictionBuilder(this, item);
    }
    ServiceAccountRestrictionContentNestedImpl() {
      this.builder = new ServiceAccountRestrictionBuilder(this);
    }
    ServiceAccountRestrictionBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endServiceAccountRestrictionContent() {
      return and();
    }
    
  }
  class ScopeRestrictionContentNestedImpl<N> extends ScopeRestrictionFluentImpl<LocalSubjectAccessReviewFluent.ScopeRestrictionContentNested<N>> implements LocalSubjectAccessReviewFluent.ScopeRestrictionContentNested<N>,Nested<N>{
    ScopeRestrictionContentNestedImpl(ScopeRestriction item) {
      this.builder = new ScopeRestrictionBuilder(this, item);
    }
    ScopeRestrictionContentNestedImpl() {
      this.builder = new ScopeRestrictionBuilder(this);
    }
    ScopeRestrictionBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endScopeRestrictionContent() {
      return and();
    }
    
  }
  class SecretLocalReferenceContentNestedImpl<N> extends SecretLocalReferenceFluentImpl<LocalSubjectAccessReviewFluent.SecretLocalReferenceContentNested<N>> implements LocalSubjectAccessReviewFluent.SecretLocalReferenceContentNested<N>,Nested<N>{
    SecretLocalReferenceContentNestedImpl(SecretLocalReference item) {
      this.builder = new SecretLocalReferenceBuilder(this, item);
    }
    SecretLocalReferenceContentNestedImpl() {
      this.builder = new SecretLocalReferenceBuilder(this);
    }
    SecretLocalReferenceBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endSecretLocalReferenceContent() {
      return and();
    }
    
  }
  class StepInfoContentNestedImpl<N> extends StepInfoFluentImpl<LocalSubjectAccessReviewFluent.StepInfoContentNested<N>> implements LocalSubjectAccessReviewFluent.StepInfoContentNested<N>,Nested<N>{
    StepInfoContentNestedImpl(StepInfo item) {
      this.builder = new StepInfoBuilder(this, item);
    }
    StepInfoContentNestedImpl() {
      this.builder = new StepInfoBuilder(this);
    }
    StepInfoBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endStepInfoContent() {
      return and();
    }
    
  }
  class UserRestrictionContentNestedImpl<N> extends UserRestrictionFluentImpl<LocalSubjectAccessReviewFluent.UserRestrictionContentNested<N>> implements LocalSubjectAccessReviewFluent.UserRestrictionContentNested<N>,Nested<N>{
    UserRestrictionContentNestedImpl(UserRestriction item) {
      this.builder = new UserRestrictionBuilder(this, item);
    }
    UserRestrictionContentNestedImpl() {
      this.builder = new UserRestrictionBuilder(this);
    }
    UserRestrictionBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endUserRestrictionContent() {
      return and();
    }
    
  }
  class PodTemplateSpecContentNestedImpl<N> extends PodTemplateSpecFluentImpl<LocalSubjectAccessReviewFluent.PodTemplateSpecContentNested<N>> implements LocalSubjectAccessReviewFluent.PodTemplateSpecContentNested<N>,Nested<N>{
    PodTemplateSpecContentNestedImpl(PodTemplateSpec item) {
      this.builder = new PodTemplateSpecBuilder(this, item);
    }
    PodTemplateSpecContentNestedImpl() {
      this.builder = new PodTemplateSpecBuilder(this);
    }
    PodTemplateSpecBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endPodTemplateSpecContent() {
      return and();
    }
    
  }
  class TemplateInstanceListContentNestedImpl<N> extends TemplateInstanceListFluentImpl<LocalSubjectAccessReviewFluent.TemplateInstanceListContentNested<N>> implements LocalSubjectAccessReviewFluent.TemplateInstanceListContentNested<N>,Nested<N>{
    TemplateInstanceListContentNestedImpl(TemplateInstanceList item) {
      this.builder = new TemplateInstanceListBuilder(this, item);
    }
    TemplateInstanceListContentNestedImpl() {
      this.builder = new TemplateInstanceListBuilder(this);
    }
    TemplateInstanceListBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endTemplateInstanceListContent() {
      return and();
    }
    
  }
  class ImageStreamImportContentNestedImpl<N> extends ImageStreamImportFluentImpl<LocalSubjectAccessReviewFluent.ImageStreamImportContentNested<N>> implements LocalSubjectAccessReviewFluent.ImageStreamImportContentNested<N>,Nested<N>{
    ImageStreamImportContentNestedImpl(ImageStreamImport item) {
      this.builder = new ImageStreamImportBuilder(this, item);
    }
    ImageStreamImportContentNestedImpl() {
      this.builder = new ImageStreamImportBuilder(this);
    }
    ImageStreamImportBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endImageStreamImportContent() {
      return and();
    }
    
  }
  class ResourceRequirementsContentNestedImpl<N> extends ResourceRequirementsFluentImpl<LocalSubjectAccessReviewFluent.ResourceRequirementsContentNested<N>> implements LocalSubjectAccessReviewFluent.ResourceRequirementsContentNested<N>,Nested<N>{
    ResourceRequirementsContentNestedImpl(ResourceRequirements item) {
      this.builder = new ResourceRequirementsBuilder(this, item);
    }
    ResourceRequirementsContentNestedImpl() {
      this.builder = new ResourceRequirementsBuilder(this);
    }
    ResourceRequirementsBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endResourceRequirementsContent() {
      return and();
    }
    
  }
  class GitHubWebHookCauseContentNestedImpl<N> extends GitHubWebHookCauseFluentImpl<LocalSubjectAccessReviewFluent.GitHubWebHookCauseContentNested<N>> implements LocalSubjectAccessReviewFluent.GitHubWebHookCauseContentNested<N>,Nested<N>{
    GitHubWebHookCauseContentNestedImpl(GitHubWebHookCause item) {
      this.builder = new GitHubWebHookCauseBuilder(this, item);
    }
    GitHubWebHookCauseContentNestedImpl() {
      this.builder = new GitHubWebHookCauseBuilder(this);
    }
    GitHubWebHookCauseBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endGitHubWebHookCauseContent() {
      return and();
    }
    
  }
  class OAuthClientListContentNestedImpl<N> extends OAuthClientListFluentImpl<LocalSubjectAccessReviewFluent.OAuthClientListContentNested<N>> implements LocalSubjectAccessReviewFluent.OAuthClientListContentNested<N>,Nested<N>{
    OAuthClientListContentNestedImpl(OAuthClientList item) {
      this.builder = new OAuthClientListBuilder(this, item);
    }
    OAuthClientListContentNestedImpl() {
      this.builder = new OAuthClientListBuilder(this);
    }
    OAuthClientListBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endOAuthClientListContent() {
      return and();
    }
    
  }
  class PodSecurityPolicyReviewStatusContentNestedImpl<N> extends PodSecurityPolicyReviewStatusFluentImpl<LocalSubjectAccessReviewFluent.PodSecurityPolicyReviewStatusContentNested<N>> implements LocalSubjectAccessReviewFluent.PodSecurityPolicyReviewStatusContentNested<N>,Nested<N>{
    PodSecurityPolicyReviewStatusContentNestedImpl(PodSecurityPolicyReviewStatus item) {
      this.builder = new PodSecurityPolicyReviewStatusBuilder(this, item);
    }
    PodSecurityPolicyReviewStatusContentNestedImpl() {
      this.builder = new PodSecurityPolicyReviewStatusBuilder(this);
    }
    PodSecurityPolicyReviewStatusBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endPodSecurityPolicyReviewStatusContent() {
      return and();
    }
    
  }
  class TemplateInstanceStatusContentNestedImpl<N> extends TemplateInstanceStatusFluentImpl<LocalSubjectAccessReviewFluent.TemplateInstanceStatusContentNested<N>> implements LocalSubjectAccessReviewFluent.TemplateInstanceStatusContentNested<N>,Nested<N>{
    TemplateInstanceStatusContentNestedImpl(TemplateInstanceStatus item) {
      this.builder = new TemplateInstanceStatusBuilder(this, item);
    }
    TemplateInstanceStatusContentNestedImpl() {
      this.builder = new TemplateInstanceStatusBuilder(this);
    }
    TemplateInstanceStatusBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endTemplateInstanceStatusContent() {
      return and();
    }
    
  }
  class HelmChartRepositoryListContentNestedImpl<N> extends HelmChartRepositoryListFluentImpl<LocalSubjectAccessReviewFluent.HelmChartRepositoryListContentNested<N>> implements LocalSubjectAccessReviewFluent.HelmChartRepositoryListContentNested<N>,Nested<N>{
    HelmChartRepositoryListContentNestedImpl(HelmChartRepositoryList item) {
      this.builder = new HelmChartRepositoryListBuilder(this, item);
    }
    HelmChartRepositoryListContentNestedImpl() {
      this.builder = new HelmChartRepositoryListBuilder(this);
    }
    HelmChartRepositoryListBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endHelmChartRepositoryListContent() {
      return and();
    }
    
  }
  class PolicyRuleContentNestedImpl<N> extends PolicyRuleFluentImpl<LocalSubjectAccessReviewFluent.PolicyRuleContentNested<N>> implements LocalSubjectAccessReviewFluent.PolicyRuleContentNested<N>,Nested<N>{
    PolicyRuleContentNestedImpl(PolicyRule item) {
      this.builder = new PolicyRuleBuilder(this, item);
    }
    PolicyRuleContentNestedImpl() {
      this.builder = new PolicyRuleBuilder(this);
    }
    PolicyRuleBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endPolicyRuleContent() {
      return and();
    }
    
  }
  class DeploymentTriggerPolicyContentNestedImpl<N> extends DeploymentTriggerPolicyFluentImpl<LocalSubjectAccessReviewFluent.DeploymentTriggerPolicyContentNested<N>> implements LocalSubjectAccessReviewFluent.DeploymentTriggerPolicyContentNested<N>,Nested<N>{
    DeploymentTriggerPolicyContentNestedImpl(DeploymentTriggerPolicy item) {
      this.builder = new DeploymentTriggerPolicyBuilder(this, item);
    }
    DeploymentTriggerPolicyContentNestedImpl() {
      this.builder = new DeploymentTriggerPolicyBuilder(this);
    }
    DeploymentTriggerPolicyBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endDeploymentTriggerPolicyContent() {
      return and();
    }
    
  }
  class BuildStrategyContentNestedImpl<N> extends BuildStrategyFluentImpl<LocalSubjectAccessReviewFluent.BuildStrategyContentNested<N>> implements LocalSubjectAccessReviewFluent.BuildStrategyContentNested<N>,Nested<N>{
    BuildStrategyContentNestedImpl(BuildStrategy item) {
      this.builder = new BuildStrategyBuilder(this, item);
    }
    BuildStrategyContentNestedImpl() {
      this.builder = new BuildStrategyBuilder(this);
    }
    BuildStrategyBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endBuildStrategyContent() {
      return and();
    }
    
  }
  class RepositoryImportSpecContentNestedImpl<N> extends RepositoryImportSpecFluentImpl<LocalSubjectAccessReviewFluent.RepositoryImportSpecContentNested<N>> implements LocalSubjectAccessReviewFluent.RepositoryImportSpecContentNested<N>,Nested<N>{
    RepositoryImportSpecContentNestedImpl(RepositoryImportSpec item) {
      this.builder = new RepositoryImportSpecBuilder(this, item);
    }
    RepositoryImportSpecContentNestedImpl() {
      this.builder = new RepositoryImportSpecBuilder(this);
    }
    RepositoryImportSpecBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endRepositoryImportSpecContent() {
      return and();
    }
    
  }
  class BrokerTemplateInstanceListContentNestedImpl<N> extends BrokerTemplateInstanceListFluentImpl<LocalSubjectAccessReviewFluent.BrokerTemplateInstanceListContentNested<N>> implements LocalSubjectAccessReviewFluent.BrokerTemplateInstanceListContentNested<N>,Nested<N>{
    BrokerTemplateInstanceListContentNestedImpl(BrokerTemplateInstanceList item) {
      this.builder = new BrokerTemplateInstanceListBuilder(this, item);
    }
    BrokerTemplateInstanceListContentNestedImpl() {
      this.builder = new BrokerTemplateInstanceListBuilder(this);
    }
    BrokerTemplateInstanceListBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endBrokerTemplateInstanceListContent() {
      return and();
    }
    
  }
  class ImageStreamImportStatusContentNestedImpl<N> extends ImageStreamImportStatusFluentImpl<LocalSubjectAccessReviewFluent.ImageStreamImportStatusContentNested<N>> implements LocalSubjectAccessReviewFluent.ImageStreamImportStatusContentNested<N>,Nested<N>{
    ImageStreamImportStatusContentNestedImpl(ImageStreamImportStatus item) {
      this.builder = new ImageStreamImportStatusBuilder(this, item);
    }
    ImageStreamImportStatusContentNestedImpl() {
      this.builder = new ImageStreamImportStatusBuilder(this);
    }
    ImageStreamImportStatusBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endImageStreamImportStatusContent() {
      return and();
    }
    
  }
  class CustomBuildStrategyContentNestedImpl<N> extends CustomBuildStrategyFluentImpl<LocalSubjectAccessReviewFluent.CustomBuildStrategyContentNested<N>> implements LocalSubjectAccessReviewFluent.CustomBuildStrategyContentNested<N>,Nested<N>{
    CustomBuildStrategyContentNestedImpl(CustomBuildStrategy item) {
      this.builder = new CustomBuildStrategyBuilder(this, item);
    }
    CustomBuildStrategyContentNestedImpl() {
      this.builder = new CustomBuildStrategyBuilder(this);
    }
    CustomBuildStrategyBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endCustomBuildStrategyContent() {
      return and();
    }
    
  }
  class ClusterResourceQuotaSelectorContentNestedImpl<N> extends ClusterResourceQuotaSelectorFluentImpl<LocalSubjectAccessReviewFluent.ClusterResourceQuotaSelectorContentNested<N>> implements LocalSubjectAccessReviewFluent.ClusterResourceQuotaSelectorContentNested<N>,Nested<N>{
    ClusterResourceQuotaSelectorContentNestedImpl(ClusterResourceQuotaSelector item) {
      this.builder = new ClusterResourceQuotaSelectorBuilder(this, item);
    }
    ClusterResourceQuotaSelectorContentNestedImpl() {
      this.builder = new ClusterResourceQuotaSelectorBuilder(this);
    }
    ClusterResourceQuotaSelectorBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endClusterResourceQuotaSelectorContent() {
      return and();
    }
    
  }
  class SubjectAccessReviewResponseContentNestedImpl<N> extends SubjectAccessReviewResponseFluentImpl<LocalSubjectAccessReviewFluent.SubjectAccessReviewResponseContentNested<N>> implements LocalSubjectAccessReviewFluent.SubjectAccessReviewResponseContentNested<N>,Nested<N>{
    SubjectAccessReviewResponseContentNestedImpl(SubjectAccessReviewResponse item) {
      this.builder = new SubjectAccessReviewResponseBuilder(this, item);
    }
    SubjectAccessReviewResponseContentNestedImpl() {
      this.builder = new SubjectAccessReviewResponseBuilder(this);
    }
    SubjectAccessReviewResponseBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endSubjectAccessReviewResponseContent() {
      return and();
    }
    
  }
  class DeploymentTriggerImageChangeParamsContentNestedImpl<N> extends DeploymentTriggerImageChangeParamsFluentImpl<LocalSubjectAccessReviewFluent.DeploymentTriggerImageChangeParamsContentNested<N>> implements LocalSubjectAccessReviewFluent.DeploymentTriggerImageChangeParamsContentNested<N>,Nested<N>{
    DeploymentTriggerImageChangeParamsContentNestedImpl(DeploymentTriggerImageChangeParams item) {
      this.builder = new DeploymentTriggerImageChangeParamsBuilder(this, item);
    }
    DeploymentTriggerImageChangeParamsContentNestedImpl() {
      this.builder = new DeploymentTriggerImageChangeParamsBuilder(this);
    }
    DeploymentTriggerImageChangeParamsBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endDeploymentTriggerImageChangeParamsContent() {
      return and();
    }
    
  }
  class LocalObjectReferenceContentNestedImpl<N> extends LocalObjectReferenceFluentImpl<LocalSubjectAccessReviewFluent.LocalObjectReferenceContentNested<N>> implements LocalSubjectAccessReviewFluent.LocalObjectReferenceContentNested<N>,Nested<N>{
    LocalObjectReferenceContentNestedImpl(LocalObjectReference item) {
      this.builder = new LocalObjectReferenceBuilder(this, item);
    }
    LocalObjectReferenceContentNestedImpl() {
      this.builder = new LocalObjectReferenceBuilder(this);
    }
    LocalObjectReferenceBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endLocalObjectReferenceContent() {
      return and();
    }
    
  }
  class TagImageHookContentNestedImpl<N> extends TagImageHookFluentImpl<LocalSubjectAccessReviewFluent.TagImageHookContentNested<N>> implements LocalSubjectAccessReviewFluent.TagImageHookContentNested<N>,Nested<N>{
    TagImageHookContentNestedImpl(TagImageHook item) {
      this.builder = new TagImageHookBuilder(this, item);
    }
    TagImageHookContentNestedImpl() {
      this.builder = new TagImageHookBuilder(this);
    }
    TagImageHookBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endTagImageHookContent() {
      return and();
    }
    
  }
  class RouteTargetReferenceContentNestedImpl<N> extends RouteTargetReferenceFluentImpl<LocalSubjectAccessReviewFluent.RouteTargetReferenceContentNested<N>> implements LocalSubjectAccessReviewFluent.RouteTargetReferenceContentNested<N>,Nested<N>{
    RouteTargetReferenceContentNestedImpl(RouteTargetReference item) {
      this.builder = new RouteTargetReferenceBuilder(this, item);
    }
    RouteTargetReferenceContentNestedImpl() {
      this.builder = new RouteTargetReferenceBuilder(this);
    }
    RouteTargetReferenceBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endRouteTargetReferenceContent() {
      return and();
    }
    
  }
  class RawExtensionContentNestedImpl<N> extends RawExtensionFluentImpl<LocalSubjectAccessReviewFluent.RawExtensionContentNested<N>> implements LocalSubjectAccessReviewFluent.RawExtensionContentNested<N>,Nested<N>{
    RawExtensionContentNestedImpl(RawExtension item) {
      this.builder = new RawExtensionBuilder(this, item);
    }
    RawExtensionContentNestedImpl() {
      this.builder = new RawExtensionBuilder(this);
    }
    RawExtensionBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endRawExtensionContent() {
      return and();
    }
    
  }
  class SubjectRulesReviewSpecContentNestedImpl<N> extends SubjectRulesReviewSpecFluentImpl<LocalSubjectAccessReviewFluent.SubjectRulesReviewSpecContentNested<N>> implements LocalSubjectAccessReviewFluent.SubjectRulesReviewSpecContentNested<N>,Nested<N>{
    SubjectRulesReviewSpecContentNestedImpl(SubjectRulesReviewSpec item) {
      this.builder = new SubjectRulesReviewSpecBuilder(this, item);
    }
    SubjectRulesReviewSpecContentNestedImpl() {
      this.builder = new SubjectRulesReviewSpecBuilder(this);
    }
    SubjectRulesReviewSpecBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endSubjectRulesReviewSpecContent() {
      return and();
    }
    
  }
  class TagReferencePolicyContentNestedImpl<N> extends TagReferencePolicyFluentImpl<LocalSubjectAccessReviewFluent.TagReferencePolicyContentNested<N>> implements LocalSubjectAccessReviewFluent.TagReferencePolicyContentNested<N>,Nested<N>{
    TagReferencePolicyContentNestedImpl(TagReferencePolicy item) {
      this.builder = new TagReferencePolicyBuilder(this, item);
    }
    TagReferencePolicyContentNestedImpl() {
      this.builder = new TagReferencePolicyBuilder(this);
    }
    TagReferencePolicyBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endTagReferencePolicyContent() {
      return and();
    }
    
  }
  class RoleListContentNestedImpl<N> extends RoleListFluentImpl<LocalSubjectAccessReviewFluent.RoleListContentNested<N>> implements LocalSubjectAccessReviewFluent.RoleListContentNested<N>,Nested<N>{
    RoleListContentNestedImpl(RoleList item) {
      this.builder = new RoleListBuilder(this, item);
    }
    RoleListContentNestedImpl() {
      this.builder = new RoleListBuilder(this);
    }
    RoleListBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endRoleListContent() {
      return and();
    }
    
  }
  class ProjectContentNestedImpl<N> extends ProjectFluentImpl<LocalSubjectAccessReviewFluent.ProjectContentNested<N>> implements LocalSubjectAccessReviewFluent.ProjectContentNested<N>,Nested<N>{
    ProjectContentNestedImpl(Project item) {
      this.builder = new ProjectBuilder(this, item);
    }
    ProjectContentNestedImpl() {
      this.builder = new ProjectBuilder(this);
    }
    ProjectBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endProjectContent() {
      return and();
    }
    
  }
  class BuildVolumeSourceContentNestedImpl<N> extends BuildVolumeSourceFluentImpl<LocalSubjectAccessReviewFluent.BuildVolumeSourceContentNested<N>> implements LocalSubjectAccessReviewFluent.BuildVolumeSourceContentNested<N>,Nested<N>{
    BuildVolumeSourceContentNestedImpl(BuildVolumeSource item) {
      this.builder = new BuildVolumeSourceBuilder(this, item);
    }
    BuildVolumeSourceContentNestedImpl() {
      this.builder = new BuildVolumeSourceBuilder(this);
    }
    BuildVolumeSourceBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endBuildVolumeSourceContent() {
      return and();
    }
    
  }
  class AppliedClusterResourceQuotaListContentNestedImpl<N> extends AppliedClusterResourceQuotaListFluentImpl<LocalSubjectAccessReviewFluent.AppliedClusterResourceQuotaListContentNested<N>> implements LocalSubjectAccessReviewFluent.AppliedClusterResourceQuotaListContentNested<N>,Nested<N>{
    AppliedClusterResourceQuotaListContentNestedImpl(AppliedClusterResourceQuotaList item) {
      this.builder = new AppliedClusterResourceQuotaListBuilder(this, item);
    }
    AppliedClusterResourceQuotaListContentNestedImpl() {
      this.builder = new AppliedClusterResourceQuotaListBuilder(this);
    }
    AppliedClusterResourceQuotaListBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endAppliedClusterResourceQuotaListContent() {
      return and();
    }
    
  }
  class DeploymentConfigListContentNestedImpl<N> extends DeploymentConfigListFluentImpl<LocalSubjectAccessReviewFluent.DeploymentConfigListContentNested<N>> implements LocalSubjectAccessReviewFluent.DeploymentConfigListContentNested<N>,Nested<N>{
    DeploymentConfigListContentNestedImpl(DeploymentConfigList item) {
      this.builder = new DeploymentConfigListBuilder(this, item);
    }
    DeploymentConfigListContentNestedImpl() {
      this.builder = new DeploymentConfigListBuilder(this);
    }
    DeploymentConfigListBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endDeploymentConfigListContent() {
      return and();
    }
    
  }
  class BuildStatusOutputContentNestedImpl<N> extends BuildStatusOutputFluentImpl<LocalSubjectAccessReviewFluent.BuildStatusOutputContentNested<N>> implements LocalSubjectAccessReviewFluent.BuildStatusOutputContentNested<N>,Nested<N>{
    BuildStatusOutputContentNestedImpl(BuildStatusOutput item) {
      this.builder = new BuildStatusOutputBuilder(this, item);
    }
    BuildStatusOutputContentNestedImpl() {
      this.builder = new BuildStatusOutputBuilder(this);
    }
    BuildStatusOutputBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endBuildStatusOutputContent() {
      return and();
    }
    
  }
  class BuildConfigContentNestedImpl<N> extends BuildConfigFluentImpl<LocalSubjectAccessReviewFluent.BuildConfigContentNested<N>> implements LocalSubjectAccessReviewFluent.BuildConfigContentNested<N>,Nested<N>{
    BuildConfigContentNestedImpl(BuildConfig item) {
      this.builder = new BuildConfigBuilder(this, item);
    }
    BuildConfigContentNestedImpl() {
      this.builder = new BuildConfigBuilder(this);
    }
    BuildConfigBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endBuildConfigContent() {
      return and();
    }
    
  }
  class ImageImportStatusContentNestedImpl<N> extends ImageImportStatusFluentImpl<LocalSubjectAccessReviewFluent.ImageImportStatusContentNested<N>> implements LocalSubjectAccessReviewFluent.ImageImportStatusContentNested<N>,Nested<N>{
    ImageImportStatusContentNestedImpl(ImageImportStatus item) {
      this.builder = new ImageImportStatusBuilder(this, item);
    }
    ImageImportStatusContentNestedImpl() {
      this.builder = new ImageImportStatusBuilder(this);
    }
    ImageImportStatusBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endImageImportStatusContent() {
      return and();
    }
    
  }
  class PodSecurityPolicySubjectReviewContentNestedImpl<N> extends PodSecurityPolicySubjectReviewFluentImpl<LocalSubjectAccessReviewFluent.PodSecurityPolicySubjectReviewContentNested<N>> implements LocalSubjectAccessReviewFluent.PodSecurityPolicySubjectReviewContentNested<N>,Nested<N>{
    PodSecurityPolicySubjectReviewContentNestedImpl(PodSecurityPolicySubjectReview item) {
      this.builder = new PodSecurityPolicySubjectReviewBuilder(this, item);
    }
    PodSecurityPolicySubjectReviewContentNestedImpl() {
      this.builder = new PodSecurityPolicySubjectReviewBuilder(this);
    }
    PodSecurityPolicySubjectReviewBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endPodSecurityPolicySubjectReviewContent() {
      return and();
    }
    
  }
  class GitLabWebHookCauseContentNestedImpl<N> extends GitLabWebHookCauseFluentImpl<LocalSubjectAccessReviewFluent.GitLabWebHookCauseContentNested<N>> implements LocalSubjectAccessReviewFluent.GitLabWebHookCauseContentNested<N>,Nested<N>{
    GitLabWebHookCauseContentNestedImpl(GitLabWebHookCause item) {
      this.builder = new GitLabWebHookCauseBuilder(this, item);
    }
    GitLabWebHookCauseContentNestedImpl() {
      this.builder = new GitLabWebHookCauseBuilder(this);
    }
    GitLabWebHookCauseBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endGitLabWebHookCauseContent() {
      return and();
    }
    
  }
  class DeploymentConfigStatusContentNestedImpl<N> extends DeploymentConfigStatusFluentImpl<LocalSubjectAccessReviewFluent.DeploymentConfigStatusContentNested<N>> implements LocalSubjectAccessReviewFluent.DeploymentConfigStatusContentNested<N>,Nested<N>{
    DeploymentConfigStatusContentNestedImpl(DeploymentConfigStatus item) {
      this.builder = new DeploymentConfigStatusBuilder(this, item);
    }
    DeploymentConfigStatusContentNestedImpl() {
      this.builder = new DeploymentConfigStatusBuilder(this);
    }
    DeploymentConfigStatusBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endDeploymentConfigStatusContent() {
      return and();
    }
    
  }
  class SecretBuildSourceContentNestedImpl<N> extends SecretBuildSourceFluentImpl<LocalSubjectAccessReviewFluent.SecretBuildSourceContentNested<N>> implements LocalSubjectAccessReviewFluent.SecretBuildSourceContentNested<N>,Nested<N>{
    SecretBuildSourceContentNestedImpl(SecretBuildSource item) {
      this.builder = new SecretBuildSourceBuilder(this, item);
    }
    SecretBuildSourceContentNestedImpl() {
      this.builder = new SecretBuildSourceBuilder(this);
    }
    SecretBuildSourceBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endSecretBuildSourceContent() {
      return and();
    }
    
  }
  class EgressNetworkPolicySpecContentNestedImpl<N> extends EgressNetworkPolicySpecFluentImpl<LocalSubjectAccessReviewFluent.EgressNetworkPolicySpecContentNested<N>> implements LocalSubjectAccessReviewFluent.EgressNetworkPolicySpecContentNested<N>,Nested<N>{
    EgressNetworkPolicySpecContentNestedImpl(EgressNetworkPolicySpec item) {
      this.builder = new EgressNetworkPolicySpecBuilder(this, item);
    }
    EgressNetworkPolicySpecContentNestedImpl() {
      this.builder = new EgressNetworkPolicySpecBuilder(this);
    }
    EgressNetworkPolicySpecBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endEgressNetworkPolicySpecContent() {
      return and();
    }
    
  }
  class HelmChartRepositoryContentNestedImpl<N> extends HelmChartRepositoryFluentImpl<LocalSubjectAccessReviewFluent.HelmChartRepositoryContentNested<N>> implements LocalSubjectAccessReviewFluent.HelmChartRepositoryContentNested<N>,Nested<N>{
    HelmChartRepositoryContentNestedImpl(HelmChartRepository item) {
      this.builder = new HelmChartRepositoryBuilder(this, item);
    }
    HelmChartRepositoryContentNestedImpl() {
      this.builder = new HelmChartRepositoryBuilder(this);
    }
    HelmChartRepositoryBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endHelmChartRepositoryContent() {
      return and();
    }
    
  }
  class TagEventContentNestedImpl<N> extends TagEventFluentImpl<LocalSubjectAccessReviewFluent.TagEventContentNested<N>> implements LocalSubjectAccessReviewFluent.TagEventContentNested<N>,Nested<N>{
    TagEventContentNestedImpl(TagEvent item) {
      this.builder = new TagEventBuilder(this, item);
    }
    TagEventContentNestedImpl() {
      this.builder = new TagEventBuilder(this);
    }
    TagEventBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endTagEventContent() {
      return and();
    }
    
  }
  class ImageStreamTagListContentNestedImpl<N> extends ImageStreamTagListFluentImpl<LocalSubjectAccessReviewFluent.ImageStreamTagListContentNested<N>> implements LocalSubjectAccessReviewFluent.ImageStreamTagListContentNested<N>,Nested<N>{
    ImageStreamTagListContentNestedImpl(ImageStreamTagList item) {
      this.builder = new ImageStreamTagListBuilder(this, item);
    }
    ImageStreamTagListContentNestedImpl() {
      this.builder = new ImageStreamTagListBuilder(this);
    }
    ImageStreamTagListBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endImageStreamTagListContent() {
      return and();
    }
    
  }
  class BitbucketWebHookCauseContentNestedImpl<N> extends BitbucketWebHookCauseFluentImpl<LocalSubjectAccessReviewFluent.BitbucketWebHookCauseContentNested<N>> implements LocalSubjectAccessReviewFluent.BitbucketWebHookCauseContentNested<N>,Nested<N>{
    BitbucketWebHookCauseContentNestedImpl(BitbucketWebHookCause item) {
      this.builder = new BitbucketWebHookCauseBuilder(this, item);
    }
    BitbucketWebHookCauseContentNestedImpl() {
      this.builder = new BitbucketWebHookCauseBuilder(this);
    }
    BitbucketWebHookCauseBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endBitbucketWebHookCauseContent() {
      return and();
    }
    
  }
  class ProjectListContentNestedImpl<N> extends ProjectListFluentImpl<LocalSubjectAccessReviewFluent.ProjectListContentNested<N>> implements LocalSubjectAccessReviewFluent.ProjectListContentNested<N>,Nested<N>{
    ProjectListContentNestedImpl(ProjectList item) {
      this.builder = new ProjectListBuilder(this, item);
    }
    ProjectListContentNestedImpl() {
      this.builder = new ProjectListBuilder(this);
    }
    ProjectListBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endProjectListContent() {
      return and();
    }
    
  }
  class RangeAllocationContentNestedImpl<N> extends RangeAllocationFluentImpl<LocalSubjectAccessReviewFluent.RangeAllocationContentNested<N>> implements LocalSubjectAccessReviewFluent.RangeAllocationContentNested<N>,Nested<N>{
    RangeAllocationContentNestedImpl(RangeAllocation item) {
      this.builder = new RangeAllocationBuilder(this, item);
    }
    RangeAllocationContentNestedImpl() {
      this.builder = new RangeAllocationBuilder(this);
    }
    RangeAllocationBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endRangeAllocationContent() {
      return and();
    }
    
  }
  class ClusterRoleScopeRestrictionContentNestedImpl<N> extends ClusterRoleScopeRestrictionFluentImpl<LocalSubjectAccessReviewFluent.ClusterRoleScopeRestrictionContentNested<N>> implements LocalSubjectAccessReviewFluent.ClusterRoleScopeRestrictionContentNested<N>,Nested<N>{
    ClusterRoleScopeRestrictionContentNestedImpl(ClusterRoleScopeRestriction item) {
      this.builder = new ClusterRoleScopeRestrictionBuilder(this, item);
    }
    ClusterRoleScopeRestrictionContentNestedImpl() {
      this.builder = new ClusterRoleScopeRestrictionBuilder(this);
    }
    ClusterRoleScopeRestrictionBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endClusterRoleScopeRestrictionContent() {
      return and();
    }
    
  }
  class RouteContentNestedImpl<N> extends RouteFluentImpl<LocalSubjectAccessReviewFluent.RouteContentNested<N>> implements LocalSubjectAccessReviewFluent.RouteContentNested<N>,Nested<N>{
    RouteContentNestedImpl(Route item) {
      this.builder = new RouteBuilder(this, item);
    }
    RouteContentNestedImpl() {
      this.builder = new RouteBuilder(this);
    }
    RouteBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endRouteContent() {
      return and();
    }
    
  }
  class SourceStrategyOptionsContentNestedImpl<N> extends SourceStrategyOptionsFluentImpl<LocalSubjectAccessReviewFluent.SourceStrategyOptionsContentNested<N>> implements LocalSubjectAccessReviewFluent.SourceStrategyOptionsContentNested<N>,Nested<N>{
    SourceStrategyOptionsContentNestedImpl(SourceStrategyOptions item) {
      this.builder = new SourceStrategyOptionsBuilder(this, item);
    }
    SourceStrategyOptionsContentNestedImpl() {
      this.builder = new SourceStrategyOptionsBuilder(this);
    }
    SourceStrategyOptionsBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endSourceStrategyOptionsContent() {
      return and();
    }
    
  }
  class ClusterNetworkContentNestedImpl<N> extends ClusterNetworkFluentImpl<LocalSubjectAccessReviewFluent.ClusterNetworkContentNested<N>> implements LocalSubjectAccessReviewFluent.ClusterNetworkContentNested<N>,Nested<N>{
    ClusterNetworkContentNestedImpl(ClusterNetwork item) {
      this.builder = new ClusterNetworkBuilder(this, item);
    }
    ClusterNetworkContentNestedImpl() {
      this.builder = new ClusterNetworkBuilder(this);
    }
    ClusterNetworkBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endClusterNetworkContent() {
      return and();
    }
    
  }
  class OAuthAuthorizeTokenContentNestedImpl<N> extends OAuthAuthorizeTokenFluentImpl<LocalSubjectAccessReviewFluent.OAuthAuthorizeTokenContentNested<N>> implements LocalSubjectAccessReviewFluent.OAuthAuthorizeTokenContentNested<N>,Nested<N>{
    OAuthAuthorizeTokenContentNestedImpl(OAuthAuthorizeToken item) {
      this.builder = new OAuthAuthorizeTokenBuilder(this, item);
    }
    OAuthAuthorizeTokenContentNestedImpl() {
      this.builder = new OAuthAuthorizeTokenBuilder(this);
    }
    OAuthAuthorizeTokenBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endOAuthAuthorizeTokenContent() {
      return and();
    }
    
  }
  class DockerBuildStrategyContentNestedImpl<N> extends DockerBuildStrategyFluentImpl<LocalSubjectAccessReviewFluent.DockerBuildStrategyContentNested<N>> implements LocalSubjectAccessReviewFluent.DockerBuildStrategyContentNested<N>,Nested<N>{
    DockerBuildStrategyContentNestedImpl(DockerBuildStrategy item) {
      this.builder = new DockerBuildStrategyBuilder(this, item);
    }
    DockerBuildStrategyContentNestedImpl() {
      this.builder = new DockerBuildStrategyBuilder(this);
    }
    DockerBuildStrategyBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endDockerBuildStrategyContent() {
      return and();
    }
    
  }
  class SignatureConditionContentNestedImpl<N> extends SignatureConditionFluentImpl<LocalSubjectAccessReviewFluent.SignatureConditionContentNested<N>> implements LocalSubjectAccessReviewFluent.SignatureConditionContentNested<N>,Nested<N>{
    SignatureConditionContentNestedImpl(SignatureCondition item) {
      this.builder = new SignatureConditionBuilder(this, item);
    }
    SignatureConditionContentNestedImpl() {
      this.builder = new SignatureConditionBuilder(this);
    }
    SignatureConditionBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endSignatureConditionContent() {
      return and();
    }
    
  }
  class UserOAuthAccessTokenContentNestedImpl<N> extends UserOAuthAccessTokenFluentImpl<LocalSubjectAccessReviewFluent.UserOAuthAccessTokenContentNested<N>> implements LocalSubjectAccessReviewFluent.UserOAuthAccessTokenContentNested<N>,Nested<N>{
    UserOAuthAccessTokenContentNestedImpl(UserOAuthAccessToken item) {
      this.builder = new UserOAuthAccessTokenBuilder(this, item);
    }
    UserOAuthAccessTokenContentNestedImpl() {
      this.builder = new UserOAuthAccessTokenBuilder(this);
    }
    UserOAuthAccessTokenBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endUserOAuthAccessTokenContent() {
      return and();
    }
    
  }
  class RoleBindingRestrictionListContentNestedImpl<N> extends RoleBindingRestrictionListFluentImpl<LocalSubjectAccessReviewFluent.RoleBindingRestrictionListContentNested<N>> implements LocalSubjectAccessReviewFluent.RoleBindingRestrictionListContentNested<N>,Nested<N>{
    RoleBindingRestrictionListContentNestedImpl(RoleBindingRestrictionList item) {
      this.builder = new RoleBindingRestrictionListBuilder(this, item);
    }
    RoleBindingRestrictionListContentNestedImpl() {
      this.builder = new RoleBindingRestrictionListBuilder(this);
    }
    RoleBindingRestrictionListBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endRoleBindingRestrictionListContent() {
      return and();
    }
    
  }
  class SecurityContextConstraintsListContentNestedImpl<N> extends SecurityContextConstraintsListFluentImpl<LocalSubjectAccessReviewFluent.SecurityContextConstraintsListContentNested<N>> implements LocalSubjectAccessReviewFluent.SecurityContextConstraintsListContentNested<N>,Nested<N>{
    SecurityContextConstraintsListContentNestedImpl(SecurityContextConstraintsList item) {
      this.builder = new SecurityContextConstraintsListBuilder(this, item);
    }
    SecurityContextConstraintsListContentNestedImpl() {
      this.builder = new SecurityContextConstraintsListBuilder(this);
    }
    SecurityContextConstraintsListBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endSecurityContextConstraintsListContent() {
      return and();
    }
    
  }
  class IdentityListContentNestedImpl<N> extends IdentityListFluentImpl<LocalSubjectAccessReviewFluent.IdentityListContentNested<N>> implements LocalSubjectAccessReviewFluent.IdentityListContentNested<N>,Nested<N>{
    IdentityListContentNestedImpl(IdentityList item) {
      this.builder = new IdentityListBuilder(this, item);
    }
    IdentityListContentNestedImpl() {
      this.builder = new IdentityListBuilder(this);
    }
    IdentityListBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endIdentityListContent() {
      return and();
    }
    
  }
  class BuildConfigListContentNestedImpl<N> extends BuildConfigListFluentImpl<LocalSubjectAccessReviewFluent.BuildConfigListContentNested<N>> implements LocalSubjectAccessReviewFluent.BuildConfigListContentNested<N>,Nested<N>{
    BuildConfigListContentNestedImpl(BuildConfigList item) {
      this.builder = new BuildConfigListBuilder(this, item);
    }
    BuildConfigListContentNestedImpl() {
      this.builder = new BuildConfigListBuilder(this);
    }
    BuildConfigListBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endBuildConfigListContent() {
      return and();
    }
    
  }
  class ClusterNetworkListContentNestedImpl<N> extends ClusterNetworkListFluentImpl<LocalSubjectAccessReviewFluent.ClusterNetworkListContentNested<N>> implements LocalSubjectAccessReviewFluent.ClusterNetworkListContentNested<N>,Nested<N>{
    ClusterNetworkListContentNestedImpl(ClusterNetworkList item) {
      this.builder = new ClusterNetworkListBuilder(this, item);
    }
    ClusterNetworkListContentNestedImpl() {
      this.builder = new ClusterNetworkListBuilder(this);
    }
    ClusterNetworkListBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endClusterNetworkListContent() {
      return and();
    }
    
  }
  class TemplateInstanceConditionContentNestedImpl<N> extends TemplateInstanceConditionFluentImpl<LocalSubjectAccessReviewFluent.TemplateInstanceConditionContentNested<N>> implements LocalSubjectAccessReviewFluent.TemplateInstanceConditionContentNested<N>,Nested<N>{
    TemplateInstanceConditionContentNestedImpl(TemplateInstanceCondition item) {
      this.builder = new TemplateInstanceConditionBuilder(this, item);
    }
    TemplateInstanceConditionContentNestedImpl() {
      this.builder = new TemplateInstanceConditionBuilder(this);
    }
    TemplateInstanceConditionBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endTemplateInstanceConditionContent() {
      return and();
    }
    
  }
  class RepositoryImportStatusContentNestedImpl<N> extends RepositoryImportStatusFluentImpl<LocalSubjectAccessReviewFluent.RepositoryImportStatusContentNested<N>> implements LocalSubjectAccessReviewFluent.RepositoryImportStatusContentNested<N>,Nested<N>{
    RepositoryImportStatusContentNestedImpl(RepositoryImportStatus item) {
      this.builder = new RepositoryImportStatusBuilder(this, item);
    }
    RepositoryImportStatusContentNestedImpl() {
      this.builder = new RepositoryImportStatusBuilder(this);
    }
    RepositoryImportStatusBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endRepositoryImportStatusContent() {
      return and();
    }
    
  }
  class DeploymentCauseContentNestedImpl<N> extends DeploymentCauseFluentImpl<LocalSubjectAccessReviewFluent.DeploymentCauseContentNested<N>> implements LocalSubjectAccessReviewFluent.DeploymentCauseContentNested<N>,Nested<N>{
    DeploymentCauseContentNestedImpl(DeploymentCause item) {
      this.builder = new DeploymentCauseBuilder(this, item);
    }
    DeploymentCauseContentNestedImpl() {
      this.builder = new DeploymentCauseBuilder(this);
    }
    DeploymentCauseBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endDeploymentCauseContent() {
      return and();
    }
    
  }
  class GroupListContentNestedImpl<N> extends GroupListFluentImpl<LocalSubjectAccessReviewFluent.GroupListContentNested<N>> implements LocalSubjectAccessReviewFluent.GroupListContentNested<N>,Nested<N>{
    GroupListContentNestedImpl(GroupList item) {
      this.builder = new GroupListBuilder(this, item);
    }
    GroupListContentNestedImpl() {
      this.builder = new GroupListBuilder(this);
    }
    GroupListBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endGroupListContent() {
      return and();
    }
    
  }
  class RunAsUserStrategyOptionsContentNestedImpl<N> extends RunAsUserStrategyOptionsFluentImpl<LocalSubjectAccessReviewFluent.RunAsUserStrategyOptionsContentNested<N>> implements LocalSubjectAccessReviewFluent.RunAsUserStrategyOptionsContentNested<N>,Nested<N>{
    RunAsUserStrategyOptionsContentNestedImpl(RunAsUserStrategyOptions item) {
      this.builder = new RunAsUserStrategyOptionsBuilder(this, item);
    }
    RunAsUserStrategyOptionsContentNestedImpl() {
      this.builder = new RunAsUserStrategyOptionsBuilder(this);
    }
    RunAsUserStrategyOptionsBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endRunAsUserStrategyOptionsContent() {
      return and();
    }
    
  }
  class LifecycleHookContentNestedImpl<N> extends LifecycleHookFluentImpl<LocalSubjectAccessReviewFluent.LifecycleHookContentNested<N>> implements LocalSubjectAccessReviewFluent.LifecycleHookContentNested<N>,Nested<N>{
    LifecycleHookContentNestedImpl(LifecycleHook item) {
      this.builder = new LifecycleHookBuilder(this, item);
    }
    LifecycleHookContentNestedImpl() {
      this.builder = new LifecycleHookBuilder(this);
    }
    LifecycleHookBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endLifecycleHookContent() {
      return and();
    }
    
  }
  class ImageStreamTagReferenceContentNestedImpl<N> extends ImageStreamTagReferenceFluentImpl<LocalSubjectAccessReviewFluent.ImageStreamTagReferenceContentNested<N>> implements LocalSubjectAccessReviewFluent.ImageStreamTagReferenceContentNested<N>,Nested<N>{
    ImageStreamTagReferenceContentNestedImpl(ImageStreamTagReference item) {
      this.builder = new ImageStreamTagReferenceBuilder(this, item);
    }
    ImageStreamTagReferenceContentNestedImpl() {
      this.builder = new ImageStreamTagReferenceBuilder(this);
    }
    ImageStreamTagReferenceBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endImageStreamTagReferenceContent() {
      return and();
    }
    
  }
  class SourceControlUserContentNestedImpl<N> extends SourceControlUserFluentImpl<LocalSubjectAccessReviewFluent.SourceControlUserContentNested<N>> implements LocalSubjectAccessReviewFluent.SourceControlUserContentNested<N>,Nested<N>{
    SourceControlUserContentNestedImpl(SourceControlUser item) {
      this.builder = new SourceControlUserBuilder(this, item);
    }
    SourceControlUserContentNestedImpl() {
      this.builder = new SourceControlUserBuilder(this);
    }
    SourceControlUserBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endSourceControlUserContent() {
      return and();
    }
    
  }
  class ContainerContentNestedImpl<N> extends ContainerFluentImpl<LocalSubjectAccessReviewFluent.ContainerContentNested<N>> implements LocalSubjectAccessReviewFluent.ContainerContentNested<N>,Nested<N>{
    ContainerContentNestedImpl(Container item) {
      this.builder = new ContainerBuilder(this, item);
    }
    ContainerContentNestedImpl() {
      this.builder = new ContainerBuilder(this);
    }
    ContainerBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endContainerContent() {
      return and();
    }
    
  }
  class ImageStreamListContentNestedImpl<N> extends ImageStreamListFluentImpl<LocalSubjectAccessReviewFluent.ImageStreamListContentNested<N>> implements LocalSubjectAccessReviewFluent.ImageStreamListContentNested<N>,Nested<N>{
    ImageStreamListContentNestedImpl(ImageStreamList item) {
      this.builder = new ImageStreamListBuilder(this, item);
    }
    ImageStreamListContentNestedImpl() {
      this.builder = new ImageStreamListBuilder(this);
    }
    ImageStreamListBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endImageStreamListContent() {
      return and();
    }
    
  }
  class ClusterRoleBindingContentNestedImpl<N> extends ClusterRoleBindingFluentImpl<LocalSubjectAccessReviewFluent.ClusterRoleBindingContentNested<N>> implements LocalSubjectAccessReviewFluent.ClusterRoleBindingContentNested<N>,Nested<N>{
    ClusterRoleBindingContentNestedImpl(ClusterRoleBinding item) {
      this.builder = new ClusterRoleBindingBuilder(this, item);
    }
    ClusterRoleBindingContentNestedImpl() {
      this.builder = new ClusterRoleBindingBuilder(this);
    }
    ClusterRoleBindingBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endClusterRoleBindingContent() {
      return and();
    }
    
  }
  class ResourceAccessReviewContentNestedImpl<N> extends ResourceAccessReviewFluentImpl<LocalSubjectAccessReviewFluent.ResourceAccessReviewContentNested<N>> implements LocalSubjectAccessReviewFluent.ResourceAccessReviewContentNested<N>,Nested<N>{
    ResourceAccessReviewContentNestedImpl(ResourceAccessReview item) {
      this.builder = new ResourceAccessReviewBuilder(this, item);
    }
    ResourceAccessReviewContentNestedImpl() {
      this.builder = new ResourceAccessReviewBuilder(this);
    }
    ResourceAccessReviewBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endResourceAccessReviewContent() {
      return and();
    }
    
  }
  class SelfSubjectRulesReviewContentNestedImpl<N> extends SelfSubjectRulesReviewFluentImpl<LocalSubjectAccessReviewFluent.SelfSubjectRulesReviewContentNested<N>> implements LocalSubjectAccessReviewFluent.SelfSubjectRulesReviewContentNested<N>,Nested<N>{
    SelfSubjectRulesReviewContentNestedImpl(SelfSubjectRulesReview item) {
      this.builder = new SelfSubjectRulesReviewBuilder(this, item);
    }
    SelfSubjectRulesReviewContentNestedImpl() {
      this.builder = new SelfSubjectRulesReviewBuilder(this);
    }
    SelfSubjectRulesReviewBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endSelfSubjectRulesReviewContent() {
      return and();
    }
    
  }
  class UserOAuthAccessTokenListContentNestedImpl<N> extends UserOAuthAccessTokenListFluentImpl<LocalSubjectAccessReviewFluent.UserOAuthAccessTokenListContentNested<N>> implements LocalSubjectAccessReviewFluent.UserOAuthAccessTokenListContentNested<N>,Nested<N>{
    UserOAuthAccessTokenListContentNestedImpl(UserOAuthAccessTokenList item) {
      this.builder = new UserOAuthAccessTokenListBuilder(this, item);
    }
    UserOAuthAccessTokenListContentNestedImpl() {
      this.builder = new UserOAuthAccessTokenListBuilder(this);
    }
    UserOAuthAccessTokenListBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endUserOAuthAccessTokenListContent() {
      return and();
    }
    
  }
  class ImageChangeTriggerStatusContentNestedImpl<N> extends ImageChangeTriggerStatusFluentImpl<LocalSubjectAccessReviewFluent.ImageChangeTriggerStatusContentNested<N>> implements LocalSubjectAccessReviewFluent.ImageChangeTriggerStatusContentNested<N>,Nested<N>{
    ImageChangeTriggerStatusContentNestedImpl(ImageChangeTriggerStatus item) {
      this.builder = new ImageChangeTriggerStatusBuilder(this, item);
    }
    ImageChangeTriggerStatusContentNestedImpl() {
      this.builder = new ImageChangeTriggerStatusBuilder(this);
    }
    ImageChangeTriggerStatusBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endImageChangeTriggerStatusContent() {
      return and();
    }
    
  }
  class RouteStatusContentNestedImpl<N> extends RouteStatusFluentImpl<LocalSubjectAccessReviewFluent.RouteStatusContentNested<N>> implements LocalSubjectAccessReviewFluent.RouteStatusContentNested<N>,Nested<N>{
    RouteStatusContentNestedImpl(RouteStatus item) {
      this.builder = new RouteStatusBuilder(this, item);
    }
    RouteStatusContentNestedImpl() {
      this.builder = new RouteStatusBuilder(this);
    }
    RouteStatusBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endRouteStatusContent() {
      return and();
    }
    
  }
  class ClusterResourceQuotaContentNestedImpl<N> extends ClusterResourceQuotaFluentImpl<LocalSubjectAccessReviewFluent.ClusterResourceQuotaContentNested<N>> implements LocalSubjectAccessReviewFluent.ClusterResourceQuotaContentNested<N>,Nested<N>{
    ClusterResourceQuotaContentNestedImpl(ClusterResourceQuota item) {
      this.builder = new ClusterResourceQuotaBuilder(this, item);
    }
    ClusterResourceQuotaContentNestedImpl() {
      this.builder = new ClusterResourceQuotaBuilder(this);
    }
    ClusterResourceQuotaBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endClusterResourceQuotaContent() {
      return and();
    }
    
  }
  class NamedTagEventListContentNestedImpl<N> extends NamedTagEventListFluentImpl<LocalSubjectAccessReviewFluent.NamedTagEventListContentNested<N>> implements LocalSubjectAccessReviewFluent.NamedTagEventListContentNested<N>,Nested<N>{
    NamedTagEventListContentNestedImpl(NamedTagEventList item) {
      this.builder = new NamedTagEventListBuilder(this, item);
    }
    NamedTagEventListContentNestedImpl() {
      this.builder = new NamedTagEventListBuilder(this);
    }
    NamedTagEventListBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endNamedTagEventListContent() {
      return and();
    }
    
  }
  class ClusterResourceQuotaListContentNestedImpl<N> extends ClusterResourceQuotaListFluentImpl<LocalSubjectAccessReviewFluent.ClusterResourceQuotaListContentNested<N>> implements LocalSubjectAccessReviewFluent.ClusterResourceQuotaListContentNested<N>,Nested<N>{
    ClusterResourceQuotaListContentNestedImpl(ClusterResourceQuotaList item) {
      this.builder = new ClusterResourceQuotaListBuilder(this, item);
    }
    ClusterResourceQuotaListContentNestedImpl() {
      this.builder = new ClusterResourceQuotaListBuilder(this);
    }
    ClusterResourceQuotaListBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endClusterResourceQuotaListContent() {
      return and();
    }
    
  }
  class RouteSpecContentNestedImpl<N> extends RouteSpecFluentImpl<LocalSubjectAccessReviewFluent.RouteSpecContentNested<N>> implements LocalSubjectAccessReviewFluent.RouteSpecContentNested<N>,Nested<N>{
    RouteSpecContentNestedImpl(RouteSpec item) {
      this.builder = new RouteSpecBuilder(this, item);
    }
    RouteSpecContentNestedImpl() {
      this.builder = new RouteSpecBuilder(this);
    }
    RouteSpecBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endRouteSpecContent() {
      return and();
    }
    
  }
  class ProjectRequestContentNestedImpl<N> extends ProjectRequestFluentImpl<LocalSubjectAccessReviewFluent.ProjectRequestContentNested<N>> implements LocalSubjectAccessReviewFluent.ProjectRequestContentNested<N>,Nested<N>{
    ProjectRequestContentNestedImpl(ProjectRequest item) {
      this.builder = new ProjectRequestBuilder(this, item);
    }
    ProjectRequestContentNestedImpl() {
      this.builder = new ProjectRequestBuilder(this);
    }
    ProjectRequestBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endProjectRequestContent() {
      return and();
    }
    
  }
  class TemplateContentNestedImpl<N> extends TemplateFluentImpl<LocalSubjectAccessReviewFluent.TemplateContentNested<N>> implements LocalSubjectAccessReviewFluent.TemplateContentNested<N>,Nested<N>{
    TemplateContentNestedImpl(Template item) {
      this.builder = new TemplateBuilder(this, item);
    }
    TemplateContentNestedImpl() {
      this.builder = new TemplateBuilder(this);
    }
    TemplateBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endTemplateContent() {
      return and();
    }
    
  }
  class ImageLookupPolicyContentNestedImpl<N> extends ImageLookupPolicyFluentImpl<LocalSubjectAccessReviewFluent.ImageLookupPolicyContentNested<N>> implements LocalSubjectAccessReviewFluent.ImageLookupPolicyContentNested<N>,Nested<N>{
    ImageLookupPolicyContentNestedImpl(ImageLookupPolicy item) {
      this.builder = new ImageLookupPolicyBuilder(this, item);
    }
    ImageLookupPolicyContentNestedImpl() {
      this.builder = new ImageLookupPolicyBuilder(this);
    }
    ImageLookupPolicyBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endImageLookupPolicyContent() {
      return and();
    }
    
  }
  class OAuthClientAuthorizationContentNestedImpl<N> extends OAuthClientAuthorizationFluentImpl<LocalSubjectAccessReviewFluent.OAuthClientAuthorizationContentNested<N>> implements LocalSubjectAccessReviewFluent.OAuthClientAuthorizationContentNested<N>,Nested<N>{
    OAuthClientAuthorizationContentNestedImpl(OAuthClientAuthorization item) {
      this.builder = new OAuthClientAuthorizationBuilder(this, item);
    }
    OAuthClientAuthorizationContentNestedImpl() {
      this.builder = new OAuthClientAuthorizationBuilder(this);
    }
    OAuthClientAuthorizationBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endOAuthClientAuthorizationContent() {
      return and();
    }
    
  }
  class ImageChangeCauseContentNestedImpl<N> extends ImageChangeCauseFluentImpl<LocalSubjectAccessReviewFluent.ImageChangeCauseContentNested<N>> implements LocalSubjectAccessReviewFluent.ImageChangeCauseContentNested<N>,Nested<N>{
    ImageChangeCauseContentNestedImpl(ImageChangeCause item) {
      this.builder = new ImageChangeCauseBuilder(this, item);
    }
    ImageChangeCauseContentNestedImpl() {
      this.builder = new ImageChangeCauseBuilder(this);
    }
    ImageChangeCauseBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endImageChangeCauseContent() {
      return and();
    }
    
  }
  class AllowedFlexVolumeContentNestedImpl<N> extends AllowedFlexVolumeFluentImpl<LocalSubjectAccessReviewFluent.AllowedFlexVolumeContentNested<N>> implements LocalSubjectAccessReviewFluent.AllowedFlexVolumeContentNested<N>,Nested<N>{
    AllowedFlexVolumeContentNestedImpl(AllowedFlexVolume item) {
      this.builder = new AllowedFlexVolumeBuilder(this, item);
    }
    AllowedFlexVolumeContentNestedImpl() {
      this.builder = new AllowedFlexVolumeBuilder(this);
    }
    AllowedFlexVolumeBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endAllowedFlexVolumeContent() {
      return and();
    }
    
  }
  class SubjectAccessReviewContentNestedImpl<N> extends SubjectAccessReviewFluentImpl<LocalSubjectAccessReviewFluent.SubjectAccessReviewContentNested<N>> implements LocalSubjectAccessReviewFluent.SubjectAccessReviewContentNested<N>,Nested<N>{
    SubjectAccessReviewContentNestedImpl(SubjectAccessReview item) {
      this.builder = new SubjectAccessReviewBuilder(this, item);
    }
    SubjectAccessReviewContentNestedImpl() {
      this.builder = new SubjectAccessReviewBuilder(this);
    }
    SubjectAccessReviewBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endSubjectAccessReviewContent() {
      return and();
    }
    
  }
  class LocalResourceAccessReviewContentNestedImpl<N> extends LocalResourceAccessReviewFluentImpl<LocalSubjectAccessReviewFluent.LocalResourceAccessReviewContentNested<N>> implements LocalSubjectAccessReviewFluent.LocalResourceAccessReviewContentNested<N>,Nested<N>{
    LocalResourceAccessReviewContentNestedImpl(LocalResourceAccessReview item) {
      this.builder = new LocalResourceAccessReviewBuilder(this, item);
    }
    LocalResourceAccessReviewContentNestedImpl() {
      this.builder = new LocalResourceAccessReviewBuilder(this);
    }
    LocalResourceAccessReviewBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endLocalResourceAccessReviewContent() {
      return and();
    }
    
  }
  class ClusterRoleContentNestedImpl<N> extends ClusterRoleFluentImpl<LocalSubjectAccessReviewFluent.ClusterRoleContentNested<N>> implements LocalSubjectAccessReviewFluent.ClusterRoleContentNested<N>,Nested<N>{
    ClusterRoleContentNestedImpl(ClusterRole item) {
      this.builder = new ClusterRoleBuilder(this, item);
    }
    ClusterRoleContentNestedImpl() {
      this.builder = new ClusterRoleBuilder(this);
    }
    ClusterRoleBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endClusterRoleContent() {
      return and();
    }
    
  }
  class ConnectionConfigContentNestedImpl<N> extends ConnectionConfigFluentImpl<LocalSubjectAccessReviewFluent.ConnectionConfigContentNested<N>> implements LocalSubjectAccessReviewFluent.ConnectionConfigContentNested<N>,Nested<N>{
    ConnectionConfigContentNestedImpl(ConnectionConfig item) {
      this.builder = new ConnectionConfigBuilder(this, item);
    }
    ConnectionConfigContentNestedImpl() {
      this.builder = new ConnectionConfigBuilder(this);
    }
    ConnectionConfigBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endConnectionConfigContent() {
      return and();
    }
    
  }
  class TagEventConditionContentNestedImpl<N> extends TagEventConditionFluentImpl<LocalSubjectAccessReviewFluent.TagEventConditionContentNested<N>> implements LocalSubjectAccessReviewFluent.TagEventConditionContentNested<N>,Nested<N>{
    TagEventConditionContentNestedImpl(TagEventCondition item) {
      this.builder = new TagEventConditionBuilder(this, item);
    }
    TagEventConditionContentNestedImpl() {
      this.builder = new TagEventConditionBuilder(this);
    }
    TagEventConditionBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endTagEventConditionContent() {
      return and();
    }
    
  }
  class LabelSelectorContentNestedImpl<N> extends LabelSelectorFluentImpl<LocalSubjectAccessReviewFluent.LabelSelectorContentNested<N>> implements LocalSubjectAccessReviewFluent.LabelSelectorContentNested<N>,Nested<N>{
    LabelSelectorContentNestedImpl(LabelSelector item) {
      this.builder = new LabelSelectorBuilder(this, item);
    }
    LabelSelectorContentNestedImpl() {
      this.builder = new LabelSelectorBuilder(this);
    }
    LabelSelectorBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endLabelSelectorContent() {
      return and();
    }
    
  }
  class NetNamespaceListContentNestedImpl<N> extends NetNamespaceListFluentImpl<LocalSubjectAccessReviewFluent.NetNamespaceListContentNested<N>> implements LocalSubjectAccessReviewFluent.NetNamespaceListContentNested<N>,Nested<N>{
    NetNamespaceListContentNestedImpl(NetNamespaceList item) {
      this.builder = new NetNamespaceListBuilder(this, item);
    }
    NetNamespaceListContentNestedImpl() {
      this.builder = new NetNamespaceListBuilder(this);
    }
    NetNamespaceListBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endNetNamespaceListContent() {
      return and();
    }
    
  }
  class BrokerTemplateInstanceSpecContentNestedImpl<N> extends BrokerTemplateInstanceSpecFluentImpl<LocalSubjectAccessReviewFluent.BrokerTemplateInstanceSpecContentNested<N>> implements LocalSubjectAccessReviewFluent.BrokerTemplateInstanceSpecContentNested<N>,Nested<N>{
    BrokerTemplateInstanceSpecContentNestedImpl(BrokerTemplateInstanceSpec item) {
      this.builder = new BrokerTemplateInstanceSpecBuilder(this, item);
    }
    BrokerTemplateInstanceSpecContentNestedImpl() {
      this.builder = new BrokerTemplateInstanceSpecBuilder(this);
    }
    BrokerTemplateInstanceSpecBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endBrokerTemplateInstanceSpecContent() {
      return and();
    }
    
  }
  class BinaryBuildSourceContentNestedImpl<N> extends BinaryBuildSourceFluentImpl<LocalSubjectAccessReviewFluent.BinaryBuildSourceContentNested<N>> implements LocalSubjectAccessReviewFluent.BinaryBuildSourceContentNested<N>,Nested<N>{
    BinaryBuildSourceContentNestedImpl(BinaryBuildSource item) {
      this.builder = new BinaryBuildSourceBuilder(this, item);
    }
    BinaryBuildSourceContentNestedImpl() {
      this.builder = new BinaryBuildSourceBuilder(this);
    }
    BinaryBuildSourceBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endBinaryBuildSourceContent() {
      return and();
    }
    
  }
  class OAuthClientAuthorizationListContentNestedImpl<N> extends OAuthClientAuthorizationListFluentImpl<LocalSubjectAccessReviewFluent.OAuthClientAuthorizationListContentNested<N>> implements LocalSubjectAccessReviewFluent.OAuthClientAuthorizationListContentNested<N>,Nested<N>{
    OAuthClientAuthorizationListContentNestedImpl(OAuthClientAuthorizationList item) {
      this.builder = new OAuthClientAuthorizationListBuilder(this, item);
    }
    OAuthClientAuthorizationListContentNestedImpl() {
      this.builder = new OAuthClientAuthorizationListBuilder(this);
    }
    OAuthClientAuthorizationListBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endOAuthClientAuthorizationListContent() {
      return and();
    }
    
  }
  class BuildSpecContentNestedImpl<N> extends BuildSpecFluentImpl<LocalSubjectAccessReviewFluent.BuildSpecContentNested<N>> implements LocalSubjectAccessReviewFluent.BuildSpecContentNested<N>,Nested<N>{
    BuildSpecContentNestedImpl(BuildSpec item) {
      this.builder = new BuildSpecBuilder(this, item);
    }
    BuildSpecContentNestedImpl() {
      this.builder = new BuildSpecBuilder(this);
    }
    BuildSpecBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endBuildSpecContent() {
      return and();
    }
    
  }
  class ProjectStatusContentNestedImpl<N> extends ProjectStatusFluentImpl<LocalSubjectAccessReviewFluent.ProjectStatusContentNested<N>> implements LocalSubjectAccessReviewFluent.ProjectStatusContentNested<N>,Nested<N>{
    ProjectStatusContentNestedImpl(ProjectStatus item) {
      this.builder = new ProjectStatusBuilder(this, item);
    }
    ProjectStatusContentNestedImpl() {
      this.builder = new ProjectStatusBuilder(this);
    }
    ProjectStatusBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endProjectStatusContent() {
      return and();
    }
    
  }
  class LocalSubjectAccessReviewContentNestedImpl<N> extends LocalSubjectAccessReviewFluentImpl<LocalSubjectAccessReviewFluent.LocalSubjectAccessReviewContentNested<N>> implements LocalSubjectAccessReviewFluent.LocalSubjectAccessReviewContentNested<N>,Nested<N>{
    LocalSubjectAccessReviewContentNestedImpl(LocalSubjectAccessReview item) {
      this.builder = new LocalSubjectAccessReviewBuilder(this, item);
    }
    LocalSubjectAccessReviewContentNestedImpl() {
      this.builder = new LocalSubjectAccessReviewBuilder(this);
    }
    LocalSubjectAccessReviewBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endLocalSubjectAccessReviewContent() {
      return and();
    }
    
  }
  class RollingDeploymentStrategyParamsContentNestedImpl<N> extends RollingDeploymentStrategyParamsFluentImpl<LocalSubjectAccessReviewFluent.RollingDeploymentStrategyParamsContentNested<N>> implements LocalSubjectAccessReviewFluent.RollingDeploymentStrategyParamsContentNested<N>,Nested<N>{
    RollingDeploymentStrategyParamsContentNestedImpl(RollingDeploymentStrategyParams item) {
      this.builder = new RollingDeploymentStrategyParamsBuilder(this, item);
    }
    RollingDeploymentStrategyParamsContentNestedImpl() {
      this.builder = new RollingDeploymentStrategyParamsBuilder(this);
    }
    RollingDeploymentStrategyParamsBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endRollingDeploymentStrategyParamsContent() {
      return and();
    }
    
  }
  class GitSourceRevisionContentNestedImpl<N> extends GitSourceRevisionFluentImpl<LocalSubjectAccessReviewFluent.GitSourceRevisionContentNested<N>> implements LocalSubjectAccessReviewFluent.GitSourceRevisionContentNested<N>,Nested<N>{
    GitSourceRevisionContentNestedImpl(GitSourceRevision item) {
      this.builder = new GitSourceRevisionBuilder(this, item);
    }
    GitSourceRevisionContentNestedImpl() {
      this.builder = new GitSourceRevisionBuilder(this);
    }
    GitSourceRevisionBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endGitSourceRevisionContent() {
      return and();
    }
    
  }
  class ImageLabelContentNestedImpl<N> extends ImageLabelFluentImpl<LocalSubjectAccessReviewFluent.ImageLabelContentNested<N>> implements LocalSubjectAccessReviewFluent.ImageLabelContentNested<N>,Nested<N>{
    ImageLabelContentNestedImpl(ImageLabel item) {
      this.builder = new ImageLabelBuilder(this, item);
    }
    ImageLabelContentNestedImpl() {
      this.builder = new ImageLabelBuilder(this);
    }
    ImageLabelBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endImageLabelContent() {
      return and();
    }
    
  }
  class ImageChangeTriggerContentNestedImpl<N> extends ImageChangeTriggerFluentImpl<LocalSubjectAccessReviewFluent.ImageChangeTriggerContentNested<N>> implements LocalSubjectAccessReviewFluent.ImageChangeTriggerContentNested<N>,Nested<N>{
    ImageChangeTriggerContentNestedImpl(ImageChangeTrigger item) {
      this.builder = new ImageChangeTriggerBuilder(this, item);
    }
    ImageChangeTriggerContentNestedImpl() {
      this.builder = new ImageChangeTriggerBuilder(this);
    }
    ImageChangeTriggerBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endImageChangeTriggerContent() {
      return and();
    }
    
  }
  class PodSecurityPolicyReviewSpecContentNestedImpl<N> extends PodSecurityPolicyReviewSpecFluentImpl<LocalSubjectAccessReviewFluent.PodSecurityPolicyReviewSpecContentNested<N>> implements LocalSubjectAccessReviewFluent.PodSecurityPolicyReviewSpecContentNested<N>,Nested<N>{
    PodSecurityPolicyReviewSpecContentNestedImpl(PodSecurityPolicyReviewSpec item) {
      this.builder = new PodSecurityPolicyReviewSpecBuilder(this, item);
    }
    PodSecurityPolicyReviewSpecContentNestedImpl() {
      this.builder = new PodSecurityPolicyReviewSpecBuilder(this);
    }
    PodSecurityPolicyReviewSpecBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endPodSecurityPolicyReviewSpecContent() {
      return and();
    }
    
  }
  class ImageTagContentNestedImpl<N> extends ImageTagFluentImpl<LocalSubjectAccessReviewFluent.ImageTagContentNested<N>> implements LocalSubjectAccessReviewFluent.ImageTagContentNested<N>,Nested<N>{
    ImageTagContentNestedImpl(ImageTag item) {
      this.builder = new ImageTagBuilder(this, item);
    }
    ImageTagContentNestedImpl() {
      this.builder = new ImageTagBuilder(this);
    }
    ImageTagBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endImageTagContent() {
      return and();
    }
    
  }
  class ImageStreamImportSpecContentNestedImpl<N> extends ImageStreamImportSpecFluentImpl<LocalSubjectAccessReviewFluent.ImageStreamImportSpecContentNested<N>> implements LocalSubjectAccessReviewFluent.ImageStreamImportSpecContentNested<N>,Nested<N>{
    ImageStreamImportSpecContentNestedImpl(ImageStreamImportSpec item) {
      this.builder = new ImageStreamImportSpecBuilder(this, item);
    }
    ImageStreamImportSpecContentNestedImpl() {
      this.builder = new ImageStreamImportSpecBuilder(this);
    }
    ImageStreamImportSpecBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endImageStreamImportSpecContent() {
      return and();
    }
    
  }
  class FSGroupStrategyOptionsContentNestedImpl<N> extends FSGroupStrategyOptionsFluentImpl<LocalSubjectAccessReviewFluent.FSGroupStrategyOptionsContentNested<N>> implements LocalSubjectAccessReviewFluent.FSGroupStrategyOptionsContentNested<N>,Nested<N>{
    FSGroupStrategyOptionsContentNestedImpl(FSGroupStrategyOptions item) {
      this.builder = new FSGroupStrategyOptionsBuilder(this, item);
    }
    FSGroupStrategyOptionsContentNestedImpl() {
      this.builder = new FSGroupStrategyOptionsBuilder(this);
    }
    FSGroupStrategyOptionsBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endFSGroupStrategyOptionsContent() {
      return and();
    }
    
  }
  class PodSecurityPolicyReviewContentNestedImpl<N> extends PodSecurityPolicyReviewFluentImpl<LocalSubjectAccessReviewFluent.PodSecurityPolicyReviewContentNested<N>> implements LocalSubjectAccessReviewFluent.PodSecurityPolicyReviewContentNested<N>,Nested<N>{
    PodSecurityPolicyReviewContentNestedImpl(PodSecurityPolicyReview item) {
      this.builder = new PodSecurityPolicyReviewBuilder(this, item);
    }
    PodSecurityPolicyReviewContentNestedImpl() {
      this.builder = new PodSecurityPolicyReviewBuilder(this);
    }
    PodSecurityPolicyReviewBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endPodSecurityPolicyReviewContent() {
      return and();
    }
    
  }
  class RecreateDeploymentStrategyParamsContentNestedImpl<N> extends RecreateDeploymentStrategyParamsFluentImpl<LocalSubjectAccessReviewFluent.RecreateDeploymentStrategyParamsContentNested<N>> implements LocalSubjectAccessReviewFluent.RecreateDeploymentStrategyParamsContentNested<N>,Nested<N>{
    RecreateDeploymentStrategyParamsContentNestedImpl(RecreateDeploymentStrategyParams item) {
      this.builder = new RecreateDeploymentStrategyParamsBuilder(this, item);
    }
    RecreateDeploymentStrategyParamsContentNestedImpl() {
      this.builder = new RecreateDeploymentStrategyParamsBuilder(this);
    }
    RecreateDeploymentStrategyParamsBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endRecreateDeploymentStrategyParamsContent() {
      return and();
    }
    
  }
  class DockerStrategyOptionsContentNestedImpl<N> extends DockerStrategyOptionsFluentImpl<LocalSubjectAccessReviewFluent.DockerStrategyOptionsContentNested<N>> implements LocalSubjectAccessReviewFluent.DockerStrategyOptionsContentNested<N>,Nested<N>{
    DockerStrategyOptionsContentNestedImpl(DockerStrategyOptions item) {
      this.builder = new DockerStrategyOptionsBuilder(this, item);
    }
    DockerStrategyOptionsContentNestedImpl() {
      this.builder = new DockerStrategyOptionsBuilder(this);
    }
    DockerStrategyOptionsBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endDockerStrategyOptionsContent() {
      return and();
    }
    
  }
  class ImageListContentNestedImpl<N> extends ImageListFluentImpl<LocalSubjectAccessReviewFluent.ImageListContentNested<N>> implements LocalSubjectAccessReviewFluent.ImageListContentNested<N>,Nested<N>{
    ImageListContentNestedImpl(ImageList item) {
      this.builder = new ImageListBuilder(this, item);
    }
    ImageListContentNestedImpl() {
      this.builder = new ImageListBuilder(this);
    }
    ImageListBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endImageListContent() {
      return and();
    }
    
  }
  class ConfigMapBuildSourceContentNestedImpl<N> extends ConfigMapBuildSourceFluentImpl<LocalSubjectAccessReviewFluent.ConfigMapBuildSourceContentNested<N>> implements LocalSubjectAccessReviewFluent.ConfigMapBuildSourceContentNested<N>,Nested<N>{
    ConfigMapBuildSourceContentNestedImpl(ConfigMapBuildSource item) {
      this.builder = new ConfigMapBuildSourceBuilder(this, item);
    }
    ConfigMapBuildSourceContentNestedImpl() {
      this.builder = new ConfigMapBuildSourceBuilder(this);
    }
    ConfigMapBuildSourceBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endConfigMapBuildSourceContent() {
      return and();
    }
    
  }
  class ImageTagListContentNestedImpl<N> extends ImageTagListFluentImpl<LocalSubjectAccessReviewFluent.ImageTagListContentNested<N>> implements LocalSubjectAccessReviewFluent.ImageTagListContentNested<N>,Nested<N>{
    ImageTagListContentNestedImpl(ImageTagList item) {
      this.builder = new ImageTagListBuilder(this, item);
    }
    ImageTagListContentNestedImpl() {
      this.builder = new ImageTagListBuilder(this);
    }
    ImageTagListBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endImageTagListContent() {
      return and();
    }
    
  }
  class OAuthAccessTokenContentNestedImpl<N> extends OAuthAccessTokenFluentImpl<LocalSubjectAccessReviewFluent.OAuthAccessTokenContentNested<N>> implements LocalSubjectAccessReviewFluent.OAuthAccessTokenContentNested<N>,Nested<N>{
    OAuthAccessTokenContentNestedImpl(OAuthAccessToken item) {
      this.builder = new OAuthAccessTokenBuilder(this, item);
    }
    OAuthAccessTokenContentNestedImpl() {
      this.builder = new OAuthAccessTokenBuilder(this);
    }
    OAuthAccessTokenBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endOAuthAccessTokenContent() {
      return and();
    }
    
  }
  class DeploymentConfigContentNestedImpl<N> extends DeploymentConfigFluentImpl<LocalSubjectAccessReviewFluent.DeploymentConfigContentNested<N>> implements LocalSubjectAccessReviewFluent.DeploymentConfigContentNested<N>,Nested<N>{
    DeploymentConfigContentNestedImpl(DeploymentConfig item) {
      this.builder = new DeploymentConfigBuilder(this, item);
    }
    DeploymentConfigContentNestedImpl() {
      this.builder = new DeploymentConfigBuilder(this);
    }
    DeploymentConfigBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endDeploymentConfigContent() {
      return and();
    }
    
  }
  class RoleBindingContentNestedImpl<N> extends RoleBindingFluentImpl<LocalSubjectAccessReviewFluent.RoleBindingContentNested<N>> implements LocalSubjectAccessReviewFluent.RoleBindingContentNested<N>,Nested<N>{
    RoleBindingContentNestedImpl(RoleBinding item) {
      this.builder = new RoleBindingBuilder(this, item);
    }
    RoleBindingContentNestedImpl() {
      this.builder = new RoleBindingBuilder(this);
    }
    RoleBindingBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endRoleBindingContent() {
      return and();
    }
    
  }
  class ImageContentNestedImpl<N> extends ImageFluentImpl<LocalSubjectAccessReviewFluent.ImageContentNested<N>> implements LocalSubjectAccessReviewFluent.ImageContentNested<N>,Nested<N>{
    ImageContentNestedImpl(Image item) {
      this.builder = new ImageBuilder(this, item);
    }
    ImageContentNestedImpl() {
      this.builder = new ImageBuilder(this);
    }
    ImageBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endImageContent() {
      return and();
    }
    
  }
  class TLSConfigContentNestedImpl<N> extends TLSConfigFluentImpl<LocalSubjectAccessReviewFluent.TLSConfigContentNested<N>> implements LocalSubjectAccessReviewFluent.TLSConfigContentNested<N>,Nested<N>{
    TLSConfigContentNestedImpl(TLSConfig item) {
      this.builder = new TLSConfigBuilder(this, item);
    }
    TLSConfigContentNestedImpl() {
      this.builder = new TLSConfigBuilder(this);
    }
    TLSConfigBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endTLSConfigContent() {
      return and();
    }
    
  }
  class BuildVolumeContentNestedImpl<N> extends BuildVolumeFluentImpl<LocalSubjectAccessReviewFluent.BuildVolumeContentNested<N>> implements LocalSubjectAccessReviewFluent.BuildVolumeContentNested<N>,Nested<N>{
    BuildVolumeContentNestedImpl(BuildVolume item) {
      this.builder = new BuildVolumeBuilder(this, item);
    }
    BuildVolumeContentNestedImpl() {
      this.builder = new BuildVolumeBuilder(this);
    }
    BuildVolumeBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endBuildVolumeContent() {
      return and();
    }
    
  }
  class TemplateInstanceSpecContentNestedImpl<N> extends TemplateInstanceSpecFluentImpl<LocalSubjectAccessReviewFluent.TemplateInstanceSpecContentNested<N>> implements LocalSubjectAccessReviewFluent.TemplateInstanceSpecContentNested<N>,Nested<N>{
    TemplateInstanceSpecContentNestedImpl(TemplateInstanceSpec item) {
      this.builder = new TemplateInstanceSpecBuilder(this, item);
    }
    TemplateInstanceSpecContentNestedImpl() {
      this.builder = new TemplateInstanceSpecBuilder(this);
    }
    TemplateInstanceSpecBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endTemplateInstanceSpecContent() {
      return and();
    }
    
  }
  class BuildStatusContentNestedImpl<N> extends BuildStatusFluentImpl<LocalSubjectAccessReviewFluent.BuildStatusContentNested<N>> implements LocalSubjectAccessReviewFluent.BuildStatusContentNested<N>,Nested<N>{
    BuildStatusContentNestedImpl(BuildStatus item) {
      this.builder = new BuildStatusBuilder(this, item);
    }
    BuildStatusContentNestedImpl() {
      this.builder = new BuildStatusBuilder(this);
    }
    BuildStatusBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endBuildStatusContent() {
      return and();
    }
    
  }
  class ImageSourceContentNestedImpl<N> extends ImageSourceFluentImpl<LocalSubjectAccessReviewFluent.ImageSourceContentNested<N>> implements LocalSubjectAccessReviewFluent.ImageSourceContentNested<N>,Nested<N>{
    ImageSourceContentNestedImpl(ImageSource item) {
      this.builder = new ImageSourceBuilder(this, item);
    }
    ImageSourceContentNestedImpl() {
      this.builder = new ImageSourceBuilder(this);
    }
    ImageSourceBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endImageSourceContent() {
      return and();
    }
    
  }
  class ObjectMetaContentNestedImpl<N> extends ObjectMetaFluentImpl<LocalSubjectAccessReviewFluent.ObjectMetaContentNested<N>> implements LocalSubjectAccessReviewFluent.ObjectMetaContentNested<N>,Nested<N>{
    ObjectMetaContentNestedImpl(ObjectMeta item) {
      this.builder = new ObjectMetaBuilder(this, item);
    }
    ObjectMetaContentNestedImpl() {
      this.builder = new ObjectMetaBuilder(this);
    }
    ObjectMetaBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endObjectMetaContent() {
      return and();
    }
    
  }
  class PersistentVolumeClaimContentNestedImpl<N> extends PersistentVolumeClaimFluentImpl<LocalSubjectAccessReviewFluent.PersistentVolumeClaimContentNested<N>> implements LocalSubjectAccessReviewFluent.PersistentVolumeClaimContentNested<N>,Nested<N>{
    PersistentVolumeClaimContentNestedImpl(PersistentVolumeClaim item) {
      this.builder = new PersistentVolumeClaimBuilder(this, item);
    }
    PersistentVolumeClaimContentNestedImpl() {
      this.builder = new PersistentVolumeClaimBuilder(this);
    }
    PersistentVolumeClaimBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endPersistentVolumeClaimContent() {
      return and();
    }
    
  }
  class PodSecurityPolicySelfSubjectReviewContentNestedImpl<N> extends PodSecurityPolicySelfSubjectReviewFluentImpl<LocalSubjectAccessReviewFluent.PodSecurityPolicySelfSubjectReviewContentNested<N>> implements LocalSubjectAccessReviewFluent.PodSecurityPolicySelfSubjectReviewContentNested<N>,Nested<N>{
    PodSecurityPolicySelfSubjectReviewContentNestedImpl(PodSecurityPolicySelfSubjectReview item) {
      this.builder = new PodSecurityPolicySelfSubjectReviewBuilder(this, item);
    }
    PodSecurityPolicySelfSubjectReviewContentNestedImpl() {
      this.builder = new PodSecurityPolicySelfSubjectReviewBuilder(this);
    }
    PodSecurityPolicySelfSubjectReviewBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endPodSecurityPolicySelfSubjectReviewContent() {
      return and();
    }
    
  }
  class TagReferenceContentNestedImpl<N> extends TagReferenceFluentImpl<LocalSubjectAccessReviewFluent.TagReferenceContentNested<N>> implements LocalSubjectAccessReviewFluent.TagReferenceContentNested<N>,Nested<N>{
    TagReferenceContentNestedImpl(TagReference item) {
      this.builder = new TagReferenceBuilder(this, item);
    }
    TagReferenceContentNestedImpl() {
      this.builder = new TagReferenceBuilder(this);
    }
    TagReferenceBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endTagReferenceContent() {
      return and();
    }
    
  }
  class EgressNetworkPolicyRuleContentNestedImpl<N> extends EgressNetworkPolicyRuleFluentImpl<LocalSubjectAccessReviewFluent.EgressNetworkPolicyRuleContentNested<N>> implements LocalSubjectAccessReviewFluent.EgressNetworkPolicyRuleContentNested<N>,Nested<N>{
    EgressNetworkPolicyRuleContentNestedImpl(EgressNetworkPolicyRule item) {
      this.builder = new EgressNetworkPolicyRuleBuilder(this, item);
    }
    EgressNetworkPolicyRuleContentNestedImpl() {
      this.builder = new EgressNetworkPolicyRuleBuilder(this);
    }
    EgressNetworkPolicyRuleBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endEgressNetworkPolicyRuleContent() {
      return and();
    }
    
  }
  class SubjectRulesReviewStatusContentNestedImpl<N> extends SubjectRulesReviewStatusFluentImpl<LocalSubjectAccessReviewFluent.SubjectRulesReviewStatusContentNested<N>> implements LocalSubjectAccessReviewFluent.SubjectRulesReviewStatusContentNested<N>,Nested<N>{
    SubjectRulesReviewStatusContentNestedImpl(SubjectRulesReviewStatus item) {
      this.builder = new SubjectRulesReviewStatusBuilder(this, item);
    }
    SubjectRulesReviewStatusContentNestedImpl() {
      this.builder = new SubjectRulesReviewStatusBuilder(this);
    }
    SubjectRulesReviewStatusBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endSubjectRulesReviewStatusContent() {
      return and();
    }
    
  }
  class BuildVolumeMountContentNestedImpl<N> extends BuildVolumeMountFluentImpl<LocalSubjectAccessReviewFluent.BuildVolumeMountContentNested<N>> implements LocalSubjectAccessReviewFluent.BuildVolumeMountContentNested<N>,Nested<N>{
    BuildVolumeMountContentNestedImpl(BuildVolumeMount item) {
      this.builder = new BuildVolumeMountBuilder(this, item);
    }
    BuildVolumeMountContentNestedImpl() {
      this.builder = new BuildVolumeMountBuilder(this);
    }
    BuildVolumeMountBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endBuildVolumeMountContent() {
      return and();
    }
    
  }
  class ClusterNetworkEntryContentNestedImpl<N> extends ClusterNetworkEntryFluentImpl<LocalSubjectAccessReviewFluent.ClusterNetworkEntryContentNested<N>> implements LocalSubjectAccessReviewFluent.ClusterNetworkEntryContentNested<N>,Nested<N>{
    ClusterNetworkEntryContentNestedImpl(ClusterNetworkEntry item) {
      this.builder = new ClusterNetworkEntryBuilder(this, item);
    }
    ClusterNetworkEntryContentNestedImpl() {
      this.builder = new ClusterNetworkEntryBuilder(this);
    }
    ClusterNetworkEntryBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endClusterNetworkEntryContent() {
      return and();
    }
    
  }
  class TemplateInstanceObjectContentNestedImpl<N> extends TemplateInstanceObjectFluentImpl<LocalSubjectAccessReviewFluent.TemplateInstanceObjectContentNested<N>> implements LocalSubjectAccessReviewFluent.TemplateInstanceObjectContentNested<N>,Nested<N>{
    TemplateInstanceObjectContentNestedImpl(TemplateInstanceObject item) {
      this.builder = new TemplateInstanceObjectBuilder(this, item);
    }
    TemplateInstanceObjectContentNestedImpl() {
      this.builder = new TemplateInstanceObjectBuilder(this);
    }
    TemplateInstanceObjectBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endTemplateInstanceObjectContent() {
      return and();
    }
    
  }
  class BuildSourceContentNestedImpl<N> extends BuildSourceFluentImpl<LocalSubjectAccessReviewFluent.BuildSourceContentNested<N>> implements LocalSubjectAccessReviewFluent.BuildSourceContentNested<N>,Nested<N>{
    BuildSourceContentNestedImpl(BuildSource item) {
      this.builder = new BuildSourceBuilder(this, item);
    }
    BuildSourceContentNestedImpl() {
      this.builder = new BuildSourceBuilder(this);
    }
    BuildSourceBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endBuildSourceContent() {
      return and();
    }
    
  }
  class ClusterResourceQuotaStatusContentNestedImpl<N> extends ClusterResourceQuotaStatusFluentImpl<LocalSubjectAccessReviewFluent.ClusterResourceQuotaStatusContentNested<N>> implements LocalSubjectAccessReviewFluent.ClusterResourceQuotaStatusContentNested<N>,Nested<N>{
    ClusterResourceQuotaStatusContentNestedImpl(ClusterResourceQuotaStatus item) {
      this.builder = new ClusterResourceQuotaStatusBuilder(this, item);
    }
    ClusterResourceQuotaStatusContentNestedImpl() {
      this.builder = new ClusterResourceQuotaStatusBuilder(this);
    }
    ClusterResourceQuotaStatusBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endClusterResourceQuotaStatusContent() {
      return and();
    }
    
  }
  class DeploymentConditionContentNestedImpl<N> extends DeploymentConditionFluentImpl<LocalSubjectAccessReviewFluent.DeploymentConditionContentNested<N>> implements LocalSubjectAccessReviewFluent.DeploymentConditionContentNested<N>,Nested<N>{
    DeploymentConditionContentNestedImpl(DeploymentCondition item) {
      this.builder = new DeploymentConditionBuilder(this, item);
    }
    DeploymentConditionContentNestedImpl() {
      this.builder = new DeploymentConditionBuilder(this);
    }
    DeploymentConditionBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endDeploymentConditionContent() {
      return and();
    }
    
  }
  class HelmChartRepositorySpecContentNestedImpl<N> extends HelmChartRepositorySpecFluentImpl<LocalSubjectAccessReviewFluent.HelmChartRepositorySpecContentNested<N>> implements LocalSubjectAccessReviewFluent.HelmChartRepositorySpecContentNested<N>,Nested<N>{
    HelmChartRepositorySpecContentNestedImpl(HelmChartRepositorySpec item) {
      this.builder = new HelmChartRepositorySpecBuilder(this, item);
    }
    HelmChartRepositorySpecContentNestedImpl() {
      this.builder = new HelmChartRepositorySpecBuilder(this);
    }
    HelmChartRepositorySpecBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endHelmChartRepositorySpecContent() {
      return and();
    }
    
  }
  class DeploymentCauseImageTriggerContentNestedImpl<N> extends DeploymentCauseImageTriggerFluentImpl<LocalSubjectAccessReviewFluent.DeploymentCauseImageTriggerContentNested<N>> implements LocalSubjectAccessReviewFluent.DeploymentCauseImageTriggerContentNested<N>,Nested<N>{
    DeploymentCauseImageTriggerContentNestedImpl(DeploymentCauseImageTrigger item) {
      this.builder = new DeploymentCauseImageTriggerBuilder(this, item);
    }
    DeploymentCauseImageTriggerContentNestedImpl() {
      this.builder = new DeploymentCauseImageTriggerBuilder(this);
    }
    DeploymentCauseImageTriggerBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endDeploymentCauseImageTriggerContent() {
      return and();
    }
    
  }
  class ImageStreamMappingContentNestedImpl<N> extends ImageStreamMappingFluentImpl<LocalSubjectAccessReviewFluent.ImageStreamMappingContentNested<N>> implements LocalSubjectAccessReviewFluent.ImageStreamMappingContentNested<N>,Nested<N>{
    ImageStreamMappingContentNestedImpl(ImageStreamMapping item) {
      this.builder = new ImageStreamMappingBuilder(this, item);
    }
    ImageStreamMappingContentNestedImpl() {
      this.builder = new ImageStreamMappingBuilder(this);
    }
    ImageStreamMappingBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endImageStreamMappingContent() {
      return and();
    }
    
  }
  class SubjectRulesReviewContentNestedImpl<N> extends SubjectRulesReviewFluentImpl<LocalSubjectAccessReviewFluent.SubjectRulesReviewContentNested<N>> implements LocalSubjectAccessReviewFluent.SubjectRulesReviewContentNested<N>,Nested<N>{
    SubjectRulesReviewContentNestedImpl(SubjectRulesReview item) {
      this.builder = new SubjectRulesReviewBuilder(this, item);
    }
    SubjectRulesReviewContentNestedImpl() {
      this.builder = new SubjectRulesReviewBuilder(this);
    }
    SubjectRulesReviewBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endSubjectRulesReviewContent() {
      return and();
    }
    
  }
  class RoleContentNestedImpl<N> extends RoleFluentImpl<LocalSubjectAccessReviewFluent.RoleContentNested<N>> implements LocalSubjectAccessReviewFluent.RoleContentNested<N>,Nested<N>{
    RoleContentNestedImpl(Role item) {
      this.builder = new RoleBuilder(this, item);
    }
    RoleContentNestedImpl() {
      this.builder = new RoleBuilder(this);
    }
    RoleBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endRoleContent() {
      return and();
    }
    
  }
  class GitBuildSourceContentNestedImpl<N> extends GitBuildSourceFluentImpl<LocalSubjectAccessReviewFluent.GitBuildSourceContentNested<N>> implements LocalSubjectAccessReviewFluent.GitBuildSourceContentNested<N>,Nested<N>{
    GitBuildSourceContentNestedImpl(GitBuildSource item) {
      this.builder = new GitBuildSourceBuilder(this, item);
    }
    GitBuildSourceContentNestedImpl() {
      this.builder = new GitBuildSourceBuilder(this);
    }
    GitBuildSourceBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endGitBuildSourceContent() {
      return and();
    }
    
  }
  class EgressNetworkPolicyListContentNestedImpl<N> extends EgressNetworkPolicyListFluentImpl<LocalSubjectAccessReviewFluent.EgressNetworkPolicyListContentNested<N>> implements LocalSubjectAccessReviewFluent.EgressNetworkPolicyListContentNested<N>,Nested<N>{
    EgressNetworkPolicyListContentNestedImpl(EgressNetworkPolicyList item) {
      this.builder = new EgressNetworkPolicyListBuilder(this, item);
    }
    EgressNetworkPolicyListContentNestedImpl() {
      this.builder = new EgressNetworkPolicyListBuilder(this);
    }
    EgressNetworkPolicyListBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endEgressNetworkPolicyListContent() {
      return and();
    }
    
  }
  class SelfSubjectRulesReviewSpecContentNestedImpl<N> extends SelfSubjectRulesReviewSpecFluentImpl<LocalSubjectAccessReviewFluent.SelfSubjectRulesReviewSpecContentNested<N>> implements LocalSubjectAccessReviewFluent.SelfSubjectRulesReviewSpecContentNested<N>,Nested<N>{
    SelfSubjectRulesReviewSpecContentNestedImpl(SelfSubjectRulesReviewSpec item) {
      this.builder = new SelfSubjectRulesReviewSpecBuilder(this, item);
    }
    SelfSubjectRulesReviewSpecContentNestedImpl() {
      this.builder = new SelfSubjectRulesReviewSpecBuilder(this);
    }
    SelfSubjectRulesReviewSpecBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endSelfSubjectRulesReviewSpecContent() {
      return and();
    }
    
  }
  class ImageSourcePathContentNestedImpl<N> extends ImageSourcePathFluentImpl<LocalSubjectAccessReviewFluent.ImageSourcePathContentNested<N>> implements LocalSubjectAccessReviewFluent.ImageSourcePathContentNested<N>,Nested<N>{
    ImageSourcePathContentNestedImpl(ImageSourcePath item) {
      this.builder = new ImageSourcePathBuilder(this, item);
    }
    ImageSourcePathContentNestedImpl() {
      this.builder = new ImageSourcePathBuilder(this);
    }
    ImageSourcePathBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endImageSourcePathContent() {
      return and();
    }
    
  }
  class BuildConfigStatusContentNestedImpl<N> extends BuildConfigStatusFluentImpl<LocalSubjectAccessReviewFluent.BuildConfigStatusContentNested<N>> implements LocalSubjectAccessReviewFluent.BuildConfigStatusContentNested<N>,Nested<N>{
    BuildConfigStatusContentNestedImpl(BuildConfigStatus item) {
      this.builder = new BuildConfigStatusBuilder(this, item);
    }
    BuildConfigStatusContentNestedImpl() {
      this.builder = new BuildConfigStatusBuilder(this);
    }
    BuildConfigStatusBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endBuildConfigStatusContent() {
      return and();
    }
    
  }
  class ResourceQuotaStatusByNamespaceContentNestedImpl<N> extends ResourceQuotaStatusByNamespaceFluentImpl<LocalSubjectAccessReviewFluent.ResourceQuotaStatusByNamespaceContentNested<N>> implements LocalSubjectAccessReviewFluent.ResourceQuotaStatusByNamespaceContentNested<N>,Nested<N>{
    ResourceQuotaStatusByNamespaceContentNestedImpl(ResourceQuotaStatusByNamespace item) {
      this.builder = new ResourceQuotaStatusByNamespaceBuilder(this, item);
    }
    ResourceQuotaStatusByNamespaceContentNestedImpl() {
      this.builder = new ResourceQuotaStatusByNamespaceBuilder(this);
    }
    ResourceQuotaStatusByNamespaceBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endResourceQuotaStatusByNamespaceContent() {
      return and();
    }
    
  }
  class SourceBuildStrategyContentNestedImpl<N> extends SourceBuildStrategyFluentImpl<LocalSubjectAccessReviewFluent.SourceBuildStrategyContentNested<N>> implements LocalSubjectAccessReviewFluent.SourceBuildStrategyContentNested<N>,Nested<N>{
    SourceBuildStrategyContentNestedImpl(SourceBuildStrategy item) {
      this.builder = new SourceBuildStrategyBuilder(this, item);
    }
    SourceBuildStrategyContentNestedImpl() {
      this.builder = new SourceBuildStrategyBuilder(this);
    }
    SourceBuildStrategyBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endSourceBuildStrategyContent() {
      return and();
    }
    
  }
  class ParameterContentNestedImpl<N> extends ParameterFluentImpl<LocalSubjectAccessReviewFluent.ParameterContentNested<N>> implements LocalSubjectAccessReviewFluent.ParameterContentNested<N>,Nested<N>{
    ParameterContentNestedImpl(Parameter item) {
      this.builder = new ParameterBuilder(this, item);
    }
    ParameterContentNestedImpl() {
      this.builder = new ParameterBuilder(this);
    }
    ParameterBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endParameterContent() {
      return and();
    }
    
  }
  class RoleBindingListContentNestedImpl<N> extends RoleBindingListFluentImpl<LocalSubjectAccessReviewFluent.RoleBindingListContentNested<N>> implements LocalSubjectAccessReviewFluent.RoleBindingListContentNested<N>,Nested<N>{
    RoleBindingListContentNestedImpl(RoleBindingList item) {
      this.builder = new RoleBindingListBuilder(this, item);
    }
    RoleBindingListContentNestedImpl() {
      this.builder = new RoleBindingListBuilder(this);
    }
    RoleBindingListBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endRoleBindingListContent() {
      return and();
    }
    
  }
  class PodSecurityPolicySelfSubjectReviewSpecContentNestedImpl<N> extends PodSecurityPolicySelfSubjectReviewSpecFluentImpl<LocalSubjectAccessReviewFluent.PodSecurityPolicySelfSubjectReviewSpecContentNested<N>> implements LocalSubjectAccessReviewFluent.PodSecurityPolicySelfSubjectReviewSpecContentNested<N>,Nested<N>{
    PodSecurityPolicySelfSubjectReviewSpecContentNestedImpl(PodSecurityPolicySelfSubjectReviewSpec item) {
      this.builder = new PodSecurityPolicySelfSubjectReviewSpecBuilder(this, item);
    }
    PodSecurityPolicySelfSubjectReviewSpecContentNestedImpl() {
      this.builder = new PodSecurityPolicySelfSubjectReviewSpecBuilder(this);
    }
    PodSecurityPolicySelfSubjectReviewSpecBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endPodSecurityPolicySelfSubjectReviewSpecContent() {
      return and();
    }
    
  }
  class BrokerTemplateInstanceContentNestedImpl<N> extends BrokerTemplateInstanceFluentImpl<LocalSubjectAccessReviewFluent.BrokerTemplateInstanceContentNested<N>> implements LocalSubjectAccessReviewFluent.BrokerTemplateInstanceContentNested<N>,Nested<N>{
    BrokerTemplateInstanceContentNestedImpl(BrokerTemplateInstance item) {
      this.builder = new BrokerTemplateInstanceBuilder(this, item);
    }
    BrokerTemplateInstanceContentNestedImpl() {
      this.builder = new BrokerTemplateInstanceBuilder(this);
    }
    BrokerTemplateInstanceBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endBrokerTemplateInstanceContent() {
      return and();
    }
    
  }
  class BuildPostCommitSpecContentNestedImpl<N> extends BuildPostCommitSpecFluentImpl<LocalSubjectAccessReviewFluent.BuildPostCommitSpecContentNested<N>> implements LocalSubjectAccessReviewFluent.BuildPostCommitSpecContentNested<N>,Nested<N>{
    BuildPostCommitSpecContentNestedImpl(BuildPostCommitSpec item) {
      this.builder = new BuildPostCommitSpecBuilder(this, item);
    }
    BuildPostCommitSpecContentNestedImpl() {
      this.builder = new BuildPostCommitSpecBuilder(this);
    }
    BuildPostCommitSpecBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endBuildPostCommitSpecContent() {
      return and();
    }
    
  }
  class OAuthAuthorizeTokenListContentNestedImpl<N> extends OAuthAuthorizeTokenListFluentImpl<LocalSubjectAccessReviewFluent.OAuthAuthorizeTokenListContentNested<N>> implements LocalSubjectAccessReviewFluent.OAuthAuthorizeTokenListContentNested<N>,Nested<N>{
    OAuthAuthorizeTokenListContentNestedImpl(OAuthAuthorizeTokenList item) {
      this.builder = new OAuthAuthorizeTokenListBuilder(this, item);
    }
    OAuthAuthorizeTokenListContentNestedImpl() {
      this.builder = new OAuthAuthorizeTokenListBuilder(this);
    }
    OAuthAuthorizeTokenListBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endOAuthAuthorizeTokenListContent() {
      return and();
    }
    
  }
  class DeploymentStrategyContentNestedImpl<N> extends DeploymentStrategyFluentImpl<LocalSubjectAccessReviewFluent.DeploymentStrategyContentNested<N>> implements LocalSubjectAccessReviewFluent.DeploymentStrategyContentNested<N>,Nested<N>{
    DeploymentStrategyContentNestedImpl(DeploymentStrategy item) {
      this.builder = new DeploymentStrategyBuilder(this, item);
    }
    DeploymentStrategyContentNestedImpl() {
      this.builder = new DeploymentStrategyBuilder(this);
    }
    DeploymentStrategyBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endDeploymentStrategyContent() {
      return and();
    }
    
  }
  class SignatureSubjectContentNestedImpl<N> extends SignatureSubjectFluentImpl<LocalSubjectAccessReviewFluent.SignatureSubjectContentNested<N>> implements LocalSubjectAccessReviewFluent.SignatureSubjectContentNested<N>,Nested<N>{
    SignatureSubjectContentNestedImpl(SignatureSubject item) {
      this.builder = new SignatureSubjectBuilder(this, item);
    }
    SignatureSubjectContentNestedImpl() {
      this.builder = new SignatureSubjectBuilder(this);
    }
    SignatureSubjectBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endSignatureSubjectContent() {
      return and();
    }
    
  }
  class HostSubnetListContentNestedImpl<N> extends HostSubnetListFluentImpl<LocalSubjectAccessReviewFluent.HostSubnetListContentNested<N>> implements LocalSubjectAccessReviewFluent.HostSubnetListContentNested<N>,Nested<N>{
    HostSubnetListContentNestedImpl(HostSubnetList item) {
      this.builder = new HostSubnetListBuilder(this, item);
    }
    HostSubnetListContentNestedImpl() {
      this.builder = new HostSubnetListBuilder(this);
    }
    HostSubnetListBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endHostSubnetListContent() {
      return and();
    }
    
  }
  class RouteIngressConditionContentNestedImpl<N> extends RouteIngressConditionFluentImpl<LocalSubjectAccessReviewFluent.RouteIngressConditionContentNested<N>> implements LocalSubjectAccessReviewFluent.RouteIngressConditionContentNested<N>,Nested<N>{
    RouteIngressConditionContentNestedImpl(RouteIngressCondition item) {
      this.builder = new RouteIngressConditionBuilder(this, item);
    }
    RouteIngressConditionContentNestedImpl() {
      this.builder = new RouteIngressConditionBuilder(this);
    }
    RouteIngressConditionBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endRouteIngressConditionContent() {
      return and();
    }
    
  }
  class CustomDeploymentStrategyParamsContentNestedImpl<N> extends CustomDeploymentStrategyParamsFluentImpl<LocalSubjectAccessReviewFluent.CustomDeploymentStrategyParamsContentNested<N>> implements LocalSubjectAccessReviewFluent.CustomDeploymentStrategyParamsContentNested<N>,Nested<N>{
    CustomDeploymentStrategyParamsContentNestedImpl(CustomDeploymentStrategyParams item) {
      this.builder = new CustomDeploymentStrategyParamsBuilder(this, item);
    }
    CustomDeploymentStrategyParamsContentNestedImpl() {
      this.builder = new CustomDeploymentStrategyParamsBuilder(this);
    }
    CustomDeploymentStrategyParamsBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endCustomDeploymentStrategyParamsContent() {
      return and();
    }
    
  }
  class ImageImportSpecContentNestedImpl<N> extends ImageImportSpecFluentImpl<LocalSubjectAccessReviewFluent.ImageImportSpecContentNested<N>> implements LocalSubjectAccessReviewFluent.ImageImportSpecContentNested<N>,Nested<N>{
    ImageImportSpecContentNestedImpl(ImageImportSpec item) {
      this.builder = new ImageImportSpecBuilder(this, item);
    }
    ImageImportSpecContentNestedImpl() {
      this.builder = new ImageImportSpecBuilder(this);
    }
    ImageImportSpecBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endImageImportSpecContent() {
      return and();
    }
    
  }
  class StageInfoContentNestedImpl<N> extends StageInfoFluentImpl<LocalSubjectAccessReviewFluent.StageInfoContentNested<N>> implements LocalSubjectAccessReviewFluent.StageInfoContentNested<N>,Nested<N>{
    StageInfoContentNestedImpl(StageInfo item) {
      this.builder = new StageInfoBuilder(this, item);
    }
    StageInfoContentNestedImpl() {
      this.builder = new StageInfoBuilder(this);
    }
    StageInfoBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endStageInfoContent() {
      return and();
    }
    
  }
  class RoleBindingRestrictionSpecContentNestedImpl<N> extends RoleBindingRestrictionSpecFluentImpl<LocalSubjectAccessReviewFluent.RoleBindingRestrictionSpecContentNested<N>> implements LocalSubjectAccessReviewFluent.RoleBindingRestrictionSpecContentNested<N>,Nested<N>{
    RoleBindingRestrictionSpecContentNestedImpl(RoleBindingRestrictionSpec item) {
      this.builder = new RoleBindingRestrictionSpecBuilder(this, item);
    }
    RoleBindingRestrictionSpecContentNestedImpl() {
      this.builder = new RoleBindingRestrictionSpecBuilder(this);
    }
    RoleBindingRestrictionSpecBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endRoleBindingRestrictionSpecContent() {
      return and();
    }
    
  }
  class IDRangeContentNestedImpl<N> extends IDRangeFluentImpl<LocalSubjectAccessReviewFluent.IDRangeContentNested<N>> implements LocalSubjectAccessReviewFluent.IDRangeContentNested<N>,Nested<N>{
    IDRangeContentNestedImpl(IDRange item) {
      this.builder = new IDRangeBuilder(this, item);
    }
    IDRangeContentNestedImpl() {
      this.builder = new IDRangeBuilder(this);
    }
    IDRangeBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endIDRangeContent() {
      return and();
    }
    
  }
  class UserListContentNestedImpl<N> extends UserListFluentImpl<LocalSubjectAccessReviewFluent.UserListContentNested<N>> implements LocalSubjectAccessReviewFluent.UserListContentNested<N>,Nested<N>{
    UserListContentNestedImpl(UserList item) {
      this.builder = new UserListBuilder(this, item);
    }
    UserListContentNestedImpl() {
      this.builder = new UserListBuilder(this);
    }
    UserListBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endUserListContent() {
      return and();
    }
    
  }
  class BuildConfigSpecContentNestedImpl<N> extends BuildConfigSpecFluentImpl<LocalSubjectAccessReviewFluent.BuildConfigSpecContentNested<N>> implements LocalSubjectAccessReviewFluent.BuildConfigSpecContentNested<N>,Nested<N>{
    BuildConfigSpecContentNestedImpl(BuildConfigSpec item) {
      this.builder = new BuildConfigSpecBuilder(this, item);
    }
    BuildConfigSpecContentNestedImpl() {
      this.builder = new BuildConfigSpecBuilder(this);
    }
    BuildConfigSpecBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endBuildConfigSpecContent() {
      return and();
    }
    
  }
  class UserContentNestedImpl<N> extends UserFluentImpl<LocalSubjectAccessReviewFluent.UserContentNested<N>> implements LocalSubjectAccessReviewFluent.UserContentNested<N>,Nested<N>{
    UserContentNestedImpl(User item) {
      this.builder = new UserBuilder(this, item);
    }
    UserContentNestedImpl() {
      this.builder = new UserBuilder(this);
    }
    UserBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endUserContent() {
      return and();
    }
    
  }
  class ImageStreamImageContentNestedImpl<N> extends ImageStreamImageFluentImpl<LocalSubjectAccessReviewFluent.ImageStreamImageContentNested<N>> implements LocalSubjectAccessReviewFluent.ImageStreamImageContentNested<N>,Nested<N>{
    ImageStreamImageContentNestedImpl(ImageStreamImage item) {
      this.builder = new ImageStreamImageBuilder(this, item);
    }
    ImageStreamImageContentNestedImpl() {
      this.builder = new ImageStreamImageBuilder(this);
    }
    ImageStreamImageBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endImageStreamImageContent() {
      return and();
    }
    
  }
  class BuildStatusOutputToContentNestedImpl<N> extends BuildStatusOutputToFluentImpl<LocalSubjectAccessReviewFluent.BuildStatusOutputToContentNested<N>> implements LocalSubjectAccessReviewFluent.BuildStatusOutputToContentNested<N>,Nested<N>{
    BuildStatusOutputToContentNestedImpl(BuildStatusOutputTo item) {
      this.builder = new BuildStatusOutputToBuilder(this, item);
    }
    BuildStatusOutputToContentNestedImpl() {
      this.builder = new BuildStatusOutputToBuilder(this);
    }
    BuildStatusOutputToBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endBuildStatusOutputToContent() {
      return and();
    }
    
  }
  class BuildConditionContentNestedImpl<N> extends BuildConditionFluentImpl<LocalSubjectAccessReviewFluent.BuildConditionContentNested<N>> implements LocalSubjectAccessReviewFluent.BuildConditionContentNested<N>,Nested<N>{
    BuildConditionContentNestedImpl(BuildCondition item) {
      this.builder = new BuildConditionBuilder(this, item);
    }
    BuildConditionContentNestedImpl() {
      this.builder = new BuildConditionBuilder(this);
    }
    BuildConditionBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endBuildConditionContent() {
      return and();
    }
    
  }
  class ResourceAccessReviewResponseContentNestedImpl<N> extends ResourceAccessReviewResponseFluentImpl<LocalSubjectAccessReviewFluent.ResourceAccessReviewResponseContentNested<N>> implements LocalSubjectAccessReviewFluent.ResourceAccessReviewResponseContentNested<N>,Nested<N>{
    ResourceAccessReviewResponseContentNestedImpl(ResourceAccessReviewResponse item) {
      this.builder = new ResourceAccessReviewResponseBuilder(this, item);
    }
    ResourceAccessReviewResponseContentNestedImpl() {
      this.builder = new ResourceAccessReviewResponseBuilder(this);
    }
    ResourceAccessReviewResponseBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endResourceAccessReviewResponseContent() {
      return and();
    }
    
  }
  class ExecNewPodHookContentNestedImpl<N> extends ExecNewPodHookFluentImpl<LocalSubjectAccessReviewFluent.ExecNewPodHookContentNested<N>> implements LocalSubjectAccessReviewFluent.ExecNewPodHookContentNested<N>,Nested<N>{
    ExecNewPodHookContentNestedImpl(ExecNewPodHook item) {
      this.builder = new ExecNewPodHookBuilder(this, item);
    }
    ExecNewPodHookContentNestedImpl() {
      this.builder = new ExecNewPodHookBuilder(this);
    }
    ExecNewPodHookBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endExecNewPodHookContent() {
      return and();
    }
    
  }
  class SecretSpecContentNestedImpl<N> extends SecretSpecFluentImpl<LocalSubjectAccessReviewFluent.SecretSpecContentNested<N>> implements LocalSubjectAccessReviewFluent.SecretSpecContentNested<N>,Nested<N>{
    SecretSpecContentNestedImpl(SecretSpec item) {
      this.builder = new SecretSpecBuilder(this, item);
    }
    SecretSpecContentNestedImpl() {
      this.builder = new SecretSpecBuilder(this);
    }
    SecretSpecBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endSecretSpecContent() {
      return and();
    }
    
  }
  class ClusterRoleBindingListContentNestedImpl<N> extends ClusterRoleBindingListFluentImpl<LocalSubjectAccessReviewFluent.ClusterRoleBindingListContentNested<N>> implements LocalSubjectAccessReviewFluent.ClusterRoleBindingListContentNested<N>,Nested<N>{
    ClusterRoleBindingListContentNestedImpl(ClusterRoleBindingList item) {
      this.builder = new ClusterRoleBindingListBuilder(this, item);
    }
    ClusterRoleBindingListContentNestedImpl() {
      this.builder = new ClusterRoleBindingListBuilder(this);
    }
    ClusterRoleBindingListBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endClusterRoleBindingListContent() {
      return and();
    }
    
  }
  class EgressNetworkPolicyPeerContentNestedImpl<N> extends EgressNetworkPolicyPeerFluentImpl<LocalSubjectAccessReviewFluent.EgressNetworkPolicyPeerContentNested<N>> implements LocalSubjectAccessReviewFluent.EgressNetworkPolicyPeerContentNested<N>,Nested<N>{
    EgressNetworkPolicyPeerContentNestedImpl(EgressNetworkPolicyPeer item) {
      this.builder = new EgressNetworkPolicyPeerBuilder(this, item);
    }
    EgressNetworkPolicyPeerContentNestedImpl() {
      this.builder = new EgressNetworkPolicyPeerBuilder(this);
    }
    EgressNetworkPolicyPeerBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endEgressNetworkPolicyPeerContent() {
      return and();
    }
    
  }
  class TemplateInstanceContentNestedImpl<N> extends TemplateInstanceFluentImpl<LocalSubjectAccessReviewFluent.TemplateInstanceContentNested<N>> implements LocalSubjectAccessReviewFluent.TemplateInstanceContentNested<N>,Nested<N>{
    TemplateInstanceContentNestedImpl(TemplateInstance item) {
      this.builder = new TemplateInstanceBuilder(this, item);
    }
    TemplateInstanceContentNestedImpl() {
      this.builder = new TemplateInstanceBuilder(this);
    }
    TemplateInstanceBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endTemplateInstanceContent() {
      return and();
    }
    
  }
  class WebHookTriggerContentNestedImpl<N> extends WebHookTriggerFluentImpl<LocalSubjectAccessReviewFluent.WebHookTriggerContentNested<N>> implements LocalSubjectAccessReviewFluent.WebHookTriggerContentNested<N>,Nested<N>{
    WebHookTriggerContentNestedImpl(WebHookTrigger item) {
      this.builder = new WebHookTriggerBuilder(this, item);
    }
    WebHookTriggerContentNestedImpl() {
      this.builder = new WebHookTriggerBuilder(this);
    }
    WebHookTriggerBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endWebHookTriggerContent() {
      return and();
    }
    
  }
  class ServiceAccountReferenceContentNestedImpl<N> extends ServiceAccountReferenceFluentImpl<LocalSubjectAccessReviewFluent.ServiceAccountReferenceContentNested<N>> implements LocalSubjectAccessReviewFluent.ServiceAccountReferenceContentNested<N>,Nested<N>{
    ServiceAccountReferenceContentNestedImpl(ServiceAccountReference item) {
      this.builder = new ServiceAccountReferenceBuilder(this, item);
    }
    ServiceAccountReferenceContentNestedImpl() {
      this.builder = new ServiceAccountReferenceBuilder(this);
    }
    ServiceAccountReferenceBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endServiceAccountReferenceContent() {
      return and();
    }
    
  }
  class BuildContentNestedImpl<N> extends BuildFluentImpl<LocalSubjectAccessReviewFluent.BuildContentNested<N>> implements LocalSubjectAccessReviewFluent.BuildContentNested<N>,Nested<N>{
    BuildContentNestedImpl(Build item) {
      this.builder = new BuildBuilder(this, item);
    }
    BuildContentNestedImpl() {
      this.builder = new BuildBuilder(this);
    }
    BuildBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endBuildContent() {
      return and();
    }
    
  }
  class RoleBindingRestrictionContentNestedImpl<N> extends RoleBindingRestrictionFluentImpl<LocalSubjectAccessReviewFluent.RoleBindingRestrictionContentNested<N>> implements LocalSubjectAccessReviewFluent.RoleBindingRestrictionContentNested<N>,Nested<N>{
    RoleBindingRestrictionContentNestedImpl(RoleBindingRestriction item) {
      this.builder = new RoleBindingRestrictionBuilder(this, item);
    }
    RoleBindingRestrictionContentNestedImpl() {
      this.builder = new RoleBindingRestrictionBuilder(this);
    }
    RoleBindingRestrictionBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endRoleBindingRestrictionContent() {
      return and();
    }
    
  }
  class TagImportPolicyContentNestedImpl<N> extends TagImportPolicyFluentImpl<LocalSubjectAccessReviewFluent.TagImportPolicyContentNested<N>> implements LocalSubjectAccessReviewFluent.TagImportPolicyContentNested<N>,Nested<N>{
    TagImportPolicyContentNestedImpl(TagImportPolicy item) {
      this.builder = new TagImportPolicyBuilder(this, item);
    }
    TagImportPolicyContentNestedImpl() {
      this.builder = new TagImportPolicyBuilder(this);
    }
    TagImportPolicyBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endTagImportPolicyContent() {
      return and();
    }
    
  }
  class ImageStreamTagContentNestedImpl<N> extends ImageStreamTagFluentImpl<LocalSubjectAccessReviewFluent.ImageStreamTagContentNested<N>> implements LocalSubjectAccessReviewFluent.ImageStreamTagContentNested<N>,Nested<N>{
    ImageStreamTagContentNestedImpl(ImageStreamTag item) {
      this.builder = new ImageStreamTagBuilder(this, item);
    }
    ImageStreamTagContentNestedImpl() {
      this.builder = new ImageStreamTagBuilder(this);
    }
    ImageStreamTagBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endImageStreamTagContent() {
      return and();
    }
    
  }
  class BuildTriggerPolicyContentNestedImpl<N> extends BuildTriggerPolicyFluentImpl<LocalSubjectAccessReviewFluent.BuildTriggerPolicyContentNested<N>> implements LocalSubjectAccessReviewFluent.BuildTriggerPolicyContentNested<N>,Nested<N>{
    BuildTriggerPolicyContentNestedImpl(BuildTriggerPolicy item) {
      this.builder = new BuildTriggerPolicyBuilder(this, item);
    }
    BuildTriggerPolicyContentNestedImpl() {
      this.builder = new BuildTriggerPolicyBuilder(this);
    }
    BuildTriggerPolicyBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endBuildTriggerPolicyContent() {
      return and();
    }
    
  }
  class RoutePortContentNestedImpl<N> extends RoutePortFluentImpl<LocalSubjectAccessReviewFluent.RoutePortContentNested<N>> implements LocalSubjectAccessReviewFluent.RoutePortContentNested<N>,Nested<N>{
    RoutePortContentNestedImpl(RoutePort item) {
      this.builder = new RoutePortBuilder(this, item);
    }
    RoutePortContentNestedImpl() {
      this.builder = new RoutePortBuilder(this);
    }
    RoutePortBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endRoutePortContent() {
      return and();
    }
    
  }
  class TemplateInstanceRequesterContentNestedImpl<N> extends TemplateInstanceRequesterFluentImpl<LocalSubjectAccessReviewFluent.TemplateInstanceRequesterContentNested<N>> implements LocalSubjectAccessReviewFluent.TemplateInstanceRequesterContentNested<N>,Nested<N>{
    TemplateInstanceRequesterContentNestedImpl(TemplateInstanceRequester item) {
      this.builder = new TemplateInstanceRequesterBuilder(this, item);
    }
    TemplateInstanceRequesterContentNestedImpl() {
      this.builder = new TemplateInstanceRequesterBuilder(this);
    }
    TemplateInstanceRequesterBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endTemplateInstanceRequesterContent() {
      return and();
    }
    
  }
  class GroupContentNestedImpl<N> extends GroupFluentImpl<LocalSubjectAccessReviewFluent.GroupContentNested<N>> implements LocalSubjectAccessReviewFluent.GroupContentNested<N>,Nested<N>{
    GroupContentNestedImpl(Group item) {
      this.builder = new GroupBuilder(this, item);
    }
    GroupContentNestedImpl() {
      this.builder = new GroupBuilder(this);
    }
    GroupBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endGroupContent() {
      return and();
    }
    
  }
  class BuildTriggerCauseContentNestedImpl<N> extends BuildTriggerCauseFluentImpl<LocalSubjectAccessReviewFluent.BuildTriggerCauseContentNested<N>> implements LocalSubjectAccessReviewFluent.BuildTriggerCauseContentNested<N>,Nested<N>{
    BuildTriggerCauseContentNestedImpl(BuildTriggerCause item) {
      this.builder = new BuildTriggerCauseBuilder(this, item);
    }
    BuildTriggerCauseContentNestedImpl() {
      this.builder = new BuildTriggerCauseBuilder(this);
    }
    BuildTriggerCauseBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endBuildTriggerCauseContent() {
      return and();
    }
    
  }
  class ImageSignatureContentNestedImpl<N> extends ImageSignatureFluentImpl<LocalSubjectAccessReviewFluent.ImageSignatureContentNested<N>> implements LocalSubjectAccessReviewFluent.ImageSignatureContentNested<N>,Nested<N>{
    ImageSignatureContentNestedImpl(ImageSignature item) {
      this.builder = new ImageSignatureBuilder(this, item);
    }
    ImageSignatureContentNestedImpl() {
      this.builder = new ImageSignatureBuilder(this);
    }
    ImageSignatureBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endImageSignatureContent() {
      return and();
    }
    
  }
  class HelmChartRepositoryStatusContentNestedImpl<N> extends HelmChartRepositoryStatusFluentImpl<LocalSubjectAccessReviewFluent.HelmChartRepositoryStatusContentNested<N>> implements LocalSubjectAccessReviewFluent.HelmChartRepositoryStatusContentNested<N>,Nested<N>{
    HelmChartRepositoryStatusContentNestedImpl(HelmChartRepositoryStatus item) {
      this.builder = new HelmChartRepositoryStatusBuilder(this, item);
    }
    HelmChartRepositoryStatusContentNestedImpl() {
      this.builder = new HelmChartRepositoryStatusBuilder(this);
    }
    HelmChartRepositoryStatusBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endHelmChartRepositoryStatusContent() {
      return and();
    }
    
  }
  class DeploymentConfigSpecContentNestedImpl<N> extends DeploymentConfigSpecFluentImpl<LocalSubjectAccessReviewFluent.DeploymentConfigSpecContentNested<N>> implements LocalSubjectAccessReviewFluent.DeploymentConfigSpecContentNested<N>,Nested<N>{
    DeploymentConfigSpecContentNestedImpl(DeploymentConfigSpec item) {
      this.builder = new DeploymentConfigSpecBuilder(this, item);
    }
    DeploymentConfigSpecContentNestedImpl() {
      this.builder = new DeploymentConfigSpecBuilder(this);
    }
    DeploymentConfigSpecBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endDeploymentConfigSpecContent() {
      return and();
    }
    
  }
  class HostSubnetContentNestedImpl<N> extends HostSubnetFluentImpl<LocalSubjectAccessReviewFluent.HostSubnetContentNested<N>> implements LocalSubjectAccessReviewFluent.HostSubnetContentNested<N>,Nested<N>{
    HostSubnetContentNestedImpl(HostSubnet item) {
      this.builder = new HostSubnetBuilder(this, item);
    }
    HostSubnetContentNestedImpl() {
      this.builder = new HostSubnetBuilder(this);
    }
    HostSubnetBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endHostSubnetContent() {
      return and();
    }
    
  }
  class GroupRestrictionContentNestedImpl<N> extends GroupRestrictionFluentImpl<LocalSubjectAccessReviewFluent.GroupRestrictionContentNested<N>> implements LocalSubjectAccessReviewFluent.GroupRestrictionContentNested<N>,Nested<N>{
    GroupRestrictionContentNestedImpl(GroupRestriction item) {
      this.builder = new GroupRestrictionBuilder(this, item);
    }
    GroupRestrictionContentNestedImpl() {
      this.builder = new GroupRestrictionBuilder(this);
    }
    GroupRestrictionBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endGroupRestrictionContent() {
      return and();
    }
    
  }
  class AppliedClusterResourceQuotaContentNestedImpl<N> extends AppliedClusterResourceQuotaFluentImpl<LocalSubjectAccessReviewFluent.AppliedClusterResourceQuotaContentNested<N>> implements LocalSubjectAccessReviewFluent.AppliedClusterResourceQuotaContentNested<N>,Nested<N>{
    AppliedClusterResourceQuotaContentNestedImpl(AppliedClusterResourceQuota item) {
      this.builder = new AppliedClusterResourceQuotaBuilder(this, item);
    }
    AppliedClusterResourceQuotaContentNestedImpl() {
      this.builder = new AppliedClusterResourceQuotaBuilder(this);
    }
    AppliedClusterResourceQuotaBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endAppliedClusterResourceQuotaContent() {
      return and();
    }
    
  }
  class OAuthAccessTokenListContentNestedImpl<N> extends OAuthAccessTokenListFluentImpl<LocalSubjectAccessReviewFluent.OAuthAccessTokenListContentNested<N>> implements LocalSubjectAccessReviewFluent.OAuthAccessTokenListContentNested<N>,Nested<N>{
    OAuthAccessTokenListContentNestedImpl(OAuthAccessTokenList item) {
      this.builder = new OAuthAccessTokenListBuilder(this, item);
    }
    OAuthAccessTokenListContentNestedImpl() {
      this.builder = new OAuthAccessTokenListBuilder(this);
    }
    OAuthAccessTokenListBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endOAuthAccessTokenListContent() {
      return and();
    }
    
  }
  class JenkinsPipelineBuildStrategyContentNestedImpl<N> extends JenkinsPipelineBuildStrategyFluentImpl<LocalSubjectAccessReviewFluent.JenkinsPipelineBuildStrategyContentNested<N>> implements LocalSubjectAccessReviewFluent.JenkinsPipelineBuildStrategyContentNested<N>,Nested<N>{
    JenkinsPipelineBuildStrategyContentNestedImpl(JenkinsPipelineBuildStrategy item) {
      this.builder = new JenkinsPipelineBuildStrategyBuilder(this, item);
    }
    JenkinsPipelineBuildStrategyContentNestedImpl() {
      this.builder = new JenkinsPipelineBuildStrategyBuilder(this);
    }
    JenkinsPipelineBuildStrategyBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endJenkinsPipelineBuildStrategyContent() {
      return and();
    }
    
  }
  class SecurityContextConstraintsContentNestedImpl<N> extends SecurityContextConstraintsFluentImpl<LocalSubjectAccessReviewFluent.SecurityContextConstraintsContentNested<N>> implements LocalSubjectAccessReviewFluent.SecurityContextConstraintsContentNested<N>,Nested<N>{
    SecurityContextConstraintsContentNestedImpl(SecurityContextConstraints item) {
      this.builder = new SecurityContextConstraintsBuilder(this, item);
    }
    SecurityContextConstraintsContentNestedImpl() {
      this.builder = new SecurityContextConstraintsBuilder(this);
    }
    SecurityContextConstraintsBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endSecurityContextConstraintsContent() {
      return and();
    }
    
  }
  class SupplementalGroupsStrategyOptionsContentNestedImpl<N> extends SupplementalGroupsStrategyOptionsFluentImpl<LocalSubjectAccessReviewFluent.SupplementalGroupsStrategyOptionsContentNested<N>> implements LocalSubjectAccessReviewFluent.SupplementalGroupsStrategyOptionsContentNested<N>,Nested<N>{
    SupplementalGroupsStrategyOptionsContentNestedImpl(SupplementalGroupsStrategyOptions item) {
      this.builder = new SupplementalGroupsStrategyOptionsBuilder(this, item);
    }
    SupplementalGroupsStrategyOptionsContentNestedImpl() {
      this.builder = new SupplementalGroupsStrategyOptionsBuilder(this);
    }
    SupplementalGroupsStrategyOptionsBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endSupplementalGroupsStrategyOptionsContent() {
      return and();
    }
    
  }
  class ServiceAccountPodSecurityPolicyReviewStatusContentNestedImpl<N> extends ServiceAccountPodSecurityPolicyReviewStatusFluentImpl<LocalSubjectAccessReviewFluent.ServiceAccountPodSecurityPolicyReviewStatusContentNested<N>> implements LocalSubjectAccessReviewFluent.ServiceAccountPodSecurityPolicyReviewStatusContentNested<N>,Nested<N>{
    ServiceAccountPodSecurityPolicyReviewStatusContentNestedImpl(ServiceAccountPodSecurityPolicyReviewStatus item) {
      this.builder = new ServiceAccountPodSecurityPolicyReviewStatusBuilder(this, item);
    }
    ServiceAccountPodSecurityPolicyReviewStatusContentNestedImpl() {
      this.builder = new ServiceAccountPodSecurityPolicyReviewStatusBuilder(this);
    }
    ServiceAccountPodSecurityPolicyReviewStatusBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endServiceAccountPodSecurityPolicyReviewStatusContent() {
      return and();
    }
    
  }
  class BuildRequestContentNestedImpl<N> extends BuildRequestFluentImpl<LocalSubjectAccessReviewFluent.BuildRequestContentNested<N>> implements LocalSubjectAccessReviewFluent.BuildRequestContentNested<N>,Nested<N>{
    BuildRequestContentNestedImpl(BuildRequest item) {
      this.builder = new BuildRequestBuilder(this, item);
    }
    BuildRequestContentNestedImpl() {
      this.builder = new BuildRequestBuilder(this);
    }
    BuildRequestBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endBuildRequestContent() {
      return and();
    }
    
  }
  class SELinuxContextStrategyOptionsContentNestedImpl<N> extends SELinuxContextStrategyOptionsFluentImpl<LocalSubjectAccessReviewFluent.SELinuxContextStrategyOptionsContentNested<N>> implements LocalSubjectAccessReviewFluent.SELinuxContextStrategyOptionsContentNested<N>,Nested<N>{
    SELinuxContextStrategyOptionsContentNestedImpl(SELinuxContextStrategyOptions item) {
      this.builder = new SELinuxContextStrategyOptionsBuilder(this, item);
    }
    SELinuxContextStrategyOptionsContentNestedImpl() {
      this.builder = new SELinuxContextStrategyOptionsBuilder(this);
    }
    SELinuxContextStrategyOptionsBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endSELinuxContextStrategyOptionsContent() {
      return and();
    }
    
  }
  class ClusterRoleListContentNestedImpl<N> extends ClusterRoleListFluentImpl<LocalSubjectAccessReviewFluent.ClusterRoleListContentNested<N>> implements LocalSubjectAccessReviewFluent.ClusterRoleListContentNested<N>,Nested<N>{
    ClusterRoleListContentNestedImpl(ClusterRoleList item) {
      this.builder = new ClusterRoleListBuilder(this, item);
    }
    ClusterRoleListContentNestedImpl() {
      this.builder = new ClusterRoleListBuilder(this);
    }
    ClusterRoleListBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endClusterRoleListContent() {
      return and();
    }
    
  }
  class RouteListContentNestedImpl<N> extends RouteListFluentImpl<LocalSubjectAccessReviewFluent.RouteListContentNested<N>> implements LocalSubjectAccessReviewFluent.RouteListContentNested<N>,Nested<N>{
    RouteListContentNestedImpl(RouteList item) {
      this.builder = new RouteListBuilder(this, item);
    }
    RouteListContentNestedImpl() {
      this.builder = new RouteListBuilder(this);
    }
    RouteListBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endRouteListContent() {
      return and();
    }
    
  }
  class ImageStreamStatusContentNestedImpl<N> extends ImageStreamStatusFluentImpl<LocalSubjectAccessReviewFluent.ImageStreamStatusContentNested<N>> implements LocalSubjectAccessReviewFluent.ImageStreamStatusContentNested<N>,Nested<N>{
    ImageStreamStatusContentNestedImpl(ImageStreamStatus item) {
      this.builder = new ImageStreamStatusBuilder(this, item);
    }
    ImageStreamStatusContentNestedImpl() {
      this.builder = new ImageStreamStatusBuilder(this);
    }
    ImageStreamStatusBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endImageStreamStatusContent() {
      return and();
    }
    
  }
  class EgressNetworkPolicyContentNestedImpl<N> extends EgressNetworkPolicyFluentImpl<LocalSubjectAccessReviewFluent.EgressNetworkPolicyContentNested<N>> implements LocalSubjectAccessReviewFluent.EgressNetworkPolicyContentNested<N>,Nested<N>{
    EgressNetworkPolicyContentNestedImpl(EgressNetworkPolicy item) {
      this.builder = new EgressNetworkPolicyBuilder(this, item);
    }
    EgressNetworkPolicyContentNestedImpl() {
      this.builder = new EgressNetworkPolicyBuilder(this);
    }
    EgressNetworkPolicyBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endEgressNetworkPolicyContent() {
      return and();
    }
    
  }
  class NetNamespaceContentNestedImpl<N> extends NetNamespaceFluentImpl<LocalSubjectAccessReviewFluent.NetNamespaceContentNested<N>> implements LocalSubjectAccessReviewFluent.NetNamespaceContentNested<N>,Nested<N>{
    NetNamespaceContentNestedImpl(NetNamespace item) {
      this.builder = new NetNamespaceBuilder(this, item);
    }
    NetNamespaceContentNestedImpl() {
      this.builder = new NetNamespaceBuilder(this);
    }
    NetNamespaceBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endNetNamespaceContent() {
      return and();
    }
    
  }
  class UserIdentityMappingContentNestedImpl<N> extends UserIdentityMappingFluentImpl<LocalSubjectAccessReviewFluent.UserIdentityMappingContentNested<N>> implements LocalSubjectAccessReviewFluent.UserIdentityMappingContentNested<N>,Nested<N>{
    UserIdentityMappingContentNestedImpl(UserIdentityMapping item) {
      this.builder = new UserIdentityMappingBuilder(this, item);
    }
    UserIdentityMappingContentNestedImpl() {
      this.builder = new UserIdentityMappingBuilder(this);
    }
    UserIdentityMappingBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endUserIdentityMappingContent() {
      return and();
    }
    
  }
  class DeploymentDetailsContentNestedImpl<N> extends DeploymentDetailsFluentImpl<LocalSubjectAccessReviewFluent.DeploymentDetailsContentNested<N>> implements LocalSubjectAccessReviewFluent.DeploymentDetailsContentNested<N>,Nested<N>{
    DeploymentDetailsContentNestedImpl(DeploymentDetails item) {
      this.builder = new DeploymentDetailsBuilder(this, item);
    }
    DeploymentDetailsContentNestedImpl() {
      this.builder = new DeploymentDetailsBuilder(this);
    }
    DeploymentDetailsBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endDeploymentDetailsContent() {
      return and();
    }
    
  }
  class PodSecurityPolicySubjectReviewStatusContentNestedImpl<N> extends PodSecurityPolicySubjectReviewStatusFluentImpl<LocalSubjectAccessReviewFluent.PodSecurityPolicySubjectReviewStatusContentNested<N>> implements LocalSubjectAccessReviewFluent.PodSecurityPolicySubjectReviewStatusContentNested<N>,Nested<N>{
    PodSecurityPolicySubjectReviewStatusContentNestedImpl(PodSecurityPolicySubjectReviewStatus item) {
      this.builder = new PodSecurityPolicySubjectReviewStatusBuilder(this, item);
    }
    PodSecurityPolicySubjectReviewStatusContentNestedImpl() {
      this.builder = new PodSecurityPolicySubjectReviewStatusBuilder(this);
    }
    PodSecurityPolicySubjectReviewStatusBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endPodSecurityPolicySubjectReviewStatusContent() {
      return and();
    }
    
  }
  class PodSecurityPolicySubjectReviewSpecContentNestedImpl<N> extends PodSecurityPolicySubjectReviewSpecFluentImpl<LocalSubjectAccessReviewFluent.PodSecurityPolicySubjectReviewSpecContentNested<N>> implements LocalSubjectAccessReviewFluent.PodSecurityPolicySubjectReviewSpecContentNested<N>,Nested<N>{
    PodSecurityPolicySubjectReviewSpecContentNestedImpl(PodSecurityPolicySubjectReviewSpec item) {
      this.builder = new PodSecurityPolicySubjectReviewSpecBuilder(this, item);
    }
    PodSecurityPolicySubjectReviewSpecContentNestedImpl() {
      this.builder = new PodSecurityPolicySubjectReviewSpecBuilder(this);
    }
    PodSecurityPolicySubjectReviewSpecBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endPodSecurityPolicySubjectReviewSpecContent() {
      return and();
    }
    
  }
  class ImageStreamContentNestedImpl<N> extends ImageStreamFluentImpl<LocalSubjectAccessReviewFluent.ImageStreamContentNested<N>> implements LocalSubjectAccessReviewFluent.ImageStreamContentNested<N>,Nested<N>{
    ImageStreamContentNestedImpl(ImageStream item) {
      this.builder = new ImageStreamBuilder(this, item);
    }
    ImageStreamContentNestedImpl() {
      this.builder = new ImageStreamBuilder(this);
    }
    ImageStreamBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endImageStreamContent() {
      return and();
    }
    
  }
  class BuildListContentNestedImpl<N> extends BuildListFluentImpl<LocalSubjectAccessReviewFluent.BuildListContentNested<N>> implements LocalSubjectAccessReviewFluent.BuildListContentNested<N>,Nested<N>{
    BuildListContentNestedImpl(BuildList item) {
      this.builder = new BuildListBuilder(this, item);
    }
    BuildListContentNestedImpl() {
      this.builder = new BuildListBuilder(this);
    }
    BuildListBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endBuildListContent() {
      return and();
    }
    
  }
  class TemplateListContentNestedImpl<N> extends TemplateListFluentImpl<LocalSubjectAccessReviewFluent.TemplateListContentNested<N>> implements LocalSubjectAccessReviewFluent.TemplateListContentNested<N>,Nested<N>{
    TemplateListContentNestedImpl(TemplateList item) {
      this.builder = new TemplateListBuilder(this, item);
    }
    TemplateListContentNestedImpl() {
      this.builder = new TemplateListBuilder(this);
    }
    TemplateListBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endTemplateListContent() {
      return and();
    }
    
  }
  class BuildOutputContentNestedImpl<N> extends BuildOutputFluentImpl<LocalSubjectAccessReviewFluent.BuildOutputContentNested<N>> implements LocalSubjectAccessReviewFluent.BuildOutputContentNested<N>,Nested<N>{
    BuildOutputContentNestedImpl(BuildOutput item) {
      this.builder = new BuildOutputBuilder(this, item);
    }
    BuildOutputContentNestedImpl() {
      this.builder = new BuildOutputBuilder(this);
    }
    BuildOutputBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endBuildOutputContent() {
      return and();
    }
    
  }
  class ProjectSpecContentNestedImpl<N> extends ProjectSpecFluentImpl<LocalSubjectAccessReviewFluent.ProjectSpecContentNested<N>> implements LocalSubjectAccessReviewFluent.ProjectSpecContentNested<N>,Nested<N>{
    ProjectSpecContentNestedImpl(ProjectSpec item) {
      this.builder = new ProjectSpecBuilder(this, item);
    }
    ProjectSpecContentNestedImpl() {
      this.builder = new ProjectSpecBuilder(this);
    }
    ProjectSpecBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endProjectSpecContent() {
      return and();
    }
    
  }
  class SourceRevisionContentNestedImpl<N> extends SourceRevisionFluentImpl<LocalSubjectAccessReviewFluent.SourceRevisionContentNested<N>> implements LocalSubjectAccessReviewFluent.SourceRevisionContentNested<N>,Nested<N>{
    SourceRevisionContentNestedImpl(SourceRevision item) {
      this.builder = new SourceRevisionBuilder(this, item);
    }
    SourceRevisionContentNestedImpl() {
      this.builder = new SourceRevisionBuilder(this);
    }
    SourceRevisionBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endSourceRevisionContent() {
      return and();
    }
    
  }
  class ObjectReferenceContentNestedImpl<N> extends ObjectReferenceFluentImpl<LocalSubjectAccessReviewFluent.ObjectReferenceContentNested<N>> implements LocalSubjectAccessReviewFluent.ObjectReferenceContentNested<N>,Nested<N>{
    ObjectReferenceContentNestedImpl(ObjectReference item) {
      this.builder = new ObjectReferenceBuilder(this, item);
    }
    ObjectReferenceContentNestedImpl() {
      this.builder = new ObjectReferenceBuilder(this);
    }
    ObjectReferenceBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endObjectReferenceContent() {
      return and();
    }
    
  }
  class SignatureIssuerContentNestedImpl<N> extends SignatureIssuerFluentImpl<LocalSubjectAccessReviewFluent.SignatureIssuerContentNested<N>> implements LocalSubjectAccessReviewFluent.SignatureIssuerContentNested<N>,Nested<N>{
    SignatureIssuerContentNestedImpl(SignatureIssuer item) {
      this.builder = new SignatureIssuerBuilder(this, item);
    }
    SignatureIssuerContentNestedImpl() {
      this.builder = new SignatureIssuerBuilder(this);
    }
    SignatureIssuerBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endSignatureIssuerContent() {
      return and();
    }
    
  }
  class ImageLayerContentNestedImpl<N> extends ImageLayerFluentImpl<LocalSubjectAccessReviewFluent.ImageLayerContentNested<N>> implements LocalSubjectAccessReviewFluent.ImageLayerContentNested<N>,Nested<N>{
    ImageLayerContentNestedImpl(ImageLayer item) {
      this.builder = new ImageLayerBuilder(this, item);
    }
    ImageLayerContentNestedImpl() {
      this.builder = new ImageLayerBuilder(this);
    }
    ImageLayerBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endImageLayerContent() {
      return and();
    }
    
  }
  class ClusterResourceQuotaSpecContentNestedImpl<N> extends ClusterResourceQuotaSpecFluentImpl<LocalSubjectAccessReviewFluent.ClusterResourceQuotaSpecContentNested<N>> implements LocalSubjectAccessReviewFluent.ClusterResourceQuotaSpecContentNested<N>,Nested<N>{
    ClusterResourceQuotaSpecContentNestedImpl(ClusterResourceQuotaSpec item) {
      this.builder = new ClusterResourceQuotaSpecBuilder(this, item);
    }
    ClusterResourceQuotaSpecContentNestedImpl() {
      this.builder = new ClusterResourceQuotaSpecBuilder(this);
    }
    ClusterResourceQuotaSpecBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endClusterResourceQuotaSpecContent() {
      return and();
    }
    
  }
  class ImageStreamSpecContentNestedImpl<N> extends ImageStreamSpecFluentImpl<LocalSubjectAccessReviewFluent.ImageStreamSpecContentNested<N>> implements LocalSubjectAccessReviewFluent.ImageStreamSpecContentNested<N>,Nested<N>{
    ImageStreamSpecContentNestedImpl(ImageStreamSpec item) {
      this.builder = new ImageStreamSpecBuilder(this, item);
    }
    ImageStreamSpecContentNestedImpl() {
      this.builder = new ImageStreamSpecBuilder(this);
    }
    ImageStreamSpecBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endImageStreamSpecContent() {
      return and();
    }
    
  }
  class RouteIngressContentNestedImpl<N> extends RouteIngressFluentImpl<LocalSubjectAccessReviewFluent.RouteIngressContentNested<N>> implements LocalSubjectAccessReviewFluent.RouteIngressContentNested<N>,Nested<N>{
    RouteIngressContentNestedImpl(RouteIngress item) {
      this.builder = new RouteIngressBuilder(this, item);
    }
    RouteIngressContentNestedImpl() {
      this.builder = new RouteIngressBuilder(this);
    }
    RouteIngressBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endRouteIngressContent() {
      return and();
    }
    
  }
  class OAuthClientContentNestedImpl<N> extends OAuthClientFluentImpl<LocalSubjectAccessReviewFluent.OAuthClientContentNested<N>> implements LocalSubjectAccessReviewFluent.OAuthClientContentNested<N>,Nested<N>{
    OAuthClientContentNestedImpl(OAuthClient item) {
      this.builder = new OAuthClientBuilder(this, item);
    }
    OAuthClientContentNestedImpl() {
      this.builder = new OAuthClientBuilder(this);
    }
    OAuthClientBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endOAuthClientContent() {
      return and();
    }
    
  }
  class IdentityContentNestedImpl<N> extends IdentityFluentImpl<LocalSubjectAccessReviewFluent.IdentityContentNested<N>> implements LocalSubjectAccessReviewFluent.IdentityContentNested<N>,Nested<N>{
    IdentityContentNestedImpl(Identity item) {
      this.builder = new IdentityBuilder(this, item);
    }
    IdentityContentNestedImpl() {
      this.builder = new IdentityBuilder(this);
    }
    IdentityBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endIdentityContent() {
      return and();
    }
    
  }
  class RangeAllocationListContentNestedImpl<N> extends RangeAllocationListFluentImpl<LocalSubjectAccessReviewFluent.RangeAllocationListContentNested<N>> implements LocalSubjectAccessReviewFluent.RangeAllocationListContentNested<N>,Nested<N>{
    RangeAllocationListContentNestedImpl(RangeAllocationList item) {
      this.builder = new RangeAllocationListBuilder(this, item);
    }
    RangeAllocationListContentNestedImpl() {
      this.builder = new RangeAllocationListBuilder(this);
    }
    RangeAllocationListBuilder builder;
    public N and() {
      return (N) LocalSubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endRangeAllocationListContent() {
      return and();
    }
    
  }
  
}