package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public interface IdentityListFluent<A extends IdentityListFluent<A>> extends Fluent<A>{
  public String getApiVersion();
  public A withApiVersion(String apiVersion);
  public Boolean hasApiVersion();
  public A addToItems(Integer index,Identity item);
  public A setToItems(Integer index,Identity item);
  public A addToItems(io.fabric8.openshift.api.model.Identity... items);
  public A addAllToItems(Collection<Identity> items);
  public A removeFromItems(io.fabric8.openshift.api.model.Identity... items);
  public A removeAllFromItems(Collection<Identity> items);
  public A removeMatchingFromItems(Predicate<IdentityBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildItems instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<Identity> getItems();
  public List<Identity> buildItems();
  public Identity buildItem(Integer index);
  public Identity buildFirstItem();
  public Identity buildLastItem();
  public Identity buildMatchingItem(Predicate<IdentityBuilder> predicate);
  public Boolean hasMatchingItem(Predicate<IdentityBuilder> predicate);
  public A withItems(List<Identity> items);
  public A withItems(io.fabric8.openshift.api.model.Identity... items);
  public Boolean hasItems();
  public IdentityListFluent.ItemsNested<A> addNewItem();
  public IdentityListFluent.ItemsNested<A> addNewItemLike(Identity item);
  public IdentityListFluent.ItemsNested<A> setNewItemLike(Integer index,Identity item);
  public IdentityListFluent.ItemsNested<A> editItem(Integer index);
  public IdentityListFluent.ItemsNested<A> editFirstItem();
  public IdentityListFluent.ItemsNested<A> editLastItem();
  public IdentityListFluent.ItemsNested<A> editMatchingItem(Predicate<IdentityBuilder> predicate);
  public String getKind();
  public A withKind(String kind);
  public Boolean hasKind();
  public ListMeta getMetadata();
  public A withMetadata(ListMeta metadata);
  public Boolean hasMetadata();
  public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink);
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public interface ItemsNested<N> extends Nested<N>,IdentityFluent<IdentityListFluent.ItemsNested<N>>{
    public N and();
    public N endItem();
    
  }
  
}