/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.openshift.api.model.TagImportPolicy;
import io.fabric8.openshift.api.model.TagImportPolicyBuilder;
import io.fabric8.openshift.api.model.TagImportPolicyFluent;
import io.fabric8.openshift.api.model.TagReference;
import io.fabric8.openshift.api.model.TagReferencePolicy;
import io.fabric8.openshift.api.model.TagReferencePolicyBuilder;
import io.fabric8.openshift.api.model.TagReferencePolicyFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class TagReferenceFluent<A extends TagReferenceFluent<A>>
extends BaseFluent<A> {
    private Map<String, String> annotations;
    private ObjectReferenceBuilder from;
    private Long generation;
    private TagImportPolicyBuilder importPolicy;
    private String name;
    private Boolean reference;
    private TagReferencePolicyBuilder referencePolicy;
    private Map<String, Object> additionalProperties;

    public TagReferenceFluent() {
    }

    public TagReferenceFluent(TagReference instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(TagReference instance) {
        TagReference tagReference = instance = instance != null ? instance : new TagReference();
        if (instance != null) {
            this.withAnnotations(instance.getAnnotations());
            this.withFrom(instance.getFrom());
            this.withGeneration(instance.getGeneration());
            this.withImportPolicy(instance.getImportPolicy());
            this.withName(instance.getName());
            this.withReference(instance.getReference());
            this.withReferencePolicy(instance.getReferencePolicy());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToAnnotations(String key, String value) {
        if (this.annotations == null && key != null && value != null) {
            this.annotations = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.annotations.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAnnotations(Map<String, String> map) {
        if (this.annotations == null && map != null) {
            this.annotations = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.annotations.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAnnotations(String key) {
        if (this.annotations == null) {
            return (A)((Object)this);
        }
        if (key != null && this.annotations != null) {
            this.annotations.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAnnotations(Map<String, String> map) {
        if (this.annotations == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.annotations == null) continue;
                this.annotations.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, String> getAnnotations() {
        return this.annotations;
    }

    public <K, V> A withAnnotations(Map<String, String> annotations) {
        this.annotations = annotations == null ? null : new LinkedHashMap<String, String>(annotations);
        return (A)((Object)this);
    }

    public boolean hasAnnotations() {
        return this.annotations != null;
    }

    public ObjectReference buildFrom() {
        return this.from != null ? this.from.build() : null;
    }

    public A withFrom(ObjectReference from) {
        this._visitables.remove((Object)"from");
        if (from != null) {
            this.from = new ObjectReferenceBuilder(from);
            this._visitables.get((Object)"from").add(this.from);
        } else {
            this.from = null;
            this._visitables.get((Object)"from").remove(this.from);
        }
        return (A)((Object)this);
    }

    public boolean hasFrom() {
        return this.from != null;
    }

    public FromNested<A> withNewFrom() {
        return new FromNested(null);
    }

    public FromNested<A> withNewFromLike(ObjectReference item) {
        return new FromNested(item);
    }

    public FromNested<A> editFrom() {
        return this.withNewFromLike(Optional.ofNullable(this.buildFrom()).orElse(null));
    }

    public FromNested<A> editOrNewFrom() {
        return this.withNewFromLike(Optional.ofNullable(this.buildFrom()).orElse(new ObjectReferenceBuilder().build()));
    }

    public FromNested<A> editOrNewFromLike(ObjectReference item) {
        return this.withNewFromLike(Optional.ofNullable(this.buildFrom()).orElse(item));
    }

    public Long getGeneration() {
        return this.generation;
    }

    public A withGeneration(Long generation) {
        this.generation = generation;
        return (A)((Object)this);
    }

    public boolean hasGeneration() {
        return this.generation != null;
    }

    public TagImportPolicy buildImportPolicy() {
        return this.importPolicy != null ? this.importPolicy.build() : null;
    }

    public A withImportPolicy(TagImportPolicy importPolicy) {
        this._visitables.remove((Object)"importPolicy");
        if (importPolicy != null) {
            this.importPolicy = new TagImportPolicyBuilder(importPolicy);
            this._visitables.get((Object)"importPolicy").add(this.importPolicy);
        } else {
            this.importPolicy = null;
            this._visitables.get((Object)"importPolicy").remove((Object)this.importPolicy);
        }
        return (A)((Object)this);
    }

    public boolean hasImportPolicy() {
        return this.importPolicy != null;
    }

    public A withNewImportPolicy(String importMode, Boolean insecure, Boolean scheduled) {
        return this.withImportPolicy(new TagImportPolicy(importMode, insecure, scheduled));
    }

    public ImportPolicyNested<A> withNewImportPolicy() {
        return new ImportPolicyNested(null);
    }

    public ImportPolicyNested<A> withNewImportPolicyLike(TagImportPolicy item) {
        return new ImportPolicyNested(item);
    }

    public ImportPolicyNested<A> editImportPolicy() {
        return this.withNewImportPolicyLike(Optional.ofNullable(this.buildImportPolicy()).orElse(null));
    }

    public ImportPolicyNested<A> editOrNewImportPolicy() {
        return this.withNewImportPolicyLike(Optional.ofNullable(this.buildImportPolicy()).orElse(new TagImportPolicyBuilder().build()));
    }

    public ImportPolicyNested<A> editOrNewImportPolicyLike(TagImportPolicy item) {
        return this.withNewImportPolicyLike(Optional.ofNullable(this.buildImportPolicy()).orElse(item));
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name = name;
        return (A)((Object)this);
    }

    public boolean hasName() {
        return this.name != null;
    }

    public Boolean getReference() {
        return this.reference;
    }

    public A withReference(Boolean reference) {
        this.reference = reference;
        return (A)((Object)this);
    }

    public boolean hasReference() {
        return this.reference != null;
    }

    public TagReferencePolicy buildReferencePolicy() {
        return this.referencePolicy != null ? this.referencePolicy.build() : null;
    }

    public A withReferencePolicy(TagReferencePolicy referencePolicy) {
        this._visitables.remove((Object)"referencePolicy");
        if (referencePolicy != null) {
            this.referencePolicy = new TagReferencePolicyBuilder(referencePolicy);
            this._visitables.get((Object)"referencePolicy").add(this.referencePolicy);
        } else {
            this.referencePolicy = null;
            this._visitables.get((Object)"referencePolicy").remove((Object)this.referencePolicy);
        }
        return (A)((Object)this);
    }

    public boolean hasReferencePolicy() {
        return this.referencePolicy != null;
    }

    public A withNewReferencePolicy(String type) {
        return this.withReferencePolicy(new TagReferencePolicy(type));
    }

    public ReferencePolicyNested<A> withNewReferencePolicy() {
        return new ReferencePolicyNested(null);
    }

    public ReferencePolicyNested<A> withNewReferencePolicyLike(TagReferencePolicy item) {
        return new ReferencePolicyNested(item);
    }

    public ReferencePolicyNested<A> editReferencePolicy() {
        return this.withNewReferencePolicyLike(Optional.ofNullable(this.buildReferencePolicy()).orElse(null));
    }

    public ReferencePolicyNested<A> editOrNewReferencePolicy() {
        return this.withNewReferencePolicyLike(Optional.ofNullable(this.buildReferencePolicy()).orElse(new TagReferencePolicyBuilder().build()));
    }

    public ReferencePolicyNested<A> editOrNewReferencePolicyLike(TagReferencePolicy item) {
        return this.withNewReferencePolicyLike(Optional.ofNullable(this.buildReferencePolicy()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TagReferenceFluent that = (TagReferenceFluent)((Object)o);
        if (!Objects.equals(this.annotations, that.annotations)) {
            return false;
        }
        if (!Objects.equals(this.from, that.from)) {
            return false;
        }
        if (!Objects.equals(this.generation, that.generation)) {
            return false;
        }
        if (!Objects.equals((Object)this.importPolicy, (Object)that.importPolicy)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.reference, that.reference)) {
            return false;
        }
        if (!Objects.equals((Object)this.referencePolicy, (Object)that.referencePolicy)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.annotations, this.from, this.generation, this.importPolicy, this.name, this.reference, this.referencePolicy, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.annotations != null && !this.annotations.isEmpty()) {
            sb.append("annotations:");
            sb.append(this.annotations + ",");
        }
        if (this.from != null) {
            sb.append("from:");
            sb.append(this.from + ",");
        }
        if (this.generation != null) {
            sb.append("generation:");
            sb.append(this.generation + ",");
        }
        if (this.importPolicy != null) {
            sb.append("importPolicy:");
            sb.append((Object)((Object)this.importPolicy) + ",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.reference != null) {
            sb.append("reference:");
            sb.append(this.reference + ",");
        }
        if (this.referencePolicy != null) {
            sb.append("referencePolicy:");
            sb.append((Object)((Object)this.referencePolicy) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withReference() {
        return this.withReference(true);
    }

    public class ReferencePolicyNested<N>
    extends TagReferencePolicyFluent<ReferencePolicyNested<N>>
    implements Nested<N> {
        TagReferencePolicyBuilder builder;

        ReferencePolicyNested(TagReferencePolicy item) {
            this.builder = new TagReferencePolicyBuilder(this, item);
        }

        public N and() {
            return (N)TagReferenceFluent.this.withReferencePolicy(this.builder.build());
        }

        public N endReferencePolicy() {
            return this.and();
        }
    }

    public class ImportPolicyNested<N>
    extends TagImportPolicyFluent<ImportPolicyNested<N>>
    implements Nested<N> {
        TagImportPolicyBuilder builder;

        ImportPolicyNested(TagImportPolicy item) {
            this.builder = new TagImportPolicyBuilder(this, item);
        }

        public N and() {
            return (N)TagReferenceFluent.this.withImportPolicy(this.builder.build());
        }

        public N endImportPolicy() {
            return this.and();
        }
    }

    public class FromNested<N>
    extends ObjectReferenceFluent<FromNested<N>>
    implements Nested<N> {
        ObjectReferenceBuilder builder;

        FromNested(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder((ObjectReferenceFluent)this, item);
        }

        public N and() {
            return (N)TagReferenceFluent.this.withFrom(this.builder.build());
        }

        public N endFrom() {
            return this.and();
        }
    }
}

