/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluentImpl;
import io.fabric8.openshift.api.model.PodSecurityPolicyReviewSpec;
import io.fabric8.openshift.api.model.PodSecurityPolicyReviewSpecFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class PodSecurityPolicyReviewSpecFluentImpl<A extends PodSecurityPolicyReviewSpecFluent<A>>
extends BaseFluent<A>
implements PodSecurityPolicyReviewSpecFluent<A> {
    private List<String> serviceAccountNames = new ArrayList<String>();
    private PodTemplateSpecBuilder template;
    private Map<String, Object> additionalProperties;

    public PodSecurityPolicyReviewSpecFluentImpl() {
    }

    public PodSecurityPolicyReviewSpecFluentImpl(PodSecurityPolicyReviewSpec instance) {
        this.withServiceAccountNames(instance.getServiceAccountNames());
        this.withTemplate(instance.getTemplate());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public A addToServiceAccountNames(Integer index, String item) {
        if (this.serviceAccountNames == null) {
            this.serviceAccountNames = new ArrayList<String>();
        }
        this.serviceAccountNames.add(index, item);
        return (A)this;
    }

    @Override
    public A setToServiceAccountNames(Integer index, String item) {
        if (this.serviceAccountNames == null) {
            this.serviceAccountNames = new ArrayList<String>();
        }
        this.serviceAccountNames.set(index, item);
        return (A)this;
    }

    @Override
    public A addToServiceAccountNames(String ... items) {
        if (this.serviceAccountNames == null) {
            this.serviceAccountNames = new ArrayList<String>();
        }
        for (String item : items) {
            this.serviceAccountNames.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToServiceAccountNames(Collection<String> items) {
        if (this.serviceAccountNames == null) {
            this.serviceAccountNames = new ArrayList<String>();
        }
        for (String item : items) {
            this.serviceAccountNames.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromServiceAccountNames(String ... items) {
        for (String item : items) {
            if (this.serviceAccountNames == null) continue;
            this.serviceAccountNames.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromServiceAccountNames(Collection<String> items) {
        for (String item : items) {
            if (this.serviceAccountNames == null) continue;
            this.serviceAccountNames.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getServiceAccountNames() {
        return this.serviceAccountNames;
    }

    @Override
    public String getServiceAccountName(Integer index) {
        return this.serviceAccountNames.get(index);
    }

    @Override
    public String getFirstServiceAccountName() {
        return this.serviceAccountNames.get(0);
    }

    @Override
    public String getLastServiceAccountName() {
        return this.serviceAccountNames.get(this.serviceAccountNames.size() - 1);
    }

    @Override
    public String getMatchingServiceAccountName(Predicate<String> predicate) {
        for (String item : this.serviceAccountNames) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingServiceAccountName(Predicate<String> predicate) {
        for (String item : this.serviceAccountNames) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withServiceAccountNames(List<String> serviceAccountNames) {
        if (serviceAccountNames != null) {
            this.serviceAccountNames = new ArrayList<String>();
            for (String item : serviceAccountNames) {
                this.addToServiceAccountNames(item);
            }
        } else {
            this.serviceAccountNames = null;
        }
        return (A)this;
    }

    @Override
    public A withServiceAccountNames(String ... serviceAccountNames) {
        if (this.serviceAccountNames != null) {
            this.serviceAccountNames.clear();
        }
        if (serviceAccountNames != null) {
            for (String item : serviceAccountNames) {
                this.addToServiceAccountNames(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasServiceAccountNames() {
        return this.serviceAccountNames != null && !this.serviceAccountNames.isEmpty();
    }

    @Override
    @Deprecated
    public PodTemplateSpec getTemplate() {
        return this.template != null ? this.template.build() : null;
    }

    @Override
    public PodTemplateSpec buildTemplate() {
        return this.template != null ? this.template.build() : null;
    }

    @Override
    public A withTemplate(PodTemplateSpec template) {
        this._visitables.get((Object)"template").remove(this.template);
        if (template != null) {
            this.template = new PodTemplateSpecBuilder(template);
            this._visitables.get((Object)"template").add(this.template);
        }
        return (A)this;
    }

    @Override
    public Boolean hasTemplate() {
        return this.template != null;
    }

    @Override
    public PodSecurityPolicyReviewSpecFluent.TemplateNested<A> withNewTemplate() {
        return new TemplateNestedImpl();
    }

    @Override
    public PodSecurityPolicyReviewSpecFluent.TemplateNested<A> withNewTemplateLike(PodTemplateSpec item) {
        return new TemplateNestedImpl(item);
    }

    @Override
    public PodSecurityPolicyReviewSpecFluent.TemplateNested<A> editTemplate() {
        return this.withNewTemplateLike(this.getTemplate());
    }

    @Override
    public PodSecurityPolicyReviewSpecFluent.TemplateNested<A> editOrNewTemplate() {
        return this.withNewTemplateLike(this.getTemplate() != null ? this.getTemplate() : new PodTemplateSpecBuilder().build());
    }

    @Override
    public PodSecurityPolicyReviewSpecFluent.TemplateNested<A> editOrNewTemplateLike(PodTemplateSpec item) {
        return this.withNewTemplateLike(this.getTemplate() != null ? this.getTemplate() : item);
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PodSecurityPolicyReviewSpecFluentImpl that = (PodSecurityPolicyReviewSpecFluentImpl)o;
        if (this.serviceAccountNames != null ? !this.serviceAccountNames.equals(that.serviceAccountNames) : that.serviceAccountNames != null) {
            return false;
        }
        if (this.template != null ? !this.template.equals((Object)that.template) : that.template != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public int hashCode() {
        return Objects.hash(this.serviceAccountNames, this.template, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.serviceAccountNames != null && !this.serviceAccountNames.isEmpty()) {
            sb.append("serviceAccountNames:");
            sb.append(this.serviceAccountNames + ",");
        }
        if (this.template != null) {
            sb.append("template:");
            sb.append(this.template + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class TemplateNestedImpl<N>
    extends PodTemplateSpecFluentImpl<PodSecurityPolicyReviewSpecFluent.TemplateNested<N>>
    implements PodSecurityPolicyReviewSpecFluent.TemplateNested<N>,
    Nested<N> {
        PodTemplateSpecBuilder builder;

        TemplateNestedImpl(PodTemplateSpec item) {
            this.builder = new PodTemplateSpecBuilder((PodTemplateSpecFluent)this, item);
        }

        TemplateNestedImpl() {
            this.builder = new PodTemplateSpecBuilder((PodTemplateSpecFluent)this);
        }

        @Override
        public N and() {
            return (N)PodSecurityPolicyReviewSpecFluentImpl.this.withTemplate(this.builder.build());
        }

        @Override
        public N endTemplate() {
            return this.and();
        }
    }
}

