/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluentImpl;
import io.fabric8.openshift.api.model.SecretBuildSource;
import io.fabric8.openshift.api.model.SecretBuildSourceFluent;
import java.util.Objects;

public class SecretBuildSourceFluentImpl<A extends SecretBuildSourceFluent<A>>
extends BaseFluent<A>
implements SecretBuildSourceFluent<A> {
    private String destinationDir;
    private LocalObjectReferenceBuilder secret;

    public SecretBuildSourceFluentImpl() {
    }

    public SecretBuildSourceFluentImpl(SecretBuildSource instance) {
        this.withDestinationDir(instance.getDestinationDir());
        this.withSecret(instance.getSecret());
    }

    @Override
    public String getDestinationDir() {
        return this.destinationDir;
    }

    @Override
    public A withDestinationDir(String destinationDir) {
        this.destinationDir = destinationDir;
        return (A)this;
    }

    @Override
    public Boolean hasDestinationDir() {
        return this.destinationDir != null;
    }

    @Override
    @Deprecated
    public A withNewDestinationDir(String arg0) {
        return this.withDestinationDir(new String(arg0));
    }

    @Override
    @Deprecated
    public LocalObjectReference getSecret() {
        return this.secret != null ? this.secret.build() : null;
    }

    @Override
    public LocalObjectReference buildSecret() {
        return this.secret != null ? this.secret.build() : null;
    }

    @Override
    public A withSecret(LocalObjectReference secret) {
        this._visitables.get((Object)"secret").remove(this.secret);
        if (secret != null) {
            this.secret = new LocalObjectReferenceBuilder(secret);
            this._visitables.get((Object)"secret").add(this.secret);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSecret() {
        return this.secret != null;
    }

    @Override
    public A withNewSecret(String name) {
        return this.withSecret(new LocalObjectReference(name));
    }

    @Override
    public SecretBuildSourceFluent.SecretNested<A> withNewSecret() {
        return new SecretNestedImpl();
    }

    @Override
    public SecretBuildSourceFluent.SecretNested<A> withNewSecretLike(LocalObjectReference item) {
        return new SecretNestedImpl(item);
    }

    @Override
    public SecretBuildSourceFluent.SecretNested<A> editSecret() {
        return this.withNewSecretLike(this.getSecret());
    }

    @Override
    public SecretBuildSourceFluent.SecretNested<A> editOrNewSecret() {
        return this.withNewSecretLike(this.getSecret() != null ? this.getSecret() : new LocalObjectReferenceBuilder().build());
    }

    @Override
    public SecretBuildSourceFluent.SecretNested<A> editOrNewSecretLike(LocalObjectReference item) {
        return this.withNewSecretLike(this.getSecret() != null ? this.getSecret() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SecretBuildSourceFluentImpl that = (SecretBuildSourceFluentImpl)o;
        if (this.destinationDir != null ? !this.destinationDir.equals(that.destinationDir) : that.destinationDir != null) {
            return false;
        }
        return !(this.secret != null ? !this.secret.equals((Object)that.secret) : that.secret != null);
    }

    public int hashCode() {
        return Objects.hash(this.destinationDir, this.secret, super.hashCode());
    }

    public class SecretNestedImpl<N>
    extends LocalObjectReferenceFluentImpl<SecretBuildSourceFluent.SecretNested<N>>
    implements SecretBuildSourceFluent.SecretNested<N>,
    Nested<N> {
        LocalObjectReferenceBuilder builder;

        SecretNestedImpl(LocalObjectReference item) {
            this.builder = new LocalObjectReferenceBuilder((LocalObjectReferenceFluent)this, item);
        }

        SecretNestedImpl() {
            this.builder = new LocalObjectReferenceBuilder((LocalObjectReferenceFluent)this);
        }

        @Override
        public N and() {
            return (N)SecretBuildSourceFluentImpl.this.withSecret(this.builder.build());
        }

        @Override
        public N endSecret() {
            return this.and();
        }
    }
}

