/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import io.fabric8.openshift.api.model.BuildVolume;
import io.fabric8.openshift.api.model.BuildVolumeBuilder;
import io.fabric8.openshift.api.model.BuildVolumeFluentImpl;
import io.fabric8.openshift.api.model.SourceBuildStrategy;
import io.fabric8.openshift.api.model.SourceBuildStrategyFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class SourceBuildStrategyFluentImpl<A extends SourceBuildStrategyFluent<A>>
extends BaseFluent<A>
implements SourceBuildStrategyFluent<A> {
    private List<EnvVar> env = new ArrayList<EnvVar>();
    private Boolean forcePull;
    private ObjectReferenceBuilder from;
    private Boolean incremental;
    private LocalObjectReferenceBuilder pullSecret;
    private String scripts;
    private List<BuildVolumeBuilder> volumes = new ArrayList<BuildVolumeBuilder>();
    private Map<String, Object> additionalProperties;

    public SourceBuildStrategyFluentImpl() {
    }

    public SourceBuildStrategyFluentImpl(SourceBuildStrategy instance) {
        this.withEnv(instance.getEnv());
        this.withForcePull(instance.getForcePull());
        this.withFrom(instance.getFrom());
        this.withIncremental(instance.getIncremental());
        this.withPullSecret(instance.getPullSecret());
        this.withScripts(instance.getScripts());
        this.withVolumes(instance.getVolumes());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public A addToEnv(Integer index, EnvVar item) {
        if (this.env == null) {
            this.env = new ArrayList<EnvVar>();
        }
        this.env.add(index, item);
        return (A)this;
    }

    @Override
    public A setToEnv(Integer index, EnvVar item) {
        if (this.env == null) {
            this.env = new ArrayList<EnvVar>();
        }
        this.env.set(index, item);
        return (A)this;
    }

    @Override
    public A addToEnv(EnvVar ... items) {
        if (this.env == null) {
            this.env = new ArrayList<EnvVar>();
        }
        for (EnvVar item : items) {
            this.env.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToEnv(Collection<EnvVar> items) {
        if (this.env == null) {
            this.env = new ArrayList<EnvVar>();
        }
        for (EnvVar item : items) {
            this.env.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromEnv(EnvVar ... items) {
        for (EnvVar item : items) {
            if (this.env == null) continue;
            this.env.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromEnv(Collection<EnvVar> items) {
        for (EnvVar item : items) {
            if (this.env == null) continue;
            this.env.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<EnvVar> getEnv() {
        return this.env;
    }

    @Override
    public EnvVar getEnv(Integer index) {
        return this.env.get(index);
    }

    @Override
    public EnvVar getFirstEnv() {
        return this.env.get(0);
    }

    @Override
    public EnvVar getLastEnv() {
        return this.env.get(this.env.size() - 1);
    }

    @Override
    public EnvVar getMatchingEnv(Predicate<EnvVar> predicate) {
        for (EnvVar item : this.env) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingEnv(Predicate<EnvVar> predicate) {
        for (EnvVar item : this.env) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withEnv(List<EnvVar> env) {
        if (env != null) {
            this.env = new ArrayList<EnvVar>();
            for (EnvVar item : env) {
                this.addToEnv(item);
            }
        } else {
            this.env = null;
        }
        return (A)this;
    }

    @Override
    public A withEnv(EnvVar ... env) {
        if (this.env != null) {
            this.env.clear();
        }
        if (env != null) {
            for (EnvVar item : env) {
                this.addToEnv(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasEnv() {
        return this.env != null && !this.env.isEmpty();
    }

    @Override
    public Boolean getForcePull() {
        return this.forcePull;
    }

    @Override
    public A withForcePull(Boolean forcePull) {
        this.forcePull = forcePull;
        return (A)this;
    }

    @Override
    public Boolean hasForcePull() {
        return this.forcePull != null;
    }

    @Override
    @Deprecated
    public ObjectReference getFrom() {
        return this.from != null ? this.from.build() : null;
    }

    @Override
    public ObjectReference buildFrom() {
        return this.from != null ? this.from.build() : null;
    }

    @Override
    public A withFrom(ObjectReference from) {
        this._visitables.get((Object)"from").remove(this.from);
        if (from != null) {
            this.from = new ObjectReferenceBuilder(from);
            this._visitables.get((Object)"from").add(this.from);
        }
        return (A)this;
    }

    @Override
    public Boolean hasFrom() {
        return this.from != null;
    }

    @Override
    public SourceBuildStrategyFluent.FromNested<A> withNewFrom() {
        return new FromNestedImpl();
    }

    @Override
    public SourceBuildStrategyFluent.FromNested<A> withNewFromLike(ObjectReference item) {
        return new FromNestedImpl(item);
    }

    @Override
    public SourceBuildStrategyFluent.FromNested<A> editFrom() {
        return this.withNewFromLike(this.getFrom());
    }

    @Override
    public SourceBuildStrategyFluent.FromNested<A> editOrNewFrom() {
        return this.withNewFromLike(this.getFrom() != null ? this.getFrom() : new ObjectReferenceBuilder().build());
    }

    @Override
    public SourceBuildStrategyFluent.FromNested<A> editOrNewFromLike(ObjectReference item) {
        return this.withNewFromLike(this.getFrom() != null ? this.getFrom() : item);
    }

    @Override
    public Boolean getIncremental() {
        return this.incremental;
    }

    @Override
    public A withIncremental(Boolean incremental) {
        this.incremental = incremental;
        return (A)this;
    }

    @Override
    public Boolean hasIncremental() {
        return this.incremental != null;
    }

    @Override
    @Deprecated
    public LocalObjectReference getPullSecret() {
        return this.pullSecret != null ? this.pullSecret.build() : null;
    }

    @Override
    public LocalObjectReference buildPullSecret() {
        return this.pullSecret != null ? this.pullSecret.build() : null;
    }

    @Override
    public A withPullSecret(LocalObjectReference pullSecret) {
        this._visitables.get((Object)"pullSecret").remove(this.pullSecret);
        if (pullSecret != null) {
            this.pullSecret = new LocalObjectReferenceBuilder(pullSecret);
            this._visitables.get((Object)"pullSecret").add(this.pullSecret);
        }
        return (A)this;
    }

    @Override
    public Boolean hasPullSecret() {
        return this.pullSecret != null;
    }

    @Override
    public A withNewPullSecret(String name) {
        return this.withPullSecret(new LocalObjectReference(name));
    }

    @Override
    public SourceBuildStrategyFluent.PullSecretNested<A> withNewPullSecret() {
        return new PullSecretNestedImpl();
    }

    @Override
    public SourceBuildStrategyFluent.PullSecretNested<A> withNewPullSecretLike(LocalObjectReference item) {
        return new PullSecretNestedImpl(item);
    }

    @Override
    public SourceBuildStrategyFluent.PullSecretNested<A> editPullSecret() {
        return this.withNewPullSecretLike(this.getPullSecret());
    }

    @Override
    public SourceBuildStrategyFluent.PullSecretNested<A> editOrNewPullSecret() {
        return this.withNewPullSecretLike(this.getPullSecret() != null ? this.getPullSecret() : new LocalObjectReferenceBuilder().build());
    }

    @Override
    public SourceBuildStrategyFluent.PullSecretNested<A> editOrNewPullSecretLike(LocalObjectReference item) {
        return this.withNewPullSecretLike(this.getPullSecret() != null ? this.getPullSecret() : item);
    }

    @Override
    public String getScripts() {
        return this.scripts;
    }

    @Override
    public A withScripts(String scripts) {
        this.scripts = scripts;
        return (A)this;
    }

    @Override
    public Boolean hasScripts() {
        return this.scripts != null;
    }

    @Override
    @Deprecated
    public A withNewScripts(String arg0) {
        return this.withScripts(new String(arg0));
    }

    @Override
    public A addToVolumes(Integer index, BuildVolume item) {
        if (this.volumes == null) {
            this.volumes = new ArrayList<BuildVolumeBuilder>();
        }
        BuildVolumeBuilder builder = new BuildVolumeBuilder(item);
        this._visitables.get((Object)"volumes").add(index >= 0 ? index.intValue() : this._visitables.get((Object)"volumes").size(), builder);
        this.volumes.add(index >= 0 ? index.intValue() : this.volumes.size(), builder);
        return (A)this;
    }

    @Override
    public A setToVolumes(Integer index, BuildVolume item) {
        if (this.volumes == null) {
            this.volumes = new ArrayList<BuildVolumeBuilder>();
        }
        BuildVolumeBuilder builder = new BuildVolumeBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"volumes").size()) {
            this._visitables.get((Object)"volumes").add(builder);
        } else {
            this._visitables.get((Object)"volumes").set(index, builder);
        }
        if (index < 0 || index >= this.volumes.size()) {
            this.volumes.add(builder);
        } else {
            this.volumes.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToVolumes(BuildVolume ... items) {
        if (this.volumes == null) {
            this.volumes = new ArrayList<BuildVolumeBuilder>();
        }
        for (BuildVolume item : items) {
            BuildVolumeBuilder builder = new BuildVolumeBuilder(item);
            this._visitables.get((Object)"volumes").add(builder);
            this.volumes.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToVolumes(Collection<BuildVolume> items) {
        if (this.volumes == null) {
            this.volumes = new ArrayList<BuildVolumeBuilder>();
        }
        for (BuildVolume item : items) {
            BuildVolumeBuilder builder = new BuildVolumeBuilder(item);
            this._visitables.get((Object)"volumes").add(builder);
            this.volumes.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromVolumes(BuildVolume ... items) {
        for (BuildVolume item : items) {
            BuildVolumeBuilder builder = new BuildVolumeBuilder(item);
            this._visitables.get((Object)"volumes").remove(builder);
            if (this.volumes == null) continue;
            this.volumes.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromVolumes(Collection<BuildVolume> items) {
        for (BuildVolume item : items) {
            BuildVolumeBuilder builder = new BuildVolumeBuilder(item);
            this._visitables.get((Object)"volumes").remove(builder);
            if (this.volumes == null) continue;
            this.volumes.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromVolumes(Predicate<BuildVolumeBuilder> predicate) {
        if (this.volumes == null) {
            return (A)this;
        }
        Iterator<BuildVolumeBuilder> each = this.volumes.iterator();
        List visitables = this._visitables.get((Object)"volumes");
        while (each.hasNext()) {
            BuildVolumeBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<BuildVolume> getVolumes() {
        return SourceBuildStrategyFluentImpl.build(this.volumes);
    }

    @Override
    public List<BuildVolume> buildVolumes() {
        return SourceBuildStrategyFluentImpl.build(this.volumes);
    }

    @Override
    public BuildVolume buildVolume(Integer index) {
        return this.volumes.get(index).build();
    }

    @Override
    public BuildVolume buildFirstVolume() {
        return this.volumes.get(0).build();
    }

    @Override
    public BuildVolume buildLastVolume() {
        return this.volumes.get(this.volumes.size() - 1).build();
    }

    @Override
    public BuildVolume buildMatchingVolume(Predicate<BuildVolumeBuilder> predicate) {
        for (BuildVolumeBuilder item : this.volumes) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingVolume(Predicate<BuildVolumeBuilder> predicate) {
        for (BuildVolumeBuilder item : this.volumes) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withVolumes(List<BuildVolume> volumes) {
        if (this.volumes != null) {
            this._visitables.get((Object)"volumes").removeAll(this.volumes);
        }
        if (volumes != null) {
            this.volumes = new ArrayList<BuildVolumeBuilder>();
            for (BuildVolume item : volumes) {
                this.addToVolumes(item);
            }
        } else {
            this.volumes = null;
        }
        return (A)this;
    }

    @Override
    public A withVolumes(BuildVolume ... volumes) {
        if (this.volumes != null) {
            this.volumes.clear();
        }
        if (volumes != null) {
            for (BuildVolume item : volumes) {
                this.addToVolumes(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasVolumes() {
        return this.volumes != null && !this.volumes.isEmpty();
    }

    @Override
    public SourceBuildStrategyFluent.VolumesNested<A> addNewVolume() {
        return new VolumesNestedImpl();
    }

    @Override
    public SourceBuildStrategyFluent.VolumesNested<A> addNewVolumeLike(BuildVolume item) {
        return new VolumesNestedImpl(-1, item);
    }

    @Override
    public SourceBuildStrategyFluent.VolumesNested<A> setNewVolumeLike(Integer index, BuildVolume item) {
        return new VolumesNestedImpl(index, item);
    }

    @Override
    public SourceBuildStrategyFluent.VolumesNested<A> editVolume(Integer index) {
        if (this.volumes.size() <= index) {
            throw new RuntimeException("Can't edit volumes. Index exceeds size.");
        }
        return this.setNewVolumeLike(index, this.buildVolume(index));
    }

    @Override
    public SourceBuildStrategyFluent.VolumesNested<A> editFirstVolume() {
        if (this.volumes.size() == 0) {
            throw new RuntimeException("Can't edit first volumes. The list is empty.");
        }
        return this.setNewVolumeLike(0, this.buildVolume(0));
    }

    @Override
    public SourceBuildStrategyFluent.VolumesNested<A> editLastVolume() {
        int index = this.volumes.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last volumes. The list is empty.");
        }
        return this.setNewVolumeLike(index, this.buildVolume(index));
    }

    @Override
    public SourceBuildStrategyFluent.VolumesNested<A> editMatchingVolume(Predicate<BuildVolumeBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.volumes.size(); ++i) {
            if (!predicate.test(this.volumes.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching volumes. No match found.");
        }
        return this.setNewVolumeLike(index, this.buildVolume(index));
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SourceBuildStrategyFluentImpl that = (SourceBuildStrategyFluentImpl)o;
        if (this.env != null ? !this.env.equals(that.env) : that.env != null) {
            return false;
        }
        if (this.forcePull != null ? !this.forcePull.equals(that.forcePull) : that.forcePull != null) {
            return false;
        }
        if (this.from != null ? !this.from.equals((Object)that.from) : that.from != null) {
            return false;
        }
        if (this.incremental != null ? !this.incremental.equals(that.incremental) : that.incremental != null) {
            return false;
        }
        if (this.pullSecret != null ? !this.pullSecret.equals((Object)that.pullSecret) : that.pullSecret != null) {
            return false;
        }
        if (this.scripts != null ? !this.scripts.equals(that.scripts) : that.scripts != null) {
            return false;
        }
        if (this.volumes != null ? !this.volumes.equals(that.volumes) : that.volumes != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public int hashCode() {
        return Objects.hash(this.env, this.forcePull, this.from, this.incremental, this.pullSecret, this.scripts, this.volumes, this.additionalProperties, super.hashCode());
    }

    public class VolumesNestedImpl<N>
    extends BuildVolumeFluentImpl<SourceBuildStrategyFluent.VolumesNested<N>>
    implements SourceBuildStrategyFluent.VolumesNested<N>,
    Nested<N> {
        BuildVolumeBuilder builder;
        Integer index;

        VolumesNestedImpl(Integer index, BuildVolume item) {
            this.index = index;
            this.builder = new BuildVolumeBuilder(this, item);
        }

        VolumesNestedImpl() {
            this.index = -1;
            this.builder = new BuildVolumeBuilder(this);
        }

        @Override
        public N and() {
            return (N)SourceBuildStrategyFluentImpl.this.setToVolumes(this.index, this.builder.build());
        }

        @Override
        public N endVolume() {
            return this.and();
        }
    }

    public class PullSecretNestedImpl<N>
    extends LocalObjectReferenceFluentImpl<SourceBuildStrategyFluent.PullSecretNested<N>>
    implements SourceBuildStrategyFluent.PullSecretNested<N>,
    Nested<N> {
        LocalObjectReferenceBuilder builder;

        PullSecretNestedImpl(LocalObjectReference item) {
            this.builder = new LocalObjectReferenceBuilder((LocalObjectReferenceFluent)this, item);
        }

        PullSecretNestedImpl() {
            this.builder = new LocalObjectReferenceBuilder((LocalObjectReferenceFluent)this);
        }

        @Override
        public N and() {
            return (N)SourceBuildStrategyFluentImpl.this.withPullSecret(this.builder.build());
        }

        @Override
        public N endPullSecret() {
            return this.and();
        }
    }

    public class FromNestedImpl<N>
    extends ObjectReferenceFluentImpl<SourceBuildStrategyFluent.FromNested<N>>
    implements SourceBuildStrategyFluent.FromNested<N>,
    Nested<N> {
        ObjectReferenceBuilder builder;

        FromNestedImpl(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder((ObjectReferenceFluent)this, item);
        }

        FromNestedImpl() {
            this.builder = new ObjectReferenceBuilder((ObjectReferenceFluent)this);
        }

        @Override
        public N and() {
            return (N)SourceBuildStrategyFluentImpl.this.withFrom(this.builder.build());
        }

        @Override
        public N endFrom() {
            return this.and();
        }
    }
}

