/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.tuned.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.tuned.v1.ProfileStatus;
import io.fabric8.openshift.api.model.tuned.v1.ProfileStatusCondition;
import io.fabric8.openshift.api.model.tuned.v1.ProfileStatusConditionBuilder;
import io.fabric8.openshift.api.model.tuned.v1.ProfileStatusConditionFluentImpl;
import io.fabric8.openshift.api.model.tuned.v1.ProfileStatusFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class ProfileStatusFluentImpl<A extends ProfileStatusFluent<A>>
extends BaseFluent<A>
implements ProfileStatusFluent<A> {
    private String bootcmdline;
    private List<ProfileStatusConditionBuilder> conditions = new ArrayList<ProfileStatusConditionBuilder>();
    private Boolean stalld;
    private String tunedProfile;

    public ProfileStatusFluentImpl() {
    }

    public ProfileStatusFluentImpl(ProfileStatus instance) {
        this.withBootcmdline(instance.getBootcmdline());
        this.withConditions(instance.getConditions());
        this.withStalld(instance.getStalld());
        this.withTunedProfile(instance.getTunedProfile());
    }

    @Override
    public String getBootcmdline() {
        return this.bootcmdline;
    }

    @Override
    public A withBootcmdline(String bootcmdline) {
        this.bootcmdline = bootcmdline;
        return (A)this;
    }

    @Override
    public Boolean hasBootcmdline() {
        return this.bootcmdline != null;
    }

    @Override
    @Deprecated
    public A withNewBootcmdline(String arg0) {
        return this.withBootcmdline(new String(arg0));
    }

    @Override
    public A addToConditions(Integer index, ProfileStatusCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<ProfileStatusConditionBuilder>();
        }
        ProfileStatusConditionBuilder builder = new ProfileStatusConditionBuilder(item);
        this._visitables.get((Object)"conditions").add(index >= 0 ? index.intValue() : this._visitables.get((Object)"conditions").size(), builder);
        this.conditions.add(index >= 0 ? index.intValue() : this.conditions.size(), builder);
        return (A)this;
    }

    @Override
    public A setToConditions(Integer index, ProfileStatusCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<ProfileStatusConditionBuilder>();
        }
        ProfileStatusConditionBuilder builder = new ProfileStatusConditionBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"conditions").size()) {
            this._visitables.get((Object)"conditions").add(builder);
        } else {
            this._visitables.get((Object)"conditions").set(index, builder);
        }
        if (index < 0 || index >= this.conditions.size()) {
            this.conditions.add(builder);
        } else {
            this.conditions.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToConditions(ProfileStatusCondition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<ProfileStatusConditionBuilder>();
        }
        for (ProfileStatusCondition item : items) {
            ProfileStatusConditionBuilder builder = new ProfileStatusConditionBuilder(item);
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToConditions(Collection<ProfileStatusCondition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<ProfileStatusConditionBuilder>();
        }
        for (ProfileStatusCondition item : items) {
            ProfileStatusConditionBuilder builder = new ProfileStatusConditionBuilder(item);
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromConditions(ProfileStatusCondition ... items) {
        for (ProfileStatusCondition item : items) {
            ProfileStatusConditionBuilder builder = new ProfileStatusConditionBuilder(item);
            this._visitables.get((Object)"conditions").remove(builder);
            if (this.conditions == null) continue;
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromConditions(Collection<ProfileStatusCondition> items) {
        for (ProfileStatusCondition item : items) {
            ProfileStatusConditionBuilder builder = new ProfileStatusConditionBuilder(item);
            this._visitables.get((Object)"conditions").remove(builder);
            if (this.conditions == null) continue;
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromConditions(Predicate<ProfileStatusConditionBuilder> predicate) {
        if (this.conditions == null) {
            return (A)this;
        }
        Iterator<ProfileStatusConditionBuilder> each = this.conditions.iterator();
        List visitables = this._visitables.get((Object)"conditions");
        while (each.hasNext()) {
            ProfileStatusConditionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<ProfileStatusCondition> getConditions() {
        return ProfileStatusFluentImpl.build(this.conditions);
    }

    @Override
    public List<ProfileStatusCondition> buildConditions() {
        return ProfileStatusFluentImpl.build(this.conditions);
    }

    @Override
    public ProfileStatusCondition buildCondition(Integer index) {
        return this.conditions.get(index).build();
    }

    @Override
    public ProfileStatusCondition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    @Override
    public ProfileStatusCondition buildLastCondition() {
        return this.conditions.get(this.conditions.size() - 1).build();
    }

    @Override
    public ProfileStatusCondition buildMatchingCondition(Predicate<ProfileStatusConditionBuilder> predicate) {
        for (ProfileStatusConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingCondition(Predicate<ProfileStatusConditionBuilder> predicate) {
        for (ProfileStatusConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withConditions(List<ProfileStatusCondition> conditions) {
        if (this.conditions != null) {
            this._visitables.get((Object)"conditions").removeAll(this.conditions);
        }
        if (conditions != null) {
            this.conditions = new ArrayList<ProfileStatusConditionBuilder>();
            for (ProfileStatusCondition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)this;
    }

    @Override
    public A withConditions(ProfileStatusCondition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
        }
        if (conditions != null) {
            for (ProfileStatusCondition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    @Override
    public A addNewCondition(String lastTransitionTime, String message, String reason, String status, String type) {
        return this.addToConditions(new ProfileStatusCondition(lastTransitionTime, message, reason, status, type));
    }

    @Override
    public ProfileStatusFluent.ConditionsNested<A> addNewCondition() {
        return new ConditionsNestedImpl();
    }

    @Override
    public ProfileStatusFluent.ConditionsNested<A> addNewConditionLike(ProfileStatusCondition item) {
        return new ConditionsNestedImpl(-1, item);
    }

    @Override
    public ProfileStatusFluent.ConditionsNested<A> setNewConditionLike(Integer index, ProfileStatusCondition item) {
        return new ConditionsNestedImpl(index, item);
    }

    @Override
    public ProfileStatusFluent.ConditionsNested<A> editCondition(Integer index) {
        if (this.conditions.size() <= index) {
            throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public ProfileStatusFluent.ConditionsNested<A> editFirstCondition() {
        if (this.conditions.size() == 0) {
            throw new RuntimeException("Can't edit first conditions. The list is empty.");
        }
        return this.setNewConditionLike(0, this.buildCondition(0));
    }

    @Override
    public ProfileStatusFluent.ConditionsNested<A> editLastCondition() {
        int index = this.conditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last conditions. The list is empty.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public ProfileStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<ProfileStatusConditionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.conditions.size(); ++i) {
            if (!predicate.test(this.conditions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching conditions. No match found.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public Boolean getStalld() {
        return this.stalld;
    }

    @Override
    public A withStalld(Boolean stalld) {
        this.stalld = stalld;
        return (A)this;
    }

    @Override
    public Boolean hasStalld() {
        return this.stalld != null;
    }

    @Override
    public String getTunedProfile() {
        return this.tunedProfile;
    }

    @Override
    public A withTunedProfile(String tunedProfile) {
        this.tunedProfile = tunedProfile;
        return (A)this;
    }

    @Override
    public Boolean hasTunedProfile() {
        return this.tunedProfile != null;
    }

    @Override
    @Deprecated
    public A withNewTunedProfile(String arg0) {
        return this.withTunedProfile(new String(arg0));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProfileStatusFluentImpl that = (ProfileStatusFluentImpl)o;
        if (this.bootcmdline != null ? !this.bootcmdline.equals(that.bootcmdline) : that.bootcmdline != null) {
            return false;
        }
        if (this.conditions != null ? !this.conditions.equals(that.conditions) : that.conditions != null) {
            return false;
        }
        if (this.stalld != null ? !this.stalld.equals(that.stalld) : that.stalld != null) {
            return false;
        }
        return !(this.tunedProfile != null ? !this.tunedProfile.equals(that.tunedProfile) : that.tunedProfile != null);
    }

    public int hashCode() {
        return Objects.hash(this.bootcmdline, this.conditions, this.stalld, this.tunedProfile, super.hashCode());
    }

    public class ConditionsNestedImpl<N>
    extends ProfileStatusConditionFluentImpl<ProfileStatusFluent.ConditionsNested<N>>
    implements ProfileStatusFluent.ConditionsNested<N>,
    Nested<N> {
        ProfileStatusConditionBuilder builder;
        Integer index;

        ConditionsNestedImpl(Integer index, ProfileStatusCondition item) {
            this.index = index;
            this.builder = new ProfileStatusConditionBuilder(this, item);
        }

        ConditionsNestedImpl() {
            this.index = -1;
            this.builder = new ProfileStatusConditionBuilder(this);
        }

        @Override
        public N and() {
            return (N)ProfileStatusFluentImpl.this.setToConditions(this.index, this.builder.build());
        }

        @Override
        public N endCondition() {
            return this.and();
        }
    }
}

