/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.operatorhub.v1alpha1.CRDDescription;
import io.fabric8.openshift.api.model.operatorhub.v1alpha1.CRDDescriptionBuilder;
import io.fabric8.openshift.api.model.operatorhub.v1alpha1.CRDDescriptionFluent;
import io.fabric8.openshift.api.model.operatorhub.v1alpha1.CustomResourceDefinitions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class CustomResourceDefinitionsFluent<A extends CustomResourceDefinitionsFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private ArrayList<CRDDescriptionBuilder> owned = new ArrayList();
    private ArrayList<CRDDescriptionBuilder> required = new ArrayList();

    public CustomResourceDefinitionsFluent() {
    }

    public CustomResourceDefinitionsFluent(CustomResourceDefinitions instance) {
        this.copyInstance(instance);
    }

    public A addAllToOwned(Collection<CRDDescription> items) {
        if (this.owned == null) {
            this.owned = new ArrayList();
        }
        for (CRDDescription item : items) {
            CRDDescriptionBuilder builder = new CRDDescriptionBuilder(item);
            this._visitables.get((Object)"owned").add(builder);
            this.owned.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToRequired(Collection<CRDDescription> items) {
        if (this.required == null) {
            this.required = new ArrayList();
        }
        for (CRDDescription item : items) {
            CRDDescriptionBuilder builder = new CRDDescriptionBuilder(item);
            this._visitables.get((Object)"required").add(builder);
            this.required.add(builder);
        }
        return (A)((Object)this);
    }

    public OwnedNested<A> addNewOwned() {
        return new OwnedNested(-1, null);
    }

    public OwnedNested<A> addNewOwnedLike(CRDDescription item) {
        return new OwnedNested(-1, item);
    }

    public RequiredNested<A> addNewRequired() {
        return new RequiredNested(-1, null);
    }

    public RequiredNested<A> addNewRequiredLike(CRDDescription item) {
        return new RequiredNested(-1, item);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToOwned(CRDDescription ... items) {
        if (this.owned == null) {
            this.owned = new ArrayList();
        }
        for (CRDDescription item : items) {
            CRDDescriptionBuilder builder = new CRDDescriptionBuilder(item);
            this._visitables.get((Object)"owned").add(builder);
            this.owned.add(builder);
        }
        return (A)((Object)this);
    }

    public A addToOwned(int index, CRDDescription item) {
        if (this.owned == null) {
            this.owned = new ArrayList();
        }
        CRDDescriptionBuilder builder = new CRDDescriptionBuilder(item);
        if (index < 0 || index >= this.owned.size()) {
            this._visitables.get((Object)"owned").add(builder);
            this.owned.add(builder);
        } else {
            this._visitables.get((Object)"owned").add(builder);
            this.owned.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToRequired(CRDDescription ... items) {
        if (this.required == null) {
            this.required = new ArrayList();
        }
        for (CRDDescription item : items) {
            CRDDescriptionBuilder builder = new CRDDescriptionBuilder(item);
            this._visitables.get((Object)"required").add(builder);
            this.required.add(builder);
        }
        return (A)((Object)this);
    }

    public A addToRequired(int index, CRDDescription item) {
        if (this.required == null) {
            this.required = new ArrayList();
        }
        CRDDescriptionBuilder builder = new CRDDescriptionBuilder(item);
        if (index < 0 || index >= this.required.size()) {
            this._visitables.get((Object)"required").add(builder);
            this.required.add(builder);
        } else {
            this._visitables.get((Object)"required").add(builder);
            this.required.add(index, builder);
        }
        return (A)((Object)this);
    }

    public CRDDescription buildFirstOwned() {
        return this.owned.get(0).build();
    }

    public CRDDescription buildFirstRequired() {
        return this.required.get(0).build();
    }

    public CRDDescription buildLastOwned() {
        return this.owned.get(this.owned.size() - 1).build();
    }

    public CRDDescription buildLastRequired() {
        return this.required.get(this.required.size() - 1).build();
    }

    public CRDDescription buildMatchingOwned(Predicate<CRDDescriptionBuilder> predicate) {
        for (CRDDescriptionBuilder item : this.owned) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public CRDDescription buildMatchingRequired(Predicate<CRDDescriptionBuilder> predicate) {
        for (CRDDescriptionBuilder item : this.required) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public List<CRDDescription> buildOwned() {
        return this.owned != null ? CustomResourceDefinitionsFluent.build(this.owned) : null;
    }

    public CRDDescription buildOwned(int index) {
        return this.owned.get(index).build();
    }

    public List<CRDDescription> buildRequired() {
        return this.required != null ? CustomResourceDefinitionsFluent.build(this.required) : null;
    }

    public CRDDescription buildRequired(int index) {
        return this.required.get(index).build();
    }

    protected void copyInstance(CustomResourceDefinitions instance) {
        CustomResourceDefinitions customResourceDefinitions = instance = instance != null ? instance : new CustomResourceDefinitions();
        if (instance != null) {
            this.withOwned(instance.getOwned());
            this.withRequired(instance.getRequired());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public OwnedNested<A> editFirstOwned() {
        if (this.owned.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "owned"));
        }
        return this.setNewOwnedLike(0, this.buildOwned(0));
    }

    public RequiredNested<A> editFirstRequired() {
        if (this.required.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "required"));
        }
        return this.setNewRequiredLike(0, this.buildRequired(0));
    }

    public OwnedNested<A> editLastOwned() {
        int index = this.owned.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "owned"));
        }
        return this.setNewOwnedLike(index, this.buildOwned(index));
    }

    public RequiredNested<A> editLastRequired() {
        int index = this.required.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "required"));
        }
        return this.setNewRequiredLike(index, this.buildRequired(index));
    }

    public OwnedNested<A> editMatchingOwned(Predicate<CRDDescriptionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.owned.size(); ++i) {
            if (!predicate.test(this.owned.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "owned"));
        }
        return this.setNewOwnedLike(index, this.buildOwned(index));
    }

    public RequiredNested<A> editMatchingRequired(Predicate<CRDDescriptionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.required.size(); ++i) {
            if (!predicate.test(this.required.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "required"));
        }
        return this.setNewRequiredLike(index, this.buildRequired(index));
    }

    public OwnedNested<A> editOwned(int index) {
        if (this.owned.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "owned"));
        }
        return this.setNewOwnedLike(index, this.buildOwned(index));
    }

    public RequiredNested<A> editRequired(int index) {
        if (this.required.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "required"));
        }
        return this.setNewRequiredLike(index, this.buildRequired(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CustomResourceDefinitionsFluent that = (CustomResourceDefinitionsFluent)((Object)o);
        if (!Objects.equals(this.owned, that.owned)) {
            return false;
        }
        if (!Objects.equals(this.required, that.required)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasMatchingOwned(Predicate<CRDDescriptionBuilder> predicate) {
        for (CRDDescriptionBuilder item : this.owned) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMatchingRequired(Predicate<CRDDescriptionBuilder> predicate) {
        for (CRDDescriptionBuilder item : this.required) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasOwned() {
        return this.owned != null && !this.owned.isEmpty();
    }

    public boolean hasRequired() {
        return this.required != null && !this.required.isEmpty();
    }

    public int hashCode() {
        return Objects.hash(this.owned, this.required, this.additionalProperties);
    }

    public A removeAllFromOwned(Collection<CRDDescription> items) {
        if (this.owned == null) {
            return (A)((Object)this);
        }
        for (CRDDescription item : items) {
            CRDDescriptionBuilder builder = new CRDDescriptionBuilder(item);
            this._visitables.get((Object)"owned").remove((Object)builder);
            this.owned.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromRequired(Collection<CRDDescription> items) {
        if (this.required == null) {
            return (A)((Object)this);
        }
        for (CRDDescription item : items) {
            CRDDescriptionBuilder builder = new CRDDescriptionBuilder(item);
            this._visitables.get((Object)"required").remove((Object)builder);
            this.required.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeFromOwned(CRDDescription ... items) {
        if (this.owned == null) {
            return (A)((Object)this);
        }
        for (CRDDescription item : items) {
            CRDDescriptionBuilder builder = new CRDDescriptionBuilder(item);
            this._visitables.get((Object)"owned").remove((Object)builder);
            this.owned.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeFromRequired(CRDDescription ... items) {
        if (this.required == null) {
            return (A)((Object)this);
        }
        for (CRDDescription item : items) {
            CRDDescriptionBuilder builder = new CRDDescriptionBuilder(item);
            this._visitables.get((Object)"required").remove((Object)builder);
            this.required.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromOwned(Predicate<CRDDescriptionBuilder> predicate) {
        if (this.owned == null) {
            return (A)((Object)this);
        }
        Iterator<CRDDescriptionBuilder> each = this.owned.iterator();
        List visitables = this._visitables.get((Object)"owned");
        while (each.hasNext()) {
            CRDDescriptionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromRequired(Predicate<CRDDescriptionBuilder> predicate) {
        if (this.required == null) {
            return (A)((Object)this);
        }
        Iterator<CRDDescriptionBuilder> each = this.required.iterator();
        List visitables = this._visitables.get((Object)"required");
        while (each.hasNext()) {
            CRDDescriptionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public OwnedNested<A> setNewOwnedLike(int index, CRDDescription item) {
        return new OwnedNested(index, item);
    }

    public RequiredNested<A> setNewRequiredLike(int index, CRDDescription item) {
        return new RequiredNested(index, item);
    }

    public A setToOwned(int index, CRDDescription item) {
        if (this.owned == null) {
            this.owned = new ArrayList();
        }
        CRDDescriptionBuilder builder = new CRDDescriptionBuilder(item);
        if (index < 0 || index >= this.owned.size()) {
            this._visitables.get((Object)"owned").add(builder);
            this.owned.add(builder);
        } else {
            this._visitables.get((Object)"owned").add(builder);
            this.owned.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToRequired(int index, CRDDescription item) {
        if (this.required == null) {
            this.required = new ArrayList();
        }
        CRDDescriptionBuilder builder = new CRDDescriptionBuilder(item);
        if (index < 0 || index >= this.required.size()) {
            this._visitables.get((Object)"required").add(builder);
            this.required.add(builder);
        } else {
            this._visitables.get((Object)"required").add(builder);
            this.required.set(index, builder);
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.owned != null && !this.owned.isEmpty()) {
            sb.append("owned:");
            sb.append(this.owned);
            sb.append(",");
        }
        if (this.required != null && !this.required.isEmpty()) {
            sb.append("required:");
            sb.append(this.required);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withOwned(List<CRDDescription> owned) {
        if (this.owned != null) {
            this._visitables.get((Object)"owned").clear();
        }
        if (owned != null) {
            this.owned = new ArrayList();
            for (CRDDescription item : owned) {
                this.addToOwned(item);
            }
        } else {
            this.owned = null;
        }
        return (A)((Object)this);
    }

    public A withOwned(CRDDescription ... owned) {
        if (this.owned != null) {
            this.owned.clear();
            this._visitables.remove((Object)"owned");
        }
        if (owned != null) {
            for (CRDDescription item : owned) {
                this.addToOwned(item);
            }
        }
        return (A)((Object)this);
    }

    public A withRequired(List<CRDDescription> required) {
        if (this.required != null) {
            this._visitables.get((Object)"required").clear();
        }
        if (required != null) {
            this.required = new ArrayList();
            for (CRDDescription item : required) {
                this.addToRequired(item);
            }
        } else {
            this.required = null;
        }
        return (A)((Object)this);
    }

    public A withRequired(CRDDescription ... required) {
        if (this.required != null) {
            this.required.clear();
            this._visitables.remove((Object)"required");
        }
        if (required != null) {
            for (CRDDescription item : required) {
                this.addToRequired(item);
            }
        }
        return (A)((Object)this);
    }

    public class RequiredNested<N>
    extends CRDDescriptionFluent<RequiredNested<N>>
    implements Nested<N> {
        CRDDescriptionBuilder builder;
        int index;

        RequiredNested(int index, CRDDescription item) {
            this.index = index;
            this.builder = new CRDDescriptionBuilder(this, item);
        }

        public N and() {
            return (N)CustomResourceDefinitionsFluent.this.setToRequired(this.index, this.builder.build());
        }

        public N endRequired() {
            return this.and();
        }
    }

    public class OwnedNested<N>
    extends CRDDescriptionFluent<OwnedNested<N>>
    implements Nested<N> {
        CRDDescriptionBuilder builder;
        int index;

        OwnedNested(int index, CRDDescription item) {
            this.index = index;
            this.builder = new CRDDescriptionBuilder(this, item);
        }

        public N and() {
            return (N)CustomResourceDefinitionsFluent.this.setToOwned(this.index, this.builder.build());
        }

        public N endOwned() {
            return this.and();
        }
    }
}

