/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.operatorhub.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.LabelSelectorFluent;
import io.fabric8.openshift.api.model.operatorhub.v1.Components;
import io.fabric8.openshift.api.model.operatorhub.v1.RichReference;
import io.fabric8.openshift.api.model.operatorhub.v1.RichReferenceBuilder;
import io.fabric8.openshift.api.model.operatorhub.v1.RichReferenceFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class ComponentsFluent<A extends ComponentsFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private LabelSelectorBuilder labelSelector;
    private ArrayList<RichReferenceBuilder> refs = new ArrayList();

    public ComponentsFluent() {
    }

    public ComponentsFluent(Components instance) {
        this.copyInstance(instance);
    }

    public A addAllToRefs(Collection<RichReference> items) {
        if (this.refs == null) {
            this.refs = new ArrayList();
        }
        for (RichReference item : items) {
            RichReferenceBuilder builder = new RichReferenceBuilder(item);
            this._visitables.get((Object)"refs").add(builder);
            this.refs.add(builder);
        }
        return (A)((Object)this);
    }

    public RefsNested<A> addNewRef() {
        return new RefsNested(-1, null);
    }

    public RefsNested<A> addNewRefLike(RichReference item) {
        return new RefsNested(-1, item);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToRefs(RichReference ... items) {
        if (this.refs == null) {
            this.refs = new ArrayList();
        }
        for (RichReference item : items) {
            RichReferenceBuilder builder = new RichReferenceBuilder(item);
            this._visitables.get((Object)"refs").add(builder);
            this.refs.add(builder);
        }
        return (A)((Object)this);
    }

    public A addToRefs(int index, RichReference item) {
        if (this.refs == null) {
            this.refs = new ArrayList();
        }
        RichReferenceBuilder builder = new RichReferenceBuilder(item);
        if (index < 0 || index >= this.refs.size()) {
            this._visitables.get((Object)"refs").add(builder);
            this.refs.add(builder);
        } else {
            this._visitables.get((Object)"refs").add(builder);
            this.refs.add(index, builder);
        }
        return (A)((Object)this);
    }

    public RichReference buildFirstRef() {
        return this.refs.get(0).build();
    }

    public LabelSelector buildLabelSelector() {
        return this.labelSelector != null ? this.labelSelector.build() : null;
    }

    public RichReference buildLastRef() {
        return this.refs.get(this.refs.size() - 1).build();
    }

    public RichReference buildMatchingRef(Predicate<RichReferenceBuilder> predicate) {
        for (RichReferenceBuilder item : this.refs) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public RichReference buildRef(int index) {
        return this.refs.get(index).build();
    }

    public List<RichReference> buildRefs() {
        return this.refs != null ? ComponentsFluent.build(this.refs) : null;
    }

    protected void copyInstance(Components instance) {
        Components components = instance = instance != null ? instance : new Components();
        if (instance != null) {
            this.withLabelSelector(instance.getLabelSelector());
            this.withRefs(instance.getRefs());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public RefsNested<A> editFirstRef() {
        if (this.refs.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "refs"));
        }
        return this.setNewRefLike(0, this.buildRef(0));
    }

    public LabelSelectorNested<A> editLabelSelector() {
        return this.withNewLabelSelectorLike(Optional.ofNullable(this.buildLabelSelector()).orElse(null));
    }

    public RefsNested<A> editLastRef() {
        int index = this.refs.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "refs"));
        }
        return this.setNewRefLike(index, this.buildRef(index));
    }

    public RefsNested<A> editMatchingRef(Predicate<RichReferenceBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.refs.size(); ++i) {
            if (!predicate.test(this.refs.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "refs"));
        }
        return this.setNewRefLike(index, this.buildRef(index));
    }

    public LabelSelectorNested<A> editOrNewLabelSelector() {
        return this.withNewLabelSelectorLike(Optional.ofNullable(this.buildLabelSelector()).orElse(new LabelSelectorBuilder().build()));
    }

    public LabelSelectorNested<A> editOrNewLabelSelectorLike(LabelSelector item) {
        return this.withNewLabelSelectorLike(Optional.ofNullable(this.buildLabelSelector()).orElse(item));
    }

    public RefsNested<A> editRef(int index) {
        if (this.refs.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "refs"));
        }
        return this.setNewRefLike(index, this.buildRef(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ComponentsFluent that = (ComponentsFluent)((Object)o);
        if (!Objects.equals(this.labelSelector, that.labelSelector)) {
            return false;
        }
        if (!Objects.equals(this.refs, that.refs)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasLabelSelector() {
        return this.labelSelector != null;
    }

    public boolean hasMatchingRef(Predicate<RichReferenceBuilder> predicate) {
        for (RichReferenceBuilder item : this.refs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasRefs() {
        return this.refs != null && !this.refs.isEmpty();
    }

    public int hashCode() {
        return Objects.hash(this.labelSelector, this.refs, this.additionalProperties);
    }

    public A removeAllFromRefs(Collection<RichReference> items) {
        if (this.refs == null) {
            return (A)((Object)this);
        }
        for (RichReference item : items) {
            RichReferenceBuilder builder = new RichReferenceBuilder(item);
            this._visitables.get((Object)"refs").remove((Object)builder);
            this.refs.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeFromRefs(RichReference ... items) {
        if (this.refs == null) {
            return (A)((Object)this);
        }
        for (RichReference item : items) {
            RichReferenceBuilder builder = new RichReferenceBuilder(item);
            this._visitables.get((Object)"refs").remove((Object)builder);
            this.refs.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromRefs(Predicate<RichReferenceBuilder> predicate) {
        if (this.refs == null) {
            return (A)((Object)this);
        }
        Iterator<RichReferenceBuilder> each = this.refs.iterator();
        List visitables = this._visitables.get((Object)"refs");
        while (each.hasNext()) {
            RichReferenceBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public RefsNested<A> setNewRefLike(int index, RichReference item) {
        return new RefsNested(index, item);
    }

    public A setToRefs(int index, RichReference item) {
        if (this.refs == null) {
            this.refs = new ArrayList();
        }
        RichReferenceBuilder builder = new RichReferenceBuilder(item);
        if (index < 0 || index >= this.refs.size()) {
            this._visitables.get((Object)"refs").add(builder);
            this.refs.add(builder);
        } else {
            this._visitables.get((Object)"refs").add(builder);
            this.refs.set(index, builder);
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.labelSelector != null) {
            sb.append("labelSelector:");
            sb.append(this.labelSelector);
            sb.append(",");
        }
        if (this.refs != null && !this.refs.isEmpty()) {
            sb.append("refs:");
            sb.append(this.refs);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withLabelSelector(LabelSelector labelSelector) {
        this._visitables.remove((Object)"labelSelector");
        if (labelSelector != null) {
            this.labelSelector = new LabelSelectorBuilder(labelSelector);
            this._visitables.get((Object)"labelSelector").add(this.labelSelector);
        } else {
            this.labelSelector = null;
            this._visitables.get((Object)"labelSelector").remove(this.labelSelector);
        }
        return (A)((Object)this);
    }

    public LabelSelectorNested<A> withNewLabelSelector() {
        return new LabelSelectorNested(null);
    }

    public LabelSelectorNested<A> withNewLabelSelectorLike(LabelSelector item) {
        return new LabelSelectorNested(item);
    }

    public A withRefs(List<RichReference> refs) {
        if (this.refs != null) {
            this._visitables.get((Object)"refs").clear();
        }
        if (refs != null) {
            this.refs = new ArrayList();
            for (RichReference item : refs) {
                this.addToRefs(item);
            }
        } else {
            this.refs = null;
        }
        return (A)((Object)this);
    }

    public A withRefs(RichReference ... refs) {
        if (this.refs != null) {
            this.refs.clear();
            this._visitables.remove((Object)"refs");
        }
        if (refs != null) {
            for (RichReference item : refs) {
                this.addToRefs(item);
            }
        }
        return (A)((Object)this);
    }

    public class RefsNested<N>
    extends RichReferenceFluent<RefsNested<N>>
    implements Nested<N> {
        RichReferenceBuilder builder;
        int index;

        RefsNested(int index, RichReference item) {
            this.index = index;
            this.builder = new RichReferenceBuilder(this, item);
        }

        public N and() {
            return (N)ComponentsFluent.this.setToRefs(this.index, this.builder.build());
        }

        public N endRef() {
            return this.and();
        }
    }

    public class LabelSelectorNested<N>
    extends LabelSelectorFluent<LabelSelectorNested<N>>
    implements Nested<N> {
        LabelSelectorBuilder builder;

        LabelSelectorNested(LabelSelector item) {
            this.builder = new LabelSelectorBuilder((LabelSelectorFluent)this, item);
        }

        public N and() {
            return (N)ComponentsFluent.this.withLabelSelector(this.builder.build());
        }

        public N endLabelSelector() {
            return this.and();
        }
    }
}

