/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.openshift.api.model.operatorhub.v1alpha1.BundleLookup;
import io.fabric8.openshift.api.model.operatorhub.v1alpha1.BundleLookupCondition;
import io.fabric8.openshift.api.model.operatorhub.v1alpha1.BundleLookupConditionBuilder;
import io.fabric8.openshift.api.model.operatorhub.v1alpha1.BundleLookupConditionFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class BundleLookupFluent<A extends BundleLookupFluent<A>>
extends BaseFluent<A> {
    private ObjectReferenceBuilder catalogSourceRef;
    private ArrayList<BundleLookupConditionBuilder> conditions = new ArrayList();
    private String identifier;
    private String path;
    private String properties;
    private String replaces;
    private Map<String, Object> additionalProperties;

    public BundleLookupFluent() {
    }

    public BundleLookupFluent(BundleLookup instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(BundleLookup instance) {
        BundleLookup bundleLookup = instance = instance != null ? instance : new BundleLookup();
        if (instance != null) {
            this.withCatalogSourceRef(instance.getCatalogSourceRef());
            this.withConditions(instance.getConditions());
            this.withIdentifier(instance.getIdentifier());
            this.withPath(instance.getPath());
            this.withProperties(instance.getProperties());
            this.withReplaces(instance.getReplaces());
            this.withCatalogSourceRef(instance.getCatalogSourceRef());
            this.withConditions(instance.getConditions());
            this.withIdentifier(instance.getIdentifier());
            this.withPath(instance.getPath());
            this.withProperties(instance.getProperties());
            this.withReplaces(instance.getReplaces());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public ObjectReference buildCatalogSourceRef() {
        return this.catalogSourceRef != null ? this.catalogSourceRef.build() : null;
    }

    public A withCatalogSourceRef(ObjectReference catalogSourceRef) {
        this._visitables.remove((Object)this.catalogSourceRef);
        if (catalogSourceRef != null) {
            this.catalogSourceRef = new ObjectReferenceBuilder(catalogSourceRef);
            this._visitables.get((Object)"catalogSourceRef").add(this.catalogSourceRef);
        } else {
            this.catalogSourceRef = null;
            this._visitables.get((Object)"catalogSourceRef").remove(this.catalogSourceRef);
        }
        return (A)((Object)this);
    }

    public boolean hasCatalogSourceRef() {
        return this.catalogSourceRef != null;
    }

    public CatalogSourceRefNested<A> withNewCatalogSourceRef() {
        return new CatalogSourceRefNested(null);
    }

    public CatalogSourceRefNested<A> withNewCatalogSourceRefLike(ObjectReference item) {
        return new CatalogSourceRefNested(item);
    }

    public CatalogSourceRefNested<A> editCatalogSourceRef() {
        return this.withNewCatalogSourceRefLike(Optional.ofNullable(this.buildCatalogSourceRef()).orElse(null));
    }

    public CatalogSourceRefNested<A> editOrNewCatalogSourceRef() {
        return this.withNewCatalogSourceRefLike(Optional.ofNullable(this.buildCatalogSourceRef()).orElse(new ObjectReferenceBuilder().build()));
    }

    public CatalogSourceRefNested<A> editOrNewCatalogSourceRefLike(ObjectReference item) {
        return this.withNewCatalogSourceRefLike(Optional.ofNullable(this.buildCatalogSourceRef()).orElse(item));
    }

    public A addToConditions(int index, BundleLookupCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        BundleLookupConditionBuilder builder = new BundleLookupConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get((Object)"conditions").add(index, builder);
            this.conditions.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToConditions(int index, BundleLookupCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        BundleLookupConditionBuilder builder = new BundleLookupConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get((Object)"conditions").set(index, builder);
            this.conditions.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToConditions(BundleLookupCondition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (BundleLookupCondition item : items) {
            BundleLookupConditionBuilder builder = new BundleLookupConditionBuilder(item);
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToConditions(Collection<BundleLookupCondition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (BundleLookupCondition item : items) {
            BundleLookupConditionBuilder builder = new BundleLookupConditionBuilder(item);
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromConditions(BundleLookupCondition ... items) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        for (BundleLookupCondition item : items) {
            BundleLookupConditionBuilder builder = new BundleLookupConditionBuilder(item);
            this._visitables.get((Object)"conditions").remove((Object)builder);
            this.conditions.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromConditions(Collection<BundleLookupCondition> items) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        for (BundleLookupCondition item : items) {
            BundleLookupConditionBuilder builder = new BundleLookupConditionBuilder(item);
            this._visitables.get((Object)"conditions").remove((Object)builder);
            this.conditions.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromConditions(Predicate<BundleLookupConditionBuilder> predicate) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        Iterator<BundleLookupConditionBuilder> each = this.conditions.iterator();
        List visitables = this._visitables.get((Object)"conditions");
        while (each.hasNext()) {
            BundleLookupConditionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<BundleLookupCondition> buildConditions() {
        return this.conditions != null ? BundleLookupFluent.build(this.conditions) : null;
    }

    public BundleLookupCondition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    public BundleLookupCondition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    public BundleLookupCondition buildLastCondition() {
        return this.conditions.get(this.conditions.size() - 1).build();
    }

    public BundleLookupCondition buildMatchingCondition(Predicate<BundleLookupConditionBuilder> predicate) {
        for (BundleLookupConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingCondition(Predicate<BundleLookupConditionBuilder> predicate) {
        for (BundleLookupConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withConditions(List<BundleLookupCondition> conditions) {
        if (this.conditions != null) {
            this._visitables.get((Object)"conditions").clear();
        }
        if (conditions != null) {
            this.conditions = new ArrayList();
            for (BundleLookupCondition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)((Object)this);
    }

    public A withConditions(BundleLookupCondition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
            this._visitables.remove((Object)"conditions");
        }
        if (conditions != null) {
            for (BundleLookupCondition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    public ConditionsNested<A> addNewCondition() {
        return new ConditionsNested(-1, null);
    }

    public ConditionsNested<A> addNewConditionLike(BundleLookupCondition item) {
        return new ConditionsNested(-1, item);
    }

    public ConditionsNested<A> setNewConditionLike(int index, BundleLookupCondition item) {
        return new ConditionsNested(index, item);
    }

    public ConditionsNested<A> editCondition(int index) {
        if (this.conditions.size() <= index) {
            throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ConditionsNested<A> editFirstCondition() {
        if (this.conditions.size() == 0) {
            throw new RuntimeException("Can't edit first conditions. The list is empty.");
        }
        return this.setNewConditionLike(0, this.buildCondition(0));
    }

    public ConditionsNested<A> editLastCondition() {
        int index = this.conditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last conditions. The list is empty.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ConditionsNested<A> editMatchingCondition(Predicate<BundleLookupConditionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.conditions.size(); ++i) {
            if (!predicate.test(this.conditions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching conditions. No match found.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public A withIdentifier(String identifier) {
        this.identifier = identifier;
        return (A)((Object)this);
    }

    public boolean hasIdentifier() {
        return this.identifier != null;
    }

    public String getPath() {
        return this.path;
    }

    public A withPath(String path) {
        this.path = path;
        return (A)((Object)this);
    }

    public boolean hasPath() {
        return this.path != null;
    }

    public String getProperties() {
        return this.properties;
    }

    public A withProperties(String properties) {
        this.properties = properties;
        return (A)((Object)this);
    }

    public boolean hasProperties() {
        return this.properties != null;
    }

    public String getReplaces() {
        return this.replaces;
    }

    public A withReplaces(String replaces) {
        this.replaces = replaces;
        return (A)((Object)this);
    }

    public boolean hasReplaces() {
        return this.replaces != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BundleLookupFluent that = (BundleLookupFluent)((Object)o);
        if (!Objects.equals(this.catalogSourceRef, that.catalogSourceRef)) {
            return false;
        }
        if (!Objects.equals(this.conditions, that.conditions)) {
            return false;
        }
        if (!Objects.equals(this.identifier, that.identifier)) {
            return false;
        }
        if (!Objects.equals(this.path, that.path)) {
            return false;
        }
        if (!Objects.equals(this.properties, that.properties)) {
            return false;
        }
        if (!Objects.equals(this.replaces, that.replaces)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.catalogSourceRef, this.conditions, this.identifier, this.path, this.properties, this.replaces, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.catalogSourceRef != null) {
            sb.append("catalogSourceRef:");
            sb.append(this.catalogSourceRef + ",");
        }
        if (this.conditions != null && !this.conditions.isEmpty()) {
            sb.append("conditions:");
            sb.append(this.conditions + ",");
        }
        if (this.identifier != null) {
            sb.append("identifier:");
            sb.append(this.identifier + ",");
        }
        if (this.path != null) {
            sb.append("path:");
            sb.append(this.path + ",");
        }
        if (this.properties != null) {
            sb.append("properties:");
            sb.append(this.properties + ",");
        }
        if (this.replaces != null) {
            sb.append("replaces:");
            sb.append(this.replaces + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ConditionsNested<N>
    extends BundleLookupConditionFluent<ConditionsNested<N>>
    implements Nested<N> {
        BundleLookupConditionBuilder builder;
        int index;

        ConditionsNested(int index, BundleLookupCondition item) {
            this.index = index;
            this.builder = new BundleLookupConditionBuilder(this, item);
        }

        public N and() {
            return (N)BundleLookupFluent.this.setToConditions(this.index, this.builder.build());
        }

        public N endCondition() {
            return this.and();
        }
    }

    public class CatalogSourceRefNested<N>
    extends ObjectReferenceFluent<CatalogSourceRefNested<N>>
    implements Nested<N> {
        ObjectReferenceBuilder builder;

        CatalogSourceRefNested(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder((ObjectReferenceFluent)this, item);
        }

        public N and() {
            return (N)BundleLookupFluent.this.withCatalogSourceRef(this.builder.build());
        }

        public N endCatalogSourceRef() {
            return this.and();
        }
    }
}

