/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.openshift.api.model.operatorhub.v1alpha1.InstallPlanSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class InstallPlanSpecFluent<A extends InstallPlanSpecFluent<A>>
extends BaseFluent<A> {
    private String approval;
    private Boolean approved;
    private List<String> clusterServiceVersionNames = new ArrayList<String>();
    private Integer generation;
    private String source;
    private String sourceNamespace;
    private Map<String, Object> additionalProperties;

    public InstallPlanSpecFluent() {
    }

    public InstallPlanSpecFluent(InstallPlanSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(InstallPlanSpec instance) {
        InstallPlanSpec installPlanSpec = instance = instance != null ? instance : new InstallPlanSpec();
        if (instance != null) {
            this.withApproval(instance.getApproval());
            this.withApproved(instance.getApproved());
            this.withClusterServiceVersionNames(instance.getClusterServiceVersionNames());
            this.withGeneration(instance.getGeneration());
            this.withSource(instance.getSource());
            this.withSourceNamespace(instance.getSourceNamespace());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getApproval() {
        return this.approval;
    }

    public A withApproval(String approval) {
        this.approval = approval;
        return (A)((Object)this);
    }

    public boolean hasApproval() {
        return this.approval != null;
    }

    public Boolean getApproved() {
        return this.approved;
    }

    public A withApproved(Boolean approved) {
        this.approved = approved;
        return (A)((Object)this);
    }

    public boolean hasApproved() {
        return this.approved != null;
    }

    public A addToClusterServiceVersionNames(int index, String item) {
        if (this.clusterServiceVersionNames == null) {
            this.clusterServiceVersionNames = new ArrayList<String>();
        }
        this.clusterServiceVersionNames.add(index, item);
        return (A)((Object)this);
    }

    public A setToClusterServiceVersionNames(int index, String item) {
        if (this.clusterServiceVersionNames == null) {
            this.clusterServiceVersionNames = new ArrayList<String>();
        }
        this.clusterServiceVersionNames.set(index, item);
        return (A)((Object)this);
    }

    public A addToClusterServiceVersionNames(String ... items) {
        if (this.clusterServiceVersionNames == null) {
            this.clusterServiceVersionNames = new ArrayList<String>();
        }
        for (String item : items) {
            this.clusterServiceVersionNames.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToClusterServiceVersionNames(Collection<String> items) {
        if (this.clusterServiceVersionNames == null) {
            this.clusterServiceVersionNames = new ArrayList<String>();
        }
        for (String item : items) {
            this.clusterServiceVersionNames.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromClusterServiceVersionNames(String ... items) {
        if (this.clusterServiceVersionNames == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.clusterServiceVersionNames.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromClusterServiceVersionNames(Collection<String> items) {
        if (this.clusterServiceVersionNames == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.clusterServiceVersionNames.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getClusterServiceVersionNames() {
        return this.clusterServiceVersionNames;
    }

    public String getClusterServiceVersionName(int index) {
        return this.clusterServiceVersionNames.get(index);
    }

    public String getFirstClusterServiceVersionName() {
        return this.clusterServiceVersionNames.get(0);
    }

    public String getLastClusterServiceVersionName() {
        return this.clusterServiceVersionNames.get(this.clusterServiceVersionNames.size() - 1);
    }

    public String getMatchingClusterServiceVersionName(Predicate<String> predicate) {
        for (String item : this.clusterServiceVersionNames) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingClusterServiceVersionName(Predicate<String> predicate) {
        for (String item : this.clusterServiceVersionNames) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withClusterServiceVersionNames(List<String> clusterServiceVersionNames) {
        if (clusterServiceVersionNames != null) {
            this.clusterServiceVersionNames = new ArrayList<String>();
            for (String item : clusterServiceVersionNames) {
                this.addToClusterServiceVersionNames(item);
            }
        } else {
            this.clusterServiceVersionNames = null;
        }
        return (A)((Object)this);
    }

    public A withClusterServiceVersionNames(String ... clusterServiceVersionNames) {
        if (this.clusterServiceVersionNames != null) {
            this.clusterServiceVersionNames.clear();
            this._visitables.remove((Object)"clusterServiceVersionNames");
        }
        if (clusterServiceVersionNames != null) {
            for (String item : clusterServiceVersionNames) {
                this.addToClusterServiceVersionNames(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasClusterServiceVersionNames() {
        return this.clusterServiceVersionNames != null && !this.clusterServiceVersionNames.isEmpty();
    }

    public Integer getGeneration() {
        return this.generation;
    }

    public A withGeneration(Integer generation) {
        this.generation = generation;
        return (A)((Object)this);
    }

    public boolean hasGeneration() {
        return this.generation != null;
    }

    public String getSource() {
        return this.source;
    }

    public A withSource(String source) {
        this.source = source;
        return (A)((Object)this);
    }

    public boolean hasSource() {
        return this.source != null;
    }

    public String getSourceNamespace() {
        return this.sourceNamespace;
    }

    public A withSourceNamespace(String sourceNamespace) {
        this.sourceNamespace = sourceNamespace;
        return (A)((Object)this);
    }

    public boolean hasSourceNamespace() {
        return this.sourceNamespace != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        InstallPlanSpecFluent that = (InstallPlanSpecFluent)((Object)o);
        if (!Objects.equals(this.approval, that.approval)) {
            return false;
        }
        if (!Objects.equals(this.approved, that.approved)) {
            return false;
        }
        if (!Objects.equals(this.clusterServiceVersionNames, that.clusterServiceVersionNames)) {
            return false;
        }
        if (!Objects.equals(this.generation, that.generation)) {
            return false;
        }
        if (!Objects.equals(this.source, that.source)) {
            return false;
        }
        if (!Objects.equals(this.sourceNamespace, that.sourceNamespace)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.approval, this.approved, this.clusterServiceVersionNames, this.generation, this.source, this.sourceNamespace, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.approval != null) {
            sb.append("approval:");
            sb.append(this.approval + ",");
        }
        if (this.approved != null) {
            sb.append("approved:");
            sb.append(this.approved + ",");
        }
        if (this.clusterServiceVersionNames != null && !this.clusterServiceVersionNames.isEmpty()) {
            sb.append("clusterServiceVersionNames:");
            sb.append(this.clusterServiceVersionNames + ",");
        }
        if (this.generation != null) {
            sb.append("generation:");
            sb.append(this.generation + ",");
        }
        if (this.source != null) {
            sb.append("source:");
            sb.append(this.source + ",");
        }
        if (this.sourceNamespace != null) {
            sb.append("sourceNamespace:");
            sb.append(this.sourceNamespace + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withApproved() {
        return this.withApproved(true);
    }
}

