package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class InsightsReportBuilder extends InsightsReportFluent<InsightsReportBuilder> implements VisitableBuilder<InsightsReport,InsightsReportBuilder>{
  public InsightsReportBuilder() {
    this(new InsightsReport());
  }
  
  public InsightsReportBuilder(InsightsReportFluent<?> fluent) {
    this(fluent, new InsightsReport());
  }
  
  public InsightsReportBuilder(InsightsReportFluent<?> fluent,InsightsReport instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public InsightsReportBuilder(InsightsReport instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  InsightsReportFluent<?> fluent;
  
  public InsightsReport build() {
    InsightsReport buildable = new InsightsReport(fluent.getDownloadedAt(),fluent.buildHealthChecks());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}