package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class DNSStatusFluent<A extends DNSStatusFluent<A>> extends BaseFluent<A>{
  public DNSStatusFluent() {
  }
  
  public DNSStatusFluent(DNSStatus instance) {
    this.copyInstance(instance);
  }
  private String clusterDomain;
  private String clusterIP;
  private ArrayList<OperatorConditionBuilder> conditions = new ArrayList<OperatorConditionBuilder>();
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(DNSStatus instance) {
    instance = (instance != null ? instance : new DNSStatus());
    if (instance != null) {
          this.withClusterDomain(instance.getClusterDomain());
          this.withClusterIP(instance.getClusterIP());
          this.withConditions(instance.getConditions());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getClusterDomain() {
    return this.clusterDomain;
  }
  
  public A withClusterDomain(String clusterDomain) {
    this.clusterDomain = clusterDomain;
    return (A) this;
  }
  
  public boolean hasClusterDomain() {
    return this.clusterDomain != null;
  }
  
  public String getClusterIP() {
    return this.clusterIP;
  }
  
  public A withClusterIP(String clusterIP) {
    this.clusterIP = clusterIP;
    return (A) this;
  }
  
  public boolean hasClusterIP() {
    return this.clusterIP != null;
  }
  
  public A addToConditions(int index,OperatorCondition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<OperatorConditionBuilder>();}
    OperatorConditionBuilder builder = new OperatorConditionBuilder(item);
    if (index < 0 || index >= conditions.size()) {
        _visitables.get("conditions").add(builder);
        conditions.add(builder);
    } else {
        _visitables.get("conditions").add(builder);
        conditions.add(index, builder);
    }
    return (A)this;
  }
  
  public A setToConditions(int index,OperatorCondition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<OperatorConditionBuilder>();}
    OperatorConditionBuilder builder = new OperatorConditionBuilder(item);
    if (index < 0 || index >= conditions.size()) {
        _visitables.get("conditions").add(builder);
        conditions.add(builder);
    } else {
        _visitables.get("conditions").add(builder);
        conditions.set(index, builder);
    }
    return (A)this;
  }
  
  public A addToConditions(io.fabric8.openshift.api.model.operator.v1.OperatorCondition... items) {
    if (this.conditions == null) {this.conditions = new ArrayList<OperatorConditionBuilder>();}
    for (OperatorCondition item : items) {OperatorConditionBuilder builder = new OperatorConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  
  public A addAllToConditions(Collection<OperatorCondition> items) {
    if (this.conditions == null) {this.conditions = new ArrayList<OperatorConditionBuilder>();}
    for (OperatorCondition item : items) {OperatorConditionBuilder builder = new OperatorConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  
  public A removeFromConditions(io.fabric8.openshift.api.model.operator.v1.OperatorCondition... items) {
    if (this.conditions == null) return (A)this;
    for (OperatorCondition item : items) {OperatorConditionBuilder builder = new OperatorConditionBuilder(item);_visitables.get("conditions").remove(builder); this.conditions.remove(builder);} return (A)this;
  }
  
  public A removeAllFromConditions(Collection<OperatorCondition> items) {
    if (this.conditions == null) return (A)this;
    for (OperatorCondition item : items) {OperatorConditionBuilder builder = new OperatorConditionBuilder(item);_visitables.get("conditions").remove(builder); this.conditions.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromConditions(Predicate<OperatorConditionBuilder> predicate) {
    if (conditions == null) return (A) this;
    final Iterator<OperatorConditionBuilder> each = conditions.iterator();
    final List visitables = _visitables.get("conditions");
    while (each.hasNext()) {
      OperatorConditionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<OperatorCondition> buildConditions() {
    return this.conditions != null ? build(conditions) : null;
  }
  
  public OperatorCondition buildCondition(int index) {
    return this.conditions.get(index).build();
  }
  
  public OperatorCondition buildFirstCondition() {
    return this.conditions.get(0).build();
  }
  
  public OperatorCondition buildLastCondition() {
    return this.conditions.get(conditions.size() - 1).build();
  }
  
  public OperatorCondition buildMatchingCondition(Predicate<OperatorConditionBuilder> predicate) {
      for (OperatorConditionBuilder item : conditions) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingCondition(Predicate<OperatorConditionBuilder> predicate) {
      for (OperatorConditionBuilder item : conditions) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withConditions(List<OperatorCondition> conditions) {
    if (this.conditions != null) {
      this._visitables.get("conditions").clear();
    }
    if (conditions != null) {
        this.conditions = new ArrayList();
        for (OperatorCondition item : conditions) {
          this.addToConditions(item);
        }
    } else {
      this.conditions = null;
    }
    return (A) this;
  }
  
  public A withConditions(io.fabric8.openshift.api.model.operator.v1.OperatorCondition... conditions) {
    if (this.conditions != null) {
        this.conditions.clear();
        _visitables.remove("conditions");
    }
    if (conditions != null) {
      for (OperatorCondition item : conditions) {
        this.addToConditions(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasConditions() {
    return this.conditions != null && !this.conditions.isEmpty();
  }
  
  public A addNewCondition(String lastTransitionTime,String message,String reason,String status,String type) {
    return (A)addToConditions(new OperatorCondition(lastTransitionTime, message, reason, status, type));
  }
  
  public ConditionsNested<A> addNewCondition() {
    return new ConditionsNested(-1, null);
  }
  
  public ConditionsNested<A> addNewConditionLike(OperatorCondition item) {
    return new ConditionsNested(-1, item);
  }
  
  public ConditionsNested<A> setNewConditionLike(int index,OperatorCondition item) {
    return new ConditionsNested(index, item);
  }
  
  public ConditionsNested<A> editCondition(int index) {
    if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
    return setNewConditionLike(index, buildCondition(index));
  }
  
  public ConditionsNested<A> editFirstCondition() {
    if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
    return setNewConditionLike(0, buildCondition(0));
  }
  
  public ConditionsNested<A> editLastCondition() {
    int index = conditions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
    return setNewConditionLike(index, buildCondition(index));
  }
  
  public ConditionsNested<A> editMatchingCondition(Predicate<OperatorConditionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<conditions.size();i++) { 
    if (predicate.test(conditions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
    return setNewConditionLike(index, buildCondition(index));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    DNSStatusFluent that = (DNSStatusFluent) o;
    if (!java.util.Objects.equals(clusterDomain, that.clusterDomain)) return false;
    if (!java.util.Objects.equals(clusterIP, that.clusterIP)) return false;
    if (!java.util.Objects.equals(conditions, that.conditions)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(clusterDomain,  clusterIP,  conditions,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (clusterDomain != null) { sb.append("clusterDomain:"); sb.append(clusterDomain + ","); }
    if (clusterIP != null) { sb.append("clusterIP:"); sb.append(clusterIP + ","); }
    if (conditions != null && !conditions.isEmpty()) { sb.append("conditions:"); sb.append(conditions + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class ConditionsNested<N> extends OperatorConditionFluent<ConditionsNested<N>> implements Nested<N>{
    ConditionsNested(int index,OperatorCondition item) {
      this.index = index;
      this.builder = new OperatorConditionBuilder(this, item);
    }
    OperatorConditionBuilder builder;
    int index;
    
    public N and() {
      return (N) DNSStatusFluent.this.setToConditions(index,builder.build());
    }
    
    public N endCondition() {
      return and();
    }
    
  
  }

}