package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class NetworkSpecBuilder extends NetworkSpecFluent<NetworkSpecBuilder> implements VisitableBuilder<NetworkSpec,NetworkSpecBuilder>{
  public NetworkSpecBuilder() {
    this(new NetworkSpec());
  }
  
  public NetworkSpecBuilder(NetworkSpecFluent<?> fluent) {
    this(fluent, new NetworkSpec());
  }
  
  public NetworkSpecBuilder(NetworkSpecFluent<?> fluent,NetworkSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public NetworkSpecBuilder(NetworkSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  NetworkSpecFluent<?> fluent;
  
  public NetworkSpec build() {
    NetworkSpec buildable = new NetworkSpec(fluent.buildAdditionalNetworks(),fluent.buildClusterNetwork(),fluent.buildDefaultNetwork(),fluent.getDeployKubeProxy(),fluent.getDisableMultiNetwork(),fluent.getDisableNetworkDiagnostics(),fluent.buildExportNetworkFlows(),fluent.buildKubeProxyConfig(),fluent.getLogLevel(),fluent.getManagementState(),fluent.buildMigration(),fluent.buildObservedConfig(),fluent.getOperatorLogLevel(),fluent.getServiceNetwork(),fluent.buildUnsupportedConfigOverrides(),fluent.getUseMultiNetworkPolicy());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}