/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.operator.v1.AccessLogging;
import io.fabric8.openshift.api.model.operator.v1.IngressControllerCaptureHTTPCookie;
import io.fabric8.openshift.api.model.operator.v1.IngressControllerCaptureHTTPCookieBuilder;
import io.fabric8.openshift.api.model.operator.v1.IngressControllerCaptureHTTPCookieFluent;
import io.fabric8.openshift.api.model.operator.v1.IngressControllerCaptureHTTPHeaders;
import io.fabric8.openshift.api.model.operator.v1.IngressControllerCaptureHTTPHeadersBuilder;
import io.fabric8.openshift.api.model.operator.v1.IngressControllerCaptureHTTPHeadersFluent;
import io.fabric8.openshift.api.model.operator.v1.LoggingDestination;
import io.fabric8.openshift.api.model.operator.v1.LoggingDestinationBuilder;
import io.fabric8.openshift.api.model.operator.v1.LoggingDestinationFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class AccessLoggingFluent<A extends AccessLoggingFluent<A>>
extends BaseFluent<A> {
    private LoggingDestinationBuilder destination;
    private ArrayList<IngressControllerCaptureHTTPCookieBuilder> httpCaptureCookies = new ArrayList();
    private IngressControllerCaptureHTTPHeadersBuilder httpCaptureHeaders;
    private String httpLogFormat;
    private String logEmptyRequests;
    private Map<String, Object> additionalProperties;

    public AccessLoggingFluent() {
    }

    public AccessLoggingFluent(AccessLogging instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(AccessLogging instance) {
        AccessLogging accessLogging = instance = instance != null ? instance : new AccessLogging();
        if (instance != null) {
            this.withDestination(instance.getDestination());
            this.withHttpCaptureCookies(instance.getHttpCaptureCookies());
            this.withHttpCaptureHeaders(instance.getHttpCaptureHeaders());
            this.withHttpLogFormat(instance.getHttpLogFormat());
            this.withLogEmptyRequests(instance.getLogEmptyRequests());
            this.withDestination(instance.getDestination());
            this.withHttpCaptureCookies(instance.getHttpCaptureCookies());
            this.withHttpCaptureHeaders(instance.getHttpCaptureHeaders());
            this.withHttpLogFormat(instance.getHttpLogFormat());
            this.withLogEmptyRequests(instance.getLogEmptyRequests());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public LoggingDestination buildDestination() {
        return this.destination != null ? this.destination.build() : null;
    }

    public A withDestination(LoggingDestination destination) {
        this._visitables.get((Object)"destination").remove((Object)this.destination);
        if (destination != null) {
            this.destination = new LoggingDestinationBuilder(destination);
            this._visitables.get((Object)"destination").add(this.destination);
        } else {
            this.destination = null;
            this._visitables.get((Object)"destination").remove((Object)this.destination);
        }
        return (A)((Object)this);
    }

    public boolean hasDestination() {
        return this.destination != null;
    }

    public DestinationNested<A> withNewDestination() {
        return new DestinationNested(null);
    }

    public DestinationNested<A> withNewDestinationLike(LoggingDestination item) {
        return new DestinationNested(item);
    }

    public DestinationNested<A> editDestination() {
        return this.withNewDestinationLike(Optional.ofNullable(this.buildDestination()).orElse(null));
    }

    public DestinationNested<A> editOrNewDestination() {
        return this.withNewDestinationLike(Optional.ofNullable(this.buildDestination()).orElse(new LoggingDestinationBuilder().build()));
    }

    public DestinationNested<A> editOrNewDestinationLike(LoggingDestination item) {
        return this.withNewDestinationLike(Optional.ofNullable(this.buildDestination()).orElse(item));
    }

    public A addToHttpCaptureCookies(int index, IngressControllerCaptureHTTPCookie item) {
        if (this.httpCaptureCookies == null) {
            this.httpCaptureCookies = new ArrayList();
        }
        IngressControllerCaptureHTTPCookieBuilder builder = new IngressControllerCaptureHTTPCookieBuilder(item);
        if (index < 0 || index >= this.httpCaptureCookies.size()) {
            this._visitables.get((Object)"httpCaptureCookies").add(builder);
            this.httpCaptureCookies.add(builder);
        } else {
            this._visitables.get((Object)"httpCaptureCookies").add(index, builder);
            this.httpCaptureCookies.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToHttpCaptureCookies(int index, IngressControllerCaptureHTTPCookie item) {
        if (this.httpCaptureCookies == null) {
            this.httpCaptureCookies = new ArrayList();
        }
        IngressControllerCaptureHTTPCookieBuilder builder = new IngressControllerCaptureHTTPCookieBuilder(item);
        if (index < 0 || index >= this.httpCaptureCookies.size()) {
            this._visitables.get((Object)"httpCaptureCookies").add(builder);
            this.httpCaptureCookies.add(builder);
        } else {
            this._visitables.get((Object)"httpCaptureCookies").set(index, builder);
            this.httpCaptureCookies.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToHttpCaptureCookies(IngressControllerCaptureHTTPCookie ... items) {
        if (this.httpCaptureCookies == null) {
            this.httpCaptureCookies = new ArrayList();
        }
        for (IngressControllerCaptureHTTPCookie item : items) {
            IngressControllerCaptureHTTPCookieBuilder builder = new IngressControllerCaptureHTTPCookieBuilder(item);
            this._visitables.get((Object)"httpCaptureCookies").add(builder);
            this.httpCaptureCookies.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToHttpCaptureCookies(Collection<IngressControllerCaptureHTTPCookie> items) {
        if (this.httpCaptureCookies == null) {
            this.httpCaptureCookies = new ArrayList();
        }
        for (IngressControllerCaptureHTTPCookie item : items) {
            IngressControllerCaptureHTTPCookieBuilder builder = new IngressControllerCaptureHTTPCookieBuilder(item);
            this._visitables.get((Object)"httpCaptureCookies").add(builder);
            this.httpCaptureCookies.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromHttpCaptureCookies(IngressControllerCaptureHTTPCookie ... items) {
        if (this.httpCaptureCookies == null) {
            return (A)((Object)this);
        }
        for (IngressControllerCaptureHTTPCookie item : items) {
            IngressControllerCaptureHTTPCookieBuilder builder = new IngressControllerCaptureHTTPCookieBuilder(item);
            this._visitables.get((Object)"httpCaptureCookies").remove((Object)builder);
            this.httpCaptureCookies.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromHttpCaptureCookies(Collection<IngressControllerCaptureHTTPCookie> items) {
        if (this.httpCaptureCookies == null) {
            return (A)((Object)this);
        }
        for (IngressControllerCaptureHTTPCookie item : items) {
            IngressControllerCaptureHTTPCookieBuilder builder = new IngressControllerCaptureHTTPCookieBuilder(item);
            this._visitables.get((Object)"httpCaptureCookies").remove((Object)builder);
            this.httpCaptureCookies.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromHttpCaptureCookies(Predicate<IngressControllerCaptureHTTPCookieBuilder> predicate) {
        if (this.httpCaptureCookies == null) {
            return (A)((Object)this);
        }
        Iterator<IngressControllerCaptureHTTPCookieBuilder> each = this.httpCaptureCookies.iterator();
        List visitables = this._visitables.get((Object)"httpCaptureCookies");
        while (each.hasNext()) {
            IngressControllerCaptureHTTPCookieBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<IngressControllerCaptureHTTPCookie> buildHttpCaptureCookies() {
        return this.httpCaptureCookies != null ? AccessLoggingFluent.build(this.httpCaptureCookies) : null;
    }

    public IngressControllerCaptureHTTPCookie buildHttpCaptureCooky(int index) {
        return this.httpCaptureCookies.get(index).build();
    }

    public IngressControllerCaptureHTTPCookie buildFirstHttpCaptureCooky() {
        return this.httpCaptureCookies.get(0).build();
    }

    public IngressControllerCaptureHTTPCookie buildLastHttpCaptureCooky() {
        return this.httpCaptureCookies.get(this.httpCaptureCookies.size() - 1).build();
    }

    public IngressControllerCaptureHTTPCookie buildMatchingHttpCaptureCooky(Predicate<IngressControllerCaptureHTTPCookieBuilder> predicate) {
        for (IngressControllerCaptureHTTPCookieBuilder item : this.httpCaptureCookies) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingHttpCaptureCooky(Predicate<IngressControllerCaptureHTTPCookieBuilder> predicate) {
        for (IngressControllerCaptureHTTPCookieBuilder item : this.httpCaptureCookies) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withHttpCaptureCookies(List<IngressControllerCaptureHTTPCookie> httpCaptureCookies) {
        if (this.httpCaptureCookies != null) {
            this._visitables.get((Object)"httpCaptureCookies").clear();
        }
        if (httpCaptureCookies != null) {
            this.httpCaptureCookies = new ArrayList();
            for (IngressControllerCaptureHTTPCookie item : httpCaptureCookies) {
                this.addToHttpCaptureCookies(item);
            }
        } else {
            this.httpCaptureCookies = null;
        }
        return (A)((Object)this);
    }

    public A withHttpCaptureCookies(IngressControllerCaptureHTTPCookie ... httpCaptureCookies) {
        if (this.httpCaptureCookies != null) {
            this.httpCaptureCookies.clear();
            this._visitables.remove((Object)"httpCaptureCookies");
        }
        if (httpCaptureCookies != null) {
            for (IngressControllerCaptureHTTPCookie item : httpCaptureCookies) {
                this.addToHttpCaptureCookies(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasHttpCaptureCookies() {
        return this.httpCaptureCookies != null && !this.httpCaptureCookies.isEmpty();
    }

    public A addNewHttpCaptureCooky(String matchType, Integer maxLength, String name, String namePrefix) {
        return this.addToHttpCaptureCookies(new IngressControllerCaptureHTTPCookie(matchType, maxLength, name, namePrefix));
    }

    public HttpCaptureCookiesNested<A> addNewHttpCaptureCooky() {
        return new HttpCaptureCookiesNested(-1, null);
    }

    public HttpCaptureCookiesNested<A> addNewHttpCaptureCookyLike(IngressControllerCaptureHTTPCookie item) {
        return new HttpCaptureCookiesNested(-1, item);
    }

    public HttpCaptureCookiesNested<A> setNewHttpCaptureCookyLike(int index, IngressControllerCaptureHTTPCookie item) {
        return new HttpCaptureCookiesNested(index, item);
    }

    public HttpCaptureCookiesNested<A> editHttpCaptureCooky(int index) {
        if (this.httpCaptureCookies.size() <= index) {
            throw new RuntimeException("Can't edit httpCaptureCookies. Index exceeds size.");
        }
        return this.setNewHttpCaptureCookyLike(index, this.buildHttpCaptureCooky(index));
    }

    public HttpCaptureCookiesNested<A> editFirstHttpCaptureCooky() {
        if (this.httpCaptureCookies.size() == 0) {
            throw new RuntimeException("Can't edit first httpCaptureCookies. The list is empty.");
        }
        return this.setNewHttpCaptureCookyLike(0, this.buildHttpCaptureCooky(0));
    }

    public HttpCaptureCookiesNested<A> editLastHttpCaptureCooky() {
        int index = this.httpCaptureCookies.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last httpCaptureCookies. The list is empty.");
        }
        return this.setNewHttpCaptureCookyLike(index, this.buildHttpCaptureCooky(index));
    }

    public HttpCaptureCookiesNested<A> editMatchingHttpCaptureCooky(Predicate<IngressControllerCaptureHTTPCookieBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.httpCaptureCookies.size(); ++i) {
            if (!predicate.test(this.httpCaptureCookies.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching httpCaptureCookies. No match found.");
        }
        return this.setNewHttpCaptureCookyLike(index, this.buildHttpCaptureCooky(index));
    }

    public IngressControllerCaptureHTTPHeaders buildHttpCaptureHeaders() {
        return this.httpCaptureHeaders != null ? this.httpCaptureHeaders.build() : null;
    }

    public A withHttpCaptureHeaders(IngressControllerCaptureHTTPHeaders httpCaptureHeaders) {
        this._visitables.get((Object)"httpCaptureHeaders").remove((Object)this.httpCaptureHeaders);
        if (httpCaptureHeaders != null) {
            this.httpCaptureHeaders = new IngressControllerCaptureHTTPHeadersBuilder(httpCaptureHeaders);
            this._visitables.get((Object)"httpCaptureHeaders").add(this.httpCaptureHeaders);
        } else {
            this.httpCaptureHeaders = null;
            this._visitables.get((Object)"httpCaptureHeaders").remove((Object)this.httpCaptureHeaders);
        }
        return (A)((Object)this);
    }

    public boolean hasHttpCaptureHeaders() {
        return this.httpCaptureHeaders != null;
    }

    public HttpCaptureHeadersNested<A> withNewHttpCaptureHeaders() {
        return new HttpCaptureHeadersNested(null);
    }

    public HttpCaptureHeadersNested<A> withNewHttpCaptureHeadersLike(IngressControllerCaptureHTTPHeaders item) {
        return new HttpCaptureHeadersNested(item);
    }

    public HttpCaptureHeadersNested<A> editHttpCaptureHeaders() {
        return this.withNewHttpCaptureHeadersLike(Optional.ofNullable(this.buildHttpCaptureHeaders()).orElse(null));
    }

    public HttpCaptureHeadersNested<A> editOrNewHttpCaptureHeaders() {
        return this.withNewHttpCaptureHeadersLike(Optional.ofNullable(this.buildHttpCaptureHeaders()).orElse(new IngressControllerCaptureHTTPHeadersBuilder().build()));
    }

    public HttpCaptureHeadersNested<A> editOrNewHttpCaptureHeadersLike(IngressControllerCaptureHTTPHeaders item) {
        return this.withNewHttpCaptureHeadersLike(Optional.ofNullable(this.buildHttpCaptureHeaders()).orElse(item));
    }

    public String getHttpLogFormat() {
        return this.httpLogFormat;
    }

    public A withHttpLogFormat(String httpLogFormat) {
        this.httpLogFormat = httpLogFormat;
        return (A)((Object)this);
    }

    public boolean hasHttpLogFormat() {
        return this.httpLogFormat != null;
    }

    public String getLogEmptyRequests() {
        return this.logEmptyRequests;
    }

    public A withLogEmptyRequests(String logEmptyRequests) {
        this.logEmptyRequests = logEmptyRequests;
        return (A)((Object)this);
    }

    public boolean hasLogEmptyRequests() {
        return this.logEmptyRequests != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AccessLoggingFluent that = (AccessLoggingFluent)((Object)o);
        if (!Objects.equals((Object)this.destination, (Object)that.destination)) {
            return false;
        }
        if (!Objects.equals(this.httpCaptureCookies, that.httpCaptureCookies)) {
            return false;
        }
        if (!Objects.equals((Object)this.httpCaptureHeaders, (Object)that.httpCaptureHeaders)) {
            return false;
        }
        if (!Objects.equals(this.httpLogFormat, that.httpLogFormat)) {
            return false;
        }
        if (!Objects.equals(this.logEmptyRequests, that.logEmptyRequests)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.destination, this.httpCaptureCookies, this.httpCaptureHeaders, this.httpLogFormat, this.logEmptyRequests, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.destination != null) {
            sb.append("destination:");
            sb.append((Object)((Object)this.destination) + ",");
        }
        if (this.httpCaptureCookies != null && !this.httpCaptureCookies.isEmpty()) {
            sb.append("httpCaptureCookies:");
            sb.append(this.httpCaptureCookies + ",");
        }
        if (this.httpCaptureHeaders != null) {
            sb.append("httpCaptureHeaders:");
            sb.append((Object)((Object)this.httpCaptureHeaders) + ",");
        }
        if (this.httpLogFormat != null) {
            sb.append("httpLogFormat:");
            sb.append(this.httpLogFormat + ",");
        }
        if (this.logEmptyRequests != null) {
            sb.append("logEmptyRequests:");
            sb.append(this.logEmptyRequests + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class HttpCaptureHeadersNested<N>
    extends IngressControllerCaptureHTTPHeadersFluent<HttpCaptureHeadersNested<N>>
    implements Nested<N> {
        IngressControllerCaptureHTTPHeadersBuilder builder;

        HttpCaptureHeadersNested(IngressControllerCaptureHTTPHeaders item) {
            this.builder = new IngressControllerCaptureHTTPHeadersBuilder(this, item);
        }

        public N and() {
            return (N)AccessLoggingFluent.this.withHttpCaptureHeaders(this.builder.build());
        }

        public N endHttpCaptureHeaders() {
            return this.and();
        }
    }

    public class HttpCaptureCookiesNested<N>
    extends IngressControllerCaptureHTTPCookieFluent<HttpCaptureCookiesNested<N>>
    implements Nested<N> {
        IngressControllerCaptureHTTPCookieBuilder builder;
        int index;

        HttpCaptureCookiesNested(int index, IngressControllerCaptureHTTPCookie item) {
            this.index = index;
            this.builder = new IngressControllerCaptureHTTPCookieBuilder(this, item);
        }

        public N and() {
            return (N)AccessLoggingFluent.this.setToHttpCaptureCookies(this.index, this.builder.build());
        }

        public N endHttpCaptureCooky() {
            return this.and();
        }
    }

    public class DestinationNested<N>
    extends LoggingDestinationFluent<DestinationNested<N>>
    implements Nested<N> {
        LoggingDestinationBuilder builder;

        DestinationNested(LoggingDestination item) {
            this.builder = new LoggingDestinationBuilder(this, item);
        }

        public N and() {
            return (N)AccessLoggingFluent.this.withDestination(this.builder.build());
        }

        public N endDestination() {
            return this.and();
        }
    }
}

