package io.fabric8.openshift.api.model.operator.v1;

import java.lang.String;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.LogEntryFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.OutageEntryFluentImpl;
import io.fabric8.kubernetes.api.model.runtime.RawExtensionFluentImpl;
import io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.PodNetworkConnectivityCheck;
import io.fabric8.openshift.api.model.operator.v1alpha1.ImageContentSourcePolicyFluentImpl;
import io.fabric8.openshift.api.model.operator.v1alpha1.RepositoryDigestMirrorsBuilder;
import io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.PodNetworkConnectivityCheckStatusFluentImpl;
import io.fabric8.kubernetes.api.model.ContainerFluentImpl;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimFluentImpl;
import io.fabric8.openshift.api.model.operator.v1alpha1.ImageContentSourcePolicyListBuilder;
import io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.PodNetworkConnectivityCheckList;
import io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.PodNetworkConnectivityCheckFluentImpl;
import io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.LogEntry;
import io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.PodNetworkConnectivityCheckSpec;
import io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.PodNetworkConnectivityCheckStatus;
import io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.PodNetworkConnectivityCheckCondition;
import io.fabric8.kubernetes.api.model.runtime.RawExtensionBuilder;
import io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.OutageEntryBuilder;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.PodNetworkConnectivityCheckSpecBuilder;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluentImpl;
import java.lang.Boolean;
import java.lang.Object;
import io.fabric8.openshift.api.model.operator.v1alpha1.ImageContentSourcePolicySpecFluentImpl;
import io.fabric8.openshift.api.model.config.v1.ConfigMapNameReference;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.OutageEntry;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.PodNetworkConnectivityCheckStatusBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.ResourceRequirementsFluentImpl;
import io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.PodNetworkConnectivityCheckBuilder;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.model.GenericKubernetesResource;
import io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.PodNetworkConnectivityCheckConditionBuilder;
import io.fabric8.openshift.api.model.operator.v1alpha1.ImageContentSourcePolicyBuilder;
import io.fabric8.openshift.api.model.operator.v1alpha1.ImageContentSourcePolicyList;
import io.fabric8.kubernetes.api.model.GenericKubernetesResourceBuilder;
import java.util.Map;
import io.fabric8.openshift.api.model.operator.v1alpha1.ImageContentSourcePolicy;
import io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder;
import io.fabric8.kubernetes.api.model.LabelSelectorFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.PodNetworkConnectivityCheckListFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.openshift.api.model.operator.v1alpha1.ImageContentSourcePolicySpec;
import io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.PodNetworkConnectivityCheckConditionFluentImpl;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.LogEntryBuilder;
import io.fabric8.openshift.api.model.config.v1.TLSSecurityProfile;
import io.fabric8.openshift.api.model.operator.v1alpha1.RepositoryDigestMirrors;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.openshift.api.model.operator.v1alpha1.ImageContentSourcePolicyListFluentImpl;
import java.lang.Integer;
import io.fabric8.kubernetes.api.model.GenericKubernetesResourceFluentImpl;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.PodNetworkConnectivityCheckSpecFluentImpl;
import io.fabric8.openshift.api.model.operator.v1alpha1.RepositoryDigestMirrorsFluentImpl;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.openshift.api.model.operator.v1alpha1.ImageContentSourcePolicySpecBuilder;
import io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.PodNetworkConnectivityCheckListBuilder;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.model.runtime.RawExtension;
import io.fabric8.kubernetes.api.builder.Nested;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class IngressControllerSpecFluentImpl<A extends IngressControllerSpecFluent<A>> extends BaseFluent<A> implements IngressControllerSpecFluent<A>{
  public IngressControllerSpecFluentImpl() {
  }
  public IngressControllerSpecFluentImpl(IngressControllerSpec instance) {
    this.withClientTLS(instance.getClientTLS()); 
    this.withDefaultCertificate(instance.getDefaultCertificate()); 
    this.withDomain(instance.getDomain()); 
    this.withEndpointPublishingStrategy(instance.getEndpointPublishingStrategy()); 
    this.withHttpCompression(instance.getHttpCompression()); 
    this.withHttpEmptyRequestsPolicy(instance.getHttpEmptyRequestsPolicy()); 
    this.withHttpErrorCodePages(instance.getHttpErrorCodePages()); 
    this.withHttpHeaders(instance.getHttpHeaders()); 
    this.withLogging(instance.getLogging()); 
    this.withNamespaceSelector(instance.getNamespaceSelector()); 
    this.withNodePlacement(instance.getNodePlacement()); 
    this.withReplicas(instance.getReplicas()); 
    this.withRouteAdmission(instance.getRouteAdmission()); 
    this.withRouteSelector(instance.getRouteSelector()); 
    this.withTlsSecurityProfile(instance.getTlsSecurityProfile()); 
    this.withTuningOptions(instance.getTuningOptions()); 
    this.withUnsupportedConfigOverrides(instance.getUnsupportedConfigOverrides()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private ClientTLSBuilder clientTLS;
  private LocalObjectReferenceBuilder defaultCertificate;
  private String domain;
  private EndpointPublishingStrategyBuilder endpointPublishingStrategy;
  private HTTPCompressionPolicyBuilder httpCompression;
  private String httpEmptyRequestsPolicy;
  private ConfigMapNameReference httpErrorCodePages;
  private IngressControllerHTTPHeadersBuilder httpHeaders;
  private IngressControllerLoggingBuilder logging;
  private LabelSelectorBuilder namespaceSelector;
  private NodePlacementBuilder nodePlacement;
  private Integer replicas;
  private RouteAdmissionPolicyBuilder routeAdmission;
  private LabelSelectorBuilder routeSelector;
  private TLSSecurityProfile tlsSecurityProfile;
  private IngressControllerTuningOptionsBuilder tuningOptions;
  private VisitableBuilder<? extends KubernetesResource,?> unsupportedConfigOverrides;
  private Map<String,Object> additionalProperties;
  
  /**
   * This method has been deprecated, please use method buildClientTLS instead.
   * @return The buildable object.
   */
  @Deprecated
  public ClientTLS getClientTLS() {
    return this.clientTLS!=null ?this.clientTLS.build():null;
  }
  public ClientTLS buildClientTLS() {
    return this.clientTLS!=null ?this.clientTLS.build():null;
  }
  public A withClientTLS(ClientTLS clientTLS) {
    _visitables.get("clientTLS").remove(this.clientTLS);
    if (clientTLS!=null){ this.clientTLS= new ClientTLSBuilder(clientTLS); _visitables.get("clientTLS").add(this.clientTLS);} else { this.clientTLS = null; _visitables.get("clientTLS").remove(this.clientTLS); } return (A) this;
  }
  public Boolean hasClientTLS() {
    return this.clientTLS != null;
  }
  public IngressControllerSpecFluent.ClientTLSNested<A> withNewClientTLS() {
    return new IngressControllerSpecFluentImpl.ClientTLSNestedImpl();
  }
  public IngressControllerSpecFluent.ClientTLSNested<A> withNewClientTLSLike(ClientTLS item) {
    return new IngressControllerSpecFluentImpl.ClientTLSNestedImpl(item);
  }
  public IngressControllerSpecFluent.ClientTLSNested<A> editClientTLS() {
    return withNewClientTLSLike(getClientTLS());
  }
  public IngressControllerSpecFluent.ClientTLSNested<A> editOrNewClientTLS() {
    return withNewClientTLSLike(getClientTLS() != null ? getClientTLS(): new ClientTLSBuilder().build());
  }
  public IngressControllerSpecFluent.ClientTLSNested<A> editOrNewClientTLSLike(ClientTLS item) {
    return withNewClientTLSLike(getClientTLS() != null ? getClientTLS(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildDefaultCertificate instead.
   * @return The buildable object.
   */
  @Deprecated
  public LocalObjectReference getDefaultCertificate() {
    return this.defaultCertificate!=null ?this.defaultCertificate.build():null;
  }
  public LocalObjectReference buildDefaultCertificate() {
    return this.defaultCertificate!=null ?this.defaultCertificate.build():null;
  }
  public A withDefaultCertificate(LocalObjectReference defaultCertificate) {
    _visitables.get("defaultCertificate").remove(this.defaultCertificate);
    if (defaultCertificate!=null){ this.defaultCertificate= new LocalObjectReferenceBuilder(defaultCertificate); _visitables.get("defaultCertificate").add(this.defaultCertificate);} else { this.defaultCertificate = null; _visitables.get("defaultCertificate").remove(this.defaultCertificate); } return (A) this;
  }
  public Boolean hasDefaultCertificate() {
    return this.defaultCertificate != null;
  }
  public A withNewDefaultCertificate(String name) {
    return (A)withDefaultCertificate(new LocalObjectReference(name));
  }
  public IngressControllerSpecFluent.DefaultCertificateNested<A> withNewDefaultCertificate() {
    return new IngressControllerSpecFluentImpl.DefaultCertificateNestedImpl();
  }
  public IngressControllerSpecFluent.DefaultCertificateNested<A> withNewDefaultCertificateLike(LocalObjectReference item) {
    return new IngressControllerSpecFluentImpl.DefaultCertificateNestedImpl(item);
  }
  public IngressControllerSpecFluent.DefaultCertificateNested<A> editDefaultCertificate() {
    return withNewDefaultCertificateLike(getDefaultCertificate());
  }
  public IngressControllerSpecFluent.DefaultCertificateNested<A> editOrNewDefaultCertificate() {
    return withNewDefaultCertificateLike(getDefaultCertificate() != null ? getDefaultCertificate(): new LocalObjectReferenceBuilder().build());
  }
  public IngressControllerSpecFluent.DefaultCertificateNested<A> editOrNewDefaultCertificateLike(LocalObjectReference item) {
    return withNewDefaultCertificateLike(getDefaultCertificate() != null ? getDefaultCertificate(): item);
  }
  public String getDomain() {
    return this.domain;
  }
  public A withDomain(String domain) {
    this.domain=domain; return (A) this;
  }
  public Boolean hasDomain() {
    return this.domain != null;
  }
  
  /**
   * This method has been deprecated, please use method buildEndpointPublishingStrategy instead.
   * @return The buildable object.
   */
  @Deprecated
  public EndpointPublishingStrategy getEndpointPublishingStrategy() {
    return this.endpointPublishingStrategy!=null ?this.endpointPublishingStrategy.build():null;
  }
  public EndpointPublishingStrategy buildEndpointPublishingStrategy() {
    return this.endpointPublishingStrategy!=null ?this.endpointPublishingStrategy.build():null;
  }
  public A withEndpointPublishingStrategy(EndpointPublishingStrategy endpointPublishingStrategy) {
    _visitables.get("endpointPublishingStrategy").remove(this.endpointPublishingStrategy);
    if (endpointPublishingStrategy!=null){ this.endpointPublishingStrategy= new EndpointPublishingStrategyBuilder(endpointPublishingStrategy); _visitables.get("endpointPublishingStrategy").add(this.endpointPublishingStrategy);} else { this.endpointPublishingStrategy = null; _visitables.get("endpointPublishingStrategy").remove(this.endpointPublishingStrategy); } return (A) this;
  }
  public Boolean hasEndpointPublishingStrategy() {
    return this.endpointPublishingStrategy != null;
  }
  public IngressControllerSpecFluent.EndpointPublishingStrategyNested<A> withNewEndpointPublishingStrategy() {
    return new IngressControllerSpecFluentImpl.EndpointPublishingStrategyNestedImpl();
  }
  public IngressControllerSpecFluent.EndpointPublishingStrategyNested<A> withNewEndpointPublishingStrategyLike(EndpointPublishingStrategy item) {
    return new IngressControllerSpecFluentImpl.EndpointPublishingStrategyNestedImpl(item);
  }
  public IngressControllerSpecFluent.EndpointPublishingStrategyNested<A> editEndpointPublishingStrategy() {
    return withNewEndpointPublishingStrategyLike(getEndpointPublishingStrategy());
  }
  public IngressControllerSpecFluent.EndpointPublishingStrategyNested<A> editOrNewEndpointPublishingStrategy() {
    return withNewEndpointPublishingStrategyLike(getEndpointPublishingStrategy() != null ? getEndpointPublishingStrategy(): new EndpointPublishingStrategyBuilder().build());
  }
  public IngressControllerSpecFluent.EndpointPublishingStrategyNested<A> editOrNewEndpointPublishingStrategyLike(EndpointPublishingStrategy item) {
    return withNewEndpointPublishingStrategyLike(getEndpointPublishingStrategy() != null ? getEndpointPublishingStrategy(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildHttpCompression instead.
   * @return The buildable object.
   */
  @Deprecated
  public HTTPCompressionPolicy getHttpCompression() {
    return this.httpCompression!=null ?this.httpCompression.build():null;
  }
  public HTTPCompressionPolicy buildHttpCompression() {
    return this.httpCompression!=null ?this.httpCompression.build():null;
  }
  public A withHttpCompression(HTTPCompressionPolicy httpCompression) {
    _visitables.get("httpCompression").remove(this.httpCompression);
    if (httpCompression!=null){ this.httpCompression= new HTTPCompressionPolicyBuilder(httpCompression); _visitables.get("httpCompression").add(this.httpCompression);} else { this.httpCompression = null; _visitables.get("httpCompression").remove(this.httpCompression); } return (A) this;
  }
  public Boolean hasHttpCompression() {
    return this.httpCompression != null;
  }
  public IngressControllerSpecFluent.HttpCompressionNested<A> withNewHttpCompression() {
    return new IngressControllerSpecFluentImpl.HttpCompressionNestedImpl();
  }
  public IngressControllerSpecFluent.HttpCompressionNested<A> withNewHttpCompressionLike(HTTPCompressionPolicy item) {
    return new IngressControllerSpecFluentImpl.HttpCompressionNestedImpl(item);
  }
  public IngressControllerSpecFluent.HttpCompressionNested<A> editHttpCompression() {
    return withNewHttpCompressionLike(getHttpCompression());
  }
  public IngressControllerSpecFluent.HttpCompressionNested<A> editOrNewHttpCompression() {
    return withNewHttpCompressionLike(getHttpCompression() != null ? getHttpCompression(): new HTTPCompressionPolicyBuilder().build());
  }
  public IngressControllerSpecFluent.HttpCompressionNested<A> editOrNewHttpCompressionLike(HTTPCompressionPolicy item) {
    return withNewHttpCompressionLike(getHttpCompression() != null ? getHttpCompression(): item);
  }
  public String getHttpEmptyRequestsPolicy() {
    return this.httpEmptyRequestsPolicy;
  }
  public A withHttpEmptyRequestsPolicy(String httpEmptyRequestsPolicy) {
    this.httpEmptyRequestsPolicy=httpEmptyRequestsPolicy; return (A) this;
  }
  public Boolean hasHttpEmptyRequestsPolicy() {
    return this.httpEmptyRequestsPolicy != null;
  }
  public ConfigMapNameReference getHttpErrorCodePages() {
    return this.httpErrorCodePages;
  }
  public A withHttpErrorCodePages(ConfigMapNameReference httpErrorCodePages) {
    this.httpErrorCodePages=httpErrorCodePages; return (A) this;
  }
  public Boolean hasHttpErrorCodePages() {
    return this.httpErrorCodePages != null;
  }
  public A withNewHttpErrorCodePages(String name) {
    return (A)withHttpErrorCodePages(new ConfigMapNameReference(name));
  }
  
  /**
   * This method has been deprecated, please use method buildHttpHeaders instead.
   * @return The buildable object.
   */
  @Deprecated
  public IngressControllerHTTPHeaders getHttpHeaders() {
    return this.httpHeaders!=null ?this.httpHeaders.build():null;
  }
  public IngressControllerHTTPHeaders buildHttpHeaders() {
    return this.httpHeaders!=null ?this.httpHeaders.build():null;
  }
  public A withHttpHeaders(IngressControllerHTTPHeaders httpHeaders) {
    _visitables.get("httpHeaders").remove(this.httpHeaders);
    if (httpHeaders!=null){ this.httpHeaders= new IngressControllerHTTPHeadersBuilder(httpHeaders); _visitables.get("httpHeaders").add(this.httpHeaders);} else { this.httpHeaders = null; _visitables.get("httpHeaders").remove(this.httpHeaders); } return (A) this;
  }
  public Boolean hasHttpHeaders() {
    return this.httpHeaders != null;
  }
  public IngressControllerSpecFluent.HttpHeadersNested<A> withNewHttpHeaders() {
    return new IngressControllerSpecFluentImpl.HttpHeadersNestedImpl();
  }
  public IngressControllerSpecFluent.HttpHeadersNested<A> withNewHttpHeadersLike(IngressControllerHTTPHeaders item) {
    return new IngressControllerSpecFluentImpl.HttpHeadersNestedImpl(item);
  }
  public IngressControllerSpecFluent.HttpHeadersNested<A> editHttpHeaders() {
    return withNewHttpHeadersLike(getHttpHeaders());
  }
  public IngressControllerSpecFluent.HttpHeadersNested<A> editOrNewHttpHeaders() {
    return withNewHttpHeadersLike(getHttpHeaders() != null ? getHttpHeaders(): new IngressControllerHTTPHeadersBuilder().build());
  }
  public IngressControllerSpecFluent.HttpHeadersNested<A> editOrNewHttpHeadersLike(IngressControllerHTTPHeaders item) {
    return withNewHttpHeadersLike(getHttpHeaders() != null ? getHttpHeaders(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildLogging instead.
   * @return The buildable object.
   */
  @Deprecated
  public IngressControllerLogging getLogging() {
    return this.logging!=null ?this.logging.build():null;
  }
  public IngressControllerLogging buildLogging() {
    return this.logging!=null ?this.logging.build():null;
  }
  public A withLogging(IngressControllerLogging logging) {
    _visitables.get("logging").remove(this.logging);
    if (logging!=null){ this.logging= new IngressControllerLoggingBuilder(logging); _visitables.get("logging").add(this.logging);} else { this.logging = null; _visitables.get("logging").remove(this.logging); } return (A) this;
  }
  public Boolean hasLogging() {
    return this.logging != null;
  }
  public IngressControllerSpecFluent.LoggingNested<A> withNewLogging() {
    return new IngressControllerSpecFluentImpl.LoggingNestedImpl();
  }
  public IngressControllerSpecFluent.LoggingNested<A> withNewLoggingLike(IngressControllerLogging item) {
    return new IngressControllerSpecFluentImpl.LoggingNestedImpl(item);
  }
  public IngressControllerSpecFluent.LoggingNested<A> editLogging() {
    return withNewLoggingLike(getLogging());
  }
  public IngressControllerSpecFluent.LoggingNested<A> editOrNewLogging() {
    return withNewLoggingLike(getLogging() != null ? getLogging(): new IngressControllerLoggingBuilder().build());
  }
  public IngressControllerSpecFluent.LoggingNested<A> editOrNewLoggingLike(IngressControllerLogging item) {
    return withNewLoggingLike(getLogging() != null ? getLogging(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildNamespaceSelector instead.
   * @return The buildable object.
   */
  @Deprecated
  public LabelSelector getNamespaceSelector() {
    return this.namespaceSelector!=null ?this.namespaceSelector.build():null;
  }
  public LabelSelector buildNamespaceSelector() {
    return this.namespaceSelector!=null ?this.namespaceSelector.build():null;
  }
  public A withNamespaceSelector(LabelSelector namespaceSelector) {
    _visitables.get("namespaceSelector").remove(this.namespaceSelector);
    if (namespaceSelector!=null){ this.namespaceSelector= new LabelSelectorBuilder(namespaceSelector); _visitables.get("namespaceSelector").add(this.namespaceSelector);} else { this.namespaceSelector = null; _visitables.get("namespaceSelector").remove(this.namespaceSelector); } return (A) this;
  }
  public Boolean hasNamespaceSelector() {
    return this.namespaceSelector != null;
  }
  public IngressControllerSpecFluent.NamespaceSelectorNested<A> withNewNamespaceSelector() {
    return new IngressControllerSpecFluentImpl.NamespaceSelectorNestedImpl();
  }
  public IngressControllerSpecFluent.NamespaceSelectorNested<A> withNewNamespaceSelectorLike(LabelSelector item) {
    return new IngressControllerSpecFluentImpl.NamespaceSelectorNestedImpl(item);
  }
  public IngressControllerSpecFluent.NamespaceSelectorNested<A> editNamespaceSelector() {
    return withNewNamespaceSelectorLike(getNamespaceSelector());
  }
  public IngressControllerSpecFluent.NamespaceSelectorNested<A> editOrNewNamespaceSelector() {
    return withNewNamespaceSelectorLike(getNamespaceSelector() != null ? getNamespaceSelector(): new LabelSelectorBuilder().build());
  }
  public IngressControllerSpecFluent.NamespaceSelectorNested<A> editOrNewNamespaceSelectorLike(LabelSelector item) {
    return withNewNamespaceSelectorLike(getNamespaceSelector() != null ? getNamespaceSelector(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildNodePlacement instead.
   * @return The buildable object.
   */
  @Deprecated
  public NodePlacement getNodePlacement() {
    return this.nodePlacement!=null ?this.nodePlacement.build():null;
  }
  public NodePlacement buildNodePlacement() {
    return this.nodePlacement!=null ?this.nodePlacement.build():null;
  }
  public A withNodePlacement(NodePlacement nodePlacement) {
    _visitables.get("nodePlacement").remove(this.nodePlacement);
    if (nodePlacement!=null){ this.nodePlacement= new NodePlacementBuilder(nodePlacement); _visitables.get("nodePlacement").add(this.nodePlacement);} else { this.nodePlacement = null; _visitables.get("nodePlacement").remove(this.nodePlacement); } return (A) this;
  }
  public Boolean hasNodePlacement() {
    return this.nodePlacement != null;
  }
  public IngressControllerSpecFluent.NodePlacementNested<A> withNewNodePlacement() {
    return new IngressControllerSpecFluentImpl.NodePlacementNestedImpl();
  }
  public IngressControllerSpecFluent.NodePlacementNested<A> withNewNodePlacementLike(NodePlacement item) {
    return new IngressControllerSpecFluentImpl.NodePlacementNestedImpl(item);
  }
  public IngressControllerSpecFluent.NodePlacementNested<A> editNodePlacement() {
    return withNewNodePlacementLike(getNodePlacement());
  }
  public IngressControllerSpecFluent.NodePlacementNested<A> editOrNewNodePlacement() {
    return withNewNodePlacementLike(getNodePlacement() != null ? getNodePlacement(): new NodePlacementBuilder().build());
  }
  public IngressControllerSpecFluent.NodePlacementNested<A> editOrNewNodePlacementLike(NodePlacement item) {
    return withNewNodePlacementLike(getNodePlacement() != null ? getNodePlacement(): item);
  }
  public Integer getReplicas() {
    return this.replicas;
  }
  public A withReplicas(Integer replicas) {
    this.replicas=replicas; return (A) this;
  }
  public Boolean hasReplicas() {
    return this.replicas != null;
  }
  
  /**
   * This method has been deprecated, please use method buildRouteAdmission instead.
   * @return The buildable object.
   */
  @Deprecated
  public RouteAdmissionPolicy getRouteAdmission() {
    return this.routeAdmission!=null ?this.routeAdmission.build():null;
  }
  public RouteAdmissionPolicy buildRouteAdmission() {
    return this.routeAdmission!=null ?this.routeAdmission.build():null;
  }
  public A withRouteAdmission(RouteAdmissionPolicy routeAdmission) {
    _visitables.get("routeAdmission").remove(this.routeAdmission);
    if (routeAdmission!=null){ this.routeAdmission= new RouteAdmissionPolicyBuilder(routeAdmission); _visitables.get("routeAdmission").add(this.routeAdmission);} else { this.routeAdmission = null; _visitables.get("routeAdmission").remove(this.routeAdmission); } return (A) this;
  }
  public Boolean hasRouteAdmission() {
    return this.routeAdmission != null;
  }
  public A withNewRouteAdmission(String namespaceOwnership,String wildcardPolicy) {
    return (A)withRouteAdmission(new RouteAdmissionPolicy(namespaceOwnership, wildcardPolicy));
  }
  public IngressControllerSpecFluent.RouteAdmissionNested<A> withNewRouteAdmission() {
    return new IngressControllerSpecFluentImpl.RouteAdmissionNestedImpl();
  }
  public IngressControllerSpecFluent.RouteAdmissionNested<A> withNewRouteAdmissionLike(RouteAdmissionPolicy item) {
    return new IngressControllerSpecFluentImpl.RouteAdmissionNestedImpl(item);
  }
  public IngressControllerSpecFluent.RouteAdmissionNested<A> editRouteAdmission() {
    return withNewRouteAdmissionLike(getRouteAdmission());
  }
  public IngressControllerSpecFluent.RouteAdmissionNested<A> editOrNewRouteAdmission() {
    return withNewRouteAdmissionLike(getRouteAdmission() != null ? getRouteAdmission(): new RouteAdmissionPolicyBuilder().build());
  }
  public IngressControllerSpecFluent.RouteAdmissionNested<A> editOrNewRouteAdmissionLike(RouteAdmissionPolicy item) {
    return withNewRouteAdmissionLike(getRouteAdmission() != null ? getRouteAdmission(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildRouteSelector instead.
   * @return The buildable object.
   */
  @Deprecated
  public LabelSelector getRouteSelector() {
    return this.routeSelector!=null ?this.routeSelector.build():null;
  }
  public LabelSelector buildRouteSelector() {
    return this.routeSelector!=null ?this.routeSelector.build():null;
  }
  public A withRouteSelector(LabelSelector routeSelector) {
    _visitables.get("routeSelector").remove(this.routeSelector);
    if (routeSelector!=null){ this.routeSelector= new LabelSelectorBuilder(routeSelector); _visitables.get("routeSelector").add(this.routeSelector);} else { this.routeSelector = null; _visitables.get("routeSelector").remove(this.routeSelector); } return (A) this;
  }
  public Boolean hasRouteSelector() {
    return this.routeSelector != null;
  }
  public IngressControllerSpecFluent.RouteSelectorNested<A> withNewRouteSelector() {
    return new IngressControllerSpecFluentImpl.RouteSelectorNestedImpl();
  }
  public IngressControllerSpecFluent.RouteSelectorNested<A> withNewRouteSelectorLike(LabelSelector item) {
    return new IngressControllerSpecFluentImpl.RouteSelectorNestedImpl(item);
  }
  public IngressControllerSpecFluent.RouteSelectorNested<A> editRouteSelector() {
    return withNewRouteSelectorLike(getRouteSelector());
  }
  public IngressControllerSpecFluent.RouteSelectorNested<A> editOrNewRouteSelector() {
    return withNewRouteSelectorLike(getRouteSelector() != null ? getRouteSelector(): new LabelSelectorBuilder().build());
  }
  public IngressControllerSpecFluent.RouteSelectorNested<A> editOrNewRouteSelectorLike(LabelSelector item) {
    return withNewRouteSelectorLike(getRouteSelector() != null ? getRouteSelector(): item);
  }
  public TLSSecurityProfile getTlsSecurityProfile() {
    return this.tlsSecurityProfile;
  }
  public A withTlsSecurityProfile(TLSSecurityProfile tlsSecurityProfile) {
    this.tlsSecurityProfile=tlsSecurityProfile; return (A) this;
  }
  public Boolean hasTlsSecurityProfile() {
    return this.tlsSecurityProfile != null;
  }
  
  /**
   * This method has been deprecated, please use method buildTuningOptions instead.
   * @return The buildable object.
   */
  @Deprecated
  public IngressControllerTuningOptions getTuningOptions() {
    return this.tuningOptions!=null ?this.tuningOptions.build():null;
  }
  public IngressControllerTuningOptions buildTuningOptions() {
    return this.tuningOptions!=null ?this.tuningOptions.build():null;
  }
  public A withTuningOptions(IngressControllerTuningOptions tuningOptions) {
    _visitables.get("tuningOptions").remove(this.tuningOptions);
    if (tuningOptions!=null){ this.tuningOptions= new IngressControllerTuningOptionsBuilder(tuningOptions); _visitables.get("tuningOptions").add(this.tuningOptions);} else { this.tuningOptions = null; _visitables.get("tuningOptions").remove(this.tuningOptions); } return (A) this;
  }
  public Boolean hasTuningOptions() {
    return this.tuningOptions != null;
  }
  public IngressControllerSpecFluent.TuningOptionsNested<A> withNewTuningOptions() {
    return new IngressControllerSpecFluentImpl.TuningOptionsNestedImpl();
  }
  public IngressControllerSpecFluent.TuningOptionsNested<A> withNewTuningOptionsLike(IngressControllerTuningOptions item) {
    return new IngressControllerSpecFluentImpl.TuningOptionsNestedImpl(item);
  }
  public IngressControllerSpecFluent.TuningOptionsNested<A> editTuningOptions() {
    return withNewTuningOptionsLike(getTuningOptions());
  }
  public IngressControllerSpecFluent.TuningOptionsNested<A> editOrNewTuningOptions() {
    return withNewTuningOptionsLike(getTuningOptions() != null ? getTuningOptions(): new IngressControllerTuningOptionsBuilder().build());
  }
  public IngressControllerSpecFluent.TuningOptionsNested<A> editOrNewTuningOptionsLike(IngressControllerTuningOptions item) {
    return withNewTuningOptionsLike(getTuningOptions() != null ? getTuningOptions(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildUnsupportedConfigOverrides instead.
   * @return The buildable object.
   */
  @Deprecated
  public KubernetesResource getUnsupportedConfigOverrides() {
    return this.unsupportedConfigOverrides!=null?this.unsupportedConfigOverrides.build():null;
  }
  public KubernetesResource buildUnsupportedConfigOverrides() {
    return this.unsupportedConfigOverrides!=null?this.unsupportedConfigOverrides.build():null;
  }
  public A withUnsupportedConfigOverrides(KubernetesResource unsupportedConfigOverrides) {
    if (unsupportedConfigOverrides instanceof ServiceCatalogAPIServerList){ this.unsupportedConfigOverrides= new ServiceCatalogAPIServerListBuilder((ServiceCatalogAPIServerList)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof LabelSelector){ this.unsupportedConfigOverrides= new LabelSelectorBuilder((LabelSelector)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof ImagePruner){ this.unsupportedConfigOverrides= new ImagePrunerBuilder((ImagePruner)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof KubeControllerManager){ this.unsupportedConfigOverrides= new KubeControllerManagerBuilder((KubeControllerManager)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof PodNetworkConnectivityCheckStatus){ this.unsupportedConfigOverrides= new PodNetworkConnectivityCheckStatusBuilder((PodNetworkConnectivityCheckStatus)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof KubeStorageVersionMigratorList){ this.unsupportedConfigOverrides= new KubeStorageVersionMigratorListBuilder((KubeStorageVersionMigratorList)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof Storage){ this.unsupportedConfigOverrides= new StorageBuilder((Storage)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof PodTemplateSpec){ this.unsupportedConfigOverrides= new PodTemplateSpecBuilder((PodTemplateSpec)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof KubeControllerManagerStatus){ this.unsupportedConfigOverrides= new KubeControllerManagerStatusBuilder((KubeControllerManagerStatus)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof ServiceCatalogControllerManagerList){ this.unsupportedConfigOverrides= new ServiceCatalogControllerManagerListBuilder((ServiceCatalogControllerManagerList)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof CSISnapshotControllerStatus){ this.unsupportedConfigOverrides= new CSISnapshotControllerStatusBuilder((CSISnapshotControllerStatus)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof IPsecConfig){ this.unsupportedConfigOverrides= new IPsecConfigBuilder((IPsecConfig)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof ImageContentSourcePolicy){ this.unsupportedConfigOverrides= new ImageContentSourcePolicyBuilder((ImageContentSourcePolicy)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof ResourceRequirements){ this.unsupportedConfigOverrides= new ResourceRequirementsBuilder((ResourceRequirements)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof OVNKubernetesConfig){ this.unsupportedConfigOverrides= new OVNKubernetesConfigBuilder((OVNKubernetesConfig)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof DeveloperConsoleCatalogCategoryMeta){ this.unsupportedConfigOverrides= new DeveloperConsoleCatalogCategoryMetaBuilder((DeveloperConsoleCatalogCategoryMeta)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof KubeStorageVersionMigratorSpec){ this.unsupportedConfigOverrides= new KubeStorageVersionMigratorSpecBuilder((KubeStorageVersionMigratorSpec)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof IngressControllerSpec){ this.unsupportedConfigOverrides= new IngressControllerSpecBuilder((IngressControllerSpec)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof DNSSpec){ this.unsupportedConfigOverrides= new DNSSpecBuilder((DNSSpec)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof OpenShiftSDNConfig){ this.unsupportedConfigOverrides= new OpenShiftSDNConfigBuilder((OpenShiftSDNConfig)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof OperatorCondition){ this.unsupportedConfigOverrides= new OperatorConditionBuilder((OperatorCondition)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof IngressControllerHTTPHeaders){ this.unsupportedConfigOverrides= new IngressControllerHTTPHeadersBuilder((IngressControllerHTTPHeaders)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof ProxyConfig){ this.unsupportedConfigOverrides= new ProxyConfigBuilder((ProxyConfig)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof ConsoleList){ this.unsupportedConfigOverrides= new ConsoleListBuilder((ConsoleList)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof KuryrConfig){ this.unsupportedConfigOverrides= new KuryrConfigBuilder((KuryrConfig)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof DeveloperConsoleCatalogCategory){ this.unsupportedConfigOverrides= new DeveloperConsoleCatalogCategoryBuilder((DeveloperConsoleCatalogCategory)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof OpenShiftControllerManagerSpec){ this.unsupportedConfigOverrides= new OpenShiftControllerManagerSpecBuilder((OpenShiftControllerManagerSpec)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof ExportNetworkFlows){ this.unsupportedConfigOverrides= new ExportNetworkFlowsBuilder((ExportNetworkFlows)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof ClusterCSIDriverSpec){ this.unsupportedConfigOverrides= new ClusterCSIDriverSpecBuilder((ClusterCSIDriverSpec)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof ServiceCatalogAPIServerSpec){ this.unsupportedConfigOverrides= new ServiceCatalogAPIServerSpecBuilder((ServiceCatalogAPIServerSpec)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof ImageContentSourcePolicySpec){ this.unsupportedConfigOverrides= new ImageContentSourcePolicySpecBuilder((ImageContentSourcePolicySpec)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof RepositoryDigestMirrors){ this.unsupportedConfigOverrides= new RepositoryDigestMirrorsBuilder((RepositoryDigestMirrors)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof ConsoleCustomization){ this.unsupportedConfigOverrides= new ConsoleCustomizationBuilder((ConsoleCustomization)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof CSISnapshotControllerSpec){ this.unsupportedConfigOverrides= new CSISnapshotControllerSpecBuilder((CSISnapshotControllerSpec)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof UpstreamResolvers){ this.unsupportedConfigOverrides= new UpstreamResolversBuilder((UpstreamResolvers)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof DNSStatus){ this.unsupportedConfigOverrides= new DNSStatusBuilder((DNSStatus)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof IngressControllerHTTPUniqueIdHeaderPolicy){ this.unsupportedConfigOverrides= new IngressControllerHTTPUniqueIdHeaderPolicyBuilder((IngressControllerHTTPUniqueIdHeaderPolicy)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof GCPLoadBalancerParameters){ this.unsupportedConfigOverrides= new GCPLoadBalancerParametersBuilder((GCPLoadBalancerParameters)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof ConfigStatus){ this.unsupportedConfigOverrides= new ConfigStatusBuilder((ConfigStatus)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof KubeAPIServerList){ this.unsupportedConfigOverrides= new KubeAPIServerListBuilder((KubeAPIServerList)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof ServiceCA){ this.unsupportedConfigOverrides= new ServiceCABuilder((ServiceCA)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof ServiceCatalogControllerManagerSpec){ this.unsupportedConfigOverrides= new ServiceCatalogControllerManagerSpecBuilder((ServiceCatalogControllerManagerSpec)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof Config){ this.unsupportedConfigOverrides= new ConfigBuilder((Config)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof IngressControllerList){ this.unsupportedConfigOverrides= new IngressControllerListBuilder((IngressControllerList)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof DNSList){ this.unsupportedConfigOverrides= new DNSListBuilder((DNSList)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof ObjectMeta){ this.unsupportedConfigOverrides= new ObjectMetaBuilder((ObjectMeta)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof ClusterCSIDriverList){ this.unsupportedConfigOverrides= new ClusterCSIDriverListBuilder((ClusterCSIDriverList)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof SimpleMacvlanConfig){ this.unsupportedConfigOverrides= new SimpleMacvlanConfigBuilder((SimpleMacvlanConfig)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof PersistentVolumeClaim){ this.unsupportedConfigOverrides= new PersistentVolumeClaimBuilder((PersistentVolumeClaim)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof KubeAPIServerStatus){ this.unsupportedConfigOverrides= new KubeAPIServerStatusBuilder((KubeAPIServerStatus)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof AWSClassicLoadBalancerParameters){ this.unsupportedConfigOverrides= new AWSClassicLoadBalancerParametersBuilder((AWSClassicLoadBalancerParameters)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof KubeAPIServer){ this.unsupportedConfigOverrides= new KubeAPIServerBuilder((KubeAPIServer)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof IngressController){ this.unsupportedConfigOverrides= new IngressControllerBuilder((IngressController)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof ConsoleConfigRoute){ this.unsupportedConfigOverrides= new ConsoleConfigRouteBuilder((ConsoleConfigRoute)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof CloudCredentialStatus){ this.unsupportedConfigOverrides= new CloudCredentialStatusBuilder((CloudCredentialStatus)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof KubeStorageVersionMigrator){ this.unsupportedConfigOverrides= new KubeStorageVersionMigratorBuilder((KubeStorageVersionMigrator)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof GenericKubernetesResource){ this.unsupportedConfigOverrides= new GenericKubernetesResourceBuilder((GenericKubernetesResource)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof IngressControllerStatus){ this.unsupportedConfigOverrides= new IngressControllerStatusBuilder((IngressControllerStatus)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof ServiceCatalogControllerManagerStatus){ this.unsupportedConfigOverrides= new ServiceCatalogControllerManagerStatusBuilder((ServiceCatalogControllerManagerStatus)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof HybridOverlayConfig){ this.unsupportedConfigOverrides= new HybridOverlayConfigBuilder((HybridOverlayConfig)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof AWSLoadBalancerParameters){ this.unsupportedConfigOverrides= new AWSLoadBalancerParametersBuilder((AWSLoadBalancerParameters)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof ImagePrunerList){ this.unsupportedConfigOverrides= new ImagePrunerListBuilder((ImagePrunerList)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof CSISnapshotControllerList){ this.unsupportedConfigOverrides= new CSISnapshotControllerListBuilder((CSISnapshotControllerList)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof LocalObjectReference){ this.unsupportedConfigOverrides= new LocalObjectReferenceBuilder((LocalObjectReference)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof Console){ this.unsupportedConfigOverrides= new ConsoleBuilder((Console)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof StaticIPAMRoutes){ this.unsupportedConfigOverrides= new StaticIPAMRoutesBuilder((StaticIPAMRoutes)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof DNSZoneCondition){ this.unsupportedConfigOverrides= new DNSZoneConditionBuilder((DNSZoneCondition)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof ContainerLoggingDestinationParameters){ this.unsupportedConfigOverrides= new ContainerLoggingDestinationParametersBuilder((ContainerLoggingDestinationParameters)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof KubeSchedulerList){ this.unsupportedConfigOverrides= new KubeSchedulerListBuilder((KubeSchedulerList)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof KubeAPIServerSpec){ this.unsupportedConfigOverrides= new KubeAPIServerSpecBuilder((KubeAPIServerSpec)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof ClusterCSIDriver){ this.unsupportedConfigOverrides= new ClusterCSIDriverBuilder((ClusterCSIDriver)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof QuickStarts){ this.unsupportedConfigOverrides= new QuickStartsBuilder((QuickStarts)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof DNSZoneStatus){ this.unsupportedConfigOverrides= new DNSZoneStatusBuilder((DNSZoneStatus)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof OpenShiftControllerManager){ this.unsupportedConfigOverrides= new OpenShiftControllerManagerBuilder((OpenShiftControllerManager)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof ConfigSpec){ this.unsupportedConfigOverrides= new ConfigSpecBuilder((ConfigSpec)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof OutageEntry){ this.unsupportedConfigOverrides= new OutageEntryBuilder((OutageEntry)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof OpenShiftControllerManagerList){ this.unsupportedConfigOverrides= new OpenShiftControllerManagerListBuilder((OpenShiftControllerManagerList)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof Etcd){ this.unsupportedConfigOverrides= new EtcdBuilder((Etcd)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof EndpointPublishingStrategy){ this.unsupportedConfigOverrides= new EndpointPublishingStrategyBuilder((EndpointPublishingStrategy)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof IPFIXConfig){ this.unsupportedConfigOverrides= new IPFIXConfigBuilder((IPFIXConfig)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof CloudCredential){ this.unsupportedConfigOverrides= new CloudCredentialBuilder((CloudCredential)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof KubeScheduler){ this.unsupportedConfigOverrides= new KubeSchedulerBuilder((KubeScheduler)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof ClusterCSIDriverStatus){ this.unsupportedConfigOverrides= new ClusterCSIDriverStatusBuilder((ClusterCSIDriverStatus)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof NetworkStatus){ this.unsupportedConfigOverrides= new NetworkStatusBuilder((NetworkStatus)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof SFlowConfig){ this.unsupportedConfigOverrides= new SFlowConfigBuilder((SFlowConfig)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof ForwardPlugin){ this.unsupportedConfigOverrides= new ForwardPluginBuilder((ForwardPlugin)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof LogEntry){ this.unsupportedConfigOverrides= new LogEntryBuilder((LogEntry)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof NodeStatus){ this.unsupportedConfigOverrides= new NodeStatusBuilder((NodeStatus)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof PodNetworkConnectivityCheckCondition){ this.unsupportedConfigOverrides= new PodNetworkConnectivityCheckConditionBuilder((PodNetworkConnectivityCheckCondition)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof AdditionalNetworkDefinition){ this.unsupportedConfigOverrides= new AdditionalNetworkDefinitionBuilder((AdditionalNetworkDefinition)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof RouteAdmissionPolicy){ this.unsupportedConfigOverrides= new RouteAdmissionPolicyBuilder((RouteAdmissionPolicy)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof GenerationStatus){ this.unsupportedConfigOverrides= new GenerationStatusBuilder((GenerationStatus)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof AuthenticationStatus){ this.unsupportedConfigOverrides= new AuthenticationStatusBuilder((AuthenticationStatus)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof IngressControllerCaptureHTTPHeaders){ this.unsupportedConfigOverrides= new IngressControllerCaptureHTTPHeadersBuilder((IngressControllerCaptureHTTPHeaders)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof EtcdList){ this.unsupportedConfigOverrides= new EtcdListBuilder((EtcdList)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof NodePortStrategy){ this.unsupportedConfigOverrides= new NodePortStrategyBuilder((NodePortStrategy)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof DefaultNetworkDefinition){ this.unsupportedConfigOverrides= new DefaultNetworkDefinitionBuilder((DefaultNetworkDefinition)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof Network){ this.unsupportedConfigOverrides= new NetworkBuilder((Network)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof ClientTLS){ this.unsupportedConfigOverrides= new ClientTLSBuilder((ClientTLS)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof OpenShiftAPIServerSpec){ this.unsupportedConfigOverrides= new OpenShiftAPIServerSpecBuilder((OpenShiftAPIServerSpec)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof ImagePrunerStatus){ this.unsupportedConfigOverrides= new ImagePrunerStatusBuilder((ImagePrunerStatus)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof KubeSchedulerStatus){ this.unsupportedConfigOverrides= new KubeSchedulerStatusBuilder((KubeSchedulerStatus)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof SyslogLoggingDestinationParameters){ this.unsupportedConfigOverrides= new SyslogLoggingDestinationParametersBuilder((SyslogLoggingDestinationParameters)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof Upstream){ this.unsupportedConfigOverrides= new UpstreamBuilder((Upstream)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof AWSNetworkLoadBalancerParameters){ this.unsupportedConfigOverrides= new AWSNetworkLoadBalancerParametersBuilder((AWSNetworkLoadBalancerParameters)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof ServiceCAList){ this.unsupportedConfigOverrides= new ServiceCAListBuilder((ServiceCAList)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof ServiceCatalogAPIServer){ this.unsupportedConfigOverrides= new ServiceCatalogAPIServerBuilder((ServiceCatalogAPIServer)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof IngressControllerCaptureHTTPHeader){ this.unsupportedConfigOverrides= new IngressControllerCaptureHTTPHeaderBuilder((IngressControllerCaptureHTTPHeader)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof NetworkMigration){ this.unsupportedConfigOverrides= new NetworkMigrationBuilder((NetworkMigration)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof DNSRecordList){ this.unsupportedConfigOverrides= new DNSRecordListBuilder((DNSRecordList)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof RawExtension){ this.unsupportedConfigOverrides= new RawExtensionBuilder((RawExtension)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof EtcdSpec){ this.unsupportedConfigOverrides= new EtcdSpecBuilder((EtcdSpec)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof PodNetworkConnectivityCheck){ this.unsupportedConfigOverrides= new PodNetworkConnectivityCheckBuilder((PodNetworkConnectivityCheck)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof OpenShiftAPIServerStatus){ this.unsupportedConfigOverrides= new OpenShiftAPIServerStatusBuilder((OpenShiftAPIServerStatus)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof LoadBalancerStrategy){ this.unsupportedConfigOverrides= new LoadBalancerStrategyBuilder((LoadBalancerStrategy)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof EtcdStatus){ this.unsupportedConfigOverrides= new EtcdStatusBuilder((EtcdStatus)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof CloudCredentialList){ this.unsupportedConfigOverrides= new CloudCredentialListBuilder((CloudCredentialList)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof ImagePrunerSpec){ this.unsupportedConfigOverrides= new ImagePrunerSpecBuilder((ImagePrunerSpec)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof StatuspageProvider){ this.unsupportedConfigOverrides= new StatuspageProviderBuilder((StatuspageProvider)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof KubeStorageVersionMigratorStatus){ this.unsupportedConfigOverrides= new KubeStorageVersionMigratorStatusBuilder((KubeStorageVersionMigratorStatus)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof ConfigList){ this.unsupportedConfigOverrides= new ConfigListBuilder((ConfigList)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof ConsoleProviders){ this.unsupportedConfigOverrides= new ConsoleProvidersBuilder((ConsoleProviders)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof IngressControllerLogging){ this.unsupportedConfigOverrides= new IngressControllerLoggingBuilder((IngressControllerLogging)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof AuthenticationList){ this.unsupportedConfigOverrides= new AuthenticationListBuilder((AuthenticationList)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof StorageStatus){ this.unsupportedConfigOverrides= new StorageStatusBuilder((StorageStatus)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof KubeControllerManagerList){ this.unsupportedConfigOverrides= new KubeControllerManagerListBuilder((KubeControllerManagerList)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof AuthenticationSpec){ this.unsupportedConfigOverrides= new AuthenticationSpecBuilder((AuthenticationSpec)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof IPAMConfig){ this.unsupportedConfigOverrides= new IPAMConfigBuilder((IPAMConfig)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof Container){ this.unsupportedConfigOverrides= new ContainerBuilder((Container)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof CSISnapshotController){ this.unsupportedConfigOverrides= new CSISnapshotControllerBuilder((CSISnapshotController)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof PodNetworkConnectivityCheckSpec){ this.unsupportedConfigOverrides= new PodNetworkConnectivityCheckSpecBuilder((PodNetworkConnectivityCheckSpec)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof AccessLogging){ this.unsupportedConfigOverrides= new AccessLoggingBuilder((AccessLogging)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof HostNetworkStrategy){ this.unsupportedConfigOverrides= new HostNetworkStrategyBuilder((HostNetworkStrategy)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof DNSRecordSpec){ this.unsupportedConfigOverrides= new DNSRecordSpecBuilder((DNSRecordSpec)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof DeveloperConsoleCatalogCustomization){ this.unsupportedConfigOverrides= new DeveloperConsoleCatalogCustomizationBuilder((DeveloperConsoleCatalogCustomization)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof KubeSchedulerSpec){ this.unsupportedConfigOverrides= new KubeSchedulerSpecBuilder((KubeSchedulerSpec)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof LoggingDestination){ this.unsupportedConfigOverrides= new LoggingDestinationBuilder((LoggingDestination)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof IngressControllerTuningOptions){ this.unsupportedConfigOverrides= new IngressControllerTuningOptionsBuilder((IngressControllerTuningOptions)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof StaticIPAMConfig){ this.unsupportedConfigOverrides= new StaticIPAMConfigBuilder((StaticIPAMConfig)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof ImageContentSourcePolicyList){ this.unsupportedConfigOverrides= new ImageContentSourcePolicyListBuilder((ImageContentSourcePolicyList)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof OpenShiftControllerManagerStatus){ this.unsupportedConfigOverrides= new OpenShiftControllerManagerStatusBuilder((OpenShiftControllerManagerStatus)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof ServiceCatalogAPIServerStatus){ this.unsupportedConfigOverrides= new ServiceCatalogAPIServerStatusBuilder((ServiceCatalogAPIServerStatus)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof KubeControllerManagerSpec){ this.unsupportedConfigOverrides= new KubeControllerManagerSpecBuilder((KubeControllerManagerSpec)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof StaticIPAMDNS){ this.unsupportedConfigOverrides= new StaticIPAMDNSBuilder((StaticIPAMDNS)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof DNSNodePlacement){ this.unsupportedConfigOverrides= new DNSNodePlacementBuilder((DNSNodePlacement)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof StorageSpec){ this.unsupportedConfigOverrides= new StorageSpecBuilder((StorageSpec)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof NetworkList){ this.unsupportedConfigOverrides= new NetworkListBuilder((NetworkList)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof NodePlacement){ this.unsupportedConfigOverrides= new NodePlacementBuilder((NodePlacement)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof ProviderLoadBalancerParameters){ this.unsupportedConfigOverrides= new ProviderLoadBalancerParametersBuilder((ProviderLoadBalancerParameters)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof NetworkSpec){ this.unsupportedConfigOverrides= new NetworkSpecBuilder((NetworkSpec)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof ServiceCASpec){ this.unsupportedConfigOverrides= new ServiceCASpecBuilder((ServiceCASpec)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof PrivateStrategy){ this.unsupportedConfigOverrides= new PrivateStrategyBuilder((PrivateStrategy)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof ConsoleStatus){ this.unsupportedConfigOverrides= new ConsoleStatusBuilder((ConsoleStatus)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof PodNetworkConnectivityCheckList){ this.unsupportedConfigOverrides= new PodNetworkConnectivityCheckListBuilder((PodNetworkConnectivityCheckList)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof ObjectReference){ this.unsupportedConfigOverrides= new ObjectReferenceBuilder((ObjectReference)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof OpenShiftAPIServerList){ this.unsupportedConfigOverrides= new OpenShiftAPIServerListBuilder((OpenShiftAPIServerList)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof Server){ this.unsupportedConfigOverrides= new ServerBuilder((Server)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof OAuthAPIServerStatus){ this.unsupportedConfigOverrides= new OAuthAPIServerStatusBuilder((OAuthAPIServerStatus)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof CloudCredentialSpec){ this.unsupportedConfigOverrides= new CloudCredentialSpecBuilder((CloudCredentialSpec)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof DNSRecordStatus){ this.unsupportedConfigOverrides= new DNSRecordStatusBuilder((DNSRecordStatus)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof ServiceCatalogControllerManager){ this.unsupportedConfigOverrides= new ServiceCatalogControllerManagerBuilder((ServiceCatalogControllerManager)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof ClusterNetworkEntry){ this.unsupportedConfigOverrides= new ClusterNetworkEntryBuilder((ClusterNetworkEntry)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof IngressControllerCaptureHTTPCookie){ this.unsupportedConfigOverrides= new IngressControllerCaptureHTTPCookieBuilder((IngressControllerCaptureHTTPCookie)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof HTTPCompressionPolicy){ this.unsupportedConfigOverrides= new HTTPCompressionPolicyBuilder((HTTPCompressionPolicy)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof ProjectAccess){ this.unsupportedConfigOverrides= new ProjectAccessBuilder((ProjectAccess)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof DNS){ this.unsupportedConfigOverrides= new DNSBuilder((DNS)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof NetFlowConfig){ this.unsupportedConfigOverrides= new NetFlowConfigBuilder((NetFlowConfig)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof PolicyAuditConfig){ this.unsupportedConfigOverrides= new PolicyAuditConfigBuilder((PolicyAuditConfig)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof AddPage){ this.unsupportedConfigOverrides= new AddPageBuilder((AddPage)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof StorageList){ this.unsupportedConfigOverrides= new StorageListBuilder((StorageList)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof StaticIPAMAddresses){ this.unsupportedConfigOverrides= new StaticIPAMAddressesBuilder((StaticIPAMAddresses)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof DNSRecord){ this.unsupportedConfigOverrides= new DNSRecordBuilder((DNSRecord)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof OpenShiftAPIServer){ this.unsupportedConfigOverrides= new OpenShiftAPIServerBuilder((OpenShiftAPIServer)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof Authentication){ this.unsupportedConfigOverrides= new AuthenticationBuilder((Authentication)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof ConsoleSpec){ this.unsupportedConfigOverrides= new ConsoleSpecBuilder((ConsoleSpec)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof ServiceCAStatus){ this.unsupportedConfigOverrides= new ServiceCAStatusBuilder((ServiceCAStatus)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    return (A) this;
  }
  public Boolean hasUnsupportedConfigOverrides() {
    return this.unsupportedConfigOverrides != null;
  }
  public A withServiceCatalogAPIServerListUnsupportedConfigOverrides(ServiceCatalogAPIServerList serviceCatalogAPIServerListUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (serviceCatalogAPIServerListUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new ServiceCatalogAPIServerListBuilder(serviceCatalogAPIServerListUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.ServiceCatalogAPIServerListUnsupportedConfigOverridesNested<A> withNewServiceCatalogAPIServerListUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.ServiceCatalogAPIServerListUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.ServiceCatalogAPIServerListUnsupportedConfigOverridesNested<A> withNewServiceCatalogAPIServerListUnsupportedConfigOverridesLike(ServiceCatalogAPIServerList item) {
    return new IngressControllerSpecFluentImpl.ServiceCatalogAPIServerListUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withLabelSelectorUnsupportedConfigOverrides(LabelSelector labelSelectorUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (labelSelectorUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new LabelSelectorBuilder(labelSelectorUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.LabelSelectorUnsupportedConfigOverridesNested<A> withNewLabelSelectorUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.LabelSelectorUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.LabelSelectorUnsupportedConfigOverridesNested<A> withNewLabelSelectorUnsupportedConfigOverridesLike(LabelSelector item) {
    return new IngressControllerSpecFluentImpl.LabelSelectorUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withImagePrunerUnsupportedConfigOverrides(ImagePruner imagePrunerUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (imagePrunerUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new ImagePrunerBuilder(imagePrunerUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.ImagePrunerUnsupportedConfigOverridesNested<A> withNewImagePrunerUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.ImagePrunerUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.ImagePrunerUnsupportedConfigOverridesNested<A> withNewImagePrunerUnsupportedConfigOverridesLike(ImagePruner item) {
    return new IngressControllerSpecFluentImpl.ImagePrunerUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withKubeControllerManagerUnsupportedConfigOverrides(KubeControllerManager kubeControllerManagerUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (kubeControllerManagerUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new KubeControllerManagerBuilder(kubeControllerManagerUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.KubeControllerManagerUnsupportedConfigOverridesNested<A> withNewKubeControllerManagerUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.KubeControllerManagerUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.KubeControllerManagerUnsupportedConfigOverridesNested<A> withNewKubeControllerManagerUnsupportedConfigOverridesLike(KubeControllerManager item) {
    return new IngressControllerSpecFluentImpl.KubeControllerManagerUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withPodNetworkConnectivityCheckStatusUnsupportedConfigOverrides(PodNetworkConnectivityCheckStatus podNetworkConnectivityCheckStatusUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (podNetworkConnectivityCheckStatusUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new PodNetworkConnectivityCheckStatusBuilder(podNetworkConnectivityCheckStatusUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.PodNetworkConnectivityCheckStatusUnsupportedConfigOverridesNested<A> withNewPodNetworkConnectivityCheckStatusUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.PodNetworkConnectivityCheckStatusUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.PodNetworkConnectivityCheckStatusUnsupportedConfigOverridesNested<A> withNewPodNetworkConnectivityCheckStatusUnsupportedConfigOverridesLike(PodNetworkConnectivityCheckStatus item) {
    return new IngressControllerSpecFluentImpl.PodNetworkConnectivityCheckStatusUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withKubeStorageVersionMigratorListUnsupportedConfigOverrides(KubeStorageVersionMigratorList kubeStorageVersionMigratorListUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (kubeStorageVersionMigratorListUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new KubeStorageVersionMigratorListBuilder(kubeStorageVersionMigratorListUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.KubeStorageVersionMigratorListUnsupportedConfigOverridesNested<A> withNewKubeStorageVersionMigratorListUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.KubeStorageVersionMigratorListUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.KubeStorageVersionMigratorListUnsupportedConfigOverridesNested<A> withNewKubeStorageVersionMigratorListUnsupportedConfigOverridesLike(KubeStorageVersionMigratorList item) {
    return new IngressControllerSpecFluentImpl.KubeStorageVersionMigratorListUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withStorageUnsupportedConfigOverrides(Storage storageUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (storageUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new StorageBuilder(storageUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.StorageUnsupportedConfigOverridesNested<A> withNewStorageUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.StorageUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.StorageUnsupportedConfigOverridesNested<A> withNewStorageUnsupportedConfigOverridesLike(Storage item) {
    return new IngressControllerSpecFluentImpl.StorageUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withPodTemplateSpecUnsupportedConfigOverrides(PodTemplateSpec podTemplateSpecUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (podTemplateSpecUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new PodTemplateSpecBuilder(podTemplateSpecUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.PodTemplateSpecUnsupportedConfigOverridesNested<A> withNewPodTemplateSpecUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.PodTemplateSpecUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.PodTemplateSpecUnsupportedConfigOverridesNested<A> withNewPodTemplateSpecUnsupportedConfigOverridesLike(PodTemplateSpec item) {
    return new IngressControllerSpecFluentImpl.PodTemplateSpecUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withKubeControllerManagerStatusUnsupportedConfigOverrides(KubeControllerManagerStatus kubeControllerManagerStatusUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (kubeControllerManagerStatusUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new KubeControllerManagerStatusBuilder(kubeControllerManagerStatusUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.KubeControllerManagerStatusUnsupportedConfigOverridesNested<A> withNewKubeControllerManagerStatusUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.KubeControllerManagerStatusUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.KubeControllerManagerStatusUnsupportedConfigOverridesNested<A> withNewKubeControllerManagerStatusUnsupportedConfigOverridesLike(KubeControllerManagerStatus item) {
    return new IngressControllerSpecFluentImpl.KubeControllerManagerStatusUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withServiceCatalogControllerManagerListUnsupportedConfigOverrides(ServiceCatalogControllerManagerList serviceCatalogControllerManagerListUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (serviceCatalogControllerManagerListUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new ServiceCatalogControllerManagerListBuilder(serviceCatalogControllerManagerListUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.ServiceCatalogControllerManagerListUnsupportedConfigOverridesNested<A> withNewServiceCatalogControllerManagerListUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.ServiceCatalogControllerManagerListUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.ServiceCatalogControllerManagerListUnsupportedConfigOverridesNested<A> withNewServiceCatalogControllerManagerListUnsupportedConfigOverridesLike(ServiceCatalogControllerManagerList item) {
    return new IngressControllerSpecFluentImpl.ServiceCatalogControllerManagerListUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withCSISnapshotControllerStatusUnsupportedConfigOverrides(CSISnapshotControllerStatus cSISnapshotControllerStatusUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (cSISnapshotControllerStatusUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new CSISnapshotControllerStatusBuilder(cSISnapshotControllerStatusUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.CSISnapshotControllerStatusUnsupportedConfigOverridesNested<A> withNewCSISnapshotControllerStatusUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.CSISnapshotControllerStatusUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.CSISnapshotControllerStatusUnsupportedConfigOverridesNested<A> withNewCSISnapshotControllerStatusUnsupportedConfigOverridesLike(CSISnapshotControllerStatus item) {
    return new IngressControllerSpecFluentImpl.CSISnapshotControllerStatusUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withIPsecConfigUnsupportedOverrides(IPsecConfig iPsecConfigUnsupportedOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (iPsecConfigUnsupportedOverrides!=null){ this.unsupportedConfigOverrides= new IPsecConfigBuilder(iPsecConfigUnsupportedOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.IPsecConfigUnsupportedOverridesNested<A> withNewIPsecConfigUnsupportedOverrides() {
    return new IngressControllerSpecFluentImpl.IPsecConfigUnsupportedOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.IPsecConfigUnsupportedOverridesNested<A> withNewIPsecConfigUnsupportedOverridesLike(IPsecConfig item) {
    return new IngressControllerSpecFluentImpl.IPsecConfigUnsupportedOverridesNestedImpl(item);
  }
  public A withImageContentSourcePolicyUnsupportedConfigOverrides(ImageContentSourcePolicy imageContentSourcePolicyUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (imageContentSourcePolicyUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new ImageContentSourcePolicyBuilder(imageContentSourcePolicyUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.ImageContentSourcePolicyUnsupportedConfigOverridesNested<A> withNewImageContentSourcePolicyUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.ImageContentSourcePolicyUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.ImageContentSourcePolicyUnsupportedConfigOverridesNested<A> withNewImageContentSourcePolicyUnsupportedConfigOverridesLike(ImageContentSourcePolicy item) {
    return new IngressControllerSpecFluentImpl.ImageContentSourcePolicyUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withResourceRequirementsUnsupportedConfigOverrides(ResourceRequirements resourceRequirementsUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (resourceRequirementsUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new ResourceRequirementsBuilder(resourceRequirementsUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.ResourceRequirementsUnsupportedConfigOverridesNested<A> withNewResourceRequirementsUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.ResourceRequirementsUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.ResourceRequirementsUnsupportedConfigOverridesNested<A> withNewResourceRequirementsUnsupportedConfigOverridesLike(ResourceRequirements item) {
    return new IngressControllerSpecFluentImpl.ResourceRequirementsUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withOVNKubernetesConfigUnsupportedOverrides(OVNKubernetesConfig oVNKubernetesConfigUnsupportedOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (oVNKubernetesConfigUnsupportedOverrides!=null){ this.unsupportedConfigOverrides= new OVNKubernetesConfigBuilder(oVNKubernetesConfigUnsupportedOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.OVNKubernetesConfigUnsupportedOverridesNested<A> withNewOVNKubernetesConfigUnsupportedOverrides() {
    return new IngressControllerSpecFluentImpl.OVNKubernetesConfigUnsupportedOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.OVNKubernetesConfigUnsupportedOverridesNested<A> withNewOVNKubernetesConfigUnsupportedOverridesLike(OVNKubernetesConfig item) {
    return new IngressControllerSpecFluentImpl.OVNKubernetesConfigUnsupportedOverridesNestedImpl(item);
  }
  public A withDeveloperConsoleCatalogCategoryMetaUnsupportedConfigOverrides(DeveloperConsoleCatalogCategoryMeta developerConsoleCatalogCategoryMetaUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (developerConsoleCatalogCategoryMetaUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new DeveloperConsoleCatalogCategoryMetaBuilder(developerConsoleCatalogCategoryMetaUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.DeveloperConsoleCatalogCategoryMetaUnsupportedConfigOverridesNested<A> withNewDeveloperConsoleCatalogCategoryMetaUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.DeveloperConsoleCatalogCategoryMetaUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.DeveloperConsoleCatalogCategoryMetaUnsupportedConfigOverridesNested<A> withNewDeveloperConsoleCatalogCategoryMetaUnsupportedConfigOverridesLike(DeveloperConsoleCatalogCategoryMeta item) {
    return new IngressControllerSpecFluentImpl.DeveloperConsoleCatalogCategoryMetaUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withKubeStorageVersionMigratorSpecUnsupportedConfigOverrides(KubeStorageVersionMigratorSpec kubeStorageVersionMigratorSpecUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (kubeStorageVersionMigratorSpecUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new KubeStorageVersionMigratorSpecBuilder(kubeStorageVersionMigratorSpecUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.KubeStorageVersionMigratorSpecUnsupportedConfigOverridesNested<A> withNewKubeStorageVersionMigratorSpecUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.KubeStorageVersionMigratorSpecUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.KubeStorageVersionMigratorSpecUnsupportedConfigOverridesNested<A> withNewKubeStorageVersionMigratorSpecUnsupportedConfigOverridesLike(KubeStorageVersionMigratorSpec item) {
    return new IngressControllerSpecFluentImpl.KubeStorageVersionMigratorSpecUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withIngressControllerSpecUnsupportedConfigOverrides(IngressControllerSpec ingressControllerSpecUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (ingressControllerSpecUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new IngressControllerSpecBuilder(ingressControllerSpecUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.IngressControllerSpecUnsupportedConfigOverridesNested<A> withNewIngressControllerSpecUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.IngressControllerSpecUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.IngressControllerSpecUnsupportedConfigOverridesNested<A> withNewIngressControllerSpecUnsupportedConfigOverridesLike(IngressControllerSpec item) {
    return new IngressControllerSpecFluentImpl.IngressControllerSpecUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withDNSSpecUnsupportedConfigOverrides(DNSSpec dNSSpecUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (dNSSpecUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new DNSSpecBuilder(dNSSpecUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.DNSSpecUnsupportedConfigOverridesNested<A> withNewDNSSpecUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.DNSSpecUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.DNSSpecUnsupportedConfigOverridesNested<A> withNewDNSSpecUnsupportedConfigOverridesLike(DNSSpec item) {
    return new IngressControllerSpecFluentImpl.DNSSpecUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withOpenShiftSDNConfigUnsupportedOverrides(OpenShiftSDNConfig openShiftSDNConfigUnsupportedOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (openShiftSDNConfigUnsupportedOverrides!=null){ this.unsupportedConfigOverrides= new OpenShiftSDNConfigBuilder(openShiftSDNConfigUnsupportedOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.OpenShiftSDNConfigUnsupportedOverridesNested<A> withNewOpenShiftSDNConfigUnsupportedOverrides() {
    return new IngressControllerSpecFluentImpl.OpenShiftSDNConfigUnsupportedOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.OpenShiftSDNConfigUnsupportedOverridesNested<A> withNewOpenShiftSDNConfigUnsupportedOverridesLike(OpenShiftSDNConfig item) {
    return new IngressControllerSpecFluentImpl.OpenShiftSDNConfigUnsupportedOverridesNestedImpl(item);
  }
  public A withNewOpenShiftSDNConfigUnsupportedOverrides(Boolean enableUnidling,String mode,Integer mtu,Boolean useExternalOpenvswitch,Integer vxlanPort) {
    return (A)withOpenShiftSDNConfigUnsupportedOverrides(new OpenShiftSDNConfig(enableUnidling, mode, mtu, useExternalOpenvswitch, vxlanPort));
  }
  public A withOperatorConditionUnsupportedConfigOverrides(OperatorCondition operatorConditionUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (operatorConditionUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new OperatorConditionBuilder(operatorConditionUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.OperatorConditionUnsupportedConfigOverridesNested<A> withNewOperatorConditionUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.OperatorConditionUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.OperatorConditionUnsupportedConfigOverridesNested<A> withNewOperatorConditionUnsupportedConfigOverridesLike(OperatorCondition item) {
    return new IngressControllerSpecFluentImpl.OperatorConditionUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withNewOperatorConditionUnsupportedConfigOverrides(String lastTransitionTime,String message,String reason,String status,String type) {
    return (A)withOperatorConditionUnsupportedConfigOverrides(new OperatorCondition(lastTransitionTime, message, reason, status, type));
  }
  public A withIngressControllerHTTPHeadersUnsupportedConfigOverrides(IngressControllerHTTPHeaders ingressControllerHTTPHeadersUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (ingressControllerHTTPHeadersUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new IngressControllerHTTPHeadersBuilder(ingressControllerHTTPHeadersUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.IngressControllerHTTPHeadersUnsupportedConfigOverridesNested<A> withNewIngressControllerHTTPHeadersUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.IngressControllerHTTPHeadersUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.IngressControllerHTTPHeadersUnsupportedConfigOverridesNested<A> withNewIngressControllerHTTPHeadersUnsupportedConfigOverridesLike(IngressControllerHTTPHeaders item) {
    return new IngressControllerSpecFluentImpl.IngressControllerHTTPHeadersUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withProxyConfigUnsupportedOverrides(ProxyConfig proxyConfigUnsupportedOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (proxyConfigUnsupportedOverrides!=null){ this.unsupportedConfigOverrides= new ProxyConfigBuilder(proxyConfigUnsupportedOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.ProxyConfigUnsupportedOverridesNested<A> withNewProxyConfigUnsupportedOverrides() {
    return new IngressControllerSpecFluentImpl.ProxyConfigUnsupportedOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.ProxyConfigUnsupportedOverridesNested<A> withNewProxyConfigUnsupportedOverridesLike(ProxyConfig item) {
    return new IngressControllerSpecFluentImpl.ProxyConfigUnsupportedOverridesNestedImpl(item);
  }
  public A withConsoleListUnsupportedConfigOverrides(ConsoleList consoleListUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (consoleListUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new ConsoleListBuilder(consoleListUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.ConsoleListUnsupportedConfigOverridesNested<A> withNewConsoleListUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.ConsoleListUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.ConsoleListUnsupportedConfigOverridesNested<A> withNewConsoleListUnsupportedConfigOverridesLike(ConsoleList item) {
    return new IngressControllerSpecFluentImpl.ConsoleListUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withKuryrConfigUnsupportedOverrides(KuryrConfig kuryrConfigUnsupportedOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (kuryrConfigUnsupportedOverrides!=null){ this.unsupportedConfigOverrides= new KuryrConfigBuilder(kuryrConfigUnsupportedOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.KuryrConfigUnsupportedOverridesNested<A> withNewKuryrConfigUnsupportedOverrides() {
    return new IngressControllerSpecFluentImpl.KuryrConfigUnsupportedOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.KuryrConfigUnsupportedOverridesNested<A> withNewKuryrConfigUnsupportedOverridesLike(KuryrConfig item) {
    return new IngressControllerSpecFluentImpl.KuryrConfigUnsupportedOverridesNestedImpl(item);
  }
  public A withDeveloperConsoleCatalogCategoryUnsupportedConfigOverrides(DeveloperConsoleCatalogCategory developerConsoleCatalogCategoryUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (developerConsoleCatalogCategoryUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new DeveloperConsoleCatalogCategoryBuilder(developerConsoleCatalogCategoryUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.DeveloperConsoleCatalogCategoryUnsupportedConfigOverridesNested<A> withNewDeveloperConsoleCatalogCategoryUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.DeveloperConsoleCatalogCategoryUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.DeveloperConsoleCatalogCategoryUnsupportedConfigOverridesNested<A> withNewDeveloperConsoleCatalogCategoryUnsupportedConfigOverridesLike(DeveloperConsoleCatalogCategory item) {
    return new IngressControllerSpecFluentImpl.DeveloperConsoleCatalogCategoryUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withOpenShiftControllerManagerSpecUnsupportedConfigOverrides(OpenShiftControllerManagerSpec openShiftControllerManagerSpecUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (openShiftControllerManagerSpecUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new OpenShiftControllerManagerSpecBuilder(openShiftControllerManagerSpecUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.OpenShiftControllerManagerSpecUnsupportedConfigOverridesNested<A> withNewOpenShiftControllerManagerSpecUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.OpenShiftControllerManagerSpecUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.OpenShiftControllerManagerSpecUnsupportedConfigOverridesNested<A> withNewOpenShiftControllerManagerSpecUnsupportedConfigOverridesLike(OpenShiftControllerManagerSpec item) {
    return new IngressControllerSpecFluentImpl.OpenShiftControllerManagerSpecUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withExportNetworkFlowsUnsupportedConfigOverrides(ExportNetworkFlows exportNetworkFlowsUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (exportNetworkFlowsUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new ExportNetworkFlowsBuilder(exportNetworkFlowsUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.ExportNetworkFlowsUnsupportedConfigOverridesNested<A> withNewExportNetworkFlowsUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.ExportNetworkFlowsUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.ExportNetworkFlowsUnsupportedConfigOverridesNested<A> withNewExportNetworkFlowsUnsupportedConfigOverridesLike(ExportNetworkFlows item) {
    return new IngressControllerSpecFluentImpl.ExportNetworkFlowsUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withClusterCSIDriverSpecUnsupportedConfigOverrides(ClusterCSIDriverSpec clusterCSIDriverSpecUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (clusterCSIDriverSpecUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new ClusterCSIDriverSpecBuilder(clusterCSIDriverSpecUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.ClusterCSIDriverSpecUnsupportedConfigOverridesNested<A> withNewClusterCSIDriverSpecUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.ClusterCSIDriverSpecUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.ClusterCSIDriverSpecUnsupportedConfigOverridesNested<A> withNewClusterCSIDriverSpecUnsupportedConfigOverridesLike(ClusterCSIDriverSpec item) {
    return new IngressControllerSpecFluentImpl.ClusterCSIDriverSpecUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withServiceCatalogAPIServerSpecUnsupportedConfigOverrides(ServiceCatalogAPIServerSpec serviceCatalogAPIServerSpecUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (serviceCatalogAPIServerSpecUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new ServiceCatalogAPIServerSpecBuilder(serviceCatalogAPIServerSpecUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.ServiceCatalogAPIServerSpecUnsupportedConfigOverridesNested<A> withNewServiceCatalogAPIServerSpecUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.ServiceCatalogAPIServerSpecUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.ServiceCatalogAPIServerSpecUnsupportedConfigOverridesNested<A> withNewServiceCatalogAPIServerSpecUnsupportedConfigOverridesLike(ServiceCatalogAPIServerSpec item) {
    return new IngressControllerSpecFluentImpl.ServiceCatalogAPIServerSpecUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withImageContentSourcePolicySpecUnsupportedConfigOverrides(ImageContentSourcePolicySpec imageContentSourcePolicySpecUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (imageContentSourcePolicySpecUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new ImageContentSourcePolicySpecBuilder(imageContentSourcePolicySpecUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.ImageContentSourcePolicySpecUnsupportedConfigOverridesNested<A> withNewImageContentSourcePolicySpecUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.ImageContentSourcePolicySpecUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.ImageContentSourcePolicySpecUnsupportedConfigOverridesNested<A> withNewImageContentSourcePolicySpecUnsupportedConfigOverridesLike(ImageContentSourcePolicySpec item) {
    return new IngressControllerSpecFluentImpl.ImageContentSourcePolicySpecUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withRepositoryDigestMirrorsUnsupportedConfigOverrides(RepositoryDigestMirrors repositoryDigestMirrorsUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (repositoryDigestMirrorsUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new RepositoryDigestMirrorsBuilder(repositoryDigestMirrorsUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.RepositoryDigestMirrorsUnsupportedConfigOverridesNested<A> withNewRepositoryDigestMirrorsUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.RepositoryDigestMirrorsUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.RepositoryDigestMirrorsUnsupportedConfigOverridesNested<A> withNewRepositoryDigestMirrorsUnsupportedConfigOverridesLike(RepositoryDigestMirrors item) {
    return new IngressControllerSpecFluentImpl.RepositoryDigestMirrorsUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withConsoleCustomizationUnsupportedConfigOverrides(ConsoleCustomization consoleCustomizationUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (consoleCustomizationUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new ConsoleCustomizationBuilder(consoleCustomizationUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.ConsoleCustomizationUnsupportedConfigOverridesNested<A> withNewConsoleCustomizationUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.ConsoleCustomizationUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.ConsoleCustomizationUnsupportedConfigOverridesNested<A> withNewConsoleCustomizationUnsupportedConfigOverridesLike(ConsoleCustomization item) {
    return new IngressControllerSpecFluentImpl.ConsoleCustomizationUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withCSISnapshotControllerSpecUnsupportedConfigOverrides(CSISnapshotControllerSpec cSISnapshotControllerSpecUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (cSISnapshotControllerSpecUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new CSISnapshotControllerSpecBuilder(cSISnapshotControllerSpecUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.CSISnapshotControllerSpecUnsupportedConfigOverridesNested<A> withNewCSISnapshotControllerSpecUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.CSISnapshotControllerSpecUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.CSISnapshotControllerSpecUnsupportedConfigOverridesNested<A> withNewCSISnapshotControllerSpecUnsupportedConfigOverridesLike(CSISnapshotControllerSpec item) {
    return new IngressControllerSpecFluentImpl.CSISnapshotControllerSpecUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withUpstreamResolversUnsupportedConfigOverrides(UpstreamResolvers upstreamResolversUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (upstreamResolversUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new UpstreamResolversBuilder(upstreamResolversUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.UpstreamResolversUnsupportedConfigOverridesNested<A> withNewUpstreamResolversUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.UpstreamResolversUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.UpstreamResolversUnsupportedConfigOverridesNested<A> withNewUpstreamResolversUnsupportedConfigOverridesLike(UpstreamResolvers item) {
    return new IngressControllerSpecFluentImpl.UpstreamResolversUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withDNSStatusUnsupportedConfigOverrides(DNSStatus dNSStatusUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (dNSStatusUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new DNSStatusBuilder(dNSStatusUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.DNSStatusUnsupportedConfigOverridesNested<A> withNewDNSStatusUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.DNSStatusUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.DNSStatusUnsupportedConfigOverridesNested<A> withNewDNSStatusUnsupportedConfigOverridesLike(DNSStatus item) {
    return new IngressControllerSpecFluentImpl.DNSStatusUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withIngressControllerHTTPUniqueIdHeaderPolicyUnsupportedConfigOverrides(IngressControllerHTTPUniqueIdHeaderPolicy ingressControllerHTTPUniqueIdHeaderPolicyUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (ingressControllerHTTPUniqueIdHeaderPolicyUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new IngressControllerHTTPUniqueIdHeaderPolicyBuilder(ingressControllerHTTPUniqueIdHeaderPolicyUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.IngressControllerHTTPUniqueIdHeaderPolicyUnsupportedConfigOverridesNested<A> withNewIngressControllerHTTPUniqueIdHeaderPolicyUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.IngressControllerHTTPUniqueIdHeaderPolicyUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.IngressControllerHTTPUniqueIdHeaderPolicyUnsupportedConfigOverridesNested<A> withNewIngressControllerHTTPUniqueIdHeaderPolicyUnsupportedConfigOverridesLike(IngressControllerHTTPUniqueIdHeaderPolicy item) {
    return new IngressControllerSpecFluentImpl.IngressControllerHTTPUniqueIdHeaderPolicyUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withNewIngressControllerHTTPUniqueIdHeaderPolicyUnsupportedConfigOverrides(String format,String name) {
    return (A)withIngressControllerHTTPUniqueIdHeaderPolicyUnsupportedConfigOverrides(new IngressControllerHTTPUniqueIdHeaderPolicy(format, name));
  }
  public A withGCPLoadBalancerParametersUnsupportedConfigOverrides(GCPLoadBalancerParameters gCPLoadBalancerParametersUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (gCPLoadBalancerParametersUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new GCPLoadBalancerParametersBuilder(gCPLoadBalancerParametersUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.GCPLoadBalancerParametersUnsupportedConfigOverridesNested<A> withNewGCPLoadBalancerParametersUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.GCPLoadBalancerParametersUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.GCPLoadBalancerParametersUnsupportedConfigOverridesNested<A> withNewGCPLoadBalancerParametersUnsupportedConfigOverridesLike(GCPLoadBalancerParameters item) {
    return new IngressControllerSpecFluentImpl.GCPLoadBalancerParametersUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withNewGCPLoadBalancerParametersUnsupportedConfigOverrides(String clientAccess) {
    return (A)withGCPLoadBalancerParametersUnsupportedConfigOverrides(new GCPLoadBalancerParameters(clientAccess));
  }
  public A withConfigStatusUnsupportedConfigOverrides(ConfigStatus configStatusUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (configStatusUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new ConfigStatusBuilder(configStatusUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.ConfigStatusUnsupportedConfigOverridesNested<A> withNewConfigStatusUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.ConfigStatusUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.ConfigStatusUnsupportedConfigOverridesNested<A> withNewConfigStatusUnsupportedConfigOverridesLike(ConfigStatus item) {
    return new IngressControllerSpecFluentImpl.ConfigStatusUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withKubeAPIServerListUnsupportedConfigOverrides(KubeAPIServerList kubeAPIServerListUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (kubeAPIServerListUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new KubeAPIServerListBuilder(kubeAPIServerListUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.KubeAPIServerListUnsupportedConfigOverridesNested<A> withNewKubeAPIServerListUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.KubeAPIServerListUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.KubeAPIServerListUnsupportedConfigOverridesNested<A> withNewKubeAPIServerListUnsupportedConfigOverridesLike(KubeAPIServerList item) {
    return new IngressControllerSpecFluentImpl.KubeAPIServerListUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withServiceCAUnsupportedConfigOverrides(ServiceCA serviceCAUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (serviceCAUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new ServiceCABuilder(serviceCAUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.ServiceCAUnsupportedConfigOverridesNested<A> withNewServiceCAUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.ServiceCAUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.ServiceCAUnsupportedConfigOverridesNested<A> withNewServiceCAUnsupportedConfigOverridesLike(ServiceCA item) {
    return new IngressControllerSpecFluentImpl.ServiceCAUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withServiceCatalogControllerManagerSpecUnsupportedConfigOverrides(ServiceCatalogControllerManagerSpec serviceCatalogControllerManagerSpecUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (serviceCatalogControllerManagerSpecUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new ServiceCatalogControllerManagerSpecBuilder(serviceCatalogControllerManagerSpecUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.ServiceCatalogControllerManagerSpecUnsupportedConfigOverridesNested<A> withNewServiceCatalogControllerManagerSpecUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.ServiceCatalogControllerManagerSpecUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.ServiceCatalogControllerManagerSpecUnsupportedConfigOverridesNested<A> withNewServiceCatalogControllerManagerSpecUnsupportedConfigOverridesLike(ServiceCatalogControllerManagerSpec item) {
    return new IngressControllerSpecFluentImpl.ServiceCatalogControllerManagerSpecUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withConfigUnsupportedConfigOverrides(Config configUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (configUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new ConfigBuilder(configUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.ConfigUnsupportedConfigOverridesNested<A> withNewConfigUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.ConfigUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.ConfigUnsupportedConfigOverridesNested<A> withNewConfigUnsupportedConfigOverridesLike(Config item) {
    return new IngressControllerSpecFluentImpl.ConfigUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withIngressControllerListUnsupportedConfigOverrides(IngressControllerList ingressControllerListUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (ingressControllerListUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new IngressControllerListBuilder(ingressControllerListUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.IngressControllerListUnsupportedConfigOverridesNested<A> withNewIngressControllerListUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.IngressControllerListUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.IngressControllerListUnsupportedConfigOverridesNested<A> withNewIngressControllerListUnsupportedConfigOverridesLike(IngressControllerList item) {
    return new IngressControllerSpecFluentImpl.IngressControllerListUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withDNSListUnsupportedConfigOverrides(DNSList dNSListUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (dNSListUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new DNSListBuilder(dNSListUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.DNSListUnsupportedConfigOverridesNested<A> withNewDNSListUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.DNSListUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.DNSListUnsupportedConfigOverridesNested<A> withNewDNSListUnsupportedConfigOverridesLike(DNSList item) {
    return new IngressControllerSpecFluentImpl.DNSListUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withObjectMetaUnsupportedConfigOverrides(ObjectMeta objectMetaUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (objectMetaUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new ObjectMetaBuilder(objectMetaUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.ObjectMetaUnsupportedConfigOverridesNested<A> withNewObjectMetaUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.ObjectMetaUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.ObjectMetaUnsupportedConfigOverridesNested<A> withNewObjectMetaUnsupportedConfigOverridesLike(ObjectMeta item) {
    return new IngressControllerSpecFluentImpl.ObjectMetaUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withClusterCSIDriverListUnsupportedConfigOverrides(ClusterCSIDriverList clusterCSIDriverListUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (clusterCSIDriverListUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new ClusterCSIDriverListBuilder(clusterCSIDriverListUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.ClusterCSIDriverListUnsupportedConfigOverridesNested<A> withNewClusterCSIDriverListUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.ClusterCSIDriverListUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.ClusterCSIDriverListUnsupportedConfigOverridesNested<A> withNewClusterCSIDriverListUnsupportedConfigOverridesLike(ClusterCSIDriverList item) {
    return new IngressControllerSpecFluentImpl.ClusterCSIDriverListUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withSimpleMacvlanConfigUnsupportedOverrides(SimpleMacvlanConfig simpleMacvlanConfigUnsupportedOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (simpleMacvlanConfigUnsupportedOverrides!=null){ this.unsupportedConfigOverrides= new SimpleMacvlanConfigBuilder(simpleMacvlanConfigUnsupportedOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.SimpleMacvlanConfigUnsupportedOverridesNested<A> withNewSimpleMacvlanConfigUnsupportedOverrides() {
    return new IngressControllerSpecFluentImpl.SimpleMacvlanConfigUnsupportedOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.SimpleMacvlanConfigUnsupportedOverridesNested<A> withNewSimpleMacvlanConfigUnsupportedOverridesLike(SimpleMacvlanConfig item) {
    return new IngressControllerSpecFluentImpl.SimpleMacvlanConfigUnsupportedOverridesNestedImpl(item);
  }
  public A withPersistentVolumeClaimUnsupportedConfigOverrides(PersistentVolumeClaim persistentVolumeClaimUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (persistentVolumeClaimUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new PersistentVolumeClaimBuilder(persistentVolumeClaimUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.PersistentVolumeClaimUnsupportedConfigOverridesNested<A> withNewPersistentVolumeClaimUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.PersistentVolumeClaimUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.PersistentVolumeClaimUnsupportedConfigOverridesNested<A> withNewPersistentVolumeClaimUnsupportedConfigOverridesLike(PersistentVolumeClaim item) {
    return new IngressControllerSpecFluentImpl.PersistentVolumeClaimUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withKubeAPIServerStatusUnsupportedConfigOverrides(KubeAPIServerStatus kubeAPIServerStatusUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (kubeAPIServerStatusUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new KubeAPIServerStatusBuilder(kubeAPIServerStatusUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.KubeAPIServerStatusUnsupportedConfigOverridesNested<A> withNewKubeAPIServerStatusUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.KubeAPIServerStatusUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.KubeAPIServerStatusUnsupportedConfigOverridesNested<A> withNewKubeAPIServerStatusUnsupportedConfigOverridesLike(KubeAPIServerStatus item) {
    return new IngressControllerSpecFluentImpl.KubeAPIServerStatusUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withAWSClassicLoadBalancerParametersUnsupportedConfigOverrides(AWSClassicLoadBalancerParameters aWSClassicLoadBalancerParametersUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (aWSClassicLoadBalancerParametersUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new AWSClassicLoadBalancerParametersBuilder(aWSClassicLoadBalancerParametersUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.AWSClassicLoadBalancerParametersUnsupportedConfigOverridesNested<A> withNewAWSClassicLoadBalancerParametersUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.AWSClassicLoadBalancerParametersUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.AWSClassicLoadBalancerParametersUnsupportedConfigOverridesNested<A> withNewAWSClassicLoadBalancerParametersUnsupportedConfigOverridesLike(AWSClassicLoadBalancerParameters item) {
    return new IngressControllerSpecFluentImpl.AWSClassicLoadBalancerParametersUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withKubeAPIServerUnsupportedConfigOverrides(KubeAPIServer kubeAPIServerUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (kubeAPIServerUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new KubeAPIServerBuilder(kubeAPIServerUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.KubeAPIServerUnsupportedConfigOverridesNested<A> withNewKubeAPIServerUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.KubeAPIServerUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.KubeAPIServerUnsupportedConfigOverridesNested<A> withNewKubeAPIServerUnsupportedConfigOverridesLike(KubeAPIServer item) {
    return new IngressControllerSpecFluentImpl.KubeAPIServerUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withIngressControllerUnsupportedConfigOverrides(IngressController ingressControllerUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (ingressControllerUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new IngressControllerBuilder(ingressControllerUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.IngressControllerUnsupportedConfigOverridesNested<A> withNewIngressControllerUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.IngressControllerUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.IngressControllerUnsupportedConfigOverridesNested<A> withNewIngressControllerUnsupportedConfigOverridesLike(IngressController item) {
    return new IngressControllerSpecFluentImpl.IngressControllerUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withConsoleConfigRouteUnsupportedOverrides(ConsoleConfigRoute consoleConfigRouteUnsupportedOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (consoleConfigRouteUnsupportedOverrides!=null){ this.unsupportedConfigOverrides= new ConsoleConfigRouteBuilder(consoleConfigRouteUnsupportedOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.ConsoleConfigRouteUnsupportedOverridesNested<A> withNewConsoleConfigRouteUnsupportedOverrides() {
    return new IngressControllerSpecFluentImpl.ConsoleConfigRouteUnsupportedOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.ConsoleConfigRouteUnsupportedOverridesNested<A> withNewConsoleConfigRouteUnsupportedOverridesLike(ConsoleConfigRoute item) {
    return new IngressControllerSpecFluentImpl.ConsoleConfigRouteUnsupportedOverridesNestedImpl(item);
  }
  public A withCloudCredentialStatusUnsupportedConfigOverrides(CloudCredentialStatus cloudCredentialStatusUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (cloudCredentialStatusUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new CloudCredentialStatusBuilder(cloudCredentialStatusUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.CloudCredentialStatusUnsupportedConfigOverridesNested<A> withNewCloudCredentialStatusUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.CloudCredentialStatusUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.CloudCredentialStatusUnsupportedConfigOverridesNested<A> withNewCloudCredentialStatusUnsupportedConfigOverridesLike(CloudCredentialStatus item) {
    return new IngressControllerSpecFluentImpl.CloudCredentialStatusUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withKubeStorageVersionMigratorUnsupportedConfigOverrides(KubeStorageVersionMigrator kubeStorageVersionMigratorUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (kubeStorageVersionMigratorUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new KubeStorageVersionMigratorBuilder(kubeStorageVersionMigratorUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.KubeStorageVersionMigratorUnsupportedConfigOverridesNested<A> withNewKubeStorageVersionMigratorUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.KubeStorageVersionMigratorUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.KubeStorageVersionMigratorUnsupportedConfigOverridesNested<A> withNewKubeStorageVersionMigratorUnsupportedConfigOverridesLike(KubeStorageVersionMigrator item) {
    return new IngressControllerSpecFluentImpl.KubeStorageVersionMigratorUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withGenericKubernetesResourceUnsupportedConfigOverrides(GenericKubernetesResource genericKubernetesResourceUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (genericKubernetesResourceUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new GenericKubernetesResourceBuilder(genericKubernetesResourceUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.GenericKubernetesResourceUnsupportedConfigOverridesNested<A> withNewGenericKubernetesResourceUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.GenericKubernetesResourceUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.GenericKubernetesResourceUnsupportedConfigOverridesNested<A> withNewGenericKubernetesResourceUnsupportedConfigOverridesLike(GenericKubernetesResource item) {
    return new IngressControllerSpecFluentImpl.GenericKubernetesResourceUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withIngressControllerStatusUnsupportedConfigOverrides(IngressControllerStatus ingressControllerStatusUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (ingressControllerStatusUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new IngressControllerStatusBuilder(ingressControllerStatusUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.IngressControllerStatusUnsupportedConfigOverridesNested<A> withNewIngressControllerStatusUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.IngressControllerStatusUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.IngressControllerStatusUnsupportedConfigOverridesNested<A> withNewIngressControllerStatusUnsupportedConfigOverridesLike(IngressControllerStatus item) {
    return new IngressControllerSpecFluentImpl.IngressControllerStatusUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withServiceCatalogControllerManagerStatusUnsupportedConfigOverrides(ServiceCatalogControllerManagerStatus serviceCatalogControllerManagerStatusUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (serviceCatalogControllerManagerStatusUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new ServiceCatalogControllerManagerStatusBuilder(serviceCatalogControllerManagerStatusUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.ServiceCatalogControllerManagerStatusUnsupportedConfigOverridesNested<A> withNewServiceCatalogControllerManagerStatusUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.ServiceCatalogControllerManagerStatusUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.ServiceCatalogControllerManagerStatusUnsupportedConfigOverridesNested<A> withNewServiceCatalogControllerManagerStatusUnsupportedConfigOverridesLike(ServiceCatalogControllerManagerStatus item) {
    return new IngressControllerSpecFluentImpl.ServiceCatalogControllerManagerStatusUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withHybridOverlayConfigUnsupportedOverrides(HybridOverlayConfig hybridOverlayConfigUnsupportedOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (hybridOverlayConfigUnsupportedOverrides!=null){ this.unsupportedConfigOverrides= new HybridOverlayConfigBuilder(hybridOverlayConfigUnsupportedOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.HybridOverlayConfigUnsupportedOverridesNested<A> withNewHybridOverlayConfigUnsupportedOverrides() {
    return new IngressControllerSpecFluentImpl.HybridOverlayConfigUnsupportedOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.HybridOverlayConfigUnsupportedOverridesNested<A> withNewHybridOverlayConfigUnsupportedOverridesLike(HybridOverlayConfig item) {
    return new IngressControllerSpecFluentImpl.HybridOverlayConfigUnsupportedOverridesNestedImpl(item);
  }
  public A withAWSLoadBalancerParametersUnsupportedConfigOverrides(AWSLoadBalancerParameters aWSLoadBalancerParametersUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (aWSLoadBalancerParametersUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new AWSLoadBalancerParametersBuilder(aWSLoadBalancerParametersUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.AWSLoadBalancerParametersUnsupportedConfigOverridesNested<A> withNewAWSLoadBalancerParametersUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.AWSLoadBalancerParametersUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.AWSLoadBalancerParametersUnsupportedConfigOverridesNested<A> withNewAWSLoadBalancerParametersUnsupportedConfigOverridesLike(AWSLoadBalancerParameters item) {
    return new IngressControllerSpecFluentImpl.AWSLoadBalancerParametersUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withImagePrunerListUnsupportedConfigOverrides(ImagePrunerList imagePrunerListUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (imagePrunerListUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new ImagePrunerListBuilder(imagePrunerListUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.ImagePrunerListUnsupportedConfigOverridesNested<A> withNewImagePrunerListUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.ImagePrunerListUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.ImagePrunerListUnsupportedConfigOverridesNested<A> withNewImagePrunerListUnsupportedConfigOverridesLike(ImagePrunerList item) {
    return new IngressControllerSpecFluentImpl.ImagePrunerListUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withCSISnapshotControllerListUnsupportedConfigOverrides(CSISnapshotControllerList cSISnapshotControllerListUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (cSISnapshotControllerListUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new CSISnapshotControllerListBuilder(cSISnapshotControllerListUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.CSISnapshotControllerListUnsupportedConfigOverridesNested<A> withNewCSISnapshotControllerListUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.CSISnapshotControllerListUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.CSISnapshotControllerListUnsupportedConfigOverridesNested<A> withNewCSISnapshotControllerListUnsupportedConfigOverridesLike(CSISnapshotControllerList item) {
    return new IngressControllerSpecFluentImpl.CSISnapshotControllerListUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withLocalObjectReferenceUnsupportedConfigOverrides(LocalObjectReference localObjectReferenceUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (localObjectReferenceUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new LocalObjectReferenceBuilder(localObjectReferenceUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.LocalObjectReferenceUnsupportedConfigOverridesNested<A> withNewLocalObjectReferenceUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.LocalObjectReferenceUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.LocalObjectReferenceUnsupportedConfigOverridesNested<A> withNewLocalObjectReferenceUnsupportedConfigOverridesLike(LocalObjectReference item) {
    return new IngressControllerSpecFluentImpl.LocalObjectReferenceUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withNewLocalObjectReferenceUnsupportedConfigOverrides(String name) {
    return (A)withLocalObjectReferenceUnsupportedConfigOverrides(new LocalObjectReference(name));
  }
  public A withConsoleUnsupportedConfigOverrides(Console consoleUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (consoleUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new ConsoleBuilder(consoleUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.ConsoleUnsupportedConfigOverridesNested<A> withNewConsoleUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.ConsoleUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.ConsoleUnsupportedConfigOverridesNested<A> withNewConsoleUnsupportedConfigOverridesLike(Console item) {
    return new IngressControllerSpecFluentImpl.ConsoleUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withStaticIPAMRoutesUnsupportedConfigOverrides(StaticIPAMRoutes staticIPAMRoutesUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (staticIPAMRoutesUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new StaticIPAMRoutesBuilder(staticIPAMRoutesUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.StaticIPAMRoutesUnsupportedConfigOverridesNested<A> withNewStaticIPAMRoutesUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.StaticIPAMRoutesUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.StaticIPAMRoutesUnsupportedConfigOverridesNested<A> withNewStaticIPAMRoutesUnsupportedConfigOverridesLike(StaticIPAMRoutes item) {
    return new IngressControllerSpecFluentImpl.StaticIPAMRoutesUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withNewStaticIPAMRoutesUnsupportedConfigOverrides(String destination,String gateway) {
    return (A)withStaticIPAMRoutesUnsupportedConfigOverrides(new StaticIPAMRoutes(destination, gateway));
  }
  public A withDNSZoneConditionUnsupportedConfigOverrides(DNSZoneCondition dNSZoneConditionUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (dNSZoneConditionUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new DNSZoneConditionBuilder(dNSZoneConditionUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.DNSZoneConditionUnsupportedConfigOverridesNested<A> withNewDNSZoneConditionUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.DNSZoneConditionUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.DNSZoneConditionUnsupportedConfigOverridesNested<A> withNewDNSZoneConditionUnsupportedConfigOverridesLike(DNSZoneCondition item) {
    return new IngressControllerSpecFluentImpl.DNSZoneConditionUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withNewDNSZoneConditionUnsupportedConfigOverrides(String lastTransitionTime,String message,String reason,String status,String type) {
    return (A)withDNSZoneConditionUnsupportedConfigOverrides(new DNSZoneCondition(lastTransitionTime, message, reason, status, type));
  }
  public A withContainerLoggingDestinationParametersUnsupportedConfigOverrides(ContainerLoggingDestinationParameters containerLoggingDestinationParametersUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (containerLoggingDestinationParametersUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new ContainerLoggingDestinationParametersBuilder(containerLoggingDestinationParametersUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.ContainerLoggingDestinationParametersUnsupportedConfigOverridesNested<A> withNewContainerLoggingDestinationParametersUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.ContainerLoggingDestinationParametersUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.ContainerLoggingDestinationParametersUnsupportedConfigOverridesNested<A> withNewContainerLoggingDestinationParametersUnsupportedConfigOverridesLike(ContainerLoggingDestinationParameters item) {
    return new IngressControllerSpecFluentImpl.ContainerLoggingDestinationParametersUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withKubeSchedulerListUnsupportedConfigOverrides(KubeSchedulerList kubeSchedulerListUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (kubeSchedulerListUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new KubeSchedulerListBuilder(kubeSchedulerListUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.KubeSchedulerListUnsupportedConfigOverridesNested<A> withNewKubeSchedulerListUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.KubeSchedulerListUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.KubeSchedulerListUnsupportedConfigOverridesNested<A> withNewKubeSchedulerListUnsupportedConfigOverridesLike(KubeSchedulerList item) {
    return new IngressControllerSpecFluentImpl.KubeSchedulerListUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withKubeAPIServerSpecUnsupportedConfigOverrides(KubeAPIServerSpec kubeAPIServerSpecUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (kubeAPIServerSpecUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new KubeAPIServerSpecBuilder(kubeAPIServerSpecUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.KubeAPIServerSpecUnsupportedConfigOverridesNested<A> withNewKubeAPIServerSpecUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.KubeAPIServerSpecUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.KubeAPIServerSpecUnsupportedConfigOverridesNested<A> withNewKubeAPIServerSpecUnsupportedConfigOverridesLike(KubeAPIServerSpec item) {
    return new IngressControllerSpecFluentImpl.KubeAPIServerSpecUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withClusterCSIDriverUnsupportedConfigOverrides(ClusterCSIDriver clusterCSIDriverUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (clusterCSIDriverUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new ClusterCSIDriverBuilder(clusterCSIDriverUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.ClusterCSIDriverUnsupportedConfigOverridesNested<A> withNewClusterCSIDriverUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.ClusterCSIDriverUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.ClusterCSIDriverUnsupportedConfigOverridesNested<A> withNewClusterCSIDriverUnsupportedConfigOverridesLike(ClusterCSIDriver item) {
    return new IngressControllerSpecFluentImpl.ClusterCSIDriverUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withQuickStartsUnsupportedConfigOverrides(QuickStarts quickStartsUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (quickStartsUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new QuickStartsBuilder(quickStartsUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.QuickStartsUnsupportedConfigOverridesNested<A> withNewQuickStartsUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.QuickStartsUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.QuickStartsUnsupportedConfigOverridesNested<A> withNewQuickStartsUnsupportedConfigOverridesLike(QuickStarts item) {
    return new IngressControllerSpecFluentImpl.QuickStartsUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withDNSZoneStatusUnsupportedConfigOverrides(DNSZoneStatus dNSZoneStatusUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (dNSZoneStatusUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new DNSZoneStatusBuilder(dNSZoneStatusUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.DNSZoneStatusUnsupportedConfigOverridesNested<A> withNewDNSZoneStatusUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.DNSZoneStatusUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.DNSZoneStatusUnsupportedConfigOverridesNested<A> withNewDNSZoneStatusUnsupportedConfigOverridesLike(DNSZoneStatus item) {
    return new IngressControllerSpecFluentImpl.DNSZoneStatusUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withOpenShiftControllerManagerUnsupportedConfigOverrides(OpenShiftControllerManager openShiftControllerManagerUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (openShiftControllerManagerUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new OpenShiftControllerManagerBuilder(openShiftControllerManagerUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.OpenShiftControllerManagerUnsupportedConfigOverridesNested<A> withNewOpenShiftControllerManagerUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.OpenShiftControllerManagerUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.OpenShiftControllerManagerUnsupportedConfigOverridesNested<A> withNewOpenShiftControllerManagerUnsupportedConfigOverridesLike(OpenShiftControllerManager item) {
    return new IngressControllerSpecFluentImpl.OpenShiftControllerManagerUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withConfigSpecUnsupportedConfigOverrides(ConfigSpec configSpecUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (configSpecUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new ConfigSpecBuilder(configSpecUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.ConfigSpecUnsupportedConfigOverridesNested<A> withNewConfigSpecUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.ConfigSpecUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.ConfigSpecUnsupportedConfigOverridesNested<A> withNewConfigSpecUnsupportedConfigOverridesLike(ConfigSpec item) {
    return new IngressControllerSpecFluentImpl.ConfigSpecUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withOutageEntryUnsupportedConfigOverrides(OutageEntry outageEntryUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (outageEntryUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new OutageEntryBuilder(outageEntryUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.OutageEntryUnsupportedConfigOverridesNested<A> withNewOutageEntryUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.OutageEntryUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.OutageEntryUnsupportedConfigOverridesNested<A> withNewOutageEntryUnsupportedConfigOverridesLike(OutageEntry item) {
    return new IngressControllerSpecFluentImpl.OutageEntryUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withOpenShiftControllerManagerListUnsupportedConfigOverrides(OpenShiftControllerManagerList openShiftControllerManagerListUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (openShiftControllerManagerListUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new OpenShiftControllerManagerListBuilder(openShiftControllerManagerListUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.OpenShiftControllerManagerListUnsupportedConfigOverridesNested<A> withNewOpenShiftControllerManagerListUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.OpenShiftControllerManagerListUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.OpenShiftControllerManagerListUnsupportedConfigOverridesNested<A> withNewOpenShiftControllerManagerListUnsupportedConfigOverridesLike(OpenShiftControllerManagerList item) {
    return new IngressControllerSpecFluentImpl.OpenShiftControllerManagerListUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withEtcdUnsupportedConfigOverrides(Etcd etcdUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (etcdUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new EtcdBuilder(etcdUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.EtcdUnsupportedConfigOverridesNested<A> withNewEtcdUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.EtcdUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.EtcdUnsupportedConfigOverridesNested<A> withNewEtcdUnsupportedConfigOverridesLike(Etcd item) {
    return new IngressControllerSpecFluentImpl.EtcdUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withEndpointPublishingStrategyUnsupportedConfigOverrides(EndpointPublishingStrategy endpointPublishingStrategyUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (endpointPublishingStrategyUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new EndpointPublishingStrategyBuilder(endpointPublishingStrategyUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.EndpointPublishingStrategyUnsupportedConfigOverridesNested<A> withNewEndpointPublishingStrategyUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.EndpointPublishingStrategyUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.EndpointPublishingStrategyUnsupportedConfigOverridesNested<A> withNewEndpointPublishingStrategyUnsupportedConfigOverridesLike(EndpointPublishingStrategy item) {
    return new IngressControllerSpecFluentImpl.EndpointPublishingStrategyUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withIPFIXConfigUnsupportedOverrides(IPFIXConfig iPFIXConfigUnsupportedOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (iPFIXConfigUnsupportedOverrides!=null){ this.unsupportedConfigOverrides= new IPFIXConfigBuilder(iPFIXConfigUnsupportedOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.IPFIXConfigUnsupportedOverridesNested<A> withNewIPFIXConfigUnsupportedOverrides() {
    return new IngressControllerSpecFluentImpl.IPFIXConfigUnsupportedOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.IPFIXConfigUnsupportedOverridesNested<A> withNewIPFIXConfigUnsupportedOverridesLike(IPFIXConfig item) {
    return new IngressControllerSpecFluentImpl.IPFIXConfigUnsupportedOverridesNestedImpl(item);
  }
  public A withCloudCredentialUnsupportedConfigOverrides(CloudCredential cloudCredentialUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (cloudCredentialUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new CloudCredentialBuilder(cloudCredentialUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.CloudCredentialUnsupportedConfigOverridesNested<A> withNewCloudCredentialUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.CloudCredentialUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.CloudCredentialUnsupportedConfigOverridesNested<A> withNewCloudCredentialUnsupportedConfigOverridesLike(CloudCredential item) {
    return new IngressControllerSpecFluentImpl.CloudCredentialUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withKubeSchedulerUnsupportedConfigOverrides(KubeScheduler kubeSchedulerUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (kubeSchedulerUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new KubeSchedulerBuilder(kubeSchedulerUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.KubeSchedulerUnsupportedConfigOverridesNested<A> withNewKubeSchedulerUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.KubeSchedulerUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.KubeSchedulerUnsupportedConfigOverridesNested<A> withNewKubeSchedulerUnsupportedConfigOverridesLike(KubeScheduler item) {
    return new IngressControllerSpecFluentImpl.KubeSchedulerUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withClusterCSIDriverStatusUnsupportedConfigOverrides(ClusterCSIDriverStatus clusterCSIDriverStatusUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (clusterCSIDriverStatusUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new ClusterCSIDriverStatusBuilder(clusterCSIDriverStatusUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.ClusterCSIDriverStatusUnsupportedConfigOverridesNested<A> withNewClusterCSIDriverStatusUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.ClusterCSIDriverStatusUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.ClusterCSIDriverStatusUnsupportedConfigOverridesNested<A> withNewClusterCSIDriverStatusUnsupportedConfigOverridesLike(ClusterCSIDriverStatus item) {
    return new IngressControllerSpecFluentImpl.ClusterCSIDriverStatusUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withNetworkStatusUnsupportedConfigOverrides(NetworkStatus networkStatusUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (networkStatusUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new NetworkStatusBuilder(networkStatusUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.NetworkStatusUnsupportedConfigOverridesNested<A> withNewNetworkStatusUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.NetworkStatusUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.NetworkStatusUnsupportedConfigOverridesNested<A> withNewNetworkStatusUnsupportedConfigOverridesLike(NetworkStatus item) {
    return new IngressControllerSpecFluentImpl.NetworkStatusUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withSFlowConfigUnsupportedOverrides(SFlowConfig sFlowConfigUnsupportedOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (sFlowConfigUnsupportedOverrides!=null){ this.unsupportedConfigOverrides= new SFlowConfigBuilder(sFlowConfigUnsupportedOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.SFlowConfigUnsupportedOverridesNested<A> withNewSFlowConfigUnsupportedOverrides() {
    return new IngressControllerSpecFluentImpl.SFlowConfigUnsupportedOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.SFlowConfigUnsupportedOverridesNested<A> withNewSFlowConfigUnsupportedOverridesLike(SFlowConfig item) {
    return new IngressControllerSpecFluentImpl.SFlowConfigUnsupportedOverridesNestedImpl(item);
  }
  public A withForwardPluginUnsupportedConfigOverrides(ForwardPlugin forwardPluginUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (forwardPluginUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new ForwardPluginBuilder(forwardPluginUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.ForwardPluginUnsupportedConfigOverridesNested<A> withNewForwardPluginUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.ForwardPluginUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.ForwardPluginUnsupportedConfigOverridesNested<A> withNewForwardPluginUnsupportedConfigOverridesLike(ForwardPlugin item) {
    return new IngressControllerSpecFluentImpl.ForwardPluginUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withLogEntryUnsupportedConfigOverrides(LogEntry logEntryUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (logEntryUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new LogEntryBuilder(logEntryUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.LogEntryUnsupportedConfigOverridesNested<A> withNewLogEntryUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.LogEntryUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.LogEntryUnsupportedConfigOverridesNested<A> withNewLogEntryUnsupportedConfigOverridesLike(LogEntry item) {
    return new IngressControllerSpecFluentImpl.LogEntryUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withNodeStatusUnsupportedConfigOverrides(NodeStatus nodeStatusUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (nodeStatusUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new NodeStatusBuilder(nodeStatusUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.NodeStatusUnsupportedConfigOverridesNested<A> withNewNodeStatusUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.NodeStatusUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.NodeStatusUnsupportedConfigOverridesNested<A> withNewNodeStatusUnsupportedConfigOverridesLike(NodeStatus item) {
    return new IngressControllerSpecFluentImpl.NodeStatusUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withPodNetworkConnectivityCheckConditionUnsupportedConfigOverrides(PodNetworkConnectivityCheckCondition podNetworkConnectivityCheckConditionUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (podNetworkConnectivityCheckConditionUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new PodNetworkConnectivityCheckConditionBuilder(podNetworkConnectivityCheckConditionUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.PodNetworkConnectivityCheckConditionUnsupportedConfigOverridesNested<A> withNewPodNetworkConnectivityCheckConditionUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.PodNetworkConnectivityCheckConditionUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.PodNetworkConnectivityCheckConditionUnsupportedConfigOverridesNested<A> withNewPodNetworkConnectivityCheckConditionUnsupportedConfigOverridesLike(PodNetworkConnectivityCheckCondition item) {
    return new IngressControllerSpecFluentImpl.PodNetworkConnectivityCheckConditionUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withNewPodNetworkConnectivityCheckConditionUnsupportedConfigOverrides(String lastTransitionTime,String message,String reason,String status,String type) {
    return (A)withPodNetworkConnectivityCheckConditionUnsupportedConfigOverrides(new PodNetworkConnectivityCheckCondition(lastTransitionTime, message, reason, status, type));
  }
  public A withAdditionalNetworkDefinitionUnsupportedConfigOverrides(AdditionalNetworkDefinition additionalNetworkDefinitionUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (additionalNetworkDefinitionUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new AdditionalNetworkDefinitionBuilder(additionalNetworkDefinitionUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.AdditionalNetworkDefinitionUnsupportedConfigOverridesNested<A> withNewAdditionalNetworkDefinitionUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.AdditionalNetworkDefinitionUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.AdditionalNetworkDefinitionUnsupportedConfigOverridesNested<A> withNewAdditionalNetworkDefinitionUnsupportedConfigOverridesLike(AdditionalNetworkDefinition item) {
    return new IngressControllerSpecFluentImpl.AdditionalNetworkDefinitionUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withRouteAdmissionPolicyUnsupportedConfigOverrides(RouteAdmissionPolicy routeAdmissionPolicyUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (routeAdmissionPolicyUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new RouteAdmissionPolicyBuilder(routeAdmissionPolicyUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.RouteAdmissionPolicyUnsupportedConfigOverridesNested<A> withNewRouteAdmissionPolicyUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.RouteAdmissionPolicyUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.RouteAdmissionPolicyUnsupportedConfigOverridesNested<A> withNewRouteAdmissionPolicyUnsupportedConfigOverridesLike(RouteAdmissionPolicy item) {
    return new IngressControllerSpecFluentImpl.RouteAdmissionPolicyUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withNewRouteAdmissionPolicyUnsupportedConfigOverrides(String namespaceOwnership,String wildcardPolicy) {
    return (A)withRouteAdmissionPolicyUnsupportedConfigOverrides(new RouteAdmissionPolicy(namespaceOwnership, wildcardPolicy));
  }
  public A withGenerationStatusUnsupportedConfigOverrides(GenerationStatus generationStatusUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (generationStatusUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new GenerationStatusBuilder(generationStatusUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.GenerationStatusUnsupportedConfigOverridesNested<A> withNewGenerationStatusUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.GenerationStatusUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.GenerationStatusUnsupportedConfigOverridesNested<A> withNewGenerationStatusUnsupportedConfigOverridesLike(GenerationStatus item) {
    return new IngressControllerSpecFluentImpl.GenerationStatusUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withAuthenticationStatusUnsupportedConfigOverrides(AuthenticationStatus authenticationStatusUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (authenticationStatusUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new AuthenticationStatusBuilder(authenticationStatusUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.AuthenticationStatusUnsupportedConfigOverridesNested<A> withNewAuthenticationStatusUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.AuthenticationStatusUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.AuthenticationStatusUnsupportedConfigOverridesNested<A> withNewAuthenticationStatusUnsupportedConfigOverridesLike(AuthenticationStatus item) {
    return new IngressControllerSpecFluentImpl.AuthenticationStatusUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withIngressControllerCaptureHTTPHeadersUnsupportedConfigOverrides(IngressControllerCaptureHTTPHeaders ingressControllerCaptureHTTPHeadersUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (ingressControllerCaptureHTTPHeadersUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new IngressControllerCaptureHTTPHeadersBuilder(ingressControllerCaptureHTTPHeadersUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.IngressControllerCaptureHTTPHeadersUnsupportedConfigOverridesNested<A> withNewIngressControllerCaptureHTTPHeadersUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.IngressControllerCaptureHTTPHeadersUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.IngressControllerCaptureHTTPHeadersUnsupportedConfigOverridesNested<A> withNewIngressControllerCaptureHTTPHeadersUnsupportedConfigOverridesLike(IngressControllerCaptureHTTPHeaders item) {
    return new IngressControllerSpecFluentImpl.IngressControllerCaptureHTTPHeadersUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withEtcdListUnsupportedConfigOverrides(EtcdList etcdListUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (etcdListUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new EtcdListBuilder(etcdListUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.EtcdListUnsupportedConfigOverridesNested<A> withNewEtcdListUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.EtcdListUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.EtcdListUnsupportedConfigOverridesNested<A> withNewEtcdListUnsupportedConfigOverridesLike(EtcdList item) {
    return new IngressControllerSpecFluentImpl.EtcdListUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withNodePortStrategyUnsupportedConfigOverrides(NodePortStrategy nodePortStrategyUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (nodePortStrategyUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new NodePortStrategyBuilder(nodePortStrategyUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.NodePortStrategyUnsupportedConfigOverridesNested<A> withNewNodePortStrategyUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.NodePortStrategyUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.NodePortStrategyUnsupportedConfigOverridesNested<A> withNewNodePortStrategyUnsupportedConfigOverridesLike(NodePortStrategy item) {
    return new IngressControllerSpecFluentImpl.NodePortStrategyUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withNewNodePortStrategyUnsupportedConfigOverrides(String protocol) {
    return (A)withNodePortStrategyUnsupportedConfigOverrides(new NodePortStrategy(protocol));
  }
  public A withDefaultNetworkDefinitionUnsupportedConfigOverrides(DefaultNetworkDefinition defaultNetworkDefinitionUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (defaultNetworkDefinitionUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new DefaultNetworkDefinitionBuilder(defaultNetworkDefinitionUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.DefaultNetworkDefinitionUnsupportedConfigOverridesNested<A> withNewDefaultNetworkDefinitionUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.DefaultNetworkDefinitionUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.DefaultNetworkDefinitionUnsupportedConfigOverridesNested<A> withNewDefaultNetworkDefinitionUnsupportedConfigOverridesLike(DefaultNetworkDefinition item) {
    return new IngressControllerSpecFluentImpl.DefaultNetworkDefinitionUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withNetworkUnsupportedConfigOverrides(Network networkUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (networkUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new NetworkBuilder(networkUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.NetworkUnsupportedConfigOverridesNested<A> withNewNetworkUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.NetworkUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.NetworkUnsupportedConfigOverridesNested<A> withNewNetworkUnsupportedConfigOverridesLike(Network item) {
    return new IngressControllerSpecFluentImpl.NetworkUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withClientTLSUnsupportedConfigOverrides(ClientTLS clientTLSUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (clientTLSUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new ClientTLSBuilder(clientTLSUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.ClientTLSUnsupportedConfigOverridesNested<A> withNewClientTLSUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.ClientTLSUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.ClientTLSUnsupportedConfigOverridesNested<A> withNewClientTLSUnsupportedConfigOverridesLike(ClientTLS item) {
    return new IngressControllerSpecFluentImpl.ClientTLSUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withOpenShiftAPIServerSpecUnsupportedConfigOverrides(OpenShiftAPIServerSpec openShiftAPIServerSpecUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (openShiftAPIServerSpecUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new OpenShiftAPIServerSpecBuilder(openShiftAPIServerSpecUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.OpenShiftAPIServerSpecUnsupportedConfigOverridesNested<A> withNewOpenShiftAPIServerSpecUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.OpenShiftAPIServerSpecUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.OpenShiftAPIServerSpecUnsupportedConfigOverridesNested<A> withNewOpenShiftAPIServerSpecUnsupportedConfigOverridesLike(OpenShiftAPIServerSpec item) {
    return new IngressControllerSpecFluentImpl.OpenShiftAPIServerSpecUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withImagePrunerStatusUnsupportedConfigOverrides(ImagePrunerStatus imagePrunerStatusUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (imagePrunerStatusUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new ImagePrunerStatusBuilder(imagePrunerStatusUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.ImagePrunerStatusUnsupportedConfigOverridesNested<A> withNewImagePrunerStatusUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.ImagePrunerStatusUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.ImagePrunerStatusUnsupportedConfigOverridesNested<A> withNewImagePrunerStatusUnsupportedConfigOverridesLike(ImagePrunerStatus item) {
    return new IngressControllerSpecFluentImpl.ImagePrunerStatusUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withKubeSchedulerStatusUnsupportedConfigOverrides(KubeSchedulerStatus kubeSchedulerStatusUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (kubeSchedulerStatusUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new KubeSchedulerStatusBuilder(kubeSchedulerStatusUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.KubeSchedulerStatusUnsupportedConfigOverridesNested<A> withNewKubeSchedulerStatusUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.KubeSchedulerStatusUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.KubeSchedulerStatusUnsupportedConfigOverridesNested<A> withNewKubeSchedulerStatusUnsupportedConfigOverridesLike(KubeSchedulerStatus item) {
    return new IngressControllerSpecFluentImpl.KubeSchedulerStatusUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withSyslogLoggingDestinationParametersUnsupportedConfigOverrides(SyslogLoggingDestinationParameters syslogLoggingDestinationParametersUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (syslogLoggingDestinationParametersUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new SyslogLoggingDestinationParametersBuilder(syslogLoggingDestinationParametersUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.SyslogLoggingDestinationParametersUnsupportedConfigOverridesNested<A> withNewSyslogLoggingDestinationParametersUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.SyslogLoggingDestinationParametersUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.SyslogLoggingDestinationParametersUnsupportedConfigOverridesNested<A> withNewSyslogLoggingDestinationParametersUnsupportedConfigOverridesLike(SyslogLoggingDestinationParameters item) {
    return new IngressControllerSpecFluentImpl.SyslogLoggingDestinationParametersUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withNewSyslogLoggingDestinationParametersUnsupportedConfigOverrides(String address,String facility,Integer maxLength,Integer port) {
    return (A)withSyslogLoggingDestinationParametersUnsupportedConfigOverrides(new SyslogLoggingDestinationParameters(address, facility, maxLength, port));
  }
  public A withUpstreamUnsupportedConfigOverrides(Upstream upstreamUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (upstreamUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new UpstreamBuilder(upstreamUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.UpstreamUnsupportedConfigOverridesNested<A> withNewUpstreamUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.UpstreamUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.UpstreamUnsupportedConfigOverridesNested<A> withNewUpstreamUnsupportedConfigOverridesLike(Upstream item) {
    return new IngressControllerSpecFluentImpl.UpstreamUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withNewUpstreamUnsupportedConfigOverrides(String address,Integer port,String type) {
    return (A)withUpstreamUnsupportedConfigOverrides(new Upstream(address, port, type));
  }
  public A withAWSNetworkLoadBalancerParametersUnsupportedConfigOverrides(AWSNetworkLoadBalancerParameters aWSNetworkLoadBalancerParametersUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (aWSNetworkLoadBalancerParametersUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new AWSNetworkLoadBalancerParametersBuilder(aWSNetworkLoadBalancerParametersUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.AWSNetworkLoadBalancerParametersUnsupportedConfigOverridesNested<A> withNewAWSNetworkLoadBalancerParametersUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.AWSNetworkLoadBalancerParametersUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.AWSNetworkLoadBalancerParametersUnsupportedConfigOverridesNested<A> withNewAWSNetworkLoadBalancerParametersUnsupportedConfigOverridesLike(AWSNetworkLoadBalancerParameters item) {
    return new IngressControllerSpecFluentImpl.AWSNetworkLoadBalancerParametersUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withServiceCAListUnsupportedConfigOverrides(ServiceCAList serviceCAListUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (serviceCAListUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new ServiceCAListBuilder(serviceCAListUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.ServiceCAListUnsupportedConfigOverridesNested<A> withNewServiceCAListUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.ServiceCAListUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.ServiceCAListUnsupportedConfigOverridesNested<A> withNewServiceCAListUnsupportedConfigOverridesLike(ServiceCAList item) {
    return new IngressControllerSpecFluentImpl.ServiceCAListUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withServiceCatalogAPIServerUnsupportedConfigOverrides(ServiceCatalogAPIServer serviceCatalogAPIServerUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (serviceCatalogAPIServerUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new ServiceCatalogAPIServerBuilder(serviceCatalogAPIServerUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.ServiceCatalogAPIServerUnsupportedConfigOverridesNested<A> withNewServiceCatalogAPIServerUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.ServiceCatalogAPIServerUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.ServiceCatalogAPIServerUnsupportedConfigOverridesNested<A> withNewServiceCatalogAPIServerUnsupportedConfigOverridesLike(ServiceCatalogAPIServer item) {
    return new IngressControllerSpecFluentImpl.ServiceCatalogAPIServerUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withIngressControllerCaptureHTTPHeaderUnsupportedConfigOverrides(IngressControllerCaptureHTTPHeader ingressControllerCaptureHTTPHeaderUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (ingressControllerCaptureHTTPHeaderUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new IngressControllerCaptureHTTPHeaderBuilder(ingressControllerCaptureHTTPHeaderUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.IngressControllerCaptureHTTPHeaderUnsupportedConfigOverridesNested<A> withNewIngressControllerCaptureHTTPHeaderUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.IngressControllerCaptureHTTPHeaderUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.IngressControllerCaptureHTTPHeaderUnsupportedConfigOverridesNested<A> withNewIngressControllerCaptureHTTPHeaderUnsupportedConfigOverridesLike(IngressControllerCaptureHTTPHeader item) {
    return new IngressControllerSpecFluentImpl.IngressControllerCaptureHTTPHeaderUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withNewIngressControllerCaptureHTTPHeaderUnsupportedConfigOverrides(Integer maxLength,String name) {
    return (A)withIngressControllerCaptureHTTPHeaderUnsupportedConfigOverrides(new IngressControllerCaptureHTTPHeader(maxLength, name));
  }
  public A withNetworkMigrationUnsupportedConfigOverrides(NetworkMigration networkMigrationUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (networkMigrationUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new NetworkMigrationBuilder(networkMigrationUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.NetworkMigrationUnsupportedConfigOverridesNested<A> withNewNetworkMigrationUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.NetworkMigrationUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.NetworkMigrationUnsupportedConfigOverridesNested<A> withNewNetworkMigrationUnsupportedConfigOverridesLike(NetworkMigration item) {
    return new IngressControllerSpecFluentImpl.NetworkMigrationUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withNewNetworkMigrationUnsupportedConfigOverrides(String networkType) {
    return (A)withNetworkMigrationUnsupportedConfigOverrides(new NetworkMigration(networkType));
  }
  public A withDNSRecordListUnsupportedConfigOverrides(DNSRecordList dNSRecordListUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (dNSRecordListUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new DNSRecordListBuilder(dNSRecordListUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.DNSRecordListUnsupportedConfigOverridesNested<A> withNewDNSRecordListUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.DNSRecordListUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.DNSRecordListUnsupportedConfigOverridesNested<A> withNewDNSRecordListUnsupportedConfigOverridesLike(DNSRecordList item) {
    return new IngressControllerSpecFluentImpl.DNSRecordListUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withRawExtensionUnsupportedConfigOverrides(RawExtension rawExtensionUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (rawExtensionUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new RawExtensionBuilder(rawExtensionUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.RawExtensionUnsupportedConfigOverridesNested<A> withNewRawExtensionUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.RawExtensionUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.RawExtensionUnsupportedConfigOverridesNested<A> withNewRawExtensionUnsupportedConfigOverridesLike(RawExtension item) {
    return new IngressControllerSpecFluentImpl.RawExtensionUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withNewRawExtensionUnsupportedConfigOverrides(Object value) {
    return (A)withRawExtensionUnsupportedConfigOverrides(new RawExtension(value));
  }
  public A withEtcdSpecUnsupportedConfigOverrides(EtcdSpec etcdSpecUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (etcdSpecUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new EtcdSpecBuilder(etcdSpecUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.EtcdSpecUnsupportedConfigOverridesNested<A> withNewEtcdSpecUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.EtcdSpecUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.EtcdSpecUnsupportedConfigOverridesNested<A> withNewEtcdSpecUnsupportedConfigOverridesLike(EtcdSpec item) {
    return new IngressControllerSpecFluentImpl.EtcdSpecUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withPodNetworkConnectivityCheckUnsupportedConfigOverrides(PodNetworkConnectivityCheck podNetworkConnectivityCheckUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (podNetworkConnectivityCheckUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new PodNetworkConnectivityCheckBuilder(podNetworkConnectivityCheckUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.PodNetworkConnectivityCheckUnsupportedConfigOverridesNested<A> withNewPodNetworkConnectivityCheckUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.PodNetworkConnectivityCheckUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.PodNetworkConnectivityCheckUnsupportedConfigOverridesNested<A> withNewPodNetworkConnectivityCheckUnsupportedConfigOverridesLike(PodNetworkConnectivityCheck item) {
    return new IngressControllerSpecFluentImpl.PodNetworkConnectivityCheckUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withOpenShiftAPIServerStatusUnsupportedConfigOverrides(OpenShiftAPIServerStatus openShiftAPIServerStatusUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (openShiftAPIServerStatusUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new OpenShiftAPIServerStatusBuilder(openShiftAPIServerStatusUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.OpenShiftAPIServerStatusUnsupportedConfigOverridesNested<A> withNewOpenShiftAPIServerStatusUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.OpenShiftAPIServerStatusUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.OpenShiftAPIServerStatusUnsupportedConfigOverridesNested<A> withNewOpenShiftAPIServerStatusUnsupportedConfigOverridesLike(OpenShiftAPIServerStatus item) {
    return new IngressControllerSpecFluentImpl.OpenShiftAPIServerStatusUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withLoadBalancerStrategyUnsupportedConfigOverrides(LoadBalancerStrategy loadBalancerStrategyUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (loadBalancerStrategyUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new LoadBalancerStrategyBuilder(loadBalancerStrategyUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.LoadBalancerStrategyUnsupportedConfigOverridesNested<A> withNewLoadBalancerStrategyUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.LoadBalancerStrategyUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.LoadBalancerStrategyUnsupportedConfigOverridesNested<A> withNewLoadBalancerStrategyUnsupportedConfigOverridesLike(LoadBalancerStrategy item) {
    return new IngressControllerSpecFluentImpl.LoadBalancerStrategyUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withEtcdStatusUnsupportedConfigOverrides(EtcdStatus etcdStatusUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (etcdStatusUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new EtcdStatusBuilder(etcdStatusUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.EtcdStatusUnsupportedConfigOverridesNested<A> withNewEtcdStatusUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.EtcdStatusUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.EtcdStatusUnsupportedConfigOverridesNested<A> withNewEtcdStatusUnsupportedConfigOverridesLike(EtcdStatus item) {
    return new IngressControllerSpecFluentImpl.EtcdStatusUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withCloudCredentialListUnsupportedConfigOverrides(CloudCredentialList cloudCredentialListUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (cloudCredentialListUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new CloudCredentialListBuilder(cloudCredentialListUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.CloudCredentialListUnsupportedConfigOverridesNested<A> withNewCloudCredentialListUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.CloudCredentialListUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.CloudCredentialListUnsupportedConfigOverridesNested<A> withNewCloudCredentialListUnsupportedConfigOverridesLike(CloudCredentialList item) {
    return new IngressControllerSpecFluentImpl.CloudCredentialListUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withImagePrunerSpecUnsupportedConfigOverrides(ImagePrunerSpec imagePrunerSpecUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (imagePrunerSpecUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new ImagePrunerSpecBuilder(imagePrunerSpecUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.ImagePrunerSpecUnsupportedConfigOverridesNested<A> withNewImagePrunerSpecUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.ImagePrunerSpecUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.ImagePrunerSpecUnsupportedConfigOverridesNested<A> withNewImagePrunerSpecUnsupportedConfigOverridesLike(ImagePrunerSpec item) {
    return new IngressControllerSpecFluentImpl.ImagePrunerSpecUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withStatuspageProviderUnsupportedConfigOverrides(StatuspageProvider statuspageProviderUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (statuspageProviderUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new StatuspageProviderBuilder(statuspageProviderUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.StatuspageProviderUnsupportedConfigOverridesNested<A> withNewStatuspageProviderUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.StatuspageProviderUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.StatuspageProviderUnsupportedConfigOverridesNested<A> withNewStatuspageProviderUnsupportedConfigOverridesLike(StatuspageProvider item) {
    return new IngressControllerSpecFluentImpl.StatuspageProviderUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withNewStatuspageProviderUnsupportedConfigOverrides(String pageID) {
    return (A)withStatuspageProviderUnsupportedConfigOverrides(new StatuspageProvider(pageID));
  }
  public A withKubeStorageVersionMigratorStatusUnsupportedConfigOverrides(KubeStorageVersionMigratorStatus kubeStorageVersionMigratorStatusUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (kubeStorageVersionMigratorStatusUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new KubeStorageVersionMigratorStatusBuilder(kubeStorageVersionMigratorStatusUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.KubeStorageVersionMigratorStatusUnsupportedConfigOverridesNested<A> withNewKubeStorageVersionMigratorStatusUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.KubeStorageVersionMigratorStatusUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.KubeStorageVersionMigratorStatusUnsupportedConfigOverridesNested<A> withNewKubeStorageVersionMigratorStatusUnsupportedConfigOverridesLike(KubeStorageVersionMigratorStatus item) {
    return new IngressControllerSpecFluentImpl.KubeStorageVersionMigratorStatusUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withConfigListUnsupportedConfigOverrides(ConfigList configListUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (configListUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new ConfigListBuilder(configListUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.ConfigListUnsupportedConfigOverridesNested<A> withNewConfigListUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.ConfigListUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.ConfigListUnsupportedConfigOverridesNested<A> withNewConfigListUnsupportedConfigOverridesLike(ConfigList item) {
    return new IngressControllerSpecFluentImpl.ConfigListUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withConsoleProvidersUnsupportedConfigOverrides(ConsoleProviders consoleProvidersUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (consoleProvidersUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new ConsoleProvidersBuilder(consoleProvidersUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.ConsoleProvidersUnsupportedConfigOverridesNested<A> withNewConsoleProvidersUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.ConsoleProvidersUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.ConsoleProvidersUnsupportedConfigOverridesNested<A> withNewConsoleProvidersUnsupportedConfigOverridesLike(ConsoleProviders item) {
    return new IngressControllerSpecFluentImpl.ConsoleProvidersUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withIngressControllerLoggingUnsupportedConfigOverrides(IngressControllerLogging ingressControllerLoggingUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (ingressControllerLoggingUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new IngressControllerLoggingBuilder(ingressControllerLoggingUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.IngressControllerLoggingUnsupportedConfigOverridesNested<A> withNewIngressControllerLoggingUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.IngressControllerLoggingUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.IngressControllerLoggingUnsupportedConfigOverridesNested<A> withNewIngressControllerLoggingUnsupportedConfigOverridesLike(IngressControllerLogging item) {
    return new IngressControllerSpecFluentImpl.IngressControllerLoggingUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withAuthenticationListUnsupportedConfigOverrides(AuthenticationList authenticationListUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (authenticationListUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new AuthenticationListBuilder(authenticationListUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.AuthenticationListUnsupportedConfigOverridesNested<A> withNewAuthenticationListUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.AuthenticationListUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.AuthenticationListUnsupportedConfigOverridesNested<A> withNewAuthenticationListUnsupportedConfigOverridesLike(AuthenticationList item) {
    return new IngressControllerSpecFluentImpl.AuthenticationListUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withStorageStatusUnsupportedConfigOverrides(StorageStatus storageStatusUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (storageStatusUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new StorageStatusBuilder(storageStatusUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.StorageStatusUnsupportedConfigOverridesNested<A> withNewStorageStatusUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.StorageStatusUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.StorageStatusUnsupportedConfigOverridesNested<A> withNewStorageStatusUnsupportedConfigOverridesLike(StorageStatus item) {
    return new IngressControllerSpecFluentImpl.StorageStatusUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withKubeControllerManagerListUnsupportedConfigOverrides(KubeControllerManagerList kubeControllerManagerListUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (kubeControllerManagerListUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new KubeControllerManagerListBuilder(kubeControllerManagerListUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.KubeControllerManagerListUnsupportedConfigOverridesNested<A> withNewKubeControllerManagerListUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.KubeControllerManagerListUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.KubeControllerManagerListUnsupportedConfigOverridesNested<A> withNewKubeControllerManagerListUnsupportedConfigOverridesLike(KubeControllerManagerList item) {
    return new IngressControllerSpecFluentImpl.KubeControllerManagerListUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withAuthenticationSpecUnsupportedConfigOverrides(AuthenticationSpec authenticationSpecUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (authenticationSpecUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new AuthenticationSpecBuilder(authenticationSpecUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.AuthenticationSpecUnsupportedConfigOverridesNested<A> withNewAuthenticationSpecUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.AuthenticationSpecUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.AuthenticationSpecUnsupportedConfigOverridesNested<A> withNewAuthenticationSpecUnsupportedConfigOverridesLike(AuthenticationSpec item) {
    return new IngressControllerSpecFluentImpl.AuthenticationSpecUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withIPAMConfigUnsupportedOverrides(IPAMConfig iPAMConfigUnsupportedOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (iPAMConfigUnsupportedOverrides!=null){ this.unsupportedConfigOverrides= new IPAMConfigBuilder(iPAMConfigUnsupportedOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.IPAMConfigUnsupportedOverridesNested<A> withNewIPAMConfigUnsupportedOverrides() {
    return new IngressControllerSpecFluentImpl.IPAMConfigUnsupportedOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.IPAMConfigUnsupportedOverridesNested<A> withNewIPAMConfigUnsupportedOverridesLike(IPAMConfig item) {
    return new IngressControllerSpecFluentImpl.IPAMConfigUnsupportedOverridesNestedImpl(item);
  }
  public A withContainerUnsupportedConfigOverrides(Container containerUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (containerUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new ContainerBuilder(containerUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.ContainerUnsupportedConfigOverridesNested<A> withNewContainerUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.ContainerUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.ContainerUnsupportedConfigOverridesNested<A> withNewContainerUnsupportedConfigOverridesLike(Container item) {
    return new IngressControllerSpecFluentImpl.ContainerUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withCSISnapshotControllerUnsupportedConfigOverrides(CSISnapshotController cSISnapshotControllerUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (cSISnapshotControllerUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new CSISnapshotControllerBuilder(cSISnapshotControllerUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.CSISnapshotControllerUnsupportedConfigOverridesNested<A> withNewCSISnapshotControllerUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.CSISnapshotControllerUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.CSISnapshotControllerUnsupportedConfigOverridesNested<A> withNewCSISnapshotControllerUnsupportedConfigOverridesLike(CSISnapshotController item) {
    return new IngressControllerSpecFluentImpl.CSISnapshotControllerUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withPodNetworkConnectivityCheckSpecUnsupportedConfigOverrides(PodNetworkConnectivityCheckSpec podNetworkConnectivityCheckSpecUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (podNetworkConnectivityCheckSpecUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new PodNetworkConnectivityCheckSpecBuilder(podNetworkConnectivityCheckSpecUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.PodNetworkConnectivityCheckSpecUnsupportedConfigOverridesNested<A> withNewPodNetworkConnectivityCheckSpecUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.PodNetworkConnectivityCheckSpecUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.PodNetworkConnectivityCheckSpecUnsupportedConfigOverridesNested<A> withNewPodNetworkConnectivityCheckSpecUnsupportedConfigOverridesLike(PodNetworkConnectivityCheckSpec item) {
    return new IngressControllerSpecFluentImpl.PodNetworkConnectivityCheckSpecUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withAccessLoggingUnsupportedConfigOverrides(AccessLogging accessLoggingUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (accessLoggingUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new AccessLoggingBuilder(accessLoggingUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.AccessLoggingUnsupportedConfigOverridesNested<A> withNewAccessLoggingUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.AccessLoggingUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.AccessLoggingUnsupportedConfigOverridesNested<A> withNewAccessLoggingUnsupportedConfigOverridesLike(AccessLogging item) {
    return new IngressControllerSpecFluentImpl.AccessLoggingUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withHostNetworkStrategyUnsupportedConfigOverrides(HostNetworkStrategy hostNetworkStrategyUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (hostNetworkStrategyUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new HostNetworkStrategyBuilder(hostNetworkStrategyUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.HostNetworkStrategyUnsupportedConfigOverridesNested<A> withNewHostNetworkStrategyUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.HostNetworkStrategyUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.HostNetworkStrategyUnsupportedConfigOverridesNested<A> withNewHostNetworkStrategyUnsupportedConfigOverridesLike(HostNetworkStrategy item) {
    return new IngressControllerSpecFluentImpl.HostNetworkStrategyUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withNewHostNetworkStrategyUnsupportedConfigOverrides(String protocol) {
    return (A)withHostNetworkStrategyUnsupportedConfigOverrides(new HostNetworkStrategy(protocol));
  }
  public A withDNSRecordSpecUnsupportedConfigOverrides(DNSRecordSpec dNSRecordSpecUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (dNSRecordSpecUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new DNSRecordSpecBuilder(dNSRecordSpecUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.DNSRecordSpecUnsupportedConfigOverridesNested<A> withNewDNSRecordSpecUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.DNSRecordSpecUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.DNSRecordSpecUnsupportedConfigOverridesNested<A> withNewDNSRecordSpecUnsupportedConfigOverridesLike(DNSRecordSpec item) {
    return new IngressControllerSpecFluentImpl.DNSRecordSpecUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withDeveloperConsoleCatalogCustomizationUnsupportedConfigOverrides(DeveloperConsoleCatalogCustomization developerConsoleCatalogCustomizationUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (developerConsoleCatalogCustomizationUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new DeveloperConsoleCatalogCustomizationBuilder(developerConsoleCatalogCustomizationUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.DeveloperConsoleCatalogCustomizationUnsupportedConfigOverridesNested<A> withNewDeveloperConsoleCatalogCustomizationUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.DeveloperConsoleCatalogCustomizationUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.DeveloperConsoleCatalogCustomizationUnsupportedConfigOverridesNested<A> withNewDeveloperConsoleCatalogCustomizationUnsupportedConfigOverridesLike(DeveloperConsoleCatalogCustomization item) {
    return new IngressControllerSpecFluentImpl.DeveloperConsoleCatalogCustomizationUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withKubeSchedulerSpecUnsupportedConfigOverrides(KubeSchedulerSpec kubeSchedulerSpecUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (kubeSchedulerSpecUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new KubeSchedulerSpecBuilder(kubeSchedulerSpecUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.KubeSchedulerSpecUnsupportedConfigOverridesNested<A> withNewKubeSchedulerSpecUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.KubeSchedulerSpecUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.KubeSchedulerSpecUnsupportedConfigOverridesNested<A> withNewKubeSchedulerSpecUnsupportedConfigOverridesLike(KubeSchedulerSpec item) {
    return new IngressControllerSpecFluentImpl.KubeSchedulerSpecUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withLoggingDestinationUnsupportedConfigOverrides(LoggingDestination loggingDestinationUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (loggingDestinationUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new LoggingDestinationBuilder(loggingDestinationUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.LoggingDestinationUnsupportedConfigOverridesNested<A> withNewLoggingDestinationUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.LoggingDestinationUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.LoggingDestinationUnsupportedConfigOverridesNested<A> withNewLoggingDestinationUnsupportedConfigOverridesLike(LoggingDestination item) {
    return new IngressControllerSpecFluentImpl.LoggingDestinationUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withIngressControllerTuningOptionsUnsupportedConfigOverrides(IngressControllerTuningOptions ingressControllerTuningOptionsUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (ingressControllerTuningOptionsUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new IngressControllerTuningOptionsBuilder(ingressControllerTuningOptionsUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.IngressControllerTuningOptionsUnsupportedConfigOverridesNested<A> withNewIngressControllerTuningOptionsUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.IngressControllerTuningOptionsUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.IngressControllerTuningOptionsUnsupportedConfigOverridesNested<A> withNewIngressControllerTuningOptionsUnsupportedConfigOverridesLike(IngressControllerTuningOptions item) {
    return new IngressControllerSpecFluentImpl.IngressControllerTuningOptionsUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withStaticIPAMConfigUnsupportedOverrides(StaticIPAMConfig staticIPAMConfigUnsupportedOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (staticIPAMConfigUnsupportedOverrides!=null){ this.unsupportedConfigOverrides= new StaticIPAMConfigBuilder(staticIPAMConfigUnsupportedOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.StaticIPAMConfigUnsupportedOverridesNested<A> withNewStaticIPAMConfigUnsupportedOverrides() {
    return new IngressControllerSpecFluentImpl.StaticIPAMConfigUnsupportedOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.StaticIPAMConfigUnsupportedOverridesNested<A> withNewStaticIPAMConfigUnsupportedOverridesLike(StaticIPAMConfig item) {
    return new IngressControllerSpecFluentImpl.StaticIPAMConfigUnsupportedOverridesNestedImpl(item);
  }
  public A withImageContentSourcePolicyListUnsupportedConfigOverrides(ImageContentSourcePolicyList imageContentSourcePolicyListUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (imageContentSourcePolicyListUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new ImageContentSourcePolicyListBuilder(imageContentSourcePolicyListUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.ImageContentSourcePolicyListUnsupportedConfigOverridesNested<A> withNewImageContentSourcePolicyListUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.ImageContentSourcePolicyListUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.ImageContentSourcePolicyListUnsupportedConfigOverridesNested<A> withNewImageContentSourcePolicyListUnsupportedConfigOverridesLike(ImageContentSourcePolicyList item) {
    return new IngressControllerSpecFluentImpl.ImageContentSourcePolicyListUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withOpenShiftControllerManagerStatusUnsupportedConfigOverrides(OpenShiftControllerManagerStatus openShiftControllerManagerStatusUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (openShiftControllerManagerStatusUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new OpenShiftControllerManagerStatusBuilder(openShiftControllerManagerStatusUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.OpenShiftControllerManagerStatusUnsupportedConfigOverridesNested<A> withNewOpenShiftControllerManagerStatusUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.OpenShiftControllerManagerStatusUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.OpenShiftControllerManagerStatusUnsupportedConfigOverridesNested<A> withNewOpenShiftControllerManagerStatusUnsupportedConfigOverridesLike(OpenShiftControllerManagerStatus item) {
    return new IngressControllerSpecFluentImpl.OpenShiftControllerManagerStatusUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withServiceCatalogAPIServerStatusUnsupportedConfigOverrides(ServiceCatalogAPIServerStatus serviceCatalogAPIServerStatusUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (serviceCatalogAPIServerStatusUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new ServiceCatalogAPIServerStatusBuilder(serviceCatalogAPIServerStatusUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.ServiceCatalogAPIServerStatusUnsupportedConfigOverridesNested<A> withNewServiceCatalogAPIServerStatusUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.ServiceCatalogAPIServerStatusUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.ServiceCatalogAPIServerStatusUnsupportedConfigOverridesNested<A> withNewServiceCatalogAPIServerStatusUnsupportedConfigOverridesLike(ServiceCatalogAPIServerStatus item) {
    return new IngressControllerSpecFluentImpl.ServiceCatalogAPIServerStatusUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withKubeControllerManagerSpecUnsupportedConfigOverrides(KubeControllerManagerSpec kubeControllerManagerSpecUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (kubeControllerManagerSpecUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new KubeControllerManagerSpecBuilder(kubeControllerManagerSpecUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.KubeControllerManagerSpecUnsupportedConfigOverridesNested<A> withNewKubeControllerManagerSpecUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.KubeControllerManagerSpecUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.KubeControllerManagerSpecUnsupportedConfigOverridesNested<A> withNewKubeControllerManagerSpecUnsupportedConfigOverridesLike(KubeControllerManagerSpec item) {
    return new IngressControllerSpecFluentImpl.KubeControllerManagerSpecUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withStaticIPAMDNSUnsupportedConfigOverrides(StaticIPAMDNS staticIPAMDNSUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (staticIPAMDNSUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new StaticIPAMDNSBuilder(staticIPAMDNSUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.StaticIPAMDNSUnsupportedConfigOverridesNested<A> withNewStaticIPAMDNSUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.StaticIPAMDNSUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.StaticIPAMDNSUnsupportedConfigOverridesNested<A> withNewStaticIPAMDNSUnsupportedConfigOverridesLike(StaticIPAMDNS item) {
    return new IngressControllerSpecFluentImpl.StaticIPAMDNSUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withDNSNodePlacementUnsupportedConfigOverrides(DNSNodePlacement dNSNodePlacementUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (dNSNodePlacementUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new DNSNodePlacementBuilder(dNSNodePlacementUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.DNSNodePlacementUnsupportedConfigOverridesNested<A> withNewDNSNodePlacementUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.DNSNodePlacementUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.DNSNodePlacementUnsupportedConfigOverridesNested<A> withNewDNSNodePlacementUnsupportedConfigOverridesLike(DNSNodePlacement item) {
    return new IngressControllerSpecFluentImpl.DNSNodePlacementUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withStorageSpecUnsupportedConfigOverrides(StorageSpec storageSpecUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (storageSpecUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new StorageSpecBuilder(storageSpecUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.StorageSpecUnsupportedConfigOverridesNested<A> withNewStorageSpecUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.StorageSpecUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.StorageSpecUnsupportedConfigOverridesNested<A> withNewStorageSpecUnsupportedConfigOverridesLike(StorageSpec item) {
    return new IngressControllerSpecFluentImpl.StorageSpecUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withNetworkListUnsupportedConfigOverrides(NetworkList networkListUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (networkListUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new NetworkListBuilder(networkListUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.NetworkListUnsupportedConfigOverridesNested<A> withNewNetworkListUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.NetworkListUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.NetworkListUnsupportedConfigOverridesNested<A> withNewNetworkListUnsupportedConfigOverridesLike(NetworkList item) {
    return new IngressControllerSpecFluentImpl.NetworkListUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withNodePlacementUnsupportedConfigOverrides(NodePlacement nodePlacementUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (nodePlacementUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new NodePlacementBuilder(nodePlacementUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.NodePlacementUnsupportedConfigOverridesNested<A> withNewNodePlacementUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.NodePlacementUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.NodePlacementUnsupportedConfigOverridesNested<A> withNewNodePlacementUnsupportedConfigOverridesLike(NodePlacement item) {
    return new IngressControllerSpecFluentImpl.NodePlacementUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withProviderLoadBalancerParametersUnsupportedConfigOverrides(ProviderLoadBalancerParameters providerLoadBalancerParametersUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (providerLoadBalancerParametersUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new ProviderLoadBalancerParametersBuilder(providerLoadBalancerParametersUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.ProviderLoadBalancerParametersUnsupportedConfigOverridesNested<A> withNewProviderLoadBalancerParametersUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.ProviderLoadBalancerParametersUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.ProviderLoadBalancerParametersUnsupportedConfigOverridesNested<A> withNewProviderLoadBalancerParametersUnsupportedConfigOverridesLike(ProviderLoadBalancerParameters item) {
    return new IngressControllerSpecFluentImpl.ProviderLoadBalancerParametersUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withNetworkSpecUnsupportedConfigOverrides(NetworkSpec networkSpecUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (networkSpecUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new NetworkSpecBuilder(networkSpecUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.NetworkSpecUnsupportedConfigOverridesNested<A> withNewNetworkSpecUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.NetworkSpecUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.NetworkSpecUnsupportedConfigOverridesNested<A> withNewNetworkSpecUnsupportedConfigOverridesLike(NetworkSpec item) {
    return new IngressControllerSpecFluentImpl.NetworkSpecUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withServiceCASpecUnsupportedConfigOverrides(ServiceCASpec serviceCASpecUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (serviceCASpecUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new ServiceCASpecBuilder(serviceCASpecUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.ServiceCASpecUnsupportedConfigOverridesNested<A> withNewServiceCASpecUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.ServiceCASpecUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.ServiceCASpecUnsupportedConfigOverridesNested<A> withNewServiceCASpecUnsupportedConfigOverridesLike(ServiceCASpec item) {
    return new IngressControllerSpecFluentImpl.ServiceCASpecUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withPrivateStrategyUnsupportedConfigOverrides(PrivateStrategy privateStrategyUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (privateStrategyUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new PrivateStrategyBuilder(privateStrategyUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.PrivateStrategyUnsupportedConfigOverridesNested<A> withNewPrivateStrategyUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.PrivateStrategyUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.PrivateStrategyUnsupportedConfigOverridesNested<A> withNewPrivateStrategyUnsupportedConfigOverridesLike(PrivateStrategy item) {
    return new IngressControllerSpecFluentImpl.PrivateStrategyUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withConsoleStatusUnsupportedConfigOverrides(ConsoleStatus consoleStatusUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (consoleStatusUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new ConsoleStatusBuilder(consoleStatusUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.ConsoleStatusUnsupportedConfigOverridesNested<A> withNewConsoleStatusUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.ConsoleStatusUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.ConsoleStatusUnsupportedConfigOverridesNested<A> withNewConsoleStatusUnsupportedConfigOverridesLike(ConsoleStatus item) {
    return new IngressControllerSpecFluentImpl.ConsoleStatusUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withPodNetworkConnectivityCheckListUnsupportedConfigOverrides(PodNetworkConnectivityCheckList podNetworkConnectivityCheckListUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (podNetworkConnectivityCheckListUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new PodNetworkConnectivityCheckListBuilder(podNetworkConnectivityCheckListUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.PodNetworkConnectivityCheckListUnsupportedConfigOverridesNested<A> withNewPodNetworkConnectivityCheckListUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.PodNetworkConnectivityCheckListUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.PodNetworkConnectivityCheckListUnsupportedConfigOverridesNested<A> withNewPodNetworkConnectivityCheckListUnsupportedConfigOverridesLike(PodNetworkConnectivityCheckList item) {
    return new IngressControllerSpecFluentImpl.PodNetworkConnectivityCheckListUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withObjectReferenceUnsupportedConfigOverrides(ObjectReference objectReferenceUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (objectReferenceUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new ObjectReferenceBuilder(objectReferenceUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.ObjectReferenceUnsupportedConfigOverridesNested<A> withNewObjectReferenceUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.ObjectReferenceUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.ObjectReferenceUnsupportedConfigOverridesNested<A> withNewObjectReferenceUnsupportedConfigOverridesLike(ObjectReference item) {
    return new IngressControllerSpecFluentImpl.ObjectReferenceUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withOpenShiftAPIServerListUnsupportedConfigOverrides(OpenShiftAPIServerList openShiftAPIServerListUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (openShiftAPIServerListUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new OpenShiftAPIServerListBuilder(openShiftAPIServerListUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.OpenShiftAPIServerListUnsupportedConfigOverridesNested<A> withNewOpenShiftAPIServerListUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.OpenShiftAPIServerListUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.OpenShiftAPIServerListUnsupportedConfigOverridesNested<A> withNewOpenShiftAPIServerListUnsupportedConfigOverridesLike(OpenShiftAPIServerList item) {
    return new IngressControllerSpecFluentImpl.OpenShiftAPIServerListUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withServerUnsupportedConfigOverrides(Server serverUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (serverUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new ServerBuilder(serverUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.ServerUnsupportedConfigOverridesNested<A> withNewServerUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.ServerUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.ServerUnsupportedConfigOverridesNested<A> withNewServerUnsupportedConfigOverridesLike(Server item) {
    return new IngressControllerSpecFluentImpl.ServerUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withOAuthAPIServerStatusUnsupportedConfigOverrides(OAuthAPIServerStatus oAuthAPIServerStatusUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (oAuthAPIServerStatusUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new OAuthAPIServerStatusBuilder(oAuthAPIServerStatusUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.OAuthAPIServerStatusUnsupportedConfigOverridesNested<A> withNewOAuthAPIServerStatusUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.OAuthAPIServerStatusUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.OAuthAPIServerStatusUnsupportedConfigOverridesNested<A> withNewOAuthAPIServerStatusUnsupportedConfigOverridesLike(OAuthAPIServerStatus item) {
    return new IngressControllerSpecFluentImpl.OAuthAPIServerStatusUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withNewOAuthAPIServerStatusUnsupportedConfigOverrides(Integer latestAvailableRevision) {
    return (A)withOAuthAPIServerStatusUnsupportedConfigOverrides(new OAuthAPIServerStatus(latestAvailableRevision));
  }
  public A withCloudCredentialSpecUnsupportedConfigOverrides(CloudCredentialSpec cloudCredentialSpecUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (cloudCredentialSpecUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new CloudCredentialSpecBuilder(cloudCredentialSpecUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.CloudCredentialSpecUnsupportedConfigOverridesNested<A> withNewCloudCredentialSpecUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.CloudCredentialSpecUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.CloudCredentialSpecUnsupportedConfigOverridesNested<A> withNewCloudCredentialSpecUnsupportedConfigOverridesLike(CloudCredentialSpec item) {
    return new IngressControllerSpecFluentImpl.CloudCredentialSpecUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withDNSRecordStatusUnsupportedConfigOverrides(DNSRecordStatus dNSRecordStatusUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (dNSRecordStatusUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new DNSRecordStatusBuilder(dNSRecordStatusUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.DNSRecordStatusUnsupportedConfigOverridesNested<A> withNewDNSRecordStatusUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.DNSRecordStatusUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.DNSRecordStatusUnsupportedConfigOverridesNested<A> withNewDNSRecordStatusUnsupportedConfigOverridesLike(DNSRecordStatus item) {
    return new IngressControllerSpecFluentImpl.DNSRecordStatusUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withServiceCatalogControllerManagerUnsupportedConfigOverrides(ServiceCatalogControllerManager serviceCatalogControllerManagerUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (serviceCatalogControllerManagerUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new ServiceCatalogControllerManagerBuilder(serviceCatalogControllerManagerUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.ServiceCatalogControllerManagerUnsupportedConfigOverridesNested<A> withNewServiceCatalogControllerManagerUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.ServiceCatalogControllerManagerUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.ServiceCatalogControllerManagerUnsupportedConfigOverridesNested<A> withNewServiceCatalogControllerManagerUnsupportedConfigOverridesLike(ServiceCatalogControllerManager item) {
    return new IngressControllerSpecFluentImpl.ServiceCatalogControllerManagerUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withClusterNetworkEntryUnsupportedConfigOverrides(ClusterNetworkEntry clusterNetworkEntryUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (clusterNetworkEntryUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new ClusterNetworkEntryBuilder(clusterNetworkEntryUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.ClusterNetworkEntryUnsupportedConfigOverridesNested<A> withNewClusterNetworkEntryUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.ClusterNetworkEntryUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.ClusterNetworkEntryUnsupportedConfigOverridesNested<A> withNewClusterNetworkEntryUnsupportedConfigOverridesLike(ClusterNetworkEntry item) {
    return new IngressControllerSpecFluentImpl.ClusterNetworkEntryUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withNewClusterNetworkEntryUnsupportedConfigOverrides(String cidr,Integer hostPrefix) {
    return (A)withClusterNetworkEntryUnsupportedConfigOverrides(new ClusterNetworkEntry(cidr, hostPrefix));
  }
  public A withIngressControllerCaptureHTTPCookieUnsupportedConfigOverrides(IngressControllerCaptureHTTPCookie ingressControllerCaptureHTTPCookieUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (ingressControllerCaptureHTTPCookieUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new IngressControllerCaptureHTTPCookieBuilder(ingressControllerCaptureHTTPCookieUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.IngressControllerCaptureHTTPCookieUnsupportedConfigOverridesNested<A> withNewIngressControllerCaptureHTTPCookieUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.IngressControllerCaptureHTTPCookieUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.IngressControllerCaptureHTTPCookieUnsupportedConfigOverridesNested<A> withNewIngressControllerCaptureHTTPCookieUnsupportedConfigOverridesLike(IngressControllerCaptureHTTPCookie item) {
    return new IngressControllerSpecFluentImpl.IngressControllerCaptureHTTPCookieUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withNewIngressControllerCaptureHTTPCookieUnsupportedConfigOverrides(String matchType,Integer maxLength,String name,String namePrefix) {
    return (A)withIngressControllerCaptureHTTPCookieUnsupportedConfigOverrides(new IngressControllerCaptureHTTPCookie(matchType, maxLength, name, namePrefix));
  }
  public A withHTTPCompressionPolicyUnsupportedConfigOverrides(HTTPCompressionPolicy hTTPCompressionPolicyUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (hTTPCompressionPolicyUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new HTTPCompressionPolicyBuilder(hTTPCompressionPolicyUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.HTTPCompressionPolicyUnsupportedConfigOverridesNested<A> withNewHTTPCompressionPolicyUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.HTTPCompressionPolicyUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.HTTPCompressionPolicyUnsupportedConfigOverridesNested<A> withNewHTTPCompressionPolicyUnsupportedConfigOverridesLike(HTTPCompressionPolicy item) {
    return new IngressControllerSpecFluentImpl.HTTPCompressionPolicyUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withProjectAccessUnsupportedConfigOverrides(ProjectAccess projectAccessUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (projectAccessUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new ProjectAccessBuilder(projectAccessUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.ProjectAccessUnsupportedConfigOverridesNested<A> withNewProjectAccessUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.ProjectAccessUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.ProjectAccessUnsupportedConfigOverridesNested<A> withNewProjectAccessUnsupportedConfigOverridesLike(ProjectAccess item) {
    return new IngressControllerSpecFluentImpl.ProjectAccessUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withDNSUnsupportedConfigOverrides(DNS dNSUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (dNSUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new DNSBuilder(dNSUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.DNSUnsupportedConfigOverridesNested<A> withNewDNSUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.DNSUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.DNSUnsupportedConfigOverridesNested<A> withNewDNSUnsupportedConfigOverridesLike(DNS item) {
    return new IngressControllerSpecFluentImpl.DNSUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withNetFlowConfigUnsupportedOverrides(NetFlowConfig netFlowConfigUnsupportedOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (netFlowConfigUnsupportedOverrides!=null){ this.unsupportedConfigOverrides= new NetFlowConfigBuilder(netFlowConfigUnsupportedOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.NetFlowConfigUnsupportedOverridesNested<A> withNewNetFlowConfigUnsupportedOverrides() {
    return new IngressControllerSpecFluentImpl.NetFlowConfigUnsupportedOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.NetFlowConfigUnsupportedOverridesNested<A> withNewNetFlowConfigUnsupportedOverridesLike(NetFlowConfig item) {
    return new IngressControllerSpecFluentImpl.NetFlowConfigUnsupportedOverridesNestedImpl(item);
  }
  public A withPolicyAuditConfigUnsupportedOverrides(PolicyAuditConfig policyAuditConfigUnsupportedOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (policyAuditConfigUnsupportedOverrides!=null){ this.unsupportedConfigOverrides= new PolicyAuditConfigBuilder(policyAuditConfigUnsupportedOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.PolicyAuditConfigUnsupportedOverridesNested<A> withNewPolicyAuditConfigUnsupportedOverrides() {
    return new IngressControllerSpecFluentImpl.PolicyAuditConfigUnsupportedOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.PolicyAuditConfigUnsupportedOverridesNested<A> withNewPolicyAuditConfigUnsupportedOverridesLike(PolicyAuditConfig item) {
    return new IngressControllerSpecFluentImpl.PolicyAuditConfigUnsupportedOverridesNestedImpl(item);
  }
  public A withNewPolicyAuditConfigUnsupportedOverrides(String destination,Integer maxFileSize,Integer rateLimit,String syslogFacility) {
    return (A)withPolicyAuditConfigUnsupportedOverrides(new PolicyAuditConfig(destination, maxFileSize, rateLimit, syslogFacility));
  }
  public A withAddPageUnsupportedConfigOverrides(AddPage addPageUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (addPageUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new AddPageBuilder(addPageUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.AddPageUnsupportedConfigOverridesNested<A> withNewAddPageUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.AddPageUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.AddPageUnsupportedConfigOverridesNested<A> withNewAddPageUnsupportedConfigOverridesLike(AddPage item) {
    return new IngressControllerSpecFluentImpl.AddPageUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withStorageListUnsupportedConfigOverrides(StorageList storageListUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (storageListUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new StorageListBuilder(storageListUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.StorageListUnsupportedConfigOverridesNested<A> withNewStorageListUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.StorageListUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.StorageListUnsupportedConfigOverridesNested<A> withNewStorageListUnsupportedConfigOverridesLike(StorageList item) {
    return new IngressControllerSpecFluentImpl.StorageListUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withStaticIPAMAddressesUnsupportedConfigOverrides(StaticIPAMAddresses staticIPAMAddressesUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (staticIPAMAddressesUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new StaticIPAMAddressesBuilder(staticIPAMAddressesUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.StaticIPAMAddressesUnsupportedConfigOverridesNested<A> withNewStaticIPAMAddressesUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.StaticIPAMAddressesUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.StaticIPAMAddressesUnsupportedConfigOverridesNested<A> withNewStaticIPAMAddressesUnsupportedConfigOverridesLike(StaticIPAMAddresses item) {
    return new IngressControllerSpecFluentImpl.StaticIPAMAddressesUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withNewStaticIPAMAddressesUnsupportedConfigOverrides(String address,String gateway) {
    return (A)withStaticIPAMAddressesUnsupportedConfigOverrides(new StaticIPAMAddresses(address, gateway));
  }
  public A withDNSRecordUnsupportedConfigOverrides(DNSRecord dNSRecordUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (dNSRecordUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new DNSRecordBuilder(dNSRecordUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.DNSRecordUnsupportedConfigOverridesNested<A> withNewDNSRecordUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.DNSRecordUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.DNSRecordUnsupportedConfigOverridesNested<A> withNewDNSRecordUnsupportedConfigOverridesLike(DNSRecord item) {
    return new IngressControllerSpecFluentImpl.DNSRecordUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withOpenShiftAPIServerUnsupportedConfigOverrides(OpenShiftAPIServer openShiftAPIServerUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (openShiftAPIServerUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new OpenShiftAPIServerBuilder(openShiftAPIServerUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.OpenShiftAPIServerUnsupportedConfigOverridesNested<A> withNewOpenShiftAPIServerUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.OpenShiftAPIServerUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.OpenShiftAPIServerUnsupportedConfigOverridesNested<A> withNewOpenShiftAPIServerUnsupportedConfigOverridesLike(OpenShiftAPIServer item) {
    return new IngressControllerSpecFluentImpl.OpenShiftAPIServerUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withAuthenticationUnsupportedConfigOverrides(Authentication authenticationUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (authenticationUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new AuthenticationBuilder(authenticationUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.AuthenticationUnsupportedConfigOverridesNested<A> withNewAuthenticationUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.AuthenticationUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.AuthenticationUnsupportedConfigOverridesNested<A> withNewAuthenticationUnsupportedConfigOverridesLike(Authentication item) {
    return new IngressControllerSpecFluentImpl.AuthenticationUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withConsoleSpecUnsupportedConfigOverrides(ConsoleSpec consoleSpecUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (consoleSpecUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new ConsoleSpecBuilder(consoleSpecUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.ConsoleSpecUnsupportedConfigOverridesNested<A> withNewConsoleSpecUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.ConsoleSpecUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.ConsoleSpecUnsupportedConfigOverridesNested<A> withNewConsoleSpecUnsupportedConfigOverridesLike(ConsoleSpec item) {
    return new IngressControllerSpecFluentImpl.ConsoleSpecUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withServiceCAStatusUnsupportedConfigOverrides(ServiceCAStatus serviceCAStatusUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (serviceCAStatusUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new ServiceCAStatusBuilder(serviceCAStatusUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public IngressControllerSpecFluent.ServiceCAStatusUnsupportedConfigOverridesNested<A> withNewServiceCAStatusUnsupportedConfigOverrides() {
    return new IngressControllerSpecFluentImpl.ServiceCAStatusUnsupportedConfigOverridesNestedImpl();
  }
  public IngressControllerSpecFluent.ServiceCAStatusUnsupportedConfigOverridesNested<A> withNewServiceCAStatusUnsupportedConfigOverridesLike(ServiceCAStatus item) {
    return new IngressControllerSpecFluentImpl.ServiceCAStatusUnsupportedConfigOverridesNestedImpl(item);
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    IngressControllerSpecFluentImpl that = (IngressControllerSpecFluentImpl) o;
    if (clientTLS != null ? !clientTLS.equals(that.clientTLS) :that.clientTLS != null) return false;
    if (defaultCertificate != null ? !defaultCertificate.equals(that.defaultCertificate) :that.defaultCertificate != null) return false;
    if (domain != null ? !domain.equals(that.domain) :that.domain != null) return false;
    if (endpointPublishingStrategy != null ? !endpointPublishingStrategy.equals(that.endpointPublishingStrategy) :that.endpointPublishingStrategy != null) return false;
    if (httpCompression != null ? !httpCompression.equals(that.httpCompression) :that.httpCompression != null) return false;
    if (httpEmptyRequestsPolicy != null ? !httpEmptyRequestsPolicy.equals(that.httpEmptyRequestsPolicy) :that.httpEmptyRequestsPolicy != null) return false;
    if (httpErrorCodePages != null ? !httpErrorCodePages.equals(that.httpErrorCodePages) :that.httpErrorCodePages != null) return false;
    if (httpHeaders != null ? !httpHeaders.equals(that.httpHeaders) :that.httpHeaders != null) return false;
    if (logging != null ? !logging.equals(that.logging) :that.logging != null) return false;
    if (namespaceSelector != null ? !namespaceSelector.equals(that.namespaceSelector) :that.namespaceSelector != null) return false;
    if (nodePlacement != null ? !nodePlacement.equals(that.nodePlacement) :that.nodePlacement != null) return false;
    if (replicas != null ? !replicas.equals(that.replicas) :that.replicas != null) return false;
    if (routeAdmission != null ? !routeAdmission.equals(that.routeAdmission) :that.routeAdmission != null) return false;
    if (routeSelector != null ? !routeSelector.equals(that.routeSelector) :that.routeSelector != null) return false;
    if (tlsSecurityProfile != null ? !tlsSecurityProfile.equals(that.tlsSecurityProfile) :that.tlsSecurityProfile != null) return false;
    if (tuningOptions != null ? !tuningOptions.equals(that.tuningOptions) :that.tuningOptions != null) return false;
    if (unsupportedConfigOverrides != null ? !unsupportedConfigOverrides.equals(that.unsupportedConfigOverrides) :that.unsupportedConfigOverrides != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(clientTLS,  defaultCertificate,  domain,  endpointPublishingStrategy,  httpCompression,  httpEmptyRequestsPolicy,  httpErrorCodePages,  httpHeaders,  logging,  namespaceSelector,  nodePlacement,  replicas,  routeAdmission,  routeSelector,  tlsSecurityProfile,  tuningOptions,  unsupportedConfigOverrides,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (clientTLS != null) { sb.append("clientTLS:"); sb.append(clientTLS + ","); }
    if (defaultCertificate != null) { sb.append("defaultCertificate:"); sb.append(defaultCertificate + ","); }
    if (domain != null) { sb.append("domain:"); sb.append(domain + ","); }
    if (endpointPublishingStrategy != null) { sb.append("endpointPublishingStrategy:"); sb.append(endpointPublishingStrategy + ","); }
    if (httpCompression != null) { sb.append("httpCompression:"); sb.append(httpCompression + ","); }
    if (httpEmptyRequestsPolicy != null) { sb.append("httpEmptyRequestsPolicy:"); sb.append(httpEmptyRequestsPolicy + ","); }
    if (httpErrorCodePages != null) { sb.append("httpErrorCodePages:"); sb.append(httpErrorCodePages + ","); }
    if (httpHeaders != null) { sb.append("httpHeaders:"); sb.append(httpHeaders + ","); }
    if (logging != null) { sb.append("logging:"); sb.append(logging + ","); }
    if (namespaceSelector != null) { sb.append("namespaceSelector:"); sb.append(namespaceSelector + ","); }
    if (nodePlacement != null) { sb.append("nodePlacement:"); sb.append(nodePlacement + ","); }
    if (replicas != null) { sb.append("replicas:"); sb.append(replicas + ","); }
    if (routeAdmission != null) { sb.append("routeAdmission:"); sb.append(routeAdmission + ","); }
    if (routeSelector != null) { sb.append("routeSelector:"); sb.append(routeSelector + ","); }
    if (tlsSecurityProfile != null) { sb.append("tlsSecurityProfile:"); sb.append(tlsSecurityProfile + ","); }
    if (tuningOptions != null) { sb.append("tuningOptions:"); sb.append(tuningOptions + ","); }
    if (unsupportedConfigOverrides != null) { sb.append("unsupportedConfigOverrides:"); sb.append(unsupportedConfigOverrides + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class ClientTLSNestedImpl<N> extends ClientTLSFluentImpl<IngressControllerSpecFluent.ClientTLSNested<N>> implements IngressControllerSpecFluent.ClientTLSNested<N>,Nested<N>{
    ClientTLSNestedImpl(ClientTLS item) {
      this.builder = new ClientTLSBuilder(this, item);
    }
    ClientTLSNestedImpl() {
      this.builder = new ClientTLSBuilder(this);
    }
    ClientTLSBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withClientTLS(builder.build());
    }
    public N endClientTLS() {
      return and();
    }
    
  }
  class DefaultCertificateNestedImpl<N> extends LocalObjectReferenceFluentImpl<IngressControllerSpecFluent.DefaultCertificateNested<N>> implements IngressControllerSpecFluent.DefaultCertificateNested<N>,Nested<N>{
    DefaultCertificateNestedImpl(LocalObjectReference item) {
      this.builder = new LocalObjectReferenceBuilder(this, item);
    }
    DefaultCertificateNestedImpl() {
      this.builder = new LocalObjectReferenceBuilder(this);
    }
    LocalObjectReferenceBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withDefaultCertificate(builder.build());
    }
    public N endDefaultCertificate() {
      return and();
    }
    
  }
  class EndpointPublishingStrategyNestedImpl<N> extends EndpointPublishingStrategyFluentImpl<IngressControllerSpecFluent.EndpointPublishingStrategyNested<N>> implements IngressControllerSpecFluent.EndpointPublishingStrategyNested<N>,Nested<N>{
    EndpointPublishingStrategyNestedImpl(EndpointPublishingStrategy item) {
      this.builder = new EndpointPublishingStrategyBuilder(this, item);
    }
    EndpointPublishingStrategyNestedImpl() {
      this.builder = new EndpointPublishingStrategyBuilder(this);
    }
    EndpointPublishingStrategyBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withEndpointPublishingStrategy(builder.build());
    }
    public N endEndpointPublishingStrategy() {
      return and();
    }
    
  }
  class HttpCompressionNestedImpl<N> extends HTTPCompressionPolicyFluentImpl<IngressControllerSpecFluent.HttpCompressionNested<N>> implements IngressControllerSpecFluent.HttpCompressionNested<N>,Nested<N>{
    HttpCompressionNestedImpl(HTTPCompressionPolicy item) {
      this.builder = new HTTPCompressionPolicyBuilder(this, item);
    }
    HttpCompressionNestedImpl() {
      this.builder = new HTTPCompressionPolicyBuilder(this);
    }
    HTTPCompressionPolicyBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withHttpCompression(builder.build());
    }
    public N endHttpCompression() {
      return and();
    }
    
  }
  class HttpHeadersNestedImpl<N> extends IngressControllerHTTPHeadersFluentImpl<IngressControllerSpecFluent.HttpHeadersNested<N>> implements IngressControllerSpecFluent.HttpHeadersNested<N>,Nested<N>{
    HttpHeadersNestedImpl(IngressControllerHTTPHeaders item) {
      this.builder = new IngressControllerHTTPHeadersBuilder(this, item);
    }
    HttpHeadersNestedImpl() {
      this.builder = new IngressControllerHTTPHeadersBuilder(this);
    }
    IngressControllerHTTPHeadersBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withHttpHeaders(builder.build());
    }
    public N endHttpHeaders() {
      return and();
    }
    
  }
  class LoggingNestedImpl<N> extends IngressControllerLoggingFluentImpl<IngressControllerSpecFluent.LoggingNested<N>> implements IngressControllerSpecFluent.LoggingNested<N>,Nested<N>{
    LoggingNestedImpl(IngressControllerLogging item) {
      this.builder = new IngressControllerLoggingBuilder(this, item);
    }
    LoggingNestedImpl() {
      this.builder = new IngressControllerLoggingBuilder(this);
    }
    IngressControllerLoggingBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withLogging(builder.build());
    }
    public N endLogging() {
      return and();
    }
    
  }
  class NamespaceSelectorNestedImpl<N> extends LabelSelectorFluentImpl<IngressControllerSpecFluent.NamespaceSelectorNested<N>> implements IngressControllerSpecFluent.NamespaceSelectorNested<N>,Nested<N>{
    NamespaceSelectorNestedImpl(LabelSelector item) {
      this.builder = new LabelSelectorBuilder(this, item);
    }
    NamespaceSelectorNestedImpl() {
      this.builder = new LabelSelectorBuilder(this);
    }
    LabelSelectorBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withNamespaceSelector(builder.build());
    }
    public N endNamespaceSelector() {
      return and();
    }
    
  }
  class NodePlacementNestedImpl<N> extends NodePlacementFluentImpl<IngressControllerSpecFluent.NodePlacementNested<N>> implements IngressControllerSpecFluent.NodePlacementNested<N>,Nested<N>{
    NodePlacementNestedImpl(NodePlacement item) {
      this.builder = new NodePlacementBuilder(this, item);
    }
    NodePlacementNestedImpl() {
      this.builder = new NodePlacementBuilder(this);
    }
    NodePlacementBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withNodePlacement(builder.build());
    }
    public N endNodePlacement() {
      return and();
    }
    
  }
  class RouteAdmissionNestedImpl<N> extends RouteAdmissionPolicyFluentImpl<IngressControllerSpecFluent.RouteAdmissionNested<N>> implements IngressControllerSpecFluent.RouteAdmissionNested<N>,Nested<N>{
    RouteAdmissionNestedImpl(RouteAdmissionPolicy item) {
      this.builder = new RouteAdmissionPolicyBuilder(this, item);
    }
    RouteAdmissionNestedImpl() {
      this.builder = new RouteAdmissionPolicyBuilder(this);
    }
    RouteAdmissionPolicyBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withRouteAdmission(builder.build());
    }
    public N endRouteAdmission() {
      return and();
    }
    
  }
  class RouteSelectorNestedImpl<N> extends LabelSelectorFluentImpl<IngressControllerSpecFluent.RouteSelectorNested<N>> implements IngressControllerSpecFluent.RouteSelectorNested<N>,Nested<N>{
    RouteSelectorNestedImpl(LabelSelector item) {
      this.builder = new LabelSelectorBuilder(this, item);
    }
    RouteSelectorNestedImpl() {
      this.builder = new LabelSelectorBuilder(this);
    }
    LabelSelectorBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withRouteSelector(builder.build());
    }
    public N endRouteSelector() {
      return and();
    }
    
  }
  class TuningOptionsNestedImpl<N> extends IngressControllerTuningOptionsFluentImpl<IngressControllerSpecFluent.TuningOptionsNested<N>> implements IngressControllerSpecFluent.TuningOptionsNested<N>,Nested<N>{
    TuningOptionsNestedImpl(IngressControllerTuningOptions item) {
      this.builder = new IngressControllerTuningOptionsBuilder(this, item);
    }
    TuningOptionsNestedImpl() {
      this.builder = new IngressControllerTuningOptionsBuilder(this);
    }
    IngressControllerTuningOptionsBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withTuningOptions(builder.build());
    }
    public N endTuningOptions() {
      return and();
    }
    
  }
  class ServiceCatalogAPIServerListUnsupportedConfigOverridesNestedImpl<N> extends ServiceCatalogAPIServerListFluentImpl<IngressControllerSpecFluent.ServiceCatalogAPIServerListUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.ServiceCatalogAPIServerListUnsupportedConfigOverridesNested<N>,Nested<N>{
    ServiceCatalogAPIServerListUnsupportedConfigOverridesNestedImpl(ServiceCatalogAPIServerList item) {
      this.builder = new ServiceCatalogAPIServerListBuilder(this, item);
    }
    ServiceCatalogAPIServerListUnsupportedConfigOverridesNestedImpl() {
      this.builder = new ServiceCatalogAPIServerListBuilder(this);
    }
    ServiceCatalogAPIServerListBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endServiceCatalogAPIServerListUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class LabelSelectorUnsupportedConfigOverridesNestedImpl<N> extends LabelSelectorFluentImpl<IngressControllerSpecFluent.LabelSelectorUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.LabelSelectorUnsupportedConfigOverridesNested<N>,Nested<N>{
    LabelSelectorUnsupportedConfigOverridesNestedImpl(LabelSelector item) {
      this.builder = new LabelSelectorBuilder(this, item);
    }
    LabelSelectorUnsupportedConfigOverridesNestedImpl() {
      this.builder = new LabelSelectorBuilder(this);
    }
    LabelSelectorBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endLabelSelectorUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class ImagePrunerUnsupportedConfigOverridesNestedImpl<N> extends ImagePrunerFluentImpl<IngressControllerSpecFluent.ImagePrunerUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.ImagePrunerUnsupportedConfigOverridesNested<N>,Nested<N>{
    ImagePrunerUnsupportedConfigOverridesNestedImpl(ImagePruner item) {
      this.builder = new ImagePrunerBuilder(this, item);
    }
    ImagePrunerUnsupportedConfigOverridesNestedImpl() {
      this.builder = new ImagePrunerBuilder(this);
    }
    ImagePrunerBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endImagePrunerUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class KubeControllerManagerUnsupportedConfigOverridesNestedImpl<N> extends KubeControllerManagerFluentImpl<IngressControllerSpecFluent.KubeControllerManagerUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.KubeControllerManagerUnsupportedConfigOverridesNested<N>,Nested<N>{
    KubeControllerManagerUnsupportedConfigOverridesNestedImpl(KubeControllerManager item) {
      this.builder = new KubeControllerManagerBuilder(this, item);
    }
    KubeControllerManagerUnsupportedConfigOverridesNestedImpl() {
      this.builder = new KubeControllerManagerBuilder(this);
    }
    KubeControllerManagerBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endKubeControllerManagerUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class PodNetworkConnectivityCheckStatusUnsupportedConfigOverridesNestedImpl<N> extends PodNetworkConnectivityCheckStatusFluentImpl<IngressControllerSpecFluent.PodNetworkConnectivityCheckStatusUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.PodNetworkConnectivityCheckStatusUnsupportedConfigOverridesNested<N>,Nested<N>{
    PodNetworkConnectivityCheckStatusUnsupportedConfigOverridesNestedImpl(PodNetworkConnectivityCheckStatus item) {
      this.builder = new PodNetworkConnectivityCheckStatusBuilder(this, item);
    }
    PodNetworkConnectivityCheckStatusUnsupportedConfigOverridesNestedImpl() {
      this.builder = new PodNetworkConnectivityCheckStatusBuilder(this);
    }
    PodNetworkConnectivityCheckStatusBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endPodNetworkConnectivityCheckStatusUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class KubeStorageVersionMigratorListUnsupportedConfigOverridesNestedImpl<N> extends KubeStorageVersionMigratorListFluentImpl<IngressControllerSpecFluent.KubeStorageVersionMigratorListUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.KubeStorageVersionMigratorListUnsupportedConfigOverridesNested<N>,Nested<N>{
    KubeStorageVersionMigratorListUnsupportedConfigOverridesNestedImpl(KubeStorageVersionMigratorList item) {
      this.builder = new KubeStorageVersionMigratorListBuilder(this, item);
    }
    KubeStorageVersionMigratorListUnsupportedConfigOverridesNestedImpl() {
      this.builder = new KubeStorageVersionMigratorListBuilder(this);
    }
    KubeStorageVersionMigratorListBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endKubeStorageVersionMigratorListUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class StorageUnsupportedConfigOverridesNestedImpl<N> extends StorageFluentImpl<IngressControllerSpecFluent.StorageUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.StorageUnsupportedConfigOverridesNested<N>,Nested<N>{
    StorageUnsupportedConfigOverridesNestedImpl(Storage item) {
      this.builder = new StorageBuilder(this, item);
    }
    StorageUnsupportedConfigOverridesNestedImpl() {
      this.builder = new StorageBuilder(this);
    }
    StorageBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endStorageUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class PodTemplateSpecUnsupportedConfigOverridesNestedImpl<N> extends PodTemplateSpecFluentImpl<IngressControllerSpecFluent.PodTemplateSpecUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.PodTemplateSpecUnsupportedConfigOverridesNested<N>,Nested<N>{
    PodTemplateSpecUnsupportedConfigOverridesNestedImpl(PodTemplateSpec item) {
      this.builder = new PodTemplateSpecBuilder(this, item);
    }
    PodTemplateSpecUnsupportedConfigOverridesNestedImpl() {
      this.builder = new PodTemplateSpecBuilder(this);
    }
    PodTemplateSpecBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endPodTemplateSpecUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class KubeControllerManagerStatusUnsupportedConfigOverridesNestedImpl<N> extends KubeControllerManagerStatusFluentImpl<IngressControllerSpecFluent.KubeControllerManagerStatusUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.KubeControllerManagerStatusUnsupportedConfigOverridesNested<N>,Nested<N>{
    KubeControllerManagerStatusUnsupportedConfigOverridesNestedImpl(KubeControllerManagerStatus item) {
      this.builder = new KubeControllerManagerStatusBuilder(this, item);
    }
    KubeControllerManagerStatusUnsupportedConfigOverridesNestedImpl() {
      this.builder = new KubeControllerManagerStatusBuilder(this);
    }
    KubeControllerManagerStatusBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endKubeControllerManagerStatusUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class ServiceCatalogControllerManagerListUnsupportedConfigOverridesNestedImpl<N> extends ServiceCatalogControllerManagerListFluentImpl<IngressControllerSpecFluent.ServiceCatalogControllerManagerListUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.ServiceCatalogControllerManagerListUnsupportedConfigOverridesNested<N>,Nested<N>{
    ServiceCatalogControllerManagerListUnsupportedConfigOverridesNestedImpl(ServiceCatalogControllerManagerList item) {
      this.builder = new ServiceCatalogControllerManagerListBuilder(this, item);
    }
    ServiceCatalogControllerManagerListUnsupportedConfigOverridesNestedImpl() {
      this.builder = new ServiceCatalogControllerManagerListBuilder(this);
    }
    ServiceCatalogControllerManagerListBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endServiceCatalogControllerManagerListUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class CSISnapshotControllerStatusUnsupportedConfigOverridesNestedImpl<N> extends CSISnapshotControllerStatusFluentImpl<IngressControllerSpecFluent.CSISnapshotControllerStatusUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.CSISnapshotControllerStatusUnsupportedConfigOverridesNested<N>,Nested<N>{
    CSISnapshotControllerStatusUnsupportedConfigOverridesNestedImpl(CSISnapshotControllerStatus item) {
      this.builder = new CSISnapshotControllerStatusBuilder(this, item);
    }
    CSISnapshotControllerStatusUnsupportedConfigOverridesNestedImpl() {
      this.builder = new CSISnapshotControllerStatusBuilder(this);
    }
    CSISnapshotControllerStatusBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endCSISnapshotControllerStatusUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class IPsecConfigUnsupportedOverridesNestedImpl<N> extends IPsecConfigFluentImpl<IngressControllerSpecFluent.IPsecConfigUnsupportedOverridesNested<N>> implements IngressControllerSpecFluent.IPsecConfigUnsupportedOverridesNested<N>,Nested<N>{
    IPsecConfigUnsupportedOverridesNestedImpl(IPsecConfig item) {
      this.builder = new IPsecConfigBuilder(this, item);
    }
    IPsecConfigUnsupportedOverridesNestedImpl() {
      this.builder = new IPsecConfigBuilder(this);
    }
    IPsecConfigBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endIPsecConfigUnsupportedOverrides() {
      return and();
    }
    
  }
  class ImageContentSourcePolicyUnsupportedConfigOverridesNestedImpl<N> extends ImageContentSourcePolicyFluentImpl<IngressControllerSpecFluent.ImageContentSourcePolicyUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.ImageContentSourcePolicyUnsupportedConfigOverridesNested<N>,Nested<N>{
    ImageContentSourcePolicyUnsupportedConfigOverridesNestedImpl(ImageContentSourcePolicy item) {
      this.builder = new ImageContentSourcePolicyBuilder(this, item);
    }
    ImageContentSourcePolicyUnsupportedConfigOverridesNestedImpl() {
      this.builder = new ImageContentSourcePolicyBuilder(this);
    }
    ImageContentSourcePolicyBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endImageContentSourcePolicyUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class ResourceRequirementsUnsupportedConfigOverridesNestedImpl<N> extends ResourceRequirementsFluentImpl<IngressControllerSpecFluent.ResourceRequirementsUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.ResourceRequirementsUnsupportedConfigOverridesNested<N>,Nested<N>{
    ResourceRequirementsUnsupportedConfigOverridesNestedImpl(ResourceRequirements item) {
      this.builder = new ResourceRequirementsBuilder(this, item);
    }
    ResourceRequirementsUnsupportedConfigOverridesNestedImpl() {
      this.builder = new ResourceRequirementsBuilder(this);
    }
    ResourceRequirementsBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endResourceRequirementsUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class OVNKubernetesConfigUnsupportedOverridesNestedImpl<N> extends OVNKubernetesConfigFluentImpl<IngressControllerSpecFluent.OVNKubernetesConfigUnsupportedOverridesNested<N>> implements IngressControllerSpecFluent.OVNKubernetesConfigUnsupportedOverridesNested<N>,Nested<N>{
    OVNKubernetesConfigUnsupportedOverridesNestedImpl(OVNKubernetesConfig item) {
      this.builder = new OVNKubernetesConfigBuilder(this, item);
    }
    OVNKubernetesConfigUnsupportedOverridesNestedImpl() {
      this.builder = new OVNKubernetesConfigBuilder(this);
    }
    OVNKubernetesConfigBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endOVNKubernetesConfigUnsupportedOverrides() {
      return and();
    }
    
  }
  class DeveloperConsoleCatalogCategoryMetaUnsupportedConfigOverridesNestedImpl<N> extends DeveloperConsoleCatalogCategoryMetaFluentImpl<IngressControllerSpecFluent.DeveloperConsoleCatalogCategoryMetaUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.DeveloperConsoleCatalogCategoryMetaUnsupportedConfigOverridesNested<N>,Nested<N>{
    DeveloperConsoleCatalogCategoryMetaUnsupportedConfigOverridesNestedImpl(DeveloperConsoleCatalogCategoryMeta item) {
      this.builder = new DeveloperConsoleCatalogCategoryMetaBuilder(this, item);
    }
    DeveloperConsoleCatalogCategoryMetaUnsupportedConfigOverridesNestedImpl() {
      this.builder = new DeveloperConsoleCatalogCategoryMetaBuilder(this);
    }
    DeveloperConsoleCatalogCategoryMetaBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endDeveloperConsoleCatalogCategoryMetaUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class KubeStorageVersionMigratorSpecUnsupportedConfigOverridesNestedImpl<N> extends KubeStorageVersionMigratorSpecFluentImpl<IngressControllerSpecFluent.KubeStorageVersionMigratorSpecUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.KubeStorageVersionMigratorSpecUnsupportedConfigOverridesNested<N>,Nested<N>{
    KubeStorageVersionMigratorSpecUnsupportedConfigOverridesNestedImpl(KubeStorageVersionMigratorSpec item) {
      this.builder = new KubeStorageVersionMigratorSpecBuilder(this, item);
    }
    KubeStorageVersionMigratorSpecUnsupportedConfigOverridesNestedImpl() {
      this.builder = new KubeStorageVersionMigratorSpecBuilder(this);
    }
    KubeStorageVersionMigratorSpecBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endKubeStorageVersionMigratorSpecUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class IngressControllerSpecUnsupportedConfigOverridesNestedImpl<N> extends IngressControllerSpecFluentImpl<IngressControllerSpecFluent.IngressControllerSpecUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.IngressControllerSpecUnsupportedConfigOverridesNested<N>,Nested<N>{
    IngressControllerSpecUnsupportedConfigOverridesNestedImpl(IngressControllerSpec item) {
      this.builder = new IngressControllerSpecBuilder(this, item);
    }
    IngressControllerSpecUnsupportedConfigOverridesNestedImpl() {
      this.builder = new IngressControllerSpecBuilder(this);
    }
    IngressControllerSpecBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endIngressControllerSpecUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class DNSSpecUnsupportedConfigOverridesNestedImpl<N> extends DNSSpecFluentImpl<IngressControllerSpecFluent.DNSSpecUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.DNSSpecUnsupportedConfigOverridesNested<N>,Nested<N>{
    DNSSpecUnsupportedConfigOverridesNestedImpl(DNSSpec item) {
      this.builder = new DNSSpecBuilder(this, item);
    }
    DNSSpecUnsupportedConfigOverridesNestedImpl() {
      this.builder = new DNSSpecBuilder(this);
    }
    DNSSpecBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endDNSSpecUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class OpenShiftSDNConfigUnsupportedOverridesNestedImpl<N> extends OpenShiftSDNConfigFluentImpl<IngressControllerSpecFluent.OpenShiftSDNConfigUnsupportedOverridesNested<N>> implements IngressControllerSpecFluent.OpenShiftSDNConfigUnsupportedOverridesNested<N>,Nested<N>{
    OpenShiftSDNConfigUnsupportedOverridesNestedImpl(OpenShiftSDNConfig item) {
      this.builder = new OpenShiftSDNConfigBuilder(this, item);
    }
    OpenShiftSDNConfigUnsupportedOverridesNestedImpl() {
      this.builder = new OpenShiftSDNConfigBuilder(this);
    }
    OpenShiftSDNConfigBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endOpenShiftSDNConfigUnsupportedOverrides() {
      return and();
    }
    
  }
  class OperatorConditionUnsupportedConfigOverridesNestedImpl<N> extends OperatorConditionFluentImpl<IngressControllerSpecFluent.OperatorConditionUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.OperatorConditionUnsupportedConfigOverridesNested<N>,Nested<N>{
    OperatorConditionUnsupportedConfigOverridesNestedImpl(OperatorCondition item) {
      this.builder = new OperatorConditionBuilder(this, item);
    }
    OperatorConditionUnsupportedConfigOverridesNestedImpl() {
      this.builder = new OperatorConditionBuilder(this);
    }
    OperatorConditionBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endOperatorConditionUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class IngressControllerHTTPHeadersUnsupportedConfigOverridesNestedImpl<N> extends IngressControllerHTTPHeadersFluentImpl<IngressControllerSpecFluent.IngressControllerHTTPHeadersUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.IngressControllerHTTPHeadersUnsupportedConfigOverridesNested<N>,Nested<N>{
    IngressControllerHTTPHeadersUnsupportedConfigOverridesNestedImpl(IngressControllerHTTPHeaders item) {
      this.builder = new IngressControllerHTTPHeadersBuilder(this, item);
    }
    IngressControllerHTTPHeadersUnsupportedConfigOverridesNestedImpl() {
      this.builder = new IngressControllerHTTPHeadersBuilder(this);
    }
    IngressControllerHTTPHeadersBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endIngressControllerHTTPHeadersUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class ProxyConfigUnsupportedOverridesNestedImpl<N> extends ProxyConfigFluentImpl<IngressControllerSpecFluent.ProxyConfigUnsupportedOverridesNested<N>> implements IngressControllerSpecFluent.ProxyConfigUnsupportedOverridesNested<N>,Nested<N>{
    ProxyConfigUnsupportedOverridesNestedImpl(ProxyConfig item) {
      this.builder = new ProxyConfigBuilder(this, item);
    }
    ProxyConfigUnsupportedOverridesNestedImpl() {
      this.builder = new ProxyConfigBuilder(this);
    }
    ProxyConfigBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endProxyConfigUnsupportedOverrides() {
      return and();
    }
    
  }
  class ConsoleListUnsupportedConfigOverridesNestedImpl<N> extends ConsoleListFluentImpl<IngressControllerSpecFluent.ConsoleListUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.ConsoleListUnsupportedConfigOverridesNested<N>,Nested<N>{
    ConsoleListUnsupportedConfigOverridesNestedImpl(ConsoleList item) {
      this.builder = new ConsoleListBuilder(this, item);
    }
    ConsoleListUnsupportedConfigOverridesNestedImpl() {
      this.builder = new ConsoleListBuilder(this);
    }
    ConsoleListBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endConsoleListUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class KuryrConfigUnsupportedOverridesNestedImpl<N> extends KuryrConfigFluentImpl<IngressControllerSpecFluent.KuryrConfigUnsupportedOverridesNested<N>> implements IngressControllerSpecFluent.KuryrConfigUnsupportedOverridesNested<N>,Nested<N>{
    KuryrConfigUnsupportedOverridesNestedImpl(KuryrConfig item) {
      this.builder = new KuryrConfigBuilder(this, item);
    }
    KuryrConfigUnsupportedOverridesNestedImpl() {
      this.builder = new KuryrConfigBuilder(this);
    }
    KuryrConfigBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endKuryrConfigUnsupportedOverrides() {
      return and();
    }
    
  }
  class DeveloperConsoleCatalogCategoryUnsupportedConfigOverridesNestedImpl<N> extends DeveloperConsoleCatalogCategoryFluentImpl<IngressControllerSpecFluent.DeveloperConsoleCatalogCategoryUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.DeveloperConsoleCatalogCategoryUnsupportedConfigOverridesNested<N>,Nested<N>{
    DeveloperConsoleCatalogCategoryUnsupportedConfigOverridesNestedImpl(DeveloperConsoleCatalogCategory item) {
      this.builder = new DeveloperConsoleCatalogCategoryBuilder(this, item);
    }
    DeveloperConsoleCatalogCategoryUnsupportedConfigOverridesNestedImpl() {
      this.builder = new DeveloperConsoleCatalogCategoryBuilder(this);
    }
    DeveloperConsoleCatalogCategoryBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endDeveloperConsoleCatalogCategoryUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class OpenShiftControllerManagerSpecUnsupportedConfigOverridesNestedImpl<N> extends OpenShiftControllerManagerSpecFluentImpl<IngressControllerSpecFluent.OpenShiftControllerManagerSpecUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.OpenShiftControllerManagerSpecUnsupportedConfigOverridesNested<N>,Nested<N>{
    OpenShiftControllerManagerSpecUnsupportedConfigOverridesNestedImpl(OpenShiftControllerManagerSpec item) {
      this.builder = new OpenShiftControllerManagerSpecBuilder(this, item);
    }
    OpenShiftControllerManagerSpecUnsupportedConfigOverridesNestedImpl() {
      this.builder = new OpenShiftControllerManagerSpecBuilder(this);
    }
    OpenShiftControllerManagerSpecBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endOpenShiftControllerManagerSpecUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class ExportNetworkFlowsUnsupportedConfigOverridesNestedImpl<N> extends ExportNetworkFlowsFluentImpl<IngressControllerSpecFluent.ExportNetworkFlowsUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.ExportNetworkFlowsUnsupportedConfigOverridesNested<N>,Nested<N>{
    ExportNetworkFlowsUnsupportedConfigOverridesNestedImpl(ExportNetworkFlows item) {
      this.builder = new ExportNetworkFlowsBuilder(this, item);
    }
    ExportNetworkFlowsUnsupportedConfigOverridesNestedImpl() {
      this.builder = new ExportNetworkFlowsBuilder(this);
    }
    ExportNetworkFlowsBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endExportNetworkFlowsUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class ClusterCSIDriverSpecUnsupportedConfigOverridesNestedImpl<N> extends ClusterCSIDriverSpecFluentImpl<IngressControllerSpecFluent.ClusterCSIDriverSpecUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.ClusterCSIDriverSpecUnsupportedConfigOverridesNested<N>,Nested<N>{
    ClusterCSIDriverSpecUnsupportedConfigOverridesNestedImpl(ClusterCSIDriverSpec item) {
      this.builder = new ClusterCSIDriverSpecBuilder(this, item);
    }
    ClusterCSIDriverSpecUnsupportedConfigOverridesNestedImpl() {
      this.builder = new ClusterCSIDriverSpecBuilder(this);
    }
    ClusterCSIDriverSpecBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endClusterCSIDriverSpecUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class ServiceCatalogAPIServerSpecUnsupportedConfigOverridesNestedImpl<N> extends ServiceCatalogAPIServerSpecFluentImpl<IngressControllerSpecFluent.ServiceCatalogAPIServerSpecUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.ServiceCatalogAPIServerSpecUnsupportedConfigOverridesNested<N>,Nested<N>{
    ServiceCatalogAPIServerSpecUnsupportedConfigOverridesNestedImpl(ServiceCatalogAPIServerSpec item) {
      this.builder = new ServiceCatalogAPIServerSpecBuilder(this, item);
    }
    ServiceCatalogAPIServerSpecUnsupportedConfigOverridesNestedImpl() {
      this.builder = new ServiceCatalogAPIServerSpecBuilder(this);
    }
    ServiceCatalogAPIServerSpecBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endServiceCatalogAPIServerSpecUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class ImageContentSourcePolicySpecUnsupportedConfigOverridesNestedImpl<N> extends ImageContentSourcePolicySpecFluentImpl<IngressControllerSpecFluent.ImageContentSourcePolicySpecUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.ImageContentSourcePolicySpecUnsupportedConfigOverridesNested<N>,Nested<N>{
    ImageContentSourcePolicySpecUnsupportedConfigOverridesNestedImpl(ImageContentSourcePolicySpec item) {
      this.builder = new ImageContentSourcePolicySpecBuilder(this, item);
    }
    ImageContentSourcePolicySpecUnsupportedConfigOverridesNestedImpl() {
      this.builder = new ImageContentSourcePolicySpecBuilder(this);
    }
    ImageContentSourcePolicySpecBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endImageContentSourcePolicySpecUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class RepositoryDigestMirrorsUnsupportedConfigOverridesNestedImpl<N> extends RepositoryDigestMirrorsFluentImpl<IngressControllerSpecFluent.RepositoryDigestMirrorsUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.RepositoryDigestMirrorsUnsupportedConfigOverridesNested<N>,Nested<N>{
    RepositoryDigestMirrorsUnsupportedConfigOverridesNestedImpl(RepositoryDigestMirrors item) {
      this.builder = new RepositoryDigestMirrorsBuilder(this, item);
    }
    RepositoryDigestMirrorsUnsupportedConfigOverridesNestedImpl() {
      this.builder = new RepositoryDigestMirrorsBuilder(this);
    }
    RepositoryDigestMirrorsBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endRepositoryDigestMirrorsUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class ConsoleCustomizationUnsupportedConfigOverridesNestedImpl<N> extends ConsoleCustomizationFluentImpl<IngressControllerSpecFluent.ConsoleCustomizationUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.ConsoleCustomizationUnsupportedConfigOverridesNested<N>,Nested<N>{
    ConsoleCustomizationUnsupportedConfigOverridesNestedImpl(ConsoleCustomization item) {
      this.builder = new ConsoleCustomizationBuilder(this, item);
    }
    ConsoleCustomizationUnsupportedConfigOverridesNestedImpl() {
      this.builder = new ConsoleCustomizationBuilder(this);
    }
    ConsoleCustomizationBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endConsoleCustomizationUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class CSISnapshotControllerSpecUnsupportedConfigOverridesNestedImpl<N> extends CSISnapshotControllerSpecFluentImpl<IngressControllerSpecFluent.CSISnapshotControllerSpecUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.CSISnapshotControllerSpecUnsupportedConfigOverridesNested<N>,Nested<N>{
    CSISnapshotControllerSpecUnsupportedConfigOverridesNestedImpl(CSISnapshotControllerSpec item) {
      this.builder = new CSISnapshotControllerSpecBuilder(this, item);
    }
    CSISnapshotControllerSpecUnsupportedConfigOverridesNestedImpl() {
      this.builder = new CSISnapshotControllerSpecBuilder(this);
    }
    CSISnapshotControllerSpecBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endCSISnapshotControllerSpecUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class UpstreamResolversUnsupportedConfigOverridesNestedImpl<N> extends UpstreamResolversFluentImpl<IngressControllerSpecFluent.UpstreamResolversUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.UpstreamResolversUnsupportedConfigOverridesNested<N>,Nested<N>{
    UpstreamResolversUnsupportedConfigOverridesNestedImpl(UpstreamResolvers item) {
      this.builder = new UpstreamResolversBuilder(this, item);
    }
    UpstreamResolversUnsupportedConfigOverridesNestedImpl() {
      this.builder = new UpstreamResolversBuilder(this);
    }
    UpstreamResolversBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endUpstreamResolversUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class DNSStatusUnsupportedConfigOverridesNestedImpl<N> extends DNSStatusFluentImpl<IngressControllerSpecFluent.DNSStatusUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.DNSStatusUnsupportedConfigOverridesNested<N>,Nested<N>{
    DNSStatusUnsupportedConfigOverridesNestedImpl(DNSStatus item) {
      this.builder = new DNSStatusBuilder(this, item);
    }
    DNSStatusUnsupportedConfigOverridesNestedImpl() {
      this.builder = new DNSStatusBuilder(this);
    }
    DNSStatusBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endDNSStatusUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class IngressControllerHTTPUniqueIdHeaderPolicyUnsupportedConfigOverridesNestedImpl<N> extends IngressControllerHTTPUniqueIdHeaderPolicyFluentImpl<IngressControllerSpecFluent.IngressControllerHTTPUniqueIdHeaderPolicyUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.IngressControllerHTTPUniqueIdHeaderPolicyUnsupportedConfigOverridesNested<N>,Nested<N>{
    IngressControllerHTTPUniqueIdHeaderPolicyUnsupportedConfigOverridesNestedImpl(IngressControllerHTTPUniqueIdHeaderPolicy item) {
      this.builder = new IngressControllerHTTPUniqueIdHeaderPolicyBuilder(this, item);
    }
    IngressControllerHTTPUniqueIdHeaderPolicyUnsupportedConfigOverridesNestedImpl() {
      this.builder = new IngressControllerHTTPUniqueIdHeaderPolicyBuilder(this);
    }
    IngressControllerHTTPUniqueIdHeaderPolicyBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endIngressControllerHTTPUniqueIdHeaderPolicyUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class GCPLoadBalancerParametersUnsupportedConfigOverridesNestedImpl<N> extends GCPLoadBalancerParametersFluentImpl<IngressControllerSpecFluent.GCPLoadBalancerParametersUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.GCPLoadBalancerParametersUnsupportedConfigOverridesNested<N>,Nested<N>{
    GCPLoadBalancerParametersUnsupportedConfigOverridesNestedImpl(GCPLoadBalancerParameters item) {
      this.builder = new GCPLoadBalancerParametersBuilder(this, item);
    }
    GCPLoadBalancerParametersUnsupportedConfigOverridesNestedImpl() {
      this.builder = new GCPLoadBalancerParametersBuilder(this);
    }
    GCPLoadBalancerParametersBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endGCPLoadBalancerParametersUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class ConfigStatusUnsupportedConfigOverridesNestedImpl<N> extends ConfigStatusFluentImpl<IngressControllerSpecFluent.ConfigStatusUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.ConfigStatusUnsupportedConfigOverridesNested<N>,Nested<N>{
    ConfigStatusUnsupportedConfigOverridesNestedImpl(ConfigStatus item) {
      this.builder = new ConfigStatusBuilder(this, item);
    }
    ConfigStatusUnsupportedConfigOverridesNestedImpl() {
      this.builder = new ConfigStatusBuilder(this);
    }
    ConfigStatusBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endConfigStatusUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class KubeAPIServerListUnsupportedConfigOverridesNestedImpl<N> extends KubeAPIServerListFluentImpl<IngressControllerSpecFluent.KubeAPIServerListUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.KubeAPIServerListUnsupportedConfigOverridesNested<N>,Nested<N>{
    KubeAPIServerListUnsupportedConfigOverridesNestedImpl(KubeAPIServerList item) {
      this.builder = new KubeAPIServerListBuilder(this, item);
    }
    KubeAPIServerListUnsupportedConfigOverridesNestedImpl() {
      this.builder = new KubeAPIServerListBuilder(this);
    }
    KubeAPIServerListBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endKubeAPIServerListUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class ServiceCAUnsupportedConfigOverridesNestedImpl<N> extends ServiceCAFluentImpl<IngressControllerSpecFluent.ServiceCAUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.ServiceCAUnsupportedConfigOverridesNested<N>,Nested<N>{
    ServiceCAUnsupportedConfigOverridesNestedImpl(ServiceCA item) {
      this.builder = new ServiceCABuilder(this, item);
    }
    ServiceCAUnsupportedConfigOverridesNestedImpl() {
      this.builder = new ServiceCABuilder(this);
    }
    ServiceCABuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endServiceCAUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class ServiceCatalogControllerManagerSpecUnsupportedConfigOverridesNestedImpl<N> extends ServiceCatalogControllerManagerSpecFluentImpl<IngressControllerSpecFluent.ServiceCatalogControllerManagerSpecUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.ServiceCatalogControllerManagerSpecUnsupportedConfigOverridesNested<N>,Nested<N>{
    ServiceCatalogControllerManagerSpecUnsupportedConfigOverridesNestedImpl(ServiceCatalogControllerManagerSpec item) {
      this.builder = new ServiceCatalogControllerManagerSpecBuilder(this, item);
    }
    ServiceCatalogControllerManagerSpecUnsupportedConfigOverridesNestedImpl() {
      this.builder = new ServiceCatalogControllerManagerSpecBuilder(this);
    }
    ServiceCatalogControllerManagerSpecBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endServiceCatalogControllerManagerSpecUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class ConfigUnsupportedConfigOverridesNestedImpl<N> extends ConfigFluentImpl<IngressControllerSpecFluent.ConfigUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.ConfigUnsupportedConfigOverridesNested<N>,Nested<N>{
    ConfigUnsupportedConfigOverridesNestedImpl(Config item) {
      this.builder = new ConfigBuilder(this, item);
    }
    ConfigUnsupportedConfigOverridesNestedImpl() {
      this.builder = new ConfigBuilder(this);
    }
    ConfigBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endConfigUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class IngressControllerListUnsupportedConfigOverridesNestedImpl<N> extends IngressControllerListFluentImpl<IngressControllerSpecFluent.IngressControllerListUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.IngressControllerListUnsupportedConfigOverridesNested<N>,Nested<N>{
    IngressControllerListUnsupportedConfigOverridesNestedImpl(IngressControllerList item) {
      this.builder = new IngressControllerListBuilder(this, item);
    }
    IngressControllerListUnsupportedConfigOverridesNestedImpl() {
      this.builder = new IngressControllerListBuilder(this);
    }
    IngressControllerListBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endIngressControllerListUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class DNSListUnsupportedConfigOverridesNestedImpl<N> extends DNSListFluentImpl<IngressControllerSpecFluent.DNSListUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.DNSListUnsupportedConfigOverridesNested<N>,Nested<N>{
    DNSListUnsupportedConfigOverridesNestedImpl(DNSList item) {
      this.builder = new DNSListBuilder(this, item);
    }
    DNSListUnsupportedConfigOverridesNestedImpl() {
      this.builder = new DNSListBuilder(this);
    }
    DNSListBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endDNSListUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class ObjectMetaUnsupportedConfigOverridesNestedImpl<N> extends ObjectMetaFluentImpl<IngressControllerSpecFluent.ObjectMetaUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.ObjectMetaUnsupportedConfigOverridesNested<N>,Nested<N>{
    ObjectMetaUnsupportedConfigOverridesNestedImpl(ObjectMeta item) {
      this.builder = new ObjectMetaBuilder(this, item);
    }
    ObjectMetaUnsupportedConfigOverridesNestedImpl() {
      this.builder = new ObjectMetaBuilder(this);
    }
    ObjectMetaBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endObjectMetaUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class ClusterCSIDriverListUnsupportedConfigOverridesNestedImpl<N> extends ClusterCSIDriverListFluentImpl<IngressControllerSpecFluent.ClusterCSIDriverListUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.ClusterCSIDriverListUnsupportedConfigOverridesNested<N>,Nested<N>{
    ClusterCSIDriverListUnsupportedConfigOverridesNestedImpl(ClusterCSIDriverList item) {
      this.builder = new ClusterCSIDriverListBuilder(this, item);
    }
    ClusterCSIDriverListUnsupportedConfigOverridesNestedImpl() {
      this.builder = new ClusterCSIDriverListBuilder(this);
    }
    ClusterCSIDriverListBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endClusterCSIDriverListUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class SimpleMacvlanConfigUnsupportedOverridesNestedImpl<N> extends SimpleMacvlanConfigFluentImpl<IngressControllerSpecFluent.SimpleMacvlanConfigUnsupportedOverridesNested<N>> implements IngressControllerSpecFluent.SimpleMacvlanConfigUnsupportedOverridesNested<N>,Nested<N>{
    SimpleMacvlanConfigUnsupportedOverridesNestedImpl(SimpleMacvlanConfig item) {
      this.builder = new SimpleMacvlanConfigBuilder(this, item);
    }
    SimpleMacvlanConfigUnsupportedOverridesNestedImpl() {
      this.builder = new SimpleMacvlanConfigBuilder(this);
    }
    SimpleMacvlanConfigBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endSimpleMacvlanConfigUnsupportedOverrides() {
      return and();
    }
    
  }
  class PersistentVolumeClaimUnsupportedConfigOverridesNestedImpl<N> extends PersistentVolumeClaimFluentImpl<IngressControllerSpecFluent.PersistentVolumeClaimUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.PersistentVolumeClaimUnsupportedConfigOverridesNested<N>,Nested<N>{
    PersistentVolumeClaimUnsupportedConfigOverridesNestedImpl(PersistentVolumeClaim item) {
      this.builder = new PersistentVolumeClaimBuilder(this, item);
    }
    PersistentVolumeClaimUnsupportedConfigOverridesNestedImpl() {
      this.builder = new PersistentVolumeClaimBuilder(this);
    }
    PersistentVolumeClaimBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endPersistentVolumeClaimUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class KubeAPIServerStatusUnsupportedConfigOverridesNestedImpl<N> extends KubeAPIServerStatusFluentImpl<IngressControllerSpecFluent.KubeAPIServerStatusUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.KubeAPIServerStatusUnsupportedConfigOverridesNested<N>,Nested<N>{
    KubeAPIServerStatusUnsupportedConfigOverridesNestedImpl(KubeAPIServerStatus item) {
      this.builder = new KubeAPIServerStatusBuilder(this, item);
    }
    KubeAPIServerStatusUnsupportedConfigOverridesNestedImpl() {
      this.builder = new KubeAPIServerStatusBuilder(this);
    }
    KubeAPIServerStatusBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endKubeAPIServerStatusUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class AWSClassicLoadBalancerParametersUnsupportedConfigOverridesNestedImpl<N> extends AWSClassicLoadBalancerParametersFluentImpl<IngressControllerSpecFluent.AWSClassicLoadBalancerParametersUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.AWSClassicLoadBalancerParametersUnsupportedConfigOverridesNested<N>,Nested<N>{
    AWSClassicLoadBalancerParametersUnsupportedConfigOverridesNestedImpl(AWSClassicLoadBalancerParameters item) {
      this.builder = new AWSClassicLoadBalancerParametersBuilder(this, item);
    }
    AWSClassicLoadBalancerParametersUnsupportedConfigOverridesNestedImpl() {
      this.builder = new AWSClassicLoadBalancerParametersBuilder(this);
    }
    AWSClassicLoadBalancerParametersBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endAWSClassicLoadBalancerParametersUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class KubeAPIServerUnsupportedConfigOverridesNestedImpl<N> extends KubeAPIServerFluentImpl<IngressControllerSpecFluent.KubeAPIServerUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.KubeAPIServerUnsupportedConfigOverridesNested<N>,Nested<N>{
    KubeAPIServerUnsupportedConfigOverridesNestedImpl(KubeAPIServer item) {
      this.builder = new KubeAPIServerBuilder(this, item);
    }
    KubeAPIServerUnsupportedConfigOverridesNestedImpl() {
      this.builder = new KubeAPIServerBuilder(this);
    }
    KubeAPIServerBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endKubeAPIServerUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class IngressControllerUnsupportedConfigOverridesNestedImpl<N> extends IngressControllerFluentImpl<IngressControllerSpecFluent.IngressControllerUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.IngressControllerUnsupportedConfigOverridesNested<N>,Nested<N>{
    IngressControllerUnsupportedConfigOverridesNestedImpl(IngressController item) {
      this.builder = new IngressControllerBuilder(this, item);
    }
    IngressControllerUnsupportedConfigOverridesNestedImpl() {
      this.builder = new IngressControllerBuilder(this);
    }
    IngressControllerBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endIngressControllerUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class ConsoleConfigRouteUnsupportedOverridesNestedImpl<N> extends ConsoleConfigRouteFluentImpl<IngressControllerSpecFluent.ConsoleConfigRouteUnsupportedOverridesNested<N>> implements IngressControllerSpecFluent.ConsoleConfigRouteUnsupportedOverridesNested<N>,Nested<N>{
    ConsoleConfigRouteUnsupportedOverridesNestedImpl(ConsoleConfigRoute item) {
      this.builder = new ConsoleConfigRouteBuilder(this, item);
    }
    ConsoleConfigRouteUnsupportedOverridesNestedImpl() {
      this.builder = new ConsoleConfigRouteBuilder(this);
    }
    ConsoleConfigRouteBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endConsoleConfigRouteUnsupportedOverrides() {
      return and();
    }
    
  }
  class CloudCredentialStatusUnsupportedConfigOverridesNestedImpl<N> extends CloudCredentialStatusFluentImpl<IngressControllerSpecFluent.CloudCredentialStatusUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.CloudCredentialStatusUnsupportedConfigOverridesNested<N>,Nested<N>{
    CloudCredentialStatusUnsupportedConfigOverridesNestedImpl(CloudCredentialStatus item) {
      this.builder = new CloudCredentialStatusBuilder(this, item);
    }
    CloudCredentialStatusUnsupportedConfigOverridesNestedImpl() {
      this.builder = new CloudCredentialStatusBuilder(this);
    }
    CloudCredentialStatusBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endCloudCredentialStatusUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class KubeStorageVersionMigratorUnsupportedConfigOverridesNestedImpl<N> extends KubeStorageVersionMigratorFluentImpl<IngressControllerSpecFluent.KubeStorageVersionMigratorUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.KubeStorageVersionMigratorUnsupportedConfigOverridesNested<N>,Nested<N>{
    KubeStorageVersionMigratorUnsupportedConfigOverridesNestedImpl(KubeStorageVersionMigrator item) {
      this.builder = new KubeStorageVersionMigratorBuilder(this, item);
    }
    KubeStorageVersionMigratorUnsupportedConfigOverridesNestedImpl() {
      this.builder = new KubeStorageVersionMigratorBuilder(this);
    }
    KubeStorageVersionMigratorBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endKubeStorageVersionMigratorUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class GenericKubernetesResourceUnsupportedConfigOverridesNestedImpl<N> extends GenericKubernetesResourceFluentImpl<IngressControllerSpecFluent.GenericKubernetesResourceUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.GenericKubernetesResourceUnsupportedConfigOverridesNested<N>,Nested<N>{
    GenericKubernetesResourceUnsupportedConfigOverridesNestedImpl(GenericKubernetesResource item) {
      this.builder = new GenericKubernetesResourceBuilder(this, item);
    }
    GenericKubernetesResourceUnsupportedConfigOverridesNestedImpl() {
      this.builder = new GenericKubernetesResourceBuilder(this);
    }
    GenericKubernetesResourceBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endGenericKubernetesResourceUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class IngressControllerStatusUnsupportedConfigOverridesNestedImpl<N> extends IngressControllerStatusFluentImpl<IngressControllerSpecFluent.IngressControllerStatusUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.IngressControllerStatusUnsupportedConfigOverridesNested<N>,Nested<N>{
    IngressControllerStatusUnsupportedConfigOverridesNestedImpl(IngressControllerStatus item) {
      this.builder = new IngressControllerStatusBuilder(this, item);
    }
    IngressControllerStatusUnsupportedConfigOverridesNestedImpl() {
      this.builder = new IngressControllerStatusBuilder(this);
    }
    IngressControllerStatusBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endIngressControllerStatusUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class ServiceCatalogControllerManagerStatusUnsupportedConfigOverridesNestedImpl<N> extends ServiceCatalogControllerManagerStatusFluentImpl<IngressControllerSpecFluent.ServiceCatalogControllerManagerStatusUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.ServiceCatalogControllerManagerStatusUnsupportedConfigOverridesNested<N>,Nested<N>{
    ServiceCatalogControllerManagerStatusUnsupportedConfigOverridesNestedImpl(ServiceCatalogControllerManagerStatus item) {
      this.builder = new ServiceCatalogControllerManagerStatusBuilder(this, item);
    }
    ServiceCatalogControllerManagerStatusUnsupportedConfigOverridesNestedImpl() {
      this.builder = new ServiceCatalogControllerManagerStatusBuilder(this);
    }
    ServiceCatalogControllerManagerStatusBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endServiceCatalogControllerManagerStatusUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class HybridOverlayConfigUnsupportedOverridesNestedImpl<N> extends HybridOverlayConfigFluentImpl<IngressControllerSpecFluent.HybridOverlayConfigUnsupportedOverridesNested<N>> implements IngressControllerSpecFluent.HybridOverlayConfigUnsupportedOverridesNested<N>,Nested<N>{
    HybridOverlayConfigUnsupportedOverridesNestedImpl(HybridOverlayConfig item) {
      this.builder = new HybridOverlayConfigBuilder(this, item);
    }
    HybridOverlayConfigUnsupportedOverridesNestedImpl() {
      this.builder = new HybridOverlayConfigBuilder(this);
    }
    HybridOverlayConfigBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endHybridOverlayConfigUnsupportedOverrides() {
      return and();
    }
    
  }
  class AWSLoadBalancerParametersUnsupportedConfigOverridesNestedImpl<N> extends AWSLoadBalancerParametersFluentImpl<IngressControllerSpecFluent.AWSLoadBalancerParametersUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.AWSLoadBalancerParametersUnsupportedConfigOverridesNested<N>,Nested<N>{
    AWSLoadBalancerParametersUnsupportedConfigOverridesNestedImpl(AWSLoadBalancerParameters item) {
      this.builder = new AWSLoadBalancerParametersBuilder(this, item);
    }
    AWSLoadBalancerParametersUnsupportedConfigOverridesNestedImpl() {
      this.builder = new AWSLoadBalancerParametersBuilder(this);
    }
    AWSLoadBalancerParametersBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endAWSLoadBalancerParametersUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class ImagePrunerListUnsupportedConfigOverridesNestedImpl<N> extends ImagePrunerListFluentImpl<IngressControllerSpecFluent.ImagePrunerListUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.ImagePrunerListUnsupportedConfigOverridesNested<N>,Nested<N>{
    ImagePrunerListUnsupportedConfigOverridesNestedImpl(ImagePrunerList item) {
      this.builder = new ImagePrunerListBuilder(this, item);
    }
    ImagePrunerListUnsupportedConfigOverridesNestedImpl() {
      this.builder = new ImagePrunerListBuilder(this);
    }
    ImagePrunerListBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endImagePrunerListUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class CSISnapshotControllerListUnsupportedConfigOverridesNestedImpl<N> extends CSISnapshotControllerListFluentImpl<IngressControllerSpecFluent.CSISnapshotControllerListUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.CSISnapshotControllerListUnsupportedConfigOverridesNested<N>,Nested<N>{
    CSISnapshotControllerListUnsupportedConfigOverridesNestedImpl(CSISnapshotControllerList item) {
      this.builder = new CSISnapshotControllerListBuilder(this, item);
    }
    CSISnapshotControllerListUnsupportedConfigOverridesNestedImpl() {
      this.builder = new CSISnapshotControllerListBuilder(this);
    }
    CSISnapshotControllerListBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endCSISnapshotControllerListUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class LocalObjectReferenceUnsupportedConfigOverridesNestedImpl<N> extends LocalObjectReferenceFluentImpl<IngressControllerSpecFluent.LocalObjectReferenceUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.LocalObjectReferenceUnsupportedConfigOverridesNested<N>,Nested<N>{
    LocalObjectReferenceUnsupportedConfigOverridesNestedImpl(LocalObjectReference item) {
      this.builder = new LocalObjectReferenceBuilder(this, item);
    }
    LocalObjectReferenceUnsupportedConfigOverridesNestedImpl() {
      this.builder = new LocalObjectReferenceBuilder(this);
    }
    LocalObjectReferenceBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endLocalObjectReferenceUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class ConsoleUnsupportedConfigOverridesNestedImpl<N> extends ConsoleFluentImpl<IngressControllerSpecFluent.ConsoleUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.ConsoleUnsupportedConfigOverridesNested<N>,Nested<N>{
    ConsoleUnsupportedConfigOverridesNestedImpl(Console item) {
      this.builder = new ConsoleBuilder(this, item);
    }
    ConsoleUnsupportedConfigOverridesNestedImpl() {
      this.builder = new ConsoleBuilder(this);
    }
    ConsoleBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endConsoleUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class StaticIPAMRoutesUnsupportedConfigOverridesNestedImpl<N> extends StaticIPAMRoutesFluentImpl<IngressControllerSpecFluent.StaticIPAMRoutesUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.StaticIPAMRoutesUnsupportedConfigOverridesNested<N>,Nested<N>{
    StaticIPAMRoutesUnsupportedConfigOverridesNestedImpl(StaticIPAMRoutes item) {
      this.builder = new StaticIPAMRoutesBuilder(this, item);
    }
    StaticIPAMRoutesUnsupportedConfigOverridesNestedImpl() {
      this.builder = new StaticIPAMRoutesBuilder(this);
    }
    StaticIPAMRoutesBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endStaticIPAMRoutesUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class DNSZoneConditionUnsupportedConfigOverridesNestedImpl<N> extends DNSZoneConditionFluentImpl<IngressControllerSpecFluent.DNSZoneConditionUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.DNSZoneConditionUnsupportedConfigOverridesNested<N>,Nested<N>{
    DNSZoneConditionUnsupportedConfigOverridesNestedImpl(DNSZoneCondition item) {
      this.builder = new DNSZoneConditionBuilder(this, item);
    }
    DNSZoneConditionUnsupportedConfigOverridesNestedImpl() {
      this.builder = new DNSZoneConditionBuilder(this);
    }
    DNSZoneConditionBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endDNSZoneConditionUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class ContainerLoggingDestinationParametersUnsupportedConfigOverridesNestedImpl<N> extends ContainerLoggingDestinationParametersFluentImpl<IngressControllerSpecFluent.ContainerLoggingDestinationParametersUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.ContainerLoggingDestinationParametersUnsupportedConfigOverridesNested<N>,Nested<N>{
    ContainerLoggingDestinationParametersUnsupportedConfigOverridesNestedImpl(ContainerLoggingDestinationParameters item) {
      this.builder = new ContainerLoggingDestinationParametersBuilder(this, item);
    }
    ContainerLoggingDestinationParametersUnsupportedConfigOverridesNestedImpl() {
      this.builder = new ContainerLoggingDestinationParametersBuilder(this);
    }
    ContainerLoggingDestinationParametersBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endContainerLoggingDestinationParametersUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class KubeSchedulerListUnsupportedConfigOverridesNestedImpl<N> extends KubeSchedulerListFluentImpl<IngressControllerSpecFluent.KubeSchedulerListUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.KubeSchedulerListUnsupportedConfigOverridesNested<N>,Nested<N>{
    KubeSchedulerListUnsupportedConfigOverridesNestedImpl(KubeSchedulerList item) {
      this.builder = new KubeSchedulerListBuilder(this, item);
    }
    KubeSchedulerListUnsupportedConfigOverridesNestedImpl() {
      this.builder = new KubeSchedulerListBuilder(this);
    }
    KubeSchedulerListBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endKubeSchedulerListUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class KubeAPIServerSpecUnsupportedConfigOverridesNestedImpl<N> extends KubeAPIServerSpecFluentImpl<IngressControllerSpecFluent.KubeAPIServerSpecUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.KubeAPIServerSpecUnsupportedConfigOverridesNested<N>,Nested<N>{
    KubeAPIServerSpecUnsupportedConfigOverridesNestedImpl(KubeAPIServerSpec item) {
      this.builder = new KubeAPIServerSpecBuilder(this, item);
    }
    KubeAPIServerSpecUnsupportedConfigOverridesNestedImpl() {
      this.builder = new KubeAPIServerSpecBuilder(this);
    }
    KubeAPIServerSpecBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endKubeAPIServerSpecUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class ClusterCSIDriverUnsupportedConfigOverridesNestedImpl<N> extends ClusterCSIDriverFluentImpl<IngressControllerSpecFluent.ClusterCSIDriverUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.ClusterCSIDriverUnsupportedConfigOverridesNested<N>,Nested<N>{
    ClusterCSIDriverUnsupportedConfigOverridesNestedImpl(ClusterCSIDriver item) {
      this.builder = new ClusterCSIDriverBuilder(this, item);
    }
    ClusterCSIDriverUnsupportedConfigOverridesNestedImpl() {
      this.builder = new ClusterCSIDriverBuilder(this);
    }
    ClusterCSIDriverBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endClusterCSIDriverUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class QuickStartsUnsupportedConfigOverridesNestedImpl<N> extends QuickStartsFluentImpl<IngressControllerSpecFluent.QuickStartsUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.QuickStartsUnsupportedConfigOverridesNested<N>,Nested<N>{
    QuickStartsUnsupportedConfigOverridesNestedImpl(QuickStarts item) {
      this.builder = new QuickStartsBuilder(this, item);
    }
    QuickStartsUnsupportedConfigOverridesNestedImpl() {
      this.builder = new QuickStartsBuilder(this);
    }
    QuickStartsBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endQuickStartsUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class DNSZoneStatusUnsupportedConfigOverridesNestedImpl<N> extends DNSZoneStatusFluentImpl<IngressControllerSpecFluent.DNSZoneStatusUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.DNSZoneStatusUnsupportedConfigOverridesNested<N>,Nested<N>{
    DNSZoneStatusUnsupportedConfigOverridesNestedImpl(DNSZoneStatus item) {
      this.builder = new DNSZoneStatusBuilder(this, item);
    }
    DNSZoneStatusUnsupportedConfigOverridesNestedImpl() {
      this.builder = new DNSZoneStatusBuilder(this);
    }
    DNSZoneStatusBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endDNSZoneStatusUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class OpenShiftControllerManagerUnsupportedConfigOverridesNestedImpl<N> extends OpenShiftControllerManagerFluentImpl<IngressControllerSpecFluent.OpenShiftControllerManagerUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.OpenShiftControllerManagerUnsupportedConfigOverridesNested<N>,Nested<N>{
    OpenShiftControllerManagerUnsupportedConfigOverridesNestedImpl(OpenShiftControllerManager item) {
      this.builder = new OpenShiftControllerManagerBuilder(this, item);
    }
    OpenShiftControllerManagerUnsupportedConfigOverridesNestedImpl() {
      this.builder = new OpenShiftControllerManagerBuilder(this);
    }
    OpenShiftControllerManagerBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endOpenShiftControllerManagerUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class ConfigSpecUnsupportedConfigOverridesNestedImpl<N> extends ConfigSpecFluentImpl<IngressControllerSpecFluent.ConfigSpecUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.ConfigSpecUnsupportedConfigOverridesNested<N>,Nested<N>{
    ConfigSpecUnsupportedConfigOverridesNestedImpl(ConfigSpec item) {
      this.builder = new ConfigSpecBuilder(this, item);
    }
    ConfigSpecUnsupportedConfigOverridesNestedImpl() {
      this.builder = new ConfigSpecBuilder(this);
    }
    ConfigSpecBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endConfigSpecUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class OutageEntryUnsupportedConfigOverridesNestedImpl<N> extends OutageEntryFluentImpl<IngressControllerSpecFluent.OutageEntryUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.OutageEntryUnsupportedConfigOverridesNested<N>,Nested<N>{
    OutageEntryUnsupportedConfigOverridesNestedImpl(OutageEntry item) {
      this.builder = new OutageEntryBuilder(this, item);
    }
    OutageEntryUnsupportedConfigOverridesNestedImpl() {
      this.builder = new OutageEntryBuilder(this);
    }
    OutageEntryBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endOutageEntryUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class OpenShiftControllerManagerListUnsupportedConfigOverridesNestedImpl<N> extends OpenShiftControllerManagerListFluentImpl<IngressControllerSpecFluent.OpenShiftControllerManagerListUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.OpenShiftControllerManagerListUnsupportedConfigOverridesNested<N>,Nested<N>{
    OpenShiftControllerManagerListUnsupportedConfigOverridesNestedImpl(OpenShiftControllerManagerList item) {
      this.builder = new OpenShiftControllerManagerListBuilder(this, item);
    }
    OpenShiftControllerManagerListUnsupportedConfigOverridesNestedImpl() {
      this.builder = new OpenShiftControllerManagerListBuilder(this);
    }
    OpenShiftControllerManagerListBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endOpenShiftControllerManagerListUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class EtcdUnsupportedConfigOverridesNestedImpl<N> extends EtcdFluentImpl<IngressControllerSpecFluent.EtcdUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.EtcdUnsupportedConfigOverridesNested<N>,Nested<N>{
    EtcdUnsupportedConfigOverridesNestedImpl(Etcd item) {
      this.builder = new EtcdBuilder(this, item);
    }
    EtcdUnsupportedConfigOverridesNestedImpl() {
      this.builder = new EtcdBuilder(this);
    }
    EtcdBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endEtcdUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class EndpointPublishingStrategyUnsupportedConfigOverridesNestedImpl<N> extends EndpointPublishingStrategyFluentImpl<IngressControllerSpecFluent.EndpointPublishingStrategyUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.EndpointPublishingStrategyUnsupportedConfigOverridesNested<N>,Nested<N>{
    EndpointPublishingStrategyUnsupportedConfigOverridesNestedImpl(EndpointPublishingStrategy item) {
      this.builder = new EndpointPublishingStrategyBuilder(this, item);
    }
    EndpointPublishingStrategyUnsupportedConfigOverridesNestedImpl() {
      this.builder = new EndpointPublishingStrategyBuilder(this);
    }
    EndpointPublishingStrategyBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endEndpointPublishingStrategyUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class IPFIXConfigUnsupportedOverridesNestedImpl<N> extends IPFIXConfigFluentImpl<IngressControllerSpecFluent.IPFIXConfigUnsupportedOverridesNested<N>> implements IngressControllerSpecFluent.IPFIXConfigUnsupportedOverridesNested<N>,Nested<N>{
    IPFIXConfigUnsupportedOverridesNestedImpl(IPFIXConfig item) {
      this.builder = new IPFIXConfigBuilder(this, item);
    }
    IPFIXConfigUnsupportedOverridesNestedImpl() {
      this.builder = new IPFIXConfigBuilder(this);
    }
    IPFIXConfigBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endIPFIXConfigUnsupportedOverrides() {
      return and();
    }
    
  }
  class CloudCredentialUnsupportedConfigOverridesNestedImpl<N> extends CloudCredentialFluentImpl<IngressControllerSpecFluent.CloudCredentialUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.CloudCredentialUnsupportedConfigOverridesNested<N>,Nested<N>{
    CloudCredentialUnsupportedConfigOverridesNestedImpl(CloudCredential item) {
      this.builder = new CloudCredentialBuilder(this, item);
    }
    CloudCredentialUnsupportedConfigOverridesNestedImpl() {
      this.builder = new CloudCredentialBuilder(this);
    }
    CloudCredentialBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endCloudCredentialUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class KubeSchedulerUnsupportedConfigOverridesNestedImpl<N> extends KubeSchedulerFluentImpl<IngressControllerSpecFluent.KubeSchedulerUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.KubeSchedulerUnsupportedConfigOverridesNested<N>,Nested<N>{
    KubeSchedulerUnsupportedConfigOverridesNestedImpl(KubeScheduler item) {
      this.builder = new KubeSchedulerBuilder(this, item);
    }
    KubeSchedulerUnsupportedConfigOverridesNestedImpl() {
      this.builder = new KubeSchedulerBuilder(this);
    }
    KubeSchedulerBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endKubeSchedulerUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class ClusterCSIDriverStatusUnsupportedConfigOverridesNestedImpl<N> extends ClusterCSIDriverStatusFluentImpl<IngressControllerSpecFluent.ClusterCSIDriverStatusUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.ClusterCSIDriverStatusUnsupportedConfigOverridesNested<N>,Nested<N>{
    ClusterCSIDriverStatusUnsupportedConfigOverridesNestedImpl(ClusterCSIDriverStatus item) {
      this.builder = new ClusterCSIDriverStatusBuilder(this, item);
    }
    ClusterCSIDriverStatusUnsupportedConfigOverridesNestedImpl() {
      this.builder = new ClusterCSIDriverStatusBuilder(this);
    }
    ClusterCSIDriverStatusBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endClusterCSIDriverStatusUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class NetworkStatusUnsupportedConfigOverridesNestedImpl<N> extends NetworkStatusFluentImpl<IngressControllerSpecFluent.NetworkStatusUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.NetworkStatusUnsupportedConfigOverridesNested<N>,Nested<N>{
    NetworkStatusUnsupportedConfigOverridesNestedImpl(NetworkStatus item) {
      this.builder = new NetworkStatusBuilder(this, item);
    }
    NetworkStatusUnsupportedConfigOverridesNestedImpl() {
      this.builder = new NetworkStatusBuilder(this);
    }
    NetworkStatusBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endNetworkStatusUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class SFlowConfigUnsupportedOverridesNestedImpl<N> extends SFlowConfigFluentImpl<IngressControllerSpecFluent.SFlowConfigUnsupportedOverridesNested<N>> implements IngressControllerSpecFluent.SFlowConfigUnsupportedOverridesNested<N>,Nested<N>{
    SFlowConfigUnsupportedOverridesNestedImpl(SFlowConfig item) {
      this.builder = new SFlowConfigBuilder(this, item);
    }
    SFlowConfigUnsupportedOverridesNestedImpl() {
      this.builder = new SFlowConfigBuilder(this);
    }
    SFlowConfigBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endSFlowConfigUnsupportedOverrides() {
      return and();
    }
    
  }
  class ForwardPluginUnsupportedConfigOverridesNestedImpl<N> extends ForwardPluginFluentImpl<IngressControllerSpecFluent.ForwardPluginUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.ForwardPluginUnsupportedConfigOverridesNested<N>,Nested<N>{
    ForwardPluginUnsupportedConfigOverridesNestedImpl(ForwardPlugin item) {
      this.builder = new ForwardPluginBuilder(this, item);
    }
    ForwardPluginUnsupportedConfigOverridesNestedImpl() {
      this.builder = new ForwardPluginBuilder(this);
    }
    ForwardPluginBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endForwardPluginUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class LogEntryUnsupportedConfigOverridesNestedImpl<N> extends LogEntryFluentImpl<IngressControllerSpecFluent.LogEntryUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.LogEntryUnsupportedConfigOverridesNested<N>,Nested<N>{
    LogEntryUnsupportedConfigOverridesNestedImpl(LogEntry item) {
      this.builder = new LogEntryBuilder(this, item);
    }
    LogEntryUnsupportedConfigOverridesNestedImpl() {
      this.builder = new LogEntryBuilder(this);
    }
    LogEntryBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endLogEntryUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class NodeStatusUnsupportedConfigOverridesNestedImpl<N> extends NodeStatusFluentImpl<IngressControllerSpecFluent.NodeStatusUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.NodeStatusUnsupportedConfigOverridesNested<N>,Nested<N>{
    NodeStatusUnsupportedConfigOverridesNestedImpl(NodeStatus item) {
      this.builder = new NodeStatusBuilder(this, item);
    }
    NodeStatusUnsupportedConfigOverridesNestedImpl() {
      this.builder = new NodeStatusBuilder(this);
    }
    NodeStatusBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endNodeStatusUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class PodNetworkConnectivityCheckConditionUnsupportedConfigOverridesNestedImpl<N> extends PodNetworkConnectivityCheckConditionFluentImpl<IngressControllerSpecFluent.PodNetworkConnectivityCheckConditionUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.PodNetworkConnectivityCheckConditionUnsupportedConfigOverridesNested<N>,Nested<N>{
    PodNetworkConnectivityCheckConditionUnsupportedConfigOverridesNestedImpl(PodNetworkConnectivityCheckCondition item) {
      this.builder = new PodNetworkConnectivityCheckConditionBuilder(this, item);
    }
    PodNetworkConnectivityCheckConditionUnsupportedConfigOverridesNestedImpl() {
      this.builder = new PodNetworkConnectivityCheckConditionBuilder(this);
    }
    PodNetworkConnectivityCheckConditionBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endPodNetworkConnectivityCheckConditionUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class AdditionalNetworkDefinitionUnsupportedConfigOverridesNestedImpl<N> extends AdditionalNetworkDefinitionFluentImpl<IngressControllerSpecFluent.AdditionalNetworkDefinitionUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.AdditionalNetworkDefinitionUnsupportedConfigOverridesNested<N>,Nested<N>{
    AdditionalNetworkDefinitionUnsupportedConfigOverridesNestedImpl(AdditionalNetworkDefinition item) {
      this.builder = new AdditionalNetworkDefinitionBuilder(this, item);
    }
    AdditionalNetworkDefinitionUnsupportedConfigOverridesNestedImpl() {
      this.builder = new AdditionalNetworkDefinitionBuilder(this);
    }
    AdditionalNetworkDefinitionBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endAdditionalNetworkDefinitionUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class RouteAdmissionPolicyUnsupportedConfigOverridesNestedImpl<N> extends RouteAdmissionPolicyFluentImpl<IngressControllerSpecFluent.RouteAdmissionPolicyUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.RouteAdmissionPolicyUnsupportedConfigOverridesNested<N>,Nested<N>{
    RouteAdmissionPolicyUnsupportedConfigOverridesNestedImpl(RouteAdmissionPolicy item) {
      this.builder = new RouteAdmissionPolicyBuilder(this, item);
    }
    RouteAdmissionPolicyUnsupportedConfigOverridesNestedImpl() {
      this.builder = new RouteAdmissionPolicyBuilder(this);
    }
    RouteAdmissionPolicyBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endRouteAdmissionPolicyUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class GenerationStatusUnsupportedConfigOverridesNestedImpl<N> extends GenerationStatusFluentImpl<IngressControllerSpecFluent.GenerationStatusUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.GenerationStatusUnsupportedConfigOverridesNested<N>,Nested<N>{
    GenerationStatusUnsupportedConfigOverridesNestedImpl(GenerationStatus item) {
      this.builder = new GenerationStatusBuilder(this, item);
    }
    GenerationStatusUnsupportedConfigOverridesNestedImpl() {
      this.builder = new GenerationStatusBuilder(this);
    }
    GenerationStatusBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endGenerationStatusUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class AuthenticationStatusUnsupportedConfigOverridesNestedImpl<N> extends AuthenticationStatusFluentImpl<IngressControllerSpecFluent.AuthenticationStatusUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.AuthenticationStatusUnsupportedConfigOverridesNested<N>,Nested<N>{
    AuthenticationStatusUnsupportedConfigOverridesNestedImpl(AuthenticationStatus item) {
      this.builder = new AuthenticationStatusBuilder(this, item);
    }
    AuthenticationStatusUnsupportedConfigOverridesNestedImpl() {
      this.builder = new AuthenticationStatusBuilder(this);
    }
    AuthenticationStatusBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endAuthenticationStatusUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class IngressControllerCaptureHTTPHeadersUnsupportedConfigOverridesNestedImpl<N> extends IngressControllerCaptureHTTPHeadersFluentImpl<IngressControllerSpecFluent.IngressControllerCaptureHTTPHeadersUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.IngressControllerCaptureHTTPHeadersUnsupportedConfigOverridesNested<N>,Nested<N>{
    IngressControllerCaptureHTTPHeadersUnsupportedConfigOverridesNestedImpl(IngressControllerCaptureHTTPHeaders item) {
      this.builder = new IngressControllerCaptureHTTPHeadersBuilder(this, item);
    }
    IngressControllerCaptureHTTPHeadersUnsupportedConfigOverridesNestedImpl() {
      this.builder = new IngressControllerCaptureHTTPHeadersBuilder(this);
    }
    IngressControllerCaptureHTTPHeadersBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endIngressControllerCaptureHTTPHeadersUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class EtcdListUnsupportedConfigOverridesNestedImpl<N> extends EtcdListFluentImpl<IngressControllerSpecFluent.EtcdListUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.EtcdListUnsupportedConfigOverridesNested<N>,Nested<N>{
    EtcdListUnsupportedConfigOverridesNestedImpl(EtcdList item) {
      this.builder = new EtcdListBuilder(this, item);
    }
    EtcdListUnsupportedConfigOverridesNestedImpl() {
      this.builder = new EtcdListBuilder(this);
    }
    EtcdListBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endEtcdListUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class NodePortStrategyUnsupportedConfigOverridesNestedImpl<N> extends NodePortStrategyFluentImpl<IngressControllerSpecFluent.NodePortStrategyUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.NodePortStrategyUnsupportedConfigOverridesNested<N>,Nested<N>{
    NodePortStrategyUnsupportedConfigOverridesNestedImpl(NodePortStrategy item) {
      this.builder = new NodePortStrategyBuilder(this, item);
    }
    NodePortStrategyUnsupportedConfigOverridesNestedImpl() {
      this.builder = new NodePortStrategyBuilder(this);
    }
    NodePortStrategyBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endNodePortStrategyUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class DefaultNetworkDefinitionUnsupportedConfigOverridesNestedImpl<N> extends DefaultNetworkDefinitionFluentImpl<IngressControllerSpecFluent.DefaultNetworkDefinitionUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.DefaultNetworkDefinitionUnsupportedConfigOverridesNested<N>,Nested<N>{
    DefaultNetworkDefinitionUnsupportedConfigOverridesNestedImpl(DefaultNetworkDefinition item) {
      this.builder = new DefaultNetworkDefinitionBuilder(this, item);
    }
    DefaultNetworkDefinitionUnsupportedConfigOverridesNestedImpl() {
      this.builder = new DefaultNetworkDefinitionBuilder(this);
    }
    DefaultNetworkDefinitionBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endDefaultNetworkDefinitionUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class NetworkUnsupportedConfigOverridesNestedImpl<N> extends NetworkFluentImpl<IngressControllerSpecFluent.NetworkUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.NetworkUnsupportedConfigOverridesNested<N>,Nested<N>{
    NetworkUnsupportedConfigOverridesNestedImpl(Network item) {
      this.builder = new NetworkBuilder(this, item);
    }
    NetworkUnsupportedConfigOverridesNestedImpl() {
      this.builder = new NetworkBuilder(this);
    }
    NetworkBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endNetworkUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class ClientTLSUnsupportedConfigOverridesNestedImpl<N> extends ClientTLSFluentImpl<IngressControllerSpecFluent.ClientTLSUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.ClientTLSUnsupportedConfigOverridesNested<N>,Nested<N>{
    ClientTLSUnsupportedConfigOverridesNestedImpl(ClientTLS item) {
      this.builder = new ClientTLSBuilder(this, item);
    }
    ClientTLSUnsupportedConfigOverridesNestedImpl() {
      this.builder = new ClientTLSBuilder(this);
    }
    ClientTLSBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endClientTLSUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class OpenShiftAPIServerSpecUnsupportedConfigOverridesNestedImpl<N> extends OpenShiftAPIServerSpecFluentImpl<IngressControllerSpecFluent.OpenShiftAPIServerSpecUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.OpenShiftAPIServerSpecUnsupportedConfigOverridesNested<N>,Nested<N>{
    OpenShiftAPIServerSpecUnsupportedConfigOverridesNestedImpl(OpenShiftAPIServerSpec item) {
      this.builder = new OpenShiftAPIServerSpecBuilder(this, item);
    }
    OpenShiftAPIServerSpecUnsupportedConfigOverridesNestedImpl() {
      this.builder = new OpenShiftAPIServerSpecBuilder(this);
    }
    OpenShiftAPIServerSpecBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endOpenShiftAPIServerSpecUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class ImagePrunerStatusUnsupportedConfigOverridesNestedImpl<N> extends ImagePrunerStatusFluentImpl<IngressControllerSpecFluent.ImagePrunerStatusUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.ImagePrunerStatusUnsupportedConfigOverridesNested<N>,Nested<N>{
    ImagePrunerStatusUnsupportedConfigOverridesNestedImpl(ImagePrunerStatus item) {
      this.builder = new ImagePrunerStatusBuilder(this, item);
    }
    ImagePrunerStatusUnsupportedConfigOverridesNestedImpl() {
      this.builder = new ImagePrunerStatusBuilder(this);
    }
    ImagePrunerStatusBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endImagePrunerStatusUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class KubeSchedulerStatusUnsupportedConfigOverridesNestedImpl<N> extends KubeSchedulerStatusFluentImpl<IngressControllerSpecFluent.KubeSchedulerStatusUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.KubeSchedulerStatusUnsupportedConfigOverridesNested<N>,Nested<N>{
    KubeSchedulerStatusUnsupportedConfigOverridesNestedImpl(KubeSchedulerStatus item) {
      this.builder = new KubeSchedulerStatusBuilder(this, item);
    }
    KubeSchedulerStatusUnsupportedConfigOverridesNestedImpl() {
      this.builder = new KubeSchedulerStatusBuilder(this);
    }
    KubeSchedulerStatusBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endKubeSchedulerStatusUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class SyslogLoggingDestinationParametersUnsupportedConfigOverridesNestedImpl<N> extends SyslogLoggingDestinationParametersFluentImpl<IngressControllerSpecFluent.SyslogLoggingDestinationParametersUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.SyslogLoggingDestinationParametersUnsupportedConfigOverridesNested<N>,Nested<N>{
    SyslogLoggingDestinationParametersUnsupportedConfigOverridesNestedImpl(SyslogLoggingDestinationParameters item) {
      this.builder = new SyslogLoggingDestinationParametersBuilder(this, item);
    }
    SyslogLoggingDestinationParametersUnsupportedConfigOverridesNestedImpl() {
      this.builder = new SyslogLoggingDestinationParametersBuilder(this);
    }
    SyslogLoggingDestinationParametersBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endSyslogLoggingDestinationParametersUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class UpstreamUnsupportedConfigOverridesNestedImpl<N> extends UpstreamFluentImpl<IngressControllerSpecFluent.UpstreamUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.UpstreamUnsupportedConfigOverridesNested<N>,Nested<N>{
    UpstreamUnsupportedConfigOverridesNestedImpl(Upstream item) {
      this.builder = new UpstreamBuilder(this, item);
    }
    UpstreamUnsupportedConfigOverridesNestedImpl() {
      this.builder = new UpstreamBuilder(this);
    }
    UpstreamBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endUpstreamUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class AWSNetworkLoadBalancerParametersUnsupportedConfigOverridesNestedImpl<N> extends AWSNetworkLoadBalancerParametersFluentImpl<IngressControllerSpecFluent.AWSNetworkLoadBalancerParametersUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.AWSNetworkLoadBalancerParametersUnsupportedConfigOverridesNested<N>,Nested<N>{
    AWSNetworkLoadBalancerParametersUnsupportedConfigOverridesNestedImpl(AWSNetworkLoadBalancerParameters item) {
      this.builder = new AWSNetworkLoadBalancerParametersBuilder(this, item);
    }
    AWSNetworkLoadBalancerParametersUnsupportedConfigOverridesNestedImpl() {
      this.builder = new AWSNetworkLoadBalancerParametersBuilder(this);
    }
    AWSNetworkLoadBalancerParametersBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endAWSNetworkLoadBalancerParametersUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class ServiceCAListUnsupportedConfigOverridesNestedImpl<N> extends ServiceCAListFluentImpl<IngressControllerSpecFluent.ServiceCAListUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.ServiceCAListUnsupportedConfigOverridesNested<N>,Nested<N>{
    ServiceCAListUnsupportedConfigOverridesNestedImpl(ServiceCAList item) {
      this.builder = new ServiceCAListBuilder(this, item);
    }
    ServiceCAListUnsupportedConfigOverridesNestedImpl() {
      this.builder = new ServiceCAListBuilder(this);
    }
    ServiceCAListBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endServiceCAListUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class ServiceCatalogAPIServerUnsupportedConfigOverridesNestedImpl<N> extends ServiceCatalogAPIServerFluentImpl<IngressControllerSpecFluent.ServiceCatalogAPIServerUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.ServiceCatalogAPIServerUnsupportedConfigOverridesNested<N>,Nested<N>{
    ServiceCatalogAPIServerUnsupportedConfigOverridesNestedImpl(ServiceCatalogAPIServer item) {
      this.builder = new ServiceCatalogAPIServerBuilder(this, item);
    }
    ServiceCatalogAPIServerUnsupportedConfigOverridesNestedImpl() {
      this.builder = new ServiceCatalogAPIServerBuilder(this);
    }
    ServiceCatalogAPIServerBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endServiceCatalogAPIServerUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class IngressControllerCaptureHTTPHeaderUnsupportedConfigOverridesNestedImpl<N> extends IngressControllerCaptureHTTPHeaderFluentImpl<IngressControllerSpecFluent.IngressControllerCaptureHTTPHeaderUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.IngressControllerCaptureHTTPHeaderUnsupportedConfigOverridesNested<N>,Nested<N>{
    IngressControllerCaptureHTTPHeaderUnsupportedConfigOverridesNestedImpl(IngressControllerCaptureHTTPHeader item) {
      this.builder = new IngressControllerCaptureHTTPHeaderBuilder(this, item);
    }
    IngressControllerCaptureHTTPHeaderUnsupportedConfigOverridesNestedImpl() {
      this.builder = new IngressControllerCaptureHTTPHeaderBuilder(this);
    }
    IngressControllerCaptureHTTPHeaderBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endIngressControllerCaptureHTTPHeaderUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class NetworkMigrationUnsupportedConfigOverridesNestedImpl<N> extends NetworkMigrationFluentImpl<IngressControllerSpecFluent.NetworkMigrationUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.NetworkMigrationUnsupportedConfigOverridesNested<N>,Nested<N>{
    NetworkMigrationUnsupportedConfigOverridesNestedImpl(NetworkMigration item) {
      this.builder = new NetworkMigrationBuilder(this, item);
    }
    NetworkMigrationUnsupportedConfigOverridesNestedImpl() {
      this.builder = new NetworkMigrationBuilder(this);
    }
    NetworkMigrationBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endNetworkMigrationUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class DNSRecordListUnsupportedConfigOverridesNestedImpl<N> extends DNSRecordListFluentImpl<IngressControllerSpecFluent.DNSRecordListUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.DNSRecordListUnsupportedConfigOverridesNested<N>,Nested<N>{
    DNSRecordListUnsupportedConfigOverridesNestedImpl(DNSRecordList item) {
      this.builder = new DNSRecordListBuilder(this, item);
    }
    DNSRecordListUnsupportedConfigOverridesNestedImpl() {
      this.builder = new DNSRecordListBuilder(this);
    }
    DNSRecordListBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endDNSRecordListUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class RawExtensionUnsupportedConfigOverridesNestedImpl<N> extends RawExtensionFluentImpl<IngressControllerSpecFluent.RawExtensionUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.RawExtensionUnsupportedConfigOverridesNested<N>,Nested<N>{
    RawExtensionUnsupportedConfigOverridesNestedImpl(RawExtension item) {
      this.builder = new RawExtensionBuilder(this, item);
    }
    RawExtensionUnsupportedConfigOverridesNestedImpl() {
      this.builder = new RawExtensionBuilder(this);
    }
    RawExtensionBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endRawExtensionUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class EtcdSpecUnsupportedConfigOverridesNestedImpl<N> extends EtcdSpecFluentImpl<IngressControllerSpecFluent.EtcdSpecUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.EtcdSpecUnsupportedConfigOverridesNested<N>,Nested<N>{
    EtcdSpecUnsupportedConfigOverridesNestedImpl(EtcdSpec item) {
      this.builder = new EtcdSpecBuilder(this, item);
    }
    EtcdSpecUnsupportedConfigOverridesNestedImpl() {
      this.builder = new EtcdSpecBuilder(this);
    }
    EtcdSpecBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endEtcdSpecUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class PodNetworkConnectivityCheckUnsupportedConfigOverridesNestedImpl<N> extends PodNetworkConnectivityCheckFluentImpl<IngressControllerSpecFluent.PodNetworkConnectivityCheckUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.PodNetworkConnectivityCheckUnsupportedConfigOverridesNested<N>,Nested<N>{
    PodNetworkConnectivityCheckUnsupportedConfigOverridesNestedImpl(PodNetworkConnectivityCheck item) {
      this.builder = new PodNetworkConnectivityCheckBuilder(this, item);
    }
    PodNetworkConnectivityCheckUnsupportedConfigOverridesNestedImpl() {
      this.builder = new PodNetworkConnectivityCheckBuilder(this);
    }
    PodNetworkConnectivityCheckBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endPodNetworkConnectivityCheckUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class OpenShiftAPIServerStatusUnsupportedConfigOverridesNestedImpl<N> extends OpenShiftAPIServerStatusFluentImpl<IngressControllerSpecFluent.OpenShiftAPIServerStatusUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.OpenShiftAPIServerStatusUnsupportedConfigOverridesNested<N>,Nested<N>{
    OpenShiftAPIServerStatusUnsupportedConfigOverridesNestedImpl(OpenShiftAPIServerStatus item) {
      this.builder = new OpenShiftAPIServerStatusBuilder(this, item);
    }
    OpenShiftAPIServerStatusUnsupportedConfigOverridesNestedImpl() {
      this.builder = new OpenShiftAPIServerStatusBuilder(this);
    }
    OpenShiftAPIServerStatusBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endOpenShiftAPIServerStatusUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class LoadBalancerStrategyUnsupportedConfigOverridesNestedImpl<N> extends LoadBalancerStrategyFluentImpl<IngressControllerSpecFluent.LoadBalancerStrategyUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.LoadBalancerStrategyUnsupportedConfigOverridesNested<N>,Nested<N>{
    LoadBalancerStrategyUnsupportedConfigOverridesNestedImpl(LoadBalancerStrategy item) {
      this.builder = new LoadBalancerStrategyBuilder(this, item);
    }
    LoadBalancerStrategyUnsupportedConfigOverridesNestedImpl() {
      this.builder = new LoadBalancerStrategyBuilder(this);
    }
    LoadBalancerStrategyBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endLoadBalancerStrategyUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class EtcdStatusUnsupportedConfigOverridesNestedImpl<N> extends EtcdStatusFluentImpl<IngressControllerSpecFluent.EtcdStatusUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.EtcdStatusUnsupportedConfigOverridesNested<N>,Nested<N>{
    EtcdStatusUnsupportedConfigOverridesNestedImpl(EtcdStatus item) {
      this.builder = new EtcdStatusBuilder(this, item);
    }
    EtcdStatusUnsupportedConfigOverridesNestedImpl() {
      this.builder = new EtcdStatusBuilder(this);
    }
    EtcdStatusBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endEtcdStatusUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class CloudCredentialListUnsupportedConfigOverridesNestedImpl<N> extends CloudCredentialListFluentImpl<IngressControllerSpecFluent.CloudCredentialListUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.CloudCredentialListUnsupportedConfigOverridesNested<N>,Nested<N>{
    CloudCredentialListUnsupportedConfigOverridesNestedImpl(CloudCredentialList item) {
      this.builder = new CloudCredentialListBuilder(this, item);
    }
    CloudCredentialListUnsupportedConfigOverridesNestedImpl() {
      this.builder = new CloudCredentialListBuilder(this);
    }
    CloudCredentialListBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endCloudCredentialListUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class ImagePrunerSpecUnsupportedConfigOverridesNestedImpl<N> extends ImagePrunerSpecFluentImpl<IngressControllerSpecFluent.ImagePrunerSpecUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.ImagePrunerSpecUnsupportedConfigOverridesNested<N>,Nested<N>{
    ImagePrunerSpecUnsupportedConfigOverridesNestedImpl(ImagePrunerSpec item) {
      this.builder = new ImagePrunerSpecBuilder(this, item);
    }
    ImagePrunerSpecUnsupportedConfigOverridesNestedImpl() {
      this.builder = new ImagePrunerSpecBuilder(this);
    }
    ImagePrunerSpecBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endImagePrunerSpecUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class StatuspageProviderUnsupportedConfigOverridesNestedImpl<N> extends StatuspageProviderFluentImpl<IngressControllerSpecFluent.StatuspageProviderUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.StatuspageProviderUnsupportedConfigOverridesNested<N>,Nested<N>{
    StatuspageProviderUnsupportedConfigOverridesNestedImpl(StatuspageProvider item) {
      this.builder = new StatuspageProviderBuilder(this, item);
    }
    StatuspageProviderUnsupportedConfigOverridesNestedImpl() {
      this.builder = new StatuspageProviderBuilder(this);
    }
    StatuspageProviderBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endStatuspageProviderUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class KubeStorageVersionMigratorStatusUnsupportedConfigOverridesNestedImpl<N> extends KubeStorageVersionMigratorStatusFluentImpl<IngressControllerSpecFluent.KubeStorageVersionMigratorStatusUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.KubeStorageVersionMigratorStatusUnsupportedConfigOverridesNested<N>,Nested<N>{
    KubeStorageVersionMigratorStatusUnsupportedConfigOverridesNestedImpl(KubeStorageVersionMigratorStatus item) {
      this.builder = new KubeStorageVersionMigratorStatusBuilder(this, item);
    }
    KubeStorageVersionMigratorStatusUnsupportedConfigOverridesNestedImpl() {
      this.builder = new KubeStorageVersionMigratorStatusBuilder(this);
    }
    KubeStorageVersionMigratorStatusBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endKubeStorageVersionMigratorStatusUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class ConfigListUnsupportedConfigOverridesNestedImpl<N> extends ConfigListFluentImpl<IngressControllerSpecFluent.ConfigListUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.ConfigListUnsupportedConfigOverridesNested<N>,Nested<N>{
    ConfigListUnsupportedConfigOverridesNestedImpl(ConfigList item) {
      this.builder = new ConfigListBuilder(this, item);
    }
    ConfigListUnsupportedConfigOverridesNestedImpl() {
      this.builder = new ConfigListBuilder(this);
    }
    ConfigListBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endConfigListUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class ConsoleProvidersUnsupportedConfigOverridesNestedImpl<N> extends ConsoleProvidersFluentImpl<IngressControllerSpecFluent.ConsoleProvidersUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.ConsoleProvidersUnsupportedConfigOverridesNested<N>,Nested<N>{
    ConsoleProvidersUnsupportedConfigOverridesNestedImpl(ConsoleProviders item) {
      this.builder = new ConsoleProvidersBuilder(this, item);
    }
    ConsoleProvidersUnsupportedConfigOverridesNestedImpl() {
      this.builder = new ConsoleProvidersBuilder(this);
    }
    ConsoleProvidersBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endConsoleProvidersUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class IngressControllerLoggingUnsupportedConfigOverridesNestedImpl<N> extends IngressControllerLoggingFluentImpl<IngressControllerSpecFluent.IngressControllerLoggingUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.IngressControllerLoggingUnsupportedConfigOverridesNested<N>,Nested<N>{
    IngressControllerLoggingUnsupportedConfigOverridesNestedImpl(IngressControllerLogging item) {
      this.builder = new IngressControllerLoggingBuilder(this, item);
    }
    IngressControllerLoggingUnsupportedConfigOverridesNestedImpl() {
      this.builder = new IngressControllerLoggingBuilder(this);
    }
    IngressControllerLoggingBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endIngressControllerLoggingUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class AuthenticationListUnsupportedConfigOverridesNestedImpl<N> extends AuthenticationListFluentImpl<IngressControllerSpecFluent.AuthenticationListUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.AuthenticationListUnsupportedConfigOverridesNested<N>,Nested<N>{
    AuthenticationListUnsupportedConfigOverridesNestedImpl(AuthenticationList item) {
      this.builder = new AuthenticationListBuilder(this, item);
    }
    AuthenticationListUnsupportedConfigOverridesNestedImpl() {
      this.builder = new AuthenticationListBuilder(this);
    }
    AuthenticationListBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endAuthenticationListUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class StorageStatusUnsupportedConfigOverridesNestedImpl<N> extends StorageStatusFluentImpl<IngressControllerSpecFluent.StorageStatusUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.StorageStatusUnsupportedConfigOverridesNested<N>,Nested<N>{
    StorageStatusUnsupportedConfigOverridesNestedImpl(StorageStatus item) {
      this.builder = new StorageStatusBuilder(this, item);
    }
    StorageStatusUnsupportedConfigOverridesNestedImpl() {
      this.builder = new StorageStatusBuilder(this);
    }
    StorageStatusBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endStorageStatusUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class KubeControllerManagerListUnsupportedConfigOverridesNestedImpl<N> extends KubeControllerManagerListFluentImpl<IngressControllerSpecFluent.KubeControllerManagerListUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.KubeControllerManagerListUnsupportedConfigOverridesNested<N>,Nested<N>{
    KubeControllerManagerListUnsupportedConfigOverridesNestedImpl(KubeControllerManagerList item) {
      this.builder = new KubeControllerManagerListBuilder(this, item);
    }
    KubeControllerManagerListUnsupportedConfigOverridesNestedImpl() {
      this.builder = new KubeControllerManagerListBuilder(this);
    }
    KubeControllerManagerListBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endKubeControllerManagerListUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class AuthenticationSpecUnsupportedConfigOverridesNestedImpl<N> extends AuthenticationSpecFluentImpl<IngressControllerSpecFluent.AuthenticationSpecUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.AuthenticationSpecUnsupportedConfigOverridesNested<N>,Nested<N>{
    AuthenticationSpecUnsupportedConfigOverridesNestedImpl(AuthenticationSpec item) {
      this.builder = new AuthenticationSpecBuilder(this, item);
    }
    AuthenticationSpecUnsupportedConfigOverridesNestedImpl() {
      this.builder = new AuthenticationSpecBuilder(this);
    }
    AuthenticationSpecBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endAuthenticationSpecUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class IPAMConfigUnsupportedOverridesNestedImpl<N> extends IPAMConfigFluentImpl<IngressControllerSpecFluent.IPAMConfigUnsupportedOverridesNested<N>> implements IngressControllerSpecFluent.IPAMConfigUnsupportedOverridesNested<N>,Nested<N>{
    IPAMConfigUnsupportedOverridesNestedImpl(IPAMConfig item) {
      this.builder = new IPAMConfigBuilder(this, item);
    }
    IPAMConfigUnsupportedOverridesNestedImpl() {
      this.builder = new IPAMConfigBuilder(this);
    }
    IPAMConfigBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endIPAMConfigUnsupportedOverrides() {
      return and();
    }
    
  }
  class ContainerUnsupportedConfigOverridesNestedImpl<N> extends ContainerFluentImpl<IngressControllerSpecFluent.ContainerUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.ContainerUnsupportedConfigOverridesNested<N>,Nested<N>{
    ContainerUnsupportedConfigOverridesNestedImpl(Container item) {
      this.builder = new ContainerBuilder(this, item);
    }
    ContainerUnsupportedConfigOverridesNestedImpl() {
      this.builder = new ContainerBuilder(this);
    }
    ContainerBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endContainerUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class CSISnapshotControllerUnsupportedConfigOverridesNestedImpl<N> extends CSISnapshotControllerFluentImpl<IngressControllerSpecFluent.CSISnapshotControllerUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.CSISnapshotControllerUnsupportedConfigOverridesNested<N>,Nested<N>{
    CSISnapshotControllerUnsupportedConfigOverridesNestedImpl(CSISnapshotController item) {
      this.builder = new CSISnapshotControllerBuilder(this, item);
    }
    CSISnapshotControllerUnsupportedConfigOverridesNestedImpl() {
      this.builder = new CSISnapshotControllerBuilder(this);
    }
    CSISnapshotControllerBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endCSISnapshotControllerUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class PodNetworkConnectivityCheckSpecUnsupportedConfigOverridesNestedImpl<N> extends PodNetworkConnectivityCheckSpecFluentImpl<IngressControllerSpecFluent.PodNetworkConnectivityCheckSpecUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.PodNetworkConnectivityCheckSpecUnsupportedConfigOverridesNested<N>,Nested<N>{
    PodNetworkConnectivityCheckSpecUnsupportedConfigOverridesNestedImpl(PodNetworkConnectivityCheckSpec item) {
      this.builder = new PodNetworkConnectivityCheckSpecBuilder(this, item);
    }
    PodNetworkConnectivityCheckSpecUnsupportedConfigOverridesNestedImpl() {
      this.builder = new PodNetworkConnectivityCheckSpecBuilder(this);
    }
    PodNetworkConnectivityCheckSpecBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endPodNetworkConnectivityCheckSpecUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class AccessLoggingUnsupportedConfigOverridesNestedImpl<N> extends AccessLoggingFluentImpl<IngressControllerSpecFluent.AccessLoggingUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.AccessLoggingUnsupportedConfigOverridesNested<N>,Nested<N>{
    AccessLoggingUnsupportedConfigOverridesNestedImpl(AccessLogging item) {
      this.builder = new AccessLoggingBuilder(this, item);
    }
    AccessLoggingUnsupportedConfigOverridesNestedImpl() {
      this.builder = new AccessLoggingBuilder(this);
    }
    AccessLoggingBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endAccessLoggingUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class HostNetworkStrategyUnsupportedConfigOverridesNestedImpl<N> extends HostNetworkStrategyFluentImpl<IngressControllerSpecFluent.HostNetworkStrategyUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.HostNetworkStrategyUnsupportedConfigOverridesNested<N>,Nested<N>{
    HostNetworkStrategyUnsupportedConfigOverridesNestedImpl(HostNetworkStrategy item) {
      this.builder = new HostNetworkStrategyBuilder(this, item);
    }
    HostNetworkStrategyUnsupportedConfigOverridesNestedImpl() {
      this.builder = new HostNetworkStrategyBuilder(this);
    }
    HostNetworkStrategyBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endHostNetworkStrategyUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class DNSRecordSpecUnsupportedConfigOverridesNestedImpl<N> extends DNSRecordSpecFluentImpl<IngressControllerSpecFluent.DNSRecordSpecUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.DNSRecordSpecUnsupportedConfigOverridesNested<N>,Nested<N>{
    DNSRecordSpecUnsupportedConfigOverridesNestedImpl(DNSRecordSpec item) {
      this.builder = new DNSRecordSpecBuilder(this, item);
    }
    DNSRecordSpecUnsupportedConfigOverridesNestedImpl() {
      this.builder = new DNSRecordSpecBuilder(this);
    }
    DNSRecordSpecBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endDNSRecordSpecUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class DeveloperConsoleCatalogCustomizationUnsupportedConfigOverridesNestedImpl<N> extends DeveloperConsoleCatalogCustomizationFluentImpl<IngressControllerSpecFluent.DeveloperConsoleCatalogCustomizationUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.DeveloperConsoleCatalogCustomizationUnsupportedConfigOverridesNested<N>,Nested<N>{
    DeveloperConsoleCatalogCustomizationUnsupportedConfigOverridesNestedImpl(DeveloperConsoleCatalogCustomization item) {
      this.builder = new DeveloperConsoleCatalogCustomizationBuilder(this, item);
    }
    DeveloperConsoleCatalogCustomizationUnsupportedConfigOverridesNestedImpl() {
      this.builder = new DeveloperConsoleCatalogCustomizationBuilder(this);
    }
    DeveloperConsoleCatalogCustomizationBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endDeveloperConsoleCatalogCustomizationUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class KubeSchedulerSpecUnsupportedConfigOverridesNestedImpl<N> extends KubeSchedulerSpecFluentImpl<IngressControllerSpecFluent.KubeSchedulerSpecUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.KubeSchedulerSpecUnsupportedConfigOverridesNested<N>,Nested<N>{
    KubeSchedulerSpecUnsupportedConfigOverridesNestedImpl(KubeSchedulerSpec item) {
      this.builder = new KubeSchedulerSpecBuilder(this, item);
    }
    KubeSchedulerSpecUnsupportedConfigOverridesNestedImpl() {
      this.builder = new KubeSchedulerSpecBuilder(this);
    }
    KubeSchedulerSpecBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endKubeSchedulerSpecUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class LoggingDestinationUnsupportedConfigOverridesNestedImpl<N> extends LoggingDestinationFluentImpl<IngressControllerSpecFluent.LoggingDestinationUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.LoggingDestinationUnsupportedConfigOverridesNested<N>,Nested<N>{
    LoggingDestinationUnsupportedConfigOverridesNestedImpl(LoggingDestination item) {
      this.builder = new LoggingDestinationBuilder(this, item);
    }
    LoggingDestinationUnsupportedConfigOverridesNestedImpl() {
      this.builder = new LoggingDestinationBuilder(this);
    }
    LoggingDestinationBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endLoggingDestinationUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class IngressControllerTuningOptionsUnsupportedConfigOverridesNestedImpl<N> extends IngressControllerTuningOptionsFluentImpl<IngressControllerSpecFluent.IngressControllerTuningOptionsUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.IngressControllerTuningOptionsUnsupportedConfigOverridesNested<N>,Nested<N>{
    IngressControllerTuningOptionsUnsupportedConfigOverridesNestedImpl(IngressControllerTuningOptions item) {
      this.builder = new IngressControllerTuningOptionsBuilder(this, item);
    }
    IngressControllerTuningOptionsUnsupportedConfigOverridesNestedImpl() {
      this.builder = new IngressControllerTuningOptionsBuilder(this);
    }
    IngressControllerTuningOptionsBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endIngressControllerTuningOptionsUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class StaticIPAMConfigUnsupportedOverridesNestedImpl<N> extends StaticIPAMConfigFluentImpl<IngressControllerSpecFluent.StaticIPAMConfigUnsupportedOverridesNested<N>> implements IngressControllerSpecFluent.StaticIPAMConfigUnsupportedOverridesNested<N>,Nested<N>{
    StaticIPAMConfigUnsupportedOverridesNestedImpl(StaticIPAMConfig item) {
      this.builder = new StaticIPAMConfigBuilder(this, item);
    }
    StaticIPAMConfigUnsupportedOverridesNestedImpl() {
      this.builder = new StaticIPAMConfigBuilder(this);
    }
    StaticIPAMConfigBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endStaticIPAMConfigUnsupportedOverrides() {
      return and();
    }
    
  }
  class ImageContentSourcePolicyListUnsupportedConfigOverridesNestedImpl<N> extends ImageContentSourcePolicyListFluentImpl<IngressControllerSpecFluent.ImageContentSourcePolicyListUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.ImageContentSourcePolicyListUnsupportedConfigOverridesNested<N>,Nested<N>{
    ImageContentSourcePolicyListUnsupportedConfigOverridesNestedImpl(ImageContentSourcePolicyList item) {
      this.builder = new ImageContentSourcePolicyListBuilder(this, item);
    }
    ImageContentSourcePolicyListUnsupportedConfigOverridesNestedImpl() {
      this.builder = new ImageContentSourcePolicyListBuilder(this);
    }
    ImageContentSourcePolicyListBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endImageContentSourcePolicyListUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class OpenShiftControllerManagerStatusUnsupportedConfigOverridesNestedImpl<N> extends OpenShiftControllerManagerStatusFluentImpl<IngressControllerSpecFluent.OpenShiftControllerManagerStatusUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.OpenShiftControllerManagerStatusUnsupportedConfigOverridesNested<N>,Nested<N>{
    OpenShiftControllerManagerStatusUnsupportedConfigOverridesNestedImpl(OpenShiftControllerManagerStatus item) {
      this.builder = new OpenShiftControllerManagerStatusBuilder(this, item);
    }
    OpenShiftControllerManagerStatusUnsupportedConfigOverridesNestedImpl() {
      this.builder = new OpenShiftControllerManagerStatusBuilder(this);
    }
    OpenShiftControllerManagerStatusBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endOpenShiftControllerManagerStatusUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class ServiceCatalogAPIServerStatusUnsupportedConfigOverridesNestedImpl<N> extends ServiceCatalogAPIServerStatusFluentImpl<IngressControllerSpecFluent.ServiceCatalogAPIServerStatusUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.ServiceCatalogAPIServerStatusUnsupportedConfigOverridesNested<N>,Nested<N>{
    ServiceCatalogAPIServerStatusUnsupportedConfigOverridesNestedImpl(ServiceCatalogAPIServerStatus item) {
      this.builder = new ServiceCatalogAPIServerStatusBuilder(this, item);
    }
    ServiceCatalogAPIServerStatusUnsupportedConfigOverridesNestedImpl() {
      this.builder = new ServiceCatalogAPIServerStatusBuilder(this);
    }
    ServiceCatalogAPIServerStatusBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endServiceCatalogAPIServerStatusUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class KubeControllerManagerSpecUnsupportedConfigOverridesNestedImpl<N> extends KubeControllerManagerSpecFluentImpl<IngressControllerSpecFluent.KubeControllerManagerSpecUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.KubeControllerManagerSpecUnsupportedConfigOverridesNested<N>,Nested<N>{
    KubeControllerManagerSpecUnsupportedConfigOverridesNestedImpl(KubeControllerManagerSpec item) {
      this.builder = new KubeControllerManagerSpecBuilder(this, item);
    }
    KubeControllerManagerSpecUnsupportedConfigOverridesNestedImpl() {
      this.builder = new KubeControllerManagerSpecBuilder(this);
    }
    KubeControllerManagerSpecBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endKubeControllerManagerSpecUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class StaticIPAMDNSUnsupportedConfigOverridesNestedImpl<N> extends StaticIPAMDNSFluentImpl<IngressControllerSpecFluent.StaticIPAMDNSUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.StaticIPAMDNSUnsupportedConfigOverridesNested<N>,Nested<N>{
    StaticIPAMDNSUnsupportedConfigOverridesNestedImpl(StaticIPAMDNS item) {
      this.builder = new StaticIPAMDNSBuilder(this, item);
    }
    StaticIPAMDNSUnsupportedConfigOverridesNestedImpl() {
      this.builder = new StaticIPAMDNSBuilder(this);
    }
    StaticIPAMDNSBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endStaticIPAMDNSUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class DNSNodePlacementUnsupportedConfigOverridesNestedImpl<N> extends DNSNodePlacementFluentImpl<IngressControllerSpecFluent.DNSNodePlacementUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.DNSNodePlacementUnsupportedConfigOverridesNested<N>,Nested<N>{
    DNSNodePlacementUnsupportedConfigOverridesNestedImpl(DNSNodePlacement item) {
      this.builder = new DNSNodePlacementBuilder(this, item);
    }
    DNSNodePlacementUnsupportedConfigOverridesNestedImpl() {
      this.builder = new DNSNodePlacementBuilder(this);
    }
    DNSNodePlacementBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endDNSNodePlacementUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class StorageSpecUnsupportedConfigOverridesNestedImpl<N> extends StorageSpecFluentImpl<IngressControllerSpecFluent.StorageSpecUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.StorageSpecUnsupportedConfigOverridesNested<N>,Nested<N>{
    StorageSpecUnsupportedConfigOverridesNestedImpl(StorageSpec item) {
      this.builder = new StorageSpecBuilder(this, item);
    }
    StorageSpecUnsupportedConfigOverridesNestedImpl() {
      this.builder = new StorageSpecBuilder(this);
    }
    StorageSpecBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endStorageSpecUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class NetworkListUnsupportedConfigOverridesNestedImpl<N> extends NetworkListFluentImpl<IngressControllerSpecFluent.NetworkListUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.NetworkListUnsupportedConfigOverridesNested<N>,Nested<N>{
    NetworkListUnsupportedConfigOverridesNestedImpl(NetworkList item) {
      this.builder = new NetworkListBuilder(this, item);
    }
    NetworkListUnsupportedConfigOverridesNestedImpl() {
      this.builder = new NetworkListBuilder(this);
    }
    NetworkListBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endNetworkListUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class NodePlacementUnsupportedConfigOverridesNestedImpl<N> extends NodePlacementFluentImpl<IngressControllerSpecFluent.NodePlacementUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.NodePlacementUnsupportedConfigOverridesNested<N>,Nested<N>{
    NodePlacementUnsupportedConfigOverridesNestedImpl(NodePlacement item) {
      this.builder = new NodePlacementBuilder(this, item);
    }
    NodePlacementUnsupportedConfigOverridesNestedImpl() {
      this.builder = new NodePlacementBuilder(this);
    }
    NodePlacementBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endNodePlacementUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class ProviderLoadBalancerParametersUnsupportedConfigOverridesNestedImpl<N> extends ProviderLoadBalancerParametersFluentImpl<IngressControllerSpecFluent.ProviderLoadBalancerParametersUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.ProviderLoadBalancerParametersUnsupportedConfigOverridesNested<N>,Nested<N>{
    ProviderLoadBalancerParametersUnsupportedConfigOverridesNestedImpl(ProviderLoadBalancerParameters item) {
      this.builder = new ProviderLoadBalancerParametersBuilder(this, item);
    }
    ProviderLoadBalancerParametersUnsupportedConfigOverridesNestedImpl() {
      this.builder = new ProviderLoadBalancerParametersBuilder(this);
    }
    ProviderLoadBalancerParametersBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endProviderLoadBalancerParametersUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class NetworkSpecUnsupportedConfigOverridesNestedImpl<N> extends NetworkSpecFluentImpl<IngressControllerSpecFluent.NetworkSpecUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.NetworkSpecUnsupportedConfigOverridesNested<N>,Nested<N>{
    NetworkSpecUnsupportedConfigOverridesNestedImpl(NetworkSpec item) {
      this.builder = new NetworkSpecBuilder(this, item);
    }
    NetworkSpecUnsupportedConfigOverridesNestedImpl() {
      this.builder = new NetworkSpecBuilder(this);
    }
    NetworkSpecBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endNetworkSpecUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class ServiceCASpecUnsupportedConfigOverridesNestedImpl<N> extends ServiceCASpecFluentImpl<IngressControllerSpecFluent.ServiceCASpecUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.ServiceCASpecUnsupportedConfigOverridesNested<N>,Nested<N>{
    ServiceCASpecUnsupportedConfigOverridesNestedImpl(ServiceCASpec item) {
      this.builder = new ServiceCASpecBuilder(this, item);
    }
    ServiceCASpecUnsupportedConfigOverridesNestedImpl() {
      this.builder = new ServiceCASpecBuilder(this);
    }
    ServiceCASpecBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endServiceCASpecUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class PrivateStrategyUnsupportedConfigOverridesNestedImpl<N> extends PrivateStrategyFluentImpl<IngressControllerSpecFluent.PrivateStrategyUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.PrivateStrategyUnsupportedConfigOverridesNested<N>,Nested<N>{
    PrivateStrategyUnsupportedConfigOverridesNestedImpl(PrivateStrategy item) {
      this.builder = new PrivateStrategyBuilder(this, item);
    }
    PrivateStrategyUnsupportedConfigOverridesNestedImpl() {
      this.builder = new PrivateStrategyBuilder(this);
    }
    PrivateStrategyBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endPrivateStrategyUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class ConsoleStatusUnsupportedConfigOverridesNestedImpl<N> extends ConsoleStatusFluentImpl<IngressControllerSpecFluent.ConsoleStatusUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.ConsoleStatusUnsupportedConfigOverridesNested<N>,Nested<N>{
    ConsoleStatusUnsupportedConfigOverridesNestedImpl(ConsoleStatus item) {
      this.builder = new ConsoleStatusBuilder(this, item);
    }
    ConsoleStatusUnsupportedConfigOverridesNestedImpl() {
      this.builder = new ConsoleStatusBuilder(this);
    }
    ConsoleStatusBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endConsoleStatusUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class PodNetworkConnectivityCheckListUnsupportedConfigOverridesNestedImpl<N> extends PodNetworkConnectivityCheckListFluentImpl<IngressControllerSpecFluent.PodNetworkConnectivityCheckListUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.PodNetworkConnectivityCheckListUnsupportedConfigOverridesNested<N>,Nested<N>{
    PodNetworkConnectivityCheckListUnsupportedConfigOverridesNestedImpl(PodNetworkConnectivityCheckList item) {
      this.builder = new PodNetworkConnectivityCheckListBuilder(this, item);
    }
    PodNetworkConnectivityCheckListUnsupportedConfigOverridesNestedImpl() {
      this.builder = new PodNetworkConnectivityCheckListBuilder(this);
    }
    PodNetworkConnectivityCheckListBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endPodNetworkConnectivityCheckListUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class ObjectReferenceUnsupportedConfigOverridesNestedImpl<N> extends ObjectReferenceFluentImpl<IngressControllerSpecFluent.ObjectReferenceUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.ObjectReferenceUnsupportedConfigOverridesNested<N>,Nested<N>{
    ObjectReferenceUnsupportedConfigOverridesNestedImpl(ObjectReference item) {
      this.builder = new ObjectReferenceBuilder(this, item);
    }
    ObjectReferenceUnsupportedConfigOverridesNestedImpl() {
      this.builder = new ObjectReferenceBuilder(this);
    }
    ObjectReferenceBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endObjectReferenceUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class OpenShiftAPIServerListUnsupportedConfigOverridesNestedImpl<N> extends OpenShiftAPIServerListFluentImpl<IngressControllerSpecFluent.OpenShiftAPIServerListUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.OpenShiftAPIServerListUnsupportedConfigOverridesNested<N>,Nested<N>{
    OpenShiftAPIServerListUnsupportedConfigOverridesNestedImpl(OpenShiftAPIServerList item) {
      this.builder = new OpenShiftAPIServerListBuilder(this, item);
    }
    OpenShiftAPIServerListUnsupportedConfigOverridesNestedImpl() {
      this.builder = new OpenShiftAPIServerListBuilder(this);
    }
    OpenShiftAPIServerListBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endOpenShiftAPIServerListUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class ServerUnsupportedConfigOverridesNestedImpl<N> extends ServerFluentImpl<IngressControllerSpecFluent.ServerUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.ServerUnsupportedConfigOverridesNested<N>,Nested<N>{
    ServerUnsupportedConfigOverridesNestedImpl(Server item) {
      this.builder = new ServerBuilder(this, item);
    }
    ServerUnsupportedConfigOverridesNestedImpl() {
      this.builder = new ServerBuilder(this);
    }
    ServerBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endServerUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class OAuthAPIServerStatusUnsupportedConfigOverridesNestedImpl<N> extends OAuthAPIServerStatusFluentImpl<IngressControllerSpecFluent.OAuthAPIServerStatusUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.OAuthAPIServerStatusUnsupportedConfigOverridesNested<N>,Nested<N>{
    OAuthAPIServerStatusUnsupportedConfigOverridesNestedImpl(OAuthAPIServerStatus item) {
      this.builder = new OAuthAPIServerStatusBuilder(this, item);
    }
    OAuthAPIServerStatusUnsupportedConfigOverridesNestedImpl() {
      this.builder = new OAuthAPIServerStatusBuilder(this);
    }
    OAuthAPIServerStatusBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endOAuthAPIServerStatusUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class CloudCredentialSpecUnsupportedConfigOverridesNestedImpl<N> extends CloudCredentialSpecFluentImpl<IngressControllerSpecFluent.CloudCredentialSpecUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.CloudCredentialSpecUnsupportedConfigOverridesNested<N>,Nested<N>{
    CloudCredentialSpecUnsupportedConfigOverridesNestedImpl(CloudCredentialSpec item) {
      this.builder = new CloudCredentialSpecBuilder(this, item);
    }
    CloudCredentialSpecUnsupportedConfigOverridesNestedImpl() {
      this.builder = new CloudCredentialSpecBuilder(this);
    }
    CloudCredentialSpecBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endCloudCredentialSpecUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class DNSRecordStatusUnsupportedConfigOverridesNestedImpl<N> extends DNSRecordStatusFluentImpl<IngressControllerSpecFluent.DNSRecordStatusUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.DNSRecordStatusUnsupportedConfigOverridesNested<N>,Nested<N>{
    DNSRecordStatusUnsupportedConfigOverridesNestedImpl(DNSRecordStatus item) {
      this.builder = new DNSRecordStatusBuilder(this, item);
    }
    DNSRecordStatusUnsupportedConfigOverridesNestedImpl() {
      this.builder = new DNSRecordStatusBuilder(this);
    }
    DNSRecordStatusBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endDNSRecordStatusUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class ServiceCatalogControllerManagerUnsupportedConfigOverridesNestedImpl<N> extends ServiceCatalogControllerManagerFluentImpl<IngressControllerSpecFluent.ServiceCatalogControllerManagerUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.ServiceCatalogControllerManagerUnsupportedConfigOverridesNested<N>,Nested<N>{
    ServiceCatalogControllerManagerUnsupportedConfigOverridesNestedImpl(ServiceCatalogControllerManager item) {
      this.builder = new ServiceCatalogControllerManagerBuilder(this, item);
    }
    ServiceCatalogControllerManagerUnsupportedConfigOverridesNestedImpl() {
      this.builder = new ServiceCatalogControllerManagerBuilder(this);
    }
    ServiceCatalogControllerManagerBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endServiceCatalogControllerManagerUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class ClusterNetworkEntryUnsupportedConfigOverridesNestedImpl<N> extends ClusterNetworkEntryFluentImpl<IngressControllerSpecFluent.ClusterNetworkEntryUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.ClusterNetworkEntryUnsupportedConfigOverridesNested<N>,Nested<N>{
    ClusterNetworkEntryUnsupportedConfigOverridesNestedImpl(ClusterNetworkEntry item) {
      this.builder = new ClusterNetworkEntryBuilder(this, item);
    }
    ClusterNetworkEntryUnsupportedConfigOverridesNestedImpl() {
      this.builder = new ClusterNetworkEntryBuilder(this);
    }
    ClusterNetworkEntryBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endClusterNetworkEntryUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class IngressControllerCaptureHTTPCookieUnsupportedConfigOverridesNestedImpl<N> extends IngressControllerCaptureHTTPCookieFluentImpl<IngressControllerSpecFluent.IngressControllerCaptureHTTPCookieUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.IngressControllerCaptureHTTPCookieUnsupportedConfigOverridesNested<N>,Nested<N>{
    IngressControllerCaptureHTTPCookieUnsupportedConfigOverridesNestedImpl(IngressControllerCaptureHTTPCookie item) {
      this.builder = new IngressControllerCaptureHTTPCookieBuilder(this, item);
    }
    IngressControllerCaptureHTTPCookieUnsupportedConfigOverridesNestedImpl() {
      this.builder = new IngressControllerCaptureHTTPCookieBuilder(this);
    }
    IngressControllerCaptureHTTPCookieBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endIngressControllerCaptureHTTPCookieUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class HTTPCompressionPolicyUnsupportedConfigOverridesNestedImpl<N> extends HTTPCompressionPolicyFluentImpl<IngressControllerSpecFluent.HTTPCompressionPolicyUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.HTTPCompressionPolicyUnsupportedConfigOverridesNested<N>,Nested<N>{
    HTTPCompressionPolicyUnsupportedConfigOverridesNestedImpl(HTTPCompressionPolicy item) {
      this.builder = new HTTPCompressionPolicyBuilder(this, item);
    }
    HTTPCompressionPolicyUnsupportedConfigOverridesNestedImpl() {
      this.builder = new HTTPCompressionPolicyBuilder(this);
    }
    HTTPCompressionPolicyBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endHTTPCompressionPolicyUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class ProjectAccessUnsupportedConfigOverridesNestedImpl<N> extends ProjectAccessFluentImpl<IngressControllerSpecFluent.ProjectAccessUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.ProjectAccessUnsupportedConfigOverridesNested<N>,Nested<N>{
    ProjectAccessUnsupportedConfigOverridesNestedImpl(ProjectAccess item) {
      this.builder = new ProjectAccessBuilder(this, item);
    }
    ProjectAccessUnsupportedConfigOverridesNestedImpl() {
      this.builder = new ProjectAccessBuilder(this);
    }
    ProjectAccessBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endProjectAccessUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class DNSUnsupportedConfigOverridesNestedImpl<N> extends DNSFluentImpl<IngressControllerSpecFluent.DNSUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.DNSUnsupportedConfigOverridesNested<N>,Nested<N>{
    DNSUnsupportedConfigOverridesNestedImpl(DNS item) {
      this.builder = new DNSBuilder(this, item);
    }
    DNSUnsupportedConfigOverridesNestedImpl() {
      this.builder = new DNSBuilder(this);
    }
    DNSBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endDNSUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class NetFlowConfigUnsupportedOverridesNestedImpl<N> extends NetFlowConfigFluentImpl<IngressControllerSpecFluent.NetFlowConfigUnsupportedOverridesNested<N>> implements IngressControllerSpecFluent.NetFlowConfigUnsupportedOverridesNested<N>,Nested<N>{
    NetFlowConfigUnsupportedOverridesNestedImpl(NetFlowConfig item) {
      this.builder = new NetFlowConfigBuilder(this, item);
    }
    NetFlowConfigUnsupportedOverridesNestedImpl() {
      this.builder = new NetFlowConfigBuilder(this);
    }
    NetFlowConfigBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endNetFlowConfigUnsupportedOverrides() {
      return and();
    }
    
  }
  class PolicyAuditConfigUnsupportedOverridesNestedImpl<N> extends PolicyAuditConfigFluentImpl<IngressControllerSpecFluent.PolicyAuditConfigUnsupportedOverridesNested<N>> implements IngressControllerSpecFluent.PolicyAuditConfigUnsupportedOverridesNested<N>,Nested<N>{
    PolicyAuditConfigUnsupportedOverridesNestedImpl(PolicyAuditConfig item) {
      this.builder = new PolicyAuditConfigBuilder(this, item);
    }
    PolicyAuditConfigUnsupportedOverridesNestedImpl() {
      this.builder = new PolicyAuditConfigBuilder(this);
    }
    PolicyAuditConfigBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endPolicyAuditConfigUnsupportedOverrides() {
      return and();
    }
    
  }
  class AddPageUnsupportedConfigOverridesNestedImpl<N> extends AddPageFluentImpl<IngressControllerSpecFluent.AddPageUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.AddPageUnsupportedConfigOverridesNested<N>,Nested<N>{
    AddPageUnsupportedConfigOverridesNestedImpl(AddPage item) {
      this.builder = new AddPageBuilder(this, item);
    }
    AddPageUnsupportedConfigOverridesNestedImpl() {
      this.builder = new AddPageBuilder(this);
    }
    AddPageBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endAddPageUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class StorageListUnsupportedConfigOverridesNestedImpl<N> extends StorageListFluentImpl<IngressControllerSpecFluent.StorageListUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.StorageListUnsupportedConfigOverridesNested<N>,Nested<N>{
    StorageListUnsupportedConfigOverridesNestedImpl(StorageList item) {
      this.builder = new StorageListBuilder(this, item);
    }
    StorageListUnsupportedConfigOverridesNestedImpl() {
      this.builder = new StorageListBuilder(this);
    }
    StorageListBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endStorageListUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class StaticIPAMAddressesUnsupportedConfigOverridesNestedImpl<N> extends StaticIPAMAddressesFluentImpl<IngressControllerSpecFluent.StaticIPAMAddressesUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.StaticIPAMAddressesUnsupportedConfigOverridesNested<N>,Nested<N>{
    StaticIPAMAddressesUnsupportedConfigOverridesNestedImpl(StaticIPAMAddresses item) {
      this.builder = new StaticIPAMAddressesBuilder(this, item);
    }
    StaticIPAMAddressesUnsupportedConfigOverridesNestedImpl() {
      this.builder = new StaticIPAMAddressesBuilder(this);
    }
    StaticIPAMAddressesBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endStaticIPAMAddressesUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class DNSRecordUnsupportedConfigOverridesNestedImpl<N> extends DNSRecordFluentImpl<IngressControllerSpecFluent.DNSRecordUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.DNSRecordUnsupportedConfigOverridesNested<N>,Nested<N>{
    DNSRecordUnsupportedConfigOverridesNestedImpl(DNSRecord item) {
      this.builder = new DNSRecordBuilder(this, item);
    }
    DNSRecordUnsupportedConfigOverridesNestedImpl() {
      this.builder = new DNSRecordBuilder(this);
    }
    DNSRecordBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endDNSRecordUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class OpenShiftAPIServerUnsupportedConfigOverridesNestedImpl<N> extends OpenShiftAPIServerFluentImpl<IngressControllerSpecFluent.OpenShiftAPIServerUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.OpenShiftAPIServerUnsupportedConfigOverridesNested<N>,Nested<N>{
    OpenShiftAPIServerUnsupportedConfigOverridesNestedImpl(OpenShiftAPIServer item) {
      this.builder = new OpenShiftAPIServerBuilder(this, item);
    }
    OpenShiftAPIServerUnsupportedConfigOverridesNestedImpl() {
      this.builder = new OpenShiftAPIServerBuilder(this);
    }
    OpenShiftAPIServerBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endOpenShiftAPIServerUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class AuthenticationUnsupportedConfigOverridesNestedImpl<N> extends AuthenticationFluentImpl<IngressControllerSpecFluent.AuthenticationUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.AuthenticationUnsupportedConfigOverridesNested<N>,Nested<N>{
    AuthenticationUnsupportedConfigOverridesNestedImpl(Authentication item) {
      this.builder = new AuthenticationBuilder(this, item);
    }
    AuthenticationUnsupportedConfigOverridesNestedImpl() {
      this.builder = new AuthenticationBuilder(this);
    }
    AuthenticationBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endAuthenticationUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class ConsoleSpecUnsupportedConfigOverridesNestedImpl<N> extends ConsoleSpecFluentImpl<IngressControllerSpecFluent.ConsoleSpecUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.ConsoleSpecUnsupportedConfigOverridesNested<N>,Nested<N>{
    ConsoleSpecUnsupportedConfigOverridesNestedImpl(ConsoleSpec item) {
      this.builder = new ConsoleSpecBuilder(this, item);
    }
    ConsoleSpecUnsupportedConfigOverridesNestedImpl() {
      this.builder = new ConsoleSpecBuilder(this);
    }
    ConsoleSpecBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endConsoleSpecUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class ServiceCAStatusUnsupportedConfigOverridesNestedImpl<N> extends ServiceCAStatusFluentImpl<IngressControllerSpecFluent.ServiceCAStatusUnsupportedConfigOverridesNested<N>> implements IngressControllerSpecFluent.ServiceCAStatusUnsupportedConfigOverridesNested<N>,Nested<N>{
    ServiceCAStatusUnsupportedConfigOverridesNestedImpl(ServiceCAStatus item) {
      this.builder = new ServiceCAStatusBuilder(this, item);
    }
    ServiceCAStatusUnsupportedConfigOverridesNestedImpl() {
      this.builder = new ServiceCAStatusBuilder(this);
    }
    ServiceCAStatusBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endServiceCAStatusUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  
}